!function(e,t){"use strict";var a="#define SHADER_NAME BloomVS\nvarying vec2 v_Texcoord0;vec4 remapPositionZ(vec4 position){\n#ifdef BLITSCREEN_INVERTY\nposition.y=-position.y;\n#endif\nreturn position;}void main(){gl_Position=vec4(a_PositionTexcoord.xy,0.0,1.0);v_Texcoord0=a_PositionTexcoord.zw;gl_Position=remapPositionZ(gl_Position);}";class o extends t.PostProcessEffect{static init(){t.Shader3D.addInclude("StdLib.glsl","#define HALF_MAX 65504.0\n#define FLT_EPSILON 1.192092896e-07\nmediump vec4 safeHDR(mediump vec4 c){return min(c,HALF_MAX);}float max3(float a,float b,float c){return max(max(a,b),c);}vec3 positivePow(vec3 base,vec3 power){return pow(max(abs(base),vec3(FLT_EPSILON,FLT_EPSILON,FLT_EPSILON)),power);}"),t.Shader3D.addInclude("Colors.glsl",'#include "StdLib.glsl";\n#define EPSILON 1.0e-4\nmediump vec4 quadraticThreshold(mediump vec4 color,mediump float threshold,mediump vec3 curve){mediump float br=max3(color.r,color.g,color.b);mediump float rq=clamp(br-curve.x,0.0,curve.y);rq=curve.z*rq*rq;color*=max(rq,br-threshold)/max(br,EPSILON);return color;}'),t.Shader3D.addInclude("Sampling.glsl","vec4 samplerTex(sampler2D tex,vec2 uv){vec4 mainSampler=texture2D(tex,uv);\n#ifdef Gamma_u_MainTex\nmainSampler=gammaToLinear(mainSampler);\n#endif\nreturn mainSampler;}mediump vec4 downsampleBox13Tap(sampler2D tex,vec2 uv,vec2 texelSize){mediump vec4 A=samplerTex(tex,uv+texelSize*vec2(-1.0,-1.0));mediump vec4 B=samplerTex(tex,uv+texelSize*vec2(0.0,-1.0));mediump vec4 C=samplerTex(tex,uv+texelSize*vec2(1.0,-1.0));mediump vec4 D=samplerTex(tex,uv+texelSize*vec2(-0.5,-0.5));mediump vec4 E=samplerTex(tex,uv+texelSize*vec2(0.5,-0.5));mediump vec4 F=samplerTex(tex,uv+texelSize*vec2(-1.0,0.0));mediump vec4 G=samplerTex(tex,uv);mediump vec4 H=samplerTex(tex,uv+texelSize*vec2(1.0,0.0));mediump vec4 I=samplerTex(tex,uv+texelSize*vec2(-0.5,0.5));mediump vec4 J=samplerTex(tex,uv+texelSize*vec2(0.5,0.5));mediump vec4 K=samplerTex(tex,uv+texelSize*vec2(-1.0,1.0));mediump vec4 L=samplerTex(tex,uv+texelSize*vec2(0.0,1.0));mediump vec4 M=samplerTex(tex,uv+texelSize*vec2(1.0,1.0));mediump vec2 scale=vec2(0.5,0.125);mediump vec2 div=(1.0/4.0)*scale;mediump vec4 o=(D+E+I+J)*div.x;o+=(A+B+G+F)*div.y;o+=(B+C+H+G)*div.y;o+=(F+G+L+K)*div.y;o+=(G+H+M+L)*div.y;return o;}mediump vec4 downsampleBox4Tap(sampler2D tex,vec2 uv,vec2 texelSize){vec4 d=texelSize.xyxy*vec4(-1.0,-1.0,1.0,1.0);mediump vec4 s=samplerTex(tex,uv+d.xy);s+=samplerTex(tex,uv+d.zy);s+=samplerTex(tex,uv+d.xw);s+=samplerTex(tex,uv+d.zw);return s*(1.0/4.0);}mediump vec4 upsampleTent(sampler2D tex,vec2 uv,vec2 texelSize,vec4 sampleScale){vec4 d=texelSize.xyxy*vec4(1.0,1.0,-1.0,0.0)*sampleScale;mediump vec4 s=samplerTex(tex,uv-d.xy);s+=samplerTex(tex,uv-d.wy)*2.0;s+=samplerTex(tex,uv-d.zy);s+=samplerTex(tex,uv+d.zw)*2.0;s+=samplerTex(tex,uv)*4.0;s+=samplerTex(tex,uv+d.xw)*2.0;s+=samplerTex(tex,uv+d.zy);s+=samplerTex(tex,uv+d.wy)*2.0;s+=samplerTex(tex,uv+d.xy);return s*(1.0/16.0);}mediump vec4 upsampleBox(sampler2D tex,vec2 uv,vec2 texelSize,vec4 sampleScale){vec4 d=texelSize.xyxy*vec4(-1.0,-1.0,1.0,1.0)*0.5*sampleScale;mediump vec4 s=samplerTex(tex,uv+d.xy);s+=samplerTex(tex,uv+d.zy);s+=samplerTex(tex,uv+d.xw);s+=samplerTex(tex,uv+d.zw);return s*(1.0/4.0);}");var e={a_PositionTexcoord:[t.VertexMesh.MESH_POSITION0,t.ShaderDataType.Vector4]},r={u_MainTex:t.ShaderDataType.Texture2D,u_MainTex_TexelSize:t.ShaderDataType.Vector4,u_AutoExposureTex:t.ShaderDataType.Texture2D,u_Threshold:t.ShaderDataType.Vector4,u_Params:t.ShaderDataType.Vector4,u_BloomTex:t.ShaderDataType.Texture2D,u_SampleScale:t.ShaderDataType.Float},i=t.Shader3D.add("PostProcessBloom");i.shaderType=t.ShaderFeatureType.PostProcess;var s=new t.SubShader(e,r);i.addSubShader(s);var l=s.addShaderPass(a,'#define SHADER_NAME BloomPreFilter13FS\n#include "Color.glsl";\n#include "Colors.glsl";\n#include "Sampling.glsl";\nvarying vec2 v_Texcoord0;mediump vec4 prefilter(mediump vec4 color,vec2 uv){vec4 autoExposureSampler=texture2D(u_AutoExposureTex,uv);\n#ifdef Gamma_u_AutoExposureTex\nautoExposureSampler=gammaToLinear(autoExposureSampler);\n#endif\nmediump float autoExposure=autoExposureSampler.r;color*=autoExposure;color=min(vec4(u_Params.x),color);color=quadraticThreshold(color,u_Threshold.x,u_Threshold.yzw);return color;}void fragPrefilter13(){mediump vec4 color=downsampleBox13Tap(u_MainTex,v_Texcoord0,u_MainTex_TexelSize.xy);gl_FragColor=prefilter(safeHDR(color),v_Texcoord0);}void main(){fragPrefilter13();gl_FragColor=outputTransform(gl_FragColor);}'),n=l.renderState;(n=l.renderState).depthTest=t.RenderState.DEPTHTEST_ALWAYS,n.depthWrite=!1,n.cull=t.RenderState.CULL_NONE,n.blend=t.RenderState.BLEND_DISABLE,s=new t.SubShader(e,r),i.addSubShader(s),(n=(l=s.addShaderPass(a,'#define SHADER_NAME BloomPreFilter4FS\n#include "Color.glsl";\n#include "Colors.glsl";\n#include "Sampling.glsl";\nvarying vec2 v_Texcoord0;mediump vec4 prefilter(mediump vec4 color,vec2 uv){vec4 autoExposureSampler=texture2D(u_AutoExposureTex,uv);\n#ifdef Gamma_u_AutoExposureTex\nautoExposureSampler=gammaToLinear(autoExposureSampler);\n#endif\nmediump float autoExposure=autoExposureSampler.r;color*=autoExposure;color=min(vec4(u_Params.x),color);color=quadraticThreshold(color,u_Threshold.x,u_Threshold.yzw);return color;}void fragPrefilter4(){mediump vec4 color=downsampleBox4Tap(u_MainTex,v_Texcoord0,u_MainTex_TexelSize.xy);gl_FragColor=prefilter(safeHDR(color),v_Texcoord0);}void main(){fragPrefilter4();gl_FragColor=outputTransform(gl_FragColor);}')).renderState).depthTest=t.RenderState.DEPTHTEST_ALWAYS,n.depthWrite=!1,n.cull=t.RenderState.CULL_NONE,n.blend=t.RenderState.BLEND_DISABLE,s=new t.SubShader(e,r),i.addSubShader(s),(n=(l=s.addShaderPass(a,'#define SHADER_NAME BloomDownSample13FS\n#include "Color.glsl";\n#include "Colors.glsl";\n#include "Sampling.glsl";\nvarying vec2 v_Texcoord0;void fragDownsample13(){mediump vec4 color=downsampleBox13Tap(u_MainTex,v_Texcoord0,u_MainTex_TexelSize.xy);gl_FragColor=color;}void main(){fragDownsample13();gl_FragColor=outputTransform(gl_FragColor);}')).renderState).depthTest=t.RenderState.DEPTHTEST_ALWAYS,n.depthWrite=!1,n.cull=t.RenderState.CULL_NONE,n.blend=t.RenderState.BLEND_DISABLE,s=new t.SubShader(e,r),i.addSubShader(s),(n=(l=s.addShaderPass(a,'#define SHADER_NAME BloomDownSample4FS\n#include "Color.glsl";\n#include "Colors.glsl";\n#include "Sampling.glsl";\nvarying vec2 v_Texcoord0;void fragDownsample4(){mediump vec4 color=downsampleBox4Tap(u_MainTex,v_Texcoord0,u_MainTex_TexelSize.xy);gl_FragColor=color;}void main(){fragDownsample4();gl_FragColor=outputTransform(gl_FragColor);}')).renderState).depthTest=t.RenderState.DEPTHTEST_ALWAYS,n.depthWrite=!1,n.cull=t.RenderState.CULL_NONE,n.blend=t.RenderState.BLEND_DISABLE,s=new t.SubShader(e,r),i.addSubShader(s),(n=(l=s.addShaderPass(a,'#define SHADER_NAME BloomUpSampleTentFS\n#include "Color.glsl";\n#include "Colors.glsl";\n#include "Sampling.glsl";\nvarying vec2 v_Texcoord0;mediump vec4 combine(mediump vec4 bloom,vec2 uv){mediump vec4 color=texture2D(u_BloomTex,uv);\n#ifdef Gamma_u_BloomTex\ncolor=gammaToLinear(color);\n#endif\nreturn bloom+color;}void fragUpsampleTent(){mediump vec4 bloom=upsampleTent(u_MainTex,v_Texcoord0,u_MainTex_TexelSize.xy,vec4(u_SampleScale));gl_FragColor=combine(bloom,v_Texcoord0);}void main(){fragUpsampleTent();gl_FragColor=outputTransform(gl_FragColor);}')).renderState).depthTest=t.RenderState.DEPTHTEST_ALWAYS,n.depthWrite=!1,n.cull=t.RenderState.CULL_NONE,n.blend=t.RenderState.BLEND_DISABLE,s=new t.SubShader(e,r),i.addSubShader(s),(n=(l=s.addShaderPass(a,'#define SHADER_NAME BloomUpSampleBoxFS\n#include "Color.glsl";\n#include "Colors.glsl";\n#include "Sampling.glsl";\nvarying vec2 v_Texcoord0;mediump vec4 combine(mediump vec4 bloom,vec2 uv){mediump vec4 color=texture2D(u_BloomTex,uv);\n#ifdef Gamma_u_BloomTex\ncolor=gammaToLinear(color);\n#endif\nreturn bloom+color;}void fragUpsampleBox(){mediump vec4 bloom=upsampleBox(u_MainTex,v_Texcoord0,u_MainTex_TexelSize.xy,vec4(u_SampleScale));gl_FragColor=combine(bloom,v_Texcoord0);}void main(){fragUpsampleBox();gl_FragColor=outputTransform(gl_FragColor);}')).renderState).depthTest=t.RenderState.DEPTHTEST_ALWAYS,n.depthWrite=!1,n.cull=t.RenderState.CULL_NONE,n.blend=t.RenderState.BLEND_DISABLE,o.CompositeInit(),o.__initDefine__()}static CompositeInit(){let e={a_PositionTexcoord:[t.VertexMesh.MESH_POSITION0,t.ShaderDataType.Vector4]},a={u_MainTex:t.ShaderDataType.Texture2D,u_BloomTex:t.ShaderDataType.Texture2D,u_AutoExposureTex:t.ShaderDataType.Texture2D,u_Bloom_DirtTex:t.ShaderDataType.Texture2D,u_BloomTex_TexelSize:t.ShaderDataType.Vector4,u_Bloom_DirtTileOffset:t.ShaderDataType.Vector4,u_Bloom_Settings:t.ShaderDataType.Vector4,u_Bloom_Color:t.ShaderDataType.Color},o=t.Shader3D.add("PostProcessComposite");o.shaderType=t.ShaderFeatureType.PostProcess;let r=new t.SubShader(e,a);o.addSubShader(r);let i=r.addShaderPass("#define SHADER_NAME CompositeVS\nvarying vec2 v_Texcoord0;vec4 remapPositionZ(vec4 position){\n#ifdef BLITSCREEN_INVERTY\nposition.y=-position.y;\n#endif\nreturn position;}void main(){gl_Position=vec4(a_PositionTexcoord.xy,0.0,1.0);v_Texcoord0=a_PositionTexcoord.zw;gl_Position=remapPositionZ(gl_Position);}",'#define SHADER_NAME CompositeFS\n#include "Color.glsl";\n#include "Colors.glsl";\n#include "Sampling.glsl";\nvarying vec2 v_Texcoord0;void main(){vec4 autoExposureSampler=texture2D(u_AutoExposureTex,v_Texcoord0);\n#ifdef Gamma_u_AutoExposureTex\nautoExposureSampler=gammaToLinear(autoExposureSampler);\n#endif\nmediump float autoExposure=autoExposureSampler.r;mediump vec4 color=vec4(0.0);color=texture2D(u_MainTex,v_Texcoord0);\n#ifdef Gamma_u_MainTex\ncolor=gammaToLinear(color);\n#endif\ncolor.rgb*=autoExposure;\n#if defined(BLOOM) || defined(BLOOM_LOW)\n#ifdef BLOOM\nmediump vec4 bloom=upsampleTent(u_BloomTex,v_Texcoord0,u_BloomTex_TexelSize.xy,vec4(u_Bloom_Settings.x));\n#else\nmediump vec4 bloom=upsampleBox(u_BloomTex,v_Texcoord0,u_BloomTex_TexelSize.xy,vec4(u_Bloom_Settings.x));\n#endif\nmediump vec4 dirt=vec4(texture2D(u_Bloom_DirtTex,v_Texcoord0*u_Bloom_DirtTileOffset.xy+u_Bloom_DirtTileOffset.zw).rgb,0.0);\n#ifdef Gamma_u_Bloom_DirtTex\ndirt=gammaToLinear(dirt);\n#endif\nbloom*=u_Bloom_Settings.y;dirt*=u_Bloom_Settings.z;mediump vec4 bloomColor=u_Bloom_Color;color+=bloom*bloomColor;color+=dirt*bloom;\n#endif\nmediump vec4 finalColor=color;gl_FragColor=finalColor;gl_FragColor=outputTransform(gl_FragColor);}').renderState;i.depthTest=t.RenderState.DEPTHTEST_ALWAYS,i.depthWrite=!1,i.cull=t.RenderState.CULL_NONE,i.blend=t.RenderState.BLEND_DISABLE}static __initDefine__(){o.SHADERVALUE_MAINTEX=t.Shader3D.propertyNameToID("u_MainTex"),o.SHADERVALUE_AUTOEXPOSURETEX=t.Shader3D.propertyNameToID("u_AutoExposureTex"),o.SHADERVALUE_SAMPLESCALE=t.Shader3D.propertyNameToID("u_SampleScale"),o.SHADERVALUE_THRESHOLD=t.Shader3D.propertyNameToID("u_Threshold"),o.SHADERVALUE_PARAMS=t.Shader3D.propertyNameToID("u_Params"),o.SHADERVALUE_BLOOMTEX=t.Shader3D.propertyNameToID("u_BloomTex")}get clamp(){return this._clamp}set clamp(e){this._clamp=e}get color(){return this._color}set color(e){this._color=e}get fastMode(){return this._fastMode}set fastMode(e){this._fastMode=e}get dirtTexture(){return this._dirtTexture}set dirtTexture(e){this._dirtTexture&&this._dirtTexture._removeReference(1),this._dirtTexture=e,this._dirtTexture&&this._dirtTexture._addReference(1)}get intensity(){return this._intensity}set intensity(e){this._intensity=Math.max(e,0)}get threshold(){return this._threshold}set threshold(e){this._threshold=Math.max(e,0)}get softKnee(){return this._softKnee}set softKnee(e){this._softKnee=Math.min(Math.max(e,0),1)}get diffusion(){return this._diffusion}set diffusion(e){this._diffusion=Math.min(Math.max(e,1),10)}get anamorphicRatio(){return this._anamorphicRatio}set anamorphicRatio(e){this._anamorphicRatio=Math.min(Math.max(e,-1),1)}get dirtIntensity(){return this._dirtIntensity}set dirtIntensity(e){this._dirtIntensity=Math.max(e,0)}constructor(){super(),this._shader=null,this._shaderData=t.LayaGL.renderDeviceFactory.createShaderData(null),this._linearColor=new t.Color,this._bloomTextureTexelSize=new t.Vector4,this._shaderThreshold=new t.Vector4,this._shaderParams=new t.Vector4,this._pyramid=null,this._intensity=0,this._threshold=1,this._softKnee=.5,this._diffusion=7,this._anamorphicRatio=0,this._dirtIntensity=0,this._shaderSetting=new t.Vector4,this._dirtTileOffset=new t.Vector4,this._fastMode=!1,this._dirtTexture=null,this.singleton=!0,this.active=!0,this.intensity=1,this.threshold=1,this.softKnee=.5,this.clamp=65472,this.diffusion=7,this.anamorphicRatio=0,this.color=new t.Color(1,1,1,1)}effectInit(e){super.effectInit(e),this._shader=t.Shader3D.find("PostProcessBloom"),this._pyramid=new Array(2*o.MAXPYRAMIDSIZE)}getCameraDepthTextureModeFlag(){return 0}release(e){super.release(e),this._shader=null,this._pyramid=[]}render(e){var a=e.command,r=e.camera.viewport;this._shaderData.setTexture(o.SHADERVALUE_AUTOEXPOSURETEX,t.Texture2D.whiteTexture);var i,s=this._anamorphicRatio,l=s<0?-s:0,n=s>0?s:0,c=Math.floor(r.width/(2-l)),d=Math.floor(r.height/(2-n)),_=Math.max(c,d);i=Math.log2(_)+this._diffusion-10;var u=Math.floor(i),h=Math.min(Math.max(u,1),o.MAXPYRAMIDSIZE),f=.5+i-u;this._shaderData.setNumber(o.SHADERVALUE_SAMPLESCALE,f);var m=t.Color.gammaToLinearSpace(this.threshold),S=m*this._softKnee+1e-5;this._shaderThreshold.setValue(m,m-S,2*S,.25/S),this._shaderData.setVector(o.SHADERVALUE_THRESHOLD,this._shaderThreshold);var p=t.Color.gammaToLinearSpace(this.clamp);this._shaderParams.setValue(p,0,0,0),this._shaderData.setVector(o.SHADERVALUE_PARAMS,this._shaderParams);for(var T=this.fastMode?1:0,v=e.indirectTarget,x=0;x<h;x++){var g=2*x,D=g+1,C=0==x?o.SUBSHADER_PREFILTER13+T:o.SUBSHADER_DOWNSAMPLE13+T,E=t.RenderTexture.createFromPool(c,d,t.RenderTargetFormat.R8G8B8A8,t.RenderTargetFormat.None,!1,1,!1,!0);if(E.filterMode=t.FilterMode.Bilinear,this._pyramid[g]=E,x!==h-1){var A=t.RenderTexture.createFromPool(c,d,t.RenderTargetFormat.R8G8B8A8,t.RenderTargetFormat.None,!1,1,!1,!0);A.filterMode=t.FilterMode.Bilinear,this._pyramid[D]=A}a.blitScreenTriangle(v,E,null,this._shader,this._shaderData,C),v=E,c=Math.max(Math.floor(c/2),1),d=Math.max(Math.floor(d/2),1)}var L=this._pyramid[2*(h-1)];for(x=h-2;x>=0;x--)D=(g=2*x)+1,E=this._pyramid[g],A=this._pyramid[D],a.setShaderDataTexture(this._shaderData,o.SHADERVALUE_BLOOMTEX,E),a.blitScreenTriangle(L,A,null,this._shader,this._shaderData,o.SUBSHADER_UPSAMPLETENT+T),L=A;var P=this._linearColor;this.color.toLinear(P);var y=Math.pow(2,this._intensity/10)-1,M=this._shaderSetting;this._shaderSetting.setValue(f,y,this._dirtIntensity,h);var R=this._dirtTexture?this._dirtTexture:t.Texture2D.blackTexture,w=R.width/R.height,b=r.width/r.height,O=this._dirtTileOffset;w>b?O.setValue(b/w,1,.5*(1-O.x),0):w<b&&O.setValue(1,w/b,0,.5*(1-O.y));var B=e.compositeShaderData;this.fastMode?B.addDefine(t.PostProcess.SHADERDEFINE_BLOOM_LOW):B.addDefine(t.PostProcess.SHADERDEFINE_BLOOM),this._bloomTextureTexelSize.setValue(1/L.width,1/L.height,L.width,L.height),B.setVector(t.PostProcess.SHADERVALUE_BLOOM_DIRTTILEOFFSET,O),B.setVector(t.PostProcess.SHADERVALUE_BLOOM_SETTINGS,M),B.setColor(t.PostProcess.SHADERVALUE_BLOOM_COLOR,P),B.setTexture(t.PostProcess.SHADERVALUE_BLOOM_DIRTTEX,R),B.setTexture(t.PostProcess.SHADERVALUE_BLOOMTEX,L),B.setVector(t.PostProcess.SHADERVALUE_BLOOMTEX_TEXELSIZE,this._bloomTextureTexelSize);let N=t.Shader3D.find("PostProcessComposite");for(a.blitScreenTriangle(e.indirectTarget,e.destination,e.camera._screenOffsetScale,N,B,0),x=0;x<h;x++)D=(g=2*x)+1,t.RenderTexture.recoverToPool(this._pyramid[g]),0!==x&&x!==h-1&&t.RenderTexture.recoverToPool(this._pyramid[D]);e.deferredReleaseTextures.push(L)}}o.SUBSHADER_PREFILTER13=0,o.SUBSHADER_PREFILTER4=1,o.SUBSHADER_DOWNSAMPLE13=2,o.SUBSHADER_DOWNSAMPLE4=3,o.SUBSHADER_UPSAMPLETENT=4,o.SUBSHADER_UPSAMPLEBOX=5,o.MAXPYRAMIDSIZE=16,t.Laya.addInitCallback((()=>o.init()));var r,i="#define SHADER_NAME BlitVS\nvarying vec2 v_Texcoord0;void main(){gl_Position=vec4(u_OffsetScale.x*2.0-1.0+(a_PositionTexcoord.x+1.0)*u_OffsetScale.z,(1.0-((u_OffsetScale.y*2.0-1.0+(-a_PositionTexcoord.y+1.0)*u_OffsetScale.w)+1.0)/2.0)*2.0-1.0,0.0,1.0);v_Texcoord0=a_PositionTexcoord.zw;}";class s{static init(){t.Shader3D.addInclude("ACES_UtillitiesColor.glsl","#if !defined(UtillitiesColor_lib)\n#define UtillitiesColor_lib\nvec3 XYZ_2_xyY(vec3 XYZ){vec3 xyY;float divisor=max(XYZ.x+XYZ.y+XYZ.z,1e-10);xyY.x=XYZ.x/divisor;xyY.y=XYZ.y/divisor;xyY.z=XYZ.y;return xyY;}vec3 xyY_2_XYZ(vec3 xyY){vec3 XYZ;XYZ.x=xyY.x*xyY.z/max(xyY.y,1e-10);XYZ.y=xyY.z;XYZ.z=(1.0-xyY.x-xyY.y)*xyY.z/max(xyY.y,1e-10);return XYZ;}float rgb_2_yc(vec3 rgb,float ycRadiusWeight){float r=rgb.r;float g=rgb.g;float b=rgb.b;float k=b*(b-g)+g*(g-r)+r*(r-b);k=max(MEDIUMP_FLT_MIN,k);float chroma=sqrt(k);return(b+g+r+ycRadiusWeight*chroma)/3.0;}float rgb_2_yc(vec3 rgb){return rgb_2_yc(rgb,1.75);}float rgb_2_hue(vec3 rgb){float hue;if(rgb.x==rgb.y&&rgb.y==rgb.z)hue=0.0;else hue=(180.0*INVERT_PI)*atan(sqrt(3.0)*(rgb.y-rgb.z),2.0*rgb.x-rgb.y-rgb.z);if(hue<0.0){hue=hue+360.0;}return hue;}\n#endif\n"),t.Shader3D.addInclude("ACES_TransformCommon.glsl","#if !defined(TransformCommon_lib)\n#define TransformCommon_lib\nconst float TINY=1e-10;const mat3 sRGB_to_AP0_MAT=mat3(vec3(0.4395856442,0.0895395735,0.0173871832),vec3(0.3839294030,0.8147498351,0.1087391143),vec3(0.1765327364,0.0956836061,0.8738205876));const mat3 sRGB_to_AP1_MAT=mat3(vec3(0.6131178129,0.0699340823,0.0204629926),vec3(0.3411819959,0.9181030375,0.1067686634),vec3(0.0457873443,0.0119327755,0.8727159106));const mat3 AP1_to_XYZ_MAT=mat3(vec3(0.6624541811,0.2722287168,-0.0055746495),vec3(0.1340042065,0.6740817658,0.0040607335),vec3(0.1561876870,0.0536895174,1.0103391003));const mat3 AP0_to_AP1_MAT=mat3(vec3(1.4514393161,-0.0765537734,0.0083161484),vec3(-0.2365107469,1.1762296998,-0.0060324498),vec3(-0.2149285693,-0.0996759264,0.9977163014));const mat3 AP1_to_AP0_MAT=mat3(vec3(0.6954522414,0.0447945634,-0.0055258826),vec3(0.1406786965,0.8596711185,0.0040252103),vec3(0.1638690622,0.0955343182,1.0015006723));const mat3 XYZ_to_AP1_MAT=mat3(vec3(1.6410233797,-0.6636628587,0.0117218943),vec3(-0.3248032942,1.6153315917,-0.0082844420),vec3(-0.2364246952,0.0167563477,0.9883948585));const vec3 AP1_RGB2Y=vec3(0.2722287168,0.6740817658,0.0536895174);float ACES_to_ACEScc(float x){return(x<0.00003051757)?(log2(0.00001525878+x*0.5)+9.72)/17.52 :(log2(x)+9.72)/17.52;}vec3 ACES_to_ACEScc(vec3 x){x=clamp(x,vec3(0.0),vec3(MEDIUMP_FLT_MAX));x.x=ACES_to_ACEScc(x.x);x.y=ACES_to_ACEScc(x.y);x.z=ACES_to_ACEScc(x.z);return x;}float ACEScc_to_ACES(float x){if(x<-0.3013698630)return(pow(2.0,x*17.52-9.72)-pow(2.0,-16.0))*2.0;else if(x<(log2(MEDIUMP_FLT_MAX)+9.72)/17.52)return pow(2.0,x*17.52-9.72);else return MEDIUMP_FLT_MAX;}vec3 ACEScc_to_ACES(vec3 x){x.x=ACEScc_to_ACES(x.x);x.y=ACEScc_to_ACES(x.y);x.z=ACEScc_to_ACES(x.z);return x;}float rgb_2_saturation(vec3 rgb){float rgbmax=vecmax(rgb);float rgbmin=vecmin(rgb);return(max(rgbmax,TINY)-max(rgbmin,TINY))/max(rgbmax,1e-2);}\n#endif\n"),t.Shader3D.addInclude("ACES_Tonescales.glsl","#if !defined(Tonescales_lib)\n#define Tonescales_lib\nconst mat3 M=mat3(vec3(0.5,-1.0,0.5),vec3(-1.0,1.0,0.5),vec3(0.5,0.0,0.0));float segmented_spline_c5_fwd(float x){\n#ifdef GRAPHICS_API_GLES3\nconst float coefsLow[6]=float[6](-4.0000000000,-4.0000000000,-3.1573765773,-0.4852499958,1.8477324706,1.8477324706);const float coefsHigh[6]=float[6](-0.7185482425,2.0810307172,3.6681241237,4.0000000000,4.0000000000,4.0000000000);\n#else\nconst float coefsLow_0=-4.0000000000;const float coefsLow_1=-4.0000000000;const float coefsLow_2=-3.1573765773;const float coefsLow_3=-0.4852499958;const float coefsLow_4=1.8477324706;const float coefsLow_5=1.8477324706;const float coefsHigh_0=-0.7185482425;const float coefsHigh_1=2.0810307172;const float coefsHigh_2=3.6681241237;const float coefsHigh_3=4.0000000000;const float coefsHigh_4=4.0000000000;const float coefsHigh_5=4.0000000000;\n#endif\nconst vec2 minPoint=vec2(0.0000054931640625,0.0001);const vec2 midPoint=vec2(0.18,4.8);const vec2 maxPoint=vec2(47185.92,10000.);const float slopeLow=0.0;const float slopeHigh=0.0;const int N_KNOTS_LOW=4;const int N_KNOTS_HIGH=4;float logx=log10(max(x,MEDIUMP_FLT_MIN));float logy;if(logx<=log10(minPoint.x)){logy=logx*slopeLow+(log10(minPoint.y)-slopeLow*log10(minPoint.x));}else if((logx>log10(minPoint.x))&&(logx<log10(midPoint.x))){float knot_coord=float(N_KNOTS_LOW-1)*(logx-log10(minPoint.x))/(log10(midPoint.x)-log10(minPoint.x));int j=int(knot_coord);float t=knot_coord-float(j);vec3 cf;\n#ifdef GRAPHICS_API_GLES3\ncf=vec3(coefsLow[j],coefsLow[j+1],coefsLow[j+2]);\n#else\nif(j<=0){cf=vec3(coefsLow_0,coefsLow_1,coefsLow_2);}else if(j==1){cf=vec3(coefsLow_1,coefsLow_2,coefsLow_3);}else if(j==2){cf=vec3(coefsLow_2,coefsLow_3,coefsLow_4);}else{cf=vec3(coefsLow_3,coefsLow_4,coefsLow_5);}\n#endif\nvec3 monomials=vec3(t*t,t,1.);logy=dot(monomials,M*cf);}else if((logx>=log10(midPoint.x))&&(logx<log10(maxPoint.x))){float knot_coord=float(N_KNOTS_HIGH-1)*(logx-log10(midPoint.x))/(log10(maxPoint.x)-log10(midPoint.x));int j=int(knot_coord);float t=knot_coord-float(j);vec3 cf;\n#ifdef GRAPHICS_API_GLES3\ncf=vec3(coefsHigh[j],coefsHigh[j+1],coefsHigh[j+2]);\n#else\nif(j<=0){cf=vec3(coefsHigh_0,coefsHigh_1,coefsHigh_2);}else if(j==1){cf=vec3(coefsHigh_1,coefsHigh_2,coefsHigh_3);}else if(j==2){cf=vec3(coefsHigh_2,coefsHigh_3,coefsHigh_4);}else{cf=vec3(coefsHigh_3,coefsHigh_4,coefsHigh_5);}\n#endif\nvec3 monomials=vec3(t*t,t,1.);logy=dot(monomials,M*cf);}else{logy=logx*slopeHigh+(log10(maxPoint.y)-slopeHigh*log10(maxPoint.x));}return pow(10.0,logy);}float segmented_spline_c9_fwd(float x){\n#ifdef GRAPHICS_API_GLES3\nconst float coefsLow[10]=float[10](-1.6989700043,-1.6989700043,-1.4779000000,-1.2291000000,-0.8648000000,-0.4480000000,0.0051800000,0.4511080334,0.9113744414,0.9113744414);const float coefsHigh[10]=float[10](0.5154386965,0.8470437783,1.1358000000,1.3802000000,1.5197000000,1.5985000000,1.6467000000,1.6746091357,1.6878733390,1.6878733390);\n#else\nconst float coefsLow_0=-1.6989700043;const float coefsLow_1=-1.6989700043;const float coefsLow_2=-1.4779000000;const float coefsLow_3=-1.2291000000;const float coefsLow_4=-0.8648000000;const float coefsLow_5=-0.4480000000;const float coefsLow_6=0.0051800000;const float coefsLow_7=0.4511080334;const float coefsLow_8=0.9113744414;const float coefsLow_9=0.9113744414;const float coefsHigh_0=0.5154386965;const float coefsHigh_1=0.8470437783;const float coefsHigh_2=1.1358000000;const float coefsHigh_3=1.3802000000;const float coefsHigh_4=1.5197000000;const float coefsHigh_5=1.5985000000;const float coefsHigh_6=1.6467000000;const float coefsHigh_7=1.6746091357;const float coefsHigh_8=1.6878733390;const float coefsHigh_9=1.6878733390;\n#endif\nvec2 minPoint=vec2(segmented_spline_c5_fwd(0.18*pow(2.0,-6.5)),0.02);vec2 midPoint=vec2(segmented_spline_c5_fwd(0.18),4.8);vec2 maxPoint=vec2(segmented_spline_c5_fwd(0.18*pow(2.,6.5)),48.0);const float slopeLow=0.0;const float slopeHigh=0.04;const int N_KNOTS_LOW=8;const int N_KNOTS_HIGH=8;float logx=log10(max(x,MEDIUMP_FLT_MIN));float logy;if(logx<=log10(minPoint.x)){logy=logx*slopeLow+(log10(minPoint.y)-slopeLow*log10(minPoint.x));}else if((logx>log10(minPoint.x))&&(logx<log10(midPoint.x))){float knot_coord=float(N_KNOTS_LOW-1)*(logx-log10(minPoint.x))/(log10(midPoint.x)-log10(minPoint.x));int j=int(knot_coord);float t=knot_coord-float(j);vec3 cf;\n#ifdef GRAPHICS_API_GLES3\ncf=vec3(coefsLow[j],coefsLow[j+1],coefsLow[j+2]);\n#else\nif(j<=0){cf=vec3(coefsLow_0,coefsLow_1,coefsLow_2);}else if(j==1){cf=vec3(coefsLow_1,coefsLow_2,coefsLow_3);}else if(j==2){cf=vec3(coefsLow_2,coefsLow_3,coefsLow_4);}else if(j==3){cf=vec3(coefsLow_3,coefsLow_4,coefsLow_5);}else if(j==4){cf=vec3(coefsLow_4,coefsLow_5,coefsLow_6);}else if(j==5){cf=vec3(coefsLow_5,coefsLow_6,coefsLow_7);}else if(j==6){cf=vec3(coefsLow_6,coefsLow_7,coefsLow_8);}else{cf=vec3(coefsLow_7,coefsLow_8,coefsLow_9);}\n#endif\nvec3 monomials=vec3(t*t,t,1.0);logy=dot(monomials,M*cf);}else if((logx>=log10(midPoint.x))&&(logx<log10(maxPoint.x))){float knot_coord=float(N_KNOTS_HIGH-1)*(logx-log10(midPoint.x))/(log10(maxPoint.x)-log10(midPoint.x));int j=int(knot_coord);float t=knot_coord-float(j);vec3 cf;\n#ifdef GRAPHICS_API_GLES3\ncf=vec3(coefsHigh[j],coefsHigh[j+1],coefsHigh[j+2]);\n#else\nif(j<=0){cf=vec3(coefsHigh_0,coefsHigh_1,coefsHigh_2);}else if(j==1){cf=vec3(coefsHigh_1,coefsHigh_2,coefsHigh_3);}else if(j==2){cf=vec3(coefsHigh_2,coefsHigh_3,coefsHigh_4);}else if(j==3){cf=vec3(coefsHigh_3,coefsHigh_4,coefsHigh_5);}else if(j==4){cf=vec3(coefsHigh_4,coefsHigh_5,coefsHigh_6);}else if(j==5){cf=vec3(coefsHigh_5,coefsHigh_6,coefsHigh_7);}else if(j==6){cf=vec3(coefsHigh_6,coefsHigh_7,coefsHigh_8);}else{cf=vec3(coefsHigh_7,coefsHigh_8,coefsHigh_9);}\n#endif\nvec3 monomials=vec3(t*t,t,1.0);logy=dot(monomials,M*cf);}else{logy=logx*slopeHigh+(log10(maxPoint.y)-slopeHigh*log10(maxPoint.x));}return pow(10.0,logy);}\n#endif\n"),t.Shader3D.addInclude("ACES_RRTCommon.glsl","#if !defined(RRTCommon_lib)\n#define RRTCommon_lib\nconst float RRT_GLOW_GAIN=0.05;const float RRT_GLOW_MID=0.08;const float RRT_RED_SCALE=0.82;const float RRT_RED_PIVOT=0.03;const float RRT_RED_HUE=0.;const float RRT_RED_WIDTH=135.;const float RRT_SAT_FACTOR=0.96;float glow_fwd(float ycIn,float glowGainIn,float glowMid){float glowGainOut;if(ycIn<=2.0/3.0*glowMid){glowGainOut=glowGainIn;}else if(ycIn>=2.0*glowMid){glowGainOut=0.0;}else{glowGainOut=glowGainIn*(glowMid/ycIn-0.5);}return glowGainOut;}float sigmoid_shaper(float x){float t=max(1.0-abs(x*0.5),0.0);float y=1.0+sign(x)*(1.0-t*t);return y*0.5;}float center_hue(float hue,float centerH){float hueCentered=hue-centerH;if(hueCentered<-180.0){hueCentered=hueCentered+360.0;}else if(hueCentered>180.0){hueCentered-=360.0;}return hueCentered;}\n#endif\n"),t.Shader3D.addInclude("ACES_ODTCommon.glsl","#if !defined(ODTCommon_lib)\n#define ODTCommon_lib\nconst float CINEMA_WHITE=48.0;const float CINEMA_BLACK=0.02;const float DIM_SURROUND_GAMMA=0.9811;const float ODT_SAT_FACTOR=0.93;const mat3 D60_to_D65_MAT=mat3(vec3(0.987224,-0.00759836,0.00307257),vec3(-0.00611327,1.00186,-0.00509595),vec3(0.0159533,0.00533002,1.08168));float Y_2_linCV(float Y,float Ymax,float Ymin){return(Y-Ymin)/(Ymax-Ymin);}vec3 darkSurround_to_dimSurround(vec3 linearCV){vec3 XYZ=linearCV*AP1_to_XYZ_MAT;vec3 xyY=XYZ_2_xyY(XYZ);xyY.z=clamp(xyY.z,0.0,MEDIUMP_FLT_MAX);xyY.z=pow(xyY.z,DIM_SURROUND_GAMMA);XYZ=xyY_2_XYZ(xyY);return XYZ*XYZ_to_AP1_MAT;}\n#endif\n"),t.Shader3D.addInclude("ACES_RRT.glsl",'#if !defined(RRT_lib)\n#define RRT_lib\n#include "ACES_RRTCommon.glsl";\nvec3 RRT(vec3 aces){float saturation=rgb_2_saturation(aces);float ycIn=rgb_2_yc(aces);float s=sigmoid_shaper((saturation-0.4)/0.2);float addedGlow=1.0+glow_fwd(ycIn,RRT_GLOW_GAIN*s,RRT_GLOW_MID);aces*=addedGlow;float hue=rgb_2_hue(aces);float centeredHue=center_hue(hue,RRT_RED_HUE);float hueWeight=smoothstep(0.0,1.0,1.0-abs(2.0*centeredHue/RRT_RED_WIDTH));hueWeight*=hueWeight;aces.r+=hueWeight*saturation*(RRT_RED_PIVOT-aces.r)*(1.-RRT_RED_SCALE);vec3 rgbPre=AP0_to_AP1_MAT*aces;rgbPre=clamp(rgbPre,0.0,MEDIUMP_FLT_MAX);rgbPre=mix(vec3(dot(rgbPre,AP1_RGB2Y)),rgbPre,RRT_SAT_FACTOR);vec3 rgbPost;rgbPost.x=segmented_spline_c5_fwd(rgbPre.x);rgbPost.y=segmented_spline_c5_fwd(rgbPre.y);rgbPost.z=segmented_spline_c5_fwd(rgbPre.z);vec3 rgbOces=AP1_to_AP0_MAT*rgbPost;return rgbOces;}\n#endif\n'),t.Shader3D.addInclude("ACES_ODT_sRGB_100nits.glsl",'#if !defined(ODT_sRGB_100nits_lib)\n#define ODT_sRGB_100nits_lib\n#include "ACES_ODTCommon.glsl";\nconst mat3 XYZ_to_REC709_MAT=mat3(vec3(3.2409699419,-0.9692436363,0.0556300797),vec3(-1.5373831776,1.8759675015,-0.2039769589),vec3(-0.498610760,0.0415550574,1.0569715142));const float DISPGAMMA=2.4;const float OFFSET=0.055;vec3 ODT_sRGB_100nits(vec3 oces){vec3 rgbPre=AP0_to_AP1_MAT*oces;vec3 rgbPost;rgbPost.r=segmented_spline_c9_fwd(rgbPre.r);rgbPost.g=segmented_spline_c9_fwd(rgbPre.g);rgbPost.b=segmented_spline_c9_fwd(rgbPre.b);vec3 linearCV;linearCV.r=Y_2_linCV(rgbPost.r,CINEMA_WHITE,CINEMA_BLACK);linearCV.g=Y_2_linCV(rgbPost.g,CINEMA_WHITE,CINEMA_BLACK);linearCV.b=Y_2_linCV(rgbPost.b,CINEMA_WHITE,CINEMA_BLACK);linearCV=darkSurround_to_dimSurround(linearCV);vec3 XYZ=AP1_to_XYZ_MAT*linearCV;XYZ=D60_to_D65_MAT*XYZ;linearCV=XYZ_to_REC709_MAT*XYZ;linearCV=clamp(linearCV,vec3(0.0),vec3(1.0));return linearCV;}\n#endif\n'),t.Shader3D.addInclude("ACES.glsl",'\n#if !defined(ACES_lib)\n#define ACES_lib\n#include "ACES_TransformCommon.glsl";\n#include "ACES_UtillitiesColor.glsl";\n#include "ACES_Tonescales.glsl";\n#include "ACES_RRT.glsl";\n#include "ACES_ODT_sRGB_100nits.glsl";\nvec3 sRGB_to_AP0(vec3 sRGB){return sRGB_to_AP0_MAT*sRGB;}vec3 sRGB_to_AP1(vec3 sRGB){return sRGB_to_AP1_MAT*sRGB;}\n#endif\n')}}e.ToneMappingType=void 0,(r=e.ToneMappingType||(e.ToneMappingType={}))[r.None=0]="None",r[r.ACES=1]="ACES";class l extends t.PostProcessEffect{static init(){l.__initDefine__(),t.Shader3D.addInclude("ColorGrading.glsl","#if !defined(ColorGrading_lib)\n#define ColorGrading_lib\nconst float ACEScc_MAX=1.4679964;const float ACEScc_MIDGRAY=0.4135884;const float LogC_cut=0.011361;const float LogC_a=5.555556;const float LogC_b=0.047996;const float LogC_c=0.244161;const float LogC_d=0.386036;const float LogC_e=5.301883;const float LogC_f=0.092819;float linearToLogC(float x){float o;if(x>LogC_cut){o=LogC_c*log10(max(LogC_a*x+LogC_b,0.0))+LogC_d;}else{o=LogC_e*x+LogC_f;}return o;}vec3 linearToLogC(vec3 x){vec3 logc;logc.x=linearToLogC(x.x);logc.y=linearToLogC(x.y);logc.z=linearToLogC(x.z);return logc;}float logCToLinear(float x){float o;if(x>LogC_e*LogC_cut+LogC_f)o=(pow(10.0,(x-LogC_d)/LogC_c)-LogC_b)/LogC_a;else o=(x-LogC_f)/LogC_e;return o;}vec3 logCToLinear(vec3 x){vec3 linear;linear.x=logCToLinear(x.x);linear.y=logCToLinear(x.y);linear.z=logCToLinear(x.z);return linear;}vec3 RgbToHsv(vec3 c){const vec4 K=vec4(0.0,-1.0/3.0,2.0/3.0,-1.0);vec4 p=mix(vec4(c.bg,K.wz),vec4(c.gb,K.xy),step(c.b,c.g));vec4 q=mix(vec4(p.xyw,c.r),vec4(c.r,p.yzx),step(p.x,c.r));float d=q.x-min(q.w,q.y);const float e=1.0e-4;return vec3(abs(q.z+(q.w-q.y)/(6.0*d+e)),d/(q.x+e),q.x);}vec3 HsvToRgb(vec3 c){const vec4 K=vec4(1.0,2.0/3.0,1.0/3.0,3.0);vec3 p=abs(fract(vec3(c.x)+K.xyz)*6.0-K.www);return c.z*mix(vec3(K.x),saturate(p-vec3(K.x)),c.y);}float RotateHue(float value,float low,float hi){return(value<low)? value+hi:(value>hi)? value-hi: value;}const mat3 Linear_to_LMS_MAT=mat3(vec3(3.90405e-1,7.08416e-2,2.31082e-2),vec3(5.49941e-1,9.63172e-1,1.28021e-1),vec3(8.92632e-3,1.35775e-3,9.36245e-1));const mat3 LMS_to_Linear_MAT=mat3(vec3(2.85847e+0,-2.10182e-1,-4.18120e-2),vec3(-1.62879e+0,1.15820e+0,-1.18169e-1),vec3(-2.48910e-2,3.24281e-4,1.06867e+0));uniform vec3 u_ColorBalance;uniform vec4 u_SplitShadows;uniform vec3 u_Splithighlights;uniform vec3 u_Shadows;uniform vec3 u_Midtones;uniform vec3 u_Highlights;uniform vec4 u_Limits;uniform vec3 u_Lift;uniform vec3 u_Gamma;uniform vec3 u_Gain;uniform vec4 u_ColorFilter;uniform vec4 u_HueSatCon;float luminance(in vec3 color){\n#ifdef ACES\nfloat luma=dot(color,AP1_RGB2Y);\n#else\nfloat luma=dot(color,vec3(0.2126729,0.7151522,0.0721750));\n#endif\nreturn luma;}vec3 softlight(vec3 base,vec3 blend){vec3 r1=2.0*base*blend+base*base*(1.0-2.0*blend);vec3 r2=sqrt(base)*(2.0*blend-1.0)+2.0*base*(1.0-blend);vec3 t=step(0.5,blend);return r2*t+(1.0-t)*r1;}vec3 colorGrade(in vec3 color){vec3 colorLMS=Linear_to_LMS_MAT*color;colorLMS*=u_ColorBalance.xyz;color=LMS_to_Linear_MAT*colorLMS;\n#ifdef ACES\nvec3 colorLog=ACES_to_ACEScc(sRGB_to_AP0_MAT*color);\n#else\nvec3 colorLog=linearToLogC(color);\n#endif\ncolorLog=(colorLog-vec3(ACEScc_MIDGRAY))*u_HueSatCon.z+vec3(ACEScc_MIDGRAY);\n#ifdef ACES\ncolor=AP0_to_AP1_MAT*ACEScc_to_ACES(colorLog);\n#else\ncolor=logCToLinear(colorLog);\n#endif\ncolor=color*u_ColorFilter.rgb;color=max(vec3(0.0),color);float balance=u_SplitShadows.w;vec3 gamma=linearToGamma(color);float splitLuma=saturate(luminance(color))+balance;vec3 splitShadows=mix(vec3(0.5,0.5,0.5),u_SplitShadows.xyz,1.0-splitLuma);vec3 splitHeighlights=mix(vec3(0.5,0.5,0.5),u_Splithighlights.xyz,splitLuma);gamma=softlight(gamma,splitShadows);gamma=softlight(gamma,splitHeighlights);color=gammaToLinear(gamma);float luma=luminance(color);float shadowFactor=1.0-smoothstep(u_Limits.x,u_Limits.y,luma);float highlightsFactor=smoothstep(u_Limits.z,u_Limits.w,luma);float midtonesFactor=1.0-shadowFactor-highlightsFactor;color=color*u_Shadows.xyz*shadowFactor+color*u_Midtones.xyz*midtonesFactor+color*u_Highlights.xyz*highlightsFactor;color=color*u_Gain.xyz+u_Lift.xyz;color=sign(color)*pow(abs(color),u_Gamma.xyz);vec3 hsv=RgbToHsv(color);float hue=hsv.x+u_HueSatCon.x;hsv.x=RotateHue(hsv.x,0.0,1.0);color=HsvToRgb(hsv);luma=luminance(color);color=vec3(luma)+(vec3(u_HueSatCon.y))*(color-vec3(luma));return color;}\n#endif\n"),t.Shader3D.addInclude("Tonemapping.glsl","#if !defined(Tonemapping_lib)\n#define Tonemapping_lib\nvec3 tonemap(in vec3 ap1){vec3 color=ap1;\n#ifdef ACES\nvec3 aces=AP1_to_AP0_MAT*color;vec3 oces=RRT(aces);color=ODT_sRGB_100nits(oces);\n#endif\nreturn color;}\n#endif\n"),t.Shader3D.addInclude("LUT.glsl","#if !defined(LUT_lib)\n#define LUT_lib\nvec3 applyLut(sampler2D lut,vec3 uvw,vec3 scaleOffset){uvw.z*=scaleOffset.z;float shift=floor(uvw.z);uvw.xy=uvw.xy*scaleOffset.z*scaleOffset.xy+scaleOffset.xy*0.5;uvw.x+=shift*scaleOffset.y;uvw.xyz=mix(texture2DLodEXT(lut,uvw.xy,0.0).rgb,texture2DLodEXT(lut,uvw.xy+vec2(scaleOffset.y,0.0),0.0).rgb,uvw.z-shift);return uvw;}\n#endif\n");let e={a_PositionTexcoord:[t.VertexMesh.MESH_POSITION0,t.ShaderDataType.Vector4]},a={u_OffsetScale:t.ShaderDataType.Vector4,u_MainTex:t.ShaderDataType.Texture2D,u_MainTex_TexelSize:t.ShaderDataType.Vector4},o=t.Shader3D.add("blitLUTShader");o.shaderType=t.ShaderFeatureType.PostProcess;let r=new t.SubShader(e,a);o.addSubShader(r);let s=r.addShaderPass(i,'#define SHADER_NAME BlitLUTFS\n#include "Color.glsl";\n#include "ColorGrading.glsl";\n#include "LUT.glsl";\nuniform sampler2D u_Lut;uniform vec4 u_LutParams;\n#ifdef CUSTOMLUT\nuniform sampler2D u_CustomLut;uniform vec4 u_CustomLutParams;\n#endif\nvarying vec2 v_Texcoord0;void main(){gl_FragColor=texture2D(u_MainTex,v_Texcoord0);\n#ifdef Gamma_u_MainTex\ngl_FragColor=gammaToLinear(gl_FragColor);\n#endif\nvec3 color=gl_FragColor.rgb;color*=u_LutParams.w;color=applyLut(u_Lut,linearToLogC(color),u_LutParams.xyz);\n#ifdef CUSTOMLUT\nfloat contrib=u_CustomLutParams.w;vec3 gamma=linearToGamma(color);vec3 userLut=applyLut(u_CustomLut,gamma,u_CustomLutParams);gamma=mix(gamma,userLut,contrib);color=gammaToLinear(gamma);\n#endif\ngl_FragColor.rgb=color;gl_FragColor=outputTransform(gl_FragColor);}');s.renderState.depthTest=t.RenderState.DEPTHTEST_ALWAYS,s.renderState.depthWrite=!1,s.renderState.cull=t.RenderState.CULL_NONE,s.renderState.blend=t.RenderState.BLEND_DISABLE,l.lutBuilderInit()}static lutBuilderInit(){let e={a_PositionTexcoord:[t.VertexMesh.MESH_POSITION0,t.ShaderDataType.Vector4]},a={u_OffsetScale:t.ShaderDataType.Vector4,u_MainTex:t.ShaderDataType.Texture2D,u_MainTex_TexelSize:t.ShaderDataType.Vector4,u_LutParams:t.ShaderDataType.Vector4},o=t.Shader3D.add("LUTBuilder");o.shaderType=t.ShaderFeatureType.PostProcess;let r=new t.SubShader(e,a);o.addSubShader(r);let s=r.addShaderPass(i,'#define SHADER_NAME LutBuilder\n#include "Color.glsl";\n#ifdef ACES\n#include "ACES.glsl";\n#endif\n#include "ColorGrading.glsl";\n#include "Tonemapping.glsl";\nvarying vec2 v_Texcoord0;vec3 lutValue(vec2 uv,vec4 params){vec3 color;uv-=params.yz;color.r=fract(uv.x*params.x);color.b=uv.x-color.r/params.x;color.g=uv.y;return color*params.w;}void main(){vec2 uv=v_Texcoord0;vec3 color=lutValue(uv,u_LutParams);color=logCToLinear(color);vec3 grade=colorGrade(color);vec3 tone=tonemap(grade);gl_FragColor=vec4(tone,1.0);}');s.renderState.depthTest=t.RenderState.DEPTHTEST_ALWAYS,s.renderState.depthWrite=!1,s.renderState.cull=t.RenderState.CULL_NONE,s.renderState.blend=t.RenderState.BLEND_DISABLE,s.statefirst=!0}static __initDefine__(){l.SHADERDEFINE_ACES=t.Shader3D.getDefineByName("ACES"),l.SHADERDEFINE_CUSTOMLUT=t.Shader3D.getDefineByName("CUSTOMLUT"),l.SHADERVALUE_LUT=t.Shader3D.propertyNameToID("u_Lut"),l.SHADERVALUE_LUTPARAMS=t.Shader3D.propertyNameToID("u_LutParams"),l.SHADERVALUE_CUSTOMLUT=t.Shader3D.propertyNameToID("u_CustomLut"),l.SHADERVALUE_CUSTOMLUTPARAMS=t.Shader3D.propertyNameToID("u_CustomLutParams")}get toneMapping(){return this._toneMapping}set toneMapping(e){e!=this._toneMapping&&(this._needBuildLUT=!0,this._toneMapping=e)}get enableSplitTone(){return this._enableSplitTone}set enableSplitTone(e){this._enableSplitTone=e,this._needBuildLUT=!0}get splitShadow(){return this._splitShadow}set splitShadow(e){this._needBuildLUT=!0,e.cloneTo(this._splitShadow)}get splithighlights(){return this._splithighlights}set splithighlights(e){this._splithighlights.equal(e)||(this._needBuildLUT=!0,e.cloneTo(this._splithighlights))}get splitBalance(){return this._splitBalance}set splitBalance(e){this._needBuildLUT=!0,this._splitBalance=e}get enableSMH(){return this._enableSMH}set enableSMH(e){this._needBuildLUT=!0,this._enableSMH=e}get shadows(){return this._shadows}set shadows(e){this._shadows.equal(e)||(this._needBuildLUT=!0,e.cloneTo(this._shadows))}get midtones(){return this._midtones}set midtones(e){this._midtones.equal(e)||(this._needBuildLUT=!0,e.cloneTo(this._midtones))}get highlights(){return this._highlights}set highlights(e){this._highlights.equal(e)||(this._needBuildLUT=!0,e.cloneTo(this._highlights))}get shadowLimitStart(){return this._limits.x}set shadowLimitStart(e){this._needBuildLUT=!0,this._limits.x=Math.min(e,this.shadowLimitEnd)}get shadowLimitEnd(){return this._limits.y}set shadowLimitEnd(e){this._needBuildLUT=!0,this._limits.y=Math.max(e,this.shadowLimitStart)}get highLightLimitStart(){return this._limits.z}set highLightLimitStart(e){this._needBuildLUT=!0,this._limits.z=Math.min(e,this.highLightLimitEnd)}get highLightLimitEnd(){return this._limits.w}set highLightLimitEnd(e){this._needBuildLUT=!0,this._limits.w=Math.max(this.highLightLimitStart,e)}get enableLiftGammaGain(){return this._enableLiftGammaGain}set enableLiftGammaGain(e){this._needBuildLUT=!0,this._enableLiftGammaGain=e}get lift(){return this._lift}set lift(e){this.lift.equal(e)||(this._needBuildLUT=!0,e.cloneTo(this._lift))}get gamma(){return this._gamma}set gamma(e){this._gamma.equal(e)||(this._needBuildLUT=!0,e.cloneTo(this._gamma))}get gain(){return this._gain}set gain(e){this._gain.equal(e)||(this._needBuildLUT=!0,e.cloneTo(this._gain))}_StandardIlluminantY(e){return 2.87*e-3*e*e-.27509507}_CIExyToLMS(e,a){let o=1*e/a,r=1*(1-e-a)/a,i=.7328*o+.4296-.1624*r,s=-.7036*o+1.6975+.0061*r,l=.003*o+.0136+.9834*r;return new t.Vector3(i,s,l)}_ColorBalanceToLMSCoeffs(e,a){let o=e/65,r=a/65,i=.31271-o*(o<0?.1:.05),s=this._StandardIlluminantY(i)+.05*r,l=new t.Vector3(.949237,1.03542,1.08728),n=this._CIExyToLMS(i,s);this._balance.set(l.x/n.x,l.y/n.y,l.z/n.z)}get enableBalance(){return this._enableBalance}set enableBalance(e){this._needBuildLUT=!0,this._enableBalance=e}get tint(){return this._tint}set tint(e){this._needBuildLUT=!0,this._tint=e,this._ColorBalanceToLMSCoeffs(this._temperature,this._tint)}get temperature(){return this._temperature}set temperature(e){this._needBuildLUT=!0,this._temperature=e,this._ColorBalanceToLMSCoeffs(this._temperature,this._tint)}get enableColorAdjust(){return this._enableColorAdjust}set enableColorAdjust(e){this._needBuildLUT=!0,this._enableColorAdjust=e}get postExposure(){return this._postExposure}set postExposure(e){this._postExposure=e}get contrast(){return this._contrast}set contrast(e){this._needBuildLUT=!0,this._contrast=e}get colorFilter(){return this._colorFilter}set colorFilter(e){this._needBuildLUT=!0,e.cloneTo(this._colorFilter)}get HueShift(){return this._HueShift}set HueShift(e){this._needBuildLUT=!0,this._HueShift=e}get saturation(){return this._saturation}set saturation(e){this._needBuildLUT=!0,this._saturation=e}constructor(){super(),this._needBuildLUT=!1,this._lutBuilderMat=new t.Material,this._lutSize=32,this._enableSplitTone=!1,this._splitShadow=new t.Vector3(.5,.5,.5),this._splitBalance=0,this._splithighlights=new t.Vector3(.5,.5,.5),this._u_SplitShadow=new t.Vector4(0,0,0),this._enableSMH=!1,this._shadows=new t.Vector3(1,1,1),this._midtones=new t.Vector3(1,1,1),this._highlights=new t.Vector3(1,1,1),this._limits=new t.Vector4(0,.33,.55,1),this._enableLiftGammaGain=!1,this._lift=new t.Vector3(0,0,0),this._gamma=new t.Vector3(1,1,1),this._gain=new t.Vector3(1,1,1),this._enableBalance=!1,this._balance=new t.Vector3,this._tint=0,this._temperature=0,this._enableColorAdjust=!1,this._postExposure=1,this._contrast=1,this._colorFilter=new t.Color(1,1,1),this._HueShift=0,this._saturation=1,this._HueSatCon=new t.Vector4(0,1,1,0),this.default_balance=new t.Vector3(1,1,1),this.default_splitShadow=new t.Vector4(.5,.5,.5,0),this.default_splithighlights=new t.Vector3(.5,.5,.5),this.default_shadow=new t.Vector3(1,1,1),this.default_midtones=new t.Vector3(1,1,1),this.default_highlight=new t.Vector3(1,1,1),this.default_limint=new t.Vector4(0,.3,.55,1),this.default_lift=new t.Vector3(0,0,0),this.default_gamma=new t.Vector3(1,1,1),this.default_gain=new t.Vector3(1,1,1),this.default_ColorFilter=new t.Color(1,1,1,1),this.default_HueSatCon=new t.Vector4(0,1,1,0),this.singleton=!0,this.active=!0,this._needBuildLUT=!0,this._toneMapping=e.ToneMappingType.None,this._blitlutParams=new t.Vector4,this._lutShaderData=t.LayaGL.renderDeviceFactory.createShaderData(null),this.lutSize=32,this._lutBuilderMat=new t.Material}get lutSize(){return this._lutSize}set lutSize(e){e>32||(this._lutSize=e,this._lutTex&&this._lutTex.destroy(),this._lutTex=new t.RenderTexture(this._lutSize*this._lutSize,this._lutSize,t.RenderTargetFormat.R16G16B16A16,null,!1,1,!1,!1),this._lutTex.anisoLevel=1,this._lutTex.wrapModeU=t.WrapMode.Clamp,this._lutTex.wrapModeV=t.WrapMode.Clamp,this._lutTex.filterMode=t.FilterMode.Bilinear)}_buildLUT(){if(!this._needBuildLUT)return;let a=this.lutSize,o=this.lutSize*this.lutSize,r=new t.Vector4(a,.5/o,.5/a,a/(a-1));this._lutBuilderMat.setVector4("u_LutParams",r),this.enableBalance?(this._ColorBalanceToLMSCoeffs(this.temperature,this.tint),this._lutBuilderMat.setVector3("u_ColorBalance",this._balance)):this._lutBuilderMat.setVector3("u_ColorBalance",this.default_balance),this.enableSplitTone?(this._u_SplitShadow.setValue(this._splitShadow.x,this._splitShadow.y,this._splitShadow.z,this.splitBalance),this._lutBuilderMat.setVector4("u_SplitShadows",this._u_SplitShadow),this._lutBuilderMat.setVector3("u_Splithighlights",this._splithighlights)):(this._lutBuilderMat.setVector4("u_SplitShadows",this.default_splitShadow),this._lutBuilderMat.setVector3("u_Splithighlights",this.default_splithighlights)),this.enableSMH?(this._lutBuilderMat.setVector3("u_Shadows",this._shadows),this._lutBuilderMat.setVector3("u_Midtones",this._midtones),this._lutBuilderMat.setVector3("u_Highlights",this._highlights),this._lutBuilderMat.setVector4("u_Limits",this._limits)):(this._lutBuilderMat.setVector3("u_Shadows",this.default_shadow),this._lutBuilderMat.setVector3("u_Midtones",this.default_midtones),this._lutBuilderMat.setVector3("u_Highlights",this.default_highlight),this._lutBuilderMat.setVector4("u_Limits",this.default_limint)),this._enableLiftGammaGain?(this._lutBuilderMat.setVector3("u_Lift",this._lift),this._lutBuilderMat.setVector3("u_Gamma",this._gamma),this._lutBuilderMat.setVector3("u_Gain",this._gain)):(this._lutBuilderMat.setVector3("u_Lift",this.default_lift),this._lutBuilderMat.setVector3("u_Gamma",this.default_gamma),this._lutBuilderMat.setVector3("u_Gain",this.default_gain)),this.enableColorAdjust?(this._HueSatCon.setValue(this._HueShift,this.saturation,this._contrast,0),this._lutBuilderMat.setColor("u_ColorFilter",this._colorFilter),this._lutBuilderMat.setVector4("u_HueSatCon",this._HueSatCon)):(this._lutBuilderMat.setColor("u_ColorFilter",this.default_ColorFilter),this._lutBuilderMat.setVector4("u_HueSatCon",this.default_HueSatCon)),this._toneMapping==e.ToneMappingType.ACES?this._lutBuilderMat.addDefine(l.SHADERDEFINE_ACES):this._lutBuilderMat.removeDefine(l.SHADERDEFINE_ACES),this._postProcess._context.command.blitScreenQuadByMaterial(t.Texture2D.whiteTexture,this._lutTex,null,this._lutBuilderMat)}effectInit(e){super.effectInit(e),this._lutBuilderMat.setShaderName("LUTBuilder"),this._LUTShader=t.Shader3D.find("blitLUTShader"),e._enableColorGrad=!0,e._ColorGradEffect=this,this._postProcess=e}release(e){super.release(e),e._enableColorGrad=!1,e._ColorGradEffect=null}render(e){let t=e.command,a=e.indirectTarget;this._blitlutParams.setValue(1/this._lutTex.width,1/this._lutTex.height,this._lutTex.height-1,this.enableColorAdjust?this._postExposure:1),this._lutBuilderMat.removeDefine(l.SHADERDEFINE_CUSTOMLUT),this._lutShaderData.setTexture(l.SHADERVALUE_LUT,this._lutTex),this._lutShaderData.setVector(l.SHADERVALUE_LUTPARAMS,this._blitlutParams),t.blitScreenTriangle(a,e.destination,null,this._LUTShader,this._lutShaderData)}}t.Laya.addInitCallback((()=>s.init())),t.Laya.addInitCallback((()=>l.init()));var n="#define SHADER_NAME SCREENVS\nvarying vec2 v_Texcoord0;vec4 remapPositionZ(vec4 position){\n#ifdef BLITSCREEN_INVERTY\nposition.y=-position.y;\n#endif\nreturn position;}void main(){gl_Position=vec4(u_OffsetScale.x*2.0-1.0+(a_PositionTexcoord.x+1.0)*u_OffsetScale.z,(1.0-((u_OffsetScale.y*2.0-1.0+(-a_PositionTexcoord.y+1.0)*u_OffsetScale.w)+1.0)/2.0)*2.0-1.0,0.0,1.0);v_Texcoord0=a_PositionTexcoord.zw;gl_Position=remapPositionZ(gl_Position);}";class c extends t.PostProcessEffect{static init(){c.SOURCESIZE=t.Shader3D.propertyNameToID("u_SourceSize"),c.ZBUFFERPARAMS=t.Shader3D.propertyNameToID("u_ZBufferParams"),c.COCPARAMS=t.Shader3D.propertyNameToID("u_CoCParams"),c.DEPTHTEXTURE=t.Shader3D.propertyNameToID("u_CameraDepthTexture"),c.NORMALDEPTHTEXTURE=t.Shader3D.propertyNameToID("u_CameraDepthNormalTexture"),c.FULLCOCTEXTURE=t.Shader3D.propertyNameToID("u_FullCoCTex"),c.DOWNSAMPLESCALE=t.Shader3D.propertyNameToID("u_DownSampleScale"),c.BLURCOCTEXTURE=t.Shader3D.propertyNameToID("u_BlurCoCTex"),c.SHADERDEFINE_DEPTHNORMALTEXTURE=t.Shader3D.getDefineByName("CAMERA_NORMALDEPTH");let e={a_PositionTexcoord:[t.VertexMesh.MESH_POSITION0,t.ShaderDataType.Vector4]},a={u_MainTex:t.ShaderDataType.Texture2D,u_MainTex_TexelSize:t.ShaderDataType.Vector4,u_OffsetScale:t.ShaderDataType.Vector4,u_ZBufferParams:t.ShaderDataType.Vector4,u_CoCParams:t.ShaderDataType.Vector3,u_FullCoCTex:t.ShaderDataType.Texture2D,u_SourceSize:t.ShaderDataType.Vector4,u_DownSampleScale:t.ShaderDataType.Vector4,u_BlurCoCTex:t.ShaderDataType.Texture2D},o=t.Shader3D.add("GaussianDoF");o.shaderType=t.ShaderFeatureType.PostProcess;let r=new t.SubShader(e,a);o.addSubShader(r);let i=r.addShaderPass(n,"#define SHADER_NAME COCFS\n#ifdef CAMERA_NORMALDEPTH\nuniform sampler2D u_CameraDepthNormalTexture;\n#else\nuniform sampler2D u_CameraDepthTexture;\n#endif\nvarying vec2 v_Texcoord0;float Linear01Depth(float z,vec4 zbufferParams){return 1.0/(zbufferParams.x*z+zbufferParams.y);}float LinearEyeDepth(float z,vec4 zbufferParams){return 1.0/(zbufferParams.z*z+zbufferParams.w);}float DecodeFloatRG(vec2 enc){vec2 kDecodeDot=vec2(1.0,1.0/255.0);return dot(enc,kDecodeDot);}void DecodeDepthNormal(vec4 enc,out float depth){depth=DecodeFloatRG(enc.zw);}void main(){vec2 uv=v_Texcoord0;\n#ifdef CAMERA_NORMALDEPTH\nvec4 depthNormal=texture2D(u_CameraDepthNormalTexture,uv);float depth=0.0;DecodeDepthNormal(depthNormal,depth);depth=((1.0/depth)-u_ZBufferParams.y)*(1.0/u_ZBufferParams.x);\n#else\nfloat depth=texture2D(u_CameraDepthTexture,uv).x;\n#endif\ndepth=LinearEyeDepth(depth,u_ZBufferParams);float farStart=u_CoCParams.x;float farEnd=u_CoCParams.y;float coc=(depth-farStart)/(farEnd-farStart);coc=clamp(coc,0.0,1.0);gl_FragColor=vec4(coc,coc,coc,1.0);}");i.statefirst=!0,i.renderState.cull=t.RenderState.CULL_NONE;let s=new t.SubShader(e,a);o.addSubShader(s);let l=s.addShaderPass(n,'#define SHADER_NAME PrefilterFS\n#include "Color.glsl";\nvarying vec2 v_Texcoord0;const int kCount=5;vec2 kTaps[5];void main(){kTaps[0]=vec2(0.0,0.0);kTaps[1]=vec2(0.9,-0.4);kTaps[2]=vec2(-0.9,0.4);kTaps[3]=vec2(0.4,0.9);kTaps[4]=vec2(-0.4,-0.9);vec3 colorAcc=vec3(0.0);float farCoCAcc=0.0;for(int i=0;i<kCount;i++){vec2 uv=u_MainTex_TexelSize.xy*kTaps[i]+v_Texcoord0;vec3 tapColor=texture2D(u_MainTex,uv).rgb;\n#ifdef Gamma_u_MainTex\ntapColor=gammaToLinear(tapColor);\n#endif\nfloat coc=texture2D(u_FullCoCTex,uv).r;colorAcc+=tapColor*coc;farCoCAcc+=coc;}vec3 color=colorAcc*(1.0/float(kCount));float farCoC=farCoCAcc*(1.0/float(kCount));gl_FragColor=vec4(color,farCoC);gl_FragColor=outputTransform(gl_FragColor);}');l.statefirst=!0,l.renderState.cull=t.RenderState.CULL_NONE;let d=new t.SubShader(e,a);o.addSubShader(d);let _=d.addShaderPass(n,'#define SHADER_NAME BlurHFS\n#include "Color.glsl";\nvarying vec2 v_Texcoord0;const int kTapCount=3;float kOffsets[3];float kCoeffs[3];vec4 Blur(vec2 dir,float premultiply){kOffsets[0]=-1.33333333;kOffsets[1]=0.00000000;kOffsets[2]=1.33333333;kCoeffs[0]=0.35294118;kCoeffs[1]=0.29411765;kCoeffs[2]=0.3529411;vec2 uv=v_Texcoord0;vec4 halfColor=texture2D(u_MainTex,uv);\n#ifdef Gamma_u_MainTex\nhalfColor=gammaToLinear(halfColor);\n#endif\nfloat samp0CoC=halfColor.a;float maxRadius=u_CoCParams.z;vec2 offset=u_SourceSize.zw*dir*samp0CoC*maxRadius;vec4 acc=vec4(0.0);for(int i=0;i<kTapCount;i++){vec2 sampCoord=uv+kOffsets[i]*offset;vec4 samp=texture2D(u_MainTex,sampCoord);\n#ifdef Gamma_u_MainTex\nsamp=gammaToLinear(samp);\n#endif\nfloat sampCoC=samp.a;vec3 sampColor=samp.rgb;float weight=clamp(1.0-(samp0CoC-sampCoC),0.0,1.0);acc+=vec4(sampColor,sampCoC)*kCoeffs[i]*weight;}acc.xyz/=acc.w+1e-4;return vec4(acc.xyz,samp0CoC);}void main(){gl_FragColor=Blur(vec2(1.0,0.0),1.0);gl_FragColor=outputTransform(gl_FragColor);}');_.statefirst=!0,_.renderState.cull=t.RenderState.CULL_NONE;let u=new t.SubShader(e,a);o.addSubShader(u);let h=u.addShaderPass(n,'#define SHADER_NAME BlurVFS\n#include "Color.glsl";\nvarying vec2 v_Texcoord0;const int kTapCount=3;float kOffsets[3];float kCoeffs[3];vec4 Blur(vec2 dir,float premultiply){kOffsets[0]=-1.33333333;kOffsets[1]=0.00000000;kOffsets[2]=1.33333333;kCoeffs[0]=0.35294118;kCoeffs[1]=0.29411765;kCoeffs[2]=0.3529411;vec2 uv=v_Texcoord0;vec4 halfColor=texture2D(u_MainTex,uv);\n#ifdef Gamma_u_MainTex\nhalfColor=gammaToLinear(halfColor);\n#endif\nfloat samp0CoC=halfColor.a;float maxRadius=u_CoCParams.z;vec2 offset=u_SourceSize.zw*dir*samp0CoC*maxRadius;vec4 acc=vec4(0.0);for(int i=0;i<kTapCount;i++){vec2 sampCoord=uv+kOffsets[i]*offset;vec4 samp=texture2D(u_MainTex,sampCoord);\n#ifdef Gamma_u_MainTex\nsamp=gammaToLinear(samp);\n#endif\nfloat sampCoC=samp.w;vec3 sampColor=samp.xyz;float weight=clamp(1.0-(samp0CoC-sampCoC),0.0,1.0);acc+=vec4(sampColor,1.0)*kCoeffs[i]*weight;}acc.xyz/=acc.w+1e-4;return vec4(acc.xyz,1.0);}void main(){gl_FragColor=Blur(vec2(0.0,1.0),0.0);gl_FragColor=outputTransform(gl_FragColor);}');h.statefirst=!0,h.renderState.cull=t.RenderState.CULL_NONE;let f=new t.SubShader(e,a);o.addSubShader(f);let m=f.addShaderPass(n,'#define SHADER_NAME CompositeFS\n#include "Color.glsl";\nvarying vec2 v_Texcoord0;void main(){vec2 uv=v_Texcoord0;\n#ifdef BLITSCREEN_INVERTY\nuv.y=1.0-uv.y;\n#endif\nvec3 baseColor=texture2D(u_MainTex,uv).rgb;\n#ifdef Gamma_u_MainTex\nbaseColor=gammaToLinear(baseColor);\n#endif\nvec4 samplevalue=texture2D(u_BlurCoCTex,uv);vec3 farColor=samplevalue.rgb;float coc=texture2D(u_FullCoCTex,uv).r;vec3 dstColor=vec3(0.0);float dstAlpha=1.0;float blend=sqrt(coc*3.14*2.0);dstColor=farColor*clamp(blend,0.0,1.0);dstAlpha=clamp(1.0-blend,0.0,1.0);gl_FragColor=vec4(baseColor*dstAlpha+dstColor,1.0);gl_FragColor=outputTransform(gl_FragColor);}');m.statefirst=!0,m.renderState.cull=t.RenderState.CULL_NONE}constructor(){super(),this._shader=t.Shader3D.find("GaussianDoF"),this._shaderData=t.LayaGL.renderDeviceFactory.createShaderData(null),this._shaderData.setVector3(c.COCPARAMS,new t.Vector3(10,30,1)),this._zBufferParams=new t.Vector4,this._sourceSize=new t.Vector4,this._dowmSampleScale=new t.Vector4}get farStart(){return this._shaderData.getVector3(c.COCPARAMS).x}set farStart(e){let t=this._shaderData.getVector3(c.COCPARAMS);t.x=e,this._shaderData.setVector3(c.COCPARAMS,t)}get farEnd(){return this._shaderData.getVector3(c.COCPARAMS).y}set farEnd(e){let t=this._shaderData.getVector3(c.COCPARAMS);t.y=Math.max(t.x,e),this._shaderData.setVector3(c.COCPARAMS,t)}get maxRadius(){return this._shaderData.getVector3(c.COCPARAMS).z}set maxRadius(e){let t=this._shaderData.getVector3(c.COCPARAMS);t.z=Math.min(e,2),this._shaderData.setVector3(c.COCPARAMS,t)}_setupShaderValue(e){let t=e.camera;this._dowmSampleScale.setValue(.5,.5,2,2),this._shaderData.setVector(c.DOWNSAMPLESCALE,this._dowmSampleScale);let a=t.farPlane,o=t.nearPlane;this._zBufferParams.setValue(1-a/o,a/o,(o-a)/(o*a),1/o),this._shaderData.setVector(c.ZBUFFERPARAMS,this._zBufferParams)}getCameraDepthTextureModeFlag(){return t.DepthTextureMode.Depth}render(e){let a=e.command;this._setupShaderValue(e);let o=e.source,r=this._shader,i=this._shaderData,s=t.RenderTargetFormat.R16G16B16A16,l=t.RenderTexture.createFromPool(o.width,o.height,s,t.RenderTargetFormat.None,!1,1);a.blitScreenTriangle(o,l,null,r,i,0),l.filterMode=t.FilterMode.Bilinear,this._shaderData.setTexture(c.FULLCOCTEXTURE,l);let n=t.RenderTexture.createFromPool(o.width/2,o.height/2,s,t.RenderTargetFormat.None,!1,1);a.blitScreenTriangle(o,n,null,r,i,1),n.filterMode=t.FilterMode.Bilinear,this._sourceSize.setValue(n.width,n.height,1/n.width,1/n.height),this._shaderData.setShaderData(c.SOURCESIZE,t.ShaderDataType.Vector4,this._sourceSize);let d=t.RenderTexture.createFromPool(n.width,n.height,s,t.RenderTargetFormat.None,!1,1);a.blitScreenTriangle(n,d,null,this._shader,this._shaderData,2);let _=t.RenderTexture.createFromPool(n.width,n.height,s,t.RenderTargetFormat.None,!1,1);a.blitScreenTriangle(d,_,null,this._shader,this._shaderData,3),_.filterMode=t.FilterMode.Bilinear,_.anisoLevel=1,l.filterMode=t.FilterMode.Point,this._shaderData.setTexture(c.BLURCOCTEXTURE,_);let u=t.RenderTexture.createFromPool(o.width,o.height,o.colorFormat,o.depthStencilFormat,!1,1);a.blitScreenTriangle(o,e.destination,null,this._shader,this._shaderData,4),t.RenderTexture.recoverToPool(l),t.RenderTexture.recoverToPool(n),t.RenderTexture.recoverToPool(d),t.RenderTexture.recoverToPool(_),e.deferredReleaseTextures.push(u)}}t.Laya.addInitCallback((()=>c.init()));class d extends t.GeometryElement{static init(){let e=.1;d.lensQuadVertices=new Float32Array([e,e,1,1,-.1,e,0,1,-.1,-.1,0,0,e,-.1,1,0]),d.lensQuadIndex=new Uint16Array([0,2,1,0,3,2]),d.vertexDeclaration=new t.VertexDeclaration(16,[new t.VertexElement(0,t.VertexElementFormat.Vector4,0)]),d.instanceVertexDeclaration=new t.VertexDeclaration(16,[new t.VertexElement(0,t.VertexElementFormat.Vector4,1)])}constructor(){super(t.MeshTopology.Triangles,t.DrawType.DrawElementInstance),this.indexFormat=t.IndexFormat.UInt16,this._createBuffer()}_createBuffer(){this._vertexBuffer=t.Laya3DRender.renderOBJCreate.createVertexBuffer3D(4*d.lensQuadVertices.length,t.BufferUsage.Dynamic,!1),this._vertexBuffer.vertexDeclaration=d.vertexDeclaration,this._vertexBuffer.setData(d.lensQuadVertices.buffer),this._instanceVertexBuffer=t.Laya3DRender.renderOBJCreate.createVertexBuffer3D(4*d.lensFlareElementMax*4,t.BufferUsage.Dynamic,!1),this._instanceVertexBuffer.instanceBuffer=!0,this._instanceVertexBuffer.vertexDeclaration=d.instanceVertexDeclaration,this._indexBuffer=t.Laya3DRender.renderOBJCreate.createIndexBuffer3D(t.IndexFormat.UInt16,d.lensQuadIndex.length,t.BufferUsage.Static,!1),this._indexBuffer.setData(d.lensQuadIndex),this.bufferState=new t.BufferState,this.bufferState.applyState([this._vertexBuffer,this._instanceVertexBuffer],this._indexBuffer),this._updateRenderParams(null)}get instanceBuffer(){return this._instanceVertexBuffer}_getType(){return d._type}_prepareRender(e){return!0}destroy(){super.destroy(),this._vertexBuffer.destroy(),this._instanceVertexBuffer.destroy(),this.bufferState.destroy(),this._indexBuffer.destroy()}_updateRenderParams(e){this.clearRenderParams(),this.setDrawElemenParams(d.lensQuadIndex.length,0)}}d.PositionUV=0,d.PositionRotationScale=1,d.lensFlareElementMax=20,d._type=t.GeometryElement._typeCounter++;class _{get instanceCount(){return this._instanceCount}set instanceCount(e){this._instanceCount=e}constructor(){this._instanceCount=1,this._transform3D=t.Laya3DRender.Render3DModuleDataFactory.createTransform(null),this._renderElement=new t.RenderElement,this._renderElement._renderElementOBJ.isRender=!0,this._lensFlareGeometry=new d,this._renderElement.setTransform(this._transform3D),this._renderElement.setGeometry(this._lensFlareGeometry),this._initMaterial()}_initMaterial(){this._materials=new t.Material,this._materials.lock=!0,this._materials.setShaderName("LensFlare"),this._materials.materialRenderMode=t.MaterialRenderMode.RENDERMODE_ADDTIVE,this._materials.depthTest=t.RenderState.DEPTHTEST_ALWAYS,this._materials.cull=t.RenderState.CULL_NONE,this._renderElement.material=this._materials,this._renderElement.subShaderIndex=0}set center(e){this._materials.setVector2("u_FlareCenter",e)}set rotate(e){this._materials.setFloat("u_rotate",e)}get lensFlareElement(){return this._lensFlareElementData}set lensFlareElement(e){this._lensFlareElementData=e,this.applyElementData()}applyElementData(){this._materials.setTexture("u_FlareTexture",this._lensFlareElementData.texture),this._materials.setColor("u_Tint",this._lensFlareElementData.tint),this._materials.setFloat("u_TintIntensity",this._lensFlareElementData.intensity),this._materials.setVector2("u_Postionoffset",this._lensFlareElementData.positionOffset),this._materials.setFloat("u_Angularoffset",this._lensFlareElementData.angularOffset),this._lensFlareElementData.autoRotate?this._materials.addDefine(m.SHADERDEFINE_AUTOROTATE):this._materials.removeDefine(m.SHADERDEFINE_AUTOROTATE),this._lensFlareGeometry.instanceCount=1;let e=new Float32Array([this._lensFlareElementData.startPosition,t.Utils.toAngle(this._lensFlareElementData.rotation),this._lensFlareElementData.scale.x,this._lensFlareElementData.scale.y]);this._lensFlareGeometry.instanceBuffer.setData(e.buffer,0,0,4*e.length)}run(e){var a=t.RenderContext3D._instance;this._materials.setFloat("u_aspectRatio",a.camera.viewport.height/a.camera.viewport.width),e.drawRenderElement(this._renderElement)}recover(){}destroy(){this._materials.lock=!1,this._materials.destroy()}}class u{static init(){let e={a_PositionTexcoord:[d.PositionUV,t.ShaderDataType.Vector4],a_DistanceRotationScale:[d.PositionRotationScale,t.ShaderDataType.Vector4]},a={u_Tint:t.ShaderDataType.Color,u_TintIntensity:t.ShaderDataType.Float,u_FlareTexture:t.ShaderDataType.Texture2D,u_FlareCenter:t.ShaderDataType.Vector2,u_aspectRatio:t.ShaderDataType.Float,u_rotate:t.ShaderDataType.Float,u_Postionoffset:t.ShaderDataType.Vector2,u_Angularoffset:t.ShaderDataType.Float},o={u_Tint:t.Color.WHITE,u_aspectRatio:1},r=t.Shader3D.add("LensFlare",!0,!1);r.shaderType=t.ShaderFeatureType.PostProcess;let i=new t.SubShader(e,a,o);r.addSubShader(i);let s=i.addShaderPass("#define SHADER_NAME LENSFLARESVS\nvarying vec2 v_Texcoord0;vec2 rotateVector(vec2 pos,vec2 center,float angle){float cosAngle=cos(angle);float sinAngle=sin(angle);vec2 offset=pos-center;vec2 rotatedOffset=vec2(offset.x*cosAngle-offset.y*sinAngle,offset.x*sinAngle+offset.y*cosAngle);return center+rotatedOffset;}vec2 rotateVec2(float rad,vec2 pos){float s=sin(rad);float c=cos(rad);float x=pos.x*c-pos.y*s;float y=pos.x*s+c*pos.y;return vec2(x,y);}vec2 scaleVec2(vec2 scale,vec2 pos){float x=scale.x*pos.x;float y=scale.y*pos.y;return vec2(x,y);}vec2 transVec2(vec2 trans,vec2 pos){float x=pos.x+trans.x;float y=pos.y+trans.y;return vec2(x,y);}void main(){vec2 center=u_FlareCenter;vec2 deltaPos=-2.0*center;vec2 lenFlarePosition=vec2(a_PositionTexcoord.x,a_PositionTexcoord.y);vec2 aspectRadio=vec2(u_aspectRatio,1.0);vec2 scale=vec2(a_DistanceRotationScale.z,a_DistanceRotationScale.w);lenFlarePosition=scaleVec2(scale,lenFlarePosition);\n#ifdef LENSFLAREAUTOROTATE\nlenFlarePosition=rotateVec2(u_rotate,lenFlarePosition);float texRotate=a_DistanceRotationScale.y;lenFlarePosition=rotateVec2(texRotate,lenFlarePosition);\n#endif\nfloat angularoffset=u_Angularoffset;lenFlarePosition=rotateVector(lenFlarePosition,center,angularoffset);lenFlarePosition=scaleVec2(aspectRadio,lenFlarePosition);lenFlarePosition=center+deltaPos*a_DistanceRotationScale.x+lenFlarePosition+u_Postionoffset;gl_Position=vec4(lenFlarePosition.x,lenFlarePosition.y,0.0,1.0);v_Texcoord0=a_PositionTexcoord.zw;}","#define SHADER_NAME LENSFLARESFS\nvarying vec2 v_Texcoord0;void main(){gl_FragColor=texture2D(u_FlareTexture,v_Texcoord0)*u_Tint*u_TintIntensity;}");s.statefirst=!0,s.renderState.cull=t.RenderState.CULL_NONE}}class h{constructor(){this._active=!0,this._tint=new t.Color(1,1,1,1),this._intensity=1,this._texture=t.Texture2D.whiteTexture,this._positionOffset=new t.Vector2(0,0),this._scale=new t.Vector2(1,1),this._autoRotate=!1,this._rotation=0,this._startPosition=0,this._angularOffset=0,this._aspectRatio=!1,this._modulateByLightColor=!1,this._translationScale=new t.Vector2(1,1)}get active(){return this._active}set active(e){this._active=e}get tint(){return this._tint}set tint(e){this._tint=e}get intensity(){return this._intensity}set intensity(e){this._intensity=e}get texture(){return this._texture}set texture(e){this._texture=e}get positionOffset(){return this._positionOffset}set positionOffset(e){this._positionOffset=e}get scale(){return this._scale}set scale(e){this._scale=e}get autoRotate(){return this._autoRotate}set autoRotate(e){this._autoRotate=e}get rotation(){return this._rotation}set rotation(e){this._rotation=e}get startPosition(){return this._startPosition}set startPosition(e){this._startPosition=e}get angularOffset(){return this._angularOffset}set angularOffset(e){this._angularOffset=e}}class f extends t.Resource{constructor(){super(!1),this.elements=[]}}class m extends t.PostProcessEffect{static __initDefine__(){m.SHADERDEFINE_AUTOROTATE=t.Shader3D.getDefineByName("LENSFLAREAUTOROTATE")}static init(){d.init(),u.init(),m.__initDefine__()}get lensFlareData(){return this._lensFlareData}set lensFlareData(e){if(e){this._flareCMDS.length=0;for(let a=0;a<e.elements.length;a++){let o=e.elements[a];if(o.active){var t=new _;t.lensFlareElement=o,this._flareCMDS.push(t)}}this._lensFlareData=e,this._needUpdate=!0}}get bindLight(){return this._light}set bindLight(e){e&&(this._light=e,this._needUpdate=!0)}get effectIntensity(){return this._effectIntensity}set effectIntensity(e){this._effectIntensity=e,this._needUpdate=!0}get effectScale(){return this._effectScale}set effectScale(e){this._effectScale=e,this._needUpdate=!0}constructor(){super(),this._effectIntensity=1,this._effectScale=1,this._needUpdate=!1,this.singleton=!1,this._flareCMDS=[],this._flareCMDS.push(new _),this._center=new t.Vector2}_updateEffectData(e){if(0!=this._flareCMDS.length){for(let t=0;t<this._flareCMDS.length;t++){if(this._flareCMDS[t].center=this._center,this._flareCMDS[t].rotate=this._rotate,this._needUpdate){let e=this._flareCMDS[t].lensFlareElement;if(!e)continue;e.intensity*=this.effectIntensity;let a=e.scale;a.setValue(a.x*this.effectScale,a.y*this.effectScale),e.scale=a,this._flareCMDS[t].applyElementData()}this._flareCMDS[t].run(e)}this._needUpdate=!1}}caculateDirCenter(e){this._light.direction.cloneTo(S),t.Vector3.scale(S,-10,S),t.Vector3.add(e.transform.position,S,S),t.Vector3.transformV3ToV4(S,e.projectionViewMatrix,p),this._center.setValue(p.x/p.w,p.y/p.w);var a=t.Utils.toAngle(Math.atan2(this._center.x,this._center.y));a=a<0?a+360:a,a=Math.round(a),this._rotate=2*Math.PI-Math.PI/180*a}caculatePointCenter(e){this._needUpdate=!0}caculateSpotCenter(e){this._needUpdate=!0}render(e){var a=e.command;let o=e.indirectTarget;if(a.setRenderTarget(o,!1,!1),this._light){switch(this._light.lightType){case t.LightType.Directional:this.caculateDirCenter(e.camera);case t.LightType.Point:case t.LightType.Spot:}Math.abs(this._center.x)>1||Math.abs(this._center.y)>1||(this._updateEffectData(a),a.blitScreenQuad(o,e.destination))}}release(e){this._needUpdate=!1}}const S=new t.Vector3,p=new t.Vector4;t.Laya.addInitCallback((()=>m.init()));class T{load(e){return e.loader.fetch(e.url,"json",e.progress.createCallback(),e.options).then((a=>{if(!a)return null;let o=new f,r=t.URL.getPath(e.url),i=[],s=a.elements;if(s)for(let a=s.length-1;a>=0;a--){let o=s[a];if(o.texture&&o.texture._$uuid&&""!=o.texture._$uuid){let a=t.URL.getResURLByUUID(o.texture._$uuid);a.startsWith("res://")||(a=t.URL.join(r,a)),i.push(e.loader.load(a).then((e=>{o.texture=e})))}o.tint&&(o.tint=new t.Color(o.tint.r,o.tint.g,o.tint.b,o.tint.a)),o.positionOffset&&(o.positionOffset=new t.Vector2(o.positionOffset.x,o.positionOffset.y)),o.scale&&(o.scale=new t.Vector2(o.scale.x,o.scale.y))}return Promise.all(i).then((()=>(o.elements=s,o)))}))}}t.Loader.registerLoader(["lensflare"],T);var v;e.AOQUALITY=void 0,(v=e.AOQUALITY||(e.AOQUALITY={}))[v.High=0]="High",v[v.MEDIUM=1]="MEDIUM",v[v.LOWEST=2]="LOWEST";class x extends t.PostProcessEffect{static init(){x.BlurDelty=t.Shader3D.propertyNameToID("u_Delty"),x.AOColor=t.Shader3D.propertyNameToID("u_AOColor"),x.aoTexture=t.Shader3D.propertyNameToID("u_compositionAoTexture"),x.AOParams=t.Shader3D.propertyNameToID("u_AOParams"),x.SourceTex=t.Shader3D.propertyNameToID("u_SourceTex"),x.SHADERDEFINE_AOHigh=t.Shader3D.getDefineByName("AO_High"),x.SHADERDEFINE_AOMEDIUM=t.Shader3D.getDefineByName("AO_MEDIUM"),x.SHADERDEFINE_LOWEST=t.Shader3D.getDefineByName("AO_LOWEST"),t.Shader3D.addInclude("AmbientOcclusion.glsl",'#include "Camera.glsl";\n#define TWO_PI 6.2831852\n#define EPSILON 1.0e-4\n#define FLT_EPSILON 1.192092896e-07\nconst float kContrast=0.6;const float kGeometryCoeff=0.8;const float kBeta=0.002;varying vec2 v_Texcoord0;\n#if defined(AO_High)\n#define SAMPLE_COUNT 12\n#elif defined(AO_MEDIUM)\n#define SAMPLE_COUNT 8\n#else\n#define SAMPLE_COUNT 4\n#endif\n#ifdef AOLOWEST\n#define SAMPLE_COUNT 8\n#endif\n#ifdef AOLOWEST\n#define SAMPLE_COUNT 8\n#endif\n#define INTENSITY u_AOParams.x\n#define RADIUS u_AOParams.y\n#define DOWNSAMPLE u_AOParams.z\nfloat PositivePow(float base,float power){return pow(max(abs(base),float(FLT_EPSILON)),power);}float CheckBounds(vec2 uv,float d){float ob=0.0;if(uv.x<0.0||uv.x>1.0||uv.y<0.0||uv.y>1.0){ob=1.0;}if(d<=0.00001){ob+=1.0;}return ob*1e8;}float SampleDepth(vec2 uv){float depthTex_Depth=SAMPLE_DEPTH_TEXTURE(u_CameraDepthTexture,uv);float depthTex_Linear01Depth=Linear01Depth(depthTex_Depth,u_ZBufferParams);return depthTex_Linear01Depth*u_ProjectionParams.y+CheckBounds(uv,depthTex_Linear01Depth);}vec3 SampleNormal(vec2 uv){vec4 col=texture2D(u_CameraDepthNormalsTexture,uv);vec3 depthNormal_Normal=DecodeViewNormalStereo(col);return depthNormal_Normal*vec3(1.0,1.0,-1.0);}float SampleDepthNormal(vec2 uv,out vec3 normal){normal=SampleNormal(uv);return SampleDepth(uv);}float CompareNormal(vec3 d1,vec3 d2){return smoothstep(kGeometryCoeff,1.0,dot(d1,d2));}vec4 PackAONormal(float ao,vec3 n){return vec4(ao,n*0.5+0.5);}vec3 GetPackedNormal(vec4 p){return p.gba*2.0-1.0;}float GetPackAO(vec4 p){return p.r;}');let e={a_PositionTexcoord:[t.VertexMesh.MESH_POSITION0,t.ShaderDataType.Vector4]},a={u_OffsetScale:t.ShaderDataType.Vector4,u_MainTex:t.ShaderDataType.Texture2D,u_MainTex_TexelSize:t.ShaderDataType.Vector4,u_Delty:t.ShaderDataType.Vector2,u_PlugTime:t.ShaderDataType.Vector4,u_AOParams:t.ShaderDataType.Vector3,u_BlurVector:t.ShaderDataType.Vector2,u_AOColor:t.ShaderDataType.Color,u_compositionAoTexture:t.ShaderDataType.Texture2D},o=t.Shader3D.add("ScalableAO");o.shaderType=t.ShaderFeatureType.PostProcess;let r=new t.SubShader(e,a);o.addSubShader(r);let s=r.addShaderPass(i,'#define SHADER_NAME OcclusionEstimationFS\n#include "DepthNormalUtil.glsl";\n#include "AmbientOcclusion.glsl";\n#define FIX_SAMPLING_PATTERN\nfloat CheckPerspective(float x){return mix(x,1.0,0.0);}vec3 ReconstructViewPos(vec2 uv,float depth,vec2 p11_22,vec2 p13_31){return vec3((uv*2.0-1.0-p13_31)/p11_22*CheckPerspective(depth),depth);}float UVRandom(float u,float v){float f=dot(vec2(12.9898,78.233),vec2(u,v));return fract(43758.5453*sin(f));}vec2 CosSin(float theta){float sn=sin(theta);float cs=cos(theta);return vec2(cs,sn);}float GradientNoise(vec2 uv){uv=floor(uv*u_MainTex_TexelSize.zw);float f=dot(vec2(0.06711056,0.00583715),uv);return fract(52.9829189*fract(f));}vec3 PickSamplePoint(vec2 uv,float index){\n#if defined(FIX_SAMPLING_PATTERN)\nfloat gn=GradientNoise(uv*DOWNSAMPLE);float u=fract(UVRandom(0.0,index+uv.x*1e-10)+gn)*2.0-1.0;float theta=(UVRandom(1.0,index+uv.x*1e-10)+gn)*TWO_PI;\n#else\nfloat u=UVRandom(uv.x+u_PlugTime.x,uv.y+index)*2.0-1.0;float theta=UVRandom(-uv.x-u_PlugTime.x,uv.y+index)*TWO_PI;\n#endif\nvec3 v=vec3(CosSin(theta)*sqrt(1.0-u*u),u);float l=sqrt((index+1.0)/float(SAMPLE_COUNT))*RADIUS;return v*l;}void main(){vec2 uv=v_Texcoord0;mat3 proj=mat3(u_Projection);vec2 p11_22=vec2(u_Projection[0][0],u_Projection[1][1]);vec2 p13_31=vec2(u_Projection[2][0],u_Projection[2][1]);vec3 norm_o;float depth_o=SampleDepthNormal(uv,norm_o);vec3 vpos_o=ReconstructViewPos(uv,depth_o,p11_22,p13_31);float ao=0.0;for(int s=0;s<int(SAMPLE_COUNT);s++){float s_float=float(s);vec3 v_s1=PickSamplePoint(uv,s_float);v_s1=faceforward(v_s1,-norm_o,v_s1);vec3 vpos_s1=vpos_o+v_s1;vec3 spos_s1=proj*vpos_s1;vec2 uv_s1_01=(spos_s1.xy/CheckPerspective(vpos_s1.z)+1.0)*0.5;float depth_s1=SampleDepth(uv_s1_01);vec3 vpos_s2=ReconstructViewPos(uv_s1_01,depth_s1,p11_22,p13_31);vec3 v_s2=vpos_s2-vpos_o;float a1=max(dot(v_s2,norm_o)-kBeta*depth_o,0.0);float a2=dot(v_s2,v_s2)+EPSILON;ao+=a1/a2;}ao*=RADIUS;ao=PositivePow(ao*INTENSITY/float(SAMPLE_COUNT),kContrast);gl_FragColor=PackAONormal(ao,norm_o);}');s.statefirst=!0,s.renderState.cull=t.RenderState.CULL_NONE,o=t.Shader3D.add("AOBlurHorizontal"),o.shaderType=t.ShaderFeatureType.PostProcess,r=new t.SubShader(e,a),o.addSubShader(r);let l=r.addShaderPass(i,"#define SHADER_NAME AOBlurHorizontal\n#define BLUR_HIGH_QUALITY 0\nvarying vec2 v_Texcoord0;vec3 GetPackedNormal(vec4 p){return p.gba*2.0-1.0;}float CompareNormal(vec3 d1,vec3 d2){return smoothstep(0.8,1.0,dot(d1,d2));}float GetPackedAO(vec4 p){return p.r;}vec4 PackAONormal(float ao,vec3 normal){return vec4(ao,normal*0.5+0.5);}void main(){vec2 delta=vec2(u_MainTex_TexelSize.x*2.0*u_Delty.x,u_Delty.y*u_MainTex_TexelSize.y*2.0);vec2 uv=v_Texcoord0;vec2 uvtran=uv;vec4 p0=texture2D(u_MainTex,uv);uvtran=uv-delta;vec4 p1a=texture2D(u_MainTex,uvtran);uvtran=uv+delta;vec4 p1b=texture2D(u_MainTex,uvtran);uvtran=uv-delta*2.0;vec4 p2a=texture2D(u_MainTex,uvtran);uvtran=uv+delta*2.0;vec4 p2b=texture2D(u_MainTex,uvtran);uvtran=uv-delta*3.2307692308;vec4 p3a=texture2D(u_MainTex,uvtran);;uvtran=uv+delta*3.2307692308;vec4 p3b=texture2D(u_MainTex,uvtran);;vec3 n0=GetPackedNormal(p0);float w0=0.37004405286;float w1a=CompareNormal(n0,GetPackedNormal(p1a))*0.31718061674;float w1b=CompareNormal(n0,GetPackedNormal(p1b))*0.31718061674;float w2a=CompareNormal(n0,GetPackedNormal(p2a))*0.19823788546;float w2b=CompareNormal(n0,GetPackedNormal(p2b))*0.19823788546;float w3a=CompareNormal(n0,GetPackedNormal(p3a))*0.11453744493;float w3b=CompareNormal(n0,GetPackedNormal(p3b))*0.11453744493;float s;s=GetPackedAO(p0)*w0;s+=GetPackedAO(p1a)*w1a;s+=GetPackedAO(p1b)*w1b;s+=GetPackedAO(p2a)*w2a;s+=GetPackedAO(p2b)*w2b;s+=GetPackedAO(p3a)*w3a;s+=GetPackedAO(p3b)*w3b;s/=w0+w1a+w1b+w2a+w2b+w3a+w3b;gl_FragColor=PackAONormal(s,n0);}");l.statefirst=!0,l.renderState.cull=t.RenderState.CULL_NONE,o=t.Shader3D.add("AOComposition"),o.shaderType=t.ShaderFeatureType.PostProcess,r=new t.SubShader(e,a),o.addSubShader(r);let n=r.addShaderPass(i,'#define SHADER_NAME AOComposition\n#include "Color.glsl";\n#define BLUR_HIGH_QUALITY 0\nvarying vec2 v_Texcoord0;vec3 GetPackedNormal(vec4 p){return p.gba*2.0-1.0;}float CompareNormal(vec3 d1,vec3 d2){return smoothstep(0.8,1.0,dot(d1,d2));}float GetPackedAO(vec4 p){return p.r;}float BlurSmall(sampler2D tex,vec2 uv,vec2 delta){vec4 p0=texture2D(tex,uv);vec2 uvtran=uv+vec2(-delta.x,-delta.y);vec4 p1=texture2D(tex,uvtran);uvtran=uv+vec2(delta.x,-delta.y);vec4 p2=texture2D(tex,uvtran);uvtran=uv+vec2(-delta.x,delta.y);vec4 p3=texture2D(tex,uvtran);uvtran=uv+delta;vec4 p4=texture2D(tex,uvtran);vec3 n0=GetPackedNormal(p0);float w0=1.0;float w1=CompareNormal(n0,GetPackedNormal(p1));float w2=CompareNormal(n0,GetPackedNormal(p2));float w3=CompareNormal(n0,GetPackedNormal(p3));float w4=CompareNormal(n0,GetPackedNormal(p4));float s;s=GetPackedAO(p0)*w0;s+=GetPackedAO(p1)*w1;s+=GetPackedAO(p2)*w2;s+=GetPackedAO(p3)*w3;s+=GetPackedAO(p4)*w4;return s/(w0+w1+w2+w3+w4);}void main(){vec2 uv=v_Texcoord0;vec2 delty=u_MainTex_TexelSize.xy;float ao=BlurSmall(u_compositionAoTexture,uv,delty);vec4 albedo=texture2D(u_MainTex,uv);\n#ifdef Gamma_u_MainTex\nalbedo=gammaToLinear(albedo);\n#endif\nvec4 aocolor=vec4(ao*u_AOColor.rgb,ao);albedo.rgb=albedo.rgb*(1.0-ao)+ao*u_AOColor.rgb*ao;gl_FragColor=albedo;gl_FragColor=outputTransform(gl_FragColor);}');n.statefirst=!0,n.renderState.cull=t.RenderState.CULL_NONE}constructor(){super(),this._aoParams=new t.Vector3,this._aoQuality=e.AOQUALITY.MEDIUM,this._shader=t.Shader3D.find("ScalableAO"),this._shaderData=t.LayaGL.renderDeviceFactory.createShaderData(null),this._aoParams=new t.Vector3(.12,.15,1),this._shaderData.setVector3(x.AOParams,this._aoParams),this._shaderData.setVector(t.BaseCamera.DEPTHZBUFFERPARAMS,new t.Vector4),this._aoBlurHorizontalShader=t.Shader3D.find("AOBlurHorizontal"),this._aoComposition=t.Shader3D.find("AOComposition"),this.aoQuality=e.AOQUALITY.MEDIUM}get aoColor(){return this._shaderData.getColor(x.AOColor)}set aoColor(e){this._shaderData.setColor(x.AOColor,e)}get intensity(){return this._aoParams.x}set intensity(e){this._aoParams.x=e,this._shaderData.setVector3(x.AOParams,this._aoParams)}get radius(){return this._aoParams.y}set radius(e){this._aoParams.y=e,this._shaderData.setVector3(x.AOParams,this._aoParams)}get aoQuality(){return this._aoQuality}set aoQuality(t){switch(this._aoQuality=t,t){case e.AOQUALITY.High:this._shaderData.addDefine(x.SHADERDEFINE_AOHigh),this._shaderData.removeDefine(x.SHADERDEFINE_AOMEDIUM),this._shaderData.removeDefine(x.SHADERDEFINE_LOWEST);break;case e.AOQUALITY.MEDIUM:this._shaderData.addDefine(x.SHADERDEFINE_AOMEDIUM),this._shaderData.removeDefine(x.SHADERDEFINE_AOHigh),this._shaderData.removeDefine(x.SHADERDEFINE_LOWEST);break;case e.AOQUALITY.LOWEST:this._shaderData.addDefine(x.SHADERDEFINE_LOWEST),this._shaderData.removeDefine(x.SHADERDEFINE_AOHigh),this._shaderData.removeDefine(x.SHADERDEFINE_AOMEDIUM)}}getCameraDepthTextureModeFlag(){return t.DepthTextureMode.DepthAndDepthNormals}render(e){let a=e.command;e.camera.viewport;let o=e.camera;o.depthTextureMode|=t.DepthTextureMode.DepthNormals,o.depthTextureMode|=t.DepthTextureMode.Depth;let r=o.depthNormalTexture,i=o.depthTexture;if(!r||!i)return;r.wrapModeU=t.WrapMode.Clamp,r.wrapModeV=t.WrapMode.Clamp;let s=e.source,l=s.width,n=s.height,c=s.colorFormat,d=t.RenderTargetFormat.None,_=t.RenderTexture.createFromPool(l,n,c,d,!1,1),u=this._shader,h=this._shaderData;a.blitScreenTriangle(e.source,_,null,u,h,0);let f=t.RenderTexture.createFromPool(l,n,c,d,!1,1);a.blitScreenTriangle(_,f,null,this._aoBlurHorizontalShader,h,0),a.setShaderDataVector2(h,x.BlurDelty,x.deltyVector),a.blitScreenTriangle(f,_,null,this._aoBlurHorizontalShader,this._shaderData,0),a.setShaderDataTexture(h,x.aoTexture,_),a.blitScreenTriangle(e.source,e.destination,null,this._aoComposition,this._shaderData,0),e.deferredReleaseTextures.push(_),e.deferredReleaseTextures.push(f)}}x.deltyHorizontal=new t.Vector2(1,0),x.deltyVector=new t.Vector2(0,1),t.Laya.addInitCallback((()=>x.init()));let g=t.ClassUtils.regClass;g("BloomEffect",o),g("GaussianDoF",c),g("ScalableAO",x),g("ColorGradEffect",l),g("LensFlareEffect",m),g("LensFlareElement",h),g("LensFlareData",f),e.ACESShaderLib=s,e.BloomEffect=o,e.ColorGradEffect=l,e.GaussianDoF=c,e.LensFlareCMD=_,e.LensFlareData=f,e.LensFlareEffect=m,e.LensFlareElement=h,e.LensFlareElementGeomtry=d,e.LensFlareSettingsLoader=T,e.LensFlareShaderInit=u,e.ScalableAO=x}(window.Laya=window.Laya||{},Laya);
//# sourceMappingURL=laya.postProcess.js.map