/******/ (() => { // webpackBootstrap
/******/ 	var __webpack_modules__ = ({

/***/ "./node_modules/filesize/dist/filesize.esm.js":
/*!****************************************************!*\
  !*** ./node_modules/filesize/dist/filesize.esm.js ***!
  \****************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   filesize: () => (/* binding */ filesize),
/* harmony export */   partial: () => (/* binding */ partial)
/* harmony export */ });
/**
 * filesize
 *
 * @copyright 2024 Jason Mulligan <jason.mulligan@avoidwork.com>
 * @license BSD-3-Clause
 * @version 10.1.6
 */
const ARRAY = "array";
const BIT = "bit";
const BITS = "bits";
const BYTE = "byte";
const BYTES = "bytes";
const EMPTY = "";
const EXPONENT = "exponent";
const FUNCTION = "function";
const IEC = "iec";
const INVALID_NUMBER = "Invalid number";
const INVALID_ROUND = "Invalid rounding method";
const JEDEC = "jedec";
const OBJECT = "object";
const PERIOD = ".";
const ROUND = "round";
const S = "s";
const SI = "si";
const SI_KBIT = "kbit";
const SI_KBYTE = "kB";
const SPACE = " ";
const STRING = "string";
const ZERO = "0";
const STRINGS = {
	symbol: {
		iec: {
			bits: ["bit", "Kibit", "Mibit", "Gibit", "Tibit", "Pibit", "Eibit", "Zibit", "Yibit"],
			bytes: ["B", "KiB", "MiB", "GiB", "TiB", "PiB", "EiB", "ZiB", "YiB"]
		},
		jedec: {
			bits: ["bit", "Kbit", "Mbit", "Gbit", "Tbit", "Pbit", "Ebit", "Zbit", "Ybit"],
			bytes: ["B", "KB", "MB", "GB", "TB", "PB", "EB", "ZB", "YB"]
		}
	},
	fullform: {
		iec: ["", "kibi", "mebi", "gibi", "tebi", "pebi", "exbi", "zebi", "yobi"],
		jedec: ["", "kilo", "mega", "giga", "tera", "peta", "exa", "zetta", "yotta"]
	}
};function filesize (arg, {
	bits = false,
	pad = false,
	base = -1,
	round = 2,
	locale = EMPTY,
	localeOptions = {},
	separator = EMPTY,
	spacer = SPACE,
	symbols = {},
	standard = EMPTY,
	output = STRING,
	fullform = false,
	fullforms = [],
	exponent = -1,
	roundingMethod = ROUND,
	precision = 0
} = {}) {
	let e = exponent,
		num = Number(arg),
		result = [],
		val = 0,
		u = EMPTY;

	// Sync base & standard
	if (standard === SI) {
		base = 10;
		standard = JEDEC;
	} else if (standard === IEC || standard === JEDEC) {
		base = 2;
	} else if (base === 2) {
		standard = IEC;
	} else {
		base = 10;
		standard = JEDEC;
	}

	const ceil = base === 10 ? 1000 : 1024,
		full = fullform === true,
		neg = num < 0,
		roundingFunc = Math[roundingMethod];

	if (typeof arg !== "bigint" && isNaN(arg)) {
		throw new TypeError(INVALID_NUMBER);
	}

	if (typeof roundingFunc !== FUNCTION) {
		throw new TypeError(INVALID_ROUND);
	}

	// Flipping a negative number to determine the size
	if (neg) {
		num = -num;
	}

	// Determining the exponent
	if (e === -1 || isNaN(e)) {
		e = Math.floor(Math.log(num) / Math.log(ceil));

		if (e < 0) {
			e = 0;
		}
	}

	// Exceeding supported length, time to reduce & multiply
	if (e > 8) {
		if (precision > 0) {
			precision += 8 - e;
		}

		e = 8;
	}

	if (output === EXPONENT) {
		return e;
	}

	// Zero is now a special case because bytes divide by 1
	if (num === 0) {
		result[0] = 0;
		u = result[1] = STRINGS.symbol[standard][bits ? BITS : BYTES][e];
	} else {
		val = num / (base === 2 ? Math.pow(2, e * 10) : Math.pow(1000, e));

		if (bits) {
			val = val * 8;

			if (val >= ceil && e < 8) {
				val = val / ceil;
				e++;
			}
		}

		const p = Math.pow(10, e > 0 ? round : 0);
		result[0] = roundingFunc(val * p) / p;

		if (result[0] === ceil && e < 8 && exponent === -1) {
			result[0] = 1;
			e++;
		}

		u = result[1] = base === 10 && e === 1 ? bits ? SI_KBIT : SI_KBYTE : STRINGS.symbol[standard][bits ? BITS : BYTES][e];
	}

	// Decorating a 'diff'
	if (neg) {
		result[0] = -result[0];
	}

	// Setting optional precision
	if (precision > 0) {
		result[0] = result[0].toPrecision(precision);
	}

	// Applying custom symbol
	result[1] = symbols[result[1]] || result[1];

	if (locale === true) {
		result[0] = result[0].toLocaleString();
	} else if (locale.length > 0) {
		result[0] = result[0].toLocaleString(locale, localeOptions);
	} else if (separator.length > 0) {
		result[0] = result[0].toString().replace(PERIOD, separator);
	}

	if (pad && round > 0) {
		const i =  result[0].toString(),
			x = separator || ((i.match(/(\D)/g) || []).pop() || PERIOD),
			tmp = i.toString().split(x),
			s = tmp[1] || EMPTY,
			l = s.length,
			n = round - l;

		result[0] = `${tmp[0]}${x}${s.padEnd(l + n, ZERO)}`;
	}

	if (full) {
		result[1] = fullforms[e] ? fullforms[e] : STRINGS.fullform[standard][e] + (bits ? BIT : BYTE) + (result[0] === 1 ? EMPTY : S);
	}

	// Returning Array, Object, or String (default)
	return output === ARRAY ? result : output === OBJECT ? {
		value: result[0],
		symbol: result[1],
		exponent: e,
		unit: u
	} : result.join(spacer);
}

// Partial application for functional programming
function partial ({
	bits = false,
	pad = false,
	base = -1,
	round = 2,
	locale = EMPTY,
	localeOptions = {},
	separator = EMPTY,
	spacer = SPACE,
	symbols = {},
	standard = EMPTY,
	output = STRING,
	fullform = false,
	fullforms = [],
	exponent = -1,
	roundingMethod = ROUND,
	precision = 0
} = {}) {
	return arg => filesize(arg, {
		bits,
		pad,
		base,
		round,
		locale,
		localeOptions,
		separator,
		spacer,
		symbols,
		standard,
		output,
		fullform,
		fullforms,
		exponent,
		roundingMethod,
		precision
	});
}

/***/ }),

/***/ "./node_modules/spectorjs/dist/spector.bundle.js":
/*!*******************************************************!*\
  !*** ./node_modules/spectorjs/dist/spector.bundle.js ***!
  \*******************************************************/
/***/ ((module) => {

!function(e,t){ true?module.exports=t():0}(self,(()=>(()=>{var e={874:(e,t)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0})},327:(e,t)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.makeEveryOtherGenerator=t.makeGenerator=void 0,t.makeGenerator=function(e){var t=function(n){return"string"==typeof n?n:null==n?"":Array.isArray(n)?n.map(t).join(""):n.type in e?e[n.type](n):"NO GENERATOR FOR ".concat(n.type)+n};return t},t.makeEveryOtherGenerator=function(e){return function(t,n){return t.reduce((function(i,r,s){return i+e(r)+(s===t.length-1?"":e(n[s]))}),"")}}},83:function(e,t,n){"use strict";var i=this&&this.__createBinding||(Object.create?function(e,t,n,i){void 0===i&&(i=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,i,r)}:function(e,t,n,i){void 0===i&&(i=n),e[i]=t[n]}),r=this&&this.__exportStar||function(e,t){for(var n in e)"default"===n||Object.prototype.hasOwnProperty.call(t,n)||i(t,e,n)};Object.defineProperty(t,"__esModule",{value:!0}),r(n(327),t),r(n(416),t),r(n(874),t)},416:(e,t)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.visit=void 0,t.visit=function(e,t){var n=function(e,i,r,s,o){var a,l=t[e.type],c=function(e,t,n,i,r){return{node:e,parent:t,parentPath:n,key:i,index:r,skip:function(){this.skipped=!0},remove:function(){this.removed=!0},replaceWith:function(e){this.replaced=e},findParent:function(e){return n?e(n)?n:n.findParent(e):n}}}(e,i,r,s,o),u=i;if(null==l?void 0:l.enter){if(l.enter(c),c.removed){if(!s||!i)throw new Error("Asked to remove ".concat(e," but no parent key was present in ").concat(i));return"number"==typeof o?u[s].splice(o,1):u[s]=null,c}if(c.replaced){if(!s||!i)throw new Error("Asked to remove ".concat(e," but no parent key was present in ").concat(i));"number"==typeof o?u[s].splice(o,1,c.replaced):u[s]=c.replaced}if(c.skipped)return c}Object.entries(e).filter((function(e){return e[0],function(e){return function(e){return!!(null==e?void 0:e.type)}(e)||Array.isArray(e)}(e[1])})).forEach((function(t){var i=t[0],r=t[1];if(Array.isArray(r))for(var s=0,o=0;s-o<r.length;s++){var a=r[s-o],l=n(a,e,c,i,s-o);(null==l?void 0:l.removed)&&(o+=1)}else n(r,e,c,i)})),null===(a=null==l?void 0:l.exit)||void 0===a||a.call(l,c)};n(e)}},851:(e,t,n)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0});var i=(0,n(83).makeGenerator)({program:function(e){return i(e.program)+i(e.wsEnd)},segment:function(e){return i(e.blocks)},text:function(e){return i(e.text)},literal:function(e){return i(e.wsStart)+i(e.literal)+i(e.wsEnd)},identifier:function(e){return i(e.identifier)+i(e.wsEnd)},binary:function(e){return i(e.left)+i(e.operator)+i(e.right)},group:function(e){return i(e.lp)+i(e.expression)+i(e.rp)},unary:function(e){return i(e.operator)+i(e.expression)},unary_defined:function(e){return i(e.operator)+i(e.lp)+i(e.identifier)+i(e.rp)},int_constant:function(e){return i(e.token)+i(e.wsEnd)},elseif:function(e){return i(e.token)+i(e.expression)+i(e.wsEnd)+i(e.body)},if:function(e){return i(e.token)+i(e.expression)+i(e.wsEnd)+i(e.body)},ifdef:function(e){return i(e.token)+i(e.identifier)+i(e.wsEnd)},ifndef:function(e){return i(e.token)+i(e.identifier)+i(e.wsEnd)},else:function(e){return i(e.token)+i(e.body)+i(e.wsEnd)},error:function(e){return i(e.error)+i(e.message)+i(e.wsEnd)},undef:function(e){return i(e.undef)+i(e.identifier)+i(e.wsEnd)},define:function(e){return i(e.wsStart)+i(e.define)+i(e.identifier)+i(e.body)+i(e.wsEnd)},define_arguments:function(e){return i(e.wsStart)+i(e.define)+i(e.identifier)+i(e.lp)+i(e.args)+i(e.rp)+i(e.body)+i(e.wsEnd)},conditional:function(e){return i(e.wsStart)+i(e.ifPart)+i(e.elseIfParts)+i(e.elsePart)+i(e.endif)+i(e.wsEnd)},version:function(e){return i(e.version)+i(e.value)+i(e.profile)+i(e.wsEnd)},pragma:function(e){return i(e.pragma)+i(e.body)+i(e.wsEnd)},line:function(e){return i(e.line)+i(e.value)+i(e.wsEnd)},extension:function(e){return i(e.extension)+i(e.name)+i(e.colon)+i(e.behavior)+i(e.wsEnd)}});t.default=i},29:function(e,t,n){"use strict";var i=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(t,"__esModule",{value:!0}),t.parser=t.preprocess=t.generate=t.preprocessComments=t.preprocessAst=void 0;var r=i(n(851));t.generate=r.default;var s=n(168);Object.defineProperty(t,"preprocessAst",{enumerable:!0,get:function(){return s.preprocessAst}}),Object.defineProperty(t,"preprocessComments",{enumerable:!0,get:function(){return s.preprocessComments}});var o=i(n(180));t.parser=o.default;var a=function(e,t){return(0,r.default)((0,s.preprocessAst)(o.default.parse(t.preserveComments?e:(0,s.preprocessComments)(e)),t))};t.preprocess=a,t.default=a},180:e=>{"use strict";function t(e,n,i,r){var s=Error.call(this,e);return Object.setPrototypeOf&&Object.setPrototypeOf(s,t.prototype),s.expected=n,s.found=i,s.location=r,s.name="SyntaxError",s}function n(e,t,n){return n=n||" ",e.length>t?e:(t-=e.length,e+(n+=n.repeat(t)).slice(0,t))}!function(e,t){function n(){this.constructor=e}n.prototype=t.prototype,e.prototype=new n}(t,Error),t.prototype.format=function(e){var t="Error: "+this.message;if(this.location){var i,r=null;for(i=0;i<e.length;i++)if(e[i].source===this.location.source){r=e[i].text.split(/\r\n|\n|\r/g);break}var s=this.location.start,o=this.location.source+":"+s.line+":"+s.column;if(r){var a=this.location.end,l=n("",s.line.toString().length),c=r[s.line-1],u=s.line===a.line?a.column:c.length+1;t+="\n --\x3e "+o+"\n"+l+" |\n"+s.line+" | "+c+"\n"+l+" | "+n("",s.column-1)+n("",u-s.column,"^")}else t+="\n at "+o}return t},t.buildMessage=function(e,t){var n={literal:function(e){return'"'+r(e.text)+'"'},class:function(e){var t=e.parts.map((function(e){return Array.isArray(e)?s(e[0])+"-"+s(e[1]):s(e)}));return"["+(e.inverted?"^":"")+t+"]"},any:function(){return"any character"},end:function(){return"end of input"},other:function(e){return e.description}};function i(e){return e.charCodeAt(0).toString(16).toUpperCase()}function r(e){return e.replace(/\\/g,"\\\\").replace(/"/g,'\\"').replace(/\0/g,"\\0").replace(/\t/g,"\\t").replace(/\n/g,"\\n").replace(/\r/g,"\\r").replace(/[\x00-\x0F]/g,(function(e){return"\\x0"+i(e)})).replace(/[\x10-\x1F\x7F-\x9F]/g,(function(e){return"\\x"+i(e)}))}function s(e){return e.replace(/\\/g,"\\\\").replace(/\]/g,"\\]").replace(/\^/g,"\\^").replace(/-/g,"\\-").replace(/\0/g,"\\0").replace(/\t/g,"\\t").replace(/\n/g,"\\n").replace(/\r/g,"\\r").replace(/[\x00-\x0F]/g,(function(e){return"\\x0"+i(e)})).replace(/[\x10-\x1F\x7F-\x9F]/g,(function(e){return"\\x"+i(e)}))}function o(e){return n[e.type](e)}return"Expected "+function(e){var t,n,i=e.map(o);if(i.sort(),i.length>0){for(t=1,n=1;t<i.length;t++)i[t-1]!==i[t]&&(i[n]=i[t],n++);i.length=n}switch(i.length){case 1:return i[0];case 2:return i[0]+" or "+i[1];default:return i.slice(0,-1).join(", ")+", or "+i[i.length-1]}}(e)+" but "+function(e){return e?'"'+r(e)+'"':"end of input"}(t)+" found."},e.exports={SyntaxError:t,parse:function(e,n){var i,r={},s=(n=void 0!==n?n:{}).grammarSource,o={start:vt},a=vt,l="#define",c="#line",u="#undef",h="#error",d="#pragma",m="defined",p="#ifdef",g="#ifndef",f="#elif",E="#else",v="#endif",_="#version",C="#extension",A="*/",R=/^[A-Za-z_]/,S=/^[A-Za-z_0-9]/,T=/^[uU]/,b=/^[1-9]/,w=/^[0-7]/,x=/^[xX]/,y=/^[0-9a-fA-F]/,L=/^[0-9]/,I=/^[\n]/,F=/^[^\n]/,N=/^[ \t]/,M=dt("<<",!1),O=dt(">>",!1),B=dt("<=",!1),$=dt(">=",!1),P=dt("==",!1),k=dt("!=",!1),D=dt("&&",!1),U=dt("||",!1),G=dt("(",!1),W=dt(")",!1),V=dt(",",!1),H=dt("!",!1),X=dt("-",!1),z=dt("~",!1),K=dt("+",!1),j=dt("*",!1),Y=dt("/",!1),q=dt("%",!1),Z=dt("<",!1),Q=dt(">",!1),J=dt("|",!1),ee=dt("^",!1),te=dt("&",!1),ne=dt(":",!1),ie=dt("#define",!1),re=(dt("#include",!1),dt("#line",!1)),se=dt("#undef",!1),oe=dt("#error",!1),ae=dt("#pragma",!1),le=dt("defined",!1),ce=dt("#if",!1),ue=dt("#ifdef",!1),he=dt("#ifndef",!1),de=dt("#elif",!1),me=dt("#else",!1),pe=dt("#endif",!1),ge=dt("#version",!1),fe=dt("#extension",!1),Ee=mt([["A","Z"],["a","z"],"_"],!1,!1),ve=mt([["A","Z"],["a","z"],"_",["0","9"]],!1,!1),_e=pt("number"),Ce=mt(["u","U"],!1,!1),Ae=mt([["1","9"]],!1,!1),Re=dt("0",!1),Se=mt([["0","7"]],!1,!1),Te=mt(["x","X"],!1,!1),be=mt([["0","9"],["a","f"],["A","F"]],!1,!1),we=mt([["0","9"]],!1,!1),xe=pt("control line"),ye=mt(["\n"],!1,!1),Le=pt("token string"),Ie=mt(["\n"],!0,!1),Fe=pt("text"),Ne=dt("#",!1),Me=pt("if"),Oe=pt("primary expression"),Be=pt("unary expression"),$e=pt("multiplicative expression"),Pe=pt("additive expression"),ke=pt("shift expression"),De=pt("relational expression"),Ue=pt("equality expression"),Ge=pt("and expression"),We=pt("exclusive or expression"),Ve=pt("inclusive or expression"),He=pt("logical and expression"),Xe=pt("logical or expression"),ze=pt("constant expression"),Ke=pt("whitespace or comment"),je=dt("//",!1),Ye=dt("/*",!1),qe=dt("*/",!1),Ze={type:"any"},Qe=pt("whitespace"),Je=mt([" ","\t"],!1,!1),et=function(e,t){return dn("literal",{literal:e,wsEnd:t})},tt=function(e,t,n){return dn("literal",{literal:t,wsStart:e,wsEnd:n})},nt=function(e){return dn("text",{text:e.join("")})},it=function(e,t,n,i,r){return dn("elseif",{token:t,expression:n,wsEnd:i,body:r})},rt=function(e,t){return gn(e,t)},st=function(e,t,n){return mn(t,n)},ot=0,at=[{line:1,column:1}],lt=0,ct=[],ut=0,ht={};if("startRule"in n){if(!(n.startRule in o))throw new Error("Can't start parsing from rule \""+n.startRule+'".');a=o[n.startRule]}function dt(e,t){return{type:"literal",text:e,ignoreCase:t}}function mt(e,t,n){return{type:"class",parts:e,inverted:t,ignoreCase:n}}function pt(e){return{type:"other",description:e}}function gt(t){var n,i=at[t];if(i)return i;for(n=t-1;!at[n];)n--;for(i={line:(i=at[n]).line,column:i.column};n<t;)10===e.charCodeAt(n)?(i.line++,i.column=1):i.column++,n++;return at[t]=i,i}function ft(e,t){var n=gt(e),i=gt(t);return{source:s,start:{offset:e,line:n.line,column:n.column},end:{offset:t,line:i.line,column:i.column}}}function Et(e){ot<lt||(ot>lt&&(lt=ot,ct=[]),ct.push(e))}function vt(){var e,t=74*ot+0,n=ht[t];return n?(ot=n.nextPos,n.result):(e=function(){var e,t,n,i=74*ot+1,s=ht[i];return s?(ot=s.nextPos,s.result):(e=ot,(t=zt())!==r?(n=cn(),e=dn("program",{program:t.blocks,wsEnd:n})):(ot=e,e=r),ht[i]={nextPos:ot,result:e},e)}(),ht[t]={nextPos:ot,result:e},e)}function _t(){var t,n,i,s=74*ot+3,o=ht[s];return o?(ot=o.nextPos,o.result):(t=ot,"<<"===e.substr(ot,2)?(n="<<",ot+=2):(n=r,0===ut&&Et(M)),n!==r?(i=cn(),t=et(n,i)):(ot=t,t=r),ht[s]={nextPos:ot,result:t},t)}function Ct(){var t,n,i,s=74*ot+4,o=ht[s];return o?(ot=o.nextPos,o.result):(t=ot,">>"===e.substr(ot,2)?(n=">>",ot+=2):(n=r,0===ut&&Et(O)),n!==r?(i=cn(),t=et(n,i)):(ot=t,t=r),ht[s]={nextPos:ot,result:t},t)}function At(){var t,n,i,s=74*ot+5,o=ht[s];return o?(ot=o.nextPos,o.result):(t=ot,"<="===e.substr(ot,2)?(n="<=",ot+=2):(n=r,0===ut&&Et(B)),n!==r?(i=cn(),t=et(n,i)):(ot=t,t=r),ht[s]={nextPos:ot,result:t},t)}function Rt(){var t,n,i,s=74*ot+6,o=ht[s];return o?(ot=o.nextPos,o.result):(t=ot,">="===e.substr(ot,2)?(n=">=",ot+=2):(n=r,0===ut&&Et($)),n!==r?(i=cn(),t=et(n,i)):(ot=t,t=r),ht[s]={nextPos:ot,result:t},t)}function St(){var t,n,i,s=74*ot+7,o=ht[s];return o?(ot=o.nextPos,o.result):(t=ot,"=="===e.substr(ot,2)?(n="==",ot+=2):(n=r,0===ut&&Et(P)),n!==r?(i=cn(),t=et(n,i)):(ot=t,t=r),ht[s]={nextPos:ot,result:t},t)}function Tt(){var t,n,i,s=74*ot+8,o=ht[s];return o?(ot=o.nextPos,o.result):(t=ot,"!="===e.substr(ot,2)?(n="!=",ot+=2):(n=r,0===ut&&Et(k)),n!==r?(i=cn(),t=et(n,i)):(ot=t,t=r),ht[s]={nextPos:ot,result:t},t)}function bt(){var t,n,i,s=74*ot+9,o=ht[s];return o?(ot=o.nextPos,o.result):(t=ot,"&&"===e.substr(ot,2)?(n="&&",ot+=2):(n=r,0===ut&&Et(D)),n!==r?(i=cn(),t=et(n,i)):(ot=t,t=r),ht[s]={nextPos:ot,result:t},t)}function wt(){var t,n,i,s=74*ot+10,o=ht[s];return o?(ot=o.nextPos,o.result):(t=ot,"||"===e.substr(ot,2)?(n="||",ot+=2):(n=r,0===ut&&Et(U)),n!==r?(i=cn(),t=et(n,i)):(ot=t,t=r),ht[s]={nextPos:ot,result:t},t)}function xt(){var t,n,i,s=74*ot+11,o=ht[s];return o?(ot=o.nextPos,o.result):(t=ot,40===e.charCodeAt(ot)?(n="(",ot++):(n=r,0===ut&&Et(G)),n!==r?(i=cn(),t=et(n,i)):(ot=t,t=r),ht[s]={nextPos:ot,result:t},t)}function yt(){var t,n,i,s=74*ot+12,o=ht[s];return o?(ot=o.nextPos,o.result):(t=ot,41===e.charCodeAt(ot)?(n=")",ot++):(n=r,0===ut&&Et(W)),n!==r?(i=cn(),t=et(n,i)):(ot=t,t=r),ht[s]={nextPos:ot,result:t},t)}function Lt(){var t,n,i,s=74*ot+13,o=ht[s];return o?(ot=o.nextPos,o.result):(t=ot,44===e.charCodeAt(ot)?(n=",",ot++):(n=r,0===ut&&Et(V)),n!==r?(i=cn(),t=et(n,i)):(ot=t,t=r),ht[s]={nextPos:ot,result:t},t)}function It(){var t,n,i,s=74*ot+15,o=ht[s];return o?(ot=o.nextPos,o.result):(t=ot,45===e.charCodeAt(ot)?(n="-",ot++):(n=r,0===ut&&Et(X)),n!==r?(i=cn(),t=et(n,i)):(ot=t,t=r),ht[s]={nextPos:ot,result:t},t)}function Ft(){var t,n,i,s=74*ot+17,o=ht[s];return o?(ot=o.nextPos,o.result):(t=ot,43===e.charCodeAt(ot)?(n="+",ot++):(n=r,0===ut&&Et(K)),n!==r?(i=cn(),t=et(n,i)):(ot=t,t=r),ht[s]={nextPos:ot,result:t},t)}function Nt(){var t,n,i,s=74*ot+18,o=ht[s];return o?(ot=o.nextPos,o.result):(t=ot,42===e.charCodeAt(ot)?(n="*",ot++):(n=r,0===ut&&Et(j)),n!==r?(i=cn(),t=et(n,i)):(ot=t,t=r),ht[s]={nextPos:ot,result:t},t)}function Mt(){var t,n,i,s=74*ot+19,o=ht[s];return o?(ot=o.nextPos,o.result):(t=ot,47===e.charCodeAt(ot)?(n="/",ot++):(n=r,0===ut&&Et(Y)),n!==r?(i=cn(),t=et(n,i)):(ot=t,t=r),ht[s]={nextPos:ot,result:t},t)}function Ot(){var t,n,i,s=74*ot+20,o=ht[s];return o?(ot=o.nextPos,o.result):(t=ot,37===e.charCodeAt(ot)?(n="%",ot++):(n=r,0===ut&&Et(q)),n!==r?(i=cn(),t=et(n,i)):(ot=t,t=r),ht[s]={nextPos:ot,result:t},t)}function Bt(){var t,n,i,s=74*ot+21,o=ht[s];return o?(ot=o.nextPos,o.result):(t=ot,60===e.charCodeAt(ot)?(n="<",ot++):(n=r,0===ut&&Et(Z)),n!==r?(i=cn(),t=et(n,i)):(ot=t,t=r),ht[s]={nextPos:ot,result:t},t)}function $t(){var t,n,i,s=74*ot+22,o=ht[s];return o?(ot=o.nextPos,o.result):(t=ot,62===e.charCodeAt(ot)?(n=">",ot++):(n=r,0===ut&&Et(Q)),n!==r?(i=cn(),t=et(n,i)):(ot=t,t=r),ht[s]={nextPos:ot,result:t},t)}function Pt(){var t,n,i,s=74*ot+23,o=ht[s];return o?(ot=o.nextPos,o.result):(t=ot,124===e.charCodeAt(ot)?(n="|",ot++):(n=r,0===ut&&Et(J)),n!==r?(i=cn(),t=et(n,i)):(ot=t,t=r),ht[s]={nextPos:ot,result:t},t)}function kt(){var t,n,i,s=74*ot+24,o=ht[s];return o?(ot=o.nextPos,o.result):(t=ot,94===e.charCodeAt(ot)?(n="^",ot++):(n=r,0===ut&&Et(ee)),n!==r?(i=cn(),t=et(n,i)):(ot=t,t=r),ht[s]={nextPos:ot,result:t},t)}function Dt(){var t,n,i,s=74*ot+25,o=ht[s];return o?(ot=o.nextPos,o.result):(t=ot,38===e.charCodeAt(ot)?(n="&",ot++):(n=r,0===ut&&Et(te)),n!==r?(i=cn(),t=et(n,i)):(ot=t,t=r),ht[s]={nextPos:ot,result:t},t)}function Ut(){var t,n,i,s,o=74*ot+27,a=ht[o];return a?(ot=a.nextPos,a.result):(t=ot,n=cn(),e.substr(ot,7)===l?(i=l,ot+=7):(i=r,0===ut&&Et(ie)),i!==r?(s=cn(),t=tt(n,i,s)):(ot=t,t=r),ht[o]={nextPos:ot,result:t},t)}function Gt(){var t,n,i,s,o=74*ot+37,a=ht[o];return a?(ot=a.nextPos,a.result):(t=ot,n=cn(),e.substr(ot,5)===f?(i=f,ot+=5):(i=r,0===ut&&Et(de)),i!==r?(s=cn(),t=tt(n,i,s)):(ot=t,t=r),ht[o]={nextPos:ot,result:t},t)}function Wt(){var t,n,i,s,o,a,l=74*ot+42,c=ht[l];if(c)return ot=c.nextPos,c.result;if(t=ot,n=ot,i=ot,R.test(e.charAt(ot))?(s=e.charAt(ot),ot++):(s=r,0===ut&&Et(Ee)),s!==r){for(o=[],S.test(e.charAt(ot))?(a=e.charAt(ot),ot++):(a=r,0===ut&&Et(ve));a!==r;)o.push(a),S.test(e.charAt(ot))?(a=e.charAt(ot),ot++):(a=r,0===ut&&Et(ve));i=s=[s,o]}else ot=i,i=r;return(n=i!==r?e.substring(n,ot):i)!==r?(i=cn(),t=dn("identifier",{identifier:n,wsEnd:i})):(ot=t,t=r),ht[l]={nextPos:ot,result:t},t}function Vt(){var t,n,i,s,o=74*ot+44,a=ht[o];return a?(ot=a.nextPos,a.result):(ut++,t=ot,n=ot,i=function(){var t,n,i,s,o,a=74*ot+46,l=ht[a];if(l)return ot=l.nextPos,l.result;if(t=ot,n=ot,b.test(e.charAt(ot))?(i=e.charAt(ot),ot++):(i=r,0===ut&&Et(Ae)),i!==r){for(s=[],o=Xt();o!==r;)s.push(o),o=Xt();n=i=[i,s]}else ot=n,n=r;return t=n!==r?e.substring(t,ot):n,ht[a]={nextPos:ot,result:t},t}(),i!==r?((s=Ht())===r&&(s=null),n=i=[i,s]):(ot=n,n=r),(t=n!==r?e.substring(t,ot):n)===r&&(t=ot,n=ot,i=function(){var t,n,i,s,o=74*ot+47,a=ht[o];if(a)return ot=a.nextPos,a.result;if(t=ot,48===e.charCodeAt(ot)?(n="0",ot++):(n=r,0===ut&&Et(Re)),n!==r){for(i=[],w.test(e.charAt(ot))?(s=e.charAt(ot),ot++):(s=r,0===ut&&Et(Se));s!==r;)i.push(s),w.test(e.charAt(ot))?(s=e.charAt(ot),ot++):(s=r,0===ut&&Et(Se));t=n=[n,i]}else ot=t,t=r;return ht[o]={nextPos:ot,result:t},t}(),i!==r?((s=Ht())===r&&(s=null),n=i=[i,s]):(ot=n,n=r),(t=n!==r?e.substring(t,ot):n)===r&&(t=ot,n=ot,i=function(){var t,n,i,s,o,a=74*ot+48,l=ht[a];if(l)return ot=l.nextPos,l.result;if(t=ot,48===e.charCodeAt(ot)?(n="0",ot++):(n=r,0===ut&&Et(Re)),n!==r)if(x.test(e.charAt(ot))?(i=e.charAt(ot),ot++):(i=r,0===ut&&Et(Te)),i!==r){for(s=[],y.test(e.charAt(ot))?(o=e.charAt(ot),ot++):(o=r,0===ut&&Et(be));o!==r;)s.push(o),y.test(e.charAt(ot))?(o=e.charAt(ot),ot++):(o=r,0===ut&&Et(be));t=n=[n,i,s]}else ot=t,t=r;else ot=t,t=r;return ht[a]={nextPos:ot,result:t},t}(),i!==r?((s=Ht())===r&&(s=null),n=i=[i,s]):(ot=n,n=r),t=n!==r?e.substring(t,ot):n)),ut--,t===r&&(n=r,0===ut&&Et(_e)),ht[o]={nextPos:ot,result:t},t)}function Ht(){var t,n=74*ot+45,i=ht[n];return i?(ot=i.nextPos,i.result):(T.test(e.charAt(ot))?(t=e.charAt(ot),ot++):(t=r,0===ut&&Et(Ce)),ht[n]={nextPos:ot,result:t},t)}function Xt(){var t,n=74*ot+49,i=ht[n];return i?(ot=i.nextPos,i.result):(L.test(e.charAt(ot))?(t=e.charAt(ot),ot++):(t=r,0===ut&&Et(we)),ht[n]={nextPos:ot,result:t},t)}function zt(){var e,t,n,i,s,o=74*ot+50,a=ht[o];if(a)return ot=a.nextPos,a.result;if(e=ot,t=[],(n=Kt())===r){if(n=ot,i=[],(s=Yt())!==r)for(;s!==r;)i.push(s),s=Yt();else i=r;i!==r&&(i=nt(i)),n=i}if(n!==r){for(;n!==r;)if(t.push(n),(n=Kt())===r){if(n=ot,i=[],(s=Yt())!==r)for(;s!==r;)i.push(s),s=Yt();else i=r;i!==r&&(i=nt(i)),n=i}}else t=r;return t!==r&&(t=dn("segment",{blocks:t})),e=t,ht[o]={nextPos:ot,result:e},e}function Kt(){var t,n,i,s,o,a,l,m,f,A,T,b,w,x=74*ot+51,y=ht[x];if(y)return ot=y.nextPos,y.result;if(ut++,t=function(){var t,n,i,s,o,a,l,c,u,h,d,m=74*ot+54,f=ht[m];if(f)return ot=f.nextPos,f.result;if(t=ot,n=ot,i=function(){var t,n,i,s=74*ot+55,o=ht[s];return o?(ot=o.nextPos,o.result):(ut++,t=ot,n=function(){var t,n,i,s,o=74*ot+35,a=ht[o];return a?(ot=a.nextPos,a.result):(t=ot,n=cn(),e.substr(ot,6)===p?(i=p,ot+=6):(i=r,0===ut&&Et(ue)),i!==r?(s=cn(),t=tt(n,i,s)):(ot=t,t=r),ht[o]={nextPos:ot,result:t},t)}(),n!==r&&(i=Wt())!==r?t=dn("ifdef",{token:n,identifier:i}):(ot=t,t=r),t===r&&(t=ot,n=function(){var t,n,i,s,o=74*ot+36,a=ht[o];return a?(ot=a.nextPos,a.result):(t=ot,n=cn(),e.substr(ot,7)===g?(i=g,ot+=7):(i=r,0===ut&&Et(he)),i!==r?(s=cn(),t=tt(n,i,s)):(ot=t,t=r),ht[o]={nextPos:ot,result:t},t)}(),n!==r&&(i=Wt())!==r?t=dn("ifndef",{token:n,identifier:i}):(ot=t,t=r),t===r&&(t=ot,n=function(){var t,n,i,s,o=74*ot+34,a=ht[o];return a?(ot=a.nextPos,a.result):(t=ot,n=cn(),"#if"===e.substr(ot,3)?(i="#if",ot+=3):(i=r,0===ut&&Et(ce)),i!==r?(s=cn(),t=tt(n,i,s)):(ot=t,t=r),ht[o]={nextPos:ot,result:t},t)}(),n!==r?((i=ln())===r&&(i=null),t=function(e,t){return dn("if",{token:e,expression:t})}(n,i)):(ot=t,t=r))),ut--,t===r&&(n=r,0===ut&&Et(Me)),ht[s]={nextPos:ot,result:t},t)}(),i!==r?(I.test(e.charAt(ot))?(s=e.charAt(ot),ot++):(s=r,0===ut&&Et(ye)),s!==r?((o=zt())===r&&(o=null),u=i,h=s,d=o,n={...u,body:d,wsEnd:h}):(ot=n,n=r)):(ot=n,n=r),n!==r){for(i=[],s=ot,(o=Gt())!==r&&(a=ln())!==r?(I.test(e.charAt(ot))?(l=e.charAt(ot),ot++):(l=r,0===ut&&Et(ye)),l!==r?((c=zt())===r&&(c=null),s=it(0,o,a,l,c)):(ot=s,s=r)):(ot=s,s=r);s!==r;)i.push(s),s=ot,(o=Gt())!==r&&(a=ln())!==r?(I.test(e.charAt(ot))?(l=e.charAt(ot),ot++):(l=r,0===ut&&Et(ye)),l!==r?((c=zt())===r&&(c=null),s=it(0,o,a,l,c)):(ot=s,s=r)):(ot=s,s=r);s=ot,o=function(){var t,n,i,s,o=74*ot+38,a=ht[o];return a?(ot=a.nextPos,a.result):(t=ot,n=cn(),e.substr(ot,5)===E?(i=E,ot+=5):(i=r,0===ut&&Et(me)),i!==r?(s=cn(),t=tt(n,i,s)):(ot=t,t=r),ht[o]={nextPos:ot,result:t},t)}(),o!==r?(I.test(e.charAt(ot))?(a=e.charAt(ot),ot++):(a=r,0===ut&&Et(ye)),a!==r?((l=zt())===r&&(l=null),s=function(e,t,n,i,r){return dn("else",{token:n,wsEnd:i,body:r})}(0,0,o,a,l)):(ot=s,s=r)):(ot=s,s=r),s===r&&(s=null),o=function(){var t,n,i,s,o=74*ot+39,a=ht[o];return a?(ot=a.nextPos,a.result):(t=ot,n=cn(),e.substr(ot,6)===v?(i=v,ot+=6):(i=r,0===ut&&Et(pe)),i!==r?(s=cn(),t=tt(n,i,s)):(ot=t,t=r),ht[o]={nextPos:ot,result:t},t)}(),o!==r?(I.test(e.charAt(ot))?(a=e.charAt(ot),ot++):(a=r,0===ut&&Et(ye)),a===r&&(a=null),t=function(e,t,n,i,r){return dn("conditional",{ifPart:e,elseIfParts:t,elsePart:n,endif:i,wsEnd:r})}(n,i,s,o,a)):(ot=t,t=r)}else ot=t,t=r;return ht[m]={nextPos:ot,result:t},t}(),t===r){if(t=ot,n=ot,(i=Ut())!==r)if((s=function(){var t,n,i,s,o,a,l=74*ot+43,c=ht[l];if(c)return ot=c.nextPos,c.result;if(t=ot,n=ot,i=ot,R.test(e.charAt(ot))?(s=e.charAt(ot),ot++):(s=r,0===ut&&Et(Ee)),s!==r){for(o=[],S.test(e.charAt(ot))?(a=e.charAt(ot),ot++):(a=r,0===ut&&Et(ve));a!==r;)o.push(a),S.test(e.charAt(ot))?(a=e.charAt(ot),ot++):(a=r,0===ut&&Et(ve));i=s=[s,o]}else ot=i,i=r;return(n=i!==r?e.substring(n,ot):i)!==r&&(n=dn("identifier",{identifier:n})),t=n,ht[l]={nextPos:ot,result:t},t}())!==r)if((o=xt())!==r){if(a=ot,(l=Wt())!==r){for(m=[],f=ot,(A=Lt())!==r&&(T=Wt())!==r?f=A=[A,T]:(ot=f,f=r);f!==r;)m.push(f),f=ot,(A=Lt())!==r&&(T=Wt())!==r?f=A=[A,T]:(ot=f,f=r);a=[l,...m.flat()]}else ot=a,a=r;a===r&&(a=null),(l=yt())!==r?((m=jt())===r&&(m=null),n=function(e,t,n,i,r,s){return dn("define_arguments",{define:e,identifier:t,lp:n,args:i||[],rp:r,body:s})}(i,s,o,a,l,m)):(ot=n,n=r)}else ot=n,n=r;else ot=n,n=r;else ot=n,n=r;if(n===r&&(n=ot,(i=Ut())!==r&&(s=Wt())!==r?((o=jt())===r&&(o=null),n=function(e,t,n){return dn("define",{define:e,identifier:t,body:n})}(i,s,o)):(ot=n,n=r),n===r)){if(n=ot,i=function(){var t,n,i,s,o=74*ot+29,a=ht[o];return a?(ot=a.nextPos,a.result):(t=ot,n=cn(),e.substr(ot,5)===c?(i=c,ot+=5):(i=r,0===ut&&Et(re)),i!==r?(s=cn(),t=tt(n,i,s)):(ot=t,t=r),ht[o]={nextPos:ot,result:t},t)}(),i!==r){if(s=ot,o=[],(a=Xt())!==r)for(;a!==r;)o.push(a),a=Xt();else o=r;(s=o!==r?e.substring(s,ot):o)!==r?n=dn("line",{line:i,value:s}):(ot=n,n=r)}else ot=n,n=r;n===r&&(n=ot,i=function(){var t,n,i,s,o=74*ot+30,a=ht[o];return a?(ot=a.nextPos,a.result):(t=ot,n=cn(),e.substr(ot,6)===u?(i=u,ot+=6):(i=r,0===ut&&Et(se)),i!==r?(s=cn(),t=tt(n,i,s)):(ot=t,t=r),ht[o]={nextPos:ot,result:t},t)}(),i!==r&&(s=Wt())!==r?n=dn("undef",{undef:i,identifier:s}):(ot=n,n=r),n===r&&(n=ot,i=function(){var t,n,i,s,o=74*ot+31,a=ht[o];return a?(ot=a.nextPos,a.result):(t=ot,n=cn(),e.substr(ot,6)===h?(i=h,ot+=6):(i=r,0===ut&&Et(oe)),i!==r?(s=cn(),t=tt(n,i,s)):(ot=t,t=r),ht[o]={nextPos:ot,result:t},t)}(),i!==r&&(s=jt())!==r?n=dn("error",{error:i,message:s}):(ot=n,n=r),n===r&&(n=ot,i=function(){var t,n,i,s,o=74*ot+32,a=ht[o];return a?(ot=a.nextPos,a.result):(t=ot,n=cn(),e.substr(ot,7)===d?(i=d,ot+=7):(i=r,0===ut&&Et(ae)),i!==r?(s=cn(),t=tt(n,i,s)):(ot=t,t=r),ht[o]={nextPos:ot,result:t},t)}(),i!==r&&(s=jt())!==r?n=dn("pragma",{pragma:i,body:s}):(ot=n,n=r),n===r&&(n=ot,i=function(){var t,n,i,s,o=74*ot+40,a=ht[o];return a?(ot=a.nextPos,a.result):(t=ot,n=cn(),e.substr(ot,8)===_?(i=_,ot+=8):(i=r,0===ut&&Et(ge)),i!==r?(s=cn(),t=tt(n,i,s)):(ot=t,t=r),ht[o]={nextPos:ot,result:t},t)}(),i!==r&&(s=Vt())!==r?((o=jt())===r&&(o=null),n=dn("version",{version:i,value:s,profile:o})):(ot=n,n=r),n===r&&(n=ot,i=function(){var t,n,i,s,o=74*ot+41,a=ht[o];return a?(ot=a.nextPos,a.result):(t=ot,n=cn(),e.substr(ot,10)===C?(i=C,ot+=10):(i=r,0===ut&&Et(fe)),i!==r?(s=cn(),t=tt(n,i,s)):(ot=t,t=r),ht[o]={nextPos:ot,result:t},t)}(),i!==r&&(s=Wt())!==r?(o=function(){var t,n,i,s=74*ot+26,o=ht[s];return o?(ot=o.nextPos,o.result):(t=ot,58===e.charCodeAt(ot)?(n=":",ot++):(n=r,0===ut&&Et(ne)),n!==r?(i=cn(),t=et(n,i)):(ot=t,t=r),ht[s]={nextPos:ot,result:t},t)}(),o!==r&&(a=jt())!==r?n=dn("extension",{extension:i,name:s,colon:o,behavior:a}):(ot=n,n=r)):(ot=n,n=r))))))}n!==r?(I.test(e.charAt(ot))?(i=e.charAt(ot),ot++):(i=r,0===ut&&Et(ye)),i===r&&(i=null),b=n,w=i,t={...b,wsEnd:w}):(ot=t,t=r)}return ut--,t===r&&(n=r,0===ut&&Et(xe)),ht[x]={nextPos:ot,result:t},t}function jt(){var t,n,i,s=74*ot+52,o=ht[s];if(o)return ot=o.nextPos,o.result;if(ut++,t=ot,n=[],F.test(e.charAt(ot))?(i=e.charAt(ot),ot++):(i=r,0===ut&&Et(Ie)),i!==r)for(;i!==r;)n.push(i),F.test(e.charAt(ot))?(i=e.charAt(ot),ot++):(i=r,0===ut&&Et(Ie));else n=r;return t=n!==r?e.substring(t,ot):n,ut--,t===r&&(n=r,0===ut&&Et(Le)),ht[s]={nextPos:ot,result:t},t}function Yt(){var t,n,i,s,o,a,l=74*ot+53,c=ht[l];if(c)return ot=c.nextPos,c.result;if(ut++,t=ot,n=ot,i=ot,ut++,s=ot,(o=hn())===r&&(o=null),35===e.charCodeAt(ot)?(a="#",ot++):(a=r,0===ut&&Et(Ne)),a!==r?s=o=[o,a]:(ot=s,s=r),ut--,s===r?i=void 0:(ot=i,i=r),i!==r){if(s=[],F.test(e.charAt(ot))?(o=e.charAt(ot),ot++):(o=r,0===ut&&Et(Ie)),o!==r)for(;o!==r;)s.push(o),F.test(e.charAt(ot))?(o=e.charAt(ot),ot++):(o=r,0===ut&&Et(Ie));else s=r;s!==r?(I.test(e.charAt(ot))?(o=e.charAt(ot),ot++):(o=r,0===ut&&Et(ye)),o===r&&(o=null),n=i=[i,s,o]):(ot=n,n=r)}else ot=n,n=r;return n===r&&(I.test(e.charAt(ot))?(n=e.charAt(ot),ot++):(n=r,0===ut&&Et(ye))),t=n!==r?e.substring(t,ot):n,ut--,t===r&&(n=r,0===ut&&Et(Fe)),ht[l]={nextPos:ot,result:t},t}function qt(){var e,t,n,i,s=74*ot+56,o=ht[s];return o?(ot=o.nextPos,o.result):(ut++,(e=function(){var e,t,n,i=74*ot+2,s=ht[i];return s?(ot=s.nextPos,s.result):(e=ot,(t=Vt())!==r?(n=cn(),e=dn("int_constant",{token:t,wsEnd:n})):(ot=e,e=r),ht[i]={nextPos:ot,result:e},e)}())===r&&(e=ot,(t=xt())!==r&&(n=ln())!==r&&(i=yt())!==r?e=dn("group",{lp:t,expression:n,rp:i}):(ot=e,e=r),e===r&&(e=Wt())),ut--,e===r&&(t=r,0===ut&&Et(Oe)),ht[s]={nextPos:ot,result:e},e)}function Zt(){var t,n,i,s,o,a=74*ot+57,l=ht[a];return l?(ot=l.nextPos,l.result):(ut++,t=ot,n=function(){var t,n,i,s,o=74*ot+33,a=ht[o];return a?(ot=a.nextPos,a.result):(t=ot,n=cn(),e.substr(ot,7)===m?(i=m,ot+=7):(i=r,0===ut&&Et(le)),i!==r?(s=cn(),t=tt(n,i,s)):(ot=t,t=r),ht[o]={nextPos:ot,result:t},t)}(),n!==r&&(i=xt())!==r&&(s=Wt())!==r&&(o=yt())!==r?t=dn("unary_defined",{operator:n,lp:i,identifier:s,rp:o}):(ot=t,t=r),t===r&&(t=ot,(n=Ft())===r&&(n=It())===r&&(n=function(){var t,n,i,s=74*ot+14,o=ht[s];return o?(ot=o.nextPos,o.result):(t=ot,33===e.charCodeAt(ot)?(n="!",ot++):(n=r,0===ut&&Et(H)),n!==r?(i=cn(),t=et(n,i)):(ot=t,t=r),ht[s]={nextPos:ot,result:t},t)}(),n===r&&(n=function(){var t,n,i,s=74*ot+16,o=ht[s];return o?(ot=o.nextPos,o.result):(t=ot,126===e.charCodeAt(ot)?(n="~",ot++):(n=r,0===ut&&Et(z)),n!==r?(i=cn(),t=et(n,i)):(ot=t,t=r),ht[s]={nextPos:ot,result:t},t)}())),n!==r&&(i=Zt())!==r?t=dn("unary",{operator:n,expression:i}):(ot=t,t=r),t===r&&(t=qt())),ut--,t===r&&(n=r,0===ut&&Et(Be)),ht[a]={nextPos:ot,result:t},t)}function Qt(){var e,t,n,i,s,o,a=74*ot+58,l=ht[a];if(l)return ot=l.nextPos,l.result;if(ut++,e=ot,(t=Zt())!==r){for(n=[],i=ot,(s=Nt())===r&&(s=Mt())===r&&(s=Ot()),s!==r&&(o=Zt())!==r?i=s=[s,o]:(ot=i,i=r);i!==r;)n.push(i),i=ot,(s=Nt())===r&&(s=Mt())===r&&(s=Ot()),s!==r&&(o=Zt())!==r?i=s=[s,o]:(ot=i,i=r);e=rt(t,n)}else ot=e,e=r;return ut--,e===r&&(t=r,0===ut&&Et($e)),ht[a]={nextPos:ot,result:e},e}function Jt(){var e,t,n,i,s,o,a=74*ot+59,l=ht[a];if(l)return ot=l.nextPos,l.result;if(ut++,e=ot,(t=Qt())!==r){for(n=[],i=ot,(s=Ft())===r&&(s=It()),s!==r&&(o=Qt())!==r?i=s=[s,o]:(ot=i,i=r);i!==r;)n.push(i),i=ot,(s=Ft())===r&&(s=It()),s!==r&&(o=Qt())!==r?i=s=[s,o]:(ot=i,i=r);e=rt(t,n)}else ot=e,e=r;return ut--,e===r&&(t=r,0===ut&&Et(Pe)),ht[a]={nextPos:ot,result:e},e}function en(){var e,t,n,i,s,o,a=74*ot+60,l=ht[a];if(l)return ot=l.nextPos,l.result;if(ut++,e=ot,(t=Jt())!==r){for(n=[],i=ot,(s=Ct())===r&&(s=_t()),s!==r&&(o=Jt())!==r?i=s=[s,o]:(ot=i,i=r);i!==r;)n.push(i),i=ot,(s=Ct())===r&&(s=_t()),s!==r&&(o=Jt())!==r?i=s=[s,o]:(ot=i,i=r);e=rt(t,n)}else ot=e,e=r;return ut--,e===r&&(t=r,0===ut&&Et(ke)),ht[a]={nextPos:ot,result:e},e}function tn(){var e,t,n,i,s,o,a=74*ot+61,l=ht[a];if(l)return ot=l.nextPos,l.result;if(ut++,e=ot,(t=en())!==r){for(n=[],i=ot,(s=At())===r&&(s=Rt())===r&&(s=Bt())===r&&(s=$t()),s!==r&&(o=en())!==r?i=s=[s,o]:(ot=i,i=r);i!==r;)n.push(i),i=ot,(s=At())===r&&(s=Rt())===r&&(s=Bt())===r&&(s=$t()),s!==r&&(o=en())!==r?i=s=[s,o]:(ot=i,i=r);e=rt(t,n)}else ot=e,e=r;return ut--,e===r&&(t=r,0===ut&&Et(De)),ht[a]={nextPos:ot,result:e},e}function nn(){var e,t,n,i,s,o,a=74*ot+62,l=ht[a];if(l)return ot=l.nextPos,l.result;if(ut++,e=ot,(t=tn())!==r){for(n=[],i=ot,(s=St())===r&&(s=Tt()),s!==r&&(o=tn())!==r?i=s=[s,o]:(ot=i,i=r);i!==r;)n.push(i),i=ot,(s=St())===r&&(s=Tt()),s!==r&&(o=tn())!==r?i=s=[s,o]:(ot=i,i=r);e=rt(t,n)}else ot=e,e=r;return ut--,e===r&&(t=r,0===ut&&Et(Ue)),ht[a]={nextPos:ot,result:e},e}function rn(){var e,t,n,i,s,o,a=74*ot+63,l=ht[a];if(l)return ot=l.nextPos,l.result;if(ut++,e=ot,(t=nn())!==r){for(n=[],i=ot,(s=Dt())!==r&&(o=nn())!==r?i=s=[s,o]:(ot=i,i=r);i!==r;)n.push(i),i=ot,(s=Dt())!==r&&(o=nn())!==r?i=s=[s,o]:(ot=i,i=r);e=rt(t,n)}else ot=e,e=r;return ut--,e===r&&(t=r,0===ut&&Et(Ge)),ht[a]={nextPos:ot,result:e},e}function sn(){var e,t,n,i,s,o,a=74*ot+64,l=ht[a];if(l)return ot=l.nextPos,l.result;if(ut++,e=ot,(t=rn())!==r){for(n=[],i=ot,(s=kt())!==r&&(o=rn())!==r?i=s=[s,o]:(ot=i,i=r);i!==r;)n.push(i),i=ot,(s=kt())!==r&&(o=rn())!==r?i=s=[s,o]:(ot=i,i=r);e=rt(t,n)}else ot=e,e=r;return ut--,e===r&&(t=r,0===ut&&Et(We)),ht[a]={nextPos:ot,result:e},e}function on(){var e,t,n,i,s,o,a=74*ot+65,l=ht[a];if(l)return ot=l.nextPos,l.result;if(ut++,e=ot,(t=sn())!==r){for(n=[],i=ot,(s=Pt())!==r&&(o=sn())!==r?i=s=[s,o]:(ot=i,i=r);i!==r;)n.push(i),i=ot,(s=Pt())!==r&&(o=sn())!==r?i=s=[s,o]:(ot=i,i=r);e=rt(t,n)}else ot=e,e=r;return ut--,e===r&&(t=r,0===ut&&Et(Ve)),ht[a]={nextPos:ot,result:e},e}function an(){var e,t,n,i,s,o,a=74*ot+66,l=ht[a];if(l)return ot=l.nextPos,l.result;if(ut++,e=ot,(t=on())!==r){for(n=[],i=ot,(s=bt())!==r&&(o=on())!==r?i=s=[s,o]:(ot=i,i=r);i!==r;)n.push(i),i=ot,(s=bt())!==r&&(o=on())!==r?i=s=[s,o]:(ot=i,i=r);e=rt(t,n)}else ot=e,e=r;return ut--,e===r&&(t=r,0===ut&&Et(He)),ht[a]={nextPos:ot,result:e},e}function ln(){var e,t=74*ot+68,n=ht[t];return n?(ot=n.nextPos,n.result):(ut++,e=function(){var e,t,n,i,s,o,a=74*ot+67,l=ht[a];if(l)return ot=l.nextPos,l.result;if(ut++,e=ot,(t=an())!==r){for(n=[],i=ot,(s=wt())!==r&&(o=an())!==r?i=s=[s,o]:(ot=i,i=r);i!==r;)n.push(i),i=ot,(s=wt())!==r&&(o=an())!==r?i=s=[s,o]:(ot=i,i=r);e=rt(t,n)}else ot=e,e=r;return ut--,e===r&&(t=r,0===ut&&Et(Xe)),ht[a]={nextPos:ot,result:e},e}(),ut--,e===r&&0===ut&&Et(ze),ht[t]={nextPos:ot,result:e},e)}function cn(){var e,t,n,i,s,o,a=74*ot+69,l=ht[a];if(l)return ot=l.nextPos,l.result;for(ut++,e=ot,(t=hn())===r&&(t=null),n=[],i=ot,(s=un())!==r?((o=hn())===r&&(o=null),i=s=[s,o]):(ot=i,i=r);i!==r;)n.push(i),i=ot,(s=un())!==r?((o=hn())===r&&(o=null),i=s=[s,o]):(ot=i,i=r);return e=pn(t,n),ut--,t=r,0===ut&&Et(Ke),ht[a]={nextPos:ot,result:e},e}function un(){var t,n,i,s,o,a,l=74*ot+70,c=ht[l];if(c)return ot=c.nextPos,c.result;if(t=function(){var t,n,i,s,o,a=74*ot+71,l=ht[a];if(l)return ot=l.nextPos,l.result;if(t=ot,n=ot,"//"===e.substr(ot,2)?(i="//",ot+=2):(i=r,0===ut&&Et(je)),i!==r){for(s=[],F.test(e.charAt(ot))?(o=e.charAt(ot),ot++):(o=r,0===ut&&Et(Ie));o!==r;)s.push(o),F.test(e.charAt(ot))?(o=e.charAt(ot),ot++):(o=r,0===ut&&Et(Ie));n=i=[i,s]}else ot=n,n=r;return t=n!==r?e.substring(t,ot):n,ht[a]={nextPos:ot,result:t},t}(),t===r)if(t=ot,n=function(){var t,n,i,s,o,a,l,c=74*ot+72,u=ht[c];if(u)return ot=u.nextPos,u.result;if(t=ot,n=ot,"/*"===e.substr(ot,2)?(i="/*",ot+=2):(i=r,0===ut&&Et(Ye)),i!==r){for(s=[],o=ot,a=ot,ut++,e.substr(ot,2)===A?(l=A,ot+=2):(l=r,0===ut&&Et(qe)),ut--,l===r?a=void 0:(ot=a,a=r),a!==r?(e.length>ot?(l=e.charAt(ot),ot++):(l=r,0===ut&&Et(Ze)),l!==r?o=l:(ot=o,o=r)):(ot=o,o=r);o!==r;)s.push(o),o=ot,a=ot,ut++,e.substr(ot,2)===A?(l=A,ot+=2):(l=r,0===ut&&Et(qe)),ut--,l===r?a=void 0:(ot=a,a=r),a!==r?(e.length>ot?(l=e.charAt(ot),ot++):(l=r,0===ut&&Et(Ze)),l!==r?o=l:(ot=o,o=r)):(ot=o,o=r);e.substr(ot,2)===A?(o=A,ot+=2):(o=r,0===ut&&Et(qe)),o!==r?n=i=[i,s,o]:(ot=n,n=r)}else ot=n,n=r;return t=n!==r?e.substring(t,ot):n,ht[c]={nextPos:ot,result:t},t}(),n!==r){for(i=[],s=ot,(o=hn())!==r&&(a=un())!==r?s=st(0,o,a):(ot=s,s=r);s!==r;)i.push(s),s=ot,(o=hn())!==r&&(a=un())!==r?s=st(0,o,a):(ot=s,s=r);t=mn(n,i.flat())}else ot=t,t=r;return ht[l]={nextPos:ot,result:t},t}function hn(){var t,n,i,s=74*ot+73,o=ht[s];if(o)return ot=o.nextPos,o.result;if(ut++,t=ot,n=[],N.test(e.charAt(ot))?(i=e.charAt(ot),ot++):(i=r,0===ut&&Et(Je)),i!==r)for(;i!==r;)n.push(i),N.test(e.charAt(ot))?(i=e.charAt(ot),ot++):(i=r,0===ut&&Et(Je));else n=r;return t=n!==r?e.substring(t,ot):n,ut--,t===r&&(n=r,0===ut&&Et(Qe)),ht[s]={nextPos:ot,result:t},t}const dn=(e,t)=>({type:e,...t}),mn=(...e)=>e.flat().filter((e=>null!=e&&""!==e&&0!==e.length)),pn=(...e)=>{return(t=mn(e)).length>1?t:t[0];var t},gn=(...e)=>e.flat().reduce(((e,[t,n])=>({type:"binary",operator:t,left:e,right:n})));if((i=a())!==r&&ot===e.length)return i;throw i!==r&&ot<e.length&&Et({type:"end"}),fn=ct,En=lt<e.length?e.charAt(lt):null,vn=lt<e.length?ft(lt,lt+1):ft(lt,lt),new t(t.buildMessage(fn,En),fn,En,vn);var fn,En,vn}}},168:function(e,t,n){"use strict";var i=this&&this.__assign||function(){return i=Object.assign||function(e){for(var t,n=1,i=arguments.length;n<i;n++)for(var r in t=arguments[n])Object.prototype.hasOwnProperty.call(t,r)&&(e[r]=t[r]);return e},i.apply(this,arguments)},r=this&&this.__spreadArray||function(e,t,n){if(n||2===arguments.length)for(var i,r=0,s=t.length;r<s;r++)!i&&r in t||(i||(i=Array.prototype.slice.call(t,0,r)),i[r]=t[r]);return e.concat(i||Array.prototype.slice.call(t))};Object.defineProperty(t,"__esModule",{value:!0}),t.preprocessComments=t.preprocessAst=void 0;var s=n(416),o=function(e){for(var t=[],n=1;n<arguments.length;n++)t[n-1]=arguments[n];return Object.entries(e).reduce((function(e,n){var r,s=n[0],o=n[1];return i(i({},e),!t.includes(s)&&((r={})[s]=o,r))}),{})};t.preprocessComments=function(e){var t,n,i,r="",s=1,o=0,a=0;for(t=0;t<e.length;t++)n=e.substr(t,1),i=e.substr(t+1,1),"/"!=n||"/"!=i||o||a?("\n"==n&&o&&(o=0),"/"!=n||"*"!=i||a||o?"*"==n&&"/"==i&&a?(a==s&&(r+=" "),a=0,t++):(a||o)&&"\n"!=n||(r+=n,s++):(a=s,t++)):(o=s,t++);return r};var a=function(e){return e.replace(/\s+##\s+/g,"")},l=function(e,t){return Object.entries(t).reduce((function(e,n){var i=n[0],r=n[1];return r.args?function(e,t,n,i){for(var r,s="\\b".concat(t,"\\s*\\("),c=new RegExp(s,"m"),u="",h=i,d=function(){var i=function(e){for(var t,n=0,i=[],r="",s=0;s<e.length;s++){if("("===(t=e.charAt(s))&&n++,")"===t&&n--,-1===n)return(""!==r||i.length)&&i.push(r),{args:i,length:s};","===t&&0===n?(i.push(r),r=""):r+=t}return null}(h.substring(r.index+r[0].length));if(null===i)throw new Error("".concat(h.match(c)," unterminated macro invocation"));var s=(n.args||[]).filter((function(e){return","!==e.literal})),d=i.args,m=i.length,p=r[0].length+m+1;if(d.length>s.length)throw new Error("'".concat(t,"': Too many arguments for macro"));if(d.length<s.length)throw new Error("'".concat(t,"': Not enough arguments for macro"));var g=a(s.reduce((function(e,t,n){return e.replace(new RegExp("\\b".concat(t.identifier,"\\b"),"g"),d[n].trim())}),n.body)),f=l(g,o(e,t)),E=r.index+f.length,v=h.replace(h.substr(r.index,p),f);u+=v.substr(0,E),h=v.substr(E)};r=c.exec(h);)d();return u+h}(t,i,r,e):function(e,t,n,i){var r=i;if(new RegExp("\\b".concat(t,"\\b"),"g").test(i)){var s=n.body||"",c=a(i.replace(new RegExp("\\b".concat(t,"\\b"),"g"),s));r=l(c,o(e,t))}return r}(t,i,r,e)}),e)},c=function(e){return!!e},u=function(e){for(var t=[],n=1;n<arguments.length;n++)t[n-1]=arguments[n];t.forEach((function(t){d(t,{unary_defined:{enter:function(e){e.skip()}},identifier:{enter:function(t){t.node.identifier=l(t.node.identifier,e)}}})}))},h=function(e,t){return n={int_constant:function(e){return parseInt(e.token,10)},unary_defined:function(e){return e.identifier.identifier in t},identifier:function(e){return e.identifier},group:function(e,t){return t(e.expression)},binary:function(e,t){var n=e.left,i=e.right,r=e.operator.literal;switch(r){case"*":return t(n)*t(i);case"/":return t(n)/t(i);case"%":return t(n)%t(i);case"+":return t(n)+t(i);case"-":return t(n)-t(i);case"<<":return t(n)<<t(i);case">>":return t(n)>>t(i);case"<":return t(n)<t(i);case">":return t(n)>t(i);case"<=":return t(n)<=t(i);case">=":return t(n)>=t(i);case"==":return t(n)==t(i);case"!=":return t(n)!=t(i);case"&":return t(n)&t(i);case"^":return t(n)^t(i);case"|":return t(n)|t(i);case"&&":return t(n)&&t(i);case"||":return t(n)||t(i);default:throw new Error("Preprocessing error: Unknown binary operator ".concat(r))}},unary:function(e,t){switch(e.operator.literal){case"+":return t(e.expression);case"-":return-1*t(e.expression);case"!":return!t(e.expression);case"~":return~t(e.expression);default:throw new Error("Preprocessing error: Unknown unary operator ".concat(e.operator.literal))}}},i=function(e){var t=n[e.type];if(!t)throw new Error("No evaluate() evaluator for ".concat(e.type));return t(e,i)},i(e);var n,i},d=s.visit;t.preprocessAst=function(e,t){void 0===t&&(t={});var n,s=Object.entries(t.defines||{}).reduce((function(e,t){var n,r=t[0],s=t[1];return i(i({},e),((n={})[r]={body:s},n))}),{}),o=(void 0===(n=t.preserve)&&(n={}),function(e){var t=null==n?void 0:n[e.node.type];return"function"==typeof t?t(e):t});return d(e,{conditional:{enter:function(e){var t=e,n=t.node;o(t)||(u.apply(void 0,r([s],r([n.ifPart.expression],n.elseIfParts.map((function(e){return e.expression})),!0).filter(c),!1)),function(e,t){return"if"===t.type?h(t.expression,e):"ifdef"===t.type?t.identifier.identifier in e:"ifndef"===t.type?!(t.identifier.identifier in e):void 0}(s,n.ifPart)?t.replaceWith(n.ifPart.body):n.elseIfParts.reduce((function(e,n){return e||h(n.expression,s)&&(t.replaceWith(n.body),!0)}),!1)||(n.elsePart?t.replaceWith(n.elsePart.body):t.remove()))}},text:{enter:function(e){var t=e;t.node.text=l(t.node.text,s)}},define_arguments:{enter:function(e){var t=e,n=t.node,i=n.identifier.identifier,r=n.body,a=n.args;s[i]={args:a,body:r},!o(t)&&t.remove()}},define:{enter:function(e){var t=e,n=t.node,i=n.identifier.identifier,r=n.body;s[i]={body:r},!o(t)&&t.remove()}},undef:{enter:function(e){var t=e;delete s[t.node.identifier.identifier],!o(t)&&t.remove()}},error:{enter:function(e){var n=e;if(t.stopOnError)throw new Error(n.node.message);!o(n)&&n.remove()}},pragma:{enter:function(e){var t=e;!o(t)&&t.remove()}},version:{enter:function(e){var t=e;!o(t)&&t.remove()}},extension:{enter:function(e){var t=e;!o(t)&&t.remove()}},line:{enter:function(e){var t=e;!o(t)&&t.remove()}}}),e}},866:(e,t,n)=>{"use strict";n.d(t,{Z:()=>a});var i=n(81),r=n.n(i),s=n(645),o=n.n(s)()(r());o.push([e.id,"@import url(https://fonts.googleapis.com/css?family=Montserrat:300,400);"]),o.push([e.id,'.captureMenuComponent{position:absolute;padding:7px;z-index:99999;top:10px;left:50%;margin-left:-209px;height:40px;width:400px;border:2px solid #222;background-color:#2c2c2c;visibility:hidden;display:none;color:#f9f9f9;font-family:Consolas,monaco,monospace;font-size:14px;font-weight:500}.captureMenuComponent.active{visibility:visible;display:block}.captureMenuComponent,.captureMenuComponent:after,.captureMenuComponent:before{box-sizing:content-box}.captureMenuLogComponent{position:absolute;padding:7px;z-index:80000;top:66px;left:50%;margin-left:-209px;height:40px;width:400px;border:2px solid #222;background-color:#2c2c2c;visibility:hidden;display:none;color:#f9f9f9;font-family:Consolas,monaco,monospace;font-size:14px;font-weight:500}.captureMenuLogComponent.active{visibility:visible;display:block}.captureMenuLogComponent,.captureMenuLogComponent:after,.captureMenuLogComponent:before{box-sizing:content-box}.captureMenuLogComponent span.error{color:red}.canvasListComponent{float:left;width:50%;height:100%}.canvasListComponent [commandName=onCanvasSelection]{vertical-align:center;line-height:40px;white-space:nowrap;text-overflow:ellipsis;width:190px;display:inline-block;overflow:hidden;margin:0px 5px}.canvasListComponent [commandName=onCanvasSelection]:hover{color:#c9c9c9;cursor:pointer;transition:color .3s;-webkit-transition:color .3s;-moz-transition:color .3s}.canvasListComponent ul{margin:0px;padding:7px;list-style:none;position:absolute;top:54px;left:-2px;width:400px;border:2px solid #222;background-color:#2c2c2c}.canvasListComponent ul li{margin:5px}.canvasListComponent ul li:hover{color:#c9c9c9;cursor:pointer;transition:color .3s;-webkit-transition:color .3s;-moz-transition:color .3s}.captureMenuActionsComponent{float:left;width:30%;height:100%;margin-top:7.5px}.captureMenuActionsComponent div{float:left}.captureMenuActionsComponent [commandName=onCaptureRequested]{border-radius:50%;background:#2c2c2c;border:2px solid red;width:21px;height:21px}.captureMenuActionsComponent [commandName=onCaptureRequested]:hover{background:red;cursor:pointer;transition:background .3s;-webkit-transition:background .3s;-moz-transition:background .3s}.captureMenuActionsComponent [commandName=onPlayRequested],.captureMenuActionsComponent [commandName=onPlayNextFrameRequested]{width:21px;height:21px;border:2px solid #f9f9f9;border-radius:50%;margin-left:9px}.captureMenuActionsComponent [commandName=onPlayRequested]:before,.captureMenuActionsComponent [commandName=onPlayNextFrameRequested]:before{content:"";position:absolute;display:inline-block;margin-top:6px;margin-left:4px;width:7px;height:7px;border-top:2px solid #f9f9f9;border-right:2px solid #f9f9f9;background-color:#f9f9f9;-moz-transform:rotate(45deg);-webkit-transform:rotate(45deg);transform:rotate(45deg);z-index:-20}.captureMenuActionsComponent [commandName=onPlayRequested]:after,.captureMenuActionsComponent [commandName=onPlayNextFrameRequested]:after{content:"";position:absolute;display:inline-block;width:8px;height:20px;background-color:#2c2c2c;z-index:-10}.captureMenuActionsComponent [commandName=onPlayRequested]:hover,.captureMenuActionsComponent [commandName=onPlayNextFrameRequested]:hover{cursor:pointer;border:2px solid #c9c9c9;transition:border .3s;-webkit-transition:border .3s;-moz-transition:border .3s}.captureMenuActionsComponent [commandName=onPauseRequested]{width:21px;height:21px;border:2px solid #f9f9f9;border-radius:50%;margin-left:9px}.captureMenuActionsComponent [commandName=onPauseRequested]:before{content:"";position:absolute;display:inline-block;width:2px;height:13px;margin-left:12px;margin-top:4px;background-color:#f9f9f9}.captureMenuActionsComponent [commandName=onPauseRequested]:after{content:"";position:absolute;display:inline-block;width:2px;height:13px;margin-left:7px;margin-top:4px;background-color:#f9f9f9}.captureMenuActionsComponent [commandName=onPauseRequested]:hover{cursor:pointer;border:2px solid #c9c9c9;transition:border .3s;-webkit-transition:border .3s;-moz-transition:border .3s}.captureMenuActionsComponent [commandName=onPlayNextFrameRequested]:before{background-color:#2c2c2c}.fpsCounterComponent{float:left;width:20%;vertical-align:center;line-height:40px;white-space:nowrap}',""]);const a=o},625:(e,t,n)=>{"use strict";n.d(t,{Z:()=>a});var i=n(81),r=n.n(i),s=n(645),o=n.n(s)()(r());o.push([e.id,"@import url(https://fonts.googleapis.com/css?family=Montserrat:300,400);"]),o.push([e.id,'.resultViewComponent{position:absolute;z-index:99999;border:1px solid #000;top:0;left:0;bottom:0;right:0;background-color:#222;opacity:1;visibility:hidden;display:none;color:#f9f9f9;font-family:Consolas,monaco,monospace;font-size:14px;font-weight:500}.resultViewComponent.active{visibility:visible;display:block}.resultViewComponent,.resultViewComponent:after,.resultViewComponent:before{box-sizing:content-box}.resultViewMenuComponent{font-family:"Montserrat",sans-serif;font-size:13px;font-weight:300;line-height:40px;flex:1 100%;display:flex;flex-flow:row wrap;height:42px;outline:0 none;border-bottom:2px solid #222;box-sizing:border-box;list-style:none;margin:0;background:#2c2c2c;display:-webkit-box;display:-moz-box;display:-ms-flexbox;display:-webkit-flex;display:flex;-webkit-flex-flow:row wrap;flex-flow:row wrap;justify-content:flex-end}.resultViewMenuComponent .resultViewMenuOpen{display:none;visibility:hidden}.resultViewMenuComponent a{outline:0 none;text-decoration:none;display:block;padding:0 20px 0 20px;color:#ccc;background:#2c2c2c;box-sizing:border-box;height:100%}.resultViewMenuComponent a.active{background:#222;color:#fff;font-weight:400;border-bottom:2px solid #f0640d}.resultViewMenuComponent a:hover{background:#222;color:#c9c9c9;cursor:pointer;transition:color .3s;-webkit-transition:color .3s;-moz-transition:color .3s}.resultViewMenuComponent a:hover.active{color:#f0640d;transition:color 0;-webkit-transition:color 0;-moz-transition:color 0}.resultViewMenuComponent a.clearSearch{padding:0px;margin-left:-30px;margin-right:20px;z-index:9000;color:#f9f9f9}.resultViewMenuComponent a.clearSearch:hover{background:#2c2c2c;color:#f0640d}@media all and (max-width: 1024px){.resultViewMenuComponent{padding:0px;position:absolute;overflow-y:visible;top:0px;left:0px;right:0px;bottom:0px;z-index:999999;display:block}.resultViewMenuComponent .resultViewMenuOpen{display:block;visibility:visible}.resultViewMenuComponent li:not(.resultViewMenuSmall){display:none;visibility:hidden}.resultViewMenuComponent li{background:#2c2c2c}.resultViewMenuComponent li.searchContainer{background:#464646}.resultViewMenuComponent a.active{background:#2c2c2c}}.resultViewMenuComponent input{border:0;font-family:"Montserrat",sans-serif;font-weight:300;padding:0 20px 0 20px;background:#464646;color:#f9f9f9;height:40px;position:relative;top:-1px;box-sizing:border-box}.resultViewMenuComponent input:focus{border:0;outline:0 none}.resultViewMenuComponent .clearSearch{position:relative;background:rgba(0,0,0,0);display:inline;padding:0px;margin-left:-30px;z-index:9000;color:#f0640d}.resultViewMenuComponent .clearSearch:hover{background:rgba(0,0,0,0) !important}.resultViewMenuComponent ::-webkit-input-placeholder{color:#ccc}.resultViewMenuComponent :-moz-placeholder{color:#ccc}.resultViewMenuComponent ::-moz-placeholder{color:#ccc}.resultViewMenuComponent :-ms-input-placeholder{color:#ccc}.resultViewContentComponent{position:absolute;top:40px;left:0;bottom:0;right:0}.informationColumnLeftComponent{position:absolute;top:0;left:0;bottom:0;right:50%;overflow:auto;overflow-x:hidden;overflow-y:visible}.informationColumnRightComponent{position:absolute;top:0;left:50%;bottom:0;right:0;overflow:auto;overflow-x:hidden;overflow-y:visible}.captureListComponent{position:absolute;top:40px;left:0;bottom:0;right:0;background:#222;z-index:9000;display:none;visibility:hidden;overflow-y:visible;overflow-x:hidden}.captureListComponent.active{display:block;visibility:visible}.captureListComponent .openCaptureFile{border:1px dashed #f9f9f9;display:block;margin:5px;padding:5px;text-align:center;font-style:italic}.captureListComponent .openCaptureFile span{line-height:100%;vertical-align:middle}.captureListComponent ul{margin:0px;padding:0px;list-style:none;display:-webkit-box;display:-moz-box;display:-ms-flexbox;display:-webkit-flex;display:flex;-webkit-flex-flow:row wrap;flex-flow:row wrap;justify-content:flex-start}.captureListComponent ul li{margin:5px;border:1px solid #606060}.captureListComponent ul li img{width:295px;background-image:-webkit-gradient(linear, 0 100%, 100% 0, color-stop(0.25, #c9c9c9), color-stop(0.25, transparent)),-webkit-gradient(linear, 0 0, 100% 100%, color-stop(0.25, #c9c9c9), color-stop(0.25, transparent)),-webkit-gradient(linear, 0 100%, 100% 0, color-stop(0.75, transparent), color-stop(0.75, #c9c9c9)),-webkit-gradient(linear, 0 0, 100% 100%, color-stop(0.75, transparent), color-stop(0.75, #c9c9c9));background-image:-moz-linear-gradient(45deg, #d9d9d9 25%, transparent 25%),-moz-linear-gradient(-45deg, #d9d9d9 25%, transparent 25%),-moz-linear-gradient(45deg, transparent 75%, #d9d9d9 75%),-moz-linear-gradient(-45deg, transparent 75%, #d9d9d9 75%);-webkit-background-size:50px 51px;-moz-background-size:50px 50px;background-size:50px 50px;background-position:0 0,25px 0,25px -25px,0px 25px;display:block}.captureListComponent ul li span{display:block;text-align:center;border:5px solid #222}.captureListComponent ul li span .captureListItemSave{color:#f9f9f9;font-size:16px;margin-left:10px;position:relative;padding:3px 8px 3px 32px}.captureListComponent ul li span .captureListItemSave:before,.captureListComponent ul li span .captureListItemSave:after{box-sizing:border-box;content:"";position:absolute}.captureListComponent ul li span .captureListItemSave:before{background:#d9d9d9;border-color:#f9f9f9;border-style:solid;border-width:7px 2px 1px;border-radius:1px;height:16px;left:8px;top:5px;width:16px}.captureListComponent ul li span .captureListItemSave:after{background:#f9f9f9;border-color:#d9d9d9;border-style:solid;border-width:1px 1px 1px 4px;height:5px;left:13px;top:5px;width:7px}.captureListComponent ul li:hover{cursor:pointer}.captureListComponent ul li.active span{background:#f0640d;border:5px solid #f0640d}.captureListComponent ul li.active span .captureListItemSave:before{background:#f0640d}.captureListComponent ul li.active span .captureListItemSave:after{border-color:#f0640d}.visualStateListComponent{position:absolute;top:0;left:0;bottom:0;padding:5px;right:80%;overflow-y:visible;overflow-x:hidden}.visualStateListComponent ul{margin:0px;padding:0px;list-style:none}.visualStateListComponent ul li{margin:20px 15px 0px 15px;border:1px solid #606060}.visualStateListComponent ul li img{display:block;padding:0px;box-sizing:border-box;max-height:600px;width:100%;margin:0 auto;background-image:-webkit-gradient(linear, 0 100%, 100% 0, color-stop(0.25, #c9c9c9), color-stop(0.25, transparent)),-webkit-gradient(linear, 0 0, 100% 100%, color-stop(0.25, #c9c9c9), color-stop(0.25, transparent)),-webkit-gradient(linear, 0 100%, 100% 0, color-stop(0.75, transparent), color-stop(0.75, #c9c9c9)),-webkit-gradient(linear, 0 0, 100% 100%, color-stop(0.75, transparent), color-stop(0.75, #c9c9c9));background-image:-moz-linear-gradient(45deg, #d9d9d9 25%, transparent 25%),-moz-linear-gradient(-45deg, #d9d9d9 25%, transparent 25%),-moz-linear-gradient(45deg, transparent 75%, #d9d9d9 75%),-moz-linear-gradient(-45deg, transparent 75%, #d9d9d9 75%);-webkit-background-size:50px 51px;-moz-background-size:50px 50px;background-size:50px 50px;background-position:0 0,25px 0,25px -25px,0px 25px}.visualStateListComponent ul li:hover{cursor:pointer}.visualStateListComponent ul li span{border:5px solid #222;background:#222;box-sizing:border-box;display:inline-block;width:100%;margin:0px;padding:5px;word-wrap:break-word}.visualStateListComponent ul li.active{border:2px solid #f0640d}.commandListComponent{position:absolute;top:0;left:20%;right:40%;bottom:0;color:#d3d3d3}.commandListComponent ul{margin:0px;padding:0px;list-style:none;overflow-y:visible;overflow-x:hidden;height:100%}.commandListComponent ul li{padding:8px}.commandListComponent ul li span{word-wrap:break-word;line-height:22px}.commandListComponent ul li:hover{color:#f9f9f9;cursor:pointer;transition:color .3s;-webkit-transition:color .3s;-moz-transition:color .3s}.commandListComponent ul li:nth-child(even){background:#2c2c2c}.commandListComponent ul li:nth-child(odd){background:#222}.commandListComponent ul li .important{font-weight:800}.commandListComponent ul li .important.deprecated{color:red}.commandListComponent ul li .important.unused{color:#ff0}.commandListComponent ul li .important.disabled{color:gray}.commandListComponent ul li .important.redundant{color:orange}.commandListComponent ul li .important.valid{color:#adff2f}.commandListComponent ul li .marker{font-size:16px;font-weight:900;color:#adff2f}.commandListComponent ul li.active{background:#f37628;color:#222}.commandListComponent ul li.drawCall{background:#5db0d7;color:#222}.commandListComponent ul li a{margin-left:5px;margin-right:5px;color:#5db0d7;background:#222;padding:5px;font-weight:900;display:inline-block}.commandDetailComponent{position:absolute;top:0;left:60%;right:0;bottom:0;overflow-y:visible;overflow-x:hidden}.jsonGroupComponent{display:block;margin:10px;padding:10px;padding-bottom:5px}.jsonGroupComponent .jsonGroupComponentTitle{display:block;font-size:16px;color:#5db0d7;border-bottom:1px solid #5db0d7;padding-bottom:5px;margin-bottom:5px;text-transform:capitalize}.jsonGroupComponent ul{margin:0px;padding:0px;list-style:none}.jsonGroupComponent ul li:nth-child(even){background:#222}.jsonGroupComponent ul li:nth-child(odd){background:#222}.jsonItemComponentKey{color:#f0640d}.jsonItemComponentValue{white-space:pre-wrap}.jsonItemImageHolder{width:50%;margin:auto}.jsonItemImageHolder .jsonItemImage{margin:5px;display:block;border:1px solid #606060;width:100%}.jsonItemImageHolder .jsonItemImage img{width:100%;display:block;margin:auto;max-width:256px;background-image:-webkit-gradient(linear, 0 100%, 100% 0, color-stop(0.25, #c9c9c9), color-stop(0.25, transparent)),-webkit-gradient(linear, 0 0, 100% 100%, color-stop(0.25, #c9c9c9), color-stop(0.25, transparent)),-webkit-gradient(linear, 0 100%, 100% 0, color-stop(0.75, transparent), color-stop(0.75, #c9c9c9)),-webkit-gradient(linear, 0 0, 100% 100%, color-stop(0.75, transparent), color-stop(0.75, #c9c9c9));background-image:-moz-linear-gradient(45deg, #d9d9d9 25%, transparent 25%),-moz-linear-gradient(-45deg, #d9d9d9 25%, transparent 25%),-moz-linear-gradient(45deg, transparent 75%, #d9d9d9 75%),-moz-linear-gradient(-45deg, transparent 75%, #d9d9d9 75%);-webkit-background-size:50px 51px;-moz-background-size:50px 50px;background-size:50px 50px;background-position:0 0,25px 0,25px -25px,0px 25px}.jsonItemImageHolder .jsonItemImage span{margin:0px;padding:5px;word-wrap:break-word;display:inline-block;width:100%;box-sizing:border-box}[commandName=onOpenSourceClicked]:hover{color:#f9f9f9;cursor:pointer;transition:color .3s;-webkit-transition:color .3s;-moz-transition:color .3s}.jsonVisualStateItemComponent{text-align:center;padding:10px}.jsonVisualStateItemComponent img{background-image:-webkit-gradient(linear, 0 100%, 100% 0, color-stop(0.25, #c9c9c9), color-stop(0.25, transparent)),-webkit-gradient(linear, 0 0, 100% 100%, color-stop(0.25, #c9c9c9), color-stop(0.25, transparent)),-webkit-gradient(linear, 0 100%, 100% 0, color-stop(0.75, transparent), color-stop(0.75, #c9c9c9)),-webkit-gradient(linear, 0 0, 100% 100%, color-stop(0.75, transparent), color-stop(0.75, #c9c9c9));background-image:-moz-linear-gradient(45deg, #d9d9d9 25%, transparent 25%),-moz-linear-gradient(-45deg, #d9d9d9 25%, transparent 25%),-moz-linear-gradient(45deg, transparent 75%, #d9d9d9 75%),-moz-linear-gradient(-45deg, transparent 75%, #d9d9d9 75%);-webkit-background-size:50px 51px;-moz-background-size:50px 50px;background-size:50px 50px;background-position:0 0,25px 0,25px -25px,0px 25px;border:1px solid #606060;margin:5px;width:100%;max-width:512px;max-height:800px}.jsonVisualStateItemComponent span{display:block}.jsonContentComponent{position:absolute;top:0;left:0;right:0;bottom:0;padding:10px;overflow-y:visible;overflow-x:hidden}.jsonItemComponentValue{word-break:break-all;white-space:normal}.jsonSourceItemComponentOpen{font-weight:bold;color:#5db0d7;text-decoration:underline}.sourceCodeMenuComponentContainer{position:absolute;left:0;top:0;bottom:48px;right:40%}.sourceCodeMenuComponentFooter{position:absolute;left:0;right:40%;bottom:0;padding:0 15px}.sourceCodeMenuComponent{font-family:"Montserrat",sans-serif;font-size:13px;font-weight:300;line-height:40px;flex:1 100%;display:flex;flex-flow:row wrap;height:42px;outline:0 none;border-bottom:2px solid #222;box-sizing:border-box;list-style:none;margin:0;background:#2c2c2c;display:-webkit-box;display:-moz-box;display:-ms-flexbox;display:-webkit-flex;display:flex;-webkit-flex-flow:row wrap;flex-flow:row wrap;justify-content:flex-end}.sourceCodeMenuComponent .resultViewMenuOpen{display:none;visibility:hidden}.sourceCodeMenuComponent a{outline:0 none;text-decoration:none;display:block;padding:0 20px 0 20px;color:#ccc;background:#2c2c2c;box-sizing:border-box;height:100%}.sourceCodeMenuComponent a.active{background:#222;color:#fff;font-weight:400;border-bottom:2px solid #f0640d}.sourceCodeMenuComponent a:hover{background:#222;color:#c9c9c9;cursor:pointer;transition:color .3s;-webkit-transition:color .3s;-moz-transition:color .3s}.sourceCodeMenuComponent a:hover.active{color:#f0640d;transition:color 0;-webkit-transition:color 0;-moz-transition:color 0}.sourceCodeMenuComponent a.clearSearch{display:inline-block;padding:0px;margin-left:-30px;margin-right:20px;z-index:9000;color:#f9f9f9}.sourceCodeMenuComponent a.clearSearch:hover{background:#2c2c2c;color:#f0640d}.sourceCodeMenuComponent input{border:0;font-family:"Montserrat",sans-serif;font-weight:300;padding:0 20px 0 20px;background:#464646;color:#f9f9f9;height:100%;position:relative;top:-1px;box-sizing:border-box}.sourceCodeMenuComponent input:focus{border:0;outline:0 none}.sourceCodeMenuComponent .clearSearch{position:relative;background:rgba(0,0,0,0);display:inline;padding:0px;margin-left:-30px;z-index:9000;color:#f0640d}.sourceCodeMenuComponent .clearSearch:hover{background:rgba(0,0,0,0) !important}.sourceCodeMenuComponent ::-webkit-input-placeholder{color:#ccc}.sourceCodeMenuComponent :-moz-placeholder{color:#ccc}.sourceCodeMenuComponent ::-moz-placeholder{color:#ccc}.sourceCodeMenuComponent :-ms-input-placeholder{color:#ccc}.sourceCodeComponent{position:absolute;top:42px;left:0;bottom:48px;right:40%;background:#222;z-index:9000;overflow-x:visible;overflow:auto}.sourceCodeComponent .sourceCodeComponentTitle{font-size:16px;font-weight:800;line-height:50px;color:#f0640d;padding:1em;margin:.5em 0}',""]);const a=o},827:(e,t,n)=>{"use strict";n.d(t,{Z:()=>a});var i=n(81),r=n.n(i),s=n(645),o=n.n(s)()(r());o.push([e.id,".ace-monokai {\r\n    color: #f9f9f9;\r\n    font-size: 14px;\r\n}\r\n\r\n.ace-monokai .ace_entity.ace_name.ace_tag,\r\n.ace-monokai .ace_keyword,\r\n.ace-monokai .ace_meta.ace_tag,\r\n.ace-monokai .ace_storage {\r\n    color: #F0640D\r\n}\r\n\r\n.ace-monokai .ace_constant.ace_character,\r\n.ace-monokai .ace_constant.ace_other {\r\n    color: #5db0d7;\r\n}\r\n\r\n.ace-monokai .ace_marker-layer .ace_selection {\r\n    background: #a6e22e\r\n}\r\n\r\n.ace-monokai .ace_marker-layer .ace_bracket {\r\n    margin: -1px 0 0 -1px;\r\n    border: 1px solid #a6e22e;\r\n}\r\n\r\n.ace-monokai .ace_marker-layer .ace_active-line {\r\n    background: #2c2c2c\r\n}\r\n.ace-monokai .ace_gutter-active-line {\r\n    background-color: #2c2c2c\r\n}\r\n.ace-monokai .ace_marker-layer .ace_selected-word {\r\n    border: 1px solid #a6e22e\r\n}\r\n\r\n.ace-monokai .ace_constant.ace_language {\r\n    color: #e6db74\r\n}\r\n.ace-monokai .ace_constant.ace_numeric {\r\n    color: #ae81ff\r\n}\r\n\r\n.ace-monokai .ace_gutter {\r\n    background: #222;\r\n    color: #8F908A;\r\n}",""]);const a=o},645:e=>{"use strict";e.exports=function(e){var t=[];return t.toString=function(){return this.map((function(t){var n="",i=void 0!==t[5];return t[4]&&(n+="@supports (".concat(t[4],") {")),t[2]&&(n+="@media ".concat(t[2]," {")),i&&(n+="@layer".concat(t[5].length>0?" ".concat(t[5]):""," {")),n+=e(t),i&&(n+="}"),t[2]&&(n+="}"),t[4]&&(n+="}"),n})).join("")},t.i=function(e,n,i,r,s){"string"==typeof e&&(e=[[null,e,void 0]]);var o={};if(i)for(var a=0;a<this.length;a++){var l=this[a][0];null!=l&&(o[l]=!0)}for(var c=0;c<e.length;c++){var u=[].concat(e[c]);i&&o[u[0]]||(void 0!==s&&(void 0===u[5]||(u[1]="@layer".concat(u[5].length>0?" ".concat(u[5]):""," {").concat(u[1],"}")),u[5]=s),n&&(u[2]?(u[1]="@media ".concat(u[2]," {").concat(u[1],"}"),u[2]=n):u[2]=n),r&&(u[4]?(u[1]="@supports (".concat(u[4],") {").concat(u[1],"}"),u[4]=r):u[4]="".concat(r)),t.push(u))}},t}},81:e=>{"use strict";e.exports=function(e){return e[1]}},819:(e,t,n)=>{e=n.nmd(e),function(){var e=function(){return this}();e||"undefined"==typeof window||(e=window);var t=function(e,n,i){"string"==typeof e?(2==arguments.length&&(i=n),t.modules[e]||(t.payloads[e]=i,t.modules[e]=null)):t.original?t.original.apply(this,arguments):(console.error("dropping module because define wasn't a string."),console.trace())};t.modules={},t.payloads={};var n,i=function(e,t,n){if("string"==typeof t){var i=o(e,t);if(null!=i)return n&&n(),i}else if("[object Array]"===Object.prototype.toString.call(t)){for(var s=[],a=0,l=t.length;a<l;++a){var c=o(e,t[a]);if(null==c&&r.original)return;s.push(c)}return n&&n.apply(null,s)||!0}},r=function(e,t){var n=i("",e,t);return null==n&&r.original?r.original.apply(this,arguments):n},s=function(e,t){if(-1!==t.indexOf("!")){var n=t.split("!");return s(e,n[0])+"!"+s(e,n[1])}if("."==t.charAt(0))for(t=e.split("/").slice(0,-1).join("/")+"/"+t;-1!==t.indexOf(".")&&i!=t;){var i=t;t=t.replace(/\/\.\//,"/").replace(/[^\/]+\/\.\.\//,"")}return t},o=function(e,n){n=s(e,n);var r=t.modules[n];if(!r){if("function"==typeof(r=t.payloads[n])){var o={},a={id:n,uri:"",exports:o,packaged:!0};o=r((function(e,t){return i(n,e,t)}),o,a)||a.exports,t.modules[n]=o,delete t.payloads[n]}r=t.modules[n]=o||r}return r};n=e, true&&(e.ace||(e.ace={}),n=e.ace),n.define&&n.define.packaged||(t.original=n.define,n.define=t,n.define.packaged=!0),n.require&&n.require.packaged||(r.original=n.require,n.require=r,n.require.packaged=!0)}(),ace.define("ace/lib/regexp",["require","exports","module"],(function(e,t,n){"use strict";var i,r={exec:RegExp.prototype.exec,test:RegExp.prototype.test,match:String.prototype.match,replace:String.prototype.replace,split:String.prototype.split},s=void 0===r.exec.call(/()??/,"")[1],o=(i=/^/g,r.test.call(i,""),!i.lastIndex);function a(e){return(e.global?"g":"")+(e.ignoreCase?"i":"")+(e.multiline?"m":"")+(e.extended?"x":"")+(e.sticky?"y":"")}function l(e,t,n){if(Array.prototype.indexOf)return e.indexOf(t,n);for(var i=n||0;i<e.length;i++)if(e[i]===t)return i;return-1}o&&s||(RegExp.prototype.exec=function(e){var t,n,i=r.exec.apply(this,arguments);if("string"==typeof e&&i){if(!s&&i.length>1&&l(i,"")>-1&&(n=RegExp(this.source,r.replace.call(a(this),"g","")),r.replace.call(e.slice(i.index),n,(function(){for(var e=1;e<arguments.length-2;e++)void 0===arguments[e]&&(i[e]=void 0)}))),this._xregexp&&this._xregexp.captureNames)for(var c=1;c<i.length;c++)(t=this._xregexp.captureNames[c-1])&&(i[t]=i[c]);!o&&this.global&&!i[0].length&&this.lastIndex>i.index&&this.lastIndex--}return i},o||(RegExp.prototype.test=function(e){var t=r.exec.call(this,e);return t&&this.global&&!t[0].length&&this.lastIndex>t.index&&this.lastIndex--,!!t}))})),ace.define("ace/lib/es5-shim",["require","exports","module"],(function(e,t,n){function i(){}Function.prototype.bind||(Function.prototype.bind=function(e){var t=this;if("function"!=typeof t)throw new TypeError("Function.prototype.bind called on incompatible "+t);var n=d.call(arguments,1),r=function(){if(this instanceof r){var i=t.apply(this,n.concat(d.call(arguments)));return Object(i)===i?i:this}return t.apply(e,n.concat(d.call(arguments)))};return t.prototype&&(i.prototype=t.prototype,r.prototype=new i,i.prototype=null),r});var r,s,o,a,l,c=Function.prototype.call,u=Array.prototype,h=Object.prototype,d=u.slice,m=c.bind(h.toString),p=c.bind(h.hasOwnProperty);if((l=p(h,"__defineGetter__"))&&(r=c.bind(h.__defineGetter__),s=c.bind(h.__defineSetter__),o=c.bind(h.__lookupGetter__),a=c.bind(h.__lookupSetter__)),2!=[1,2].splice(0).length)if(function(){function e(e){var t=new Array(e+2);return t[0]=t[1]=0,t}var t,n=[];if(n.splice.apply(n,e(20)),n.splice.apply(n,e(26)),t=n.length,n.splice(5,0,"XXX"),n.length,t+1==n.length)return!0}()){var g=Array.prototype.splice;Array.prototype.splice=function(e,t){return arguments.length?g.apply(this,[void 0===e?0:e,void 0===t?this.length-e:t].concat(d.call(arguments,2))):[]}}else Array.prototype.splice=function(e,t){var n=this.length;e>0?e>n&&(e=n):null==e?e=0:e<0&&(e=Math.max(n+e,0)),e+t<n||(t=n-e);var i=this.slice(e,e+t),r=d.call(arguments,2),s=r.length;if(e===n)s&&this.push.apply(this,r);else{var o=Math.min(t,n-e),a=e+o,l=a+s-o,c=n-a,u=n-o;if(l<a)for(var h=0;h<c;++h)this[l+h]=this[a+h];else if(l>a)for(h=c;h--;)this[l+h]=this[a+h];if(s&&e===u)this.length=u,this.push.apply(this,r);else for(this.length=u+s,h=0;h<s;++h)this[e+h]=r[h]}return i};Array.isArray||(Array.isArray=function(e){return"[object Array]"==m(e)});var f,E,v=Object("a"),_="a"!=v[0]||!(0 in v);function C(e){try{return Object.defineProperty(e,"sentinel",{}),"sentinel"in e}catch(e){}}if(Array.prototype.forEach||(Array.prototype.forEach=function(e){var t=N(this),n=_&&"[object String]"==m(this)?this.split(""):t,i=arguments[1],r=-1,s=n.length>>>0;if("[object Function]"!=m(e))throw new TypeError;for(;++r<s;)r in n&&e.call(i,n[r],r,t)}),Array.prototype.map||(Array.prototype.map=function(e){var t=N(this),n=_&&"[object String]"==m(this)?this.split(""):t,i=n.length>>>0,r=Array(i),s=arguments[1];if("[object Function]"!=m(e))throw new TypeError(e+" is not a function");for(var o=0;o<i;o++)o in n&&(r[o]=e.call(s,n[o],o,t));return r}),Array.prototype.filter||(Array.prototype.filter=function(e){var t,n=N(this),i=_&&"[object String]"==m(this)?this.split(""):n,r=i.length>>>0,s=[],o=arguments[1];if("[object Function]"!=m(e))throw new TypeError(e+" is not a function");for(var a=0;a<r;a++)a in i&&(t=i[a],e.call(o,t,a,n)&&s.push(t));return s}),Array.prototype.every||(Array.prototype.every=function(e){var t=N(this),n=_&&"[object String]"==m(this)?this.split(""):t,i=n.length>>>0,r=arguments[1];if("[object Function]"!=m(e))throw new TypeError(e+" is not a function");for(var s=0;s<i;s++)if(s in n&&!e.call(r,n[s],s,t))return!1;return!0}),Array.prototype.some||(Array.prototype.some=function(e){var t=N(this),n=_&&"[object String]"==m(this)?this.split(""):t,i=n.length>>>0,r=arguments[1];if("[object Function]"!=m(e))throw new TypeError(e+" is not a function");for(var s=0;s<i;s++)if(s in n&&e.call(r,n[s],s,t))return!0;return!1}),Array.prototype.reduce||(Array.prototype.reduce=function(e){var t=N(this),n=_&&"[object String]"==m(this)?this.split(""):t,i=n.length>>>0;if("[object Function]"!=m(e))throw new TypeError(e+" is not a function");if(!i&&1==arguments.length)throw new TypeError("reduce of empty array with no initial value");var r,s=0;if(arguments.length>=2)r=arguments[1];else for(;;){if(s in n){r=n[s++];break}if(++s>=i)throw new TypeError("reduce of empty array with no initial value")}for(;s<i;s++)s in n&&(r=e.call(void 0,r,n[s],s,t));return r}),Array.prototype.reduceRight||(Array.prototype.reduceRight=function(e){var t=N(this),n=_&&"[object String]"==m(this)?this.split(""):t,i=n.length>>>0;if("[object Function]"!=m(e))throw new TypeError(e+" is not a function");if(!i&&1==arguments.length)throw new TypeError("reduceRight of empty array with no initial value");var r,s=i-1;if(arguments.length>=2)r=arguments[1];else for(;;){if(s in n){r=n[s--];break}if(--s<0)throw new TypeError("reduceRight of empty array with no initial value")}do{s in this&&(r=e.call(void 0,r,n[s],s,t))}while(s--);return r}),Array.prototype.indexOf&&-1==[0,1].indexOf(1,2)||(Array.prototype.indexOf=function(e){var t=_&&"[object String]"==m(this)?this.split(""):N(this),n=t.length>>>0;if(!n)return-1;var i=0;for(arguments.length>1&&(i=F(arguments[1])),i=i>=0?i:Math.max(0,n+i);i<n;i++)if(i in t&&t[i]===e)return i;return-1}),Array.prototype.lastIndexOf&&-1==[0,1].lastIndexOf(0,-3)||(Array.prototype.lastIndexOf=function(e){var t=_&&"[object String]"==m(this)?this.split(""):N(this),n=t.length>>>0;if(!n)return-1;var i=n-1;for(arguments.length>1&&(i=Math.min(i,F(arguments[1]))),i=i>=0?i:n-Math.abs(i);i>=0;i--)if(i in t&&e===t[i])return i;return-1}),Object.getPrototypeOf||(Object.getPrototypeOf=function(e){return e.__proto__||(e.constructor?e.constructor.prototype:h)}),Object.getOwnPropertyDescriptor||(Object.getOwnPropertyDescriptor=function(e,t){if("object"!=typeof e&&"function"!=typeof e||null===e)throw new TypeError("Object.getOwnPropertyDescriptor called on a non-object: "+e);if(p(e,t)){var n;if(n={enumerable:!0,configurable:!0},l){var i=e.__proto__;e.__proto__=h;var r=o(e,t),s=a(e,t);if(e.__proto__=i,r||s)return r&&(n.get=r),s&&(n.set=s),n}return n.value=e[t],n}}),Object.getOwnPropertyNames||(Object.getOwnPropertyNames=function(e){return Object.keys(e)}),Object.create||(f=null===Object.prototype.__proto__?function(){return{__proto__:null}}:function(){var e={};for(var t in e)e[t]=null;return e.constructor=e.hasOwnProperty=e.propertyIsEnumerable=e.isPrototypeOf=e.toLocaleString=e.toString=e.valueOf=e.__proto__=null,e},Object.create=function(e,t){var n;if(null===e)n=f();else{if("object"!=typeof e)throw new TypeError("typeof prototype["+typeof e+"] != 'object'");var i=function(){};i.prototype=e,(n=new i).__proto__=e}return void 0!==t&&Object.defineProperties(n,t),n}),Object.defineProperty){var A=C({}),R="undefined"==typeof document||C(document.createElement("div"));if(!A||!R)var S=Object.defineProperty}Object.defineProperty&&!S||(Object.defineProperty=function(e,t,n){if("object"!=typeof e&&"function"!=typeof e||null===e)throw new TypeError("Object.defineProperty called on non-object: "+e);if("object"!=typeof n&&"function"!=typeof n||null===n)throw new TypeError("Property description must be an object: "+n);if(S)try{return S.call(Object,e,t,n)}catch(e){}if(p(n,"value"))if(l&&(o(e,t)||a(e,t))){var i=e.__proto__;e.__proto__=h,delete e[t],e[t]=n.value,e.__proto__=i}else e[t]=n.value;else{if(!l)throw new TypeError("getters & setters can not be defined on this javascript engine");p(n,"get")&&r(e,t,n.get),p(n,"set")&&s(e,t,n.set)}return e}),Object.defineProperties||(Object.defineProperties=function(e,t){for(var n in t)p(t,n)&&Object.defineProperty(e,n,t[n]);return e}),Object.seal||(Object.seal=function(e){return e}),Object.freeze||(Object.freeze=function(e){return e});try{Object.freeze((function(){}))}catch(e){Object.freeze=(E=Object.freeze,function(e){return"function"==typeof e?e:E(e)})}if(Object.preventExtensions||(Object.preventExtensions=function(e){return e}),Object.isSealed||(Object.isSealed=function(e){return!1}),Object.isFrozen||(Object.isFrozen=function(e){return!1}),Object.isExtensible||(Object.isExtensible=function(e){if(Object(e)===e)throw new TypeError;for(var t="";p(e,t);)t+="?";e[t]=!0;var n=p(e,t);return delete e[t],n}),!Object.keys){var T=!0,b=["toString","toLocaleString","valueOf","hasOwnProperty","isPrototypeOf","propertyIsEnumerable","constructor"],w=b.length;for(var x in{toString:null})T=!1;Object.keys=function(e){if("object"!=typeof e&&"function"!=typeof e||null===e)throw new TypeError("Object.keys called on a non-object");var t=[];for(var n in e)p(e,n)&&t.push(n);if(T)for(var i=0,r=w;i<r;i++){var s=b[i];p(e,s)&&t.push(s)}return t}}Date.now||(Date.now=function(){return(new Date).getTime()});var y="\t\n\v\f\r                　\u2028\u2029\ufeff";if(!String.prototype.trim){y="["+y+"]";var L=new RegExp("^"+y+y+"*"),I=new RegExp(y+y+"*$");String.prototype.trim=function(){return String(this).replace(L,"").replace(I,"")}}function F(e){return(e=+e)!=e?e=0:0!==e&&e!==1/0&&e!==-1/0&&(e=(e>0||-1)*Math.floor(Math.abs(e))),e}var N=function(e){if(null==e)throw new TypeError("can't convert "+e+" to object");return Object(e)}})),ace.define("ace/lib/fixoldbrowsers",["require","exports","module","ace/lib/regexp","ace/lib/es5-shim"],(function(e,t,n){"use strict";e("./regexp"),e("./es5-shim"),"undefined"==typeof Element||Element.prototype.remove||Object.defineProperty(Element.prototype,"remove",{enumerable:!1,writable:!0,configurable:!0,value:function(){this.parentNode&&this.parentNode.removeChild(this)}})})),ace.define("ace/lib/useragent",["require","exports","module"],(function(e,t,n){"use strict";t.OS={LINUX:"LINUX",MAC:"MAC",WINDOWS:"WINDOWS"},t.getOS=function(){return t.isMac?t.OS.MAC:t.isLinux?t.OS.LINUX:t.OS.WINDOWS};var i="object"==typeof navigator?navigator:{},r=(/mac|win|linux/i.exec(i.platform)||["other"])[0].toLowerCase(),s=i.userAgent||"",o=i.appName||"";t.isWin="win"==r,t.isMac="mac"==r,t.isLinux="linux"==r,t.isIE="Microsoft Internet Explorer"==o||o.indexOf("MSAppHost")>=0?parseFloat((s.match(/(?:MSIE |Trident\/[0-9]+[\.0-9]+;.*rv:)([0-9]+[\.0-9]+)/)||[])[1]):parseFloat((s.match(/(?:Trident\/[0-9]+[\.0-9]+;.*rv:)([0-9]+[\.0-9]+)/)||[])[1]),t.isOldIE=t.isIE&&t.isIE<9,t.isGecko=t.isMozilla=s.match(/ Gecko\/\d+/),t.isOpera="object"==typeof opera&&"[object Opera]"==Object.prototype.toString.call(window.opera),t.isWebKit=parseFloat(s.split("WebKit/")[1])||void 0,t.isChrome=parseFloat(s.split(" Chrome/")[1])||void 0,t.isEdge=parseFloat(s.split(" Edge/")[1])||void 0,t.isAIR=s.indexOf("AdobeAIR")>=0,t.isAndroid=s.indexOf("Android")>=0,t.isChromeOS=s.indexOf(" CrOS ")>=0,t.isIOS=/iPad|iPhone|iPod/.test(s)&&!window.MSStream,t.isIOS&&(t.isMac=!0),t.isMobile=t.isIOS||t.isAndroid})),ace.define("ace/lib/dom",["require","exports","module","ace/lib/useragent"],(function(e,t,n){"use strict";var i=e("./useragent");if(t.buildDom=function e(t,n,i){if("string"==typeof t&&t){var r=document.createTextNode(t);return n&&n.appendChild(r),r}if(!Array.isArray(t))return t;if("string"!=typeof t[0]||!t[0]){for(var s=[],o=0;o<t.length;o++){var a=e(t[o],n,i);a&&s.push(a)}return s}var l=document.createElement(t[0]),c=t[1],u=1;for(c&&"object"==typeof c&&!Array.isArray(c)&&(u=2),o=u;o<t.length;o++)e(t[o],l,i);return 2==u&&Object.keys(c).forEach((function(e){var t=c[e];"class"===e?l.className=Array.isArray(t)?t.join(" "):t:"function"==typeof t||"value"==e?l[e]=t:"ref"===e?i&&(i[t]=l):null!=t&&l.setAttribute(e,t)})),n&&n.appendChild(l),l},t.getDocumentHead=function(e){return e||(e=document),e.head||e.getElementsByTagName("head")[0]||e.documentElement},t.createElement=function(e,t){return document.createElementNS?document.createElementNS(t||"http://www.w3.org/1999/xhtml",e):document.createElement(e)},t.removeChildren=function(e){e.innerHTML=""},t.createTextNode=function(e,t){return(t?t.ownerDocument:document).createTextNode(e)},t.createFragment=function(e){return(e?e.ownerDocument:document).createDocumentFragment()},t.hasCssClass=function(e,t){return-1!==(e.className+"").split(/\s+/g).indexOf(t)},t.addCssClass=function(e,n){t.hasCssClass(e,n)||(e.className+=" "+n)},t.removeCssClass=function(e,t){for(var n=e.className.split(/\s+/g);;){var i=n.indexOf(t);if(-1==i)break;n.splice(i,1)}e.className=n.join(" ")},t.toggleCssClass=function(e,t){for(var n=e.className.split(/\s+/g),i=!0;;){var r=n.indexOf(t);if(-1==r)break;i=!1,n.splice(r,1)}return i&&n.push(t),e.className=n.join(" "),i},t.setCssClass=function(e,n,i){i?t.addCssClass(e,n):t.removeCssClass(e,n)},t.hasCssString=function(e,t){var n,i=0;if(n=(t=t||document).querySelectorAll("style"))for(;i<n.length;)if(n[i++].id===e)return!0},t.importCssString=function(e,n,i){var r=i;i&&i.getRootNode&&(r=i.getRootNode())&&r!=i||(r=document);var s=r.ownerDocument||r;if(n&&t.hasCssString(n,r))return null;n&&(e+="\n/*# sourceURL=ace/css/"+n+" */");var o=t.createElement("style");o.appendChild(s.createTextNode(e)),n&&(o.id=n),r==s&&(r=t.getDocumentHead(s)),r.insertBefore(o,r.firstChild)},t.importCssStylsheet=function(e,n){t.buildDom(["link",{rel:"stylesheet",href:e}],t.getDocumentHead(n))},t.scrollbarWidth=function(e){var n=t.createElement("ace_inner");n.style.width="100%",n.style.minWidth="0px",n.style.height="200px",n.style.display="block";var i=t.createElement("ace_outer"),r=i.style;r.position="absolute",r.left="-10000px",r.overflow="hidden",r.width="200px",r.minWidth="0px",r.height="150px",r.display="block",i.appendChild(n);var s=e.documentElement;s.appendChild(i);var o=n.offsetWidth;r.overflow="scroll";var a=n.offsetWidth;return o==a&&(a=i.clientWidth),s.removeChild(i),o-a},"undefined"==typeof document&&(t.importCssString=function(){}),t.computedStyle=function(e,t){return window.getComputedStyle(e,"")||{}},t.setStyle=function(e,t,n){e[t]!==n&&(e[t]=n)},t.HAS_CSS_ANIMATION=!1,t.HAS_CSS_TRANSFORMS=!1,t.HI_DPI=!i.isWin||"undefined"!=typeof window&&window.devicePixelRatio>=1.5,"undefined"!=typeof document){var r=document.createElement("div");t.HI_DPI&&void 0!==r.style.transform&&(t.HAS_CSS_TRANSFORMS=!0),i.isEdge||void 0===r.style.animationName||(t.HAS_CSS_ANIMATION=!0),r=null}t.HAS_CSS_TRANSFORMS?t.translate=function(e,t,n){e.style.transform="translate("+Math.round(t)+"px, "+Math.round(n)+"px)"}:t.translate=function(e,t,n){e.style.top=Math.round(n)+"px",e.style.left=Math.round(t)+"px"}})),ace.define("ace/lib/oop",["require","exports","module"],(function(e,t,n){"use strict";t.inherits=function(e,t){e.super_=t,e.prototype=Object.create(t.prototype,{constructor:{value:e,enumerable:!1,writable:!0,configurable:!0}})},t.mixin=function(e,t){for(var n in t)e[n]=t[n];return e},t.implement=function(e,n){t.mixin(e,n)}})),ace.define("ace/lib/keys",["require","exports","module","ace/lib/oop"],(function(e,t,n){"use strict";var i=e("./oop"),r=function(){var e,t,n={MODIFIER_KEYS:{16:"Shift",17:"Ctrl",18:"Alt",224:"Meta",91:"MetaLeft",92:"MetaRight",93:"ContextMenu"},KEY_MODS:{ctrl:1,alt:2,option:2,shift:4,super:8,meta:8,command:8,cmd:8},FUNCTION_KEYS:{8:"Backspace",9:"Tab",13:"Return",19:"Pause",27:"Esc",32:"Space",33:"PageUp",34:"PageDown",35:"End",36:"Home",37:"Left",38:"Up",39:"Right",40:"Down",44:"Print",45:"Insert",46:"Delete",96:"Numpad0",97:"Numpad1",98:"Numpad2",99:"Numpad3",100:"Numpad4",101:"Numpad5",102:"Numpad6",103:"Numpad7",104:"Numpad8",105:"Numpad9","-13":"NumpadEnter",112:"F1",113:"F2",114:"F3",115:"F4",116:"F5",117:"F6",118:"F7",119:"F8",120:"F9",121:"F10",122:"F11",123:"F12",144:"Numlock",145:"Scrolllock"},PRINTABLE_KEYS:{32:" ",48:"0",49:"1",50:"2",51:"3",52:"4",53:"5",54:"6",55:"7",56:"8",57:"9",59:";",61:"=",65:"a",66:"b",67:"c",68:"d",69:"e",70:"f",71:"g",72:"h",73:"i",74:"j",75:"k",76:"l",77:"m",78:"n",79:"o",80:"p",81:"q",82:"r",83:"s",84:"t",85:"u",86:"v",87:"w",88:"x",89:"y",90:"z",107:"+",109:"-",110:".",186:";",187:"=",188:",",189:"-",190:".",191:"/",192:"`",219:"[",220:"\\",221:"]",222:"'",111:"/",106:"*"}};for(t in n.FUNCTION_KEYS)e=n.FUNCTION_KEYS[t].toLowerCase(),n[e]=parseInt(t,10);for(t in n.PRINTABLE_KEYS)e=n.PRINTABLE_KEYS[t].toLowerCase(),n[e]=parseInt(t,10);return i.mixin(n,n.MODIFIER_KEYS),i.mixin(n,n.PRINTABLE_KEYS),i.mixin(n,n.FUNCTION_KEYS),n.enter=n.return,n.escape=n.esc,n.del=n.delete,n[173]="-",function(){for(var e=["cmd","ctrl","alt","shift"],t=Math.pow(2,e.length);t--;)n.KEY_MODS[t]=e.filter((function(e){return t&n.KEY_MODS[e]})).join("-")+"-"}(),n.KEY_MODS[0]="",n.KEY_MODS[-1]="input-",n}();i.mixin(t,r),t.keyCodeToString=function(e){var t=r[e];return"string"!=typeof t&&(t=String.fromCharCode(e)),t.toLowerCase()}})),ace.define("ace/lib/event",["require","exports","module","ace/lib/keys","ace/lib/useragent"],(function(e,t,n){"use strict";var i=e("./keys"),r=e("./useragent"),s=null,o=0;t.addListener=function(e,t,n){if(e.addEventListener)return e.addEventListener(t,n,!1);if(e.attachEvent){var i=function(){n.call(e,window.event)};n._wrapper=i,e.attachEvent("on"+t,i)}},t.removeListener=function(e,t,n){if(e.removeEventListener)return e.removeEventListener(t,n,!1);e.detachEvent&&e.detachEvent("on"+t,n._wrapper||n)},t.stopEvent=function(e){return t.stopPropagation(e),t.preventDefault(e),!1},t.stopPropagation=function(e){e.stopPropagation?e.stopPropagation():e.cancelBubble=!0},t.preventDefault=function(e){e.preventDefault?e.preventDefault():e.returnValue=!1},t.getButton=function(e){return"dblclick"==e.type?0:"contextmenu"==e.type||r.isMac&&e.ctrlKey&&!e.altKey&&!e.shiftKey?2:e.preventDefault?e.button:{1:0,2:2,4:1}[e.button]},t.capture=function(e,n,i){function r(e){n&&n(e),i&&i(e),t.removeListener(document,"mousemove",n,!0),t.removeListener(document,"mouseup",r,!0),t.removeListener(document,"dragstart",r,!0)}return t.addListener(document,"mousemove",n,!0),t.addListener(document,"mouseup",r,!0),t.addListener(document,"dragstart",r,!0),r},t.addMouseWheelListener=function(e,n){"onmousewheel"in e?t.addListener(e,"mousewheel",(function(e){void 0!==e.wheelDeltaX?(e.wheelX=-e.wheelDeltaX/8,e.wheelY=-e.wheelDeltaY/8):(e.wheelX=0,e.wheelY=-e.wheelDelta/8),n(e)})):"onwheel"in e?t.addListener(e,"wheel",(function(e){switch(e.deltaMode){case e.DOM_DELTA_PIXEL:e.wheelX=.35*e.deltaX||0,e.wheelY=.35*e.deltaY||0;break;case e.DOM_DELTA_LINE:case e.DOM_DELTA_PAGE:e.wheelX=5*(e.deltaX||0),e.wheelY=5*(e.deltaY||0)}n(e)})):t.addListener(e,"DOMMouseScroll",(function(e){e.axis&&e.axis==e.HORIZONTAL_AXIS?(e.wheelX=5*(e.detail||0),e.wheelY=0):(e.wheelX=0,e.wheelY=5*(e.detail||0)),n(e)}))},t.addMultiMouseDownListener=function(e,n,i,s){var o,a,l,c=0,u={2:"dblclick",3:"tripleclick",4:"quadclick"};function h(e){if(0!==t.getButton(e)?c=0:e.detail>1?++c>4&&(c=1):c=1,r.isIE){var h=Math.abs(e.clientX-o)>5||Math.abs(e.clientY-a)>5;l&&!h||(c=1),l&&clearTimeout(l),l=setTimeout((function(){l=null}),n[c-1]||600),1==c&&(o=e.clientX,a=e.clientY)}if(e._clicks=c,i[s]("mousedown",e),c>4)c=0;else if(c>1)return i[s](u[c],e)}function d(e){c=2,l&&clearTimeout(l),l=setTimeout((function(){l=null}),n[c-1]||600),i[s]("mousedown",e),i[s](u[c],e)}Array.isArray(e)||(e=[e]),e.forEach((function(e){t.addListener(e,"mousedown",h),r.isOldIE&&t.addListener(e,"dblclick",d)}))};var a=r.isMac&&r.isOpera&&!("KeyboardEvent"in window)?function(e){return 0|(e.metaKey?1:0)|(e.altKey?2:0)|(e.shiftKey?4:0)|(e.ctrlKey?8:0)}:function(e){return 0|(e.ctrlKey?1:0)|(e.altKey?2:0)|(e.shiftKey?4:0)|(e.metaKey?8:0)};function l(e,t,n){var l=a(t);if(!r.isMac&&s){if(t.getModifierState&&(t.getModifierState("OS")||t.getModifierState("Win"))&&(l|=8),s.altGr){if(3==(3&l))return;s.altGr=0}if(18===n||17===n){var c="location"in t?t.location:t.keyLocation;17===n&&1===c?1==s[n]&&(o=t.timeStamp):18===n&&3===l&&2===c&&t.timeStamp-o<50&&(s.altGr=!0)}}if(n in i.MODIFIER_KEYS&&(n=-1),l||13!==n||3!==(c="location"in t?t.location:t.keyLocation)||(e(t,l,-n),!t.defaultPrevented)){if(r.isChromeOS&&8&l){if(e(t,l,n),t.defaultPrevented)return;l&=-9}return!!(l||n in i.FUNCTION_KEYS||n in i.PRINTABLE_KEYS)&&e(t,l,n)}}function c(){s=Object.create(null)}if(t.getModifierString=function(e){return i.KEY_MODS[a(e)]},t.addCommandKeyListener=function(e,n){var i=t.addListener;if(r.isOldGecko||r.isOpera&&!("KeyboardEvent"in window)){var o=null;i(e,"keydown",(function(e){o=e.keyCode})),i(e,"keypress",(function(e){return l(n,e,o)}))}else{var a=null;i(e,"keydown",(function(e){s[e.keyCode]=(s[e.keyCode]||0)+1;var t=l(n,e,e.keyCode);return a=e.defaultPrevented,t})),i(e,"keypress",(function(e){a&&(e.ctrlKey||e.altKey||e.shiftKey||e.metaKey)&&(t.stopEvent(e),a=null)})),i(e,"keyup",(function(e){s[e.keyCode]=null})),s||(c(),i(window,"focus",c))}},"object"==typeof window&&window.postMessage&&!r.isOldIE){var u=1;t.nextTick=function(e,n){n=n||window;var i="zero-timeout-message-"+u++,r=function(s){s.data==i&&(t.stopPropagation(s),t.removeListener(n,"message",r),e())};t.addListener(n,"message",r),n.postMessage(i,"*")}}t.$idleBlocked=!1,t.onIdle=function(e,n){return setTimeout((function n(){t.$idleBlocked?setTimeout(n,100):e()}),n)},t.$idleBlockId=null,t.blockIdle=function(e){t.$idleBlockId&&clearTimeout(t.$idleBlockId),t.$idleBlocked=!0,t.$idleBlockId=setTimeout((function(){t.$idleBlocked=!1}),e||100)},t.nextFrame="object"==typeof window&&(window.requestAnimationFrame||window.mozRequestAnimationFrame||window.webkitRequestAnimationFrame||window.msRequestAnimationFrame||window.oRequestAnimationFrame),t.nextFrame?t.nextFrame=t.nextFrame.bind(window):t.nextFrame=function(e){setTimeout(e,17)}})),ace.define("ace/range",["require","exports","module"],(function(e,t,n){"use strict";var i=function(e,t,n,i){this.start={row:e,column:t},this.end={row:n,column:i}};(function(){this.isEqual=function(e){return this.start.row===e.start.row&&this.end.row===e.end.row&&this.start.column===e.start.column&&this.end.column===e.end.column},this.toString=function(){return"Range: ["+this.start.row+"/"+this.start.column+"] -> ["+this.end.row+"/"+this.end.column+"]"},this.contains=function(e,t){return 0==this.compare(e,t)},this.compareRange=function(e){var t,n=e.end,i=e.start;return 1==(t=this.compare(n.row,n.column))?1==(t=this.compare(i.row,i.column))?2:0==t?1:0:-1==t?-2:-1==(t=this.compare(i.row,i.column))?-1:1==t?42:0},this.comparePoint=function(e){return this.compare(e.row,e.column)},this.containsRange=function(e){return 0==this.comparePoint(e.start)&&0==this.comparePoint(e.end)},this.intersects=function(e){var t=this.compareRange(e);return-1==t||0==t||1==t},this.isEnd=function(e,t){return this.end.row==e&&this.end.column==t},this.isStart=function(e,t){return this.start.row==e&&this.start.column==t},this.setStart=function(e,t){"object"==typeof e?(this.start.column=e.column,this.start.row=e.row):(this.start.row=e,this.start.column=t)},this.setEnd=function(e,t){"object"==typeof e?(this.end.column=e.column,this.end.row=e.row):(this.end.row=e,this.end.column=t)},this.inside=function(e,t){return 0==this.compare(e,t)&&!this.isEnd(e,t)&&!this.isStart(e,t)},this.insideStart=function(e,t){return 0==this.compare(e,t)&&!this.isEnd(e,t)},this.insideEnd=function(e,t){return 0==this.compare(e,t)&&!this.isStart(e,t)},this.compare=function(e,t){return this.isMultiLine()||e!==this.start.row?e<this.start.row?-1:e>this.end.row?1:this.start.row===e?t>=this.start.column?0:-1:this.end.row===e?t<=this.end.column?0:1:0:t<this.start.column?-1:t>this.end.column?1:0},this.compareStart=function(e,t){return this.start.row==e&&this.start.column==t?-1:this.compare(e,t)},this.compareEnd=function(e,t){return this.end.row==e&&this.end.column==t?1:this.compare(e,t)},this.compareInside=function(e,t){return this.end.row==e&&this.end.column==t?1:this.start.row==e&&this.start.column==t?-1:this.compare(e,t)},this.clipRows=function(e,t){if(this.end.row>t)var n={row:t+1,column:0};else this.end.row<e&&(n={row:e,column:0});if(this.start.row>t)var r={row:t+1,column:0};else this.start.row<e&&(r={row:e,column:0});return i.fromPoints(r||this.start,n||this.end)},this.extend=function(e,t){var n=this.compare(e,t);if(0==n)return this;if(-1==n)var r={row:e,column:t};else var s={row:e,column:t};return i.fromPoints(r||this.start,s||this.end)},this.isEmpty=function(){return this.start.row===this.end.row&&this.start.column===this.end.column},this.isMultiLine=function(){return this.start.row!==this.end.row},this.clone=function(){return i.fromPoints(this.start,this.end)},this.collapseRows=function(){return 0==this.end.column?new i(this.start.row,0,Math.max(this.start.row,this.end.row-1),0):new i(this.start.row,0,this.end.row,0)},this.toScreenRange=function(e){var t=e.documentToScreenPosition(this.start),n=e.documentToScreenPosition(this.end);return new i(t.row,t.column,n.row,n.column)},this.moveBy=function(e,t){this.start.row+=e,this.start.column+=t,this.end.row+=e,this.end.column+=t}}).call(i.prototype),i.fromPoints=function(e,t){return new i(e.row,e.column,t.row,t.column)},i.comparePoints=function(e,t){return e.row-t.row||e.column-t.column},i.comparePoints=function(e,t){return e.row-t.row||e.column-t.column},t.Range=i})),ace.define("ace/lib/lang",["require","exports","module"],(function(e,t,n){"use strict";t.last=function(e){return e[e.length-1]},t.stringReverse=function(e){return e.split("").reverse().join("")},t.stringRepeat=function(e,t){for(var n="";t>0;)1&t&&(n+=e),(t>>=1)&&(e+=e);return n};var i=/^\s\s*/,r=/\s\s*$/;t.stringTrimLeft=function(e){return e.replace(i,"")},t.stringTrimRight=function(e){return e.replace(r,"")},t.copyObject=function(e){var t={};for(var n in e)t[n]=e[n];return t},t.copyArray=function(e){for(var t=[],n=0,i=e.length;n<i;n++)e[n]&&"object"==typeof e[n]?t[n]=this.copyObject(e[n]):t[n]=e[n];return t},t.deepCopy=function e(t){if("object"!=typeof t||!t)return t;var n;if(Array.isArray(t)){n=[];for(var i=0;i<t.length;i++)n[i]=e(t[i]);return n}if("[object Object]"!==Object.prototype.toString.call(t))return t;for(var i in n={},t)n[i]=e(t[i]);return n},t.arrayToMap=function(e){for(var t={},n=0;n<e.length;n++)t[e[n]]=1;return t},t.createMap=function(e){var t=Object.create(null);for(var n in e)t[n]=e[n];return t},t.arrayRemove=function(e,t){for(var n=0;n<=e.length;n++)t===e[n]&&e.splice(n,1)},t.escapeRegExp=function(e){return e.replace(/([.*+?^${}()|[\]\/\\])/g,"\\$1")},t.escapeHTML=function(e){return(""+e).replace(/&/g,"&#38;").replace(/"/g,"&#34;").replace(/'/g,"&#39;").replace(/</g,"&#60;")},t.getMatchOffsets=function(e,t){var n=[];return e.replace(t,(function(e){n.push({offset:arguments[arguments.length-2],length:e.length})})),n},t.deferredCall=function(e){var t=null,n=function(){t=null,e()},i=function(e){return i.cancel(),t=setTimeout(n,e||0),i};return i.schedule=i,i.call=function(){return this.cancel(),e(),i},i.cancel=function(){return clearTimeout(t),t=null,i},i.isPending=function(){return t},i},t.delayedCall=function(e,t){var n=null,i=function(){n=null,e()},r=function(e){null==n&&(n=setTimeout(i,e||t))};return r.delay=function(e){n&&clearTimeout(n),n=setTimeout(i,e||t)},r.schedule=r,r.call=function(){this.cancel(),e()},r.cancel=function(){n&&clearTimeout(n),n=null},r.isPending=function(){return n},r}})),ace.define("ace/clipboard",["require","exports","module"],(function(e,t,n){"use strict";var i;n.exports={lineMode:!1,pasteCancelled:function(){return!!(i&&i>Date.now()-50)||(i=!1)},cancel:function(){i=Date.now()}}})),ace.define("ace/keyboard/textinput",["require","exports","module","ace/lib/event","ace/lib/useragent","ace/lib/dom","ace/lib/lang","ace/clipboard","ace/lib/keys"],(function(e,t,n){"use strict";var i=e("../lib/event"),r=e("../lib/useragent"),s=e("../lib/dom"),o=e("../lib/lang"),a=e("../clipboard"),l=r.isChrome<18,c=r.isIE,u=r.isChrome>63,h=400,d=e("../lib/keys"),m=d.KEY_MODS,p=r.isIOS,g=p?/\s/:/\n/;t.TextInput=function(e,t){var n=s.createElement("textarea");n.className="ace_text-input",n.setAttribute("wrap","off"),n.setAttribute("autocorrect","off"),n.setAttribute("autocapitalize","off"),n.setAttribute("spellcheck",!1),n.style.opacity="0",e.insertBefore(n,e.firstChild);var f=!1,E=!1,v=!1,_=!1,C="";r.isMobile||(n.style.fontSize="1px");var A=!1,R=!1,S="",T=0,b=0,w=0;try{var x=document.activeElement===n}catch(e){}i.addListener(n,"blur",(function(e){R||(t.onBlur(e),x=!1)})),i.addListener(n,"focus",(function(e){if(!R){if(x=!0,r.isEdge)try{if(!document.hasFocus())return}catch(e){}t.onFocus(e),r.isEdge?setTimeout(y):y()}})),this.$focusScroll=!1,this.focus=function(){if(C||u||"browser"==this.$focusScroll)return n.focus({preventScroll:!0});var e=n.style.top;n.style.position="fixed",n.style.top="0px";try{var t=0!=n.getBoundingClientRect().top}catch(e){return}var i=[];if(t)for(var r=n.parentElement;r&&1==r.nodeType;)i.push(r),r.setAttribute("ace_nocontext",!0),r=!r.parentElement&&r.getRootNode?r.getRootNode().host:r.parentElement;n.focus({preventScroll:!0}),t&&i.forEach((function(e){e.removeAttribute("ace_nocontext")})),setTimeout((function(){n.style.position="","0px"==n.style.top&&(n.style.top=e)}),0)},this.blur=function(){n.blur()},this.isFocused=function(){return x},t.on("beforeEndOperation",(function(){t.curOp&&"insertstring"==t.curOp.command.name||(v&&(S=n.value="",D()),y())}));var y=p?function(e){if(x&&(!f||e)&&!_){e||(e="");var i="\n ab"+e+"cde fg\n";i!=n.value&&(n.value=S=i);var r=4+(e.length||(t.selection.isEmpty()?0:1));4==T&&b==r||n.setSelectionRange(4,r),T=4,b=r}}:function(){if(!v&&!_&&(x||I)){v=!0;var e=t.selection,i=e.getRange(),r=e.cursor.row,s=i.start.column,o=i.end.column,a=t.session.getLine(r);if(i.start.row!=r){var l=t.session.getLine(r-1);s=i.start.row<r-1?0:s,o+=l.length+1,a=l+"\n"+a}else if(i.end.row!=r){var c=t.session.getLine(r+1);o=i.end.row>r+1?c.length:o,o+=a.length+1,a=a+"\n"+c}a.length>h&&(s<h&&o<h?a=a.slice(0,h):(a="\n",s=0,o=1));var u=a+"\n\n";if(u!=S&&(n.value=S=u,T=b=u.length),I&&(T=n.selectionStart,b=n.selectionEnd),b!=o||T!=s||n.selectionEnd!=b)try{n.setSelectionRange(s,o),T=s,b=o}catch(e){}v=!1}};x&&t.onFocus();var L=null;this.setInputHandler=function(e){L=e},this.getInputHandler=function(){return L};var I=!1,F=function(e,i){if(I&&(I=!1),E)return y(),e&&t.onPaste(e),E=!1,"";for(var r=n.selectionStart,s=n.selectionEnd,o=T,a=S.length-b,l=e,c=e.length-r,u=e.length-s,h=0;o>0&&S[h]==e[h];)h++,o--;for(l=l.slice(h),h=1;a>0&&S.length-h>T-1&&S[S.length-h]==e[e.length-h];)h++,a--;c-=h-1,u-=h-1;var d=l.length-h+1;return d<0&&(o=-d,d=0),l=l.slice(0,d),i||l||c||o||a||u?(_=!0,l&&!o&&!a&&!c&&!u||A?t.onTextInput(l):t.onTextInput(l,{extendLeft:o,extendRight:a,restoreStart:c,restoreEnd:u}),_=!1,S=e,T=r,b=s,w=u,l):""},N=function(e){if(v)return k();if(e&&e.inputType){if("historyUndo"==e.inputType)return t.execCommand("undo");if("historyRedo"==e.inputType)return t.execCommand("redo")}var i=n.value,r=F(i,!0);(i.length>500||g.test(r))&&y()},M=function(e,t,n){var i=e.clipboardData||window.clipboardData;if(i&&!l){var r=c||n?"Text":"text/plain";try{return t?!1!==i.setData(r,t):i.getData(r)}catch(e){if(!n)return M(e,t,!0)}}},O=function(e,r){var s=t.getCopyText();if(!s)return i.preventDefault(e);M(e,s)?(p&&(y(s),f=s,setTimeout((function(){f=!1}),10)),r?t.onCut():t.onCopy(),i.preventDefault(e)):(f=!0,n.value=s,n.select(),setTimeout((function(){f=!1,y(),r?t.onCut():t.onCopy()})))},B=function(e){O(e,!0)},$=function(e){O(e,!1)},P=function(e){var s=M(e);a.pasteCancelled()||("string"==typeof s?(s&&t.onPaste(s,e),r.isIE&&setTimeout(y),i.preventDefault(e)):(n.value="",E=!0))};i.addCommandKeyListener(n,t.onCommandKey.bind(t)),i.addListener(n,"select",(function(e){v||(f?f=!1:function(e){return 0===e.selectionStart&&e.selectionEnd>=S.length&&e.value===S&&S&&e.selectionEnd!==b}(n)&&(t.selectAll(),y()))})),i.addListener(n,"input",N),i.addListener(n,"cut",B),i.addListener(n,"copy",$),i.addListener(n,"paste",P),"oncut"in n&&"oncopy"in n&&"onpaste"in n||i.addListener(e,"keydown",(function(e){if((!r.isMac||e.metaKey)&&e.ctrlKey)switch(e.keyCode){case 67:$(e);break;case 86:P(e);break;case 88:B(e)}}));var k=function(){if(v&&t.onCompositionUpdate&&!t.$readOnly){if(A)return U();if(v.useTextareaForIME)t.onCompositionUpdate(n.value);else{var e=n.value;F(e),v.markerRange&&(v.context&&(v.markerRange.start.column=v.selectionStart=v.context.compositionStartOffset),v.markerRange.end.column=v.markerRange.start.column+b-v.selectionStart+w)}}},D=function(e){t.onCompositionEnd&&!t.$readOnly&&(v=!1,t.onCompositionEnd(),t.off("mousedown",U),e&&N())};function U(){R=!0,n.blur(),n.focus(),R=!1}var G,W=o.delayedCall(k,50).schedule.bind(null,null);function V(){clearTimeout(G),G=setTimeout((function(){C&&(n.style.cssText=C,C=""),t.renderer.$isMousePressed=!1,t.renderer.$keepTextAreaAtCursor&&t.renderer.$moveTextAreaToCursor()}),0)}i.addListener(n,"compositionstart",(function(e){if(!v&&t.onCompositionStart&&!t.$readOnly&&(v={},!A)){setTimeout(k,0),t.on("mousedown",U);var i=t.getSelectionRange();i.end.row=i.start.row,i.end.column=i.start.column,v.markerRange=i,v.selectionStart=T,t.onCompositionStart(v),v.useTextareaForIME?(n.value="",S="",T=0,b=0):(n.msGetInputContext&&(v.context=n.msGetInputContext()),n.getInputContext&&(v.context=n.getInputContext()))}})),i.addListener(n,"compositionupdate",k),i.addListener(n,"keyup",(function(e){27==e.keyCode&&n.value.length<n.selectionStart&&(v||(S=n.value),T=b=-1,y()),W()})),i.addListener(n,"keydown",W),i.addListener(n,"compositionend",D),this.getElement=function(){return n},this.setCommandMode=function(e){A=e,n.readOnly=!1},this.setReadOnly=function(e){A||(n.readOnly=e)},this.setCopyWithEmptySelection=function(e){},this.onContextMenu=function(e){I=!0,y(),t._emit("nativecontextmenu",{target:t,domEvent:e}),this.moveToMouse(e,!0)},this.moveToMouse=function(e,o){C||(C=n.style.cssText),n.style.cssText=(o?"z-index:100000;":"")+(r.isIE?"opacity:0.1;":"")+"text-indent: -"+(T+b)*t.renderer.characterWidth*.5+"px;";var a=t.container.getBoundingClientRect(),l=s.computedStyle(t.container),c=a.top+(parseInt(l.borderTopWidth)||0),u=a.left+(parseInt(a.borderLeftWidth)||0),h=a.bottom-c-n.clientHeight-2,d=function(e){s.translate(n,e.clientX-u-2,Math.min(e.clientY-c-2,h))};d(e),"mousedown"==e.type&&(t.renderer.$isMousePressed=!0,clearTimeout(G),r.isWin&&i.capture(t.container,d,V))},this.onContextMenuClose=V;var H=function(e){t.textInput.onContextMenu(e),V()};i.addListener(n,"mouseup",H),i.addListener(n,"mousedown",(function(e){e.preventDefault(),V()})),i.addListener(t.renderer.scroller,"contextmenu",H),i.addListener(n,"contextmenu",H),p&&function(e,t,n){var i=null,r=!1;n.addEventListener("keydown",(function(e){i&&clearTimeout(i),r=!0}),!0),n.addEventListener("keyup",(function(e){i=setTimeout((function(){r=!1}),100)}),!0);var s=function(e){if(document.activeElement===n&&!(r||v||t.$mouseHandler.isMousePressed||f)){var i=n.selectionStart,s=n.selectionEnd,o=null,a=0;if(0==i?o=d.up:1==i?o=d.home:s>b&&"\n"==S[s]?o=d.end:i<T&&" "==S[i-1]?(o=d.left,a=m.option):i<T||i==T&&b!=T&&i==s?o=d.left:s>b&&S.slice(0,s).split("\n").length>2?o=d.down:s>b&&" "==S[s-1]?(o=d.right,a=m.option):(s>b||s==b&&b!=T&&i==s)&&(o=d.right),i!==s&&(a|=m.shift),o){if(!t.onCommandKey({},a,o)&&t.commands){o=d.keyCodeToString(o);var l=t.commands.findKeyCommand(a,o);l&&t.execCommand(l)}T=i,b=s,y("")}}};document.addEventListener("selectionchange",s),t.on("destroy",(function(){document.removeEventListener("selectionchange",s)}))}(0,t,n)}})),ace.define("ace/mouse/default_handlers",["require","exports","module","ace/lib/useragent"],(function(e,t,n){"use strict";var i=e("../lib/useragent");function r(e){e.$clickSelection=null;var t=e.editor;t.setDefaultHandler("mousedown",this.onMouseDown.bind(e)),t.setDefaultHandler("dblclick",this.onDoubleClick.bind(e)),t.setDefaultHandler("tripleclick",this.onTripleClick.bind(e)),t.setDefaultHandler("quadclick",this.onQuadClick.bind(e)),t.setDefaultHandler("mousewheel",this.onMouseWheel.bind(e)),["select","startSelect","selectEnd","selectAllEnd","selectByWordsEnd","selectByLinesEnd","dragWait","dragWaitEnd","focusWait"].forEach((function(t){e[t]=this[t]}),this),e.selectByLines=this.extendSelectionBy.bind(e,"getLineRange"),e.selectByWords=this.extendSelectionBy.bind(e,"getWordRange")}function s(e,t){if(e.start.row==e.end.row)var n=2*t.column-e.start.column-e.end.column;else if(e.start.row!=e.end.row-1||e.start.column||e.end.column)n=2*t.row-e.start.row-e.end.row;else n=t.column-4;return n<0?{cursor:e.start,anchor:e.end}:{cursor:e.end,anchor:e.start}}(function(){this.onMouseDown=function(e){var t=e.inSelection(),n=e.getDocumentPosition();this.mousedownEvent=e;var r=this.editor,s=e.getButton();return 0!==s?((r.getSelectionRange().isEmpty()||1==s)&&r.selection.moveToPosition(n),void(2==s&&(r.textInput.onContextMenu(e.domEvent),i.isMozilla||e.preventDefault()))):(this.mousedownEvent.time=Date.now(),!t||r.isFocused()||(r.focus(),!this.$focusTimeout||this.$clickSelection||r.inMultiSelectMode)?(this.captureMouse(e),this.startSelect(n,e.domEvent._clicks>1),e.preventDefault()):(this.setState("focusWait"),void this.captureMouse(e)))},this.startSelect=function(e,t){e=e||this.editor.renderer.screenToTextCoordinates(this.x,this.y);var n=this.editor;this.mousedownEvent&&(this.mousedownEvent.getShiftKey()?n.selection.selectToPosition(e):t||n.selection.moveToPosition(e),t||this.select(),n.renderer.scroller.setCapture&&n.renderer.scroller.setCapture(),n.setStyle("ace_selecting"),this.setState("select"))},this.select=function(){var e,t=this.editor,n=t.renderer.screenToTextCoordinates(this.x,this.y);if(this.$clickSelection){var i=this.$clickSelection.comparePoint(n);if(-1==i)e=this.$clickSelection.end;else if(1==i)e=this.$clickSelection.start;else{var r=s(this.$clickSelection,n);n=r.cursor,e=r.anchor}t.selection.setSelectionAnchor(e.row,e.column)}t.selection.selectToPosition(n),t.renderer.scrollCursorIntoView()},this.extendSelectionBy=function(e){var t,n=this.editor,i=n.renderer.screenToTextCoordinates(this.x,this.y),r=n.selection[e](i.row,i.column);if(this.$clickSelection){var o=this.$clickSelection.comparePoint(r.start),a=this.$clickSelection.comparePoint(r.end);if(-1==o&&a<=0)t=this.$clickSelection.end,r.end.row==i.row&&r.end.column==i.column||(i=r.start);else if(1==a&&o>=0)t=this.$clickSelection.start,r.start.row==i.row&&r.start.column==i.column||(i=r.end);else if(-1==o&&1==a)i=r.end,t=r.start;else{var l=s(this.$clickSelection,i);i=l.cursor,t=l.anchor}n.selection.setSelectionAnchor(t.row,t.column)}n.selection.selectToPosition(i),n.renderer.scrollCursorIntoView()},this.selectEnd=this.selectAllEnd=this.selectByWordsEnd=this.selectByLinesEnd=function(){this.$clickSelection=null,this.editor.unsetStyle("ace_selecting"),this.editor.renderer.scroller.releaseCapture&&this.editor.renderer.scroller.releaseCapture()},this.focusWait=function(){var e,t,n,i,r=(e=this.mousedownEvent.x,t=this.mousedownEvent.y,n=this.x,i=this.y,Math.sqrt(Math.pow(n-e,2)+Math.pow(i-t,2))),s=Date.now();(r>0||s-this.mousedownEvent.time>this.$focusTimeout)&&this.startSelect(this.mousedownEvent.getDocumentPosition())},this.onDoubleClick=function(e){var t=e.getDocumentPosition(),n=this.editor,i=n.session.getBracketRange(t);i?(i.isEmpty()&&(i.start.column--,i.end.column++),this.setState("select")):(i=n.selection.getWordRange(t.row,t.column),this.setState("selectByWords")),this.$clickSelection=i,this.select()},this.onTripleClick=function(e){var t=e.getDocumentPosition(),n=this.editor;this.setState("selectByLines");var i=n.getSelectionRange();i.isMultiLine()&&i.contains(t.row,t.column)?(this.$clickSelection=n.selection.getLineRange(i.start.row),this.$clickSelection.end=n.selection.getLineRange(i.end.row).end):this.$clickSelection=n.selection.getLineRange(t.row),this.select()},this.onQuadClick=function(e){var t=this.editor;t.selectAll(),this.$clickSelection=t.getSelectionRange(),this.setState("selectAll")},this.onMouseWheel=function(e){if(!e.getAccelKey()){e.getShiftKey()&&e.wheelY&&!e.wheelX&&(e.wheelX=e.wheelY,e.wheelY=0);var t=this.editor;this.$lastScroll||(this.$lastScroll={t:0,vx:0,vy:0,allowed:0});var n=this.$lastScroll,i=e.domEvent.timeStamp,r=i-n.t,s=r?e.wheelX/r:n.vx,o=r?e.wheelY/r:n.vy;r<550&&(s=(s+n.vx)/2,o=(o+n.vy)/2);var a=Math.abs(s/o),l=!1;return a>=1&&t.renderer.isScrollableBy(e.wheelX*e.speed,0)&&(l=!0),a<=1&&t.renderer.isScrollableBy(0,e.wheelY*e.speed)&&(l=!0),l?n.allowed=i:i-n.allowed<550&&(Math.abs(s)<=1.5*Math.abs(n.vx)&&Math.abs(o)<=1.5*Math.abs(n.vy)?(l=!0,n.allowed=i):n.allowed=0),n.t=i,n.vx=s,n.vy=o,l?(t.renderer.scrollBy(e.wheelX*e.speed,e.wheelY*e.speed),e.stop()):void 0}}}).call(r.prototype),t.DefaultHandlers=r})),ace.define("ace/tooltip",["require","exports","module","ace/lib/oop","ace/lib/dom"],(function(e,t,n){"use strict";e("./lib/oop");var i=e("./lib/dom");function r(e){this.isOpen=!1,this.$element=null,this.$parentNode=e}(function(){this.$init=function(){return this.$element=i.createElement("div"),this.$element.className="ace_tooltip",this.$element.style.display="none",this.$parentNode.appendChild(this.$element),this.$element},this.getElement=function(){return this.$element||this.$init()},this.setText=function(e){this.getElement().textContent=e},this.setHtml=function(e){this.getElement().innerHTML=e},this.setPosition=function(e,t){this.getElement().style.left=e+"px",this.getElement().style.top=t+"px"},this.setClassName=function(e){i.addCssClass(this.getElement(),e)},this.show=function(e,t,n){null!=e&&this.setText(e),null!=t&&null!=n&&this.setPosition(t,n),this.isOpen||(this.getElement().style.display="block",this.isOpen=!0)},this.hide=function(){this.isOpen&&(this.getElement().style.display="none",this.isOpen=!1)},this.getHeight=function(){return this.getElement().offsetHeight},this.getWidth=function(){return this.getElement().offsetWidth},this.destroy=function(){this.isOpen=!1,this.$element&&this.$element.parentNode&&this.$element.parentNode.removeChild(this.$element)}}).call(r.prototype),t.Tooltip=r})),ace.define("ace/mouse/default_gutter_handler",["require","exports","module","ace/lib/dom","ace/lib/oop","ace/lib/event","ace/tooltip"],(function(e,t,n){"use strict";var i=e("../lib/dom"),r=e("../lib/oop"),s=e("../lib/event"),o=e("../tooltip").Tooltip;function a(e){o.call(this,e)}r.inherits(a,o),function(){this.setPosition=function(e,t){var n=window.innerWidth||document.documentElement.clientWidth,i=window.innerHeight||document.documentElement.clientHeight,r=this.getWidth(),s=this.getHeight();(e+=15)+r>n&&(e-=e+r-n),(t+=15)+s>i&&(t-=20+s),o.prototype.setPosition.call(this,e,t)}}.call(a.prototype),t.GutterHandler=function(e){var t,n,r,o=e.editor,l=o.renderer.$gutterLayer,c=new a(o.container);function u(){t&&(t=clearTimeout(t)),r&&(c.hide(),r=null,o._signal("hideGutterTooltip",c),o.removeEventListener("mousewheel",u))}function h(e){c.setPosition(e.x,e.y)}e.editor.setDefaultHandler("guttermousedown",(function(t){if(o.isFocused()&&0==t.getButton()&&"foldWidgets"!=l.getRegion(t)){var n=t.getDocumentPosition().row,i=o.session.selection;if(t.getShiftKey())i.selectTo(n,0);else{if(2==t.domEvent.detail)return o.selectAll(),t.preventDefault();e.$clickSelection=o.selection.getLineRange(n)}return e.setState("selectByLines"),e.captureMouse(t),t.preventDefault()}})),e.editor.setDefaultHandler("guttermousemove",(function(s){var a=s.domEvent.target||s.domEvent.srcElement;if(i.hasCssClass(a,"ace_fold-widget"))return u();r&&e.$tooltipFollowsMouse&&h(s),n=s,t||(t=setTimeout((function(){t=null,n&&!e.isMousePressed?function(){var t=n.getDocumentPosition().row,i=l.$annotations[t];if(!i)return u();if(t==o.session.getLength()){var s=o.renderer.pixelToScreenCoordinates(0,n.y).row,a=n.$pos;if(s>o.session.documentToScreenRow(a.row,a.column))return u()}if(r!=i)if(r=i.text.join("<br/>"),c.setHtml(r),c.show(),o._signal("showGutterTooltip",c),o.on("mousewheel",u),e.$tooltipFollowsMouse)h(n);else{var d=n.domEvent.target.getBoundingClientRect(),m=c.getElement().style;m.left=d.right+"px",m.top=d.bottom+"px"}}():u()}),50))})),s.addListener(o.renderer.$gutter,"mouseout",(function(e){n=null,r&&!t&&(t=setTimeout((function(){t=null,u()}),50))})),o.on("changeSession",u)}})),ace.define("ace/mouse/mouse_event",["require","exports","module","ace/lib/event","ace/lib/useragent"],(function(e,t,n){"use strict";var i=e("../lib/event"),r=e("../lib/useragent"),s=t.MouseEvent=function(e,t){this.domEvent=e,this.editor=t,this.x=this.clientX=e.clientX,this.y=this.clientY=e.clientY,this.$pos=null,this.$inSelection=null,this.propagationStopped=!1,this.defaultPrevented=!1};(function(){this.stopPropagation=function(){i.stopPropagation(this.domEvent),this.propagationStopped=!0},this.preventDefault=function(){i.preventDefault(this.domEvent),this.defaultPrevented=!0},this.stop=function(){this.stopPropagation(),this.preventDefault()},this.getDocumentPosition=function(){return this.$pos||(this.$pos=this.editor.renderer.screenToTextCoordinates(this.clientX,this.clientY)),this.$pos},this.inSelection=function(){if(null!==this.$inSelection)return this.$inSelection;var e=this.editor.getSelectionRange();if(e.isEmpty())this.$inSelection=!1;else{var t=this.getDocumentPosition();this.$inSelection=e.contains(t.row,t.column)}return this.$inSelection},this.getButton=function(){return i.getButton(this.domEvent)},this.getShiftKey=function(){return this.domEvent.shiftKey},this.getAccelKey=r.isMac?function(){return this.domEvent.metaKey}:function(){return this.domEvent.ctrlKey}}).call(s.prototype)})),ace.define("ace/mouse/dragdrop_handler",["require","exports","module","ace/lib/dom","ace/lib/event","ace/lib/useragent"],(function(e,t,n){"use strict";var i=e("../lib/dom"),r=e("../lib/event"),s=e("../lib/useragent");function o(e){var t=e.editor,n=i.createElement("img");n.src="data:image/gif;base64,R0lGODlhAQABAAAAACH5BAEKAAEALAAAAAABAAEAAAICTAEAOw==",s.isOpera&&(n.style.cssText="width:1px;height:1px;position:fixed;top:0;left:0;z-index:2147483647;opacity:0;"),["dragWait","dragWaitEnd","startDrag","dragReadyEnd","onMouseDrag"].forEach((function(t){e[t]=this[t]}),this),t.addEventListener("mousedown",this.onMouseDown.bind(e));var o,l,c,u,h,d,m,p,g,f,E,v=t.container,_=0;function C(){var e=d;(function(e,n){var i=Date.now(),r=!n||e.row!=n.row,s=!n||e.column!=n.column;!f||r||s?(t.moveCursorToPosition(e),f=i,E={x:l,y:c}):a(E.x,E.y,l,c)>5?f=null:i-f>=200&&(t.renderer.scrollCursorIntoView(),f=null)})(d=t.renderer.screenToTextCoordinates(l,c),e),function(e,n){var i=Date.now(),r=t.renderer.layerConfig.lineHeight,s=t.renderer.layerConfig.characterWidth,o=t.renderer.scroller.getBoundingClientRect(),a={x:{left:l-o.left,right:o.right-l},y:{top:c-o.top,bottom:o.bottom-c}},u=Math.min(a.x.left,a.x.right),h=Math.min(a.y.top,a.y.bottom),d={row:e.row,column:e.column};u/s<=2&&(d.column+=a.x.left<a.x.right?-3:2),h/r<=1&&(d.row+=a.y.top<a.y.bottom?-1:1);var m=e.row!=d.row,p=e.column!=d.column,f=!n||e.row!=n.row;m||p&&!f?g?i-g>=200&&t.renderer.scrollCursorIntoView(d):g=i:g=null}(d,e)}function A(){h=t.selection.toOrientedRange(),o=t.session.addMarker(h,"ace_selection",t.getSelectionStyle()),t.clearSelection(),t.isFocused()&&t.renderer.$cursorLayer.setBlinking(!1),clearInterval(u),C(),u=setInterval(C,20),_=0,r.addListener(document,"mousemove",T)}function R(){clearInterval(u),t.session.removeMarker(o),o=null,t.selection.fromOrientedRange(h),t.isFocused()&&!p&&t.$resetCursorStyle(),h=null,d=null,_=0,g=null,f=null,r.removeListener(document,"mousemove",T)}this.onDragStart=function(e){if(this.cancelDrag||!v.draggable){var i=this;return setTimeout((function(){i.startSelect(),i.captureMouse(e)}),0),e.preventDefault()}h=t.getSelectionRange();var r=e.dataTransfer;r.effectAllowed=t.getReadOnly()?"copy":"copyMove",s.isOpera&&(t.container.appendChild(n),n.scrollTop=0),r.setDragImage&&r.setDragImage(n,0,0),s.isOpera&&t.container.removeChild(n),r.clearData(),r.setData("Text",t.session.getTextRange()),p=!0,this.setState("drag")},this.onDragEnd=function(e){if(v.draggable=!1,p=!1,this.setState(null),!t.getReadOnly()){var n=e.dataTransfer.dropEffect;m||"move"!=n||t.session.remove(t.getSelectionRange()),t.$resetCursorStyle()}this.editor.unsetStyle("ace_dragging"),this.editor.renderer.setCursorStyle("")},this.onDragEnter=function(e){if(!t.getReadOnly()&&b(e.dataTransfer))return l=e.clientX,c=e.clientY,o||A(),_++,e.dataTransfer.dropEffect=m=w(e),r.preventDefault(e)},this.onDragOver=function(e){if(!t.getReadOnly()&&b(e.dataTransfer))return l=e.clientX,c=e.clientY,o||(A(),_++),null!==S&&(S=null),e.dataTransfer.dropEffect=m=w(e),r.preventDefault(e)},this.onDragLeave=function(e){if(--_<=0&&o)return R(),m=null,r.preventDefault(e)},this.onDrop=function(e){if(d){var n=e.dataTransfer;if(p)switch(m){case"move":h=h.contains(d.row,d.column)?{start:d,end:d}:t.moveText(h,d);break;case"copy":h=t.moveText(h,d,!0)}else{var i=n.getData("Text");h={start:d,end:t.session.insert(d,i)},t.focus(),m=null}return R(),r.preventDefault(e)}},r.addListener(v,"dragstart",this.onDragStart.bind(e)),r.addListener(v,"dragend",this.onDragEnd.bind(e)),r.addListener(v,"dragenter",this.onDragEnter.bind(e)),r.addListener(v,"dragover",this.onDragOver.bind(e)),r.addListener(v,"dragleave",this.onDragLeave.bind(e)),r.addListener(v,"drop",this.onDrop.bind(e));var S=null;function T(){null==S&&(S=setTimeout((function(){null!=S&&o&&R()}),20))}function b(e){var t=e.types;return!t||Array.prototype.some.call(t,(function(e){return"text/plain"==e||"Text"==e}))}function w(e){var t=["copy","copymove","all","uninitialized"],n=s.isMac?e.altKey:e.ctrlKey,i="uninitialized";try{i=e.dataTransfer.effectAllowed.toLowerCase()}catch(e){}var r="none";return n&&t.indexOf(i)>=0?r="copy":["move","copymove","linkmove","all","uninitialized"].indexOf(i)>=0?r="move":t.indexOf(i)>=0&&(r="copy"),r}}function a(e,t,n,i){return Math.sqrt(Math.pow(n-e,2)+Math.pow(i-t,2))}(function(){this.dragWait=function(){Date.now()-this.mousedownEvent.time>this.editor.getDragDelay()&&this.startDrag()},this.dragWaitEnd=function(){this.editor.container.draggable=!1,this.startSelect(this.mousedownEvent.getDocumentPosition()),this.selectEnd()},this.dragReadyEnd=function(e){this.editor.$resetCursorStyle(),this.editor.unsetStyle("ace_dragging"),this.editor.renderer.setCursorStyle(""),this.dragWaitEnd()},this.startDrag=function(){this.cancelDrag=!1;var e=this.editor;e.container.draggable=!0,e.renderer.$cursorLayer.setBlinking(!1),e.setStyle("ace_dragging");var t=s.isWin?"default":"move";e.renderer.setCursorStyle(t),this.setState("dragReady")},this.onMouseDrag=function(e){var t=this.editor.container;s.isIE&&"dragReady"==this.state&&a(this.mousedownEvent.x,this.mousedownEvent.y,this.x,this.y)>3&&t.dragDrop(),"dragWait"===this.state&&a(this.mousedownEvent.x,this.mousedownEvent.y,this.x,this.y)>0&&(t.draggable=!1,this.startSelect(this.mousedownEvent.getDocumentPosition()))},this.onMouseDown=function(e){if(this.$dragEnabled){this.mousedownEvent=e;var t=this.editor,n=e.inSelection(),i=e.getButton();if(1===(e.domEvent.detail||1)&&0===i&&n){if(e.editor.inMultiSelectMode&&(e.getAccelKey()||e.getShiftKey()))return;this.mousedownEvent.time=Date.now();var r=e.domEvent.target||e.domEvent.srcElement;"unselectable"in r&&(r.unselectable="on"),t.getDragDelay()?(s.isWebKit&&(this.cancelDrag=!0,t.container.draggable=!0),this.setState("dragWait")):this.startDrag(),this.captureMouse(e,this.onMouseDrag.bind(this)),e.defaultPrevented=!0}}}}).call(o.prototype),t.DragdropHandler=o})),ace.define("ace/mouse/touch_handler",["require","exports","module","ace/mouse/mouse_event","ace/lib/dom"],(function(e,t,n){"use strict";var i=e("./mouse_event").MouseEvent,r=e("../lib/dom");t.addTouchListeners=function(e,t){var n,s,o,a,l,c,u,h,d,m="scroll",p=0,g=0,f=0,E=0;function v(){var e,n,i;d||(e=window.navigator&&window.navigator.clipboard,n=!1,i=function(i){var s,o,a=i.target.getAttribute("action");if("more"==a||!n)return n=!n,s=t.getCopyText(),o=t.session.getUndoManager().hasUndo(),void d.replaceChild(r.buildDom(n?["span",!s&&["span",{class:"ace_mobile-button",action:"selectall"},"Select All"],s&&["span",{class:"ace_mobile-button",action:"copy"},"Copy"],s&&["span",{class:"ace_mobile-button",action:"cut"},"Cut"],e&&["span",{class:"ace_mobile-button",action:"paste"},"Paste"],o&&["span",{class:"ace_mobile-button",action:"undo"},"Undo"],["span",{class:"ace_mobile-button",action:"find"},"Find"],["span",{class:"ace_mobile-button",action:"openCommandPallete"},"Pallete"]]:["span"]),d.firstChild);"paste"==a?e.readText().then((function(e){t.execCommand(a,e)})):a&&("cut"!=a&&"copy"!=a||(e?e.writeText(t.getCopyText()):document.execCommand("copy")),t.execCommand(a)),d.firstChild.style.display="none",n=!1,"openCommandPallete"!=a&&t.focus()},d=r.buildDom(["div",{class:"ace_mobile-menu",ontouchstart:function(e){m="menu",e.stopPropagation(),e.preventDefault(),t.textInput.focus()},ontouchend:function(e){e.stopPropagation(),e.preventDefault(),i(e)},onclick:i},["span"],["span",{class:"ace_mobile-button",action:"more"},"..."]],t.container));var s=t.selection.cursor,o=t.renderer.textToScreenCoordinates(s.row,s.column),a=t.container.getBoundingClientRect();d.style.top=o.pageY-a.top-3+"px",d.style.right="10px",d.style.display="",d.firstChild.style.display="none",t.on("input",_)}function _(e){d&&(d.style.display="none"),t.off("input",_)}function C(){l=null,clearTimeout(l);var e=t.selection.getRange(),n=e.contains(u.row,u.column);!e.isEmpty()&&n||(t.selection.moveToPosition(u),t.selection.selectWord()),m="wait",v()}e.addEventListener("contextmenu",(function(e){h&&t.textInput.getElement().focus()})),e.addEventListener("touchstart",(function(e){var r=e.touches;if(l||r.length>1)return clearTimeout(l),l=null,o=-1,void(m="zoom");h=t.$mouseHandler.isMousePressed=!0;var c=t.renderer.layerConfig.lineHeight,d=t.renderer.layerConfig.lineHeight,v=e.timeStamp;a=v;var _=r[0],A=_.clientX,R=_.clientY;Math.abs(n-A)+Math.abs(s-R)>c&&(o=-1),n=e.clientX=A,s=e.clientY=R,f=E=0;var S=new i(e,t);if(u=S.getDocumentPosition(),v-o<500&&1==r.length&&!p)g++,e.preventDefault(),e.button=0,function(){l=null,clearTimeout(l),t.selection.moveToPosition(u);var e=g>=2?t.selection.getLineRange(u.row):t.session.getBracketRange(u);e&&!e.isEmpty()?t.selection.setRange(e):t.selection.selectWord(),m="wait"}();else{g=0;var T=t.selection.cursor,b=t.selection.isEmpty()?T:t.selection.anchor,w=t.renderer.$cursorLayer.getPixelPosition(T,!0),x=t.renderer.$cursorLayer.getPixelPosition(b,!0),y=t.renderer.scroller.getBoundingClientRect(),L=function(e,t){return(e/=d)*e+(t=t/c-.75)*t};if(e.clientX<y.left)return void(m="zoom");var I=L(e.clientX-y.left-w.left,e.clientY-y.top-w.top),F=L(e.clientX-y.left-x.left,e.clientY-y.top-x.top);I<3.5&&F<3.5&&(m=I>F?"cursor":"anchor"),m=F<3.5?"anchor":I<3.5?"cursor":"scroll",l=setTimeout(C,450)}o=v})),e.addEventListener("touchend",(function(e){h=t.$mouseHandler.isMousePressed=!1,c&&clearInterval(c),"zoom"==m?(m="",p=0):l?(t.selection.moveToPosition(u),p=0,v()):"scroll"==m?(p+=60,c=setInterval((function(){p--<=0&&(clearInterval(c),c=null),Math.abs(f)<.01&&(f=0),Math.abs(E)<.01&&(E=0),p<20&&(f*=.9),p<20&&(E*=.9);var e=t.session.getScrollTop();t.renderer.scrollBy(10*f,10*E),e==t.session.getScrollTop()&&(p=0)}),10),e.preventDefault(),_()):v(),clearTimeout(l),l=null})),e.addEventListener("touchmove",(function(e){l&&(clearTimeout(l),l=null);var r=e.touches;if(!(r.length>1||"zoom"==m)){var o=r[0],c=n-o.clientX,u=s-o.clientY;if("wait"==m){if(!(c*c+u*u>4))return e.preventDefault();m="cursor"}n=o.clientX,s=o.clientY,e.clientX=o.clientX,e.clientY=o.clientY;var h=e.timeStamp,d=h-a;if(a=h,"scroll"==m){var p=new i(e,t);p.speed=1,p.wheelX=c,p.wheelY=u,10*Math.abs(c)<Math.abs(u)&&(c=0),10*Math.abs(u)<Math.abs(c)&&(u=0),0!=d&&(f=c/d,E=u/d),t._emit("mousewheel",p),p.propagationStopped||(f=E=0)}else{var g=new i(e,t).getDocumentPosition();"cursor"==m?t.selection.moveCursorToPosition(g):"anchor"==m&&t.selection.setSelectionAnchor(g.row,g.column),t.renderer.scrollCursorIntoView(g),e.preventDefault()}}}))}})),ace.define("ace/lib/net",["require","exports","module","ace/lib/dom"],(function(e,t,n){"use strict";var i=e("./dom");t.get=function(e,t){var n=new XMLHttpRequest;n.open("GET",e,!0),n.onreadystatechange=function(){4===n.readyState&&t(n.responseText)},n.send(null)},t.loadScript=function(e,t){var n=i.getDocumentHead(),r=document.createElement("script");r.src=e,n.appendChild(r),r.onload=r.onreadystatechange=function(e,n){!n&&r.readyState&&"loaded"!=r.readyState&&"complete"!=r.readyState||(r=r.onload=r.onreadystatechange=null,n||t())}},t.qualifyURL=function(e){var t=document.createElement("a");return t.href=e,t.href}})),ace.define("ace/lib/event_emitter",["require","exports","module"],(function(e,t,n){"use strict";var i={},r=function(){this.propagationStopped=!0},s=function(){this.defaultPrevented=!0};i._emit=i._dispatchEvent=function(e,t){this._eventRegistry||(this._eventRegistry={}),this._defaultHandlers||(this._defaultHandlers={});var n=this._eventRegistry[e]||[],i=this._defaultHandlers[e];if(n.length||i){"object"==typeof t&&t||(t={}),t.type||(t.type=e),t.stopPropagation||(t.stopPropagation=r),t.preventDefault||(t.preventDefault=s),n=n.slice();for(var o=0;o<n.length&&(n[o](t,this),!t.propagationStopped);o++);return i&&!t.defaultPrevented?i(t,this):void 0}},i._signal=function(e,t){var n=(this._eventRegistry||{})[e];if(n){n=n.slice();for(var i=0;i<n.length;i++)n[i](t,this)}},i.once=function(e,t){var n=this;if(this.addEventListener(e,(function i(){n.removeEventListener(e,i),t.apply(null,arguments)})),!t)return new Promise((function(e){t=e}))},i.setDefaultHandler=function(e,t){var n=this._defaultHandlers;if(n||(n=this._defaultHandlers={_disabled_:{}}),n[e]){var i=n[e],r=n._disabled_[e];r||(n._disabled_[e]=r=[]),r.push(i);var s=r.indexOf(t);-1!=s&&r.splice(s,1)}n[e]=t},i.removeDefaultHandler=function(e,t){var n=this._defaultHandlers;if(n){var i=n._disabled_[e];if(n[e]==t)i&&this.setDefaultHandler(e,i.pop());else if(i){var r=i.indexOf(t);-1!=r&&i.splice(r,1)}}},i.on=i.addEventListener=function(e,t,n){this._eventRegistry=this._eventRegistry||{};var i=this._eventRegistry[e];return i||(i=this._eventRegistry[e]=[]),-1==i.indexOf(t)&&i[n?"unshift":"push"](t),t},i.off=i.removeListener=i.removeEventListener=function(e,t){this._eventRegistry=this._eventRegistry||{};var n=this._eventRegistry[e];if(n){var i=n.indexOf(t);-1!==i&&n.splice(i,1)}},i.removeAllListeners=function(e){this._eventRegistry&&(this._eventRegistry[e]=[])},t.EventEmitter=i})),ace.define("ace/lib/app_config",["require","exports","module","ace/lib/oop","ace/lib/event_emitter"],(function(e,t,n){var i=e("./oop"),r=e("./event_emitter").EventEmitter,s={setOptions:function(e){Object.keys(e).forEach((function(t){this.setOption(t,e[t])}),this)},getOptions:function(e){var t={};if(e)Array.isArray(e)||(t=e,e=Object.keys(t));else{var n=this.$options;e=Object.keys(n).filter((function(e){return!n[e].hidden}))}return e.forEach((function(e){t[e]=this.getOption(e)}),this),t},setOption:function(e,t){if(this["$"+e]!==t){var n=this.$options[e];if(!n)return o('misspelled option "'+e+'"');if(n.forwardTo)return this[n.forwardTo]&&this[n.forwardTo].setOption(e,t);n.handlesSet||(this["$"+e]=t),n&&n.set&&n.set.call(this,t)}},getOption:function(e){var t=this.$options[e];return t?t.forwardTo?this[t.forwardTo]&&this[t.forwardTo].getOption(e):t&&t.get?t.get.call(this):this["$"+e]:o('misspelled option "'+e+'"')}};function o(e){"undefined"!=typeof console&&console.warn&&console.warn.apply(console,arguments)}function a(e,t){var n=new Error(e);n.data=t,"object"==typeof console&&console.error&&console.error(n),setTimeout((function(){throw n}))}var l=function(){this.$defaultOptions={}};(function(){i.implement(this,r),this.defineOptions=function(e,t,n){return e.$options||(this.$defaultOptions[t]=e.$options={}),Object.keys(n).forEach((function(t){var i=n[t];"string"==typeof i&&(i={forwardTo:i}),i.name||(i.name=t),e.$options[i.name]=i,"initialValue"in i&&(e["$"+i.name]=i.initialValue)})),i.implement(e,s),this},this.resetOptions=function(e){Object.keys(e.$options).forEach((function(t){var n=e.$options[t];"value"in n&&e.setOption(t,n.value)}))},this.setDefaultValue=function(e,t,n){if(!e){for(e in this.$defaultOptions)if(this.$defaultOptions[e][t])break;if(!this.$defaultOptions[e][t])return!1}var i=this.$defaultOptions[e]||(this.$defaultOptions[e]={});i[t]&&(i.forwardTo?this.setDefaultValue(i.forwardTo,t,n):i[t].value=n)},this.setDefaultValues=function(e,t){Object.keys(t).forEach((function(n){this.setDefaultValue(e,n,t[n])}),this)},this.warn=o,this.reportError=a}).call(l.prototype),t.AppConfig=l})),ace.define("ace/config",["require","exports","module","ace/lib/lang","ace/lib/oop","ace/lib/net","ace/lib/app_config"],(function(e,t,i){var r=e("./lib/lang"),s=(e("./lib/oop"),e("./lib/net")),o=e("./lib/app_config").AppConfig;i.exports=t=new o;var a=function(){return this||"undefined"!=typeof window&&window}(),l={packaged:!1,workerPath:null,modePath:null,themePath:null,basePath:"",suffix:".js",$moduleUrls:{},loadWorkerFromBlob:!0,sharedPopups:!1};t.get=function(e){if(!l.hasOwnProperty(e))throw new Error("Unknown config key: "+e);return l[e]},t.set=function(e,t){if(l.hasOwnProperty(e))l[e]=t;else if(0==this.setDefaultValue("",e,t))throw new Error("Unknown config key: "+e)},t.all=function(){return r.copyObject(l)},t.$modes={},t.moduleUrl=function(e,t){if(l.$moduleUrls[e])return l.$moduleUrls[e];var n=e.split("/"),i="snippets"==(t=t||n[n.length-2]||"")?"/":"-",r=n[n.length-1];if("worker"==t&&"-"==i){var s=new RegExp("^"+t+"[\\-_]|[\\-_]"+t+"$","g");r=r.replace(s,"")}(!r||r==t)&&n.length>1&&(r=n[n.length-2]);var o=l[t+"Path"];return null==o?o=l.basePath:"/"==i&&(t=i=""),o&&"/"!=o.slice(-1)&&(o+="/"),o+t+i+r+this.get("suffix")},t.setModuleUrl=function(e,t){return l.$moduleUrls[e]=t},t.$loading={},t.loadModule=function(n,i){var r,o;Array.isArray(n)&&(o=n[0],n=n[1]);try{r=e(n)}catch(e){}if(r&&!t.$loading[n])return i&&i(r);if(t.$loading[n]||(t.$loading[n]=[]),t.$loading[n].push(i),!(t.$loading[n].length>1)){var a=function(){e([n],(function(e){t._emit("load.module",{name:n,module:e});var i=t.$loading[n];t.$loading[n]=null,i.forEach((function(t){t&&t(e)}))}))};if(!t.get("packaged"))return a();s.loadScript(t.moduleUrl(n,o),a),c()}};var c=function(){l.basePath||l.workerPath||l.modePath||l.themePath||Object.keys(l.$moduleUrls).length||(console.error("Unable to infer path to ace from script src,","use ace.config.set('basePath', 'path') to enable dynamic loading of modes and themes","or with webpack use ace/webpack-resolver"),c=function(){})};function u(r){if(a&&a.document){l.packaged=r||e.packaged||i.packaged||a.define&&n.amdD.packaged;for(var s,o={},c="",u=document.currentScript||document._currentScript,h=(u&&u.ownerDocument||document).getElementsByTagName("script"),d=0;d<h.length;d++){var m=h[d],p=m.src||m.getAttribute("src");if(p){for(var g=m.attributes,f=0,E=g.length;f<E;f++){var v=g[f];0===v.name.indexOf("data-ace-")&&(o[(s=v.name.replace(/^data-ace-/,""),s.replace(/-(.)/g,(function(e,t){return t.toUpperCase()})))]=v.value)}var _=p.match(/^(.*)\/ace(\-\w+)?\.js(\?|$)/);_&&(c=_[1])}}for(var C in c&&(o.base=o.base||c,o.packaged=!0),o.basePath=o.base,o.workerPath=o.workerPath||o.base,o.modePath=o.modePath||o.base,o.themePath=o.themePath||o.base,delete o.base,o)void 0!==o[C]&&t.set(C,o[C])}}u(!0),t.init=u,t.version="1.4.7"})),ace.define("ace/mouse/mouse_handler",["require","exports","module","ace/lib/event","ace/lib/useragent","ace/mouse/default_handlers","ace/mouse/default_gutter_handler","ace/mouse/mouse_event","ace/mouse/dragdrop_handler","ace/mouse/touch_handler","ace/config"],(function(e,t,n){"use strict";var i=e("../lib/event"),r=e("../lib/useragent"),s=e("./default_handlers").DefaultHandlers,o=e("./default_gutter_handler").GutterHandler,a=e("./mouse_event").MouseEvent,l=e("./dragdrop_handler").DragdropHandler,c=e("./touch_handler").addTouchListeners,u=e("../config"),h=function(e){var t=this;this.editor=e,new s(this),new o(this),new l(this);var n=function(t){(!document.hasFocus||!document.hasFocus()||!e.isFocused()&&document.activeElement==(e.textInput&&e.textInput.getElement()))&&window.focus(),e.focus()},a=e.renderer.getMouseEventTarget();i.addListener(a,"click",this.onMouseEvent.bind(this,"click")),i.addListener(a,"mousemove",this.onMouseMove.bind(this,"mousemove")),i.addMultiMouseDownListener([a,e.renderer.scrollBarV&&e.renderer.scrollBarV.inner,e.renderer.scrollBarH&&e.renderer.scrollBarH.inner,e.textInput&&e.textInput.getElement()].filter(Boolean),[400,300,250],this,"onMouseEvent"),i.addMouseWheelListener(e.container,this.onMouseWheel.bind(this,"mousewheel")),c(e.container,e);var u=e.renderer.$gutter;i.addListener(u,"mousedown",this.onMouseEvent.bind(this,"guttermousedown")),i.addListener(u,"click",this.onMouseEvent.bind(this,"gutterclick")),i.addListener(u,"dblclick",this.onMouseEvent.bind(this,"gutterdblclick")),i.addListener(u,"mousemove",this.onMouseEvent.bind(this,"guttermousemove")),i.addListener(a,"mousedown",n),i.addListener(u,"mousedown",n),r.isIE&&e.renderer.scrollBarV&&(i.addListener(e.renderer.scrollBarV.element,"mousedown",n),i.addListener(e.renderer.scrollBarH.element,"mousedown",n)),e.on("mousemove",(function(n){if(!t.state&&!t.$dragDelay&&t.$dragEnabled){var i=e.renderer.screenToTextCoordinates(n.x,n.y),r=e.session.selection.getRange(),s=e.renderer;!r.isEmpty()&&r.insideStart(i.row,i.column)?s.setCursorStyle("default"):s.setCursorStyle("")}}))};(function(){this.onMouseEvent=function(e,t){this.editor._emit(e,new a(t,this.editor))},this.onMouseMove=function(e,t){var n=this.editor._eventRegistry&&this.editor._eventRegistry.mousemove;n&&n.length&&this.editor._emit(e,new a(t,this.editor))},this.onMouseWheel=function(e,t){var n=new a(t,this.editor);n.speed=2*this.$scrollSpeed,n.wheelX=t.wheelX,n.wheelY=t.wheelY,this.editor._emit(e,n)},this.setState=function(e){this.state=e},this.captureMouse=function(e,t){this.x=e.x,this.y=e.y,this.isMousePressed=!0;var n=this.editor,s=this.editor.renderer;s.$isMousePressed=!0;var o=this,l=function(e){if(e){if(r.isWebKit&&!e.which&&o.releaseMouse)return o.releaseMouse();o.x=e.clientX,o.y=e.clientY,t&&t(e),o.mouseEvent=new a(e,o.editor),o.$mouseMoved=!0}},c=function(e){n.off("beforeEndOperation",h),clearInterval(d),u(),o[o.state+"End"]&&o[o.state+"End"](e),o.state="",o.isMousePressed=s.$isMousePressed=!1,s.$keepTextAreaAtCursor&&s.$moveTextAreaToCursor(),o.$onCaptureMouseMove=o.releaseMouse=null,e&&o.onMouseEvent("mouseup",e),n.endOperation()},u=function(){o[o.state]&&o[o.state](),o.$mouseMoved=!1};if(r.isOldIE&&"dblclick"==e.domEvent.type)return setTimeout((function(){c(e)}));var h=function(e){o.releaseMouse&&n.curOp.command.name&&n.curOp.selectionChanged&&(o[o.state+"End"]&&o[o.state+"End"](),o.state="",o.releaseMouse())};n.on("beforeEndOperation",h),n.startOperation({command:{name:"mouse"}}),o.$onCaptureMouseMove=l,o.releaseMouse=i.capture(this.editor.container,l,c);var d=setInterval(u,20)},this.releaseMouse=null,this.cancelContextMenu=function(){var e=function(t){t&&t.domEvent&&"contextmenu"!=t.domEvent.type||(this.editor.off("nativecontextmenu",e),t&&t.domEvent&&i.stopEvent(t.domEvent))}.bind(this);setTimeout(e,10),this.editor.on("nativecontextmenu",e)}}).call(h.prototype),u.defineOptions(h.prototype,"mouseHandler",{scrollSpeed:{initialValue:2},dragDelay:{initialValue:r.isMac?150:0},dragEnabled:{initialValue:!0},focusTimeout:{initialValue:0},tooltipFollowsMouse:{initialValue:!0}}),t.MouseHandler=h})),ace.define("ace/mouse/fold_handler",["require","exports","module","ace/lib/dom"],(function(e,t,n){"use strict";var i=e("../lib/dom");t.FoldHandler=function(e){e.on("click",(function(t){var n=t.getDocumentPosition(),r=e.session,s=r.getFoldAt(n.row,n.column,1);s&&(t.getAccelKey()?r.removeFold(s):r.expandFold(s),t.stop());var o=t.domEvent&&t.domEvent.target;o&&i.hasCssClass(o,"ace_inline_button")&&i.hasCssClass(o,"ace_toggle_wrap")&&(r.setOption("wrap",!r.getUseWrapMode()),e.renderer.scrollCursorIntoView())})),e.on("gutterclick",(function(t){if("foldWidgets"==e.renderer.$gutterLayer.getRegion(t)){var n=t.getDocumentPosition().row,i=e.session;i.foldWidgets&&i.foldWidgets[n]&&e.session.onFoldWidgetClick(n,t),e.isFocused()||e.focus(),t.stop()}})),e.on("gutterdblclick",(function(t){if("foldWidgets"==e.renderer.$gutterLayer.getRegion(t)){var n=t.getDocumentPosition().row,i=e.session,r=i.getParentFoldRangeData(n,!0),s=r.range||r.firstRange;if(s){n=s.start.row;var o=i.getFoldAt(n,i.getLine(n).length,1);o?i.removeFold(o):(i.addFold("...",s),e.renderer.scrollCursorIntoView({row:s.start.row,column:0}))}t.stop()}}))}})),ace.define("ace/keyboard/keybinding",["require","exports","module","ace/lib/keys","ace/lib/event"],(function(e,t,n){"use strict";var i=e("../lib/keys"),r=e("../lib/event"),s=function(e){this.$editor=e,this.$data={editor:e},this.$handlers=[],this.setDefaultHandler(e.commands)};(function(){this.setDefaultHandler=function(e){this.removeKeyboardHandler(this.$defaultHandler),this.$defaultHandler=e,this.addKeyboardHandler(e,0)},this.setKeyboardHandler=function(e){var t=this.$handlers;if(t[t.length-1]!=e){for(;t[t.length-1]&&t[t.length-1]!=this.$defaultHandler;)this.removeKeyboardHandler(t[t.length-1]);this.addKeyboardHandler(e,1)}},this.addKeyboardHandler=function(e,t){if(e){"function"!=typeof e||e.handleKeyboard||(e.handleKeyboard=e);var n=this.$handlers.indexOf(e);-1!=n&&this.$handlers.splice(n,1),null==t?this.$handlers.push(e):this.$handlers.splice(t,0,e),-1==n&&e.attach&&e.attach(this.$editor)}},this.removeKeyboardHandler=function(e){var t=this.$handlers.indexOf(e);return-1!=t&&(this.$handlers.splice(t,1),e.detach&&e.detach(this.$editor),!0)},this.getKeyboardHandler=function(){return this.$handlers[this.$handlers.length-1]},this.getStatusText=function(){var e=this.$data,t=e.editor;return this.$handlers.map((function(n){return n.getStatusText&&n.getStatusText(t,e)||""})).filter(Boolean).join(" ")},this.$callKeyboardHandlers=function(e,t,n,i){for(var s,o=!1,a=this.$editor.commands,l=this.$handlers.length;l--&&!((s=this.$handlers[l].handleKeyboard(this.$data,e,t,n,i))&&s.command&&((o="null"==s.command||a.exec(s.command,this.$editor,s.args,i))&&i&&-1!=e&&1!=s.passEvent&&1!=s.command.passEvent&&r.stopEvent(i),o)););return o||-1!=e||(s={command:"insertstring"},o=a.exec("insertstring",this.$editor,t)),o&&this.$editor._signal&&this.$editor._signal("keyboardActivity",s),o},this.onCommandKey=function(e,t,n){var r=i.keyCodeToString(n);return this.$callKeyboardHandlers(t,r,n,e)},this.onTextInput=function(e){return this.$callKeyboardHandlers(-1,e)}}).call(s.prototype),t.KeyBinding=s})),ace.define("ace/lib/bidiutil",["require","exports","module"],(function(e,t,n){"use strict";var i=0,r=0,s=!1,o=!1,a=!1,l=[[0,3,0,1,0,0,0],[0,3,0,1,2,2,0],[0,3,0,17,2,0,1],[0,3,5,5,4,1,0],[0,3,21,21,4,0,1],[0,3,5,5,4,2,0]],c=[[2,0,1,1,0,1,0],[2,0,1,1,0,2,0],[2,0,2,1,3,2,0],[2,0,2,33,3,1,1]],u=11,h=18,d=[h,h,h,h,h,h,h,h,h,6,5,6,8,5,h,h,h,h,h,h,h,h,h,h,h,h,h,h,5,5,5,6,8,4,4,u,u,u,4,4,4,4,4,10,9,10,9,9,2,2,2,2,2,2,2,2,2,2,9,4,4,4,4,4,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,4,4,4,4,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,4,4,4,h,h,h,h,h,h,5,h,h,h,h,h,h,h,h,h,h,h,h,h,h,h,h,h,h,h,h,h,h,h,h,h,h,9,4,u,u,u,u,4,4,4,4,0,4,4,h,4,4,u,u,2,2,4,0,4,4,4,2,0,4,4,4,4,4],m=[8,8,8,8,8,8,8,8,8,8,8,h,h,h,0,1,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,8,5,13,14,15,16,17,9,u,u,u,u,u,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,9,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,8];function p(e,t,n){if(!(r<e))if(1!=e||1!=i||o)for(var s,a,l,c,u=n.length,h=0;h<u;){if(t[h]>=e){for(s=h+1;s<u&&t[s]>=e;)s++;for(a=h,l=s-1;a<l;a++,l--)c=n[a],n[a]=n[l],n[l]=c;h=s}h++}else n.reverse()}function g(e,t,n,r){var l,c,d,m,p=t[r];switch(p){case 0:case 1:s=!1;case 4:case 3:return p;case 2:return s?3:2;case 7:return s=!0,1;case 8:return 4;case 9:return r<1||r+1>=t.length||2!=(l=n[r-1])&&3!=l||2!=(c=t[r+1])&&3!=c?4:(s&&(c=3),c==l?c:4);case 10:return 2==(l=r>0?n[r-1]:5)&&r+1<t.length&&2==t[r+1]?2:4;case u:if(r>0&&2==n[r-1])return 2;if(s)return 4;for(m=r+1,d=t.length;m<d&&t[m]==u;)m++;return m<d&&2==t[m]?2:4;case 12:for(d=t.length,m=r+1;m<d&&12==t[m];)m++;if(m<d){var g=e[r],f=g>=1425&&g<=2303||64286==g;if(l=t[m],f&&(1==l||7==l))return 1}return r<1||5==(l=t[r-1])?4:n[r-1];case 5:return s=!1,o=!0,i;case 6:return a=!0,4;case 13:case 14:case 16:case 17:case 15:s=!1;case h:return 4}}function f(e){var t=e.charCodeAt(0),n=t>>8;return 0==n?t>191?0:d[t]:5==n?/[\u0591-\u05f4]/.test(e)?1:0:6==n?/[\u0610-\u061a\u064b-\u065f\u06d6-\u06e4\u06e7-\u06ed]/.test(e)?12:/[\u0660-\u0669\u066b-\u066c]/.test(e)?3:1642==t?u:/[\u06f0-\u06f9]/.test(e)?2:7:32==n&&t<=8287?m[255&t]:254==n&&t>=65136?7:4}t.L=0,t.R=1,t.EN=2,t.ON_R=3,t.AN=4,t.R_H=5,t.B=6,t.RLE=7,t.DOT="·",t.doBidiReorder=function(e,n,u){if(e.length<2)return{};var d=e.split(""),m=new Array(d.length),E=new Array(d.length),v=[];i=u?1:0,function(e,t,n,u){var h=i?c:l,d=null,m=null,p=null,E=0,v=null,_=-1,C=null,A=null,R=[];if(!u)for(C=0,u=[];C<n;C++)u[C]=f(e[C]);for(r=i,s=!1,o=!1,a=!1,A=0;A<n;A++){if(d=E,R[A]=m=g(e,u,R,A),v=240&(E=h[d][m]),E&=15,t[A]=p=h[E][5],v>0)if(16==v){for(C=_;C<A;C++)t[C]=1;_=-1}else _=-1;if(h[E][6])-1==_&&(_=A);else if(_>-1){for(C=_;C<A;C++)t[C]=p;_=-1}5==u[A]&&(t[A]=0),r|=p}if(a)for(C=0;C<n;C++)if(6==u[C]){t[C]=i;for(var S=C-1;S>=0&&8==u[S];S--)t[S]=i}}(d,v,d.length,n);for(var _=0;_<m.length;m[_]=_,_++);for(p(2,v,m),p(1,v,m),_=0;_<m.length-1;_++)3===n[_]?v[_]=t.AN:1===v[_]&&(n[_]>7&&n[_]<13||4===n[_]||n[_]===h)?v[_]=t.ON_R:_>0&&"ل"===d[_-1]&&/\u0622|\u0623|\u0625|\u0627/.test(d[_])&&(v[_-1]=v[_]=t.R_H,_++);for(d[d.length-1]===t.DOT&&(v[d.length-1]=t.B),"‫"===d[0]&&(v[0]=t.RLE),_=0;_<m.length;_++)E[_]=v[m[_]];return{logicalFromVisual:m,bidiLevels:E}},t.hasBidiCharacters=function(e,t){for(var n=!1,i=0;i<e.length;i++)t[i]=f(e.charAt(i)),n||1!=t[i]&&7!=t[i]&&3!=t[i]||(n=!0);return n},t.getVisualFromLogicalIdx=function(e,t){for(var n=0;n<t.logicalFromVisual.length;n++)if(t.logicalFromVisual[n]==e)return n;return 0}})),ace.define("ace/bidihandler",["require","exports","module","ace/lib/bidiutil","ace/lib/lang"],(function(e,t,n){"use strict";var i=e("./lib/bidiutil"),r=e("./lib/lang"),s=/[\u0590-\u05f4\u0600-\u06ff\u0700-\u08ac\u202B]/,o=function(e){this.session=e,this.bidiMap={},this.currentRow=null,this.bidiUtil=i,this.charWidths=[],this.EOL="¬",this.showInvisibles=!0,this.isRtlDir=!1,this.$isRtl=!1,this.line="",this.wrapIndent=0,this.EOF="¶",this.RLE="‫",this.contentWidth=0,this.fontMetrics=null,this.rtlLineOffset=0,this.wrapOffset=0,this.isMoveLeftOperation=!1,this.seenBidi=s.test(e.getValue())};(function(){this.isBidiRow=function(e,t,n){return!!this.seenBidi&&(e!==this.currentRow&&(this.currentRow=e,this.updateRowLine(t,n),this.updateBidiMap()),this.bidiMap.bidiLevels)},this.onChange=function(e){this.seenBidi?this.currentRow=null:"insert"==e.action&&s.test(e.lines.join("\n"))&&(this.seenBidi=!0,this.currentRow=null)},this.getDocumentRow=function(){var e=0,t=this.session.$screenRowCache;if(t.length){var n=this.session.$getRowCacheIndex(t,this.currentRow);n>=0&&(e=this.session.$docRowCache[n])}return e},this.getSplitIndex=function(){var e=0,t=this.session.$screenRowCache;if(t.length)for(var n,i=this.session.$getRowCacheIndex(t,this.currentRow);this.currentRow-e>0&&(n=this.session.$getRowCacheIndex(t,this.currentRow-e-1))===i;)i=n,e++;else e=this.currentRow;return e},this.updateRowLine=function(e,t){void 0===e&&(e=this.getDocumentRow());var n=e===this.session.getLength()-1?this.EOF:this.EOL;if(this.wrapIndent=0,this.line=this.session.getLine(e),this.isRtlDir=this.$isRtl||this.line.charAt(0)===this.RLE,this.session.$useWrapMode){var s=this.session.$wrapData[e];s&&(void 0===t&&(t=this.getSplitIndex()),t>0&&s.length?(this.wrapIndent=s.indent,this.wrapOffset=this.wrapIndent*this.charWidths[i.L],this.line=t<s.length?this.line.substring(s[t-1],s[t]):this.line.substring(s[s.length-1])):this.line=this.line.substring(0,s[t])),t==s.length&&(this.line+=this.showInvisibles?n:i.DOT)}else this.line+=this.showInvisibles?n:i.DOT;var o,a=this.session,l=0;this.line=this.line.replace(/\t|[\u1100-\u2029, \u202F-\uFFE6]/g,(function(e,t){return"\t"===e||a.isFullWidth(e.charCodeAt(0))?(o="\t"===e?a.getScreenTabSize(t+l):2,l+=o-1,r.stringRepeat(i.DOT,o)):e})),this.isRtlDir&&(this.fontMetrics.$main.textContent=this.line.charAt(this.line.length-1)==i.DOT?this.line.substr(0,this.line.length-1):this.line,this.rtlLineOffset=this.contentWidth-this.fontMetrics.$main.getBoundingClientRect().width)},this.updateBidiMap=function(){var e=[];i.hasBidiCharacters(this.line,e)||this.isRtlDir?this.bidiMap=i.doBidiReorder(this.line,e,this.isRtlDir):this.bidiMap={}},this.markAsDirty=function(){this.currentRow=null},this.updateCharacterWidths=function(e){if(this.characterWidth!==e.$characterSize.width){this.fontMetrics=e;var t=this.characterWidth=e.$characterSize.width,n=e.$measureCharWidth("ה");this.charWidths[i.L]=this.charWidths[i.EN]=this.charWidths[i.ON_R]=t,this.charWidths[i.R]=this.charWidths[i.AN]=n,this.charWidths[i.R_H]=.45*n,this.charWidths[i.B]=this.charWidths[i.RLE]=0,this.currentRow=null}},this.setShowInvisibles=function(e){this.showInvisibles=e,this.currentRow=null},this.setEolChar=function(e){this.EOL=e},this.setContentWidth=function(e){this.contentWidth=e},this.isRtlLine=function(e){return!!this.$isRtl||(null!=e?this.session.getLine(e).charAt(0)==this.RLE:this.isRtlDir)},this.setRtlDirection=function(e,t){for(var n=e.getCursorPosition(),i=e.selection.getSelectionAnchor().row;i<=n.row;i++)t||e.session.getLine(i).charAt(0)!==e.session.$bidiHandler.RLE?t&&e.session.getLine(i).charAt(0)!==e.session.$bidiHandler.RLE&&e.session.doc.insert({column:0,row:i},e.session.$bidiHandler.RLE):e.session.doc.removeInLine(i,0,1)},this.getPosLeft=function(e){e-=this.wrapIndent;var t=this.line.charAt(0)===this.RLE?1:0,n=e>t?this.session.getOverwrite()?e:e-1:t,r=i.getVisualFromLogicalIdx(n,this.bidiMap),s=this.bidiMap.bidiLevels,o=0;!this.session.getOverwrite()&&e<=t&&s[r]%2!=0&&r++;for(var a=0;a<r;a++)o+=this.charWidths[s[a]];return!this.session.getOverwrite()&&e>t&&s[r]%2==0&&(o+=this.charWidths[s[r]]),this.wrapIndent&&(o+=this.isRtlDir?-1*this.wrapOffset:this.wrapOffset),this.isRtlDir&&(o+=this.rtlLineOffset),o},this.getSelections=function(e,t){var n,i=this.bidiMap,r=i.bidiLevels,s=[],o=0,a=Math.min(e,t)-this.wrapIndent,l=Math.max(e,t)-this.wrapIndent,c=!1,u=!1,h=0;this.wrapIndent&&(o+=this.isRtlDir?-1*this.wrapOffset:this.wrapOffset);for(var d,m=0;m<r.length;m++)d=i.logicalFromVisual[m],n=r[m],(c=d>=a&&d<l)&&!u?h=o:!c&&u&&s.push({left:h,width:o-h}),o+=this.charWidths[n],u=c;if(c&&m===r.length&&s.push({left:h,width:o-h}),this.isRtlDir)for(var p=0;p<s.length;p++)s[p].left+=this.rtlLineOffset;return s},this.offsetToCol=function(e){this.isRtlDir&&(e-=this.rtlLineOffset);var t=0,n=(e=Math.max(e,0),0),i=0,r=this.bidiMap.bidiLevels,s=this.charWidths[r[i]];for(this.wrapIndent&&(e-=this.isRtlDir?-1*this.wrapOffset:this.wrapOffset);e>n+s/2;){if(n+=s,i===r.length-1){s=0;break}s=this.charWidths[r[++i]]}return i>0&&r[i-1]%2!=0&&r[i]%2==0?(e<n&&i--,t=this.bidiMap.logicalFromVisual[i]):i>0&&r[i-1]%2==0&&r[i]%2!=0?t=1+(e>n?this.bidiMap.logicalFromVisual[i]:this.bidiMap.logicalFromVisual[i-1]):this.isRtlDir&&i===r.length-1&&0===s&&r[i-1]%2==0||!this.isRtlDir&&0===i&&r[i]%2!=0?t=1+this.bidiMap.logicalFromVisual[i]:(i>0&&r[i-1]%2!=0&&0!==s&&i--,t=this.bidiMap.logicalFromVisual[i]),0===t&&this.isRtlDir&&t++,t+this.wrapIndent}}).call(o.prototype),t.BidiHandler=o})),ace.define("ace/selection",["require","exports","module","ace/lib/oop","ace/lib/lang","ace/lib/event_emitter","ace/range"],(function(e,t,n){"use strict";var i=e("./lib/oop"),r=e("./lib/lang"),s=e("./lib/event_emitter").EventEmitter,o=e("./range").Range,a=function(e){this.session=e,this.doc=e.getDocument(),this.clearSelection(),this.cursor=this.lead=this.doc.createAnchor(0,0),this.anchor=this.doc.createAnchor(0,0),this.$silent=!1;var t=this;this.cursor.on("change",(function(e){t.$cursorChanged=!0,t.$silent||t._emit("changeCursor"),t.$isEmpty||t.$silent||t._emit("changeSelection"),t.$keepDesiredColumnOnChange||e.old.column==e.value.column||(t.$desiredColumn=null)})),this.anchor.on("change",(function(){t.$anchorChanged=!0,t.$isEmpty||t.$silent||t._emit("changeSelection")}))};(function(){i.implement(this,s),this.isEmpty=function(){return this.$isEmpty||this.anchor.row==this.lead.row&&this.anchor.column==this.lead.column},this.isMultiLine=function(){return!this.$isEmpty&&this.anchor.row!=this.cursor.row},this.getCursor=function(){return this.lead.getPosition()},this.setSelectionAnchor=function(e,t){this.$isEmpty=!1,this.anchor.setPosition(e,t)},this.getAnchor=this.getSelectionAnchor=function(){return this.$isEmpty?this.getSelectionLead():this.anchor.getPosition()},this.getSelectionLead=function(){return this.lead.getPosition()},this.isBackwards=function(){var e=this.anchor,t=this.lead;return e.row>t.row||e.row==t.row&&e.column>t.column},this.getRange=function(){var e=this.anchor,t=this.lead;return this.$isEmpty?o.fromPoints(t,t):this.isBackwards()?o.fromPoints(t,e):o.fromPoints(e,t)},this.clearSelection=function(){this.$isEmpty||(this.$isEmpty=!0,this._emit("changeSelection"))},this.selectAll=function(){this.$setSelection(0,0,Number.MAX_VALUE,Number.MAX_VALUE)},this.setRange=this.setSelectionRange=function(e,t){var n=t?e.end:e.start,i=t?e.start:e.end;this.$setSelection(n.row,n.column,i.row,i.column)},this.$setSelection=function(e,t,n,i){var r=this.$isEmpty,s=this.inMultiSelectMode;this.$silent=!0,this.$cursorChanged=this.$anchorChanged=!1,this.anchor.setPosition(e,t),this.cursor.setPosition(n,i),this.$isEmpty=!o.comparePoints(this.anchor,this.cursor),this.$silent=!1,this.$cursorChanged&&this._emit("changeCursor"),(this.$cursorChanged||this.$anchorChanged||r!=this.$isEmpty||s)&&this._emit("changeSelection")},this.$moveSelection=function(e){var t=this.lead;this.$isEmpty&&this.setSelectionAnchor(t.row,t.column),e.call(this)},this.selectTo=function(e,t){this.$moveSelection((function(){this.moveCursorTo(e,t)}))},this.selectToPosition=function(e){this.$moveSelection((function(){this.moveCursorToPosition(e)}))},this.moveTo=function(e,t){this.clearSelection(),this.moveCursorTo(e,t)},this.moveToPosition=function(e){this.clearSelection(),this.moveCursorToPosition(e)},this.selectUp=function(){this.$moveSelection(this.moveCursorUp)},this.selectDown=function(){this.$moveSelection(this.moveCursorDown)},this.selectRight=function(){this.$moveSelection(this.moveCursorRight)},this.selectLeft=function(){this.$moveSelection(this.moveCursorLeft)},this.selectLineStart=function(){this.$moveSelection(this.moveCursorLineStart)},this.selectLineEnd=function(){this.$moveSelection(this.moveCursorLineEnd)},this.selectFileEnd=function(){this.$moveSelection(this.moveCursorFileEnd)},this.selectFileStart=function(){this.$moveSelection(this.moveCursorFileStart)},this.selectWordRight=function(){this.$moveSelection(this.moveCursorWordRight)},this.selectWordLeft=function(){this.$moveSelection(this.moveCursorWordLeft)},this.getWordRange=function(e,t){if(void 0===t){var n=e||this.lead;e=n.row,t=n.column}return this.session.getWordRange(e,t)},this.selectWord=function(){this.setSelectionRange(this.getWordRange())},this.selectAWord=function(){var e=this.getCursor(),t=this.session.getAWordRange(e.row,e.column);this.setSelectionRange(t)},this.getLineRange=function(e,t){var n,i="number"==typeof e?e:this.lead.row,r=this.session.getFoldLine(i);return r?(i=r.start.row,n=r.end.row):n=i,!0===t?new o(i,0,n,this.session.getLine(n).length):new o(i,0,n+1,0)},this.selectLine=function(){this.setSelectionRange(this.getLineRange())},this.moveCursorUp=function(){this.moveCursorBy(-1,0)},this.moveCursorDown=function(){this.moveCursorBy(1,0)},this.wouldMoveIntoSoftTab=function(e,t,n){var i=e.column,r=e.column+t;return n<0&&(i=e.column-t,r=e.column),this.session.isTabStop(e)&&this.doc.getLine(e.row).slice(i,r).split(" ").length-1==t},this.moveCursorLeft=function(){var e,t=this.lead.getPosition();if(e=this.session.getFoldAt(t.row,t.column,-1))this.moveCursorTo(e.start.row,e.start.column);else if(0===t.column)t.row>0&&this.moveCursorTo(t.row-1,this.doc.getLine(t.row-1).length);else{var n=this.session.getTabSize();this.wouldMoveIntoSoftTab(t,n,-1)&&!this.session.getNavigateWithinSoftTabs()?this.moveCursorBy(0,-n):this.moveCursorBy(0,-1)}},this.moveCursorRight=function(){var e,t=this.lead.getPosition();if(e=this.session.getFoldAt(t.row,t.column,1))this.moveCursorTo(e.end.row,e.end.column);else if(this.lead.column==this.doc.getLine(this.lead.row).length)this.lead.row<this.doc.getLength()-1&&this.moveCursorTo(this.lead.row+1,0);else{var n=this.session.getTabSize();t=this.lead,this.wouldMoveIntoSoftTab(t,n,1)&&!this.session.getNavigateWithinSoftTabs()?this.moveCursorBy(0,n):this.moveCursorBy(0,1)}},this.moveCursorLineStart=function(){var e=this.lead.row,t=this.lead.column,n=this.session.documentToScreenRow(e,t),i=this.session.screenToDocumentPosition(n,0),r=this.session.getDisplayLine(e,null,i.row,i.column).match(/^\s*/);r[0].length==t||this.session.$useEmacsStyleLineStart||(i.column+=r[0].length),this.moveCursorToPosition(i)},this.moveCursorLineEnd=function(){var e=this.lead,t=this.session.getDocumentLastRowColumnPosition(e.row,e.column);if(this.lead.column==t.column){var n=this.session.getLine(t.row);if(t.column==n.length){var i=n.search(/\s+$/);i>0&&(t.column=i)}}this.moveCursorTo(t.row,t.column)},this.moveCursorFileEnd=function(){var e=this.doc.getLength()-1,t=this.doc.getLine(e).length;this.moveCursorTo(e,t)},this.moveCursorFileStart=function(){this.moveCursorTo(0,0)},this.moveCursorLongWordRight=function(){var e=this.lead.row,t=this.lead.column,n=this.doc.getLine(e),i=n.substring(t);this.session.nonTokenRe.lastIndex=0,this.session.tokenRe.lastIndex=0;var r=this.session.getFoldAt(e,t,1);if(r)this.moveCursorTo(r.end.row,r.end.column);else{if(this.session.nonTokenRe.exec(i)&&(t+=this.session.nonTokenRe.lastIndex,this.session.nonTokenRe.lastIndex=0,i=n.substring(t)),t>=n.length)return this.moveCursorTo(e,n.length),this.moveCursorRight(),void(e<this.doc.getLength()-1&&this.moveCursorWordRight());this.session.tokenRe.exec(i)&&(t+=this.session.tokenRe.lastIndex,this.session.tokenRe.lastIndex=0),this.moveCursorTo(e,t)}},this.moveCursorLongWordLeft=function(){var e,t=this.lead.row,n=this.lead.column;if(e=this.session.getFoldAt(t,n,-1))this.moveCursorTo(e.start.row,e.start.column);else{var i=this.session.getFoldStringAt(t,n,-1);null==i&&(i=this.doc.getLine(t).substring(0,n));var s=r.stringReverse(i);if(this.session.nonTokenRe.lastIndex=0,this.session.tokenRe.lastIndex=0,this.session.nonTokenRe.exec(s)&&(n-=this.session.nonTokenRe.lastIndex,s=s.slice(this.session.nonTokenRe.lastIndex),this.session.nonTokenRe.lastIndex=0),n<=0)return this.moveCursorTo(t,0),this.moveCursorLeft(),void(t>0&&this.moveCursorWordLeft());this.session.tokenRe.exec(s)&&(n-=this.session.tokenRe.lastIndex,this.session.tokenRe.lastIndex=0),this.moveCursorTo(t,n)}},this.$shortWordEndIndex=function(e){var t,n=0,i=/\s/,r=this.session.tokenRe;if(r.lastIndex=0,this.session.tokenRe.exec(e))n=this.session.tokenRe.lastIndex;else{for(;(t=e[n])&&i.test(t);)n++;if(n<1)for(r.lastIndex=0;(t=e[n])&&!r.test(t);)if(r.lastIndex=0,n++,i.test(t)){if(n>2){n--;break}for(;(t=e[n])&&i.test(t);)n++;if(n>2)break}}return r.lastIndex=0,n},this.moveCursorShortWordRight=function(){var e=this.lead.row,t=this.lead.column,n=this.doc.getLine(e),i=n.substring(t),r=this.session.getFoldAt(e,t,1);if(r)return this.moveCursorTo(r.end.row,r.end.column);if(t==n.length){var s=this.doc.getLength();do{e++,i=this.doc.getLine(e)}while(e<s&&/^\s*$/.test(i));/^\s+/.test(i)||(i=""),t=0}var o=this.$shortWordEndIndex(i);this.moveCursorTo(e,t+o)},this.moveCursorShortWordLeft=function(){var e,t=this.lead.row,n=this.lead.column;if(e=this.session.getFoldAt(t,n,-1))return this.moveCursorTo(e.start.row,e.start.column);var i=this.session.getLine(t).substring(0,n);if(0===n){do{t--,i=this.doc.getLine(t)}while(t>0&&/^\s*$/.test(i));n=i.length,/\s+$/.test(i)||(i="")}var s=r.stringReverse(i),o=this.$shortWordEndIndex(s);return this.moveCursorTo(t,n-o)},this.moveCursorWordRight=function(){this.session.$selectLongWords?this.moveCursorLongWordRight():this.moveCursorShortWordRight()},this.moveCursorWordLeft=function(){this.session.$selectLongWords?this.moveCursorLongWordLeft():this.moveCursorShortWordLeft()},this.moveCursorBy=function(e,t){var n,i=this.session.documentToScreenPosition(this.lead.row,this.lead.column);0===t&&(0!==e&&(this.session.$bidiHandler.isBidiRow(i.row,this.lead.row)?(n=this.session.$bidiHandler.getPosLeft(i.column),i.column=Math.round(n/this.session.$bidiHandler.charWidths[0])):n=i.column*this.session.$bidiHandler.charWidths[0]),this.$desiredColumn?i.column=this.$desiredColumn:this.$desiredColumn=i.column);var r=this.session.screenToDocumentPosition(i.row+e,i.column,n);0!==e&&0===t&&r.row===this.lead.row&&r.column===this.lead.column&&this.session.lineWidgets&&this.session.lineWidgets[r.row]&&(r.row>0||e>0)&&r.row++,this.moveCursorTo(r.row,r.column+t,0===t)},this.moveCursorToPosition=function(e){this.moveCursorTo(e.row,e.column)},this.moveCursorTo=function(e,t,n){var i=this.session.getFoldAt(e,t,1);i&&(e=i.start.row,t=i.start.column),this.$keepDesiredColumnOnChange=!0;var r=this.session.getLine(e);/[\uDC00-\uDFFF]/.test(r.charAt(t))&&r.charAt(t-1)&&(this.lead.row==e&&this.lead.column==t+1?t-=1:t+=1),this.lead.setPosition(e,t),this.$keepDesiredColumnOnChange=!1,n||(this.$desiredColumn=null)},this.moveCursorToScreen=function(e,t,n){var i=this.session.screenToDocumentPosition(e,t);this.moveCursorTo(i.row,i.column,n)},this.detach=function(){this.lead.detach(),this.anchor.detach(),this.session=this.doc=null},this.fromOrientedRange=function(e){this.setSelectionRange(e,e.cursor==e.start),this.$desiredColumn=e.desiredColumn||this.$desiredColumn},this.toOrientedRange=function(e){var t=this.getRange();return e?(e.start.column=t.start.column,e.start.row=t.start.row,e.end.column=t.end.column,e.end.row=t.end.row):e=t,e.cursor=this.isBackwards()?e.start:e.end,e.desiredColumn=this.$desiredColumn,e},this.getRangeOfMovements=function(e){var t=this.getCursor();try{e(this);var n=this.getCursor();return o.fromPoints(t,n)}catch(e){return o.fromPoints(t,t)}finally{this.moveCursorToPosition(t)}},this.toJSON=function(){if(this.rangeCount)var e=this.ranges.map((function(e){var t=e.clone();return t.isBackwards=e.cursor==e.start,t}));else(e=this.getRange()).isBackwards=this.isBackwards();return e},this.fromJSON=function(e){if(null==e.start){if(this.rangeList&&e.length>1){this.toSingleRange(e[0]);for(var t=e.length;t--;){var n=o.fromPoints(e[t].start,e[t].end);e[t].isBackwards&&(n.cursor=n.start),this.addRange(n,!0)}return}e=e[0]}this.rangeList&&this.toSingleRange(e),this.setSelectionRange(e,e.isBackwards)},this.isEqual=function(e){if((e.length||this.rangeCount)&&e.length!=this.rangeCount)return!1;if(!e.length||!this.ranges)return this.getRange().isEqual(e);for(var t=this.ranges.length;t--;)if(!this.ranges[t].isEqual(e[t]))return!1;return!0}}).call(a.prototype),t.Selection=a})),ace.define("ace/tokenizer",["require","exports","module","ace/config"],(function(e,t,n){"use strict";var i=e("./config"),r=2e3,s=function(e){for(var t in this.states=e,this.regExps={},this.matchMappings={},this.states){for(var n=this.states[t],i=[],r=0,s=this.matchMappings[t]={defaultToken:"text"},o="g",a=[],l=0;l<n.length;l++){var c=n[l];if(c.defaultToken&&(s.defaultToken=c.defaultToken),c.caseInsensitive&&(o="gi"),null!=c.regex){c.regex instanceof RegExp&&(c.regex=c.regex.toString().slice(1,-1));var u=c.regex,h=new RegExp("(?:("+u+")|(.))").exec("a").length-2;Array.isArray(c.token)?1==c.token.length||1==h?c.token=c.token[0]:h-1!=c.token.length?(this.reportError("number of classes and regexp groups doesn't match",{rule:c,groupCount:h-1}),c.token=c.token[0]):(c.tokenArray=c.token,c.token=null,c.onMatch=this.$arrayTokens):"function"!=typeof c.token||c.onMatch||(c.onMatch=h>1?this.$applyToken:c.token),h>1&&(/\\\d/.test(c.regex)?u=c.regex.replace(/\\([0-9]+)/g,(function(e,t){return"\\"+(parseInt(t,10)+r+1)})):(h=1,u=this.removeCapturingGroups(c.regex)),c.splitRegex||"string"==typeof c.token||a.push(c)),s[r]=l,r+=h,i.push(u),c.onMatch||(c.onMatch=null)}}i.length||(s[0]=0,i.push("$")),a.forEach((function(e){e.splitRegex=this.createSplitterRegexp(e.regex,o)}),this),this.regExps[t]=new RegExp("("+i.join(")|(")+")|($)",o)}};(function(){this.$setMaxTokenCount=function(e){r=0|e},this.$applyToken=function(e){var t=this.splitRegex.exec(e).slice(1),n=this.token.apply(this,t);if("string"==typeof n)return[{type:n,value:e}];for(var i=[],r=0,s=n.length;r<s;r++)t[r]&&(i[i.length]={type:n[r],value:t[r]});return i},this.$arrayTokens=function(e){if(!e)return[];var t=this.splitRegex.exec(e);if(!t)return"text";for(var n=[],i=this.tokenArray,r=0,s=i.length;r<s;r++)t[r+1]&&(n[n.length]={type:i[r],value:t[r+1]});return n},this.removeCapturingGroups=function(e){return e.replace(/\\.|\[(?:\\.|[^\\\]])*|\(\?[:=!]|(\()/g,(function(e,t){return t?"(?:":e}))},this.createSplitterRegexp=function(e,t){if(-1!=e.indexOf("(?=")){var n=0,i=!1,r={};e.replace(/(\\.)|(\((?:\?[=!])?)|(\))|([\[\]])/g,(function(e,t,s,o,a,l){return i?i="]"!=a:a?i=!0:o?(n==r.stack&&(r.end=l+1,r.stack=-1),n--):s&&(n++,1!=s.length&&(r.stack=n,r.start=l)),e})),null!=r.end&&/^\)*$/.test(e.substr(r.end))&&(e=e.substring(0,r.start)+e.substr(r.end))}return"^"!=e.charAt(0)&&(e="^"+e),"$"!=e.charAt(e.length-1)&&(e+="$"),new RegExp(e,(t||"").replace("g",""))},this.getLineTokens=function(e,t){if(t&&"string"!=typeof t){var n=t.slice(0);"#tmp"===(t=n[0])&&(n.shift(),t=n.shift())}else n=[];var i=t||"start",s=this.states[i];s||(i="start",s=this.states[i]);var o=this.matchMappings[i],a=this.regExps[i];a.lastIndex=0;for(var l,c=[],u=0,h=0,d={type:null,value:""};l=a.exec(e);){var m=o.defaultToken,p=null,g=l[0],f=a.lastIndex;if(f-g.length>u){var E=e.substring(u,f-g.length);d.type==m?d.value+=E:(d.type&&c.push(d),d={type:m,value:E})}for(var v=0;v<l.length-2;v++)if(void 0!==l[v+1]){m=(p=s[o[v]]).onMatch?p.onMatch(g,i,n,e):p.token,p.next&&(i="string"==typeof p.next?p.next:p.next(i,n),(s=this.states[i])||(this.reportError("state doesn't exist",i),i="start",s=this.states[i]),o=this.matchMappings[i],u=f,(a=this.regExps[i]).lastIndex=f),p.consumeLineEnd&&(u=f);break}if(g)if("string"==typeof m)p&&!1===p.merge||d.type!==m?(d.type&&c.push(d),d={type:m,value:g}):d.value+=g;else if(m)for(d.type&&c.push(d),d={type:null,value:""},v=0;v<m.length;v++)c.push(m[v]);if(u==e.length)break;if(u=f,h++>r){for(h>2*e.length&&this.reportError("infinite loop with in ace tokenizer",{startState:t,line:e});u<e.length;)d.type&&c.push(d),d={value:e.substring(u,u+=500),type:"overflow"};i="start",n=[];break}}return d.type&&c.push(d),n.length>1&&n[0]!==i&&n.unshift("#tmp",i),{tokens:c,state:n.length?n:i}},this.reportError=i.reportError}).call(s.prototype),t.Tokenizer=s})),ace.define("ace/mode/text_highlight_rules",["require","exports","module","ace/lib/lang"],(function(e,t,n){"use strict";var i=e("../lib/lang"),r=function(){this.$rules={start:[{token:"empty_line",regex:"^$"},{defaultToken:"text"}]}};(function(){this.addRules=function(e,t){if(t)for(var n in e){for(var i=e[n],r=0;r<i.length;r++){var s=i[r];(s.next||s.onMatch)&&("string"==typeof s.next&&0!==s.next.indexOf(t)&&(s.next=t+s.next),s.nextState&&0!==s.nextState.indexOf(t)&&(s.nextState=t+s.nextState))}this.$rules[t+n]=i}else for(var n in e)this.$rules[n]=e[n]},this.getRules=function(){return this.$rules},this.embedRules=function(e,t,n,r,s){var o="function"==typeof e?(new e).getRules():e;if(r)for(var a=0;a<r.length;a++)r[a]=t+r[a];else for(var l in r=[],o)r.push(t+l);if(this.addRules(o,t),n){var c=Array.prototype[s?"push":"unshift"];for(a=0;a<r.length;a++)c.apply(this.$rules[r[a]],i.deepCopy(n))}this.$embeds||(this.$embeds=[]),this.$embeds.push(t)},this.getEmbeds=function(){return this.$embeds};var e=function(e,t){return("start"!=e||t.length)&&t.unshift(this.nextState,e),this.nextState},t=function(e,t){return t.shift(),t.shift()||"start"};this.normalizeRules=function(){var n=0,i=this.$rules;Object.keys(i).forEach((function r(s){var o=i[s];o.processed=!0;for(var a=0;a<o.length;a++){var l=o[a],c=null;Array.isArray(l)&&(c=l,l={}),!l.regex&&l.start&&(l.regex=l.start,l.next||(l.next=[]),l.next.push({defaultToken:l.token},{token:l.token+".end",regex:l.end||l.start,next:"pop"}),l.token=l.token+".start",l.push=!0);var u=l.next||l.push;if(u&&Array.isArray(u)){var h=l.stateName;h||("string"!=typeof(h=l.token)&&(h=h[0]||""),i[h]&&(h+=n++)),i[h]=u,l.next=h,r(h)}else"pop"==u&&(l.next=t);if(l.push&&(l.nextState=l.next||l.push,l.next=e,delete l.push),l.rules)for(var d in l.rules)i[d]?i[d].push&&i[d].push.apply(i[d],l.rules[d]):i[d]=l.rules[d];var m="string"==typeof l?l:l.include;if(m&&(c=Array.isArray(m)?m.map((function(e){return i[e]})):i[m]),c){var p=[a,1].concat(c);l.noEscape&&(p=p.filter((function(e){return!e.next}))),o.splice.apply(o,p),a--}l.keywordMap&&(l.token=this.createKeywordMapper(l.keywordMap,l.defaultToken||"text",l.caseInsensitive),delete l.defaultToken)}}),this)},this.createKeywordMapper=function(e,t,n,i){var r=Object.create(null);return Object.keys(e).forEach((function(t){var s=e[t];n&&(s=s.toLowerCase());for(var o=s.split(i||"|"),a=o.length;a--;)r[o[a]]=t})),Object.getPrototypeOf(r)&&(r.__proto__=null),this.$keywordList=Object.keys(r),e=null,n?function(e){return r[e.toLowerCase()]||t}:function(e){return r[e]||t}},this.getKeywords=function(){return this.$keywords}}).call(r.prototype),t.TextHighlightRules=r})),ace.define("ace/mode/behaviour",["require","exports","module"],(function(e,t,n){"use strict";var i=function(){this.$behaviours={}};(function(){this.add=function(e,t,n){switch(void 0){case this.$behaviours:this.$behaviours={};case this.$behaviours[e]:this.$behaviours[e]={}}this.$behaviours[e][t]=n},this.addBehaviours=function(e){for(var t in e)for(var n in e[t])this.add(t,n,e[t][n])},this.remove=function(e){this.$behaviours&&this.$behaviours[e]&&delete this.$behaviours[e]},this.inherit=function(e,t){if("function"==typeof e)var n=(new e).getBehaviours(t);else n=e.getBehaviours(t);this.addBehaviours(n)},this.getBehaviours=function(e){if(e){for(var t={},n=0;n<e.length;n++)this.$behaviours[e[n]]&&(t[e[n]]=this.$behaviours[e[n]]);return t}return this.$behaviours}}).call(i.prototype),t.Behaviour=i})),ace.define("ace/token_iterator",["require","exports","module","ace/range"],(function(e,t,n){"use strict";var i=e("./range").Range,r=function(e,t,n){this.$session=e,this.$row=t,this.$rowTokens=e.getTokens(t);var i=e.getTokenAt(t,n);this.$tokenIndex=i?i.index:-1};(function(){this.stepBackward=function(){for(this.$tokenIndex-=1;this.$tokenIndex<0;){if(this.$row-=1,this.$row<0)return this.$row=0,null;this.$rowTokens=this.$session.getTokens(this.$row),this.$tokenIndex=this.$rowTokens.length-1}return this.$rowTokens[this.$tokenIndex]},this.stepForward=function(){var e;for(this.$tokenIndex+=1;this.$tokenIndex>=this.$rowTokens.length;){if(this.$row+=1,e||(e=this.$session.getLength()),this.$row>=e)return this.$row=e-1,null;this.$rowTokens=this.$session.getTokens(this.$row),this.$tokenIndex=0}return this.$rowTokens[this.$tokenIndex]},this.getCurrentToken=function(){return this.$rowTokens[this.$tokenIndex]},this.getCurrentTokenRow=function(){return this.$row},this.getCurrentTokenColumn=function(){var e=this.$rowTokens,t=this.$tokenIndex,n=e[t].start;if(void 0!==n)return n;for(n=0;t>0;)n+=e[t-=1].value.length;return n},this.getCurrentTokenPosition=function(){return{row:this.$row,column:this.getCurrentTokenColumn()}},this.getCurrentTokenRange=function(){var e=this.$rowTokens[this.$tokenIndex],t=this.getCurrentTokenColumn();return new i(this.$row,t,this.$row,t+e.value.length)}}).call(r.prototype),t.TokenIterator=r})),ace.define("ace/mode/behaviour/cstyle",["require","exports","module","ace/lib/oop","ace/mode/behaviour","ace/token_iterator","ace/lib/lang"],(function(e,t,n){"use strict";var i,r=e("../../lib/oop"),s=e("../behaviour").Behaviour,o=e("../../token_iterator").TokenIterator,a=e("../../lib/lang"),l=["text","paren.rparen","rparen","paren","punctuation.operator"],c=["text","paren.rparen","rparen","paren","punctuation.operator","comment"],u={},h={'"':'"',"'":"'"},d=function(e){var t=-1;if(e.multiSelect&&(t=e.selection.index,u.rangeCount!=e.multiSelect.rangeCount&&(u={rangeCount:e.multiSelect.rangeCount})),u[t])return i=u[t];i=u[t]={autoInsertedBrackets:0,autoInsertedRow:-1,autoInsertedLineEnd:"",maybeInsertedBrackets:0,maybeInsertedRow:-1,maybeInsertedLineStart:"",maybeInsertedLineEnd:""}},m=function(e,t,n,i){var r=e.end.row-e.start.row;return{text:n+t+i,selection:[0,e.start.column+1,r,e.end.column+(r?0:1)]}},p=function(e){this.add("braces","insertion",(function(t,n,r,s,o){var l=r.getCursorPosition(),c=s.doc.getLine(l.row);if("{"==o){d(r);var u=r.getSelectionRange(),h=s.doc.getTextRange(u);if(""!==h&&"{"!==h&&r.getWrapBehavioursEnabled())return m(u,h,"{","}");if(p.isSaneInsertion(r,s))return/[\]\}\)]/.test(c[l.column])||r.inMultiSelectMode||e&&e.braces?(p.recordAutoInsert(r,s,"}"),{text:"{}",selection:[1,1]}):(p.recordMaybeInsert(r,s,"{"),{text:"{",selection:[1,1]})}else if("}"==o){if(d(r),"}"==c.substring(l.column,l.column+1)&&null!==s.$findOpeningBracket("}",{column:l.column+1,row:l.row})&&p.isAutoInsertedClosing(l,c,o))return p.popAutoInsertedClosing(),{text:"",selection:[1,1]}}else{if("\n"==o||"\r\n"==o){d(r);var g="";if(p.isMaybeInsertedClosing(l,c)&&(g=a.stringRepeat("}",i.maybeInsertedBrackets),p.clearMaybeInsertedClosing()),"}"===c.substring(l.column,l.column+1)){var f=s.findMatchingBracket({row:l.row,column:l.column+1},"}");if(!f)return null;var E=this.$getIndent(s.getLine(f.row))}else{if(!g)return void p.clearMaybeInsertedClosing();E=this.$getIndent(c)}var v=E+s.getTabString();return{text:"\n"+v+"\n"+E+g,selection:[1,v.length,1,v.length]}}p.clearMaybeInsertedClosing()}})),this.add("braces","deletion",(function(e,t,n,r,s){var o=r.doc.getTextRange(s);if(!s.isMultiLine()&&"{"==o){if(d(n),"}"==r.doc.getLine(s.start.row).substring(s.end.column,s.end.column+1))return s.end.column++,s;i.maybeInsertedBrackets--}})),this.add("parens","insertion",(function(e,t,n,i,r){if("("==r){d(n);var s=n.getSelectionRange(),o=i.doc.getTextRange(s);if(""!==o&&n.getWrapBehavioursEnabled())return m(s,o,"(",")");if(p.isSaneInsertion(n,i))return p.recordAutoInsert(n,i,")"),{text:"()",selection:[1,1]}}else if(")"==r){d(n);var a=n.getCursorPosition(),l=i.doc.getLine(a.row);if(")"==l.substring(a.column,a.column+1)&&null!==i.$findOpeningBracket(")",{column:a.column+1,row:a.row})&&p.isAutoInsertedClosing(a,l,r))return p.popAutoInsertedClosing(),{text:"",selection:[1,1]}}})),this.add("parens","deletion",(function(e,t,n,i,r){var s=i.doc.getTextRange(r);if(!r.isMultiLine()&&"("==s&&(d(n),")"==i.doc.getLine(r.start.row).substring(r.start.column+1,r.start.column+2)))return r.end.column++,r})),this.add("brackets","insertion",(function(e,t,n,i,r){if("["==r){d(n);var s=n.getSelectionRange(),o=i.doc.getTextRange(s);if(""!==o&&n.getWrapBehavioursEnabled())return m(s,o,"[","]");if(p.isSaneInsertion(n,i))return p.recordAutoInsert(n,i,"]"),{text:"[]",selection:[1,1]}}else if("]"==r){d(n);var a=n.getCursorPosition(),l=i.doc.getLine(a.row);if("]"==l.substring(a.column,a.column+1)&&null!==i.$findOpeningBracket("]",{column:a.column+1,row:a.row})&&p.isAutoInsertedClosing(a,l,r))return p.popAutoInsertedClosing(),{text:"",selection:[1,1]}}})),this.add("brackets","deletion",(function(e,t,n,i,r){var s=i.doc.getTextRange(r);if(!r.isMultiLine()&&"["==s&&(d(n),"]"==i.doc.getLine(r.start.row).substring(r.start.column+1,r.start.column+2)))return r.end.column++,r})),this.add("string_dquotes","insertion",(function(e,t,n,i,r){var s=i.$mode.$quotes||h;if(1==r.length&&s[r]){if(this.lineCommentStart&&-1!=this.lineCommentStart.indexOf(r))return;d(n);var o=r,a=n.getSelectionRange(),l=i.doc.getTextRange(a);if(!(""===l||1==l.length&&s[l])&&n.getWrapBehavioursEnabled())return m(a,l,o,o);if(!l){var c=n.getCursorPosition(),u=i.doc.getLine(c.row),p=u.substring(c.column-1,c.column),g=u.substring(c.column,c.column+1),f=i.getTokenAt(c.row,c.column),E=i.getTokenAt(c.row,c.column+1);if("\\"==p&&f&&/escape/.test(f.type))return null;var v,_=f&&/string|escape/.test(f.type),C=!E||/string|escape/.test(E.type);if(g==o)(v=_!==C)&&/string\.end/.test(E.type)&&(v=!1);else{if(_&&!C)return null;if(_&&C)return null;var A=i.$mode.tokenRe;A.lastIndex=0;var R=A.test(p);A.lastIndex=0;var S=A.test(p);if(R||S)return null;if(g&&!/[\s;,.})\]\\]/.test(g))return null;var T=u[c.column-2];if(p==o&&(T==o||A.test(T)))return null;v=!0}return{text:v?o+o:"",selection:[1,1]}}}})),this.add("string_dquotes","deletion",(function(e,t,n,i,r){var s=i.$mode.$quotes||h,o=i.doc.getTextRange(r);if(!r.isMultiLine()&&s.hasOwnProperty(o)&&(d(n),i.doc.getLine(r.start.row).substring(r.start.column+1,r.start.column+2)==o))return r.end.column++,r}))};p.isSaneInsertion=function(e,t){var n=e.getCursorPosition(),i=new o(t,n.row,n.column);if(!this.$matchTokenType(i.getCurrentToken()||"text",l)){if(/[)}\]]/.test(e.session.getLine(n.row)[n.column]))return!0;var r=new o(t,n.row,n.column+1);if(!this.$matchTokenType(r.getCurrentToken()||"text",l))return!1}return i.stepForward(),i.getCurrentTokenRow()!==n.row||this.$matchTokenType(i.getCurrentToken()||"text",c)},p.$matchTokenType=function(e,t){return t.indexOf(e.type||e)>-1},p.recordAutoInsert=function(e,t,n){var r=e.getCursorPosition(),s=t.doc.getLine(r.row);this.isAutoInsertedClosing(r,s,i.autoInsertedLineEnd[0])||(i.autoInsertedBrackets=0),i.autoInsertedRow=r.row,i.autoInsertedLineEnd=n+s.substr(r.column),i.autoInsertedBrackets++},p.recordMaybeInsert=function(e,t,n){var r=e.getCursorPosition(),s=t.doc.getLine(r.row);this.isMaybeInsertedClosing(r,s)||(i.maybeInsertedBrackets=0),i.maybeInsertedRow=r.row,i.maybeInsertedLineStart=s.substr(0,r.column)+n,i.maybeInsertedLineEnd=s.substr(r.column),i.maybeInsertedBrackets++},p.isAutoInsertedClosing=function(e,t,n){return i.autoInsertedBrackets>0&&e.row===i.autoInsertedRow&&n===i.autoInsertedLineEnd[0]&&t.substr(e.column)===i.autoInsertedLineEnd},p.isMaybeInsertedClosing=function(e,t){return i.maybeInsertedBrackets>0&&e.row===i.maybeInsertedRow&&t.substr(e.column)===i.maybeInsertedLineEnd&&t.substr(0,e.column)==i.maybeInsertedLineStart},p.popAutoInsertedClosing=function(){i.autoInsertedLineEnd=i.autoInsertedLineEnd.substr(1),i.autoInsertedBrackets--},p.clearMaybeInsertedClosing=function(){i&&(i.maybeInsertedBrackets=0,i.maybeInsertedRow=-1)},r.inherits(p,s),t.CstyleBehaviour=p})),ace.define("ace/unicode",["require","exports","module"],(function(e,t,n){"use strict";for(var i=[48,9,8,25,5,0,2,25,48,0,11,0,5,0,6,22,2,30,2,457,5,11,15,4,8,0,2,0,18,116,2,1,3,3,9,0,2,2,2,0,2,19,2,82,2,138,2,4,3,155,12,37,3,0,8,38,10,44,2,0,2,1,2,1,2,0,9,26,6,2,30,10,7,61,2,9,5,101,2,7,3,9,2,18,3,0,17,58,3,100,15,53,5,0,6,45,211,57,3,18,2,5,3,11,3,9,2,1,7,6,2,2,2,7,3,1,3,21,2,6,2,0,4,3,3,8,3,1,3,3,9,0,5,1,2,4,3,11,16,2,2,5,5,1,3,21,2,6,2,1,2,1,2,1,3,0,2,4,5,1,3,2,4,0,8,3,2,0,8,15,12,2,2,8,2,2,2,21,2,6,2,1,2,4,3,9,2,2,2,2,3,0,16,3,3,9,18,2,2,7,3,1,3,21,2,6,2,1,2,4,3,8,3,1,3,2,9,1,5,1,2,4,3,9,2,0,17,1,2,5,4,2,2,3,4,1,2,0,2,1,4,1,4,2,4,11,5,4,4,2,2,3,3,0,7,0,15,9,18,2,2,7,2,2,2,22,2,9,2,4,4,7,2,2,2,3,8,1,2,1,7,3,3,9,19,1,2,7,2,2,2,22,2,9,2,4,3,8,2,2,2,3,8,1,8,0,2,3,3,9,19,1,2,7,2,2,2,22,2,15,4,7,2,2,2,3,10,0,9,3,3,9,11,5,3,1,2,17,4,23,2,8,2,0,3,6,4,0,5,5,2,0,2,7,19,1,14,57,6,14,2,9,40,1,2,0,3,1,2,0,3,0,7,3,2,6,2,2,2,0,2,0,3,1,2,12,2,2,3,4,2,0,2,5,3,9,3,1,35,0,24,1,7,9,12,0,2,0,2,0,5,9,2,35,5,19,2,5,5,7,2,35,10,0,58,73,7,77,3,37,11,42,2,0,4,328,2,3,3,6,2,0,2,3,3,40,2,3,3,32,2,3,3,6,2,0,2,3,3,14,2,56,2,3,3,66,5,0,33,15,17,84,13,619,3,16,2,25,6,74,22,12,2,6,12,20,12,19,13,12,2,2,2,1,13,51,3,29,4,0,5,1,3,9,34,2,3,9,7,87,9,42,6,69,11,28,4,11,5,11,11,39,3,4,12,43,5,25,7,10,38,27,5,62,2,28,3,10,7,9,14,0,89,75,5,9,18,8,13,42,4,11,71,55,9,9,4,48,83,2,2,30,14,230,23,280,3,5,3,37,3,5,3,7,2,0,2,0,2,0,2,30,3,52,2,6,2,0,4,2,2,6,4,3,3,5,5,12,6,2,2,6,67,1,20,0,29,0,14,0,17,4,60,12,5,0,4,11,18,0,5,0,3,9,2,0,4,4,7,0,2,0,2,0,2,3,2,10,3,3,6,4,5,0,53,1,2684,46,2,46,2,132,7,6,15,37,11,53,10,0,17,22,10,6,2,6,2,6,2,6,2,6,2,6,2,6,2,6,2,31,48,0,470,1,36,5,2,4,6,1,5,85,3,1,3,2,2,89,2,3,6,40,4,93,18,23,57,15,513,6581,75,20939,53,1164,68,45,3,268,4,27,21,31,3,13,13,1,2,24,9,69,11,1,38,8,3,102,3,1,111,44,25,51,13,68,12,9,7,23,4,0,5,45,3,35,13,28,4,64,15,10,39,54,10,13,3,9,7,22,4,1,5,66,25,2,227,42,2,1,3,9,7,11171,13,22,5,48,8453,301,3,61,3,105,39,6,13,4,6,11,2,12,2,4,2,0,2,1,2,1,2,107,34,362,19,63,3,53,41,11,5,15,17,6,13,1,25,2,33,4,2,134,20,9,8,25,5,0,2,25,12,88,4,5,3,5,3,5,3,2],r=0,s=[],o=0;o<i.length;o+=2)s.push(r+=i[o]),i[o+1]&&s.push(45,r+=i[o+1]);t.wordChars=String.fromCharCode.apply(null,s)})),ace.define("ace/mode/text",["require","exports","module","ace/config","ace/tokenizer","ace/mode/text_highlight_rules","ace/mode/behaviour/cstyle","ace/unicode","ace/lib/lang","ace/token_iterator","ace/range"],(function(e,t,n){"use strict";var i=e("../config"),r=e("../tokenizer").Tokenizer,s=e("./text_highlight_rules").TextHighlightRules,o=e("./behaviour/cstyle").CstyleBehaviour,a=e("../unicode"),l=e("../lib/lang"),c=e("../token_iterator").TokenIterator,u=e("../range").Range,h=function(){this.HighlightRules=s};(function(){this.$defaultBehaviour=new o,this.tokenRe=new RegExp("^["+a.wordChars+"\\$_]+","g"),this.nonTokenRe=new RegExp("^(?:[^"+a.wordChars+"\\$_]|\\s])+","g"),this.getTokenizer=function(){return this.$tokenizer||(this.$highlightRules=this.$highlightRules||new this.HighlightRules(this.$highlightRuleConfig),this.$tokenizer=new r(this.$highlightRules.getRules())),this.$tokenizer},this.lineCommentStart="",this.blockComment="",this.toggleCommentLines=function(e,t,n,i){var r=t.doc,s=!0,o=!0,a=1/0,c=t.getTabSize(),u=!1;if(this.lineCommentStart){Array.isArray(this.lineCommentStart)?(g=this.lineCommentStart.map(l.escapeRegExp).join("|"),m=this.lineCommentStart[0]):(g=l.escapeRegExp(this.lineCommentStart),m=this.lineCommentStart),g=new RegExp("^(\\s*)(?:"+g+") ?"),u=t.getUseSoftTabs(),v=function(e,t){var n=e.match(g);if(n){var i=n[1].length,s=n[0].length;d(e,i,s)||" "!=n[0][s-1]||s--,r.removeInLine(t,i,s)}};var h=m+" ",d=(E=function(e,t){s&&!/\S/.test(e)||(d(e,a,a)?r.insertInLine({row:t,column:a},h):r.insertInLine({row:t,column:a},m))},_=function(e,t){return g.test(e)},function(e,t,n){for(var i=0;t--&&" "==e.charAt(t);)i++;if(i%c!=0)return!1;for(i=0;" "==e.charAt(n++);)i++;return c>2?i%c!=c-1:i%c==0})}else{if(!this.blockComment)return!1;var m=this.blockComment.start,p=this.blockComment.end,g=new RegExp("^(\\s*)(?:"+l.escapeRegExp(m)+")"),f=new RegExp("(?:"+l.escapeRegExp(p)+")\\s*$"),E=function(e,t){_(e,t)||s&&!/\S/.test(e)||(r.insertInLine({row:t,column:e.length},p),r.insertInLine({row:t,column:a},m))},v=function(e,t){var n;(n=e.match(f))&&r.removeInLine(t,e.length-n[0].length,e.length),(n=e.match(g))&&r.removeInLine(t,n[1].length,n[0].length)},_=function(e,n){if(g.test(e))return!0;for(var i=t.getTokens(n),r=0;r<i.length;r++)if("comment"===i[r].type)return!0}}function C(e){for(var t=n;t<=i;t++)e(r.getLine(t),t)}var A=1/0;C((function(e,t){var n=e.search(/\S/);-1!==n?(n<a&&(a=n),o&&!_(e,t)&&(o=!1)):A>e.length&&(A=e.length)})),a==1/0&&(a=A,s=!1,o=!1),u&&a%c!=0&&(a=Math.floor(a/c)*c),C(o?v:E)},this.toggleBlockComment=function(e,t,n,i){var r=this.blockComment;if(r){!r.start&&r[0]&&(r=r[0]);var s,o,a=(g=new c(t,i.row,i.column)).getCurrentToken(),l=(t.selection,t.selection.toOrientedRange());if(a&&/comment/.test(a.type)){for(var h,d;a&&/comment/.test(a.type);){if(-1!=(f=a.value.indexOf(r.start))){var m=g.getCurrentTokenRow(),p=g.getCurrentTokenColumn()+f;h=new u(m,p,m,p+r.start.length);break}a=g.stepBackward()}var g;for(a=(g=new c(t,i.row,i.column)).getCurrentToken();a&&/comment/.test(a.type);){var f;if(-1!=(f=a.value.indexOf(r.end))){m=g.getCurrentTokenRow(),p=g.getCurrentTokenColumn()+f,d=new u(m,p,m,p+r.end.length);break}a=g.stepForward()}d&&t.remove(d),h&&(t.remove(h),s=h.start.row,o=-r.start.length)}else o=r.start.length,s=n.start.row,t.insert(n.end,r.end),t.insert(n.start,r.start);l.start.row==s&&(l.start.column+=o),l.end.row==s&&(l.end.column+=o),t.selection.fromOrientedRange(l)}},this.getNextLineIndent=function(e,t,n){return this.$getIndent(t)},this.checkOutdent=function(e,t,n){return!1},this.autoOutdent=function(e,t,n){},this.$getIndent=function(e){return e.match(/^\s*/)[0]},this.createWorker=function(e){return null},this.createModeDelegates=function(e){for(var t in this.$embeds=[],this.$modes={},e)if(e[t]){var n=e[t],r=n.prototype.$id,s=i.$modes[r];s||(i.$modes[r]=s=new n),i.$modes[t]||(i.$modes[t]=s),this.$embeds.push(t),this.$modes[t]=s}var o=["toggleBlockComment","toggleCommentLines","getNextLineIndent","checkOutdent","autoOutdent","transformAction","getCompletions"];for(t=0;t<o.length;t++)!function(e){var n=o[t],i=e[n];e[o[t]]=function(){return this.$delegator(n,arguments,i)}}(this)},this.$delegator=function(e,t,n){var i=t[0]||"start";if("string"!=typeof i){if(Array.isArray(i[2])){var r=i[2][i[2].length-1];if(o=this.$modes[r])return o[e].apply(o,[i[1]].concat([].slice.call(t,1)))}i=i[0]||"start"}for(var s=0;s<this.$embeds.length;s++)if(this.$modes[this.$embeds[s]]){var o,a=i.split(this.$embeds[s]);if(!a[0]&&a[1])return t[0]=a[1],(o=this.$modes[this.$embeds[s]])[e].apply(o,t)}var l=n.apply(this,t);return n?l:void 0},this.transformAction=function(e,t,n,i,r){if(this.$behaviour){var s=this.$behaviour.getBehaviours();for(var o in s)if(s[o][t]){var a=s[o][t].apply(this,arguments);if(a)return a}}},this.getKeywords=function(e){if(!this.completionKeywords){var t=this.$tokenizer.rules,n=[];for(var i in t)for(var r=t[i],s=0,o=r.length;s<o;s++)if("string"==typeof r[s].token)/keyword|support|storage/.test(r[s].token)&&n.push(r[s].regex);else if("object"==typeof r[s].token)for(var a=0,l=r[s].token.length;a<l;a++)/keyword|support|storage/.test(r[s].token[a])&&(i=r[s].regex.match(/\(.+?\)/g)[a],n.push(i.substr(1,i.length-2)));this.completionKeywords=n}return e?n.concat(this.$keywordList||[]):this.$keywordList},this.$createKeywordList=function(){return this.$highlightRules||this.getTokenizer(),this.$keywordList=this.$highlightRules.$keywordList||[]},this.getCompletions=function(e,t,n,i){return(this.$keywordList||this.$createKeywordList()).map((function(e){return{name:e,value:e,score:0,meta:"keyword"}}))},this.$id="ace/mode/text"}).call(h.prototype),t.Mode=h})),ace.define("ace/apply_delta",["require","exports","module"],(function(e,t,n){"use strict";t.applyDelta=function(e,t,n){var i=t.start.row,r=t.start.column,s=e[i]||"";switch(t.action){case"insert":if(1===t.lines.length)e[i]=s.substring(0,r)+t.lines[0]+s.substring(r);else{var o=[i,1].concat(t.lines);e.splice.apply(e,o),e[i]=s.substring(0,r)+e[i],e[i+t.lines.length-1]+=s.substring(r)}break;case"remove":var a=t.end.column,l=t.end.row;i===l?e[i]=s.substring(0,r)+s.substring(a):e.splice(i,l-i+1,s.substring(0,r)+e[l].substring(a))}}})),ace.define("ace/anchor",["require","exports","module","ace/lib/oop","ace/lib/event_emitter"],(function(e,t,n){"use strict";var i=e("./lib/oop"),r=e("./lib/event_emitter").EventEmitter,s=t.Anchor=function(e,t,n){this.$onChange=this.onChange.bind(this),this.attach(e),void 0===n?this.setPosition(t.row,t.column):this.setPosition(t,n)};(function(){function e(e,t,n){var i=n?e.column<=t.column:e.column<t.column;return e.row<t.row||e.row==t.row&&i}i.implement(this,r),this.getPosition=function(){return this.$clipPositionToDocument(this.row,this.column)},this.getDocument=function(){return this.document},this.$insertRight=!1,this.onChange=function(t){if(!(t.start.row==t.end.row&&t.start.row!=this.row||t.start.row>this.row)){var n=function(t,n,i){var r="insert"==t.action,s=(r?1:-1)*(t.end.row-t.start.row),o=(r?1:-1)*(t.end.column-t.start.column),a=t.start,l=r?a:t.end;return e(n,a,i)?{row:n.row,column:n.column}:e(l,n,!i)?{row:n.row+s,column:n.column+(n.row==l.row?o:0)}:{row:a.row,column:a.column}}(t,{row:this.row,column:this.column},this.$insertRight);this.setPosition(n.row,n.column,!0)}},this.setPosition=function(e,t,n){var i;if(i=n?{row:e,column:t}:this.$clipPositionToDocument(e,t),this.row!=i.row||this.column!=i.column){var r={row:this.row,column:this.column};this.row=i.row,this.column=i.column,this._signal("change",{old:r,value:i})}},this.detach=function(){this.document.removeEventListener("change",this.$onChange)},this.attach=function(e){this.document=e||this.document,this.document.on("change",this.$onChange)},this.$clipPositionToDocument=function(e,t){var n={};return e>=this.document.getLength()?(n.row=Math.max(0,this.document.getLength()-1),n.column=this.document.getLine(n.row).length):e<0?(n.row=0,n.column=0):(n.row=e,n.column=Math.min(this.document.getLine(n.row).length,Math.max(0,t))),t<0&&(n.column=0),n}}).call(s.prototype)})),ace.define("ace/document",["require","exports","module","ace/lib/oop","ace/apply_delta","ace/lib/event_emitter","ace/range","ace/anchor"],(function(e,t,n){"use strict";var i=e("./lib/oop"),r=e("./apply_delta").applyDelta,s=e("./lib/event_emitter").EventEmitter,o=e("./range").Range,a=e("./anchor").Anchor,l=function(e){this.$lines=[""],0===e.length?this.$lines=[""]:Array.isArray(e)?this.insertMergedLines({row:0,column:0},e):this.insert({row:0,column:0},e)};(function(){i.implement(this,s),this.setValue=function(e){var t=this.getLength()-1;this.remove(new o(0,0,t,this.getLine(t).length)),this.insert({row:0,column:0},e)},this.getValue=function(){return this.getAllLines().join(this.getNewLineCharacter())},this.createAnchor=function(e,t){return new a(this,e,t)},0==="aaa".split(/a/).length?this.$split=function(e){return e.replace(/\r\n|\r/g,"\n").split("\n")}:this.$split=function(e){return e.split(/\r\n|\r|\n/)},this.$detectNewLine=function(e){var t=e.match(/^.*?(\r\n|\r|\n)/m);this.$autoNewLine=t?t[1]:"\n",this._signal("changeNewLineMode")},this.getNewLineCharacter=function(){switch(this.$newLineMode){case"windows":return"\r\n";case"unix":return"\n";default:return this.$autoNewLine||"\n"}},this.$autoNewLine="",this.$newLineMode="auto",this.setNewLineMode=function(e){this.$newLineMode!==e&&(this.$newLineMode=e,this._signal("changeNewLineMode"))},this.getNewLineMode=function(){return this.$newLineMode},this.isNewLine=function(e){return"\r\n"==e||"\r"==e||"\n"==e},this.getLine=function(e){return this.$lines[e]||""},this.getLines=function(e,t){return this.$lines.slice(e,t+1)},this.getAllLines=function(){return this.getLines(0,this.getLength())},this.getLength=function(){return this.$lines.length},this.getTextRange=function(e){return this.getLinesForRange(e).join(this.getNewLineCharacter())},this.getLinesForRange=function(e){var t;if(e.start.row===e.end.row)t=[this.getLine(e.start.row).substring(e.start.column,e.end.column)];else{(t=this.getLines(e.start.row,e.end.row))[0]=(t[0]||"").substring(e.start.column);var n=t.length-1;e.end.row-e.start.row==n&&(t[n]=t[n].substring(0,e.end.column))}return t},this.insertLines=function(e,t){return console.warn("Use of document.insertLines is deprecated. Use the insertFullLines method instead."),this.insertFullLines(e,t)},this.removeLines=function(e,t){return console.warn("Use of document.removeLines is deprecated. Use the removeFullLines method instead."),this.removeFullLines(e,t)},this.insertNewLine=function(e){return console.warn("Use of document.insertNewLine is deprecated. Use insertMergedLines(position, ['', '']) instead."),this.insertMergedLines(e,["",""])},this.insert=function(e,t){return this.getLength()<=1&&this.$detectNewLine(t),this.insertMergedLines(e,this.$split(t))},this.insertInLine=function(e,t){var n=this.clippedPos(e.row,e.column),i=this.pos(e.row,e.column+t.length);return this.applyDelta({start:n,end:i,action:"insert",lines:[t]},!0),this.clonePos(i)},this.clippedPos=function(e,t){var n=this.getLength();void 0===e?e=n:e<0?e=0:e>=n&&(e=n-1,t=void 0);var i=this.getLine(e);return null==t&&(t=i.length),{row:e,column:t=Math.min(Math.max(t,0),i.length)}},this.clonePos=function(e){return{row:e.row,column:e.column}},this.pos=function(e,t){return{row:e,column:t}},this.$clipPosition=function(e){var t=this.getLength();return e.row>=t?(e.row=Math.max(0,t-1),e.column=this.getLine(t-1).length):(e.row=Math.max(0,e.row),e.column=Math.min(Math.max(e.column,0),this.getLine(e.row).length)),e},this.insertFullLines=function(e,t){var n=0;(e=Math.min(Math.max(e,0),this.getLength()))<this.getLength()?(t=t.concat([""]),n=0):(t=[""].concat(t),e--,n=this.$lines[e].length),this.insertMergedLines({row:e,column:n},t)},this.insertMergedLines=function(e,t){var n=this.clippedPos(e.row,e.column),i={row:n.row+t.length-1,column:(1==t.length?n.column:0)+t[t.length-1].length};return this.applyDelta({start:n,end:i,action:"insert",lines:t}),this.clonePos(i)},this.remove=function(e){var t=this.clippedPos(e.start.row,e.start.column),n=this.clippedPos(e.end.row,e.end.column);return this.applyDelta({start:t,end:n,action:"remove",lines:this.getLinesForRange({start:t,end:n})}),this.clonePos(t)},this.removeInLine=function(e,t,n){var i=this.clippedPos(e,t),r=this.clippedPos(e,n);return this.applyDelta({start:i,end:r,action:"remove",lines:this.getLinesForRange({start:i,end:r})},!0),this.clonePos(i)},this.removeFullLines=function(e,t){e=Math.min(Math.max(0,e),this.getLength()-1);var n=(t=Math.min(Math.max(0,t),this.getLength()-1))==this.getLength()-1&&e>0,i=t<this.getLength()-1,r=n?e-1:e,s=n?this.getLine(r).length:0,a=i?t+1:t,l=i?0:this.getLine(a).length,c=new o(r,s,a,l),u=this.$lines.slice(e,t+1);return this.applyDelta({start:c.start,end:c.end,action:"remove",lines:this.getLinesForRange(c)}),u},this.removeNewLine=function(e){e<this.getLength()-1&&e>=0&&this.applyDelta({start:this.pos(e,this.getLine(e).length),end:this.pos(e+1,0),action:"remove",lines:["",""]})},this.replace=function(e,t){return e instanceof o||(e=o.fromPoints(e.start,e.end)),0===t.length&&e.isEmpty()?e.start:t==this.getTextRange(e)?e.end:(this.remove(e),t?this.insert(e.start,t):e.start)},this.applyDeltas=function(e){for(var t=0;t<e.length;t++)this.applyDelta(e[t])},this.revertDeltas=function(e){for(var t=e.length-1;t>=0;t--)this.revertDelta(e[t])},this.applyDelta=function(e,t){var n="insert"==e.action;(n?e.lines.length<=1&&!e.lines[0]:!o.comparePoints(e.start,e.end))||(n&&e.lines.length>2e4?this.$splitAndapplyLargeDelta(e,2e4):(r(this.$lines,e,t),this._signal("change",e)))},this.$splitAndapplyLargeDelta=function(e,t){for(var n=e.lines,i=n.length-t+1,r=e.start.row,s=e.start.column,o=0,a=0;o<i;o=a){a+=t-1;var l=n.slice(o,a);l.push(""),this.applyDelta({start:this.pos(r+o,s),end:this.pos(r+a,s=0),action:e.action,lines:l},!0)}e.lines=n.slice(o),e.start.row=r+o,e.start.column=s,this.applyDelta(e,!0)},this.revertDelta=function(e){this.applyDelta({start:this.clonePos(e.start),end:this.clonePos(e.end),action:"insert"==e.action?"remove":"insert",lines:e.lines.slice()})},this.indexToPosition=function(e,t){for(var n=this.$lines||this.getAllLines(),i=this.getNewLineCharacter().length,r=t||0,s=n.length;r<s;r++)if((e-=n[r].length+i)<0)return{row:r,column:e+n[r].length+i};return{row:s-1,column:e+n[s-1].length+i}},this.positionToIndex=function(e,t){for(var n=this.$lines||this.getAllLines(),i=this.getNewLineCharacter().length,r=0,s=Math.min(e.row,n.length),o=t||0;o<s;++o)r+=n[o].length+i;return r+e.column}}).call(l.prototype),t.Document=l})),ace.define("ace/background_tokenizer",["require","exports","module","ace/lib/oop","ace/lib/event_emitter"],(function(e,t,n){"use strict";var i=e("./lib/oop"),r=e("./lib/event_emitter").EventEmitter,s=function(e,t){this.running=!1,this.lines=[],this.states=[],this.currentLine=0,this.tokenizer=e;var n=this;this.$worker=function(){if(n.running){for(var e=new Date,t=n.currentLine,i=-1,r=n.doc,s=t;n.lines[t];)t++;var o=r.getLength(),a=0;for(n.running=!1;t<o;){n.$tokenizeRow(t),i=t;do{t++}while(n.lines[t]);if(++a%5==0&&new Date-e>20){n.running=setTimeout(n.$worker,20);break}}n.currentLine=t,-1==i&&(i=t),s<=i&&n.fireUpdateEvent(s,i)}}};(function(){i.implement(this,r),this.setTokenizer=function(e){this.tokenizer=e,this.lines=[],this.states=[],this.start(0)},this.setDocument=function(e){this.doc=e,this.lines=[],this.states=[],this.stop()},this.fireUpdateEvent=function(e,t){var n={first:e,last:t};this._signal("update",{data:n})},this.start=function(e){this.currentLine=Math.min(e||0,this.currentLine,this.doc.getLength()),this.lines.splice(this.currentLine,this.lines.length),this.states.splice(this.currentLine,this.states.length),this.stop(),this.running=setTimeout(this.$worker,700)},this.scheduleStart=function(){this.running||(this.running=setTimeout(this.$worker,700))},this.$updateOnChange=function(e){var t=e.start.row,n=e.end.row-t;if(0===n)this.lines[t]=null;else if("remove"==e.action)this.lines.splice(t,n+1,null),this.states.splice(t,n+1,null);else{var i=Array(n+1);i.unshift(t,1),this.lines.splice.apply(this.lines,i),this.states.splice.apply(this.states,i)}this.currentLine=Math.min(t,this.currentLine,this.doc.getLength()),this.stop()},this.stop=function(){this.running&&clearTimeout(this.running),this.running=!1},this.getTokens=function(e){return this.lines[e]||this.$tokenizeRow(e)},this.getState=function(e){return this.currentLine==e&&this.$tokenizeRow(e),this.states[e]||"start"},this.$tokenizeRow=function(e){var t=this.doc.getLine(e),n=this.states[e-1],i=this.tokenizer.getLineTokens(t,n,e);return this.states[e]+""!=i.state+""?(this.states[e]=i.state,this.lines[e+1]=null,this.currentLine>e+1&&(this.currentLine=e+1)):this.currentLine==e&&(this.currentLine=e+1),this.lines[e]=i.tokens}}).call(s.prototype),t.BackgroundTokenizer=s})),ace.define("ace/search_highlight",["require","exports","module","ace/lib/lang","ace/lib/oop","ace/range"],(function(e,t,n){"use strict";var i=e("./lib/lang"),r=(e("./lib/oop"),e("./range").Range),s=function(e,t,n){this.setRegexp(e),this.clazz=t,this.type=n||"text"};(function(){this.MAX_RANGES=500,this.setRegexp=function(e){this.regExp+""!=e+""&&(this.regExp=e,this.cache=[])},this.update=function(e,t,n,s){if(this.regExp)for(var o=s.firstRow,a=s.lastRow,l=o;l<=a;l++){var c=this.cache[l];null==c&&((c=i.getMatchOffsets(n.getLine(l),this.regExp)).length>this.MAX_RANGES&&(c=c.slice(0,this.MAX_RANGES)),c=c.map((function(e){return new r(l,e.offset,l,e.offset+e.length)})),this.cache[l]=c.length?c:"");for(var u=c.length;u--;)t.drawSingleLineMarker(e,c[u].toScreenRange(n),this.clazz,s)}}}).call(s.prototype),t.SearchHighlight=s})),ace.define("ace/edit_session/fold_line",["require","exports","module","ace/range"],(function(e,t,n){"use strict";var i=e("../range").Range;function r(e,t){this.foldData=e,Array.isArray(t)?this.folds=t:t=this.folds=[t];var n=t[t.length-1];this.range=new i(t[0].start.row,t[0].start.column,n.end.row,n.end.column),this.start=this.range.start,this.end=this.range.end,this.folds.forEach((function(e){e.setFoldLine(this)}),this)}(function(){this.shiftRow=function(e){this.start.row+=e,this.end.row+=e,this.folds.forEach((function(t){t.start.row+=e,t.end.row+=e}))},this.addFold=function(e){if(e.sameRow){if(e.start.row<this.startRow||e.endRow>this.endRow)throw new Error("Can't add a fold to this FoldLine as it has no connection");this.folds.push(e),this.folds.sort((function(e,t){return-e.range.compareEnd(t.start.row,t.start.column)})),this.range.compareEnd(e.start.row,e.start.column)>0?(this.end.row=e.end.row,this.end.column=e.end.column):this.range.compareStart(e.end.row,e.end.column)<0&&(this.start.row=e.start.row,this.start.column=e.start.column)}else if(e.start.row==this.end.row)this.folds.push(e),this.end.row=e.end.row,this.end.column=e.end.column;else{if(e.end.row!=this.start.row)throw new Error("Trying to add fold to FoldRow that doesn't have a matching row");this.folds.unshift(e),this.start.row=e.start.row,this.start.column=e.start.column}e.foldLine=this},this.containsRow=function(e){return e>=this.start.row&&e<=this.end.row},this.walk=function(e,t,n){var i,r,s=0,o=this.folds,a=!0;null==t&&(t=this.end.row,n=this.end.column);for(var l=0;l<o.length;l++){if(-1==(r=(i=o[l]).range.compareStart(t,n)))return void e(null,t,n,s,a);if(!e(null,i.start.row,i.start.column,s,a)&&e(i.placeholder,i.start.row,i.start.column,s)||0===r)return;a=!i.sameRow,s=i.end.column}e(null,t,n,s,a)},this.getNextFoldTo=function(e,t){for(var n,i,r=0;r<this.folds.length;r++){if(-1==(i=(n=this.folds[r]).range.compareEnd(e,t)))return{fold:n,kind:"after"};if(0===i)return{fold:n,kind:"inside"}}return null},this.addRemoveChars=function(e,t,n){var i,r,s=this.getNextFoldTo(e,t);if(s)if(i=s.fold,"inside"==s.kind&&i.start.column!=t&&i.start.row!=e)window.console&&window.console.log(e,t,i);else if(i.start.row==e){var o=(r=this.folds).indexOf(i);for(0===o&&(this.start.column+=n);o<r.length;o++){if((i=r[o]).start.column+=n,!i.sameRow)return;i.end.column+=n}this.end.column+=n}},this.split=function(e,t){var n=this.getNextFoldTo(e,t);if(!n||"inside"==n.kind)return null;var i=n.fold,s=this.folds,o=this.foldData,a=s.indexOf(i),l=s[a-1];this.end.row=l.end.row,this.end.column=l.end.column;var c=new r(o,s=s.splice(a,s.length-a));return o.splice(o.indexOf(this)+1,0,c),c},this.merge=function(e){for(var t=e.folds,n=0;n<t.length;n++)this.addFold(t[n]);var i=this.foldData;i.splice(i.indexOf(e),1)},this.toString=function(){var e=[this.range.toString()+": ["];return this.folds.forEach((function(t){e.push("  "+t.toString())})),e.push("]"),e.join("\n")},this.idxToPosition=function(e){for(var t=0,n=0;n<this.folds.length;n++){var i=this.folds[n];if((e-=i.start.column-t)<0)return{row:i.start.row,column:i.start.column+e};if((e-=i.placeholder.length)<0)return i.start;t=i.end.column}return{row:this.end.row,column:this.end.column+e}}}).call(r.prototype),t.FoldLine=r})),ace.define("ace/range_list",["require","exports","module","ace/range"],(function(e,t,n){"use strict";var i=e("./range").Range.comparePoints,r=function(){this.ranges=[],this.$bias=1};(function(){this.comparePoints=i,this.pointIndex=function(e,t,n){for(var r=this.ranges,s=n||0;s<r.length;s++){var o=r[s],a=i(e,o.end);if(!(a>0)){var l=i(e,o.start);return 0===a?t&&0!==l?-s-2:s:l>0||0===l&&!t?s:-s-1}}return-s-1},this.add=function(e){var t=!e.isEmpty(),n=this.pointIndex(e.start,t);n<0&&(n=-n-1);var i=this.pointIndex(e.end,t,n);return i<0?i=-i-1:i++,this.ranges.splice(n,i-n,e)},this.addList=function(e){for(var t=[],n=e.length;n--;)t.push.apply(t,this.add(e[n]));return t},this.substractPoint=function(e){var t=this.pointIndex(e);if(t>=0)return this.ranges.splice(t,1)},this.merge=function(){for(var e,t=[],n=this.ranges,r=(n=n.sort((function(e,t){return i(e.start,t.start)})))[0],s=1;s<n.length;s++){e=r,r=n[s];var o=i(e.end,r.start);o<0||(0!=o||e.isEmpty()||r.isEmpty())&&(i(e.end,r.end)<0&&(e.end.row=r.end.row,e.end.column=r.end.column),n.splice(s,1),t.push(r),r=e,s--)}return this.ranges=n,t},this.contains=function(e,t){return this.pointIndex({row:e,column:t})>=0},this.containsPoint=function(e){return this.pointIndex(e)>=0},this.rangeAtPoint=function(e){var t=this.pointIndex(e);if(t>=0)return this.ranges[t]},this.clipRows=function(e,t){var n=this.ranges;if(n[0].start.row>t||n[n.length-1].start.row<e)return[];var i=this.pointIndex({row:e,column:0});i<0&&(i=-i-1);var r=this.pointIndex({row:t,column:0},i);r<0&&(r=-r-1);for(var s=[],o=i;o<r;o++)s.push(n[o]);return s},this.removeAll=function(){return this.ranges.splice(0,this.ranges.length)},this.attach=function(e){this.session&&this.detach(),this.session=e,this.onChange=this.$onChange.bind(this),this.session.on("change",this.onChange)},this.detach=function(){this.session&&(this.session.removeListener("change",this.onChange),this.session=null)},this.$onChange=function(e){for(var t=e.start,n=e.end,i=t.row,r=n.row,s=this.ranges,o=0,a=s.length;o<a&&!((u=s[o]).end.row>=i);o++);if("insert"==e.action){for(var l=r-i,c=-t.column+n.column;o<a&&!((u=s[o]).start.row>i);o++)if(u.start.row==i&&u.start.column>=t.column&&(u.start.column==t.column&&this.$bias<=0||(u.start.column+=c,u.start.row+=l)),u.end.row==i&&u.end.column>=t.column){if(u.end.column==t.column&&this.$bias<0)continue;u.end.column==t.column&&c>0&&o<a-1&&u.end.column>u.start.column&&u.end.column==s[o+1].start.column&&(u.end.column-=c),u.end.column+=c,u.end.row+=l}}else for(l=i-r,c=t.column-n.column;o<a&&!((u=s[o]).start.row>r);o++)u.end.row<r&&(i<u.end.row||i==u.end.row&&t.column<u.end.column)?(u.end.row=i,u.end.column=t.column):u.end.row==r?u.end.column<=n.column?(l||u.end.column>t.column)&&(u.end.column=t.column,u.end.row=t.row):(u.end.column+=c,u.end.row+=l):u.end.row>r&&(u.end.row+=l),u.start.row<r&&(i<u.start.row||i==u.start.row&&t.column<u.start.column)?(u.start.row=i,u.start.column=t.column):u.start.row==r?u.start.column<=n.column?(l||u.start.column>t.column)&&(u.start.column=t.column,u.start.row=t.row):(u.start.column+=c,u.start.row+=l):u.start.row>r&&(u.start.row+=l);if(0!=l&&o<a)for(;o<a;o++){var u;(u=s[o]).start.row+=l,u.end.row+=l}}}).call(r.prototype),t.RangeList=r})),ace.define("ace/edit_session/fold",["require","exports","module","ace/range_list","ace/lib/oop"],(function(e,t,n){"use strict";var i=e("../range_list").RangeList,r=e("../lib/oop"),s=t.Fold=function(e,t){this.foldLine=null,this.placeholder=t,this.range=e,this.start=e.start,this.end=e.end,this.sameRow=e.start.row==e.end.row,this.subFolds=this.ranges=[]};function o(e,t){e.row-=t.row,0==e.row&&(e.column-=t.column)}function a(e,t){0==e.row&&(e.column+=t.column),e.row+=t.row}r.inherits(s,i),function(){this.toString=function(){return'"'+this.placeholder+'" '+this.range.toString()},this.setFoldLine=function(e){this.foldLine=e,this.subFolds.forEach((function(t){t.setFoldLine(e)}))},this.clone=function(){var e=this.range.clone(),t=new s(e,this.placeholder);return this.subFolds.forEach((function(e){t.subFolds.push(e.clone())})),t.collapseChildren=this.collapseChildren,t},this.addSubFold=function(e){if(!this.range.isEqual(e)){var t,n;t=e,n=this.start,o(t.start,n),o(t.end,n);for(var i=e.start.row,r=e.start.column,s=0,a=-1;s<this.subFolds.length&&1==(a=this.subFolds[s].range.compare(i,r));s++);var l=this.subFolds[s],c=0;if(0==a){if(l.range.containsRange(e))return l.addSubFold(e);c=1}i=e.range.end.row,r=e.range.end.column;var u=s;for(a=-1;u<this.subFolds.length&&1==(a=this.subFolds[u].range.compare(i,r));u++);0==a&&u++;for(var h=this.subFolds.splice(s,u-s,e),d=0==a?h.length-1:h.length,m=c;m<d;m++)e.addSubFold(h[m]);return e.setFoldLine(this.foldLine),e}},this.restoreRange=function(e){return function(e,t){a(e.start,t),a(e.end,t)}(e,this.start)}}.call(s.prototype)})),ace.define("ace/edit_session/folding",["require","exports","module","ace/range","ace/edit_session/fold_line","ace/edit_session/fold","ace/token_iterator"],(function(e,t,n){"use strict";var i=e("../range").Range,r=e("./fold_line").FoldLine,s=e("./fold").Fold,o=e("../token_iterator").TokenIterator;t.Folding=function(){this.getFoldAt=function(e,t,n){var i=this.getFoldLine(e);if(!i)return null;for(var r=i.folds,s=0;s<r.length;s++){var o=r[s].range;if(o.contains(e,t)){if(1==n&&o.isEnd(e,t)&&!o.isEmpty())continue;if(-1==n&&o.isStart(e,t)&&!o.isEmpty())continue;return r[s]}}},this.getFoldsInRange=function(e){var t=e.start,n=e.end,i=this.$foldData,r=[];t.column+=1,n.column-=1;for(var s=0;s<i.length;s++){var o=i[s].range.compareRange(e);if(2!=o){if(-2==o)break;for(var a=i[s].folds,l=0;l<a.length;l++){var c=a[l];if(-2==(o=c.range.compareRange(e)))break;if(2!=o){if(42==o)break;r.push(c)}}}}return t.column-=1,n.column+=1,r},this.getFoldsInRangeList=function(e){if(Array.isArray(e)){var t=[];e.forEach((function(e){t=t.concat(this.getFoldsInRange(e))}),this)}else t=this.getFoldsInRange(e);return t},this.getAllFolds=function(){for(var e=[],t=this.$foldData,n=0;n<t.length;n++)for(var i=0;i<t[n].folds.length;i++)e.push(t[n].folds[i]);return e},this.getFoldStringAt=function(e,t,n,i){if(!(i=i||this.getFoldLine(e)))return null;for(var r,s,o={end:{column:0}},a=0;a<i.folds.length;a++){var l=(s=i.folds[a]).range.compareEnd(e,t);if(-1==l){r=this.getLine(s.start.row).substring(o.end.column,s.start.column);break}if(0===l)return null;o=s}return r||(r=this.getLine(s.start.row).substring(o.end.column)),-1==n?r.substring(0,t-o.end.column):1==n?r.substring(t-o.end.column):r},this.getFoldLine=function(e,t){var n=this.$foldData,i=0;for(t&&(i=n.indexOf(t)),-1==i&&(i=0);i<n.length;i++){var r=n[i];if(r.start.row<=e&&r.end.row>=e)return r;if(r.end.row>e)return null}return null},this.getNextFoldLine=function(e,t){var n=this.$foldData,i=0;for(t&&(i=n.indexOf(t)),-1==i&&(i=0);i<n.length;i++){var r=n[i];if(r.end.row>=e)return r}return null},this.getFoldedRowCount=function(e,t){for(var n=this.$foldData,i=t-e+1,r=0;r<n.length;r++){var s=n[r],o=s.end.row,a=s.start.row;if(o>=t){a<t&&(a>=e?i-=t-a:i=0);break}o>=e&&(i-=a>=e?o-a:o-e+1)}return i},this.$addFoldLine=function(e){return this.$foldData.push(e),this.$foldData.sort((function(e,t){return e.start.row-t.start.row})),e},this.addFold=function(e,t){var n,i=this.$foldData,o=!1;e instanceof s?n=e:(n=new s(t,e)).collapseChildren=t.collapseChildren,this.$clipRangeToDocument(n.range);var a=n.start.row,l=n.start.column,c=n.end.row,u=n.end.column,h=this.getFoldAt(a,l,1),d=this.getFoldAt(c,u,-1);if(h&&d==h)return h.addSubFold(n);h&&!h.range.isStart(a,l)&&this.removeFold(h),d&&!d.range.isEnd(c,u)&&this.removeFold(d);var m=this.getFoldsInRange(n.range);m.length>0&&(this.removeFolds(m),m.forEach((function(e){n.addSubFold(e)})));for(var p=0;p<i.length;p++){var g=i[p];if(c==g.start.row){g.addFold(n),o=!0;break}if(a==g.end.row){if(g.addFold(n),o=!0,!n.sameRow){var f=i[p+1];if(f&&f.start.row==c){g.merge(f);break}}break}if(c<=g.start.row)break}return o||(g=this.$addFoldLine(new r(this.$foldData,n))),this.$useWrapMode?this.$updateWrapData(g.start.row,g.start.row):this.$updateRowLengthCache(g.start.row,g.start.row),this.$modified=!0,this._signal("changeFold",{data:n,action:"add"}),n},this.addFolds=function(e){e.forEach((function(e){this.addFold(e)}),this)},this.removeFold=function(e){var t=e.foldLine,n=t.start.row,i=t.end.row,r=this.$foldData,s=t.folds;if(1==s.length)r.splice(r.indexOf(t),1);else if(t.range.isEnd(e.end.row,e.end.column))s.pop(),t.end.row=s[s.length-1].end.row,t.end.column=s[s.length-1].end.column;else if(t.range.isStart(e.start.row,e.start.column))s.shift(),t.start.row=s[0].start.row,t.start.column=s[0].start.column;else if(e.sameRow)s.splice(s.indexOf(e),1);else{var o=t.split(e.start.row,e.start.column);(s=o.folds).shift(),o.start.row=s[0].start.row,o.start.column=s[0].start.column}this.$updating||(this.$useWrapMode?this.$updateWrapData(n,i):this.$updateRowLengthCache(n,i)),this.$modified=!0,this._signal("changeFold",{data:e,action:"remove"})},this.removeFolds=function(e){for(var t=[],n=0;n<e.length;n++)t.push(e[n]);t.forEach((function(e){this.removeFold(e)}),this),this.$modified=!0},this.expandFold=function(e){this.removeFold(e),e.subFolds.forEach((function(t){e.restoreRange(t),this.addFold(t)}),this),e.collapseChildren>0&&this.foldAll(e.start.row+1,e.end.row,e.collapseChildren-1),e.subFolds=[]},this.expandFolds=function(e){e.forEach((function(e){this.expandFold(e)}),this)},this.unfold=function(e,t){var n,r;if(null==e?(n=new i(0,0,this.getLength(),0),t=!0):n="number"==typeof e?new i(e,0,e,this.getLine(e).length):"row"in e?i.fromPoints(e,e):e,r=this.getFoldsInRangeList(n),t)this.removeFolds(r);else for(var s=r;s.length;)this.expandFolds(s),s=this.getFoldsInRangeList(n);if(r.length)return r},this.isRowFolded=function(e,t){return!!this.getFoldLine(e,t)},this.getRowFoldEnd=function(e,t){var n=this.getFoldLine(e,t);return n?n.end.row:e},this.getRowFoldStart=function(e,t){var n=this.getFoldLine(e,t);return n?n.start.row:e},this.getFoldDisplayLine=function(e,t,n,i,r){null==i&&(i=e.start.row),null==r&&(r=0),null==t&&(t=e.end.row),null==n&&(n=this.getLine(t).length);var s=this.doc,o="";return e.walk((function(e,t,n,a){if(!(t<i)){if(t==i){if(n<r)return;a=Math.max(r,a)}o+=null!=e?e:s.getLine(t).substring(a,n)}}),t,n),o},this.getDisplayLine=function(e,t,n,i){var r,s=this.getFoldLine(e);return s?this.getFoldDisplayLine(s,e,t,n,i):(r=this.doc.getLine(e)).substring(i||0,t||r.length)},this.$cloneFoldData=function(){var e=[];return e=this.$foldData.map((function(t){var n=t.folds.map((function(e){return e.clone()}));return new r(e,n)}))},this.toggleFold=function(e){var t,n,i=this.selection.getRange();if(i.isEmpty()){var r=i.start;if(t=this.getFoldAt(r.row,r.column))return void this.expandFold(t);(n=this.findMatchingBracket(r))?1==i.comparePoint(n)?i.end=n:(i.start=n,i.start.column++,i.end.column--):(n=this.findMatchingBracket({row:r.row,column:r.column+1}))?(1==i.comparePoint(n)?i.end=n:i.start=n,i.start.column++):i=this.getCommentFoldRange(r.row,r.column)||i}else{var s=this.getFoldsInRange(i);if(e&&s.length)return void this.expandFolds(s);1==s.length&&(t=s[0])}if(t||(t=this.getFoldAt(i.start.row,i.start.column)),t&&t.range.toString()==i.toString())this.expandFold(t);else{var o="...";if(!i.isMultiLine()){if((o=this.getTextRange(i)).length<4)return;o=o.trim().substring(0,2)+".."}this.addFold(o,i)}},this.getCommentFoldRange=function(e,t,n){var r=new o(this,e,t),s=r.getCurrentToken(),a=s.type;if(s&&/^comment|string/.test(a)){"comment"==(a=a.match(/comment|string/)[0])&&(a+="|doc-start");var l=new RegExp(a),c=new i;if(1!=n){do{s=r.stepBackward()}while(s&&l.test(s.type));r.stepForward()}if(c.start.row=r.getCurrentTokenRow(),c.start.column=r.getCurrentTokenColumn()+2,r=new o(this,e,t),-1!=n){var u=-1;do{if(s=r.stepForward(),-1==u){var h=this.getState(r.$row);l.test(h)||(u=r.$row)}else if(r.$row>u)break}while(s&&l.test(s.type));s=r.stepBackward()}else s=r.getCurrentToken();return c.end.row=r.getCurrentTokenRow(),c.end.column=r.getCurrentTokenColumn()+s.value.length-2,c}},this.foldAll=function(e,t,n){null==n&&(n=1e5);var i=this.foldWidgets;if(i){t=t||this.getLength();for(var r=e=e||0;r<t;r++)if(null==i[r]&&(i[r]=this.getFoldWidget(r)),"start"==i[r]){var s=this.getFoldWidgetRange(r);if(s&&s.isMultiLine()&&s.end.row<=t&&s.start.row>=e){r=s.end.row;try{var o=this.addFold("...",s);o&&(o.collapseChildren=n)}catch(e){}}}}},this.$foldStyles={manual:1,markbegin:1,markbeginend:1},this.$foldStyle="markbegin",this.setFoldStyle=function(e){if(!this.$foldStyles[e])throw new Error("invalid fold style: "+e+"["+Object.keys(this.$foldStyles).join(", ")+"]");if(this.$foldStyle!=e){this.$foldStyle=e,"manual"==e&&this.unfold();var t=this.$foldMode;this.$setFolding(null),this.$setFolding(t)}},this.$setFolding=function(e){this.$foldMode!=e&&(this.$foldMode=e,this.off("change",this.$updateFoldWidgets),this.off("tokenizerUpdate",this.$tokenizerUpdateFoldWidgets),this._signal("changeAnnotation"),e&&"manual"!=this.$foldStyle?(this.foldWidgets=[],this.getFoldWidget=e.getFoldWidget.bind(e,this,this.$foldStyle),this.getFoldWidgetRange=e.getFoldWidgetRange.bind(e,this,this.$foldStyle),this.$updateFoldWidgets=this.updateFoldWidgets.bind(this),this.$tokenizerUpdateFoldWidgets=this.tokenizerUpdateFoldWidgets.bind(this),this.on("change",this.$updateFoldWidgets),this.on("tokenizerUpdate",this.$tokenizerUpdateFoldWidgets)):this.foldWidgets=null)},this.getParentFoldRangeData=function(e,t){var n=this.foldWidgets;if(!n||t&&n[e])return{};for(var i,r=e-1;r>=0;){var s=n[r];if(null==s&&(s=n[r]=this.getFoldWidget(r)),"start"==s){var o=this.getFoldWidgetRange(r);if(i||(i=o),o&&o.end.row>=e)break}r--}return{range:-1!==r&&o,firstRange:i}},this.onFoldWidgetClick=function(e,t){var n={children:(t=t.domEvent).shiftKey,all:t.ctrlKey||t.metaKey,siblings:t.altKey};if(!this.$toggleFoldWidget(e,n)){var i=t.target||t.srcElement;i&&/ace_fold-widget/.test(i.className)&&(i.className+=" ace_invalid")}},this.$toggleFoldWidget=function(e,t){if(this.getFoldWidget){var n=this.getFoldWidget(e),i=this.getLine(e),r="end"===n?-1:1,s=this.getFoldAt(e,-1===r?0:i.length,r);if(s)return t.children||t.all?this.removeFold(s):this.expandFold(s),s;var o=this.getFoldWidgetRange(e,!0);if(o&&!o.isMultiLine()&&(s=this.getFoldAt(o.start.row,o.start.column,1))&&o.isEqual(s.range))return this.removeFold(s),s;if(t.siblings){var a=this.getParentFoldRangeData(e);if(a.range)var l=a.range.start.row+1,c=a.range.end.row;this.foldAll(l,c,t.all?1e4:0)}else t.children?(c=o?o.end.row:this.getLength(),this.foldAll(e+1,c,t.all?1e4:0)):o&&(t.all&&(o.collapseChildren=1e4),this.addFold("...",o));return o}},this.toggleFoldWidget=function(e){var t=this.selection.getCursor().row;t=this.getRowFoldStart(t);var n=this.$toggleFoldWidget(t,{});if(!n){var i=this.getParentFoldRangeData(t,!0);if(n=i.range||i.firstRange){t=n.start.row;var r=this.getFoldAt(t,this.getLine(t).length,1);r?this.removeFold(r):this.addFold("...",n)}}},this.updateFoldWidgets=function(e){var t=e.start.row,n=e.end.row-t;if(0===n)this.foldWidgets[t]=null;else if("remove"==e.action)this.foldWidgets.splice(t,n+1,null);else{var i=Array(n+1);i.unshift(t,1),this.foldWidgets.splice.apply(this.foldWidgets,i)}},this.tokenizerUpdateFoldWidgets=function(e){var t=e.data;t.first!=t.last&&this.foldWidgets.length>t.first&&this.foldWidgets.splice(t.first,this.foldWidgets.length)}}})),ace.define("ace/edit_session/bracket_match",["require","exports","module","ace/token_iterator","ace/range"],(function(e,t,n){"use strict";var i=e("../token_iterator").TokenIterator,r=e("../range").Range;t.BracketMatch=function(){this.findMatchingBracket=function(e,t){if(0==e.column)return null;var n=t||this.getLine(e.row).charAt(e.column-1);if(""==n)return null;var i=n.match(/([\(\[\{])|([\)\]\}])/);return i?i[1]?this.$findClosingBracket(i[1],e):this.$findOpeningBracket(i[2],e):null},this.getBracketRange=function(e){var t,n=this.getLine(e.row),i=!0,s=n.charAt(e.column-1),o=s&&s.match(/([\(\[\{])|([\)\]\}])/);if(o||(s=n.charAt(e.column),e={row:e.row,column:e.column+1},o=s&&s.match(/([\(\[\{])|([\)\]\}])/),i=!1),!o)return null;if(o[1]){if(!(a=this.$findClosingBracket(o[1],e)))return null;t=r.fromPoints(e,a),i||(t.end.column++,t.start.column--),t.cursor=t.end}else{var a;if(!(a=this.$findOpeningBracket(o[2],e)))return null;t=r.fromPoints(a,e),i||(t.start.column++,t.end.column--),t.cursor=t.start}return t},this.$brackets={")":"(","(":")","]":"[","[":"]","{":"}","}":"{","<":">",">":"<"},this.$findOpeningBracket=function(e,t,n){var r=this.$brackets[e],s=1,o=new i(this,t.row,t.column),a=o.getCurrentToken();if(a||(a=o.stepForward()),a){n||(n=new RegExp("(\\.?"+a.type.replace(".","\\.").replace("rparen",".paren").replace(/\b(?:end)\b/,"(?:start|begin|end)")+")+"));for(var l=t.column-o.getCurrentTokenColumn()-2,c=a.value;;){for(;l>=0;){var u=c.charAt(l);if(u==r){if(0==(s-=1))return{row:o.getCurrentTokenRow(),column:l+o.getCurrentTokenColumn()}}else u==e&&(s+=1);l-=1}do{a=o.stepBackward()}while(a&&!n.test(a.type));if(null==a)break;l=(c=a.value).length-1}return null}},this.$findClosingBracket=function(e,t,n){var r=this.$brackets[e],s=1,o=new i(this,t.row,t.column),a=o.getCurrentToken();if(a||(a=o.stepForward()),a){n||(n=new RegExp("(\\.?"+a.type.replace(".","\\.").replace("lparen",".paren").replace(/\b(?:start|begin)\b/,"(?:start|begin|end)")+")+"));for(var l=t.column-o.getCurrentTokenColumn();;){for(var c=a.value,u=c.length;l<u;){var h=c.charAt(l);if(h==r){if(0==(s-=1))return{row:o.getCurrentTokenRow(),column:l+o.getCurrentTokenColumn()}}else h==e&&(s+=1);l+=1}do{a=o.stepForward()}while(a&&!n.test(a.type));if(null==a)break;l=0}return null}}}})),ace.define("ace/edit_session",["require","exports","module","ace/lib/oop","ace/lib/lang","ace/bidihandler","ace/config","ace/lib/event_emitter","ace/selection","ace/mode/text","ace/range","ace/document","ace/background_tokenizer","ace/search_highlight","ace/edit_session/folding","ace/edit_session/bracket_match"],(function(e,t,n){"use strict";var i=e("./lib/oop"),r=e("./lib/lang"),s=e("./bidihandler").BidiHandler,o=e("./config"),a=e("./lib/event_emitter").EventEmitter,l=e("./selection").Selection,c=e("./mode/text").Mode,u=e("./range").Range,h=e("./document").Document,d=e("./background_tokenizer").BackgroundTokenizer,m=e("./search_highlight").SearchHighlight,p=function(e,t){this.$breakpoints=[],this.$decorations=[],this.$frontMarkers={},this.$backMarkers={},this.$markerId=1,this.$undoSelect=!0,this.$foldData=[],this.id="session"+ ++p.$uid,this.$foldData.toString=function(){return this.join("\n")},this.on("changeFold",this.onChangeFold.bind(this)),this.$onChange=this.onChange.bind(this),"object"==typeof e&&e.getLine||(e=new h(e)),this.setDocument(e),this.selection=new l(this),this.$bidiHandler=new s(this),o.resetOptions(this),this.setMode(t),o._signal("session",this)};p.$uid=0,function(){i.implement(this,a),this.setDocument=function(e){this.doc&&this.doc.removeListener("change",this.$onChange),this.doc=e,e.on("change",this.$onChange),this.bgTokenizer&&this.bgTokenizer.setDocument(this.getDocument()),this.resetCaches()},this.getDocument=function(){return this.doc},this.$resetRowCache=function(e){if(!e)return this.$docRowCache=[],void(this.$screenRowCache=[]);var t=this.$docRowCache.length,n=this.$getRowCacheIndex(this.$docRowCache,e)+1;t>n&&(this.$docRowCache.splice(n,t),this.$screenRowCache.splice(n,t))},this.$getRowCacheIndex=function(e,t){for(var n=0,i=e.length-1;n<=i;){var r=n+i>>1,s=e[r];if(t>s)n=r+1;else{if(!(t<s))return r;i=r-1}}return n-1},this.resetCaches=function(){this.$modified=!0,this.$wrapData=[],this.$rowLengthCache=[],this.$resetRowCache(0),this.bgTokenizer&&this.bgTokenizer.start(0)},this.onChangeFold=function(e){var t=e.data;this.$resetRowCache(t.start.row)},this.onChange=function(e){this.$modified=!0,this.$bidiHandler.onChange(e),this.$resetRowCache(e.start.row);var t=this.$updateInternalDataOnChange(e);!this.$fromUndo&&this.$undoManager&&(t&&t.length&&(this.$undoManager.add({action:"removeFolds",folds:t},this.mergeUndoDeltas),this.mergeUndoDeltas=!0),this.$undoManager.add(e,this.mergeUndoDeltas),this.mergeUndoDeltas=!0,this.$informUndoManager.schedule()),this.bgTokenizer&&this.bgTokenizer.$updateOnChange(e),this._signal("change",e)},this.setValue=function(e){this.doc.setValue(e),this.selection.moveTo(0,0),this.$resetRowCache(0),this.setUndoManager(this.$undoManager),this.getUndoManager().reset()},this.getValue=this.toString=function(){return this.doc.getValue()},this.getSelection=function(){return this.selection},this.getState=function(e){return this.bgTokenizer.getState(e)},this.getTokens=function(e){return this.bgTokenizer.getTokens(e)},this.getTokenAt=function(e,t){var n,i=this.bgTokenizer.getTokens(e),r=0;if(null==t){var s=i.length-1;r=this.getLine(e).length}else for(s=0;s<i.length&&!((r+=i[s].value.length)>=t);s++);return(n=i[s])?(n.index=s,n.start=r-n.value.length,n):null},this.setUndoManager=function(e){if(this.$undoManager=e,this.$informUndoManager&&this.$informUndoManager.cancel(),e){var t=this;e.addSession(this),this.$syncInformUndoManager=function(){t.$informUndoManager.cancel(),t.mergeUndoDeltas=!1},this.$informUndoManager=r.delayedCall(this.$syncInformUndoManager)}else this.$syncInformUndoManager=function(){}},this.markUndoGroup=function(){this.$syncInformUndoManager&&this.$syncInformUndoManager()},this.$defaultUndoManager={undo:function(){},redo:function(){},hasUndo:function(){},hasRedo:function(){},reset:function(){},add:function(){},addSelection:function(){},startNewGroup:function(){},addSession:function(){}},this.getUndoManager=function(){return this.$undoManager||this.$defaultUndoManager},this.getTabString=function(){return this.getUseSoftTabs()?r.stringRepeat(" ",this.getTabSize()):"\t"},this.setUseSoftTabs=function(e){this.setOption("useSoftTabs",e)},this.getUseSoftTabs=function(){return this.$useSoftTabs&&!this.$mode.$indentWithTabs},this.setTabSize=function(e){this.setOption("tabSize",e)},this.getTabSize=function(){return this.$tabSize},this.isTabStop=function(e){return this.$useSoftTabs&&e.column%this.$tabSize==0},this.setNavigateWithinSoftTabs=function(e){this.setOption("navigateWithinSoftTabs",e)},this.getNavigateWithinSoftTabs=function(){return this.$navigateWithinSoftTabs},this.$overwrite=!1,this.setOverwrite=function(e){this.setOption("overwrite",e)},this.getOverwrite=function(){return this.$overwrite},this.toggleOverwrite=function(){this.setOverwrite(!this.$overwrite)},this.addGutterDecoration=function(e,t){this.$decorations[e]||(this.$decorations[e]=""),this.$decorations[e]+=" "+t,this._signal("changeBreakpoint",{})},this.removeGutterDecoration=function(e,t){this.$decorations[e]=(this.$decorations[e]||"").replace(" "+t,""),this._signal("changeBreakpoint",{})},this.getBreakpoints=function(){return this.$breakpoints},this.setBreakpoints=function(e){this.$breakpoints=[];for(var t=0;t<e.length;t++)this.$breakpoints[e[t]]="ace_breakpoint";this._signal("changeBreakpoint",{})},this.clearBreakpoints=function(){this.$breakpoints=[],this._signal("changeBreakpoint",{})},this.setBreakpoint=function(e,t){void 0===t&&(t="ace_breakpoint"),t?this.$breakpoints[e]=t:delete this.$breakpoints[e],this._signal("changeBreakpoint",{})},this.clearBreakpoint=function(e){delete this.$breakpoints[e],this._signal("changeBreakpoint",{})},this.addMarker=function(e,t,n,i){var r=this.$markerId++,s={range:e,type:n||"line",renderer:"function"==typeof n?n:null,clazz:t,inFront:!!i,id:r};return i?(this.$frontMarkers[r]=s,this._signal("changeFrontMarker")):(this.$backMarkers[r]=s,this._signal("changeBackMarker")),r},this.addDynamicMarker=function(e,t){if(e.update){var n=this.$markerId++;return e.id=n,e.inFront=!!t,t?(this.$frontMarkers[n]=e,this._signal("changeFrontMarker")):(this.$backMarkers[n]=e,this._signal("changeBackMarker")),e}},this.removeMarker=function(e){var t=this.$frontMarkers[e]||this.$backMarkers[e];t&&(delete(t.inFront?this.$frontMarkers:this.$backMarkers)[e],this._signal(t.inFront?"changeFrontMarker":"changeBackMarker"))},this.getMarkers=function(e){return e?this.$frontMarkers:this.$backMarkers},this.highlight=function(e){if(!this.$searchHighlight){var t=new m(null,"ace_selected-word","text");this.$searchHighlight=this.addDynamicMarker(t)}this.$searchHighlight.setRegexp(e)},this.highlightLines=function(e,t,n,i){"number"!=typeof t&&(n=t,t=e),n||(n="ace_step");var r=new u(e,0,t,1/0);return r.id=this.addMarker(r,n,"fullLine",i),r},this.setAnnotations=function(e){this.$annotations=e,this._signal("changeAnnotation",{})},this.getAnnotations=function(){return this.$annotations||[]},this.clearAnnotations=function(){this.setAnnotations([])},this.$detectNewLine=function(e){var t=e.match(/^.*?(\r?\n)/m);this.$autoNewLine=t?t[1]:"\n"},this.getWordRange=function(e,t){var n=this.getLine(e),i=!1;if(t>0&&(i=!!n.charAt(t-1).match(this.tokenRe)),i||(i=!!n.charAt(t).match(this.tokenRe)),i)var r=this.tokenRe;else r=/^\s+$/.test(n.slice(t-1,t+1))?/\s/:this.nonTokenRe;var s=t;if(s>0){do{s--}while(s>=0&&n.charAt(s).match(r));s++}for(var o=t;o<n.length&&n.charAt(o).match(r);)o++;return new u(e,s,e,o)},this.getAWordRange=function(e,t){for(var n=this.getWordRange(e,t),i=this.getLine(n.end.row);i.charAt(n.end.column).match(/[ \t]/);)n.end.column+=1;return n},this.setNewLineMode=function(e){this.doc.setNewLineMode(e)},this.getNewLineMode=function(){return this.doc.getNewLineMode()},this.setUseWorker=function(e){this.setOption("useWorker",e)},this.getUseWorker=function(){return this.$useWorker},this.onReloadTokenizer=function(e){var t=e.data;this.bgTokenizer.start(t.first),this._signal("tokenizerUpdate",e)},this.$modes=o.$modes,this.$mode=null,this.$modeId=null,this.setMode=function(e,t){if(e&&"object"==typeof e){if(e.getTokenizer)return this.$onChangeMode(e);var n=e,i=n.path}else i=e||"ace/mode/text";if(this.$modes["ace/mode/text"]||(this.$modes["ace/mode/text"]=new c),this.$modes[i]&&!n)return this.$onChangeMode(this.$modes[i]),void(t&&t());this.$modeId=i,o.loadModule(["mode",i],function(e){if(this.$modeId!==i)return t&&t();this.$modes[i]&&!n?this.$onChangeMode(this.$modes[i]):e&&e.Mode&&(e=new e.Mode(n),n||(this.$modes[i]=e,e.$id=i),this.$onChangeMode(e)),t&&t()}.bind(this)),this.$mode||this.$onChangeMode(this.$modes["ace/mode/text"],!0)},this.$onChangeMode=function(e,t){if(t||(this.$modeId=e.$id),this.$mode!==e){this.$mode=e,this.$stopWorker(),this.$useWorker&&this.$startWorker();var n=e.getTokenizer();if(void 0!==n.addEventListener){var i=this.onReloadTokenizer.bind(this);n.addEventListener("update",i)}if(this.bgTokenizer)this.bgTokenizer.setTokenizer(n);else{this.bgTokenizer=new d(n);var r=this;this.bgTokenizer.addEventListener("update",(function(e){r._signal("tokenizerUpdate",e)}))}this.bgTokenizer.setDocument(this.getDocument()),this.tokenRe=e.tokenRe,this.nonTokenRe=e.nonTokenRe,t||(e.attachToSession&&e.attachToSession(this),this.$options.wrapMethod.set.call(this,this.$wrapMethod),this.$setFolding(e.foldingRules),this.bgTokenizer.start(0),this._emit("changeMode"))}},this.$stopWorker=function(){this.$worker&&(this.$worker.terminate(),this.$worker=null)},this.$startWorker=function(){try{this.$worker=this.$mode.createWorker(this)}catch(e){o.warn("Could not load worker",e),this.$worker=null}},this.getMode=function(){return this.$mode},this.$scrollTop=0,this.setScrollTop=function(e){this.$scrollTop===e||isNaN(e)||(this.$scrollTop=e,this._signal("changeScrollTop",e))},this.getScrollTop=function(){return this.$scrollTop},this.$scrollLeft=0,this.setScrollLeft=function(e){this.$scrollLeft===e||isNaN(e)||(this.$scrollLeft=e,this._signal("changeScrollLeft",e))},this.getScrollLeft=function(){return this.$scrollLeft},this.getScreenWidth=function(){return this.$computeWidth(),this.lineWidgets?Math.max(this.getLineWidgetMaxWidth(),this.screenWidth):this.screenWidth},this.getLineWidgetMaxWidth=function(){if(null!=this.lineWidgetsWidth)return this.lineWidgetsWidth;var e=0;return this.lineWidgets.forEach((function(t){t&&t.screenWidth>e&&(e=t.screenWidth)})),this.lineWidgetWidth=e},this.$computeWidth=function(e){if(this.$modified||e){if(this.$modified=!1,this.$useWrapMode)return this.screenWidth=this.$wrapLimit;for(var t=this.doc.getAllLines(),n=this.$rowLengthCache,i=0,r=0,s=this.$foldData[r],o=s?s.start.row:1/0,a=t.length,l=0;l<a;l++){if(l>o){if((l=s.end.row+1)>=a)break;o=(s=this.$foldData[r++])?s.start.row:1/0}null==n[l]&&(n[l]=this.$getStringScreenWidth(t[l])[0]),n[l]>i&&(i=n[l])}this.screenWidth=i}},this.getLine=function(e){return this.doc.getLine(e)},this.getLines=function(e,t){return this.doc.getLines(e,t)},this.getLength=function(){return this.doc.getLength()},this.getTextRange=function(e){return this.doc.getTextRange(e||this.selection.getRange())},this.insert=function(e,t){return this.doc.insert(e,t)},this.remove=function(e){return this.doc.remove(e)},this.removeFullLines=function(e,t){return this.doc.removeFullLines(e,t)},this.undoChanges=function(e,t){if(e.length){this.$fromUndo=!0;for(var n=e.length-1;-1!=n;n--){var i=e[n];"insert"==i.action||"remove"==i.action?this.doc.revertDelta(i):i.folds&&this.addFolds(i.folds)}!t&&this.$undoSelect&&(e.selectionBefore?this.selection.fromJSON(e.selectionBefore):this.selection.setRange(this.$getUndoSelection(e,!0))),this.$fromUndo=!1}},this.redoChanges=function(e,t){if(e.length){this.$fromUndo=!0;for(var n=0;n<e.length;n++){var i=e[n];"insert"!=i.action&&"remove"!=i.action||this.doc.applyDelta(i)}!t&&this.$undoSelect&&(e.selectionAfter?this.selection.fromJSON(e.selectionAfter):this.selection.setRange(this.$getUndoSelection(e,!1))),this.$fromUndo=!1}},this.setUndoSelect=function(e){this.$undoSelect=e},this.$getUndoSelection=function(e,t){function n(e){return t?"insert"!==e.action:"insert"===e.action}for(var i,r,s=0;s<e.length;s++){var o=e[s];o.start&&(i?n(o)?(r=o.start,-1==i.compare(r.row,r.column)&&i.setStart(r),r=o.end,1==i.compare(r.row,r.column)&&i.setEnd(r)):(r=o.start,-1==i.compare(r.row,r.column)&&(i=u.fromPoints(o.start,o.start))):i=n(o)?u.fromPoints(o.start,o.end):u.fromPoints(o.start,o.start))}return i},this.replace=function(e,t){return this.doc.replace(e,t)},this.moveText=function(e,t,n){var i=this.getTextRange(e),r=this.getFoldsInRange(e),s=u.fromPoints(t,t);if(!n){this.remove(e);var o=e.start.row-e.end.row;(c=o?-e.end.column:e.start.column-e.end.column)&&(s.start.row==e.end.row&&s.start.column>e.end.column&&(s.start.column+=c),s.end.row==e.end.row&&s.end.column>e.end.column&&(s.end.column+=c)),o&&s.start.row>=e.end.row&&(s.start.row+=o,s.end.row+=o)}if(s.end=this.insert(s.start,i),r.length){var a=e.start,l=s.start,c=(o=l.row-a.row,l.column-a.column);this.addFolds(r.map((function(e){return(e=e.clone()).start.row==a.row&&(e.start.column+=c),e.end.row==a.row&&(e.end.column+=c),e.start.row+=o,e.end.row+=o,e})))}return s},this.indentRows=function(e,t,n){n=n.replace(/\t/g,this.getTabString());for(var i=e;i<=t;i++)this.doc.insertInLine({row:i,column:0},n)},this.outdentRows=function(e){for(var t=e.collapseRows(),n=new u(0,0,0,0),i=this.getTabSize(),r=t.start.row;r<=t.end.row;++r){var s=this.getLine(r);n.start.row=r,n.end.row=r;for(var o=0;o<i&&" "==s.charAt(o);++o);o<i&&"\t"==s.charAt(o)?(n.start.column=o,n.end.column=o+1):(n.start.column=0,n.end.column=o),this.remove(n)}},this.$moveLines=function(e,t,n){if(e=this.getRowFoldStart(e),t=this.getRowFoldEnd(t),n<0){if((r=this.getRowFoldStart(e+n))<0)return 0;var i=r-e}else if(n>0){var r;if((r=this.getRowFoldEnd(t+n))>this.doc.getLength()-1)return 0;i=r-t}else e=this.$clipRowToDocument(e),i=(t=this.$clipRowToDocument(t))-e+1;var s=new u(e,0,t,Number.MAX_VALUE),o=this.getFoldsInRange(s).map((function(e){return(e=e.clone()).start.row+=i,e.end.row+=i,e})),a=0==n?this.doc.getLines(e,t):this.doc.removeFullLines(e,t);return this.doc.insertFullLines(e+i,a),o.length&&this.addFolds(o),i},this.moveLinesUp=function(e,t){return this.$moveLines(e,t,-1)},this.moveLinesDown=function(e,t){return this.$moveLines(e,t,1)},this.duplicateLines=function(e,t){return this.$moveLines(e,t,0)},this.$clipRowToDocument=function(e){return Math.max(0,Math.min(e,this.doc.getLength()-1))},this.$clipColumnToRow=function(e,t){return t<0?0:Math.min(this.doc.getLine(e).length,t)},this.$clipPositionToDocument=function(e,t){if(t=Math.max(0,t),e<0)e=0,t=0;else{var n=this.doc.getLength();e>=n?(e=n-1,t=this.doc.getLine(n-1).length):t=Math.min(this.doc.getLine(e).length,t)}return{row:e,column:t}},this.$clipRangeToDocument=function(e){e.start.row<0?(e.start.row=0,e.start.column=0):e.start.column=this.$clipColumnToRow(e.start.row,e.start.column);var t=this.doc.getLength()-1;return e.end.row>t?(e.end.row=t,e.end.column=this.doc.getLine(t).length):e.end.column=this.$clipColumnToRow(e.end.row,e.end.column),e},this.$wrapLimit=80,this.$useWrapMode=!1,this.$wrapLimitRange={min:null,max:null},this.setUseWrapMode=function(e){if(e!=this.$useWrapMode){if(this.$useWrapMode=e,this.$modified=!0,this.$resetRowCache(0),e){var t=this.getLength();this.$wrapData=Array(t),this.$updateWrapData(0,t-1)}this._signal("changeWrapMode")}},this.getUseWrapMode=function(){return this.$useWrapMode},this.setWrapLimitRange=function(e,t){this.$wrapLimitRange.min===e&&this.$wrapLimitRange.max===t||(this.$wrapLimitRange={min:e,max:t},this.$modified=!0,this.$bidiHandler.markAsDirty(),this.$useWrapMode&&this._signal("changeWrapMode"))},this.adjustWrapLimit=function(e,t){var n=this.$wrapLimitRange;n.max<0&&(n={min:t,max:t});var i=this.$constrainWrapLimit(e,n.min,n.max);return i!=this.$wrapLimit&&i>1&&(this.$wrapLimit=i,this.$modified=!0,this.$useWrapMode&&(this.$updateWrapData(0,this.getLength()-1),this.$resetRowCache(0),this._signal("changeWrapLimit")),!0)},this.$constrainWrapLimit=function(e,t,n){return t&&(e=Math.max(t,e)),n&&(e=Math.min(n,e)),e},this.getWrapLimit=function(){return this.$wrapLimit},this.setWrapLimit=function(e){this.setWrapLimitRange(e,e)},this.getWrapLimitRange=function(){return{min:this.$wrapLimitRange.min,max:this.$wrapLimitRange.max}},this.$updateInternalDataOnChange=function(e){var t=this.$useWrapMode,n=e.action,i=e.start,r=e.end,s=i.row,o=r.row,a=o-s,l=null;if(this.$updating=!0,0!=a)if("remove"===n){this[t?"$wrapData":"$rowLengthCache"].splice(s,a);var c=this.$foldData;l=this.getFoldsInRange(e),this.removeFolds(l);var u=0;if(g=this.getFoldLine(r.row)){g.addRemoveChars(r.row,r.column,i.column-r.column),g.shiftRow(-a);var h=this.getFoldLine(s);h&&h!==g&&(h.merge(g),g=h),u=c.indexOf(g)+1}for(;u<c.length;u++)(g=c[u]).start.row>=r.row&&g.shiftRow(-a);o=s}else{var d=Array(a);d.unshift(s,0);var m=t?this.$wrapData:this.$rowLengthCache;if(m.splice.apply(m,d),c=this.$foldData,u=0,g=this.getFoldLine(s)){var p=g.range.compareInside(i.row,i.column);0==p?(g=g.split(i.row,i.column))&&(g.shiftRow(a),g.addRemoveChars(o,0,r.column-i.column)):-1==p&&(g.addRemoveChars(s,0,r.column-i.column),g.shiftRow(a)),u=c.indexOf(g)+1}for(;u<c.length;u++){var g;(g=c[u]).start.row>=s&&g.shiftRow(a)}}else a=Math.abs(e.start.column-e.end.column),"remove"===n&&(l=this.getFoldsInRange(e),this.removeFolds(l),a=-a),(g=this.getFoldLine(s))&&g.addRemoveChars(s,i.column,a);return t&&this.$wrapData.length!=this.doc.getLength()&&console.error("doc.getLength() and $wrapData.length have to be the same!"),this.$updating=!1,t?this.$updateWrapData(s,o):this.$updateRowLengthCache(s,o),l},this.$updateRowLengthCache=function(e,t,n){this.$rowLengthCache[e]=null,this.$rowLengthCache[t]=null},this.$updateWrapData=function(n,i){var r,s,o=this.doc.getAllLines(),a=this.getTabSize(),l=this.$wrapData,c=this.$wrapLimit,u=n;for(i=Math.min(i,o.length-1);u<=i;)(s=this.getFoldLine(u,s))?(r=[],s.walk(function(n,i,s,a){var l;if(null!=n){(l=this.$getDisplayTokens(n,r.length))[0]=e;for(var c=1;c<l.length;c++)l[c]=t}else l=this.$getDisplayTokens(o[i].substring(a,s),r.length);r=r.concat(l)}.bind(this),s.end.row,o[s.end.row].length+1),l[s.start.row]=this.$computeWrapSplits(r,c,a),u=s.end.row+1):(r=this.$getDisplayTokens(o[u]),l[u]=this.$computeWrapSplits(r,c,a),u++)};var e=3,t=4;function n(e){return!(e<4352)&&(e>=4352&&e<=4447||e>=4515&&e<=4519||e>=4602&&e<=4607||e>=9001&&e<=9002||e>=11904&&e<=11929||e>=11931&&e<=12019||e>=12032&&e<=12245||e>=12272&&e<=12283||e>=12288&&e<=12350||e>=12353&&e<=12438||e>=12441&&e<=12543||e>=12549&&e<=12589||e>=12593&&e<=12686||e>=12688&&e<=12730||e>=12736&&e<=12771||e>=12784&&e<=12830||e>=12832&&e<=12871||e>=12880&&e<=13054||e>=13056&&e<=19903||e>=19968&&e<=42124||e>=42128&&e<=42182||e>=43360&&e<=43388||e>=44032&&e<=55203||e>=55216&&e<=55238||e>=55243&&e<=55291||e>=63744&&e<=64255||e>=65040&&e<=65049||e>=65072&&e<=65106||e>=65108&&e<=65126||e>=65128&&e<=65131||e>=65281&&e<=65376||e>=65504&&e<=65510)}this.$computeWrapSplits=function(n,i,r){if(0==n.length)return[];var s=[],o=n.length,a=0,l=0,c=this.$wrapAsCode,u=this.$indentedSoftWrap,h=i<=Math.max(2*r,8)||!1===u?0:Math.floor(i/2);function d(e){for(var t=e-a,i=a;i<e;i++){var o=n[i];12!==o&&2!==o||(t-=1)}s.length||(m=function(){var e=0;if(0===h)return e;if(u)for(var t=0;t<n.length;t++){var i=n[t];if(10==i)e+=1;else{if(11!=i){if(12==i)continue;break}e+=r}}return c&&!1!==u&&(e+=r),Math.min(e,h)}(),s.indent=m),l+=t,s.push(l),a=e}for(var m=0;o-a>i-m;){var p=a+i-m;if(n[p-1]>=10&&n[p]>=10)d(p);else if(n[p]!=e&&n[p]!=t){for(var g=Math.max(p-(i-(i>>2)),a-1);p>g&&n[p]<e;)p--;if(c){for(;p>g&&n[p]<e;)p--;for(;p>g&&9==n[p];)p--}else for(;p>g&&n[p]<10;)p--;p>g?d(++p):(2==n[p=a+i]&&p--,d(p-m))}else{for(;p!=a-1&&n[p]!=e;p--);if(p>a){d(p);continue}for(p=a+i;p<n.length&&n[p]==t;p++);if(p==n.length)break;d(p)}}return s},this.$getDisplayTokens=function(e,t){var i,r=[];t=t||0;for(var s=0;s<e.length;s++){var o=e.charCodeAt(s);if(9==o){i=this.getScreenTabSize(r.length+t),r.push(11);for(var a=1;a<i;a++)r.push(12)}else 32==o?r.push(10):o>39&&o<48||o>57&&o<64?r.push(9):o>=4352&&n(o)?r.push(1,2):r.push(1)}return r},this.$getStringScreenWidth=function(e,t,i){if(0==t)return[0,0];var r,s;for(null==t&&(t=1/0),i=i||0,s=0;s<e.length&&(9==(r=e.charCodeAt(s))?i+=this.getScreenTabSize(i):r>=4352&&n(r)?i+=2:i+=1,!(i>t));s++);return[i,s]},this.lineWidgets=null,this.getRowLength=function(e){if(this.lineWidgets)var t=this.lineWidgets[e]&&this.lineWidgets[e].rowCount||0;else t=0;return this.$useWrapMode&&this.$wrapData[e]?this.$wrapData[e].length+1+t:1+t},this.getRowLineCount=function(e){return this.$useWrapMode&&this.$wrapData[e]?this.$wrapData[e].length+1:1},this.getRowWrapIndent=function(e){if(this.$useWrapMode){var t=this.screenToDocumentPosition(e,Number.MAX_VALUE),n=this.$wrapData[t.row];return n.length&&n[0]<t.column?n.indent:0}return 0},this.getScreenLastRowColumn=function(e){var t=this.screenToDocumentPosition(e,Number.MAX_VALUE);return this.documentToScreenColumn(t.row,t.column)},this.getDocumentLastRowColumn=function(e,t){var n=this.documentToScreenRow(e,t);return this.getScreenLastRowColumn(n)},this.getDocumentLastRowColumnPosition=function(e,t){var n=this.documentToScreenRow(e,t);return this.screenToDocumentPosition(n,Number.MAX_VALUE/10)},this.getRowSplitData=function(e){return this.$useWrapMode?this.$wrapData[e]:void 0},this.getScreenTabSize=function(e){return this.$tabSize-(e%this.$tabSize|0)},this.screenToDocumentRow=function(e,t){return this.screenToDocumentPosition(e,t).row},this.screenToDocumentColumn=function(e,t){return this.screenToDocumentPosition(e,t).column},this.screenToDocumentPosition=function(e,t,n){if(e<0)return{row:0,column:0};var i,r,s=0,o=0,a=0,l=0,c=this.$screenRowCache,u=this.$getRowCacheIndex(c,e),h=c.length;if(h&&u>=0){a=c[u],s=this.$docRowCache[u];var d=e>c[h-1]}else d=!h;for(var m=this.getLength()-1,p=this.getNextFoldLine(s),g=p?p.start.row:1/0;a<=e&&!(a+(l=this.getRowLength(s))>e||s>=m);)a+=l,++s>g&&(s=p.end.row+1,g=(p=this.getNextFoldLine(s,p))?p.start.row:1/0),d&&(this.$docRowCache.push(s),this.$screenRowCache.push(a));if(p&&p.start.row<=s)i=this.getFoldDisplayLine(p),s=p.start.row;else{if(a+l<=e||s>m)return{row:m,column:this.getLine(m).length};i=this.getLine(s),p=null}var f=0,E=Math.floor(e-a);if(this.$useWrapMode){var v=this.$wrapData[s];v&&(r=v[E],E>0&&v.length&&(f=v.indent,o=v[E-1]||v[v.length-1],i=i.substring(o)))}return void 0!==n&&this.$bidiHandler.isBidiRow(a+E,s,E)&&(t=this.$bidiHandler.offsetToCol(n)),o+=this.$getStringScreenWidth(i,t-f)[1],this.$useWrapMode&&o>=r&&(o=r-1),p?p.idxToPosition(o):{row:s,column:o}},this.documentToScreenPosition=function(e,t){if(void 0===t)var n=this.$clipPositionToDocument(e.row,e.column);else n=this.$clipPositionToDocument(e,t);e=n.row,t=n.column;var i,r=0,s=null;(i=this.getFoldAt(e,t,1))&&(e=i.start.row,t=i.start.column);var o,a=0,l=this.$docRowCache,c=this.$getRowCacheIndex(l,e),u=l.length;if(u&&c>=0){a=l[c],r=this.$screenRowCache[c];var h=e>l[u-1]}else h=!u;for(var d=this.getNextFoldLine(a),m=d?d.start.row:1/0;a<e;){if(a>=m){if((o=d.end.row+1)>e)break;m=(d=this.getNextFoldLine(o,d))?d.start.row:1/0}else o=a+1;r+=this.getRowLength(a),a=o,h&&(this.$docRowCache.push(a),this.$screenRowCache.push(r))}var p="";d&&a>=m?(p=this.getFoldDisplayLine(d,e,t),s=d.start.row):(p=this.getLine(e).substring(0,t),s=e);var g=0;if(this.$useWrapMode){var f=this.$wrapData[s];if(f){for(var E=0;p.length>=f[E];)r++,E++;p=p.substring(f[E-1]||0,p.length),g=E>0?f.indent:0}}return{row:r,column:g+this.$getStringScreenWidth(p)[0]}},this.documentToScreenColumn=function(e,t){return this.documentToScreenPosition(e,t).column},this.documentToScreenRow=function(e,t){return this.documentToScreenPosition(e,t).row},this.getScreenLength=function(){var e=0,t=null;if(this.$useWrapMode)for(var n=this.$wrapData.length,i=0,r=(a=0,(t=this.$foldData[a++])?t.start.row:1/0);i<n;){var s=this.$wrapData[i];e+=s?s.length+1:1,++i>r&&(i=t.end.row+1,r=(t=this.$foldData[a++])?t.start.row:1/0)}else{e=this.getLength();for(var o=this.$foldData,a=0;a<o.length;a++)e-=(t=o[a]).end.row-t.start.row}return this.lineWidgets&&(e+=this.$getWidgetScreenLength()),e},this.$setFontMetrics=function(e){this.$enableVarChar&&(this.$getStringScreenWidth=function(t,n,i){if(0===n)return[0,0];var r,s;for(n||(n=1/0),i=i||0,s=0;s<t.length&&!((i+="\t"===(r=t.charAt(s))?this.getScreenTabSize(i):e.getCharacterWidth(r))>n);s++);return[i,s]})},this.destroy=function(){this.bgTokenizer&&(this.bgTokenizer.setDocument(null),this.bgTokenizer=null),this.$stopWorker()},this.isFullWidth=n}.call(p.prototype),e("./edit_session/folding").Folding.call(p.prototype),e("./edit_session/bracket_match").BracketMatch.call(p.prototype),o.defineOptions(p.prototype,"session",{wrap:{set:function(e){if(e&&"off"!=e?"free"==e?e=!0:"printMargin"==e?e=-1:"string"==typeof e&&(e=parseInt(e,10)||!1):e=!1,this.$wrap!=e)if(this.$wrap=e,e){var t="number"==typeof e?e:null;this.setWrapLimitRange(t,t),this.setUseWrapMode(!0)}else this.setUseWrapMode(!1)},get:function(){return this.getUseWrapMode()?-1==this.$wrap?"printMargin":this.getWrapLimitRange().min?this.$wrap:"free":"off"},handlesSet:!0},wrapMethod:{set:function(e){(e="auto"==e?"text"!=this.$mode.type:"text"!=e)!=this.$wrapAsCode&&(this.$wrapAsCode=e,this.$useWrapMode&&(this.$useWrapMode=!1,this.setUseWrapMode(!0)))},initialValue:"auto"},indentedSoftWrap:{set:function(){this.$useWrapMode&&(this.$useWrapMode=!1,this.setUseWrapMode(!0))},initialValue:!0},firstLineNumber:{set:function(){this._signal("changeBreakpoint")},initialValue:1},useWorker:{set:function(e){this.$useWorker=e,this.$stopWorker(),e&&this.$startWorker()},initialValue:!0},useSoftTabs:{initialValue:!0},tabSize:{set:function(e){(e=parseInt(e))>0&&this.$tabSize!==e&&(this.$modified=!0,this.$rowLengthCache=[],this.$tabSize=e,this._signal("changeTabSize"))},initialValue:4,handlesSet:!0},navigateWithinSoftTabs:{initialValue:!1},foldStyle:{set:function(e){this.setFoldStyle(e)},handlesSet:!0},overwrite:{set:function(e){this._signal("changeOverwrite")},initialValue:!1},newLineMode:{set:function(e){this.doc.setNewLineMode(e)},get:function(){return this.doc.getNewLineMode()},handlesSet:!0},mode:{set:function(e){this.setMode(e)},get:function(){return this.$modeId},handlesSet:!0}}),t.EditSession=p})),ace.define("ace/search",["require","exports","module","ace/lib/lang","ace/lib/oop","ace/range"],(function(e,t,n){"use strict";var i=e("./lib/lang"),r=e("./lib/oop"),s=e("./range").Range,o=function(){this.$options={}};(function(){this.set=function(e){return r.mixin(this.$options,e),this},this.getOptions=function(){return i.copyObject(this.$options)},this.setOptions=function(e){this.$options=e},this.find=function(e){var t=this.$options,n=this.$matchIterator(e,t);if(!n)return!1;var i=null;return n.forEach((function(e,n,r,o){return i=new s(e,n,r,o),!(n==o&&t.start&&t.start.start&&0!=t.skipCurrent&&i.isEqual(t.start)&&(i=null,1))})),i},this.findAll=function(e){var t=this.$options;if(!t.needle)return[];this.$assembleRegExp(t);var n=t.range,r=n?e.getLines(n.start.row,n.end.row):e.doc.getAllLines(),o=[],a=t.re;if(t.$isMultiLine){var l,c=a.length,u=r.length-c;e:for(var h=a.offset||0;h<=u;h++){for(var d=0;d<c;d++)if(-1==r[h+d].search(a[d]))continue e;var m=r[h],p=r[h+c-1],g=m.length-m.match(a[0])[0].length,f=p.match(a[c-1])[0].length;l&&l.end.row===h&&l.end.column>g||(o.push(l=new s(h,g,h+c-1,f)),c>2&&(h=h+c-2))}}else for(var E=0;E<r.length;E++){var v=i.getMatchOffsets(r[E],a);for(d=0;d<v.length;d++){var _=v[d];o.push(new s(E,_.offset,E,_.offset+_.length))}}if(n){var C=n.start.column,A=n.start.column;for(E=0,d=o.length-1;E<d&&o[E].start.column<C&&o[E].start.row==n.start.row;)E++;for(;E<d&&o[d].end.column>A&&o[d].end.row==n.end.row;)d--;for(o=o.slice(E,d+1),E=0,d=o.length;E<d;E++)o[E].start.row+=n.start.row,o[E].end.row+=n.start.row}return o},this.replace=function(e,t){var n=this.$options,i=this.$assembleRegExp(n);if(n.$isMultiLine)return t;if(i){var r=i.exec(e);if(!r||r[0].length!=e.length)return null;if(t=e.replace(i,t),n.preserveCase){t=t.split("");for(var s=Math.min(e.length,e.length);s--;){var o=e[s];o&&o.toLowerCase()!=o?t[s]=t[s].toUpperCase():t[s]=t[s].toLowerCase()}t=t.join("")}return t}},this.$assembleRegExp=function(e,t){if(e.needle instanceof RegExp)return e.re=e.needle;var n=e.needle;if(!e.needle)return e.re=!1;e.regExp||(n=i.escapeRegExp(n)),e.wholeWord&&(n=function(e,t){function n(e){return/\w/.test(e)||t.regExp?"\\b":""}return n(e[0])+e+n(e[e.length-1])}(n,e));var r=e.caseSensitive?"gm":"gmi";if(e.$isMultiLine=!t&&/[\n\r]/.test(n),e.$isMultiLine)return e.re=this.$assembleMultilineRegExp(n,r);try{var s=new RegExp(n,r)}catch(e){s=!1}return e.re=s},this.$assembleMultilineRegExp=function(e,t){for(var n=e.replace(/\r\n|\r|\n/g,"$\n^").split("\n"),i=[],r=0;r<n.length;r++)try{i.push(new RegExp(n[r],t))}catch(e){return!1}return i},this.$matchIterator=function(e,t){var n=this.$assembleRegExp(t);if(!n)return!1;var i=1==t.backwards,r=0!=t.skipCurrent,s=t.range,o=t.start;o||(o=s?s[i?"end":"start"]:e.selection.getRange()),o.start&&(o=o[r!=i?"end":"start"]);var a=s?s.start.row:0,l=s?s.end.row:e.getLength()-1;if(i)var c=function(e){var n=o.row;if(!h(n,o.column,e)){for(n--;n>=a;n--)if(h(n,Number.MAX_VALUE,e))return;if(0!=t.wrap)for(n=l,a=o.row;n>=a;n--)if(h(n,Number.MAX_VALUE,e))return}};else c=function(e){var n=o.row;if(!h(n,o.column,e)){for(n+=1;n<=l;n++)if(h(n,0,e))return;if(0!=t.wrap)for(n=a,l=o.row;n<=l;n++)if(h(n,0,e))return}};if(t.$isMultiLine)var u=n.length,h=function(t,r,s){var o=i?t-u+1:t;if(!(o<0)){var a=e.getLine(o),l=a.search(n[0]);if(!(!i&&l<r||-1===l)){for(var c=1;c<u;c++)if(-1==(a=e.getLine(o+c)).search(n[c]))return;var h=a.match(n[u-1])[0].length;if(!(i&&h>r))return!!s(o,l,o+u-1,h)||void 0}}};else h=i?function(t,i,r){var s,o=e.getLine(t),a=[],l=0;for(n.lastIndex=0;s=n.exec(o);){var c=s[0].length;if(l=s.index,!c){if(l>=o.length)break;n.lastIndex=l+=1}if(s.index+c>i)break;a.push(s.index,c)}for(var u=a.length-1;u>=0;u-=2){var h=a[u-1];if(r(t,h,t,h+(c=a[u])))return!0}}:function(t,i,r){var s,o,a=e.getLine(t);for(n.lastIndex=i;o=n.exec(a);){var l=o[0].length;if(r(t,s=o.index,t,s+l))return!0;if(!l&&(n.lastIndex=s+=1,s>=a.length))return!1}};return{forEach:c}}}).call(o.prototype),t.Search=o})),ace.define("ace/keyboard/hash_handler",["require","exports","module","ace/lib/keys","ace/lib/useragent"],(function(e,t,n){"use strict";var i=e("../lib/keys"),r=e("../lib/useragent"),s=i.KEY_MODS;function o(e,t){this.platform=t||(r.isMac?"mac":"win"),this.commands={},this.commandKeyBinding={},this.addCommands(e),this.$singleCommand=!0}function a(e,t){o.call(this,e,t),this.$singleCommand=!1}a.prototype=o.prototype,function(){function e(e){return"object"==typeof e&&e.bindKey&&e.bindKey.position||(e.isDefault?-100:0)}this.addCommand=function(e){this.commands[e.name]&&this.removeCommand(e),this.commands[e.name]=e,e.bindKey&&this._buildKeyHash(e)},this.removeCommand=function(e,t){var n=e&&("string"==typeof e?e:e.name);e=this.commands[n],t||delete this.commands[n];var i=this.commandKeyBinding;for(var r in i){var s=i[r];if(s==e)delete i[r];else if(Array.isArray(s)){var o=s.indexOf(e);-1!=o&&(s.splice(o,1),1==s.length&&(i[r]=s[0]))}}},this.bindKey=function(e,t,n){if("object"==typeof e&&e&&(null==n&&(n=e.position),e=e[this.platform]),e)return"function"==typeof t?this.addCommand({exec:t,bindKey:e,name:t.name||e}):void e.split("|").forEach((function(e){var i="";if(-1!=e.indexOf(" ")){var r=e.split(/\s+/);e=r.pop(),r.forEach((function(e){var t=this.parseKeys(e),n=s[t.hashId]+t.key;i+=(i?" ":"")+n,this._addCommandToBinding(i,"chainKeys")}),this),i+=" "}var o=this.parseKeys(e),a=s[o.hashId]+o.key;this._addCommandToBinding(i+a,t,n)}),this)},this._addCommandToBinding=function(t,n,i){var r,s=this.commandKeyBinding;if(n)if(!s[t]||this.$singleCommand)s[t]=n;else{Array.isArray(s[t])?-1!=(r=s[t].indexOf(n))&&s[t].splice(r,1):s[t]=[s[t]],"number"!=typeof i&&(i=e(n));var o=s[t];for(r=0;r<o.length&&!(e(o[r])>i);r++);o.splice(r,0,n)}else delete s[t]},this.addCommands=function(e){e&&Object.keys(e).forEach((function(t){var n=e[t];if(n){if("string"==typeof n)return this.bindKey(n,t);"function"==typeof n&&(n={exec:n}),"object"==typeof n&&(n.name||(n.name=t),this.addCommand(n))}}),this)},this.removeCommands=function(e){Object.keys(e).forEach((function(t){this.removeCommand(e[t])}),this)},this.bindKeys=function(e){Object.keys(e).forEach((function(t){this.bindKey(t,e[t])}),this)},this._buildKeyHash=function(e){this.bindKey(e.bindKey,e)},this.parseKeys=function(e){var t=e.toLowerCase().split(/[\-\+]([\-\+])?/).filter((function(e){return e})),n=t.pop(),r=i[n];if(i.FUNCTION_KEYS[r])n=i.FUNCTION_KEYS[r].toLowerCase();else{if(!t.length)return{key:n,hashId:-1};if(1==t.length&&"shift"==t[0])return{key:n.toUpperCase(),hashId:-1}}for(var s=0,o=t.length;o--;){var a=i.KEY_MODS[t[o]];if(null==a)return"undefined"!=typeof console&&console.error("invalid modifier "+t[o]+" in "+e),!1;s|=a}return{key:n,hashId:s}},this.findKeyCommand=function(e,t){var n=s[e]+t;return this.commandKeyBinding[n]},this.handleKeyboard=function(e,t,n,i){if(!(i<0)){var r=s[t]+n,o=this.commandKeyBinding[r];return e.$keyChain&&(e.$keyChain+=" "+r,o=this.commandKeyBinding[e.$keyChain]||o),!o||"chainKeys"!=o&&"chainKeys"!=o[o.length-1]?(e.$keyChain&&(t&&4!=t||1!=n.length?(-1==t||i>0)&&(e.$keyChain=""):e.$keyChain=e.$keyChain.slice(0,-r.length-1)),{command:o}):(e.$keyChain=e.$keyChain||r,{command:"null"})}},this.getStatusText=function(e,t){return t.$keyChain||""}}.call(o.prototype),t.HashHandler=o,t.MultiHashHandler=a})),ace.define("ace/commands/command_manager",["require","exports","module","ace/lib/oop","ace/keyboard/hash_handler","ace/lib/event_emitter"],(function(e,t,n){"use strict";var i=e("../lib/oop"),r=e("../keyboard/hash_handler").MultiHashHandler,s=e("../lib/event_emitter").EventEmitter,o=function(e,t){r.call(this,t,e),this.byName=this.commands,this.setDefaultHandler("exec",(function(e){return e.command.exec(e.editor,e.args||{})}))};i.inherits(o,r),function(){i.implement(this,s),this.exec=function(e,t,n){if(Array.isArray(e)){for(var i=e.length;i--;)if(this.exec(e[i],t,n))return!0;return!1}if("string"==typeof e&&(e=this.commands[e]),!e)return!1;if(t&&t.$readOnly&&!e.readOnly)return!1;if(0!=this.$checkCommandState&&e.isAvailable&&!e.isAvailable(t))return!1;var r={editor:t,command:e,args:n};return r.returnValue=this._emit("exec",r),this._signal("afterExec",r),!1!==r.returnValue},this.toggleRecording=function(e){if(!this.$inReplay)return e&&e._emit("changeStatus"),this.recording?(this.macro.pop(),this.removeEventListener("exec",this.$addCommandToMacro),this.macro.length||(this.macro=this.oldMacro),this.recording=!1):(this.$addCommandToMacro||(this.$addCommandToMacro=function(e){this.macro.push([e.command,e.args])}.bind(this)),this.oldMacro=this.macro,this.macro=[],this.on("exec",this.$addCommandToMacro),this.recording=!0)},this.replay=function(e){if(!this.$inReplay&&this.macro){if(this.recording)return this.toggleRecording(e);try{this.$inReplay=!0,this.macro.forEach((function(t){"string"==typeof t?this.exec(t,e):this.exec(t[0],e,t[1])}),this)}finally{this.$inReplay=!1}}},this.trimMacro=function(e){return e.map((function(e){return"string"!=typeof e[0]&&(e[0]=e[0].name),e[1]||(e=e[0]),e}))}}.call(o.prototype),t.CommandManager=o})),ace.define("ace/commands/default_commands",["require","exports","module","ace/lib/lang","ace/config","ace/range"],(function(e,t,n){"use strict";var i=e("../lib/lang"),r=e("../config"),s=e("../range").Range;function o(e,t){return{win:e,mac:t}}t.commands=[{name:"showSettingsMenu",bindKey:o("Ctrl-,","Command-,"),exec:function(e){r.loadModule("ace/ext/settings_menu",(function(t){t.init(e),e.showSettingsMenu()}))},readOnly:!0},{name:"goToNextError",bindKey:o("Alt-E","F4"),exec:function(e){r.loadModule("./ext/error_marker",(function(t){t.showErrorMarker(e,1)}))},scrollIntoView:"animate",readOnly:!0},{name:"goToPreviousError",bindKey:o("Alt-Shift-E","Shift-F4"),exec:function(e){r.loadModule("./ext/error_marker",(function(t){t.showErrorMarker(e,-1)}))},scrollIntoView:"animate",readOnly:!0},{name:"selectall",description:"Select all",bindKey:o("Ctrl-A","Command-A"),exec:function(e){e.selectAll()},readOnly:!0},{name:"centerselection",description:"Center selection",bindKey:o(null,"Ctrl-L"),exec:function(e){e.centerSelection()},readOnly:!0},{name:"gotoline",description:"Go to line...",bindKey:o("Ctrl-L","Command-L"),exec:function(e,t){"number"!=typeof t||isNaN(t)||e.gotoLine(t),e.prompt({$type:"gotoLine"})},readOnly:!0},{name:"fold",bindKey:o("Alt-L|Ctrl-F1","Command-Alt-L|Command-F1"),exec:function(e){e.session.toggleFold(!1)},multiSelectAction:"forEach",scrollIntoView:"center",readOnly:!0},{name:"unfold",bindKey:o("Alt-Shift-L|Ctrl-Shift-F1","Command-Alt-Shift-L|Command-Shift-F1"),exec:function(e){e.session.toggleFold(!0)},multiSelectAction:"forEach",scrollIntoView:"center",readOnly:!0},{name:"toggleFoldWidget",bindKey:o("F2","F2"),exec:function(e){e.session.toggleFoldWidget()},multiSelectAction:"forEach",scrollIntoView:"center",readOnly:!0},{name:"toggleParentFoldWidget",bindKey:o("Alt-F2","Alt-F2"),exec:function(e){e.session.toggleFoldWidget(!0)},multiSelectAction:"forEach",scrollIntoView:"center",readOnly:!0},{name:"foldall",description:"Fold all",bindKey:o(null,"Ctrl-Command-Option-0"),exec:function(e){e.session.foldAll()},scrollIntoView:"center",readOnly:!0},{name:"foldOther",description:"Fold other",bindKey:o("Alt-0","Command-Option-0"),exec:function(e){e.session.foldAll(),e.session.unfold(e.selection.getAllRanges())},scrollIntoView:"center",readOnly:!0},{name:"unfoldall",description:"Unfold all",bindKey:o("Alt-Shift-0","Command-Option-Shift-0"),exec:function(e){e.session.unfold()},scrollIntoView:"center",readOnly:!0},{name:"findnext",description:"Find next",bindKey:o("Ctrl-K","Command-G"),exec:function(e){e.findNext()},multiSelectAction:"forEach",scrollIntoView:"center",readOnly:!0},{name:"findprevious",description:"Find previous",bindKey:o("Ctrl-Shift-K","Command-Shift-G"),exec:function(e){e.findPrevious()},multiSelectAction:"forEach",scrollIntoView:"center",readOnly:!0},{name:"selectOrFindNext",description:"Select or find next",bindKey:o("Alt-K","Ctrl-G"),exec:function(e){e.selection.isEmpty()?e.selection.selectWord():e.findNext()},readOnly:!0},{name:"selectOrFindPrevious",description:"Select or find previous",bindKey:o("Alt-Shift-K","Ctrl-Shift-G"),exec:function(e){e.selection.isEmpty()?e.selection.selectWord():e.findPrevious()},readOnly:!0},{name:"find",description:"Find",bindKey:o("Ctrl-F","Command-F"),exec:function(e){r.loadModule("ace/ext/searchbox",(function(t){t.Search(e)}))},readOnly:!0},{name:"overwrite",description:"Overwrite",bindKey:"Insert",exec:function(e){e.toggleOverwrite()},readOnly:!0},{name:"selecttostart",description:"Select to start",bindKey:o("Ctrl-Shift-Home","Command-Shift-Home|Command-Shift-Up"),exec:function(e){e.getSelection().selectFileStart()},multiSelectAction:"forEach",readOnly:!0,scrollIntoView:"animate",aceCommandGroup:"fileJump"},{name:"gotostart",description:"Go to start",bindKey:o("Ctrl-Home","Command-Home|Command-Up"),exec:function(e){e.navigateFileStart()},multiSelectAction:"forEach",readOnly:!0,scrollIntoView:"animate",aceCommandGroup:"fileJump"},{name:"selectup",description:"Select up",bindKey:o("Shift-Up","Shift-Up|Ctrl-Shift-P"),exec:function(e){e.getSelection().selectUp()},multiSelectAction:"forEach",scrollIntoView:"cursor",readOnly:!0},{name:"golineup",description:"Go line up",bindKey:o("Up","Up|Ctrl-P"),exec:function(e,t){e.navigateUp(t.times)},multiSelectAction:"forEach",scrollIntoView:"cursor",readOnly:!0},{name:"selecttoend",description:"Select to end",bindKey:o("Ctrl-Shift-End","Command-Shift-End|Command-Shift-Down"),exec:function(e){e.getSelection().selectFileEnd()},multiSelectAction:"forEach",readOnly:!0,scrollIntoView:"animate",aceCommandGroup:"fileJump"},{name:"gotoend",description:"Go to end",bindKey:o("Ctrl-End","Command-End|Command-Down"),exec:function(e){e.navigateFileEnd()},multiSelectAction:"forEach",readOnly:!0,scrollIntoView:"animate",aceCommandGroup:"fileJump"},{name:"selectdown",description:"Select down",bindKey:o("Shift-Down","Shift-Down|Ctrl-Shift-N"),exec:function(e){e.getSelection().selectDown()},multiSelectAction:"forEach",scrollIntoView:"cursor",readOnly:!0},{name:"golinedown",description:"Go line down",bindKey:o("Down","Down|Ctrl-N"),exec:function(e,t){e.navigateDown(t.times)},multiSelectAction:"forEach",scrollIntoView:"cursor",readOnly:!0},{name:"selectwordleft",description:"Select word left",bindKey:o("Ctrl-Shift-Left","Option-Shift-Left"),exec:function(e){e.getSelection().selectWordLeft()},multiSelectAction:"forEach",scrollIntoView:"cursor",readOnly:!0},{name:"gotowordleft",description:"Go to word left",bindKey:o("Ctrl-Left","Option-Left"),exec:function(e){e.navigateWordLeft()},multiSelectAction:"forEach",scrollIntoView:"cursor",readOnly:!0},{name:"selecttolinestart",description:"Select to line start",bindKey:o("Alt-Shift-Left","Command-Shift-Left|Ctrl-Shift-A"),exec:function(e){e.getSelection().selectLineStart()},multiSelectAction:"forEach",scrollIntoView:"cursor",readOnly:!0},{name:"gotolinestart",description:"Go to line start",bindKey:o("Alt-Left|Home","Command-Left|Home|Ctrl-A"),exec:function(e){e.navigateLineStart()},multiSelectAction:"forEach",scrollIntoView:"cursor",readOnly:!0},{name:"selectleft",description:"Select left",bindKey:o("Shift-Left","Shift-Left|Ctrl-Shift-B"),exec:function(e){e.getSelection().selectLeft()},multiSelectAction:"forEach",scrollIntoView:"cursor",readOnly:!0},{name:"gotoleft",description:"Go to left",bindKey:o("Left","Left|Ctrl-B"),exec:function(e,t){e.navigateLeft(t.times)},multiSelectAction:"forEach",scrollIntoView:"cursor",readOnly:!0},{name:"selectwordright",description:"Select word right",bindKey:o("Ctrl-Shift-Right","Option-Shift-Right"),exec:function(e){e.getSelection().selectWordRight()},multiSelectAction:"forEach",scrollIntoView:"cursor",readOnly:!0},{name:"gotowordright",description:"Go to word right",bindKey:o("Ctrl-Right","Option-Right"),exec:function(e){e.navigateWordRight()},multiSelectAction:"forEach",scrollIntoView:"cursor",readOnly:!0},{name:"selecttolineend",description:"Select to line end",bindKey:o("Alt-Shift-Right","Command-Shift-Right|Shift-End|Ctrl-Shift-E"),exec:function(e){e.getSelection().selectLineEnd()},multiSelectAction:"forEach",scrollIntoView:"cursor",readOnly:!0},{name:"gotolineend",description:"Go to line end",bindKey:o("Alt-Right|End","Command-Right|End|Ctrl-E"),exec:function(e){e.navigateLineEnd()},multiSelectAction:"forEach",scrollIntoView:"cursor",readOnly:!0},{name:"selectright",description:"Select right",bindKey:o("Shift-Right","Shift-Right"),exec:function(e){e.getSelection().selectRight()},multiSelectAction:"forEach",scrollIntoView:"cursor",readOnly:!0},{name:"gotoright",description:"Go to right",bindKey:o("Right","Right|Ctrl-F"),exec:function(e,t){e.navigateRight(t.times)},multiSelectAction:"forEach",scrollIntoView:"cursor",readOnly:!0},{name:"selectpagedown",description:"Select page down",bindKey:"Shift-PageDown",exec:function(e){e.selectPageDown()},readOnly:!0},{name:"pagedown",description:"Page down",bindKey:o(null,"Option-PageDown"),exec:function(e){e.scrollPageDown()},readOnly:!0},{name:"gotopagedown",description:"Go to page down",bindKey:o("PageDown","PageDown|Ctrl-V"),exec:function(e){e.gotoPageDown()},readOnly:!0},{name:"selectpageup",description:"Select page up",bindKey:"Shift-PageUp",exec:function(e){e.selectPageUp()},readOnly:!0},{name:"pageup",description:"Page up",bindKey:o(null,"Option-PageUp"),exec:function(e){e.scrollPageUp()},readOnly:!0},{name:"gotopageup",description:"Go to page up",bindKey:"PageUp",exec:function(e){e.gotoPageUp()},readOnly:!0},{name:"scrollup",description:"Scroll up",bindKey:o("Ctrl-Up",null),exec:function(e){e.renderer.scrollBy(0,-2*e.renderer.layerConfig.lineHeight)},readOnly:!0},{name:"scrolldown",description:"Scroll down",bindKey:o("Ctrl-Down",null),exec:function(e){e.renderer.scrollBy(0,2*e.renderer.layerConfig.lineHeight)},readOnly:!0},{name:"selectlinestart",description:"Select line start",bindKey:"Shift-Home",exec:function(e){e.getSelection().selectLineStart()},multiSelectAction:"forEach",scrollIntoView:"cursor",readOnly:!0},{name:"selectlineend",description:"Select line end",bindKey:"Shift-End",exec:function(e){e.getSelection().selectLineEnd()},multiSelectAction:"forEach",scrollIntoView:"cursor",readOnly:!0},{name:"togglerecording",description:"Toggle recording",bindKey:o("Ctrl-Alt-E","Command-Option-E"),exec:function(e){e.commands.toggleRecording(e)},readOnly:!0},{name:"replaymacro",description:"Replay macro",bindKey:o("Ctrl-Shift-E","Command-Shift-E"),exec:function(e){e.commands.replay(e)},readOnly:!0},{name:"jumptomatching",description:"Jump to matching",bindKey:o("Ctrl-\\|Ctrl-P","Command-\\"),exec:function(e){e.jumpToMatching()},multiSelectAction:"forEach",scrollIntoView:"animate",readOnly:!0},{name:"selecttomatching",description:"Select to matching",bindKey:o("Ctrl-Shift-\\|Ctrl-Shift-P","Command-Shift-\\"),exec:function(e){e.jumpToMatching(!0)},multiSelectAction:"forEach",scrollIntoView:"animate",readOnly:!0},{name:"expandToMatching",description:"Expand to matching",bindKey:o("Ctrl-Shift-M","Ctrl-Shift-M"),exec:function(e){e.jumpToMatching(!0,!0)},multiSelectAction:"forEach",scrollIntoView:"animate",readOnly:!0},{name:"passKeysToBrowser",description:"Pass keys to browser",bindKey:o(null,null),exec:function(){},passEvent:!0,readOnly:!0},{name:"copy",description:"Copy",exec:function(e){},readOnly:!0},{name:"cut",description:"Cut",exec:function(e){var t=e.$copyWithEmptySelection&&e.selection.isEmpty()?e.selection.getLineRange():e.selection.getRange();e._emit("cut",t),t.isEmpty()||e.session.remove(t),e.clearSelection()},scrollIntoView:"cursor",multiSelectAction:"forEach"},{name:"paste",description:"Paste",exec:function(e,t){e.$handlePaste(t)},scrollIntoView:"cursor"},{name:"removeline",description:"Remove line",bindKey:o("Ctrl-D","Command-D"),exec:function(e){e.removeLines()},scrollIntoView:"cursor",multiSelectAction:"forEachLine"},{name:"duplicateSelection",description:"Duplicate selection",bindKey:o("Ctrl-Shift-D","Command-Shift-D"),exec:function(e){e.duplicateSelection()},scrollIntoView:"cursor",multiSelectAction:"forEach"},{name:"sortlines",description:"Sort lines",bindKey:o("Ctrl-Alt-S","Command-Alt-S"),exec:function(e){e.sortLines()},scrollIntoView:"selection",multiSelectAction:"forEachLine"},{name:"togglecomment",description:"Toggle comment",bindKey:o("Ctrl-/","Command-/"),exec:function(e){e.toggleCommentLines()},multiSelectAction:"forEachLine",scrollIntoView:"selectionPart"},{name:"toggleBlockComment",description:"Toggle block comment",bindKey:o("Ctrl-Shift-/","Command-Shift-/"),exec:function(e){e.toggleBlockComment()},multiSelectAction:"forEach",scrollIntoView:"selectionPart"},{name:"modifyNumberUp",description:"Modify number up",bindKey:o("Ctrl-Shift-Up","Alt-Shift-Up"),exec:function(e){e.modifyNumber(1)},scrollIntoView:"cursor",multiSelectAction:"forEach"},{name:"modifyNumberDown",description:"Modify number down",bindKey:o("Ctrl-Shift-Down","Alt-Shift-Down"),exec:function(e){e.modifyNumber(-1)},scrollIntoView:"cursor",multiSelectAction:"forEach"},{name:"replace",description:"Replace",bindKey:o("Ctrl-H","Command-Option-F"),exec:function(e){r.loadModule("ace/ext/searchbox",(function(t){t.Search(e,!0)}))}},{name:"undo",description:"Undo",bindKey:o("Ctrl-Z","Command-Z"),exec:function(e){e.undo()}},{name:"redo",description:"Redo",bindKey:o("Ctrl-Shift-Z|Ctrl-Y","Command-Shift-Z|Command-Y"),exec:function(e){e.redo()}},{name:"copylinesup",description:"Copy lines up",bindKey:o("Alt-Shift-Up","Command-Option-Up"),exec:function(e){e.copyLinesUp()},scrollIntoView:"cursor"},{name:"movelinesup",description:"Move lines up",bindKey:o("Alt-Up","Option-Up"),exec:function(e){e.moveLinesUp()},scrollIntoView:"cursor"},{name:"copylinesdown",description:"Copy lines down",bindKey:o("Alt-Shift-Down","Command-Option-Down"),exec:function(e){e.copyLinesDown()},scrollIntoView:"cursor"},{name:"movelinesdown",description:"Move lines down",bindKey:o("Alt-Down","Option-Down"),exec:function(e){e.moveLinesDown()},scrollIntoView:"cursor"},{name:"del",description:"Delete",bindKey:o("Delete","Delete|Ctrl-D|Shift-Delete"),exec:function(e){e.remove("right")},multiSelectAction:"forEach",scrollIntoView:"cursor"},{name:"backspace",description:"Backspace",bindKey:o("Shift-Backspace|Backspace","Ctrl-Backspace|Shift-Backspace|Backspace|Ctrl-H"),exec:function(e){e.remove("left")},multiSelectAction:"forEach",scrollIntoView:"cursor"},{name:"cut_or_delete",description:"Cut or delete",bindKey:o("Shift-Delete",null),exec:function(e){if(!e.selection.isEmpty())return!1;e.remove("left")},multiSelectAction:"forEach",scrollIntoView:"cursor"},{name:"removetolinestart",description:"Remove to line start",bindKey:o("Alt-Backspace","Command-Backspace"),exec:function(e){e.removeToLineStart()},multiSelectAction:"forEach",scrollIntoView:"cursor"},{name:"removetolineend",description:"Remove to line end",bindKey:o("Alt-Delete","Ctrl-K|Command-Delete"),exec:function(e){e.removeToLineEnd()},multiSelectAction:"forEach",scrollIntoView:"cursor"},{name:"removetolinestarthard",description:"Remove to line start hard",bindKey:o("Ctrl-Shift-Backspace",null),exec:function(e){var t=e.selection.getRange();t.start.column=0,e.session.remove(t)},multiSelectAction:"forEach",scrollIntoView:"cursor"},{name:"removetolineendhard",description:"Remove to line end hard",bindKey:o("Ctrl-Shift-Delete",null),exec:function(e){var t=e.selection.getRange();t.end.column=Number.MAX_VALUE,e.session.remove(t)},multiSelectAction:"forEach",scrollIntoView:"cursor"},{name:"removewordleft",description:"Remove word left",bindKey:o("Ctrl-Backspace","Alt-Backspace|Ctrl-Alt-Backspace"),exec:function(e){e.removeWordLeft()},multiSelectAction:"forEach",scrollIntoView:"cursor"},{name:"removewordright",description:"Remove word right",bindKey:o("Ctrl-Delete","Alt-Delete"),exec:function(e){e.removeWordRight()},multiSelectAction:"forEach",scrollIntoView:"cursor"},{name:"outdent",description:"Outdent",bindKey:o("Shift-Tab","Shift-Tab"),exec:function(e){e.blockOutdent()},multiSelectAction:"forEach",scrollIntoView:"selectionPart"},{name:"indent",description:"Indent",bindKey:o("Tab","Tab"),exec:function(e){e.indent()},multiSelectAction:"forEach",scrollIntoView:"selectionPart"},{name:"blockoutdent",description:"Block outdent",bindKey:o("Ctrl-[","Ctrl-["),exec:function(e){e.blockOutdent()},multiSelectAction:"forEachLine",scrollIntoView:"selectionPart"},{name:"blockindent",description:"Block indent",bindKey:o("Ctrl-]","Ctrl-]"),exec:function(e){e.blockIndent()},multiSelectAction:"forEachLine",scrollIntoView:"selectionPart"},{name:"insertstring",description:"Insert string",exec:function(e,t){e.insert(t)},multiSelectAction:"forEach",scrollIntoView:"cursor"},{name:"inserttext",description:"Insert text",exec:function(e,t){e.insert(i.stringRepeat(t.text||"",t.times||1))},multiSelectAction:"forEach",scrollIntoView:"cursor"},{name:"splitline",description:"Split line",bindKey:o(null,"Ctrl-O"),exec:function(e){e.splitLine()},multiSelectAction:"forEach",scrollIntoView:"cursor"},{name:"transposeletters",description:"Transpose letters",bindKey:o("Alt-Shift-X","Ctrl-T"),exec:function(e){e.transposeLetters()},multiSelectAction:function(e){e.transposeSelections(1)},scrollIntoView:"cursor"},{name:"touppercase",description:"To uppercase",bindKey:o("Ctrl-U","Ctrl-U"),exec:function(e){e.toUpperCase()},multiSelectAction:"forEach",scrollIntoView:"cursor"},{name:"tolowercase",description:"To lowercase",bindKey:o("Ctrl-Shift-U","Ctrl-Shift-U"),exec:function(e){e.toLowerCase()},multiSelectAction:"forEach",scrollIntoView:"cursor"},{name:"expandtoline",description:"Expand to line",bindKey:o("Ctrl-Shift-L","Command-Shift-L"),exec:function(e){var t=e.selection.getRange();t.start.column=t.end.column=0,t.end.row++,e.selection.setRange(t,!1)},multiSelectAction:"forEach",scrollIntoView:"cursor",readOnly:!0},{name:"joinlines",description:"Join lines",bindKey:o(null,null),exec:function(e){for(var t=e.selection.isBackwards(),n=t?e.selection.getSelectionLead():e.selection.getSelectionAnchor(),r=t?e.selection.getSelectionAnchor():e.selection.getSelectionLead(),o=e.session.doc.getLine(n.row).length,a=e.session.doc.getTextRange(e.selection.getRange()).replace(/\n\s*/," ").length,l=e.session.doc.getLine(n.row),c=n.row+1;c<=r.row+1;c++){var u=i.stringTrimLeft(i.stringTrimRight(e.session.doc.getLine(c)));0!==u.length&&(u=" "+u),l+=u}r.row+1<e.session.doc.getLength()-1&&(l+=e.session.doc.getNewLineCharacter()),e.clearSelection(),e.session.doc.replace(new s(n.row,0,r.row+2,0),l),a>0?(e.selection.moveCursorTo(n.row,n.column),e.selection.selectTo(n.row,n.column+a)):(o=e.session.doc.getLine(n.row).length>o?o+1:o,e.selection.moveCursorTo(n.row,o))},multiSelectAction:"forEach",readOnly:!0},{name:"invertSelection",description:"Invert selection",bindKey:o(null,null),exec:function(e){var t=e.session.doc.getLength()-1,n=e.session.doc.getLine(t).length,i=e.selection.rangeList.ranges,r=[];i.length<1&&(i=[e.selection.getRange()]);for(var o=0;o<i.length;o++)o==i.length-1&&(i[o].end.row===t&&i[o].end.column===n||r.push(new s(i[o].end.row,i[o].end.column,t,n))),0===o?0===i[o].start.row&&0===i[o].start.column||r.push(new s(0,0,i[o].start.row,i[o].start.column)):r.push(new s(i[o-1].end.row,i[o-1].end.column,i[o].start.row,i[o].start.column));for(e.exitMultiSelectMode(),e.clearSelection(),o=0;o<r.length;o++)e.selection.addRange(r[o],!1)},readOnly:!0,scrollIntoView:"none"},{name:"openCommandPallete",description:"Open command pallete",bindKey:o("F1","F1"),exec:function(e){e.prompt({$type:"commands"})},readOnly:!0},{name:"modeSelect",description:"Change language mode...",bindKey:o(null,null),exec:function(e){e.prompt({$type:"modes"})},readOnly:!0}]})),ace.define("ace/editor",["require","exports","module","ace/lib/fixoldbrowsers","ace/lib/oop","ace/lib/dom","ace/lib/lang","ace/lib/useragent","ace/keyboard/textinput","ace/mouse/mouse_handler","ace/mouse/fold_handler","ace/keyboard/keybinding","ace/edit_session","ace/search","ace/range","ace/lib/event_emitter","ace/commands/command_manager","ace/commands/default_commands","ace/config","ace/token_iterator","ace/clipboard"],(function(e,t,n){"use strict";e("./lib/fixoldbrowsers");var i=e("./lib/oop"),r=e("./lib/dom"),s=e("./lib/lang"),o=e("./lib/useragent"),a=e("./keyboard/textinput").TextInput,l=e("./mouse/mouse_handler").MouseHandler,c=e("./mouse/fold_handler").FoldHandler,u=e("./keyboard/keybinding").KeyBinding,h=e("./edit_session").EditSession,d=e("./search").Search,m=e("./range").Range,p=e("./lib/event_emitter").EventEmitter,g=e("./commands/command_manager").CommandManager,f=e("./commands/default_commands").commands,E=e("./config"),v=e("./token_iterator").TokenIterator,_=e("./clipboard"),C=function(e,t,n){var i=e.getContainerElement();this.container=i,this.renderer=e,this.id="editor"+ ++C.$uid,this.commands=new g(o.isMac?"mac":"win",f),"object"==typeof document&&(this.textInput=new a(e.getTextAreaContainer(),this),this.renderer.textarea=this.textInput.getElement(),this.$mouseHandler=new l(this),new c(this)),this.keyBinding=new u(this),this.$search=(new d).set({wrap:!0}),this.$historyTracker=this.$historyTracker.bind(this),this.commands.on("exec",this.$historyTracker),this.$initOperationListeners(),this._$emitInputEvent=s.delayedCall(function(){this._signal("input",{}),this.session&&this.session.bgTokenizer&&this.session.bgTokenizer.scheduleStart()}.bind(this)),this.on("change",(function(e,t){t._$emitInputEvent.schedule(31)})),this.setSession(t||n&&n.session||new h("")),E.resetOptions(this),n&&this.setOptions(n),E._signal("editor",this)};C.$uid=0,function(){i.implement(this,p),this.$initOperationListeners=function(){this.commands.on("exec",this.startOperation.bind(this),!0),this.commands.on("afterExec",this.endOperation.bind(this),!0),this.$opResetTimer=s.delayedCall(this.endOperation.bind(this,!0)),this.on("change",function(){this.curOp||(this.startOperation(),this.curOp.selectionBefore=this.$lastSel),this.curOp.docChanged=!0}.bind(this),!0),this.on("changeSelection",function(){this.curOp||(this.startOperation(),this.curOp.selectionBefore=this.$lastSel),this.curOp.selectionChanged=!0}.bind(this),!0)},this.curOp=null,this.prevOp={},this.startOperation=function(e){if(this.curOp){if(!e||this.curOp.command)return;this.prevOp=this.curOp}e||(this.previousCommand=null,e={}),this.$opResetTimer.schedule(),this.curOp=this.session.curOp={command:e.command||{},args:e.args,scrollTop:this.renderer.scrollTop},this.curOp.selectionBefore=this.selection.toJSON()},this.endOperation=function(e){if(this.curOp){if(e&&!1===e.returnValue)return this.curOp=null;if(1==e&&this.curOp.command&&"mouse"==this.curOp.command.name)return;if(this._signal("beforeEndOperation"),!this.curOp)return;var t=this.curOp.command,n=t&&t.scrollIntoView;if(n){switch(n){case"center-animate":n="animate";case"center":this.renderer.scrollCursorIntoView(null,.5);break;case"animate":case"cursor":this.renderer.scrollCursorIntoView();break;case"selectionPart":var i=this.selection.getRange(),r=this.renderer.layerConfig;(i.start.row>=r.lastRow||i.end.row<=r.firstRow)&&this.renderer.scrollSelectionIntoView(this.selection.anchor,this.selection.lead)}"animate"==n&&this.renderer.animateScrolling(this.curOp.scrollTop)}var s=this.selection.toJSON();this.curOp.selectionAfter=s,this.$lastSel=this.selection.toJSON(),this.session.getUndoManager().addSelection(s),this.prevOp=this.curOp,this.curOp=null}},this.$mergeableCommands=["backspace","del","insertstring"],this.$historyTracker=function(e){if(this.$mergeUndoDeltas){var t=this.prevOp,n=this.$mergeableCommands,i=t.command&&e.command.name==t.command.name;if("insertstring"==e.command.name){var r=e.args;void 0===this.mergeNextCommand&&(this.mergeNextCommand=!0),i=i&&this.mergeNextCommand&&(!/\s/.test(r)||/\s/.test(t.args)),this.mergeNextCommand=!0}else i=i&&-1!==n.indexOf(e.command.name);"always"!=this.$mergeUndoDeltas&&Date.now()-this.sequenceStartTime>2e3&&(i=!1),i?this.session.mergeUndoDeltas=!0:-1!==n.indexOf(e.command.name)&&(this.sequenceStartTime=Date.now())}},this.setKeyboardHandler=function(e,t){if(e&&"string"==typeof e&&"ace"!=e){this.$keybindingId=e;var n=this;E.loadModule(["keybinding",e],(function(i){n.$keybindingId==e&&n.keyBinding.setKeyboardHandler(i&&i.handler),t&&t()}))}else this.$keybindingId=null,this.keyBinding.setKeyboardHandler(e),t&&t()},this.getKeyboardHandler=function(){return this.keyBinding.getKeyboardHandler()},this.setSession=function(e){if(this.session!=e){this.curOp&&this.endOperation(),this.curOp={};var t=this.session;if(t){this.session.off("change",this.$onDocumentChange),this.session.off("changeMode",this.$onChangeMode),this.session.off("tokenizerUpdate",this.$onTokenizerUpdate),this.session.off("changeTabSize",this.$onChangeTabSize),this.session.off("changeWrapLimit",this.$onChangeWrapLimit),this.session.off("changeWrapMode",this.$onChangeWrapMode),this.session.off("changeFold",this.$onChangeFold),this.session.off("changeFrontMarker",this.$onChangeFrontMarker),this.session.off("changeBackMarker",this.$onChangeBackMarker),this.session.off("changeBreakpoint",this.$onChangeBreakpoint),this.session.off("changeAnnotation",this.$onChangeAnnotation),this.session.off("changeOverwrite",this.$onCursorChange),this.session.off("changeScrollTop",this.$onScrollTopChange),this.session.off("changeScrollLeft",this.$onScrollLeftChange);var n=this.session.getSelection();n.off("changeCursor",this.$onCursorChange),n.off("changeSelection",this.$onSelectionChange)}this.session=e,e?(this.$onDocumentChange=this.onDocumentChange.bind(this),e.on("change",this.$onDocumentChange),this.renderer.setSession(e),this.$onChangeMode=this.onChangeMode.bind(this),e.on("changeMode",this.$onChangeMode),this.$onTokenizerUpdate=this.onTokenizerUpdate.bind(this),e.on("tokenizerUpdate",this.$onTokenizerUpdate),this.$onChangeTabSize=this.renderer.onChangeTabSize.bind(this.renderer),e.on("changeTabSize",this.$onChangeTabSize),this.$onChangeWrapLimit=this.onChangeWrapLimit.bind(this),e.on("changeWrapLimit",this.$onChangeWrapLimit),this.$onChangeWrapMode=this.onChangeWrapMode.bind(this),e.on("changeWrapMode",this.$onChangeWrapMode),this.$onChangeFold=this.onChangeFold.bind(this),e.on("changeFold",this.$onChangeFold),this.$onChangeFrontMarker=this.onChangeFrontMarker.bind(this),this.session.on("changeFrontMarker",this.$onChangeFrontMarker),this.$onChangeBackMarker=this.onChangeBackMarker.bind(this),this.session.on("changeBackMarker",this.$onChangeBackMarker),this.$onChangeBreakpoint=this.onChangeBreakpoint.bind(this),this.session.on("changeBreakpoint",this.$onChangeBreakpoint),this.$onChangeAnnotation=this.onChangeAnnotation.bind(this),this.session.on("changeAnnotation",this.$onChangeAnnotation),this.$onCursorChange=this.onCursorChange.bind(this),this.session.on("changeOverwrite",this.$onCursorChange),this.$onScrollTopChange=this.onScrollTopChange.bind(this),this.session.on("changeScrollTop",this.$onScrollTopChange),this.$onScrollLeftChange=this.onScrollLeftChange.bind(this),this.session.on("changeScrollLeft",this.$onScrollLeftChange),this.selection=e.getSelection(),this.selection.on("changeCursor",this.$onCursorChange),this.$onSelectionChange=this.onSelectionChange.bind(this),this.selection.on("changeSelection",this.$onSelectionChange),this.onChangeMode(),this.onCursorChange(),this.onScrollTopChange(),this.onScrollLeftChange(),this.onSelectionChange(),this.onChangeFrontMarker(),this.onChangeBackMarker(),this.onChangeBreakpoint(),this.onChangeAnnotation(),this.session.getUseWrapMode()&&this.renderer.adjustWrapLimit(),this.renderer.updateFull()):(this.selection=null,this.renderer.setSession(e)),this._signal("changeSession",{session:e,oldSession:t}),this.curOp=null,t&&t._signal("changeEditor",{oldEditor:this}),e&&e._signal("changeEditor",{editor:this}),e&&e.bgTokenizer&&e.bgTokenizer.scheduleStart()}},this.getSession=function(){return this.session},this.setValue=function(e,t){return this.session.doc.setValue(e),t?1==t?this.navigateFileEnd():-1==t&&this.navigateFileStart():this.selectAll(),e},this.getValue=function(){return this.session.getValue()},this.getSelection=function(){return this.selection},this.resize=function(e){this.renderer.onResize(e)},this.setTheme=function(e,t){this.renderer.setTheme(e,t)},this.getTheme=function(){return this.renderer.getTheme()},this.setStyle=function(e){this.renderer.setStyle(e)},this.unsetStyle=function(e){this.renderer.unsetStyle(e)},this.getFontSize=function(){return this.getOption("fontSize")||r.computedStyle(this.container).fontSize},this.setFontSize=function(e){this.setOption("fontSize",e)},this.$highlightBrackets=function(){if(this.session.$bracketHighlight&&(this.session.removeMarker(this.session.$bracketHighlight),this.session.$bracketHighlight=null),!this.$highlightPending){var e=this;this.$highlightPending=!0,setTimeout((function(){e.$highlightPending=!1;var t=e.session;if(t&&t.bgTokenizer){var n=t.findMatchingBracket(e.getCursorPosition());if(n)var i=new m(n.row,n.column,n.row,n.column+1);else t.$mode.getMatching&&(i=t.$mode.getMatching(e.session));i&&(t.$bracketHighlight=t.addMarker(i,"ace_bracket","text"))}}),50)}},this.$highlightTags=function(){if(!this.$highlightTagPending){var e=this;this.$highlightTagPending=!0,setTimeout((function(){e.$highlightTagPending=!1;var t=e.session;if(t&&t.bgTokenizer){var n=e.getCursorPosition(),i=new v(e.session,n.row,n.column),r=i.getCurrentToken();if(!r||!/\b(?:tag-open|tag-name)/.test(r.type))return t.removeMarker(t.$tagHighlight),void(t.$tagHighlight=null);if(-1==r.type.indexOf("tag-open")||(r=i.stepForward())){var s=r.value,o=0,a=i.stepBackward();if("<"==a.value)do{a=r,(r=i.stepForward())&&r.value===s&&-1!==r.type.indexOf("tag-name")&&("<"===a.value?o++:"</"===a.value&&o--)}while(r&&o>=0);else{do{r=a,a=i.stepBackward(),r&&r.value===s&&-1!==r.type.indexOf("tag-name")&&("<"===a.value?o++:"</"===a.value&&o--)}while(a&&o<=0);i.stepForward()}if(!r)return t.removeMarker(t.$tagHighlight),void(t.$tagHighlight=null);var l=i.getCurrentTokenRow(),c=i.getCurrentTokenColumn(),u=new m(l,c,l,c+r.value.length),h=t.$backMarkers[t.$tagHighlight];t.$tagHighlight&&null!=h&&0!==u.compareRange(h.range)&&(t.removeMarker(t.$tagHighlight),t.$tagHighlight=null),t.$tagHighlight||(t.$tagHighlight=t.addMarker(u,"ace_bracket","text"))}}}),50)}},this.focus=function(){var e=this;setTimeout((function(){e.isFocused()||e.textInput.focus()})),this.textInput.focus()},this.isFocused=function(){return this.textInput.isFocused()},this.blur=function(){this.textInput.blur()},this.onFocus=function(e){this.$isFocused||(this.$isFocused=!0,this.renderer.showCursor(),this.renderer.visualizeFocus(),this._emit("focus",e))},this.onBlur=function(e){this.$isFocused&&(this.$isFocused=!1,this.renderer.hideCursor(),this.renderer.visualizeBlur(),this._emit("blur",e))},this.$cursorChange=function(){this.renderer.updateCursor()},this.onDocumentChange=function(e){var t=this.session.$useWrapMode,n=e.start.row==e.end.row?e.end.row:1/0;this.renderer.updateLines(e.start.row,n,t),this._signal("change",e),this.$cursorChange(),this.$updateHighlightActiveLine()},this.onTokenizerUpdate=function(e){var t=e.data;this.renderer.updateLines(t.first,t.last)},this.onScrollTopChange=function(){this.renderer.scrollToY(this.session.getScrollTop())},this.onScrollLeftChange=function(){this.renderer.scrollToX(this.session.getScrollLeft())},this.onCursorChange=function(){this.$cursorChange(),this.$highlightBrackets(),this.$highlightTags(),this.$updateHighlightActiveLine(),this._signal("changeSelection")},this.$updateHighlightActiveLine=function(){var e,t=this.getSession();if(this.$highlightActiveLine&&("line"==this.$selectionStyle&&this.selection.isMultiLine()||(e=this.getCursorPosition()),this.renderer.theme&&this.renderer.theme.$selectionColorConflict&&!this.selection.isEmpty()&&(e=!1),!this.renderer.$maxLines||1!==this.session.getLength()||this.renderer.$minLines>1||(e=!1)),t.$highlightLineMarker&&!e)t.removeMarker(t.$highlightLineMarker.id),t.$highlightLineMarker=null;else if(!t.$highlightLineMarker&&e){var n=new m(e.row,e.column,e.row,1/0);n.id=t.addMarker(n,"ace_active-line","screenLine"),t.$highlightLineMarker=n}else e&&(t.$highlightLineMarker.start.row=e.row,t.$highlightLineMarker.end.row=e.row,t.$highlightLineMarker.start.column=e.column,t._signal("changeBackMarker"))},this.onSelectionChange=function(e){var t=this.session;if(t.$selectionMarker&&t.removeMarker(t.$selectionMarker),t.$selectionMarker=null,this.selection.isEmpty())this.$updateHighlightActiveLine();else{var n=this.selection.getRange(),i=this.getSelectionStyle();t.$selectionMarker=t.addMarker(n,"ace_selection",i)}var r=this.$highlightSelectedWord&&this.$getSelectionHighLightRegexp();this.session.highlight(r),this._signal("changeSelection")},this.$getSelectionHighLightRegexp=function(){var e=this.session,t=this.getSelectionRange();if(!t.isEmpty()&&!t.isMultiLine()){var n=t.start.column,i=t.end.column,r=e.getLine(t.start.row),s=r.substring(n,i);if(!(s.length>5e3)&&/[\w\d]/.test(s)){var o=this.$search.$assembleRegExp({wholeWord:!0,caseSensitive:!0,needle:s}),a=r.substring(n-1,i+1);if(o.test(a))return o}}},this.onChangeFrontMarker=function(){this.renderer.updateFrontMarkers()},this.onChangeBackMarker=function(){this.renderer.updateBackMarkers()},this.onChangeBreakpoint=function(){this.renderer.updateBreakpoints()},this.onChangeAnnotation=function(){this.renderer.setAnnotations(this.session.getAnnotations())},this.onChangeMode=function(e){this.renderer.updateText(),this._emit("changeMode",e)},this.onChangeWrapLimit=function(){this.renderer.updateFull()},this.onChangeWrapMode=function(){this.renderer.onResize(!0)},this.onChangeFold=function(){this.$updateHighlightActiveLine(),this.renderer.updateFull()},this.getSelectedText=function(){return this.session.getTextRange(this.getSelectionRange())},this.getCopyText=function(){var e=this.getSelectedText(),t=this.session.doc.getNewLineCharacter(),n=!1;if(!e&&this.$copyWithEmptySelection){n=!0;for(var i=this.selection.getAllRanges(),r=0;r<i.length;r++){var s=i[r];r&&i[r-1].start.row==s.start.row||(e+=this.session.getLine(s.start.row)+t)}}var o={text:e};return this._signal("copy",o),_.lineMode=n?o.text:"",o.text},this.onCopy=function(){this.commands.exec("copy",this)},this.onCut=function(){this.commands.exec("cut",this)},this.onPaste=function(e,t){var n={text:e,event:t};this.commands.exec("paste",this,n)},this.$handlePaste=function(e){"string"==typeof e&&(e={text:e}),this._signal("paste",e);var t=e.text,n=t==_.lineMode,i=this.session;if(!this.inMultiSelectMode||this.inVirtualSelectionMode)n?i.insert({row:this.selection.lead.row,column:0},t):this.insert(t);else if(n)this.selection.rangeList.ranges.forEach((function(e){i.insert({row:e.start.row,column:0},t)}));else{var r=t.split(/\r\n|\r|\n/),s=this.selection.rangeList.ranges,o=!(2!=r.length||r[0]&&r[1]);if(r.length!=s.length||o)return this.commands.exec("insertstring",this,t);for(var a=s.length;a--;){var l=s[a];l.isEmpty()||i.remove(l),i.insert(l.start,r[a])}}},this.execCommand=function(e,t){return this.commands.exec(e,this,t)},this.insert=function(e,t){var n=this.session,i=n.getMode(),r=this.getCursorPosition();if(this.getBehavioursEnabled()&&!t){var s=i.transformAction(n.getState(r.row),"insertion",this,n,e);s&&(e!==s.text&&(this.inVirtualSelectionMode||(this.session.mergeUndoDeltas=!1,this.mergeNextCommand=!1)),e=s.text)}if("\t"==e&&(e=this.session.getTabString()),this.selection.isEmpty())this.session.getOverwrite()&&-1==e.indexOf("\n")&&((o=new m.fromPoints(r,r)).end.column+=e.length,this.session.remove(o));else{var o=this.getSelectionRange();r=this.session.remove(o),this.clearSelection()}if("\n"==e||"\r\n"==e){var a=n.getLine(r.row);if(r.column>a.search(/\S|$/)){var l=a.substr(r.column).search(/\S|$/);n.doc.removeInLine(r.row,r.column,r.column+l)}}this.clearSelection();var c=r.column,u=n.getState(r.row),h=(a=n.getLine(r.row),i.checkOutdent(u,a,e));if(n.insert(r,e),s&&s.selection&&(2==s.selection.length?this.selection.setSelectionRange(new m(r.row,c+s.selection[0],r.row,c+s.selection[1])):this.selection.setSelectionRange(new m(r.row+s.selection[0],s.selection[1],r.row+s.selection[2],s.selection[3]))),n.getDocument().isNewLine(e)){var d=i.getNextLineIndent(u,a.slice(0,r.column),n.getTabString());n.insert({row:r.row+1,column:0},d)}h&&i.autoOutdent(u,n,r.row)},this.onTextInput=function(e,t){if(!t)return this.keyBinding.onTextInput(e);this.startOperation({command:{name:"insertstring"}});var n=this.applyComposition.bind(this,e,t);this.selection.rangeCount?this.forEachSelection(n):n(),this.endOperation()},this.applyComposition=function(e,t){var n;(t.extendLeft||t.extendRight)&&((n=this.selection.getRange()).start.column-=t.extendLeft,n.end.column+=t.extendRight,this.selection.setRange(n),e||n.isEmpty()||this.remove()),!e&&this.selection.isEmpty()||this.insert(e,!0),(t.restoreStart||t.restoreEnd)&&((n=this.selection.getRange()).start.column-=t.restoreStart,n.end.column-=t.restoreEnd,this.selection.setRange(n))},this.onCommandKey=function(e,t,n){return this.keyBinding.onCommandKey(e,t,n)},this.setOverwrite=function(e){this.session.setOverwrite(e)},this.getOverwrite=function(){return this.session.getOverwrite()},this.toggleOverwrite=function(){this.session.toggleOverwrite()},this.setScrollSpeed=function(e){this.setOption("scrollSpeed",e)},this.getScrollSpeed=function(){return this.getOption("scrollSpeed")},this.setDragDelay=function(e){this.setOption("dragDelay",e)},this.getDragDelay=function(){return this.getOption("dragDelay")},this.setSelectionStyle=function(e){this.setOption("selectionStyle",e)},this.getSelectionStyle=function(){return this.getOption("selectionStyle")},this.setHighlightActiveLine=function(e){this.setOption("highlightActiveLine",e)},this.getHighlightActiveLine=function(){return this.getOption("highlightActiveLine")},this.setHighlightGutterLine=function(e){this.setOption("highlightGutterLine",e)},this.getHighlightGutterLine=function(){return this.getOption("highlightGutterLine")},this.setHighlightSelectedWord=function(e){this.setOption("highlightSelectedWord",e)},this.getHighlightSelectedWord=function(){return this.$highlightSelectedWord},this.setAnimatedScroll=function(e){this.renderer.setAnimatedScroll(e)},this.getAnimatedScroll=function(){return this.renderer.getAnimatedScroll()},this.setShowInvisibles=function(e){this.renderer.setShowInvisibles(e)},this.getShowInvisibles=function(){return this.renderer.getShowInvisibles()},this.setDisplayIndentGuides=function(e){this.renderer.setDisplayIndentGuides(e)},this.getDisplayIndentGuides=function(){return this.renderer.getDisplayIndentGuides()},this.setShowPrintMargin=function(e){this.renderer.setShowPrintMargin(e)},this.getShowPrintMargin=function(){return this.renderer.getShowPrintMargin()},this.setPrintMarginColumn=function(e){this.renderer.setPrintMarginColumn(e)},this.getPrintMarginColumn=function(){return this.renderer.getPrintMarginColumn()},this.setReadOnly=function(e){this.setOption("readOnly",e)},this.getReadOnly=function(){return this.getOption("readOnly")},this.setBehavioursEnabled=function(e){this.setOption("behavioursEnabled",e)},this.getBehavioursEnabled=function(){return this.getOption("behavioursEnabled")},this.setWrapBehavioursEnabled=function(e){this.setOption("wrapBehavioursEnabled",e)},this.getWrapBehavioursEnabled=function(){return this.getOption("wrapBehavioursEnabled")},this.setShowFoldWidgets=function(e){this.setOption("showFoldWidgets",e)},this.getShowFoldWidgets=function(){return this.getOption("showFoldWidgets")},this.setFadeFoldWidgets=function(e){this.setOption("fadeFoldWidgets",e)},this.getFadeFoldWidgets=function(){return this.getOption("fadeFoldWidgets")},this.remove=function(e){this.selection.isEmpty()&&("left"==e?this.selection.selectLeft():this.selection.selectRight());var t=this.getSelectionRange();if(this.getBehavioursEnabled()){var n=this.session,i=n.getState(t.start.row),r=n.getMode().transformAction(i,"deletion",this,n,t);if(0===t.end.column){var s=n.getTextRange(t);if("\n"==s[s.length-1]){var o=n.getLine(t.end.row);/^\s+$/.test(o)&&(t.end.column=o.length)}}r&&(t=r)}this.session.remove(t),this.clearSelection()},this.removeWordRight=function(){this.selection.isEmpty()&&this.selection.selectWordRight(),this.session.remove(this.getSelectionRange()),this.clearSelection()},this.removeWordLeft=function(){this.selection.isEmpty()&&this.selection.selectWordLeft(),this.session.remove(this.getSelectionRange()),this.clearSelection()},this.removeToLineStart=function(){this.selection.isEmpty()&&this.selection.selectLineStart(),this.selection.isEmpty()&&this.selection.selectLeft(),this.session.remove(this.getSelectionRange()),this.clearSelection()},this.removeToLineEnd=function(){this.selection.isEmpty()&&this.selection.selectLineEnd();var e=this.getSelectionRange();e.start.column==e.end.column&&e.start.row==e.end.row&&(e.end.column=0,e.end.row++),this.session.remove(e),this.clearSelection()},this.splitLine=function(){this.selection.isEmpty()||(this.session.remove(this.getSelectionRange()),this.clearSelection());var e=this.getCursorPosition();this.insert("\n"),this.moveCursorToPosition(e)},this.transposeLetters=function(){if(this.selection.isEmpty()){var e=this.getCursorPosition(),t=e.column;if(0!==t){var n,i,r=this.session.getLine(e.row);t<r.length?(n=r.charAt(t)+r.charAt(t-1),i=new m(e.row,t-1,e.row,t+1)):(n=r.charAt(t-1)+r.charAt(t-2),i=new m(e.row,t-2,e.row,t)),this.session.replace(i,n),this.session.selection.moveToPosition(i.end)}}},this.toLowerCase=function(){var e=this.getSelectionRange();this.selection.isEmpty()&&this.selection.selectWord();var t=this.getSelectionRange(),n=this.session.getTextRange(t);this.session.replace(t,n.toLowerCase()),this.selection.setSelectionRange(e)},this.toUpperCase=function(){var e=this.getSelectionRange();this.selection.isEmpty()&&this.selection.selectWord();var t=this.getSelectionRange(),n=this.session.getTextRange(t);this.session.replace(t,n.toUpperCase()),this.selection.setSelectionRange(e)},this.indent=function(){var e=this.session,t=this.getSelectionRange();if(!(t.start.row<t.end.row)){if(t.start.column<t.end.column){var n=e.getTextRange(t);if(!/^\s+$/.test(n))return u=this.$getSelectedRows(),void e.indentRows(u.first,u.last,"\t")}var i=e.getLine(t.start.row),r=t.start,o=e.getTabSize(),a=e.documentToScreenColumn(r.row,r.column);if(this.session.getUseSoftTabs())var l=o-a%o,c=s.stringRepeat(" ",l);else{for(l=a%o;" "==i[t.start.column-1]&&l;)t.start.column--,l--;this.selection.setSelectionRange(t),c="\t"}return this.insert(c)}var u=this.$getSelectedRows();e.indentRows(u.first,u.last,"\t")},this.blockIndent=function(){var e=this.$getSelectedRows();this.session.indentRows(e.first,e.last,"\t")},this.blockOutdent=function(){var e=this.session.getSelection();this.session.outdentRows(e.getRange())},this.sortLines=function(){for(var e=this.$getSelectedRows(),t=this.session,n=[],i=e.first;i<=e.last;i++)n.push(t.getLine(i));n.sort((function(e,t){return e.toLowerCase()<t.toLowerCase()?-1:e.toLowerCase()>t.toLowerCase()?1:0}));var r=new m(0,0,0,0);for(i=e.first;i<=e.last;i++){var s=t.getLine(i);r.start.row=i,r.end.row=i,r.end.column=s.length,t.replace(r,n[i-e.first])}},this.toggleCommentLines=function(){var e=this.session.getState(this.getCursorPosition().row),t=this.$getSelectedRows();this.session.getMode().toggleCommentLines(e,this.session,t.first,t.last)},this.toggleBlockComment=function(){var e=this.getCursorPosition(),t=this.session.getState(e.row),n=this.getSelectionRange();this.session.getMode().toggleBlockComment(t,this.session,n,e)},this.getNumberAt=function(e,t){var n=/[\-]?[0-9]+(?:\.[0-9]+)?/g;n.lastIndex=0;for(var i=this.session.getLine(e);n.lastIndex<t;){var r=n.exec(i);if(r.index<=t&&r.index+r[0].length>=t)return{value:r[0],start:r.index,end:r.index+r[0].length}}return null},this.modifyNumber=function(e){var t=this.selection.getCursor().row,n=this.selection.getCursor().column,i=new m(t,n-1,t,n),r=this.session.getTextRange(i);if(!isNaN(parseFloat(r))&&isFinite(r)){var s=this.getNumberAt(t,n);if(s){var o=s.value.indexOf(".")>=0?s.start+s.value.indexOf(".")+1:s.end,a=s.start+s.value.length-o,l=parseFloat(s.value);l*=Math.pow(10,a),o!==s.end&&n<o?e*=Math.pow(10,s.end-n-1):e*=Math.pow(10,s.end-n),l+=e;var c=(l/=Math.pow(10,a)).toFixed(a),u=new m(t,s.start,t,s.end);this.session.replace(u,c),this.moveCursorTo(t,Math.max(s.start+1,n+c.length-s.value.length))}}else this.toggleWord()},this.$toggleWordPairs=[["first","last"],["true","false"],["yes","no"],["width","height"],["top","bottom"],["right","left"],["on","off"],["x","y"],["get","set"],["max","min"],["horizontal","vertical"],["show","hide"],["add","remove"],["up","down"],["before","after"],["even","odd"],["in","out"],["inside","outside"],["next","previous"],["increase","decrease"],["attach","detach"],["&&","||"],["==","!="]],this.toggleWord=function(){var e=this.selection.getCursor().row,t=this.selection.getCursor().column;this.selection.selectWord();var n=this.getSelectedText(),i=this.selection.getWordRange().start.column,r=n.replace(/([a-z]+|[A-Z]+)(?=[A-Z_]|$)/g,"$1 ").split(/\s/),o=t-i-1;o<0&&(o=0);var a=0,l=0,c=this;n.match(/[A-Za-z0-9_]+/)&&r.forEach((function(t,r){l=a+t.length,o>=a&&o<=l&&(n=t,c.selection.clearSelection(),c.moveCursorTo(e,a+i),c.selection.selectTo(e,l+i)),a=l}));for(var u,h=this.$toggleWordPairs,d=0;d<h.length;d++)for(var m=h[d],p=0;p<=1;p++){var g=+!p,f=n.match(new RegExp("^\\s?_?("+s.escapeRegExp(m[p])+")\\s?$","i"));f&&n.match(new RegExp("([_]|^|\\s)("+s.escapeRegExp(f[1])+")($|\\s)","g"))&&(u=n.replace(new RegExp(s.escapeRegExp(m[p]),"i"),(function(e){var t=m[g];return e.toUpperCase()==e?t=t.toUpperCase():e.charAt(0).toUpperCase()==e.charAt(0)&&(t=t.substr(0,0)+m[g].charAt(0).toUpperCase()+t.substr(1)),t})),this.insert(u),u="")}},this.removeLines=function(){var e=this.$getSelectedRows();this.session.removeFullLines(e.first,e.last),this.clearSelection()},this.duplicateSelection=function(){var e=this.selection,t=this.session,n=e.getRange(),i=e.isBackwards();if(n.isEmpty()){var r=n.start.row;t.duplicateLines(r,r)}else{var s=i?n.start:n.end,o=t.insert(s,t.getTextRange(n),!1);n.start=s,n.end=o,e.setSelectionRange(n,i)}},this.moveLinesDown=function(){this.$moveLines(1,!1)},this.moveLinesUp=function(){this.$moveLines(-1,!1)},this.moveText=function(e,t,n){return this.session.moveText(e,t,n)},this.copyLinesUp=function(){this.$moveLines(-1,!0)},this.copyLinesDown=function(){this.$moveLines(1,!0)},this.$moveLines=function(e,t){var n,i,r=this.selection;if(!r.inMultiSelectMode||this.inVirtualSelectionMode){var s=r.toOrientedRange();n=this.$getSelectedRows(s),i=this.session.$moveLines(n.first,n.last,t?0:e),t&&-1==e&&(i=0),s.moveBy(i,0),r.fromOrientedRange(s)}else{var o=r.rangeList.ranges;r.rangeList.detach(this.session),this.inVirtualSelectionMode=!0;for(var a=0,l=0,c=o.length,u=0;u<c;u++){var h=u;o[u].moveBy(a,0);for(var d=(n=this.$getSelectedRows(o[u])).first,m=n.last;++u<c;){l&&o[u].moveBy(l,0);var p=this.$getSelectedRows(o[u]);if(t&&p.first!=m)break;if(!t&&p.first>m+1)break;m=p.last}for(u--,a=this.session.$moveLines(d,m,t?0:e),t&&-1==e&&(h=u+1);h<=u;)o[h].moveBy(a,0),h++;t||(a=0),l+=a}r.fromOrientedRange(r.ranges[0]),r.rangeList.attach(this.session),this.inVirtualSelectionMode=!1}},this.$getSelectedRows=function(e){return e=(e||this.getSelectionRange()).collapseRows(),{first:this.session.getRowFoldStart(e.start.row),last:this.session.getRowFoldEnd(e.end.row)}},this.onCompositionStart=function(e){this.renderer.showComposition(e)},this.onCompositionUpdate=function(e){this.renderer.setCompositionText(e)},this.onCompositionEnd=function(){this.renderer.hideComposition()},this.getFirstVisibleRow=function(){return this.renderer.getFirstVisibleRow()},this.getLastVisibleRow=function(){return this.renderer.getLastVisibleRow()},this.isRowVisible=function(e){return e>=this.getFirstVisibleRow()&&e<=this.getLastVisibleRow()},this.isRowFullyVisible=function(e){return e>=this.renderer.getFirstFullyVisibleRow()&&e<=this.renderer.getLastFullyVisibleRow()},this.$getVisibleRowCount=function(){return this.renderer.getScrollBottomRow()-this.renderer.getScrollTopRow()+1},this.$moveByPage=function(e,t){var n=this.renderer,i=this.renderer.layerConfig,r=e*Math.floor(i.height/i.lineHeight);!0===t?this.selection.$moveSelection((function(){this.moveCursorBy(r,0)})):!1===t&&(this.selection.moveCursorBy(r,0),this.selection.clearSelection());var s=n.scrollTop;n.scrollBy(0,r*i.lineHeight),null!=t&&n.scrollCursorIntoView(null,.5),n.animateScrolling(s)},this.selectPageDown=function(){this.$moveByPage(1,!0)},this.selectPageUp=function(){this.$moveByPage(-1,!0)},this.gotoPageDown=function(){this.$moveByPage(1,!1)},this.gotoPageUp=function(){this.$moveByPage(-1,!1)},this.scrollPageDown=function(){this.$moveByPage(1)},this.scrollPageUp=function(){this.$moveByPage(-1)},this.scrollToRow=function(e){this.renderer.scrollToRow(e)},this.scrollToLine=function(e,t,n,i){this.renderer.scrollToLine(e,t,n,i)},this.centerSelection=function(){var e=this.getSelectionRange(),t={row:Math.floor(e.start.row+(e.end.row-e.start.row)/2),column:Math.floor(e.start.column+(e.end.column-e.start.column)/2)};this.renderer.alignCursor(t,.5)},this.getCursorPosition=function(){return this.selection.getCursor()},this.getCursorPositionScreen=function(){return this.session.documentToScreenPosition(this.getCursorPosition())},this.getSelectionRange=function(){return this.selection.getRange()},this.selectAll=function(){this.selection.selectAll()},this.clearSelection=function(){this.selection.clearSelection()},this.moveCursorTo=function(e,t){this.selection.moveCursorTo(e,t)},this.moveCursorToPosition=function(e){this.selection.moveCursorToPosition(e)},this.jumpToMatching=function(e,t){var n=this.getCursorPosition(),i=new v(this.session,n.row,n.column),r=i.getCurrentToken(),s=r||i.stepForward();if(s){var o,a,l=!1,c={},u=n.column-s.start,h={")":"(","(":"(","]":"[","[":"[","{":"{","}":"{"};do{if(s.value.match(/[{}()\[\]]/g)){for(;u<s.value.length&&!l;u++)if(h[s.value[u]])switch(a=h[s.value[u]]+"."+s.type.replace("rparen","lparen"),isNaN(c[a])&&(c[a]=0),s.value[u]){case"(":case"[":case"{":c[a]++;break;case")":case"]":case"}":c[a]--,-1===c[a]&&(o="bracket",l=!0)}}else-1!==s.type.indexOf("tag-name")&&(isNaN(c[s.value])&&(c[s.value]=0),"<"===r.value?c[s.value]++:"</"===r.value&&c[s.value]--,-1===c[s.value]&&(o="tag",l=!0));l||(r=s,s=i.stepForward(),u=0)}while(s&&!l);if(o){var d,p;if("bracket"===o)(d=this.session.getBracketRange(n))||(p=(d=new m(i.getCurrentTokenRow(),i.getCurrentTokenColumn()+u-1,i.getCurrentTokenRow(),i.getCurrentTokenColumn()+u-1)).start,(t||p.row===n.row&&Math.abs(p.column-n.column)<2)&&(d=this.session.getBracketRange(p)));else if("tag"===o){if(!s||-1===s.type.indexOf("tag-name"))return;var g=s.value;if(0===(d=new m(i.getCurrentTokenRow(),i.getCurrentTokenColumn()-2,i.getCurrentTokenRow(),i.getCurrentTokenColumn()-2)).compare(n.row,n.column)){l=!1;do{s=r,(r=i.stepBackward())&&(-1!==r.type.indexOf("tag-close")&&d.setEnd(i.getCurrentTokenRow(),i.getCurrentTokenColumn()+1),s.value===g&&-1!==s.type.indexOf("tag-name")&&("<"===r.value?c[g]++:"</"===r.value&&c[g]--,0===c[g]&&(l=!0)))}while(r&&!l)}s&&s.type.indexOf("tag-name")&&(p=d.start).row==n.row&&Math.abs(p.column-n.column)<2&&(p=d.end)}(p=d&&d.cursor||p)&&(e?d&&t?this.selection.setRange(d):d&&d.isEqual(this.getSelectionRange())?this.clearSelection():this.selection.selectTo(p.row,p.column):this.selection.moveTo(p.row,p.column))}}},this.gotoLine=function(e,t,n){this.selection.clearSelection(),this.session.unfold({row:e-1,column:t||0}),this.exitMultiSelectMode&&this.exitMultiSelectMode(),this.moveCursorTo(e-1,t||0),this.isRowFullyVisible(e-1)||this.scrollToLine(e-1,!0,n)},this.navigateTo=function(e,t){this.selection.moveTo(e,t)},this.navigateUp=function(e){if(this.selection.isMultiLine()&&!this.selection.isBackwards()){var t=this.selection.anchor.getPosition();return this.moveCursorToPosition(t)}this.selection.clearSelection(),this.selection.moveCursorBy(-e||-1,0)},this.navigateDown=function(e){if(this.selection.isMultiLine()&&this.selection.isBackwards()){var t=this.selection.anchor.getPosition();return this.moveCursorToPosition(t)}this.selection.clearSelection(),this.selection.moveCursorBy(e||1,0)},this.navigateLeft=function(e){if(this.selection.isEmpty())for(e=e||1;e--;)this.selection.moveCursorLeft();else{var t=this.getSelectionRange().start;this.moveCursorToPosition(t)}this.clearSelection()},this.navigateRight=function(e){if(this.selection.isEmpty())for(e=e||1;e--;)this.selection.moveCursorRight();else{var t=this.getSelectionRange().end;this.moveCursorToPosition(t)}this.clearSelection()},this.navigateLineStart=function(){this.selection.moveCursorLineStart(),this.clearSelection()},this.navigateLineEnd=function(){this.selection.moveCursorLineEnd(),this.clearSelection()},this.navigateFileEnd=function(){this.selection.moveCursorFileEnd(),this.clearSelection()},this.navigateFileStart=function(){this.selection.moveCursorFileStart(),this.clearSelection()},this.navigateWordRight=function(){this.selection.moveCursorWordRight(),this.clearSelection()},this.navigateWordLeft=function(){this.selection.moveCursorWordLeft(),this.clearSelection()},this.replace=function(e,t){t&&this.$search.set(t);var n=this.$search.find(this.session),i=0;return n?(this.$tryReplace(n,e)&&(i=1),this.selection.setSelectionRange(n),this.renderer.scrollSelectionIntoView(n.start,n.end),i):i},this.replaceAll=function(e,t){t&&this.$search.set(t);var n=this.$search.findAll(this.session),i=0;if(!n.length)return i;var r=this.getSelectionRange();this.selection.moveTo(0,0);for(var s=n.length-1;s>=0;--s)this.$tryReplace(n[s],e)&&i++;return this.selection.setSelectionRange(r),i},this.$tryReplace=function(e,t){var n=this.session.getTextRange(e);return null!==(t=this.$search.replace(n,t))?(e.end=this.session.replace(e,t),e):null},this.getLastSearchOptions=function(){return this.$search.getOptions()},this.find=function(e,t,n){t||(t={}),"string"==typeof e||e instanceof RegExp?t.needle=e:"object"==typeof e&&i.mixin(t,e);var r=this.selection.getRange();null==t.needle&&((e=this.session.getTextRange(r)||this.$search.$options.needle)||(r=this.session.getWordRange(r.start.row,r.start.column),e=this.session.getTextRange(r)),this.$search.set({needle:e})),this.$search.set(t),t.start||this.$search.set({start:r});var s=this.$search.find(this.session);return t.preventScroll?s:s?(this.revealRange(s,n),s):(t.backwards?r.start=r.end:r.end=r.start,void this.selection.setRange(r))},this.findNext=function(e,t){this.find({skipCurrent:!0,backwards:!1},e,t)},this.findPrevious=function(e,t){this.find(e,{skipCurrent:!0,backwards:!0},t)},this.revealRange=function(e,t){this.session.unfold(e),this.selection.setSelectionRange(e);var n=this.renderer.scrollTop;this.renderer.scrollSelectionIntoView(e.start,e.end,.5),!1!==t&&this.renderer.animateScrolling(n)},this.undo=function(){this.session.getUndoManager().undo(this.session),this.renderer.scrollCursorIntoView(null,.5)},this.redo=function(){this.session.getUndoManager().redo(this.session),this.renderer.scrollCursorIntoView(null,.5)},this.destroy=function(){this.renderer.destroy(),this._signal("destroy",this),this.session&&this.session.destroy()},this.setAutoScrollEditorIntoView=function(e){if(e){var t,n=this,i=!1;this.$scrollAnchor||(this.$scrollAnchor=document.createElement("div"));var r=this.$scrollAnchor;r.style.cssText="position:absolute",this.container.insertBefore(r,this.container.firstChild);var s=this.on("changeSelection",(function(){i=!0})),o=this.renderer.on("beforeRender",(function(){i&&(t=n.renderer.container.getBoundingClientRect())})),a=this.renderer.on("afterRender",(function(){if(i&&t&&(n.isFocused()||n.searchBox&&n.searchBox.isFocused())){var e=n.renderer,s=e.$cursorLayer.$pixelPos,o=e.layerConfig,a=s.top-o.offset;null!=(i=s.top>=0&&a+t.top<0||!(s.top<o.height&&s.top+t.top+o.lineHeight>window.innerHeight)&&null)&&(r.style.top=a+"px",r.style.left=s.left+"px",r.style.height=o.lineHeight+"px",r.scrollIntoView(i)),i=t=null}}));this.setAutoScrollEditorIntoView=function(e){e||(delete this.setAutoScrollEditorIntoView,this.off("changeSelection",s),this.renderer.off("afterRender",a),this.renderer.off("beforeRender",o))}}},this.$resetCursorStyle=function(){var e=this.$cursorStyle||"ace",t=this.renderer.$cursorLayer;t&&(t.setSmoothBlinking(/smooth/.test(e)),t.isBlinking=!this.$readOnly&&"wide"!=e,r.setCssClass(t.element,"ace_slim-cursors",/slim/.test(e)))},this.prompt=function(e,t,n){var i=this;E.loadModule("./ext/prompt",(function(r){r.prompt(i,e,t,n)}))}}.call(C.prototype),E.defineOptions(C.prototype,"editor",{selectionStyle:{set:function(e){this.onSelectionChange(),this._signal("changeSelectionStyle",{data:e})},initialValue:"line"},highlightActiveLine:{set:function(){this.$updateHighlightActiveLine()},initialValue:!0},highlightSelectedWord:{set:function(e){this.$onSelectionChange()},initialValue:!0},readOnly:{set:function(e){this.textInput.setReadOnly(e),this.$resetCursorStyle()},initialValue:!1},copyWithEmptySelection:{set:function(e){this.textInput.setCopyWithEmptySelection(e)},initialValue:!1},cursorStyle:{set:function(e){this.$resetCursorStyle()},values:["ace","slim","smooth","wide"],initialValue:"ace"},mergeUndoDeltas:{values:[!1,!0,"always"],initialValue:!0},behavioursEnabled:{initialValue:!0},wrapBehavioursEnabled:{initialValue:!0},autoScrollEditorIntoView:{set:function(e){this.setAutoScrollEditorIntoView(e)}},keyboardHandler:{set:function(e){this.setKeyboardHandler(e)},get:function(){return this.$keybindingId},handlesSet:!0},value:{set:function(e){this.session.setValue(e)},get:function(){return this.getValue()},handlesSet:!0,hidden:!0},session:{set:function(e){this.setSession(e)},get:function(){return this.session},handlesSet:!0,hidden:!0},showLineNumbers:{set:function(e){this.renderer.$gutterLayer.setShowLineNumbers(e),this.renderer.$loop.schedule(this.renderer.CHANGE_GUTTER),e&&this.$relativeLineNumbers?A.attach(this):A.detach(this)},initialValue:!0},relativeLineNumbers:{set:function(e){this.$showLineNumbers&&e?A.attach(this):A.detach(this)}},placeholder:{set:function(e){this.$updatePlaceholder||(this.$updatePlaceholder=function(){var e=this.renderer.$composition||this.getValue();if(e&&this.renderer.placeholderNode)this.renderer.off("afterRender",this.$updatePlaceholder),r.removeCssClass(this.container,"ace_hasPlaceholder"),this.renderer.placeholderNode.remove(),this.renderer.placeholderNode=null;else if(!e&&!this.renderer.placeholderNode){this.renderer.on("afterRender",this.$updatePlaceholder),r.addCssClass(this.container,"ace_hasPlaceholder");var t=r.createElement("div");t.className="ace_placeholder",t.textContent=this.$placeholder||"",this.renderer.placeholderNode=t,this.renderer.content.appendChild(this.renderer.placeholderNode)}}.bind(this),this.on("input",this.$updatePlaceholder)),this.$updatePlaceholder()}},hScrollBarAlwaysVisible:"renderer",vScrollBarAlwaysVisible:"renderer",highlightGutterLine:"renderer",animatedScroll:"renderer",showInvisibles:"renderer",showPrintMargin:"renderer",printMarginColumn:"renderer",printMargin:"renderer",fadeFoldWidgets:"renderer",showFoldWidgets:"renderer",displayIndentGuides:"renderer",showGutter:"renderer",fontSize:"renderer",fontFamily:"renderer",maxLines:"renderer",minLines:"renderer",scrollPastEnd:"renderer",fixedWidthGutter:"renderer",theme:"renderer",hasCssTransforms:"renderer",maxPixelHeight:"renderer",useTextareaForIME:"renderer",scrollSpeed:"$mouseHandler",dragDelay:"$mouseHandler",dragEnabled:"$mouseHandler",focusTimeout:"$mouseHandler",tooltipFollowsMouse:"$mouseHandler",firstLineNumber:"session",overwrite:"session",newLineMode:"session",useWorker:"session",useSoftTabs:"session",navigateWithinSoftTabs:"session",tabSize:"session",wrap:"session",indentedSoftWrap:"session",foldStyle:"session",mode:"session"});var A={getText:function(e,t){return(Math.abs(e.selection.lead.row-t)||t+1+(t<9?"·":""))+""},getWidth:function(e,t,n){return Math.max(t.toString().length,(n.lastRow+1).toString().length,2)*n.characterWidth},update:function(e,t){t.renderer.$loop.schedule(t.renderer.CHANGE_GUTTER)},attach:function(e){e.renderer.$gutterLayer.$renderer=this,e.on("changeSelection",this.update),this.update(null,e)},detach:function(e){e.renderer.$gutterLayer.$renderer==this&&(e.renderer.$gutterLayer.$renderer=null),e.off("changeSelection",this.update),this.update(null,e)}};t.Editor=C})),ace.define("ace/undomanager",["require","exports","module","ace/range"],(function(e,t,n){"use strict";var i=function(){this.$maxRev=0,this.$fromUndo=!1,this.reset()};(function(){this.addSession=function(e){this.$session=e},this.add=function(e,t,n){this.$fromUndo||e!=this.$lastDelta&&(!1!==t&&this.lastDeltas||(this.lastDeltas=[],this.$undoStack.push(this.lastDeltas),e.id=this.$rev=++this.$maxRev),"remove"!=e.action&&"insert"!=e.action||(this.$lastDelta=e),this.lastDeltas.push(e))},this.addSelection=function(e,t){this.selections.push({value:e,rev:t||this.$rev})},this.startNewGroup=function(){return this.lastDeltas=null,this.$rev},this.markIgnored=function(e,t){null==t&&(t=this.$rev+1);for(var n=this.$undoStack,i=n.length;i--;){var r=n[i][0];if(r.id<=e)break;r.id<t&&(r.ignore=!0)}this.lastDeltas=null},this.getSelection=function(e,t){for(var n=this.selections,i=n.length;i--;){var r=n[i];if(r.rev<e)return t&&(r=n[i+1]),r}},this.getRevision=function(){return this.$rev},this.getDeltas=function(e,t){null==t&&(t=this.$rev+1);for(var n=this.$undoStack,i=null,r=0,s=n.length;s--;){var o=n[s][0];if(o.id<t&&!i&&(i=s+1),o.id<=e){r=s+1;break}}return n.slice(r,i)},this.getChangedRanges=function(e,t){null==t&&(t=this.$rev+1)},this.getChangedLines=function(e,t){null==t&&(t=this.$rev+1)},this.undo=function(e,t){this.lastDeltas=null;var n=this.$undoStack;if(function(e,t){for(var n=t;n--;){var i=e[n];if(i&&!i[0].ignore){for(;n<t-1;){var r=u(e[n],e[n+1]);e[n]=r[0],e[n+1]=r[1],n++}return!0}}}(n,n.length)){e||(e=this.$session),this.$redoStackBaseRev!==this.$rev&&this.$redoStack.length&&(this.$redoStack=[]),this.$fromUndo=!0;var i=n.pop(),r=null;return i&&i.length&&(r=e.undoChanges(i,t),this.$redoStack.push(i),this.$syncRev()),this.$fromUndo=!1,r}},this.redo=function(e,t){if(this.lastDeltas=null,e||(e=this.$session),this.$fromUndo=!0,this.$redoStackBaseRev!=this.$rev){var n=this.getDeltas(this.$redoStackBaseRev,this.$rev+1);!function(e,t){for(var n=0;n<t.length;n++)for(var i=t[n],r=0;r<i.length;r++)g(e,i[r])}(this.$redoStack,n),this.$redoStackBaseRev=this.$rev,this.$redoStack.forEach((function(e){e[0].id=++this.$maxRev}),this)}var i=this.$redoStack.pop(),r=null;return i&&(r=e.redoChanges(i,t),this.$undoStack.push(i),this.$syncRev()),this.$fromUndo=!1,r},this.$syncRev=function(){var e=this.$undoStack,t=e[e.length-1],n=t&&t[0].id||0;this.$redoStackBaseRev=n,this.$rev=n},this.reset=function(){this.lastDeltas=null,this.$lastDelta=null,this.$undoStack=[],this.$redoStack=[],this.$rev=0,this.mark=0,this.$redoStackBaseRev=this.$rev,this.selections=[]},this.canUndo=function(){return this.$undoStack.length>0},this.canRedo=function(){return this.$redoStack.length>0},this.bookmark=function(e){null==e&&(e=this.$rev),this.mark=e},this.isAtBookmark=function(){return this.$rev===this.mark},this.toJSON=function(){},this.fromJSON=function(){},this.hasUndo=this.canUndo,this.hasRedo=this.canRedo,this.isClean=this.isAtBookmark,this.markClean=this.bookmark,this.$prettyPrint=function(e){return e?a(e):a(this.$undoStack)+"\n---\n"+a(this.$redoStack)}}).call(i.prototype);var r=e("./range").Range,s=r.comparePoints;function o(e){return{row:e.row,column:e.column}}function a(e){if(e=e||this,Array.isArray(e))return e.map(a).join("\n");var t="";return e.action?(t="insert"==e.action?"+":"-",t+="["+e.lines+"]"):e.value&&(t=Array.isArray(e.value)?e.value.map(l).join("\n"):l(e.value)),e.start&&(t+=l(e)),(e.id||e.rev)&&(t+="\t("+(e.id||e.rev)+")"),t}function l(e){return e.start.row+":"+e.start.column+"=>"+e.end.row+":"+e.end.column}function c(e,t){var n="insert"==e.action,i="insert"==t.action;if(n&&i)if(s(t.start,e.end)>=0)d(t,e,-1);else{if(!(s(t.start,e.start)<=0))return null;d(e,t,1)}else if(n&&!i)if(s(t.start,e.end)>=0)d(t,e,-1);else{if(!(s(t.end,e.start)<=0))return null;d(e,t,-1)}else if(!n&&i)if(s(t.start,e.start)>=0)d(t,e,1);else{if(!(s(t.start,e.start)<=0))return null;d(e,t,1)}else if(!n&&!i)if(s(t.start,e.start)>=0)d(t,e,1);else{if(!(s(t.end,e.start)<=0))return null;d(e,t,-1)}return[t,e]}function u(e,t){for(var n=e.length;n--;)for(var i=0;i<t.length;i++)if(!c(e[n],t[i])){for(;n<e.length;){for(;i--;)c(t[i],e[n]);i=t.length,n++}return[e,t]}return e.selectionBefore=t.selectionBefore=e.selectionAfter=t.selectionAfter=null,[t,e]}function h(e,t){var n="insert"==e.action,i="insert"==t.action;if(n&&i)s(e.start,t.start)<0?d(t,e,1):d(e,t,1);else if(n&&!i)s(e.start,t.end)>=0?d(e,t,-1):(s(e.start,t.start)<=0||d(e,r.fromPoints(t.start,e.start),-1),d(t,e,1));else if(!n&&i)s(t.start,e.end)>=0?d(t,e,-1):(s(t.start,e.start)<=0||d(t,r.fromPoints(e.start,t.start),-1),d(e,t,1));else if(!n&&!i)if(s(t.start,e.end)>=0)d(t,e,-1);else{var o,a;if(!(s(t.end,e.start)<=0))return s(e.start,t.start)<0&&(o=e,e=p(e,t.start)),s(e.end,t.end)>0&&(a=p(e,t.end)),m(t.end,e.start,e.end,-1),a&&!o&&(e.lines=a.lines,e.start=a.start,e.end=a.end,a=e),[t,o,a].filter(Boolean);d(e,t,-1)}return[t,e]}function d(e,t,n){m(e.start,t.start,t.end,n),m(e.end,t.start,t.end,n)}function m(e,t,n,i){e.row==(1==i?t:n).row&&(e.column+=i*(n.column-t.column)),e.row+=i*(n.row-t.row)}function p(e,t){var n=e.lines,i=e.end;e.end=o(t);var r=e.end.row-e.start.row,s=n.splice(r,n.length),a=r?t.column:t.column-e.start.column;return n.push(s[0].substring(0,a)),s[0]=s[0].substr(a),{start:o(t),end:i,lines:s,action:e.action}}function g(e,t){t=function(e){return{start:o(e.start),end:o(e.end),action:e.action,lines:e.lines.slice()}}(t);for(var n=e.length;n--;){for(var i=e[n],r=0;r<i.length;r++){var s=h(i[r],t);t=s[0],2!=s.length&&(s[2]?(i.splice(r+1,1,s[1],s[2]),r++):s[1]||(i.splice(r,1),r--))}i.length||e.splice(n,1)}return e}r.comparePoints,t.UndoManager=i})),ace.define("ace/layer/lines",["require","exports","module","ace/lib/dom"],(function(e,t,n){"use strict";var i=e("../lib/dom"),r=function(e,t){this.element=e,this.canvasHeight=t||5e5,this.element.style.height=2*this.canvasHeight+"px",this.cells=[],this.cellCache=[],this.$offsetCoefficient=0};(function(){this.moveContainer=function(e){i.translate(this.element,0,-e.firstRowScreen*e.lineHeight%this.canvasHeight-e.offset*this.$offsetCoefficient)},this.pageChanged=function(e,t){return Math.floor(e.firstRowScreen*e.lineHeight/this.canvasHeight)!==Math.floor(t.firstRowScreen*t.lineHeight/this.canvasHeight)},this.computeLineTop=function(e,t,n){var i=t.firstRowScreen*t.lineHeight,r=Math.floor(i/this.canvasHeight);return n.documentToScreenRow(e,0)*t.lineHeight-r*this.canvasHeight},this.computeLineHeight=function(e,t,n){return t.lineHeight*n.getRowLength(e)},this.getLength=function(){return this.cells.length},this.get=function(e){return this.cells[e]},this.shift=function(){this.$cacheCell(this.cells.shift())},this.pop=function(){this.$cacheCell(this.cells.pop())},this.push=function(e){if(Array.isArray(e)){this.cells.push.apply(this.cells,e);for(var t=i.createFragment(this.element),n=0;n<e.length;n++)t.appendChild(e[n].element);this.element.appendChild(t)}else this.cells.push(e),this.element.appendChild(e.element)},this.unshift=function(e){if(Array.isArray(e)){this.cells.unshift.apply(this.cells,e);for(var t=i.createFragment(this.element),n=0;n<e.length;n++)t.appendChild(e[n].element);this.element.firstChild?this.element.insertBefore(t,this.element.firstChild):this.element.appendChild(t)}else this.cells.unshift(e),this.element.insertAdjacentElement("afterbegin",e.element)},this.last=function(){return this.cells.length?this.cells[this.cells.length-1]:null},this.$cacheCell=function(e){e&&(e.element.remove(),this.cellCache.push(e))},this.createCell=function(e,t,n,r){var s=this.cellCache.pop();if(!s){var o=i.createElement("div");r&&r(o),this.element.appendChild(o),s={element:o,text:"",row:e}}return s.row=e,s}}).call(r.prototype),t.Lines=r})),ace.define("ace/layer/gutter",["require","exports","module","ace/lib/dom","ace/lib/oop","ace/lib/lang","ace/lib/event_emitter","ace/layer/lines"],(function(e,t,n){"use strict";var i=e("../lib/dom"),r=e("../lib/oop"),s=e("../lib/lang"),o=e("../lib/event_emitter").EventEmitter,a=e("./lines").Lines,l=function(e){this.element=i.createElement("div"),this.element.className="ace_layer ace_gutter-layer",e.appendChild(this.element),this.setShowFoldWidgets(this.$showFoldWidgets),this.gutterWidth=0,this.$annotations=[],this.$updateAnnotations=this.$updateAnnotations.bind(this),this.$lines=new a(this.element),this.$lines.$offsetCoefficient=1};function c(e){var t=document.createTextNode("");e.appendChild(t);var n=i.createElement("span");return e.appendChild(n),e}(function(){r.implement(this,o),this.setSession=function(e){this.session&&this.session.removeEventListener("change",this.$updateAnnotations),this.session=e,e&&e.on("change",this.$updateAnnotations)},this.addGutterDecoration=function(e,t){window.console&&console.warn&&console.warn("deprecated use session.addGutterDecoration"),this.session.addGutterDecoration(e,t)},this.removeGutterDecoration=function(e,t){window.console&&console.warn&&console.warn("deprecated use session.removeGutterDecoration"),this.session.removeGutterDecoration(e,t)},this.setAnnotations=function(e){this.$annotations=[];for(var t=0;t<e.length;t++){var n=e[t],i=n.row,r=this.$annotations[i];r||(r=this.$annotations[i]={text:[]});var o=n.text;o=o?s.escapeHTML(o):n.html||"",-1===r.text.indexOf(o)&&r.text.push(o);var a=n.type;"error"==a?r.className=" ace_error":"warning"==a&&" ace_error"!=r.className?r.className=" ace_warning":"info"!=a||r.className||(r.className=" ace_info")}},this.$updateAnnotations=function(e){if(this.$annotations.length){var t=e.start.row,n=e.end.row-t;if(0===n);else if("remove"==e.action)this.$annotations.splice(t,n+1,null);else{var i=new Array(n+1);i.unshift(t,1),this.$annotations.splice.apply(this.$annotations,i)}}},this.update=function(e){this.config=e;var t=this.session,n=e.firstRow,i=Math.min(e.lastRow+e.gutterOffset,t.getLength()-1);this.oldLastRow=i,this.config=e,this.$lines.moveContainer(e),this.$updateCursorRow();for(var r=t.getNextFoldLine(n),s=r?r.start.row:1/0,o=null,a=-1,l=n;;){if(l>s&&(l=r.end.row+1,s=(r=t.getNextFoldLine(l,r))?r.start.row:1/0),l>i){for(;this.$lines.getLength()>a+1;)this.$lines.pop();break}(o=this.$lines.get(++a))?o.row=l:(o=this.$lines.createCell(l,e,this.session,c),this.$lines.push(o)),this.$renderCell(o,e,r,l),l++}this._signal("afterRender"),this.$updateGutterWidth(e)},this.$updateGutterWidth=function(e){var t=this.session,n=t.gutterRenderer||this.$renderer,i=t.$firstLineNumber,r=this.$lines.last()?this.$lines.last().text:"";(this.$fixedWidth||t.$useWrapMode)&&(r=t.getLength()+i-1);var s=n?n.getWidth(t,r,e):r.toString().length*e.characterWidth,o=this.$padding||this.$computePadding();(s+=o.left+o.right)===this.gutterWidth||isNaN(s)||(this.gutterWidth=s,this.element.parentNode.style.width=this.element.style.width=Math.ceil(this.gutterWidth)+"px",this._signal("changeGutterWidth",s))},this.$updateCursorRow=function(){if(this.$highlightGutterLine){var e=this.session.selection.getCursor();this.$cursorRow!==e.row&&(this.$cursorRow=e.row)}},this.updateLineHighlight=function(){if(this.$highlightGutterLine){var e=this.session.selection.cursor.row;if(this.$cursorRow=e,!this.$cursorCell||this.$cursorCell.row!=e){this.$cursorCell&&(this.$cursorCell.element.className=this.$cursorCell.element.className.replace("ace_gutter-active-line ",""));var t=this.$lines.cells;this.$cursorCell=null;for(var n=0;n<t.length;n++){var i=t[n];if(i.row>=this.$cursorRow){if(i.row>this.$cursorRow){var r=this.session.getFoldLine(this.$cursorRow);if(!(n>0&&r&&r.start.row==t[n-1].row))break;i=t[n-1]}i.element.className="ace_gutter-active-line "+i.element.className,this.$cursorCell=i;break}}}}},this.scrollLines=function(e){var t=this.config;if(this.config=e,this.$updateCursorRow(),this.$lines.pageChanged(t,e))return this.update(e);this.$lines.moveContainer(e);var n=Math.min(e.lastRow+e.gutterOffset,this.session.getLength()-1),i=this.oldLastRow;if(this.oldLastRow=n,!t||i<e.firstRow)return this.update(e);if(n<t.firstRow)return this.update(e);if(t.firstRow<e.firstRow)for(var r=this.session.getFoldedRowCount(t.firstRow,e.firstRow-1);r>0;r--)this.$lines.shift();if(i>n)for(r=this.session.getFoldedRowCount(n+1,i);r>0;r--)this.$lines.pop();e.firstRow<t.firstRow&&this.$lines.unshift(this.$renderLines(e,e.firstRow,t.firstRow-1)),n>i&&this.$lines.push(this.$renderLines(e,i+1,n)),this.updateLineHighlight(),this._signal("afterRender"),this.$updateGutterWidth(e)},this.$renderLines=function(e,t,n){for(var i=[],r=t,s=this.session.getNextFoldLine(r),o=s?s.start.row:1/0;r>o&&(r=s.end.row+1,o=(s=this.session.getNextFoldLine(r,s))?s.start.row:1/0),!(r>n);){var a=this.$lines.createCell(r,e,this.session,c);this.$renderCell(a,e,s,r),i.push(a),r++}return i},this.$renderCell=function(e,t,n,r){var s=e.element,o=this.session,a=s.childNodes[0],l=s.childNodes[1],c=o.$firstLineNumber,u=o.$breakpoints,h=o.$decorations,d=o.gutterRenderer||this.$renderer,m=this.$showFoldWidgets&&o.foldWidgets,p=n?n.start.row:Number.MAX_VALUE,g="ace_gutter-cell ";if(this.$highlightGutterLine&&(r==this.$cursorRow||n&&r<this.$cursorRow&&r>=p&&this.$cursorRow<=n.end.row)&&(g+="ace_gutter-active-line ",this.$cursorCell!=e&&(this.$cursorCell&&(this.$cursorCell.element.className=this.$cursorCell.element.className.replace("ace_gutter-active-line ","")),this.$cursorCell=e)),u[r]&&(g+=u[r]),h[r]&&(g+=h[r]),this.$annotations[r]&&(g+=this.$annotations[r].className),s.className!=g&&(s.className=g),m){var f=m[r];null==f&&(f=m[r]=o.getFoldWidget(r))}if(f){g="ace_fold-widget ace_"+f,"start"==f&&r==p&&r<n.end.row?g+=" ace_closed":g+=" ace_open",l.className!=g&&(l.className=g);var E=t.lineHeight+"px";i.setStyle(l.style,"height",E),i.setStyle(l.style,"display","inline-block")}else l&&i.setStyle(l.style,"display","none");var v=(d?d.getText(o,r):r+c).toString();return v!==a.data&&(a.data=v),i.setStyle(e.element.style,"height",this.$lines.computeLineHeight(r,t,o)+"px"),i.setStyle(e.element.style,"top",this.$lines.computeLineTop(r,t,o)+"px"),e.text=v,e},this.$fixedWidth=!1,this.$highlightGutterLine=!0,this.$renderer="",this.setHighlightGutterLine=function(e){this.$highlightGutterLine=e},this.$showLineNumbers=!0,this.$renderer="",this.setShowLineNumbers=function(e){this.$renderer=!e&&{getWidth:function(){return 0},getText:function(){return""}}},this.getShowLineNumbers=function(){return this.$showLineNumbers},this.$showFoldWidgets=!0,this.setShowFoldWidgets=function(e){e?i.addCssClass(this.element,"ace_folding-enabled"):i.removeCssClass(this.element,"ace_folding-enabled"),this.$showFoldWidgets=e,this.$padding=null},this.getShowFoldWidgets=function(){return this.$showFoldWidgets},this.$computePadding=function(){if(!this.element.firstChild)return{left:0,right:0};var e=i.computedStyle(this.element.firstChild);return this.$padding={},this.$padding.left=(parseInt(e.borderLeftWidth)||0)+(parseInt(e.paddingLeft)||0)+1,this.$padding.right=(parseInt(e.borderRightWidth)||0)+(parseInt(e.paddingRight)||0),this.$padding},this.getRegion=function(e){var t=this.$padding||this.$computePadding(),n=this.element.getBoundingClientRect();return e.x<t.left+n.left?"markers":this.$showFoldWidgets&&e.x>n.right-t.right?"foldWidgets":void 0}}).call(l.prototype),t.Gutter=l})),ace.define("ace/layer/marker",["require","exports","module","ace/range","ace/lib/dom"],(function(e,t,n){"use strict";var i=e("../range").Range,r=e("../lib/dom"),s=function(e){this.element=r.createElement("div"),this.element.className="ace_layer ace_marker-layer",e.appendChild(this.element)};(function(){this.$padding=0,this.setPadding=function(e){this.$padding=e},this.setSession=function(e){this.session=e},this.setMarkers=function(e){this.markers=e},this.elt=function(e,t){var n=-1!=this.i&&this.element.childNodes[this.i];n?this.i++:(n=document.createElement("div"),this.element.appendChild(n),this.i=-1),n.style.cssText=t,n.className=e},this.update=function(e){if(e){var t;for(var n in this.config=e,this.i=0,this.markers){var i=this.markers[n];if(i.range){var r=i.range.clipRows(e.firstRow,e.lastRow);if(!r.isEmpty())if(r=r.toScreenRange(this.session),i.renderer){var s=this.$getTop(r.start.row,e),o=this.$padding+r.start.column*e.characterWidth;i.renderer(t,r,o,s,e)}else"fullLine"==i.type?this.drawFullLineMarker(t,r,i.clazz,e):"screenLine"==i.type?this.drawScreenLineMarker(t,r,i.clazz,e):r.isMultiLine()?"text"==i.type?this.drawTextMarker(t,r,i.clazz,e):this.drawMultiLineMarker(t,r,i.clazz,e):this.drawSingleLineMarker(t,r,i.clazz+" ace_start ace_br15",e)}else i.update(t,this,this.session,e)}if(-1!=this.i)for(;this.i<this.element.childElementCount;)this.element.removeChild(this.element.lastChild)}},this.$getTop=function(e,t){return(e-t.firstRowScreen)*t.lineHeight},this.drawTextMarker=function(e,t,n,r,s){for(var o=this.session,a=t.start.row,l=t.end.row,c=a,u=0,h=0,d=o.getScreenLastRowColumn(c),m=new i(c,t.start.column,c,h);c<=l;c++)m.start.row=m.end.row=c,m.start.column=c==a?t.start.column:o.getRowWrapIndent(c),m.end.column=d,u=h,h=d,d=c+1<l?o.getScreenLastRowColumn(c+1):c==l?0:t.end.column,this.drawSingleLineMarker(e,m,n+(c==a?" ace_start":"")+" ace_br"+((c==a||c==a+1&&t.start.column?1:0)|(u<h?2:0)|(h>d?4:0)|(c==l?8:0)),r,c==l?0:1,s)},this.drawMultiLineMarker=function(e,t,n,i,r){var s=this.$padding,o=i.lineHeight,a=this.$getTop(t.start.row,i),l=s+t.start.column*i.characterWidth;if(r=r||"",this.session.$bidiHandler.isBidiRow(t.start.row)?((c=t.clone()).end.row=c.start.row,c.end.column=this.session.getLine(c.start.row).length,this.drawBidiSingleLineMarker(e,c,n+" ace_br1 ace_start",i,null,r)):this.elt(n+" ace_br1 ace_start","height:"+o+"px;right:0;top:"+a+"px;left:"+l+"px;"+(r||"")),this.session.$bidiHandler.isBidiRow(t.end.row)){var c;(c=t.clone()).start.row=c.end.row,c.start.column=0,this.drawBidiSingleLineMarker(e,c,n+" ace_br12",i,null,r)}else{a=this.$getTop(t.end.row,i);var u=t.end.column*i.characterWidth;this.elt(n+" ace_br12","height:"+o+"px;width:"+u+"px;top:"+a+"px;left:"+s+"px;"+(r||""))}if(!((o=(t.end.row-t.start.row-1)*i.lineHeight)<=0)){a=this.$getTop(t.start.row+1,i);var h=(t.start.column?1:0)|(t.end.column?0:8);this.elt(n+(h?" ace_br"+h:""),"height:"+o+"px;right:0;top:"+a+"px;left:"+s+"px;"+(r||""))}},this.drawSingleLineMarker=function(e,t,n,i,r,s){if(this.session.$bidiHandler.isBidiRow(t.start.row))return this.drawBidiSingleLineMarker(e,t,n,i,r,s);var o=i.lineHeight,a=(t.end.column+(r||0)-t.start.column)*i.characterWidth,l=this.$getTop(t.start.row,i),c=this.$padding+t.start.column*i.characterWidth;this.elt(n,"height:"+o+"px;width:"+a+"px;top:"+l+"px;left:"+c+"px;"+(s||""))},this.drawBidiSingleLineMarker=function(e,t,n,i,r,s){var o=i.lineHeight,a=this.$getTop(t.start.row,i),l=this.$padding;this.session.$bidiHandler.getSelections(t.start.column,t.end.column).forEach((function(e){this.elt(n,"height:"+o+"px;width:"+e.width+(r||0)+"px;top:"+a+"px;left:"+(l+e.left)+"px;"+(s||""))}),this)},this.drawFullLineMarker=function(e,t,n,i,r){var s=this.$getTop(t.start.row,i),o=i.lineHeight;t.start.row!=t.end.row&&(o+=this.$getTop(t.end.row,i)-s),this.elt(n,"height:"+o+"px;top:"+s+"px;left:0;right:0;"+(r||""))},this.drawScreenLineMarker=function(e,t,n,i,r){var s=this.$getTop(t.start.row,i),o=i.lineHeight;this.elt(n,"height:"+o+"px;top:"+s+"px;left:0;right:0;"+(r||""))}}).call(s.prototype),t.Marker=s})),ace.define("ace/layer/text",["require","exports","module","ace/lib/oop","ace/lib/dom","ace/lib/lang","ace/layer/lines","ace/lib/event_emitter"],(function(e,t,n){"use strict";var i=e("../lib/oop"),r=e("../lib/dom"),s=e("../lib/lang"),o=e("./lines").Lines,a=e("../lib/event_emitter").EventEmitter,l=function(e){this.dom=r,this.element=this.dom.createElement("div"),this.element.className="ace_layer ace_text-layer",e.appendChild(this.element),this.$updateEolChar=this.$updateEolChar.bind(this),this.$lines=new o(this.element)};(function(){i.implement(this,a),this.EOF_CHAR="¶",this.EOL_CHAR_LF="¬",this.EOL_CHAR_CRLF="¤",this.EOL_CHAR=this.EOL_CHAR_LF,this.TAB_CHAR="—",this.SPACE_CHAR="·",this.$padding=0,this.MAX_LINE_LENGTH=1e4,this.$updateEolChar=function(){var e=this.session.doc,t="\n"==e.getNewLineCharacter()&&"windows"!=e.getNewLineMode()?this.EOL_CHAR_LF:this.EOL_CHAR_CRLF;if(this.EOL_CHAR!=t)return this.EOL_CHAR=t,!0},this.setPadding=function(e){this.$padding=e,this.element.style.margin="0 "+e+"px"},this.getLineHeight=function(){return this.$fontMetrics.$characterSize.height||0},this.getCharacterWidth=function(){return this.$fontMetrics.$characterSize.width||0},this.$setFontMetrics=function(e){this.$fontMetrics=e,this.$fontMetrics.on("changeCharacterSize",function(e){this._signal("changeCharacterSize",e)}.bind(this)),this.$pollSizeChanges()},this.checkForSizeChanges=function(){this.$fontMetrics.checkForSizeChanges()},this.$pollSizeChanges=function(){return this.$pollSizeChangesTimer=this.$fontMetrics.$pollSizeChanges()},this.setSession=function(e){this.session=e,e&&this.$computeTabString()},this.showInvisibles=!1,this.setShowInvisibles=function(e){return this.showInvisibles!=e&&(this.showInvisibles=e,this.$computeTabString(),!0)},this.displayIndentGuides=!0,this.setDisplayIndentGuides=function(e){return this.displayIndentGuides!=e&&(this.displayIndentGuides=e,this.$computeTabString(),!0)},this.$tabStrings=[],this.onChangeTabSize=this.$computeTabString=function(){var e=this.session.getTabSize();this.tabSize=e;for(var t=this.$tabStrings=[0],n=1;n<e+1;n++)this.showInvisibles?((i=this.dom.createElement("span")).className="ace_invisible ace_invisible_tab",i.textContent=s.stringRepeat(this.TAB_CHAR,n),t.push(i)):t.push(this.dom.createTextNode(s.stringRepeat(" ",n),this.element));if(this.displayIndentGuides){this.$indentGuideRe=/\s\S| \t|\t |\s$/;var i,r="ace_indent-guide",o="",a="";if(this.showInvisibles){r+=" ace_invisible",o=" ace_invisible_space",a=" ace_invisible_tab";var l=s.stringRepeat(this.SPACE_CHAR,this.tabSize),c=s.stringRepeat(this.TAB_CHAR,this.tabSize)}else c=l=s.stringRepeat(" ",this.tabSize);(i=this.dom.createElement("span")).className=r+o,i.textContent=l,this.$tabStrings[" "]=i,(i=this.dom.createElement("span")).className=r+a,i.textContent=c,this.$tabStrings["\t"]=i}},this.updateLines=function(e,t,n){if(this.config.lastRow!=e.lastRow||this.config.firstRow!=e.firstRow)return this.update(e);this.config=e;for(var i=Math.max(t,e.firstRow),r=Math.min(n,e.lastRow),s=this.element.childNodes,o=0,a=e.firstRow;a<i;a++){if(l=this.session.getFoldLine(a)){if(l.containsRow(i)){i=l.start.row;break}a=l.end.row}o++}for(var l,c=!1,u=(a=i,(l=this.session.getNextFoldLine(a))?l.start.row:1/0);a>u&&(a=l.end.row+1,u=(l=this.session.getNextFoldLine(a,l))?l.start.row:1/0),!(a>r);){var h=s[o++];if(h){this.dom.removeChildren(h),this.$renderLine(h,a,a==u&&l),c&&(h.style.top=this.$lines.computeLineTop(a,e,this.session)+"px");var d=e.lineHeight*this.session.getRowLength(a)+"px";h.style.height!=d&&(c=!0,h.style.height=d)}a++}if(c)for(;o<this.$lines.cells.length;){var m=this.$lines.cells[o++];m.element.style.top=this.$lines.computeLineTop(m.row,e,this.session)+"px"}},this.scrollLines=function(e){var t=this.config;if(this.config=e,this.$lines.pageChanged(t,e))return this.update(e);this.$lines.moveContainer(e);var n=e.lastRow,i=t?t.lastRow:-1;if(!t||i<e.firstRow)return this.update(e);if(n<t.firstRow)return this.update(e);if(!t||t.lastRow<e.firstRow)return this.update(e);if(e.lastRow<t.firstRow)return this.update(e);if(t.firstRow<e.firstRow)for(var r=this.session.getFoldedRowCount(t.firstRow,e.firstRow-1);r>0;r--)this.$lines.shift();if(t.lastRow>e.lastRow)for(r=this.session.getFoldedRowCount(e.lastRow+1,t.lastRow);r>0;r--)this.$lines.pop();e.firstRow<t.firstRow&&this.$lines.unshift(this.$renderLinesFragment(e,e.firstRow,t.firstRow-1)),e.lastRow>t.lastRow&&this.$lines.push(this.$renderLinesFragment(e,t.lastRow+1,e.lastRow))},this.$renderLinesFragment=function(e,t,n){for(var i=[],s=t,o=this.session.getNextFoldLine(s),a=o?o.start.row:1/0;s>a&&(s=o.end.row+1,a=(o=this.session.getNextFoldLine(s,o))?o.start.row:1/0),!(s>n);){var l=this.$lines.createCell(s,e,this.session),c=l.element;this.dom.removeChildren(c),r.setStyle(c.style,"height",this.$lines.computeLineHeight(s,e,this.session)+"px"),r.setStyle(c.style,"top",this.$lines.computeLineTop(s,e,this.session)+"px"),this.$renderLine(c,s,s==a&&o),this.$useLineGroups()?c.className="ace_line_group":c.className="ace_line",i.push(l),s++}return i},this.update=function(e){this.$lines.moveContainer(e),this.config=e;for(var t=e.firstRow,n=e.lastRow,i=this.$lines;i.getLength();)i.pop();i.push(this.$renderLinesFragment(e,t,n))},this.$textToken={text:!0,rparen:!0,lparen:!0},this.$renderToken=function(e,t,n,i){for(var r,o=this,a=/(\t)|( +)|([\x00-\x1f\x80-\xa0\xad\u1680\u180E\u2000-\u200f\u2028\u2029\u202F\u205F\uFEFF\uFFF9-\uFFFC]+)|(\u3000)|([\u1100-\u115F\u11A3-\u11A7\u11FA-\u11FF\u2329-\u232A\u2E80-\u2E99\u2E9B-\u2EF3\u2F00-\u2FD5\u2FF0-\u2FFB\u3001-\u303E\u3041-\u3096\u3099-\u30FF\u3105-\u312D\u3131-\u318E\u3190-\u31BA\u31C0-\u31E3\u31F0-\u321E\u3220-\u3247\u3250-\u32FE\u3300-\u4DBF\u4E00-\uA48C\uA490-\uA4C6\uA960-\uA97C\uAC00-\uD7A3\uD7B0-\uD7C6\uD7CB-\uD7FB\uF900-\uFAFF\uFE10-\uFE19\uFE30-\uFE52\uFE54-\uFE66\uFE68-\uFE6B\uFF01-\uFF60\uFFE0-\uFFE6]|[\uD800-\uDBFF][\uDC00-\uDFFF])/g,l=this.dom.createFragment(this.element),c=0;r=a.exec(i);){var u=r[1],h=r[2],d=r[3],m=r[4],p=r[5];if(o.showInvisibles||!h){var g=c!=r.index?i.slice(c,r.index):"";if(c=r.index+r[0].length,g&&l.appendChild(this.dom.createTextNode(g,this.element)),u){var f=o.session.getScreenTabSize(t+r.index);l.appendChild(o.$tabStrings[f].cloneNode(!0)),t+=f-1}else h?o.showInvisibles?((v=this.dom.createElement("span")).className="ace_invisible ace_invisible_space",v.textContent=s.stringRepeat(o.SPACE_CHAR,h.length),l.appendChild(v)):l.appendChild(this.com.createTextNode(h,this.element)):d?((v=this.dom.createElement("span")).className="ace_invisible ace_invisible_space ace_invalid",v.textContent=s.stringRepeat(o.SPACE_CHAR,d.length),l.appendChild(v)):m?(t+=1,(v=this.dom.createElement("span")).style.width=2*o.config.characterWidth+"px",v.className=o.showInvisibles?"ace_cjk ace_invisible ace_invisible_space":"ace_cjk",v.textContent=o.showInvisibles?o.SPACE_CHAR:m,l.appendChild(v)):p&&(t+=1,(v=this.dom.createElement("span")).style.width=2*o.config.characterWidth+"px",v.className="ace_cjk",v.textContent=p,l.appendChild(v))}}if(l.appendChild(this.dom.createTextNode(c?i.slice(c):i,this.element)),this.$textToken[n.type])e.appendChild(l);else{var E="ace_"+n.type.replace(/\./g," ace_"),v=this.dom.createElement("span");"fold"==n.type&&(v.style.width=n.value.length*this.config.characterWidth+"px"),v.className=E,v.appendChild(l),e.appendChild(v)}return t+i.length},this.renderIndentGuide=function(e,t,n){var i=t.search(this.$indentGuideRe);if(i<=0||i>=n)return t;if(" "==t[0]){for(var r=(i-=i%this.tabSize)/this.tabSize,s=0;s<r;s++)e.appendChild(this.$tabStrings[" "].cloneNode(!0));return t.substr(i)}if("\t"==t[0]){for(s=0;s<i;s++)e.appendChild(this.$tabStrings["\t"].cloneNode(!0));return t.substr(i)}return t},this.$createLineElement=function(e){var t=this.dom.createElement("div");return t.className="ace_line",t.style.height=this.config.lineHeight+"px",t},this.$renderWrappedLine=function(e,t,n){var i=0,r=0,o=n[0],a=0,l=this.$createLineElement();e.appendChild(l);for(var c=0;c<t.length;c++){var u=t[c],h=u.value;if(0==c&&this.displayIndentGuides){if(i=h.length,!(h=this.renderIndentGuide(l,h,o)))continue;i-=h.length}if(i+h.length<o)a=this.$renderToken(l,a,u,h),i+=h.length;else{for(;i+h.length>=o;)a=this.$renderToken(l,a,u,h.substring(0,o-i)),h=h.substring(o-i),i=o,l=this.$createLineElement(),e.appendChild(l),l.appendChild(this.dom.createTextNode(s.stringRepeat(" ",n.indent),this.element)),a=0,o=n[++r]||Number.MAX_VALUE;0!=h.length&&(i+=h.length,a=this.$renderToken(l,a,u,h))}}n[n.length-1]>this.MAX_LINE_LENGTH&&this.$renderOverflowMessage(l,a,null,"",!0)},this.$renderSimpleLine=function(e,t){var n=0,i=t[0],r=i.value;this.displayIndentGuides&&(r=this.renderIndentGuide(e,r)),r&&(n=this.$renderToken(e,n,i,r));for(var s=1;s<t.length;s++){if(n+(r=(i=t[s]).value).length>this.MAX_LINE_LENGTH)return this.$renderOverflowMessage(e,n,i,r);n=this.$renderToken(e,n,i,r)}},this.$renderOverflowMessage=function(e,t,n,i,r){n&&this.$renderToken(e,t,n,i.slice(0,this.MAX_LINE_LENGTH-t));var s=this.dom.createElement("span");s.className="ace_inline_button ace_keyword ace_toggle_wrap",s.textContent=r?"<hide>":"<click to see more...>",e.appendChild(s)},this.$renderLine=function(e,t,n){if(n||0==n||(n=this.session.getFoldLine(t)),n)var i=this.$getFoldLineTokens(t,n);else i=this.session.getTokens(t);var r=e;if(i.length){var s=this.session.getRowSplitData(t);s&&s.length?(this.$renderWrappedLine(e,i,s),r=e.lastChild):(r=e,this.$useLineGroups()&&(r=this.$createLineElement(),e.appendChild(r)),this.$renderSimpleLine(r,i))}else this.$useLineGroups()&&(r=this.$createLineElement(),e.appendChild(r));if(this.showInvisibles&&r){n&&(t=n.end.row);var o=this.dom.createElement("span");o.className="ace_invisible ace_invisible_eol",o.textContent=t==this.session.getLength()-1?this.EOF_CHAR:this.EOL_CHAR,r.appendChild(o)}},this.$getFoldLineTokens=function(e,t){var n=this.session,i=[],r=n.getTokens(e);return t.walk((function(e,t,s,o,a){null!=e?i.push({type:"fold",value:e}):(a&&(r=n.getTokens(t)),r.length&&function(e,t,n){for(var r=0,s=0;s+e[r].value.length<t;)if(s+=e[r].value.length,++r==e.length)return;for(s!=t&&((o=e[r].value.substring(t-s)).length>n-t&&(o=o.substring(0,n-t)),i.push({type:e[r].type,value:o}),s=t+o.length,r+=1);s<n&&r<e.length;){var o;(o=e[r].value).length+s>n?i.push({type:e[r].type,value:o.substring(0,n-s)}):i.push(e[r]),s+=o.length,r+=1}}(r,o,s))}),t.end.row,this.session.getLine(t.end.row).length),i},this.$useLineGroups=function(){return this.session.getUseWrapMode()},this.destroy=function(){}}).call(l.prototype),t.Text=l})),ace.define("ace/layer/cursor",["require","exports","module","ace/lib/dom"],(function(e,t,n){"use strict";var i=e("../lib/dom"),r=function(e){this.element=i.createElement("div"),this.element.className="ace_layer ace_cursor-layer",e.appendChild(this.element),this.isVisible=!1,this.isBlinking=!0,this.blinkInterval=1e3,this.smoothBlinking=!1,this.cursors=[],this.cursor=this.addCursor(),i.addCssClass(this.element,"ace_hidden-cursors"),this.$updateCursors=this.$updateOpacity.bind(this)};(function(){this.$updateOpacity=function(e){for(var t=this.cursors,n=t.length;n--;)i.setStyle(t[n].style,"opacity",e?"":"0")},this.$startCssAnimation=function(){for(var e=this.cursors,t=e.length;t--;)e[t].style.animationDuration=this.blinkInterval+"ms";setTimeout(function(){i.addCssClass(this.element,"ace_animate-blinking")}.bind(this))},this.$stopCssAnimation=function(){i.removeCssClass(this.element,"ace_animate-blinking")},this.$padding=0,this.setPadding=function(e){this.$padding=e},this.setSession=function(e){this.session=e},this.setBlinking=function(e){e!=this.isBlinking&&(this.isBlinking=e,this.restartTimer())},this.setBlinkInterval=function(e){e!=this.blinkInterval&&(this.blinkInterval=e,this.restartTimer())},this.setSmoothBlinking=function(e){e!=this.smoothBlinking&&(this.smoothBlinking=e,i.setCssClass(this.element,"ace_smooth-blinking",e),this.$updateCursors(!0),this.restartTimer())},this.addCursor=function(){var e=i.createElement("div");return e.className="ace_cursor",this.element.appendChild(e),this.cursors.push(e),e},this.removeCursor=function(){if(this.cursors.length>1){var e=this.cursors.pop();return e.parentNode.removeChild(e),e}},this.hideCursor=function(){this.isVisible=!1,i.addCssClass(this.element,"ace_hidden-cursors"),this.restartTimer()},this.showCursor=function(){this.isVisible=!0,i.removeCssClass(this.element,"ace_hidden-cursors"),this.restartTimer()},this.restartTimer=function(){var e=this.$updateCursors;if(clearInterval(this.intervalId),clearTimeout(this.timeoutId),this.$stopCssAnimation(),this.smoothBlinking&&i.removeCssClass(this.element,"ace_smooth-blinking"),e(!0),this.isBlinking&&this.blinkInterval&&this.isVisible)if(this.smoothBlinking&&setTimeout(function(){i.addCssClass(this.element,"ace_smooth-blinking")}.bind(this)),i.HAS_CSS_ANIMATION)this.$startCssAnimation();else{var t=function(){this.timeoutId=setTimeout((function(){e(!1)}),.6*this.blinkInterval)}.bind(this);this.intervalId=setInterval((function(){e(!0),t()}),this.blinkInterval),t()}else this.$stopCssAnimation()},this.getPixelPosition=function(e,t){if(!this.config||!this.session)return{left:0,top:0};e||(e=this.session.selection.getCursor());var n=this.session.documentToScreenPosition(e);return{left:this.$padding+(this.session.$bidiHandler.isBidiRow(n.row,e.row)?this.session.$bidiHandler.getPosLeft(n.column):n.column*this.config.characterWidth),top:(n.row-(t?this.config.firstRowScreen:0))*this.config.lineHeight}},this.isCursorInView=function(e,t){return e.top>=0&&e.top<t.maxHeight},this.update=function(e){this.config=e;var t=this.session.$selectionMarkers,n=0,r=0;void 0!==t&&0!==t.length||(t=[{cursor:null}]),n=0;for(var s=t.length;n<s;n++){var o=this.getPixelPosition(t[n].cursor,!0);if(!((o.top>e.height+e.offset||o.top<0)&&n>1)){var a=this.cursors[r++]||this.addCursor(),l=a.style;this.drawCursor?this.drawCursor(a,o,e,t[n],this.session):this.isCursorInView(o,e)?(i.setStyle(l,"display","block"),i.translate(a,o.left,o.top),i.setStyle(l,"width",Math.round(e.characterWidth)+"px"),i.setStyle(l,"height",e.lineHeight+"px")):i.setStyle(l,"display","none")}}for(;this.cursors.length>r;)this.removeCursor();var c=this.session.getOverwrite();this.$setOverwrite(c),this.$pixelPos=o,this.restartTimer()},this.drawCursor=null,this.$setOverwrite=function(e){e!=this.overwrite&&(this.overwrite=e,e?i.addCssClass(this.element,"ace_overwrite-cursors"):i.removeCssClass(this.element,"ace_overwrite-cursors"))},this.destroy=function(){clearInterval(this.intervalId),clearTimeout(this.timeoutId)}}).call(r.prototype),t.Cursor=r})),ace.define("ace/scrollbar",["require","exports","module","ace/lib/oop","ace/lib/dom","ace/lib/event","ace/lib/event_emitter"],(function(e,t,n){"use strict";var i=e("./lib/oop"),r=e("./lib/dom"),s=e("./lib/event"),o=e("./lib/event_emitter").EventEmitter,a=32768,l=function(e){this.element=r.createElement("div"),this.element.className="ace_scrollbar ace_scrollbar"+this.classSuffix,this.inner=r.createElement("div"),this.inner.className="ace_scrollbar-inner",this.inner.textContent=" ",this.element.appendChild(this.inner),e.appendChild(this.element),this.setVisible(!1),this.skipEvent=!1,s.addListener(this.element,"scroll",this.onScroll.bind(this)),s.addListener(this.element,"mousedown",s.preventDefault)};(function(){i.implement(this,o),this.setVisible=function(e){this.element.style.display=e?"":"none",this.isVisible=e,this.coeff=1}}).call(l.prototype);var c=function(e,t){l.call(this,e),this.scrollTop=0,this.scrollHeight=0,t.$scrollbarWidth=this.width=r.scrollbarWidth(e.ownerDocument),this.inner.style.width=this.element.style.width=(this.width||15)+5+"px",this.$minWidth=0};i.inherits(c,l),function(){this.classSuffix="-v",this.onScroll=function(){if(!this.skipEvent){if(this.scrollTop=this.element.scrollTop,1!=this.coeff){var e=this.element.clientHeight/this.scrollHeight;this.scrollTop=this.scrollTop*(1-e)/(this.coeff-e)}this._emit("scroll",{data:this.scrollTop})}this.skipEvent=!1},this.getWidth=function(){return Math.max(this.isVisible?this.width:0,this.$minWidth||0)},this.setHeight=function(e){this.element.style.height=e+"px"},this.setInnerHeight=this.setScrollHeight=function(e){this.scrollHeight=e,e>a?(this.coeff=a/e,e=a):1!=this.coeff&&(this.coeff=1),this.inner.style.height=e+"px"},this.setScrollTop=function(e){this.scrollTop!=e&&(this.skipEvent=!0,this.scrollTop=e,this.element.scrollTop=e*this.coeff)}}.call(c.prototype);var u=function(e,t){l.call(this,e),this.scrollLeft=0,this.height=t.$scrollbarWidth,this.inner.style.height=this.element.style.height=(this.height||15)+5+"px"};i.inherits(u,l),function(){this.classSuffix="-h",this.onScroll=function(){this.skipEvent||(this.scrollLeft=this.element.scrollLeft,this._emit("scroll",{data:this.scrollLeft})),this.skipEvent=!1},this.getHeight=function(){return this.isVisible?this.height:0},this.setWidth=function(e){this.element.style.width=e+"px"},this.setInnerWidth=function(e){this.inner.style.width=e+"px"},this.setScrollWidth=function(e){this.inner.style.width=e+"px"},this.setScrollLeft=function(e){this.scrollLeft!=e&&(this.skipEvent=!0,this.scrollLeft=this.element.scrollLeft=e)}}.call(u.prototype),t.ScrollBar=c,t.ScrollBarV=c,t.ScrollBarH=u,t.VScrollBar=c,t.HScrollBar=u})),ace.define("ace/renderloop",["require","exports","module","ace/lib/event"],(function(e,t,n){"use strict";var i=e("./lib/event"),r=function(e,t){this.onRender=e,this.pending=!1,this.changes=0,this.$recursionLimit=2,this.window=t||window;var n=this;this._flush=function(e){n.pending=!1;var t=n.changes;if(t&&(i.blockIdle(100),n.changes=0,n.onRender(t)),n.changes){if(n.$recursionLimit--<0)return;n.schedule()}else n.$recursionLimit=2}};(function(){this.schedule=function(e){this.changes=this.changes|e,this.changes&&!this.pending&&(i.nextFrame(this._flush),this.pending=!0)},this.clear=function(e){var t=this.changes;return this.changes=0,t}}).call(r.prototype),t.RenderLoop=r})),ace.define("ace/layer/font_metrics",["require","exports","module","ace/lib/oop","ace/lib/dom","ace/lib/lang","ace/lib/event","ace/lib/useragent","ace/lib/event_emitter"],(function(e,t,n){var i=e("../lib/oop"),r=e("../lib/dom"),s=e("../lib/lang"),o=e("../lib/event"),a=e("../lib/useragent"),l=e("../lib/event_emitter").EventEmitter,c=256,u="function"==typeof ResizeObserver,h=200,d=t.FontMetrics=function(e){this.el=r.createElement("div"),this.$setMeasureNodeStyles(this.el.style,!0),this.$main=r.createElement("div"),this.$setMeasureNodeStyles(this.$main.style),this.$measureNode=r.createElement("div"),this.$setMeasureNodeStyles(this.$measureNode.style),this.el.appendChild(this.$main),this.el.appendChild(this.$measureNode),e.appendChild(this.el),this.$measureNode.innerHTML=s.stringRepeat("X",c),this.$characterSize={width:0,height:0},u?this.$addObserver():this.checkForSizeChanges()};(function(){i.implement(this,l),this.$characterSize={width:0,height:0},this.$setMeasureNodeStyles=function(e,t){e.width=e.height="auto",e.left=e.top="0px",e.visibility="hidden",e.position="absolute",e.whiteSpace="pre",a.isIE<8?e["font-family"]="inherit":e.font="inherit",e.overflow=t?"hidden":"visible"},this.checkForSizeChanges=function(e){if(void 0===e&&(e=this.$measureSizes()),e&&(this.$characterSize.width!==e.width||this.$characterSize.height!==e.height)){this.$measureNode.style.fontWeight="bold";var t=this.$measureSizes();this.$measureNode.style.fontWeight="",this.$characterSize=e,this.charSizes=Object.create(null),this.allowBoldFonts=t&&t.width===e.width&&t.height===e.height,this._emit("changeCharacterSize",{data:e})}},this.$addObserver=function(){var e=this;this.$observer=new window.ResizeObserver((function(t){var n=t[0].contentRect;e.checkForSizeChanges({height:n.height,width:n.width/c})})),this.$observer.observe(this.$measureNode)},this.$pollSizeChanges=function(){if(this.$pollSizeChangesTimer||this.$observer)return this.$pollSizeChangesTimer;var e=this;return this.$pollSizeChangesTimer=o.onIdle((function t(){e.checkForSizeChanges(),o.onIdle(t,500)}),500)},this.setPolling=function(e){e?this.$pollSizeChanges():this.$pollSizeChangesTimer&&(clearInterval(this.$pollSizeChangesTimer),this.$pollSizeChangesTimer=0)},this.$measureSizes=function(e){var t={height:(e||this.$measureNode).clientHeight,width:(e||this.$measureNode).clientWidth/c};return 0===t.width||0===t.height?null:t},this.$measureCharWidth=function(e){return this.$main.innerHTML=s.stringRepeat(e,c),this.$main.getBoundingClientRect().width/c},this.getCharacterWidth=function(e){var t=this.charSizes[e];return void 0===t&&(t=this.charSizes[e]=this.$measureCharWidth(e)/this.$characterSize.width),t},this.destroy=function(){clearInterval(this.$pollSizeChangesTimer),this.$observer&&this.$observer.disconnect(),this.el&&this.el.parentNode&&this.el.parentNode.removeChild(this.el)},this.$getZoom=function e(t){return t?(window.getComputedStyle(t).zoom||1)*e(t.parentElement):1},this.$initTransformMeasureNodes=function(){var e=function(e,t){return["div",{style:"position: absolute;top:"+e+"px;left:"+t+"px;"}]};this.els=r.buildDom([e(0,0),e(h,0),e(0,h),e(h,h)],this.el)},this.transformCoordinates=function(e,t){function n(e,t,n){var i=e[1]*t[0]-e[0]*t[1];return[(-t[1]*n[0]+t[0]*n[1])/i,(+e[1]*n[0]-e[0]*n[1])/i]}function i(e,t){return[e[0]-t[0],e[1]-t[1]]}function r(e,t){return[e[0]+t[0],e[1]+t[1]]}function s(e,t){return[e*t[0],e*t[1]]}function o(e){var t=e.getBoundingClientRect();return[t.left,t.top]}e&&(e=s(1/this.$getZoom(this.el),e)),this.els||this.$initTransformMeasureNodes();var a=o(this.els[0]),l=o(this.els[1]),c=o(this.els[2]),u=o(this.els[3]),d=n(i(u,l),i(u,c),i(r(l,c),r(u,a))),m=s(1+d[0],i(l,a)),p=s(1+d[1],i(c,a));if(t){var g=t,f=d[0]*g[0]/h+d[1]*g[1]/h+1,E=r(s(g[0],m),s(g[1],p));return r(s(1/f/h,E),a)}var v=i(e,a),_=n(i(m,s(d[0],v)),i(p,s(d[1],v)),v);return s(h,_)}}).call(d.prototype)})),ace.define("ace/virtual_renderer",["require","exports","module","ace/lib/oop","ace/lib/dom","ace/config","ace/layer/gutter","ace/layer/marker","ace/layer/text","ace/layer/cursor","ace/scrollbar","ace/scrollbar","ace/renderloop","ace/layer/font_metrics","ace/lib/event_emitter","ace/lib/useragent"],(function(e,t,n){"use strict";var i=e("./lib/oop"),r=e("./lib/dom"),s=e("./config"),o=e("./layer/gutter").Gutter,a=e("./layer/marker").Marker,l=e("./layer/text").Text,c=e("./layer/cursor").Cursor,u=e("./scrollbar").HScrollBar,h=e("./scrollbar").VScrollBar,d=e("./renderloop").RenderLoop,m=e("./layer/font_metrics").FontMetrics,p=e("./lib/event_emitter").EventEmitter,g='.ace_br1 {border-top-left-radius    : 3px;}.ace_br2 {border-top-right-radius   : 3px;}.ace_br3 {border-top-left-radius    : 3px; border-top-right-radius:    3px;}.ace_br4 {border-bottom-right-radius: 3px;}.ace_br5 {border-top-left-radius    : 3px; border-bottom-right-radius: 3px;}.ace_br6 {border-top-right-radius   : 3px; border-bottom-right-radius: 3px;}.ace_br7 {border-top-left-radius    : 3px; border-top-right-radius:    3px; border-bottom-right-radius: 3px;}.ace_br8 {border-bottom-left-radius : 3px;}.ace_br9 {border-top-left-radius    : 3px; border-bottom-left-radius:  3px;}.ace_br10{border-top-right-radius   : 3px; border-bottom-left-radius:  3px;}.ace_br11{border-top-left-radius    : 3px; border-top-right-radius:    3px; border-bottom-left-radius:  3px;}.ace_br12{border-bottom-right-radius: 3px; border-bottom-left-radius:  3px;}.ace_br13{border-top-left-radius    : 3px; border-bottom-right-radius: 3px; border-bottom-left-radius:  3px;}.ace_br14{border-top-right-radius   : 3px; border-bottom-right-radius: 3px; border-bottom-left-radius:  3px;}.ace_br15{border-top-left-radius    : 3px; border-top-right-radius:    3px; border-bottom-right-radius: 3px; border-bottom-left-radius: 3px;}.ace_editor {position: relative;overflow: hidden;font: 12px/normal \'Monaco\', \'Menlo\', \'Ubuntu Mono\', \'Consolas\', \'source-code-pro\', monospace;direction: ltr;text-align: left;-webkit-tap-highlight-color: rgba(0, 0, 0, 0);}.ace_scroller {position: absolute;overflow: hidden;top: 0;bottom: 0;background-color: inherit;-ms-user-select: none;-moz-user-select: none;-webkit-user-select: none;user-select: none;cursor: text;}.ace_content {position: absolute;box-sizing: border-box;min-width: 100%;contain: style size layout;}.ace_dragging .ace_scroller:before{position: absolute;top: 0;left: 0;right: 0;bottom: 0;content: \'\';background: rgba(250, 250, 250, 0.01);z-index: 1000;}.ace_dragging.ace_dark .ace_scroller:before{background: rgba(0, 0, 0, 0.01);}.ace_selecting, .ace_selecting * {cursor: text !important;}.ace_gutter {position: absolute;overflow : hidden;width: auto;top: 0;bottom: 0;left: 0;cursor: default;z-index: 4;-ms-user-select: none;-moz-user-select: none;-webkit-user-select: none;user-select: none;contain: style size layout;}.ace_gutter-active-line {position: absolute;left: 0;right: 0;}.ace_scroller.ace_scroll-left {box-shadow: 17px 0 16px -16px rgba(0, 0, 0, 0.4) inset;}.ace_gutter-cell {position: absolute;top: 0;left: 0;right: 0;padding-left: 19px;padding-right: 6px;background-repeat: no-repeat;}.ace_gutter-cell.ace_error {background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAMAAAAoLQ9TAAABOFBMVEX/////////QRswFAb/Ui4wFAYwFAYwFAaWGAfDRymzOSH/PxswFAb/SiUwFAYwFAbUPRvjQiDllog5HhHdRybsTi3/Tyv9Tir+Syj/UC3////XurebMBIwFAb/RSHbPx/gUzfdwL3kzMivKBAwFAbbvbnhPx66NhowFAYwFAaZJg8wFAaxKBDZurf/RB6mMxb/SCMwFAYwFAbxQB3+RB4wFAb/Qhy4Oh+4QifbNRcwFAYwFAYwFAb/QRzdNhgwFAYwFAbav7v/Uy7oaE68MBK5LxLewr/r2NXewLswFAaxJw4wFAbkPRy2PyYwFAaxKhLm1tMwFAazPiQwFAaUGAb/QBrfOx3bvrv/VC/maE4wFAbRPBq6MRO8Qynew8Dp2tjfwb0wFAbx6eju5+by6uns4uH9/f36+vr/GkHjAAAAYnRSTlMAGt+64rnWu/bo8eAA4InH3+DwoN7j4eLi4xP99Nfg4+b+/u9B/eDs1MD1mO7+4PHg2MXa347g7vDizMLN4eG+Pv7i5evs/v79yu7S3/DV7/498Yv24eH+4ufQ3Ozu/v7+y13sRqwAAADLSURBVHjaZc/XDsFgGIBhtDrshlitmk2IrbHFqL2pvXf/+78DPokj7+Fz9qpU/9UXJIlhmPaTaQ6QPaz0mm+5gwkgovcV6GZzd5JtCQwgsxoHOvJO15kleRLAnMgHFIESUEPmawB9ngmelTtipwwfASilxOLyiV5UVUyVAfbG0cCPHig+GBkzAENHS0AstVF6bacZIOzgLmxsHbt2OecNgJC83JERmePUYq8ARGkJx6XtFsdddBQgZE2nPR6CICZhawjA4Fb/chv+399kfR+MMMDGOQAAAABJRU5ErkJggg==");background-repeat: no-repeat;background-position: 2px center;}.ace_gutter-cell.ace_warning {background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAMAAAAoLQ9TAAAAmVBMVEX///8AAAD///8AAAAAAABPSzb/5sAAAAB/blH/73z/ulkAAAAAAAD85pkAAAAAAAACAgP/vGz/rkDerGbGrV7/pkQICAf////e0IsAAAD/oED/qTvhrnUAAAD/yHD/njcAAADuv2r/nz//oTj/p064oGf/zHAAAAA9Nir/tFIAAAD/tlTiuWf/tkIAAACynXEAAAAAAAAtIRW7zBpBAAAAM3RSTlMAABR1m7RXO8Ln31Z36zT+neXe5OzooRDfn+TZ4p3h2hTf4t3k3ucyrN1K5+Xaks52Sfs9CXgrAAAAjklEQVR42o3PbQ+CIBQFYEwboPhSYgoYunIqqLn6/z8uYdH8Vmdnu9vz4WwXgN/xTPRD2+sgOcZjsge/whXZgUaYYvT8QnuJaUrjrHUQreGczuEafQCO/SJTufTbroWsPgsllVhq3wJEk2jUSzX3CUEDJC84707djRc5MTAQxoLgupWRwW6UB5fS++NV8AbOZgnsC7BpEAAAAABJRU5ErkJggg==");background-position: 2px center;}.ace_gutter-cell.ace_info {background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAAAAAA6mKC9AAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAAAJ0Uk5TAAB2k804AAAAPklEQVQY02NgIB68QuO3tiLznjAwpKTgNyDbMegwisCHZUETUZV0ZqOquBpXj2rtnpSJT1AEnnRmL2OgGgAAIKkRQap2htgAAAAASUVORK5CYII=");background-position: 2px center;}.ace_dark .ace_gutter-cell.ace_info {background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQBAMAAADt3eJSAAAAJFBMVEUAAAChoaGAgIAqKiq+vr6tra1ZWVmUlJSbm5s8PDxubm56enrdgzg3AAAAAXRSTlMAQObYZgAAAClJREFUeNpjYMAPdsMYHegyJZFQBlsUlMFVCWUYKkAZMxZAGdxlDMQBAG+TBP4B6RyJAAAAAElFTkSuQmCC");}.ace_scrollbar {contain: strict;position: absolute;right: 0;bottom: 0;z-index: 6;}.ace_scrollbar-inner {position: absolute;cursor: text;left: 0;top: 0;}.ace_scrollbar-v{overflow-x: hidden;overflow-y: scroll;top: 0;}.ace_scrollbar-h {overflow-x: scroll;overflow-y: hidden;left: 0;}.ace_print-margin {position: absolute;height: 100%;}.ace_text-input {position: absolute;z-index: 0;width: 0.5em;height: 1em;opacity: 0;background: transparent;-moz-appearance: none;appearance: none;border: none;resize: none;outline: none;overflow: hidden;font: inherit;padding: 0 1px;margin: 0 -1px;contain: strict;-ms-user-select: text;-moz-user-select: text;-webkit-user-select: text;user-select: text;white-space: pre!important;}.ace_text-input.ace_composition {background: transparent;color: inherit;z-index: 1000;opacity: 1;}.ace_composition_placeholder { color: transparent }.ace_composition_marker { border-bottom: 1px solid;position: absolute;border-radius: 0;margin-top: 1px;}[ace_nocontext=true] {transform: none!important;filter: none!important;perspective: none!important;clip-path: none!important;mask : none!important;contain: none!important;perspective: none!important;mix-blend-mode: initial!important;z-index: auto;}.ace_layer {z-index: 1;position: absolute;overflow: hidden;word-wrap: normal;white-space: pre;height: 100%;width: 100%;box-sizing: border-box;pointer-events: none;}.ace_gutter-layer {position: relative;width: auto;text-align: right;pointer-events: auto;height: 1000000px;contain: style size layout;}.ace_text-layer {font: inherit !important;position: absolute;height: 1000000px;width: 1000000px;contain: style size layout;}.ace_text-layer > .ace_line, .ace_text-layer > .ace_line_group {contain: style size layout;position: absolute;top: 0;left: 0;right: 0;}.ace_hidpi .ace_text-layer,.ace_hidpi .ace_gutter-layer,.ace_hidpi .ace_content,.ace_hidpi .ace_gutter {contain: strict;will-change: transform;}.ace_hidpi .ace_text-layer > .ace_line, .ace_hidpi .ace_text-layer > .ace_line_group {contain: strict;}.ace_cjk {display: inline-block;text-align: center;}.ace_cursor-layer {z-index: 4;}.ace_cursor {z-index: 4;position: absolute;box-sizing: border-box;border-left: 2px solid;transform: translatez(0);}.ace_multiselect .ace_cursor {border-left-width: 1px;}.ace_slim-cursors .ace_cursor {border-left-width: 1px;}.ace_overwrite-cursors .ace_cursor {border-left-width: 0;border-bottom: 1px solid;}.ace_hidden-cursors .ace_cursor {opacity: 0.2;}.ace_hasPlaceholder .ace_hidden-cursors .ace_cursor {opacity: 0;}.ace_smooth-blinking .ace_cursor {transition: opacity 0.18s;}.ace_animate-blinking .ace_cursor {animation-duration: 1000ms;animation-timing-function: step-end;animation-name: blink-ace-animate;animation-iteration-count: infinite;}.ace_animate-blinking.ace_smooth-blinking .ace_cursor {animation-duration: 1000ms;animation-timing-function: ease-in-out;animation-name: blink-ace-animate-smooth;}@keyframes blink-ace-animate {from, to { opacity: 1; }60% { opacity: 0; }}@keyframes blink-ace-animate-smooth {from, to { opacity: 1; }45% { opacity: 1; }60% { opacity: 0; }85% { opacity: 0; }}.ace_marker-layer .ace_step, .ace_marker-layer .ace_stack {position: absolute;z-index: 3;}.ace_marker-layer .ace_selection {position: absolute;z-index: 5;}.ace_marker-layer .ace_bracket {position: absolute;z-index: 6;}.ace_marker-layer .ace_active-line {position: absolute;z-index: 2;}.ace_marker-layer .ace_selected-word {position: absolute;z-index: 4;box-sizing: border-box;}.ace_line .ace_fold {box-sizing: border-box;display: inline-block;height: 11px;margin-top: -2px;vertical-align: middle;background-image:url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABEAAAAJCAYAAADU6McMAAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAAJpJREFUeNpi/P//PwOlgAXGYGRklAVSokD8GmjwY1wasKljQpYACtpCFeADcHVQfQyMQAwzwAZI3wJKvCLkfKBaMSClBlR7BOQikCFGQEErIH0VqkabiGCAqwUadAzZJRxQr/0gwiXIal8zQQPnNVTgJ1TdawL0T5gBIP1MUJNhBv2HKoQHHjqNrA4WO4zY0glyNKLT2KIfIMAAQsdgGiXvgnYAAAAASUVORK5CYII="),url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAEAAAA3CAYAAADNNiA5AAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAACJJREFUeNpi+P//fxgTAwPDBxDxD078RSX+YeEyDFMCIMAAI3INmXiwf2YAAAAASUVORK5CYII=");background-repeat: no-repeat, repeat-x;background-position: center center, top left;color: transparent;border: 1px solid black;border-radius: 2px;cursor: pointer;pointer-events: auto;}.ace_dark .ace_fold {}.ace_fold:hover{background-image:url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABEAAAAJCAYAAADU6McMAAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAAJpJREFUeNpi/P//PwOlgAXGYGRklAVSokD8GmjwY1wasKljQpYACtpCFeADcHVQfQyMQAwzwAZI3wJKvCLkfKBaMSClBlR7BOQikCFGQEErIH0VqkabiGCAqwUadAzZJRxQr/0gwiXIal8zQQPnNVTgJ1TdawL0T5gBIP1MUJNhBv2HKoQHHjqNrA4WO4zY0glyNKLT2KIfIMAAQsdgGiXvgnYAAAAASUVORK5CYII="),url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAEAAAA3CAYAAADNNiA5AAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAACBJREFUeNpi+P//fz4TAwPDZxDxD5X4i5fLMEwJgAADAEPVDbjNw87ZAAAAAElFTkSuQmCC");}.ace_tooltip {background-color: #FFF;background-image: linear-gradient(to bottom, transparent, rgba(0, 0, 0, 0.1));border: 1px solid gray;border-radius: 1px;box-shadow: 0 1px 2px rgba(0, 0, 0, 0.3);color: black;max-width: 100%;padding: 3px 4px;position: fixed;z-index: 999999;box-sizing: border-box;cursor: default;white-space: pre;word-wrap: break-word;line-height: normal;font-style: normal;font-weight: normal;letter-spacing: normal;pointer-events: none;}.ace_folding-enabled > .ace_gutter-cell {padding-right: 13px;}.ace_fold-widget {box-sizing: border-box;margin: 0 -12px 0 1px;display: none;width: 11px;vertical-align: top;background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAUAAAAFCAYAAACNbyblAAAANElEQVR42mWKsQ0AMAzC8ixLlrzQjzmBiEjp0A6WwBCSPgKAXoLkqSot7nN3yMwR7pZ32NzpKkVoDBUxKAAAAABJRU5ErkJggg==");background-repeat: no-repeat;background-position: center;border-radius: 3px;border: 1px solid transparent;cursor: pointer;}.ace_folding-enabled .ace_fold-widget {display: inline-block;   }.ace_fold-widget.ace_end {background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAUAAAAFCAYAAACNbyblAAAANElEQVR42m3HwQkAMAhD0YzsRchFKI7sAikeWkrxwScEB0nh5e7KTPWimZki4tYfVbX+MNl4pyZXejUO1QAAAABJRU5ErkJggg==");}.ace_fold-widget.ace_closed {background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAMAAAAGCAYAAAAG5SQMAAAAOUlEQVR42jXKwQkAMAgDwKwqKD4EwQ26sSOkVWjgIIHAzPiCgaqiqnJHZnKICBERHN194O5b9vbLuAVRL+l0YWnZAAAAAElFTkSuQmCCXA==");}.ace_fold-widget:hover {border: 1px solid rgba(0, 0, 0, 0.3);background-color: rgba(255, 255, 255, 0.2);box-shadow: 0 1px 1px rgba(255, 255, 255, 0.7);}.ace_fold-widget:active {border: 1px solid rgba(0, 0, 0, 0.4);background-color: rgba(0, 0, 0, 0.05);box-shadow: 0 1px 1px rgba(255, 255, 255, 0.8);}.ace_dark .ace_fold-widget {background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAUAAAAFCAYAAACNbyblAAAAHklEQVQIW2P4//8/AzoGEQ7oGCaLLAhWiSwB146BAQCSTPYocqT0AAAAAElFTkSuQmCC");}.ace_dark .ace_fold-widget.ace_end {background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAUAAAAFCAYAAACNbyblAAAAH0lEQVQIW2P4//8/AxQ7wNjIAjDMgC4AxjCVKBirIAAF0kz2rlhxpAAAAABJRU5ErkJggg==");}.ace_dark .ace_fold-widget.ace_closed {background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAMAAAAFCAYAAACAcVaiAAAAHElEQVQIW2P4//+/AxAzgDADlOOAznHAKgPWAwARji8UIDTfQQAAAABJRU5ErkJggg==");}.ace_dark .ace_fold-widget:hover {box-shadow: 0 1px 1px rgba(255, 255, 255, 0.2);background-color: rgba(255, 255, 255, 0.1);}.ace_dark .ace_fold-widget:active {box-shadow: 0 1px 1px rgba(255, 255, 255, 0.2);}.ace_inline_button {border: 1px solid lightgray;display: inline-block;margin: -1px 8px;padding: 0 5px;pointer-events: auto;cursor: pointer;}.ace_inline_button:hover {border-color: gray;background: rgba(200,200,200,0.2);display: inline-block;pointer-events: auto;}.ace_fold-widget.ace_invalid {background-color: #FFB4B4;border-color: #DE5555;}.ace_fade-fold-widgets .ace_fold-widget {transition: opacity 0.4s ease 0.05s;opacity: 0;}.ace_fade-fold-widgets:hover .ace_fold-widget {transition: opacity 0.05s ease 0.05s;opacity:1;}.ace_underline {text-decoration: underline;}.ace_bold {font-weight: bold;}.ace_nobold .ace_bold {font-weight: normal;}.ace_italic {font-style: italic;}.ace_error-marker {background-color: rgba(255, 0, 0,0.2);position: absolute;z-index: 9;}.ace_highlight-marker {background-color: rgba(255, 255, 0,0.2);position: absolute;z-index: 8;}.ace_mobile-menu {position: absolute;line-height: 1.5;border-radius: 4px;-ms-user-select: none;-moz-user-select: none;-webkit-user-select: none;user-select: none;background: white;box-shadow: 1px 3px 2px grey;border: 1px solid #dcdcdc;color: black;}.ace_dark > .ace_mobile-menu {background: #333;color: #ccc;box-shadow: 1px 3px 2px grey;border: 1px solid #444;}.ace_mobile-button {padding: 2px;cursor: pointer;overflow: hidden;}.ace_mobile-button:hover {background-color: #eee;opacity:1;}.ace_mobile-button:active {background-color: #ddd;}.ace_placeholder {font-family: arial;transform: scale(0.9);opacity: 0.7;transform-origin: left;text-indent: 10px;}',f=e("./lib/useragent"),E=f.isIE;r.importCssString(g,"ace_editor.css");var v=function(e,t){var n=this;this.container=e||r.createElement("div"),r.addCssClass(this.container,"ace_editor"),r.HI_DPI&&r.addCssClass(this.container,"ace_hidpi"),this.setTheme(t),this.$gutter=r.createElement("div"),this.$gutter.className="ace_gutter",this.container.appendChild(this.$gutter),this.$gutter.setAttribute("aria-hidden",!0),this.scroller=r.createElement("div"),this.scroller.className="ace_scroller",this.container.appendChild(this.scroller),this.content=r.createElement("div"),this.content.className="ace_content",this.scroller.appendChild(this.content),this.$gutterLayer=new o(this.$gutter),this.$gutterLayer.on("changeGutterWidth",this.onGutterResize.bind(this)),this.$markerBack=new a(this.content);var i=this.$textLayer=new l(this.content);this.canvas=i.element,this.$markerFront=new a(this.content),this.$cursorLayer=new c(this.content),this.$horizScroll=!1,this.$vScroll=!1,this.scrollBar=this.scrollBarV=new h(this.container,this),this.scrollBarH=new u(this.container,this),this.scrollBarV.addEventListener("scroll",(function(e){n.$scrollAnimation||n.session.setScrollTop(e.data-n.scrollMargin.top)})),this.scrollBarH.addEventListener("scroll",(function(e){n.$scrollAnimation||n.session.setScrollLeft(e.data-n.scrollMargin.left)})),this.scrollTop=0,this.scrollLeft=0,this.cursorPos={row:0,column:0},this.$fontMetrics=new m(this.container),this.$textLayer.$setFontMetrics(this.$fontMetrics),this.$textLayer.addEventListener("changeCharacterSize",(function(e){n.updateCharacterSize(),n.onResize(!0,n.gutterWidth,n.$size.width,n.$size.height),n._signal("changeCharacterSize",e)})),this.$size={width:0,height:0,scrollerHeight:0,scrollerWidth:0,$dirty:!0},this.layerConfig={width:1,padding:0,firstRow:0,firstRowScreen:0,lastRow:0,lineHeight:0,characterWidth:0,minHeight:1,maxHeight:1,offset:0,height:1,gutterOffset:1},this.scrollMargin={left:0,right:0,top:0,bottom:0,v:0,h:0},this.margin={left:0,right:0,top:0,bottom:0,v:0,h:0},this.$keepTextAreaAtCursor=!f.isIOS,this.$loop=new d(this.$renderChanges.bind(this),this.container.ownerDocument.defaultView),this.$loop.schedule(this.CHANGE_FULL),this.updateCharacterSize(),this.setPadding(4),s.resetOptions(this),s._signal("renderer",this)};(function(){this.CHANGE_CURSOR=1,this.CHANGE_MARKER=2,this.CHANGE_GUTTER=4,this.CHANGE_SCROLL=8,this.CHANGE_LINES=16,this.CHANGE_TEXT=32,this.CHANGE_SIZE=64,this.CHANGE_MARKER_BACK=128,this.CHANGE_MARKER_FRONT=256,this.CHANGE_FULL=512,this.CHANGE_H_SCROLL=1024,i.implement(this,p),this.updateCharacterSize=function(){this.$textLayer.allowBoldFonts!=this.$allowBoldFonts&&(this.$allowBoldFonts=this.$textLayer.allowBoldFonts,this.setStyle("ace_nobold",!this.$allowBoldFonts)),this.layerConfig.characterWidth=this.characterWidth=this.$textLayer.getCharacterWidth(),this.layerConfig.lineHeight=this.lineHeight=this.$textLayer.getLineHeight(),this.$updatePrintMargin(),r.setStyle(this.scroller.style,"line-height",this.lineHeight+"px")},this.setSession=function(e){this.session&&this.session.doc.off("changeNewLineMode",this.onChangeNewLineMode),this.session=e,e&&this.scrollMargin.top&&e.getScrollTop()<=0&&e.setScrollTop(-this.scrollMargin.top),this.$cursorLayer.setSession(e),this.$markerBack.setSession(e),this.$markerFront.setSession(e),this.$gutterLayer.setSession(e),this.$textLayer.setSession(e),e&&(this.$loop.schedule(this.CHANGE_FULL),this.session.$setFontMetrics(this.$fontMetrics),this.scrollBarH.scrollLeft=this.scrollBarV.scrollTop=null,this.onChangeNewLineMode=this.onChangeNewLineMode.bind(this),this.onChangeNewLineMode(),this.session.doc.on("changeNewLineMode",this.onChangeNewLineMode))},this.updateLines=function(e,t,n){if(void 0===t&&(t=1/0),this.$changedLines?(this.$changedLines.firstRow>e&&(this.$changedLines.firstRow=e),this.$changedLines.lastRow<t&&(this.$changedLines.lastRow=t)):this.$changedLines={firstRow:e,lastRow:t},this.$changedLines.lastRow<this.layerConfig.firstRow){if(!n)return;this.$changedLines.lastRow=this.layerConfig.lastRow}this.$changedLines.firstRow>this.layerConfig.lastRow||this.$loop.schedule(this.CHANGE_LINES)},this.onChangeNewLineMode=function(){this.$loop.schedule(this.CHANGE_TEXT),this.$textLayer.$updateEolChar(),this.session.$bidiHandler.setEolChar(this.$textLayer.EOL_CHAR)},this.onChangeTabSize=function(){this.$loop.schedule(this.CHANGE_TEXT|this.CHANGE_MARKER),this.$textLayer.onChangeTabSize()},this.updateText=function(){this.$loop.schedule(this.CHANGE_TEXT)},this.updateFull=function(e){e?this.$renderChanges(this.CHANGE_FULL,!0):this.$loop.schedule(this.CHANGE_FULL)},this.updateFontSize=function(){this.$textLayer.checkForSizeChanges()},this.$changes=0,this.$updateSizeAsync=function(){this.$loop.pending?this.$size.$dirty=!0:this.onResize()},this.onResize=function(e,t,n,i){if(!(this.resizing>2)){this.resizing>0?this.resizing++:this.resizing=e?1:0;var r=this.container;i||(i=r.clientHeight||r.scrollHeight),n||(n=r.clientWidth||r.scrollWidth);var s=this.$updateCachedSize(e,t,n,i);if(!this.$size.scrollerHeight||!n&&!i)return this.resizing=0;e&&(this.$gutterLayer.$padding=null),e?this.$renderChanges(s|this.$changes,!0):this.$loop.schedule(s|this.$changes),this.resizing&&(this.resizing=0),this.scrollBarV.scrollLeft=this.scrollBarV.scrollTop=null}},this.$updateCachedSize=function(e,t,n,i){i-=this.$extraHeight||0;var s=0,o=this.$size,a={width:o.width,height:o.height,scrollerHeight:o.scrollerHeight,scrollerWidth:o.scrollerWidth};if(i&&(e||o.height!=i)&&(o.height=i,s|=this.CHANGE_SIZE,o.scrollerHeight=o.height,this.$horizScroll&&(o.scrollerHeight-=this.scrollBarH.getHeight()),this.scrollBarV.element.style.bottom=this.scrollBarH.getHeight()+"px",s|=this.CHANGE_SCROLL),n&&(e||o.width!=n)){s|=this.CHANGE_SIZE,o.width=n,null==t&&(t=this.$showGutter?this.$gutter.offsetWidth:0),this.gutterWidth=t,r.setStyle(this.scrollBarH.element.style,"left",t+"px"),r.setStyle(this.scroller.style,"left",t+this.margin.left+"px"),o.scrollerWidth=Math.max(0,n-t-this.scrollBarV.getWidth()-this.margin.h),r.setStyle(this.$gutter.style,"left",this.margin.left+"px");var l=this.scrollBarV.getWidth()+"px";r.setStyle(this.scrollBarH.element.style,"right",l),r.setStyle(this.scroller.style,"right",l),r.setStyle(this.scroller.style,"bottom",this.scrollBarH.getHeight()),(this.session&&this.session.getUseWrapMode()&&this.adjustWrapLimit()||e)&&(s|=this.CHANGE_FULL)}return o.$dirty=!n||!i,s&&this._signal("resize",a),s},this.onGutterResize=function(e){var t=this.$showGutter?e:0;t!=this.gutterWidth&&(this.$changes|=this.$updateCachedSize(!0,t,this.$size.width,this.$size.height)),this.session.getUseWrapMode()&&this.adjustWrapLimit()||this.$size.$dirty?this.$loop.schedule(this.CHANGE_FULL):this.$computeLayerConfig()},this.adjustWrapLimit=function(){var e=this.$size.scrollerWidth-2*this.$padding,t=Math.floor(e/this.characterWidth);return this.session.adjustWrapLimit(t,this.$showPrintMargin&&this.$printMarginColumn)},this.setAnimatedScroll=function(e){this.setOption("animatedScroll",e)},this.getAnimatedScroll=function(){return this.$animatedScroll},this.setShowInvisibles=function(e){this.setOption("showInvisibles",e),this.session.$bidiHandler.setShowInvisibles(e)},this.getShowInvisibles=function(){return this.getOption("showInvisibles")},this.getDisplayIndentGuides=function(){return this.getOption("displayIndentGuides")},this.setDisplayIndentGuides=function(e){this.setOption("displayIndentGuides",e)},this.setShowPrintMargin=function(e){this.setOption("showPrintMargin",e)},this.getShowPrintMargin=function(){return this.getOption("showPrintMargin")},this.setPrintMarginColumn=function(e){this.setOption("printMarginColumn",e)},this.getPrintMarginColumn=function(){return this.getOption("printMarginColumn")},this.getShowGutter=function(){return this.getOption("showGutter")},this.setShowGutter=function(e){return this.setOption("showGutter",e)},this.getFadeFoldWidgets=function(){return this.getOption("fadeFoldWidgets")},this.setFadeFoldWidgets=function(e){this.setOption("fadeFoldWidgets",e)},this.setHighlightGutterLine=function(e){this.setOption("highlightGutterLine",e)},this.getHighlightGutterLine=function(){return this.getOption("highlightGutterLine")},this.$updatePrintMargin=function(){if(this.$showPrintMargin||this.$printMarginEl){if(!this.$printMarginEl){var e=r.createElement("div");e.className="ace_layer ace_print-margin-layer",this.$printMarginEl=r.createElement("div"),this.$printMarginEl.className="ace_print-margin",e.appendChild(this.$printMarginEl),this.content.insertBefore(e,this.content.firstChild)}var t=this.$printMarginEl.style;t.left=Math.round(this.characterWidth*this.$printMarginColumn+this.$padding)+"px",t.visibility=this.$showPrintMargin?"visible":"hidden",this.session&&-1==this.session.$wrap&&this.adjustWrapLimit()}},this.getContainerElement=function(){return this.container},this.getMouseEventTarget=function(){return this.scroller},this.getTextAreaContainer=function(){return this.container},this.$moveTextAreaToCursor=function(){if(!this.$isMousePressed){var e=this.textarea.style,t=this.$composition;if(this.$keepTextAreaAtCursor||t){var n=this.$cursorLayer.$pixelPos;if(n){t&&t.markerRange&&(n=this.$cursorLayer.getPixelPosition(t.markerRange.start,!0));var i=this.layerConfig,s=n.top,o=n.left;s-=i.offset;var a=t&&t.useTextareaForIME?this.lineHeight:E?0:1;if(s<0||s>i.height-a)r.translate(this.textarea,0,0);else{var l=1,c=this.$size.height-a;if(t)if(t.useTextareaForIME){var u=this.textarea.value;l=this.characterWidth*this.session.$getStringScreenWidth(u)[0]}else s+=this.lineHeight+2;else s+=this.lineHeight;(o-=this.scrollLeft)>this.$size.scrollerWidth-l&&(o=this.$size.scrollerWidth-l),o+=this.gutterWidth+this.margin.left,r.setStyle(e,"height",a+"px"),r.setStyle(e,"width",l+"px"),r.translate(this.textarea,Math.min(o,this.$size.scrollerWidth-l),Math.min(s,c))}}}else r.translate(this.textarea,-100,0)}},this.getFirstVisibleRow=function(){return this.layerConfig.firstRow},this.getFirstFullyVisibleRow=function(){return this.layerConfig.firstRow+(0===this.layerConfig.offset?0:1)},this.getLastFullyVisibleRow=function(){var e=this.layerConfig,t=e.lastRow;return this.session.documentToScreenRow(t,0)*e.lineHeight-this.session.getScrollTop()>e.height-e.lineHeight?t-1:t},this.getLastVisibleRow=function(){return this.layerConfig.lastRow},this.$padding=null,this.setPadding=function(e){this.$padding=e,this.$textLayer.setPadding(e),this.$cursorLayer.setPadding(e),this.$markerFront.setPadding(e),this.$markerBack.setPadding(e),this.$loop.schedule(this.CHANGE_FULL),this.$updatePrintMargin()},this.setScrollMargin=function(e,t,n,i){var r=this.scrollMargin;r.top=0|e,r.bottom=0|t,r.right=0|i,r.left=0|n,r.v=r.top+r.bottom,r.h=r.left+r.right,r.top&&this.scrollTop<=0&&this.session&&this.session.setScrollTop(-r.top),this.updateFull()},this.setMargin=function(e,t,n,i){var r=this.margin;r.top=0|e,r.bottom=0|t,r.right=0|i,r.left=0|n,r.v=r.top+r.bottom,r.h=r.left+r.right,this.$updateCachedSize(!0,this.gutterWidth,this.$size.width,this.$size.height),this.updateFull()},this.getHScrollBarAlwaysVisible=function(){return this.$hScrollBarAlwaysVisible},this.setHScrollBarAlwaysVisible=function(e){this.setOption("hScrollBarAlwaysVisible",e)},this.getVScrollBarAlwaysVisible=function(){return this.$vScrollBarAlwaysVisible},this.setVScrollBarAlwaysVisible=function(e){this.setOption("vScrollBarAlwaysVisible",e)},this.$updateScrollBarV=function(){var e=this.layerConfig.maxHeight,t=this.$size.scrollerHeight;!this.$maxLines&&this.$scrollPastEnd&&(e-=(t-this.lineHeight)*this.$scrollPastEnd,this.scrollTop>e-t&&(e=this.scrollTop+t,this.scrollBarV.scrollTop=null)),this.scrollBarV.setScrollHeight(e+this.scrollMargin.v),this.scrollBarV.setScrollTop(this.scrollTop+this.scrollMargin.top)},this.$updateScrollBarH=function(){this.scrollBarH.setScrollWidth(this.layerConfig.width+2*this.$padding+this.scrollMargin.h),this.scrollBarH.setScrollLeft(this.scrollLeft+this.scrollMargin.left)},this.$frozen=!1,this.freeze=function(){this.$frozen=!0},this.unfreeze=function(){this.$frozen=!1},this.$renderChanges=function(e,t){if(this.$changes&&(e|=this.$changes,this.$changes=0),this.session&&this.container.offsetWidth&&!this.$frozen&&(e||t)){if(this.$size.$dirty)return this.$changes|=e,this.onResize(!0);this.lineHeight||this.$textLayer.checkForSizeChanges(),this._signal("beforeRender"),this.session&&this.session.$bidiHandler&&this.session.$bidiHandler.updateCharacterWidths(this.$fontMetrics);var n=this.layerConfig;if(e&this.CHANGE_FULL||e&this.CHANGE_SIZE||e&this.CHANGE_TEXT||e&this.CHANGE_LINES||e&this.CHANGE_SCROLL||e&this.CHANGE_H_SCROLL){if(e|=this.$computeLayerConfig()|this.$loop.clear(),n.firstRow!=this.layerConfig.firstRow&&n.firstRowScreen==this.layerConfig.firstRowScreen){var i=this.scrollTop+(n.firstRow-this.layerConfig.firstRow)*this.lineHeight;i>0&&(this.scrollTop=i,e|=this.CHANGE_SCROLL,e|=this.$computeLayerConfig()|this.$loop.clear())}n=this.layerConfig,this.$updateScrollBarV(),e&this.CHANGE_H_SCROLL&&this.$updateScrollBarH(),r.translate(this.content,-this.scrollLeft,-n.offset);var s=n.width+2*this.$padding+"px",o=n.minHeight+"px";r.setStyle(this.content.style,"width",s),r.setStyle(this.content.style,"height",o)}if(e&this.CHANGE_H_SCROLL&&(r.translate(this.content,-this.scrollLeft,-n.offset),this.scroller.className=this.scrollLeft<=0?"ace_scroller":"ace_scroller ace_scroll-left"),e&this.CHANGE_FULL)return this.$changedLines=null,this.$textLayer.update(n),this.$showGutter&&this.$gutterLayer.update(n),this.$markerBack.update(n),this.$markerFront.update(n),this.$cursorLayer.update(n),this.$moveTextAreaToCursor(),void this._signal("afterRender");if(e&this.CHANGE_SCROLL)return this.$changedLines=null,e&this.CHANGE_TEXT||e&this.CHANGE_LINES?this.$textLayer.update(n):this.$textLayer.scrollLines(n),this.$showGutter&&(e&this.CHANGE_GUTTER||e&this.CHANGE_LINES?this.$gutterLayer.update(n):this.$gutterLayer.scrollLines(n)),this.$markerBack.update(n),this.$markerFront.update(n),this.$cursorLayer.update(n),this.$moveTextAreaToCursor(),void this._signal("afterRender");e&this.CHANGE_TEXT?(this.$changedLines=null,this.$textLayer.update(n),this.$showGutter&&this.$gutterLayer.update(n)):e&this.CHANGE_LINES?(this.$updateLines()||e&this.CHANGE_GUTTER&&this.$showGutter)&&this.$gutterLayer.update(n):e&this.CHANGE_TEXT||e&this.CHANGE_GUTTER?this.$showGutter&&this.$gutterLayer.update(n):e&this.CHANGE_CURSOR&&this.$highlightGutterLine&&this.$gutterLayer.updateLineHighlight(n),e&this.CHANGE_CURSOR&&(this.$cursorLayer.update(n),this.$moveTextAreaToCursor()),e&(this.CHANGE_MARKER|this.CHANGE_MARKER_FRONT)&&this.$markerFront.update(n),e&(this.CHANGE_MARKER|this.CHANGE_MARKER_BACK)&&this.$markerBack.update(n),this._signal("afterRender")}else this.$changes|=e},this.$autosize=function(){var e=this.session.getScreenLength()*this.lineHeight,t=this.$maxLines*this.lineHeight,n=Math.min(t,Math.max((this.$minLines||1)*this.lineHeight,e))+this.scrollMargin.v+(this.$extraHeight||0);this.$horizScroll&&(n+=this.scrollBarH.getHeight()),this.$maxPixelHeight&&n>this.$maxPixelHeight&&(n=this.$maxPixelHeight);var i=!(n<=2*this.lineHeight)&&e>t;if(n!=this.desiredHeight||this.$size.height!=this.desiredHeight||i!=this.$vScroll){i!=this.$vScroll&&(this.$vScroll=i,this.scrollBarV.setVisible(i));var r=this.container.clientWidth;this.container.style.height=n+"px",this.$updateCachedSize(!0,this.$gutterWidth,r,n),this.desiredHeight=n,this._signal("autosize")}},this.$computeLayerConfig=function(){var e=this.session,t=this.$size,n=t.height<=2*this.lineHeight,i=this.session.getScreenLength()*this.lineHeight,r=this.$getLongestLine(),s=!n&&(this.$hScrollBarAlwaysVisible||t.scrollerWidth-r-2*this.$padding<0),o=this.$horizScroll!==s;o&&(this.$horizScroll=s,this.scrollBarH.setVisible(s));var a=this.$vScroll;this.$maxLines&&this.lineHeight>1&&this.$autosize();var l=t.scrollerHeight+this.lineHeight,c=!this.$maxLines&&this.$scrollPastEnd?(t.scrollerHeight-this.lineHeight)*this.$scrollPastEnd:0;i+=c;var u=this.scrollMargin;this.session.setScrollTop(Math.max(-u.top,Math.min(this.scrollTop,i-t.scrollerHeight+u.bottom))),this.session.setScrollLeft(Math.max(-u.left,Math.min(this.scrollLeft,r+2*this.$padding-t.scrollerWidth+u.right)));var h=!n&&(this.$vScrollBarAlwaysVisible||t.scrollerHeight-i+c<0||this.scrollTop>u.top),d=a!==h;d&&(this.$vScroll=h,this.scrollBarV.setVisible(h));var m,p,g=this.scrollTop%this.lineHeight,f=Math.ceil(l/this.lineHeight)-1,E=Math.max(0,Math.round((this.scrollTop-g)/this.lineHeight)),v=E+f,_=this.lineHeight;E=e.screenToDocumentRow(E,0);var C=e.getFoldLine(E);C&&(E=C.start.row),m=e.documentToScreenRow(E,0),p=e.getRowLength(E)*_,v=Math.min(e.screenToDocumentRow(v,0),e.getLength()-1),l=t.scrollerHeight+e.getRowLength(v)*_+p,g=this.scrollTop-m*_;var A=0;return(this.layerConfig.width!=r||o)&&(A=this.CHANGE_H_SCROLL),(o||d)&&(A|=this.$updateCachedSize(!0,this.gutterWidth,t.width,t.height),this._signal("scrollbarVisibilityChanged"),d&&(r=this.$getLongestLine())),this.layerConfig={width:r,padding:this.$padding,firstRow:E,firstRowScreen:m,lastRow:v,lineHeight:_,characterWidth:this.characterWidth,minHeight:l,maxHeight:i,offset:g,gutterOffset:_?Math.max(0,Math.ceil((g+t.height-t.scrollerHeight)/_)):0,height:this.$size.scrollerHeight},this.session.$bidiHandler&&this.session.$bidiHandler.setContentWidth(r-this.$padding),A},this.$updateLines=function(){if(this.$changedLines){var e=this.$changedLines.firstRow,t=this.$changedLines.lastRow;this.$changedLines=null;var n=this.layerConfig;if(!(e>n.lastRow+1||t<n.firstRow))return t===1/0?(this.$showGutter&&this.$gutterLayer.update(n),void this.$textLayer.update(n)):(this.$textLayer.updateLines(n,e,t),!0)}},this.$getLongestLine=function(){var e=this.session.getScreenWidth();return this.showInvisibles&&!this.session.$useWrapMode&&(e+=1),this.$textLayer&&e>this.$textLayer.MAX_LINE_LENGTH&&(e=this.$textLayer.MAX_LINE_LENGTH+30),Math.max(this.$size.scrollerWidth-2*this.$padding,Math.round(e*this.characterWidth))},this.updateFrontMarkers=function(){this.$markerFront.setMarkers(this.session.getMarkers(!0)),this.$loop.schedule(this.CHANGE_MARKER_FRONT)},this.updateBackMarkers=function(){this.$markerBack.setMarkers(this.session.getMarkers()),this.$loop.schedule(this.CHANGE_MARKER_BACK)},this.addGutterDecoration=function(e,t){this.$gutterLayer.addGutterDecoration(e,t)},this.removeGutterDecoration=function(e,t){this.$gutterLayer.removeGutterDecoration(e,t)},this.updateBreakpoints=function(e){this.$loop.schedule(this.CHANGE_GUTTER)},this.setAnnotations=function(e){this.$gutterLayer.setAnnotations(e),this.$loop.schedule(this.CHANGE_GUTTER)},this.updateCursor=function(){this.$loop.schedule(this.CHANGE_CURSOR)},this.hideCursor=function(){this.$cursorLayer.hideCursor()},this.showCursor=function(){this.$cursorLayer.showCursor()},this.scrollSelectionIntoView=function(e,t,n){this.scrollCursorIntoView(e,n),this.scrollCursorIntoView(t,n)},this.scrollCursorIntoView=function(e,t,n){if(0!==this.$size.scrollerHeight){var i=this.$cursorLayer.getPixelPosition(e),r=i.left,s=i.top,o=n&&n.top||0,a=n&&n.bottom||0,l=this.$scrollAnimation?this.session.getScrollTop():this.scrollTop;l+o>s?(t&&l+o>s+this.lineHeight&&(s-=t*this.$size.scrollerHeight),0===s&&(s=-this.scrollMargin.top),this.session.setScrollTop(s)):l+this.$size.scrollerHeight-a<s+this.lineHeight&&(t&&l+this.$size.scrollerHeight-a<s-this.lineHeight&&(s+=t*this.$size.scrollerHeight),this.session.setScrollTop(s+this.lineHeight+a-this.$size.scrollerHeight));var c=this.scrollLeft;c>r?(r<this.$padding+2*this.layerConfig.characterWidth&&(r=-this.scrollMargin.left),this.session.setScrollLeft(r)):c+this.$size.scrollerWidth<r+this.characterWidth?this.session.setScrollLeft(Math.round(r+this.characterWidth-this.$size.scrollerWidth)):c<=this.$padding&&r-c<this.characterWidth&&this.session.setScrollLeft(0)}},this.getScrollTop=function(){return this.session.getScrollTop()},this.getScrollLeft=function(){return this.session.getScrollLeft()},this.getScrollTopRow=function(){return this.scrollTop/this.lineHeight},this.getScrollBottomRow=function(){return Math.max(0,Math.floor((this.scrollTop+this.$size.scrollerHeight)/this.lineHeight)-1)},this.scrollToRow=function(e){this.session.setScrollTop(e*this.lineHeight)},this.alignCursor=function(e,t){"number"==typeof e&&(e={row:e,column:0});var n=this.$cursorLayer.getPixelPosition(e),i=this.$size.scrollerHeight-this.lineHeight,r=n.top-i*(t||0);return this.session.setScrollTop(r),r},this.STEPS=8,this.$calcSteps=function(e,t){var n,i,r=0,s=this.STEPS,o=[];for(r=0;r<s;++r)o.push((n=r/this.STEPS,i=e,(t-e)*(Math.pow(n-1,3)+1)+i));return o},this.scrollToLine=function(e,t,n,i){var r=this.$cursorLayer.getPixelPosition({row:e,column:0}).top;t&&(r-=this.$size.scrollerHeight/2);var s=this.scrollTop;this.session.setScrollTop(r),!1!==n&&this.animateScrolling(s,i)},this.animateScrolling=function(e,t){var n=this.scrollTop;if(this.$animatedScroll){var i=this;if(e!=n){if(this.$scrollAnimation){var r=this.$scrollAnimation.steps;if(r.length&&(e=r[0])==n)return}var s=i.$calcSteps(e,n);this.$scrollAnimation={from:e,to:n,steps:s},clearInterval(this.$timer),i.session.setScrollTop(s.shift()),i.session.$scrollTop=n,this.$timer=setInterval((function(){s.length?(i.session.setScrollTop(s.shift()),i.session.$scrollTop=n):null!=n?(i.session.$scrollTop=-1,i.session.setScrollTop(n),n=null):(i.$timer=clearInterval(i.$timer),i.$scrollAnimation=null,t&&t())}),10)}}},this.scrollToY=function(e){this.scrollTop!==e&&(this.$loop.schedule(this.CHANGE_SCROLL),this.scrollTop=e)},this.scrollToX=function(e){this.scrollLeft!==e&&(this.scrollLeft=e),this.$loop.schedule(this.CHANGE_H_SCROLL)},this.scrollTo=function(e,t){this.session.setScrollTop(t),this.session.setScrollLeft(t)},this.scrollBy=function(e,t){t&&this.session.setScrollTop(this.session.getScrollTop()+t),e&&this.session.setScrollLeft(this.session.getScrollLeft()+e)},this.isScrollableBy=function(e,t){return t<0&&this.session.getScrollTop()>=1-this.scrollMargin.top||t>0&&this.session.getScrollTop()+this.$size.scrollerHeight-this.layerConfig.maxHeight<-1+this.scrollMargin.bottom||e<0&&this.session.getScrollLeft()>=1-this.scrollMargin.left||e>0&&this.session.getScrollLeft()+this.$size.scrollerWidth-this.layerConfig.width<-1+this.scrollMargin.right||void 0},this.pixelToScreenCoordinates=function(e,t){var n;if(this.$hasCssTransforms){n={top:0,left:0};var i=this.$fontMetrics.transformCoordinates([e,t]);e=i[1]-this.gutterWidth-this.margin.left,t=i[0]}else n=this.scroller.getBoundingClientRect();var r=e+this.scrollLeft-n.left-this.$padding,s=r/this.characterWidth,o=Math.floor((t+this.scrollTop-n.top)/this.lineHeight),a=this.$blockCursor?Math.floor(s):Math.round(s);return{row:o,column:a,side:s-a>0?1:-1,offsetX:r}},this.screenToTextCoordinates=function(e,t){var n;if(this.$hasCssTransforms){n={top:0,left:0};var i=this.$fontMetrics.transformCoordinates([e,t]);e=i[1]-this.gutterWidth-this.margin.left,t=i[0]}else n=this.scroller.getBoundingClientRect();var r=e+this.scrollLeft-n.left-this.$padding,s=r/this.characterWidth,o=this.$blockCursor?Math.floor(s):Math.round(s),a=Math.floor((t+this.scrollTop-n.top)/this.lineHeight);return this.session.screenToDocumentPosition(a,Math.max(o,0),r)},this.textToScreenCoordinates=function(e,t){var n=this.scroller.getBoundingClientRect(),i=this.session.documentToScreenPosition(e,t),r=this.$padding+(this.session.$bidiHandler.isBidiRow(i.row,e)?this.session.$bidiHandler.getPosLeft(i.column):Math.round(i.column*this.characterWidth)),s=i.row*this.lineHeight;return{pageX:n.left+r-this.scrollLeft,pageY:n.top+s-this.scrollTop}},this.visualizeFocus=function(){r.addCssClass(this.container,"ace_focus")},this.visualizeBlur=function(){r.removeCssClass(this.container,"ace_focus")},this.showComposition=function(e){this.$composition=e,e.cssText||(e.cssText=this.textarea.style.cssText),e.useTextareaForIME=this.$useTextareaForIME,this.$useTextareaForIME?(r.addCssClass(this.textarea,"ace_composition"),this.textarea.style.cssText="",this.$moveTextAreaToCursor(),this.$cursorLayer.element.style.display="none"):e.markerId=this.session.addMarker(e.markerRange,"ace_composition_marker","text")},this.setCompositionText=function(e){var t=this.session.selection.cursor;this.addToken(e,"composition_placeholder",t.row,t.column),this.$moveTextAreaToCursor()},this.hideComposition=function(){this.$composition&&(this.$composition.markerId&&this.session.removeMarker(this.$composition.markerId),r.removeCssClass(this.textarea,"ace_composition"),this.textarea.style.cssText=this.$composition.cssText,this.$composition=null,this.$cursorLayer.element.style.display="")},this.addToken=function(e,t,n,i){var r=this.session;r.bgTokenizer.lines[n]=null;var s={type:t,value:e},o=r.getTokens(n);if(null==i)o.push(s);else for(var a=0,l=0;l<o.length;l++){var c=o[l];if(i<=(a+=c.value.length)){var u=c.value.length-(a-i),h=c.value.slice(0,u),d=c.value.slice(u);o.splice(l,1,{type:c.type,value:h},s,{type:c.type,value:d});break}}this.updateLines(n,n)},this.setTheme=function(e,t){var n=this;if(this.$themeId=e,n._dispatchEvent("themeChange",{theme:e}),e&&"string"!=typeof e)o(e);else{var i=e||this.$options.theme.initialValue;s.loadModule(["theme",i],o)}function o(i){if(n.$themeId!=e)return t&&t();if(!i||!i.cssClass)throw new Error("couldn't load module "+e+" or it didn't call define");i.$id&&(n.$themeId=i.$id),r.importCssString(i.cssText,i.cssClass,n.container),n.theme&&r.removeCssClass(n.container,n.theme.cssClass);var s="padding"in i?i.padding:"padding"in(n.theme||{})?4:n.$padding;n.$padding&&s!=n.$padding&&n.setPadding(s),n.$theme=i.cssClass,n.theme=i,r.addCssClass(n.container,i.cssClass),r.setCssClass(n.container,"ace_dark",i.isDark),n.$size&&(n.$size.width=0,n.$updateSizeAsync()),n._dispatchEvent("themeLoaded",{theme:i}),t&&t()}},this.getTheme=function(){return this.$themeId},this.setStyle=function(e,t){r.setCssClass(this.container,e,!1!==t)},this.unsetStyle=function(e){r.removeCssClass(this.container,e)},this.setCursorStyle=function(e){r.setStyle(this.scroller.style,"cursor",e)},this.setMouseCursor=function(e){r.setStyle(this.scroller.style,"cursor",e)},this.attachToShadowRoot=function(){r.importCssString(g,"ace_editor.css",this.container)},this.destroy=function(){this.freeze(),this.$fontMetrics.destroy(),this.$cursorLayer.destroy()}}).call(v.prototype),s.defineOptions(v.prototype,"renderer",{animatedScroll:{initialValue:!1},showInvisibles:{set:function(e){this.$textLayer.setShowInvisibles(e)&&this.$loop.schedule(this.CHANGE_TEXT)},initialValue:!1},showPrintMargin:{set:function(){this.$updatePrintMargin()},initialValue:!0},printMarginColumn:{set:function(){this.$updatePrintMargin()},initialValue:80},printMargin:{set:function(e){"number"==typeof e&&(this.$printMarginColumn=e),this.$showPrintMargin=!!e,this.$updatePrintMargin()},get:function(){return this.$showPrintMargin&&this.$printMarginColumn}},showGutter:{set:function(e){this.$gutter.style.display=e?"block":"none",this.$loop.schedule(this.CHANGE_FULL),this.onGutterResize()},initialValue:!0},fadeFoldWidgets:{set:function(e){r.setCssClass(this.$gutter,"ace_fade-fold-widgets",e)},initialValue:!1},showFoldWidgets:{set:function(e){this.$gutterLayer.setShowFoldWidgets(e),this.$loop.schedule(this.CHANGE_GUTTER)},initialValue:!0},displayIndentGuides:{set:function(e){this.$textLayer.setDisplayIndentGuides(e)&&this.$loop.schedule(this.CHANGE_TEXT)},initialValue:!0},highlightGutterLine:{set:function(e){this.$gutterLayer.setHighlightGutterLine(e),this.$loop.schedule(this.CHANGE_GUTTER)},initialValue:!0},hScrollBarAlwaysVisible:{set:function(e){this.$hScrollBarAlwaysVisible&&this.$horizScroll||this.$loop.schedule(this.CHANGE_SCROLL)},initialValue:!1},vScrollBarAlwaysVisible:{set:function(e){this.$vScrollBarAlwaysVisible&&this.$vScroll||this.$loop.schedule(this.CHANGE_SCROLL)},initialValue:!1},fontSize:{set:function(e){"number"==typeof e&&(e+="px"),this.container.style.fontSize=e,this.updateFontSize()},initialValue:12},fontFamily:{set:function(e){this.container.style.fontFamily=e,this.updateFontSize()}},maxLines:{set:function(e){this.updateFull()}},minLines:{set:function(e){this.$minLines<562949953421311||(this.$minLines=0),this.updateFull()}},maxPixelHeight:{set:function(e){this.updateFull()},initialValue:0},scrollPastEnd:{set:function(e){e=+e||0,this.$scrollPastEnd!=e&&(this.$scrollPastEnd=e,this.$loop.schedule(this.CHANGE_SCROLL))},initialValue:0,handlesSet:!0},fixedWidthGutter:{set:function(e){this.$gutterLayer.$fixedWidth=!!e,this.$loop.schedule(this.CHANGE_GUTTER)}},theme:{set:function(e){this.setTheme(e)},get:function(){return this.$themeId||this.theme},initialValue:"./theme/textmate",handlesSet:!0},hasCssTransforms:{},useTextareaForIME:{initialValue:!f.isMobile&&!f.isIE}}),t.VirtualRenderer=v})),ace.define("ace/worker/worker_client",["require","exports","module","ace/lib/oop","ace/lib/net","ace/lib/event_emitter","ace/config"],(function(e,t,n){"use strict";var i=e("../lib/oop"),r=e("../lib/net"),s=e("../lib/event_emitter").EventEmitter,o=e("../config");function a(e){if("undefined"==typeof Worker)return{postMessage:function(){},terminate:function(){}};if(o.get("loadWorkerFromBlob")){var t=function(e){var t="importScripts('"+r.qualifyURL(e)+"');";try{return new Blob([t],{type:"application/javascript"})}catch(e){var n=new(window.BlobBuilder||window.WebKitBlobBuilder||window.MozBlobBuilder);return n.append(t),n.getBlob("application/javascript")}}(e),n=(window.URL||window.webkitURL).createObjectURL(t);return new Worker(n)}return new Worker(e)}var l=function(e){e.postMessage||(e=this.$createWorkerFromOldConfig.apply(this,arguments)),this.$worker=e,this.$sendDeltaQueue=this.$sendDeltaQueue.bind(this),this.changeListener=this.changeListener.bind(this),this.onMessage=this.onMessage.bind(this),this.callbackId=1,this.callbacks={},this.$worker.onmessage=this.onMessage};(function(){i.implement(this,s),this.$createWorkerFromOldConfig=function(t,n,i,r,s){if(e.nameToUrl&&!e.toUrl&&(e.toUrl=e.nameToUrl),o.get("packaged")||!e.toUrl)r=r||o.moduleUrl(n,"worker");else{var l=this.$normalizePath;r=r||l(e.toUrl("ace/worker/worker.js",null,"_"));var c={};t.forEach((function(t){c[t]=l(e.toUrl(t,null,"_").replace(/(\.js)?(\?.*)?$/,""))}))}return this.$worker=a(r),s&&this.send("importScripts",s),this.$worker.postMessage({init:!0,tlns:c,module:n,classname:i}),this.$worker},this.onMessage=function(e){var t=e.data;switch(t.type){case"event":this._signal(t.name,{data:t.data});break;case"call":var n=this.callbacks[t.id];n&&(n(t.data),delete this.callbacks[t.id]);break;case"error":this.reportError(t.data);break;case"log":window.console&&console.log&&console.log.apply(console,t.data)}},this.reportError=function(e){window.console&&console.error&&console.error(e)},this.$normalizePath=function(e){return r.qualifyURL(e)},this.terminate=function(){this._signal("terminate",{}),this.deltaQueue=null,this.$worker.terminate(),this.$worker=null,this.$doc&&this.$doc.off("change",this.changeListener),this.$doc=null},this.send=function(e,t){this.$worker.postMessage({command:e,args:t})},this.call=function(e,t,n){if(n){var i=this.callbackId++;this.callbacks[i]=n,t.push(i)}this.send(e,t)},this.emit=function(e,t){try{t.data&&t.data.err&&(t.data.err={message:t.data.err.message,stack:t.data.err.stack,code:t.data.err.code}),this.$worker.postMessage({event:e,data:{data:t.data}})}catch(e){console.error(e.stack)}},this.attachToDocument=function(e){this.$doc&&this.terminate(),this.$doc=e,this.call("setValue",[e.getValue()]),e.on("change",this.changeListener)},this.changeListener=function(e){this.deltaQueue||(this.deltaQueue=[],setTimeout(this.$sendDeltaQueue,0)),"insert"==e.action?this.deltaQueue.push(e.start,e.lines):this.deltaQueue.push(e.start,e.end)},this.$sendDeltaQueue=function(){var e=this.deltaQueue;e&&(this.deltaQueue=null,e.length>50&&e.length>this.$doc.getLength()>>1?this.call("setValue",[this.$doc.getValue()]):this.emit("change",{data:e}))}}).call(l.prototype),t.UIWorkerClient=function(e,t,n){var i=null,r=!1,a=Object.create(s),c=[],u=new l({messageBuffer:c,terminate:function(){},postMessage:function(e){c.push(e),i&&(r?setTimeout(h):h())}});u.setEmitSync=function(e){r=e};var h=function(){var e=c.shift();e.command?i[e.command].apply(i,e.args):e.event&&a._signal(e.event,e.data)};return a.postMessage=function(e){u.onMessage({data:e})},a.callback=function(e,t){this.postMessage({type:"call",id:t,data:e})},a.emit=function(e,t){this.postMessage({type:"event",name:e,data:t})},o.loadModule(["worker",t],(function(e){for(i=new e[n](a);c.length;)h()})),u},t.WorkerClient=l,t.createWorker=a})),ace.define("ace/placeholder",["require","exports","module","ace/range","ace/lib/event_emitter","ace/lib/oop"],(function(e,t,n){"use strict";var i=e("./range").Range,r=e("./lib/event_emitter").EventEmitter,s=e("./lib/oop"),o=function(e,t,n,i,r,s){var o=this;this.length=t,this.session=e,this.doc=e.getDocument(),this.mainClass=r,this.othersClass=s,this.$onUpdate=this.onUpdate.bind(this),this.doc.on("change",this.$onUpdate),this.$others=i,this.$onCursorChange=function(){setTimeout((function(){o.onCursorChange()}))},this.$pos=n;var a=e.getUndoManager().$undoStack||e.getUndoManager().$undostack||{length:-1};this.$undoStackDepth=a.length,this.setup(),e.selection.on("changeCursor",this.$onCursorChange)};(function(){s.implement(this,r),this.setup=function(){var e=this,t=this.doc,n=this.session;this.selectionBefore=n.selection.toJSON(),n.selection.inMultiSelectMode&&n.selection.toSingleRange(),this.pos=t.createAnchor(this.$pos.row,this.$pos.column);var r=this.pos;r.$insertRight=!0,r.detach(),r.markerId=n.addMarker(new i(r.row,r.column,r.row,r.column+this.length),this.mainClass,null,!1),this.others=[],this.$others.forEach((function(n){var i=t.createAnchor(n.row,n.column);i.$insertRight=!0,i.detach(),e.others.push(i)})),n.setUndoSelect(!1)},this.showOtherMarkers=function(){if(!this.othersActive){var e=this.session,t=this;this.othersActive=!0,this.others.forEach((function(n){n.markerId=e.addMarker(new i(n.row,n.column,n.row,n.column+t.length),t.othersClass,null,!1)}))}},this.hideOtherMarkers=function(){if(this.othersActive){this.othersActive=!1;for(var e=0;e<this.others.length;e++)this.session.removeMarker(this.others[e].markerId)}},this.onUpdate=function(e){if(this.$updating)return this.updateAnchors(e);var t=e;if(t.start.row===t.end.row&&t.start.row===this.pos.row){this.$updating=!0;var n="insert"===e.action?t.end.column-t.start.column:t.start.column-t.end.column,r=t.start.column>=this.pos.column&&t.start.column<=this.pos.column+this.length+1,s=t.start.column-this.pos.column;if(this.updateAnchors(e),r&&(this.length+=n),r&&!this.session.$fromUndo)if("insert"===e.action)for(var o=this.others.length-1;o>=0;o--){var a={row:(l=this.others[o]).row,column:l.column+s};this.doc.insertMergedLines(a,e.lines)}else if("remove"===e.action)for(o=this.others.length-1;o>=0;o--){var l;a={row:(l=this.others[o]).row,column:l.column+s},this.doc.remove(new i(a.row,a.column,a.row,a.column-n))}this.$updating=!1,this.updateMarkers()}},this.updateAnchors=function(e){this.pos.onChange(e);for(var t=this.others.length;t--;)this.others[t].onChange(e);this.updateMarkers()},this.updateMarkers=function(){if(!this.$updating){var e=this,t=this.session,n=function(n,r){t.removeMarker(n.markerId),n.markerId=t.addMarker(new i(n.row,n.column,n.row,n.column+e.length),r,null,!1)};n(this.pos,this.mainClass);for(var r=this.others.length;r--;)n(this.others[r],this.othersClass)}},this.onCursorChange=function(e){if(!this.$updating&&this.session){var t=this.session.selection.getCursor();t.row===this.pos.row&&t.column>=this.pos.column&&t.column<=this.pos.column+this.length?(this.showOtherMarkers(),this._emit("cursorEnter",e)):(this.hideOtherMarkers(),this._emit("cursorLeave",e))}},this.detach=function(){this.session.removeMarker(this.pos&&this.pos.markerId),this.hideOtherMarkers(),this.doc.removeEventListener("change",this.$onUpdate),this.session.selection.removeEventListener("changeCursor",this.$onCursorChange),this.session.setUndoSelect(!0),this.session=null},this.cancel=function(){if(-1!==this.$undoStackDepth){for(var e=this.session.getUndoManager(),t=(e.$undoStack||e.$undostack).length-this.$undoStackDepth,n=0;n<t;n++)e.undo(this.session,!0);this.selectionBefore&&this.session.selection.fromJSON(this.selectionBefore)}}}).call(o.prototype),t.PlaceHolder=o})),ace.define("ace/mouse/multi_select_handler",["require","exports","module","ace/lib/event","ace/lib/useragent"],(function(e,t,n){var i=e("../lib/event"),r=e("../lib/useragent");function s(e,t){return e.row==t.row&&e.column==t.column}t.onMouseDown=function(e){var t=e.domEvent,n=t.altKey,o=t.shiftKey,a=t.ctrlKey,l=e.getAccelKey(),c=e.getButton();if(a&&r.isMac&&(c=t.button),e.editor.inMultiSelectMode&&2==c)e.editor.textInput.onContextMenu(e.domEvent);else if(a||n||l){if(0===c){var u,h=e.editor,d=h.selection,m=h.inMultiSelectMode,p=e.getDocumentPosition(),g=d.getCursor(),f=e.inSelection()||d.isEmpty()&&s(p,g),E=e.x,v=e.y,_=h.session,C=h.renderer.pixelToScreenCoordinates(E,v),A=C;if(h.$mouseHandler.$enableJumpToDef)a&&n||l&&n?u=o?"block":"add":n&&h.$blockSelectEnabled&&(u="block");else if(l&&!n){if(u="add",!m&&o)return}else n&&h.$blockSelectEnabled&&(u="block");if(u&&r.isMac&&t.ctrlKey&&h.$mouseHandler.cancelContextMenu(),"add"==u){if(!m&&f)return;if(!m){var R=d.toOrientedRange();h.addSelectionMarker(R)}var S=d.rangeList.rangeAtPoint(p);h.inVirtualSelectionMode=!0,o&&(S=null,R=d.ranges[0]||R,h.removeSelectionMarker(R)),h.once("mouseup",(function(){var e=d.toOrientedRange();S&&e.isEmpty()&&s(S.cursor,e.cursor)?d.substractPoint(e.cursor):(o?d.substractPoint(R.cursor):R&&(h.removeSelectionMarker(R),d.addRange(R)),d.addRange(e)),h.inVirtualSelectionMode=!1}))}else if("block"==u){var T;e.stop(),h.inVirtualSelectionMode=!0;var b=[],w=function(){var e=h.renderer.pixelToScreenCoordinates(E,v),t=_.screenToDocumentPosition(e.row,e.column,e.offsetX);s(A,e)&&s(t,d.lead)||(A=e,h.selection.moveToPosition(t),h.renderer.scrollCursorIntoView(),h.removeSelectionMarkers(b),b=d.rectangularRangeBlock(A,C),h.$mouseHandler.$clickSelection&&1==b.length&&b[0].isEmpty()&&(b[0]=h.$mouseHandler.$clickSelection.clone()),b.forEach(h.addSelectionMarker,h),h.updateSelectionMarkers())};m&&!l?d.toSingleRange():!m&&l&&(T=d.toOrientedRange(),h.addSelectionMarker(T)),o?C=_.documentToScreenPosition(d.lead):d.moveToPosition(p),A={row:-1,column:-1};var x=w;i.capture(h.container,(function(e){E=e.clientX,v=e.clientY}),(function(e){w(),clearInterval(y),h.removeSelectionMarkers(b),b.length||(b=[d.toOrientedRange()]),T&&(h.removeSelectionMarker(T),d.toSingleRange(T));for(var t=0;t<b.length;t++)d.addRange(b[t]);h.inVirtualSelectionMode=!1,h.$mouseHandler.$clickSelection=null}));var y=setInterval((function(){x()}),20);return e.preventDefault()}}}else 0===c&&e.editor.inMultiSelectMode&&e.editor.exitMultiSelectMode()}})),ace.define("ace/commands/multi_select_commands",["require","exports","module","ace/keyboard/hash_handler"],(function(e,t,n){t.defaultCommands=[{name:"addCursorAbove",description:"Add cursor above",exec:function(e){e.selectMoreLines(-1)},bindKey:{win:"Ctrl-Alt-Up",mac:"Ctrl-Alt-Up"},scrollIntoView:"cursor",readOnly:!0},{name:"addCursorBelow",description:"Add cursor below",exec:function(e){e.selectMoreLines(1)},bindKey:{win:"Ctrl-Alt-Down",mac:"Ctrl-Alt-Down"},scrollIntoView:"cursor",readOnly:!0},{name:"addCursorAboveSkipCurrent",description:"Add cursor above (skip current)",exec:function(e){e.selectMoreLines(-1,!0)},bindKey:{win:"Ctrl-Alt-Shift-Up",mac:"Ctrl-Alt-Shift-Up"},scrollIntoView:"cursor",readOnly:!0},{name:"addCursorBelowSkipCurrent",description:"Add cursor below (skip current)",exec:function(e){e.selectMoreLines(1,!0)},bindKey:{win:"Ctrl-Alt-Shift-Down",mac:"Ctrl-Alt-Shift-Down"},scrollIntoView:"cursor",readOnly:!0},{name:"selectMoreBefore",description:"Select more before",exec:function(e){e.selectMore(-1)},bindKey:{win:"Ctrl-Alt-Left",mac:"Ctrl-Alt-Left"},scrollIntoView:"cursor",readOnly:!0},{name:"selectMoreAfter",description:"Select more after",exec:function(e){e.selectMore(1)},bindKey:{win:"Ctrl-Alt-Right",mac:"Ctrl-Alt-Right"},scrollIntoView:"cursor",readOnly:!0},{name:"selectNextBefore",description:"Select next before",exec:function(e){e.selectMore(-1,!0)},bindKey:{win:"Ctrl-Alt-Shift-Left",mac:"Ctrl-Alt-Shift-Left"},scrollIntoView:"cursor",readOnly:!0},{name:"selectNextAfter",description:"Select next after",exec:function(e){e.selectMore(1,!0)},bindKey:{win:"Ctrl-Alt-Shift-Right",mac:"Ctrl-Alt-Shift-Right"},scrollIntoView:"cursor",readOnly:!0},{name:"splitIntoLines",description:"Split into lines",exec:function(e){e.multiSelect.splitIntoLines()},bindKey:{win:"Ctrl-Alt-L",mac:"Ctrl-Alt-L"},readOnly:!0},{name:"alignCursors",description:"Align cursors",exec:function(e){e.alignCursors()},bindKey:{win:"Ctrl-Alt-A",mac:"Ctrl-Alt-A"},scrollIntoView:"cursor"},{name:"findAll",description:"Find all",exec:function(e){e.findAll()},bindKey:{win:"Ctrl-Alt-K",mac:"Ctrl-Alt-G"},scrollIntoView:"cursor",readOnly:!0}],t.multiSelectCommands=[{name:"singleSelection",description:"Single selection",bindKey:"esc",exec:function(e){e.exitMultiSelectMode()},scrollIntoView:"cursor",readOnly:!0,isAvailable:function(e){return e&&e.inMultiSelectMode}}];var i=e("../keyboard/hash_handler").HashHandler;t.keyboardHandler=new i(t.multiSelectCommands)})),ace.define("ace/multi_select",["require","exports","module","ace/range_list","ace/range","ace/selection","ace/mouse/multi_select_handler","ace/lib/event","ace/lib/lang","ace/commands/multi_select_commands","ace/search","ace/edit_session","ace/editor","ace/config"],(function(e,t,n){var i=e("./range_list").RangeList,r=e("./range").Range,s=e("./selection").Selection,o=e("./mouse/multi_select_handler").onMouseDown,a=e("./lib/event"),l=e("./lib/lang"),c=e("./commands/multi_select_commands");t.commands=c.defaultCommands.concat(c.multiSelectCommands);var u=new(0,e("./search").Search),h=e("./edit_session").EditSession;(function(){this.getSelectionMarkers=function(){return this.$selectionMarkers}}).call(h.prototype),function(){this.ranges=null,this.rangeList=null,this.addRange=function(e,t){if(e){if(!this.inMultiSelectMode&&0===this.rangeCount){var n=this.toOrientedRange();if(this.rangeList.add(n),this.rangeList.add(e),2!=this.rangeList.ranges.length)return this.rangeList.removeAll(),t||this.fromOrientedRange(e);this.rangeList.removeAll(),this.rangeList.add(n),this.$onAddRange(n)}e.cursor||(e.cursor=e.end);var i=this.rangeList.add(e);return this.$onAddRange(e),i.length&&this.$onRemoveRange(i),this.rangeCount>1&&!this.inMultiSelectMode&&(this._signal("multiSelect"),this.inMultiSelectMode=!0,this.session.$undoSelect=!1,this.rangeList.attach(this.session)),t||this.fromOrientedRange(e)}},this.toSingleRange=function(e){e=e||this.ranges[0];var t=this.rangeList.removeAll();t.length&&this.$onRemoveRange(t),e&&this.fromOrientedRange(e)},this.substractPoint=function(e){var t=this.rangeList.substractPoint(e);if(t)return this.$onRemoveRange(t),t[0]},this.mergeOverlappingRanges=function(){var e=this.rangeList.merge();e.length&&this.$onRemoveRange(e)},this.$onAddRange=function(e){this.rangeCount=this.rangeList.ranges.length,this.ranges.unshift(e),this._signal("addRange",{range:e})},this.$onRemoveRange=function(e){if(this.rangeCount=this.rangeList.ranges.length,1==this.rangeCount&&this.inMultiSelectMode){var t=this.rangeList.ranges.pop();e.push(t),this.rangeCount=0}for(var n=e.length;n--;){var i=this.ranges.indexOf(e[n]);this.ranges.splice(i,1)}this._signal("removeRange",{ranges:e}),0===this.rangeCount&&this.inMultiSelectMode&&(this.inMultiSelectMode=!1,this._signal("singleSelect"),this.session.$undoSelect=!0,this.rangeList.detach(this.session)),(t=t||this.ranges[0])&&!t.isEqual(this.getRange())&&this.fromOrientedRange(t)},this.$initRangeList=function(){this.rangeList||(this.rangeList=new i,this.ranges=[],this.rangeCount=0)},this.getAllRanges=function(){return this.rangeCount?this.rangeList.ranges.concat():[this.getRange()]},this.splitIntoLines=function(){if(this.rangeCount>1){var e=this.rangeList.ranges,t=e[e.length-1],n=r.fromPoints(e[0].start,t.end);this.toSingleRange(),this.setSelectionRange(n,t.cursor==t.start)}else{n=this.getRange();var i=this.isBackwards(),s=n.start.row,o=n.end.row;if(s==o){if(i)var a=n.end,l=n.start;else a=n.start,l=n.end;return this.addRange(r.fromPoints(l,l)),void this.addRange(r.fromPoints(a,a))}var c=[],u=this.getLineRange(s,!0);u.start.column=n.start.column,c.push(u);for(var h=s+1;h<o;h++)c.push(this.getLineRange(h,!0));(u=this.getLineRange(o,!0)).end.column=n.end.column,c.push(u),c.forEach(this.addRange,this)}},this.toggleBlockSelection=function(){if(this.rangeCount>1){var e=this.rangeList.ranges,t=e[e.length-1],n=r.fromPoints(e[0].start,t.end);this.toSingleRange(),this.setSelectionRange(n,t.cursor==t.start)}else{var i=this.session.documentToScreenPosition(this.cursor),s=this.session.documentToScreenPosition(this.anchor);this.rectangularRangeBlock(i,s).forEach(this.addRange,this)}},this.rectangularRangeBlock=function(e,t,n){var i=[],s=e.column<t.column;if(s)var o=e.column,a=t.column,l=e.offsetX,c=t.offsetX;else o=t.column,a=e.column,l=t.offsetX,c=e.offsetX;var u,h,d,m=e.row<t.row;if(m)var p=e.row,g=t.row;else p=t.row,g=e.row;o<0&&(o=0),p<0&&(p=0),p==g&&(n=!0);for(var f=p;f<=g;f++){var E=r.fromPoints(this.session.screenToDocumentPosition(f,o,l),this.session.screenToDocumentPosition(f,a,c));if(E.isEmpty()){if(u&&(d=u,(h=E.end).row==d.row&&h.column==d.column))break;u=E.end}E.cursor=s?E.start:E.end,i.push(E)}if(m&&i.reverse(),!n){for(var v=i.length-1;i[v].isEmpty()&&v>0;)v--;if(v>0)for(var _=0;i[_].isEmpty();)_++;for(var C=v;C>=_;C--)i[C].isEmpty()&&i.splice(C,1)}return i}}.call(s.prototype);var d=e("./editor").Editor;function m(e){e.$multiselectOnSessionChange||(e.$onAddRange=e.$onAddRange.bind(e),e.$onRemoveRange=e.$onRemoveRange.bind(e),e.$onMultiSelect=e.$onMultiSelect.bind(e),e.$onSingleSelect=e.$onSingleSelect.bind(e),e.$multiselectOnSessionChange=t.onSessionChange.bind(e),e.$checkMultiselectChange=e.$checkMultiselectChange.bind(e),e.$multiselectOnSessionChange(e),e.on("changeSession",e.$multiselectOnSessionChange),e.on("mousedown",o),e.commands.addCommands(c.defaultCommands),function(e){if(e.textInput){var t=e.textInput.getElement(),n=!1;a.addListener(t,"keydown",(function(t){var r=18==t.keyCode&&!(t.ctrlKey||t.shiftKey||t.metaKey);e.$blockSelectEnabled&&r?n||(e.renderer.setMouseCursor("crosshair"),n=!0):n&&i()})),a.addListener(t,"keyup",i),a.addListener(t,"blur",i)}function i(t){n&&(e.renderer.setMouseCursor(""),n=!1)}}(e))}(function(){this.updateSelectionMarkers=function(){this.renderer.updateCursor(),this.renderer.updateBackMarkers()},this.addSelectionMarker=function(e){e.cursor||(e.cursor=e.end);var t=this.getSelectionStyle();return e.marker=this.session.addMarker(e,"ace_selection",t),this.session.$selectionMarkers.push(e),this.session.selectionMarkerCount=this.session.$selectionMarkers.length,e},this.removeSelectionMarker=function(e){if(e.marker){this.session.removeMarker(e.marker);var t=this.session.$selectionMarkers.indexOf(e);-1!=t&&this.session.$selectionMarkers.splice(t,1),this.session.selectionMarkerCount=this.session.$selectionMarkers.length}},this.removeSelectionMarkers=function(e){for(var t=this.session.$selectionMarkers,n=e.length;n--;){var i=e[n];if(i.marker){this.session.removeMarker(i.marker);var r=t.indexOf(i);-1!=r&&t.splice(r,1)}}this.session.selectionMarkerCount=t.length},this.$onAddRange=function(e){this.addSelectionMarker(e.range),this.renderer.updateCursor(),this.renderer.updateBackMarkers()},this.$onRemoveRange=function(e){this.removeSelectionMarkers(e.ranges),this.renderer.updateCursor(),this.renderer.updateBackMarkers()},this.$onMultiSelect=function(e){this.inMultiSelectMode||(this.inMultiSelectMode=!0,this.setStyle("ace_multiselect"),this.keyBinding.addKeyboardHandler(c.keyboardHandler),this.commands.setDefaultHandler("exec",this.$onMultiSelectExec),this.renderer.updateCursor(),this.renderer.updateBackMarkers())},this.$onSingleSelect=function(e){this.session.multiSelect.inVirtualMode||(this.inMultiSelectMode=!1,this.unsetStyle("ace_multiselect"),this.keyBinding.removeKeyboardHandler(c.keyboardHandler),this.commands.removeDefaultHandler("exec",this.$onMultiSelectExec),this.renderer.updateCursor(),this.renderer.updateBackMarkers(),this._emit("changeSelection"))},this.$onMultiSelectExec=function(e){var t=e.command,n=e.editor;if(n.multiSelect){if(t.multiSelectAction)"forEach"==t.multiSelectAction?i=n.forEachSelection(t,e.args):"forEachLine"==t.multiSelectAction?i=n.forEachSelection(t,e.args,!0):"single"==t.multiSelectAction?(n.exitMultiSelectMode(),i=t.exec(n,e.args||{})):i=t.multiSelectAction(n,e.args||{});else{var i=t.exec(n,e.args||{});n.multiSelect.addRange(n.multiSelect.toOrientedRange()),n.multiSelect.mergeOverlappingRanges()}return i}},this.forEachSelection=function(e,t,n){if(!this.inVirtualSelectionMode){var i,r=n&&n.keepOrder,o=1==n||n&&n.$byLines,a=this.session,l=this.selection,c=l.rangeList,u=(r?l:c).ranges;if(!u.length)return e.exec?e.exec(this,t||{}):e(this,t||{});var h=l._eventRegistry;l._eventRegistry={};var d=new s(a);this.inVirtualSelectionMode=!0;for(var m=u.length;m--;){if(o)for(;m>0&&u[m].start.row==u[m-1].end.row;)m--;d.fromOrientedRange(u[m]),d.index=m,this.selection=a.selection=d;var p=e.exec?e.exec(this,t||{}):e(this,t||{});i||void 0===p||(i=p),d.toOrientedRange(u[m])}d.detach(),this.selection=a.selection=l,this.inVirtualSelectionMode=!1,l._eventRegistry=h,l.mergeOverlappingRanges(),l.ranges[0]&&l.fromOrientedRange(l.ranges[0]);var g=this.renderer.$scrollAnimation;return this.onCursorChange(),this.onSelectionChange(),g&&g.from==g.to&&this.renderer.animateScrolling(g.from),i}},this.exitMultiSelectMode=function(){this.inMultiSelectMode&&!this.inVirtualSelectionMode&&this.multiSelect.toSingleRange()},this.getSelectedText=function(){var e="";if(this.inMultiSelectMode&&!this.inVirtualSelectionMode){for(var t=this.multiSelect.rangeList.ranges,n=[],i=0;i<t.length;i++)n.push(this.session.getTextRange(t[i]));var r=this.session.getDocument().getNewLineCharacter();(e=n.join(r)).length==(n.length-1)*r.length&&(e="")}else this.selection.isEmpty()||(e=this.session.getTextRange(this.getSelectionRange()));return e},this.$checkMultiselectChange=function(e,t){if(this.inMultiSelectMode&&!this.inVirtualSelectionMode){var n=this.multiSelect.ranges[0];if(this.multiSelect.isEmpty()&&t==this.multiSelect.anchor)return;var i=t==this.multiSelect.anchor?n.cursor==n.start?n.end:n.start:n.cursor;i.row!=t.row||this.session.$clipPositionToDocument(i.row,i.column).column!=t.column?this.multiSelect.toSingleRange(this.multiSelect.toOrientedRange()):this.multiSelect.mergeOverlappingRanges()}},this.findAll=function(e,t,n){if((t=t||{}).needle=e||t.needle,null==t.needle){var i=this.selection.isEmpty()?this.selection.getWordRange():this.selection.getRange();t.needle=this.session.getTextRange(i)}this.$search.set(t);var r=this.$search.findAll(this.session);if(!r.length)return 0;var s=this.multiSelect;n||s.toSingleRange(r[0]);for(var o=r.length;o--;)s.addRange(r[o],!0);return i&&s.rangeList.rangeAtPoint(i.start)&&s.addRange(i,!0),r.length},this.selectMoreLines=function(e,t){var n=this.selection.toOrientedRange(),i=n.cursor==n.end,s=this.session.documentToScreenPosition(n.cursor);this.selection.$desiredColumn&&(s.column=this.selection.$desiredColumn);var o,a=this.session.screenToDocumentPosition(s.row+e,s.column);if(n.isEmpty())c=a;else var l=this.session.documentToScreenPosition(i?n.end:n.start),c=this.session.screenToDocumentPosition(l.row+e,l.column);if(i?(o=r.fromPoints(a,c)).cursor=o.start:(o=r.fromPoints(c,a)).cursor=o.end,o.desiredColumn=s.column,this.selection.inMultiSelectMode){if(t)var u=n.cursor}else this.selection.addRange(n);this.selection.addRange(o),u&&this.selection.substractPoint(u)},this.transposeSelections=function(e){for(var t=this.session,n=t.multiSelect,i=n.ranges,r=i.length;r--;)if((a=i[r]).isEmpty()){var s=t.getWordRange(a.start.row,a.start.column);a.start.row=s.start.row,a.start.column=s.start.column,a.end.row=s.end.row,a.end.column=s.end.column}n.mergeOverlappingRanges();var o=[];for(r=i.length;r--;){var a=i[r];o.unshift(t.getTextRange(a))}for(e<0?o.unshift(o.pop()):o.push(o.shift()),r=i.length;r--;)s=(a=i[r]).clone(),t.replace(a,o[r]),a.start.row=s.start.row,a.start.column=s.start.column;n.fromOrientedRange(n.ranges[0])},this.selectMore=function(e,t,n){var i=this.session,r=i.multiSelect.toOrientedRange();if(!r.isEmpty()||((r=i.getWordRange(r.start.row,r.start.column)).cursor=-1==e?r.start:r.end,this.multiSelect.addRange(r),!n)){var s=i.getTextRange(r),o=function(e,t,n){return u.$options.wrap=!0,u.$options.needle=t,u.$options.backwards=-1==n,u.find(e)}(i,s,e);o&&(o.cursor=-1==e?o.start:o.end,this.session.unfold(o),this.multiSelect.addRange(o),this.renderer.scrollCursorIntoView(null,.5)),t&&this.multiSelect.substractPoint(r.cursor)}},this.alignCursors=function(){var e=this.session,t=e.multiSelect,n=t.ranges,i=-1,s=n.filter((function(e){if(e.cursor.row==i)return!0;i=e.cursor.row}));if(n.length&&s.length!=n.length-1){s.forEach((function(e){t.substractPoint(e.cursor)}));var o=0,a=1/0,c=n.map((function(t){var n=t.cursor,i=e.getLine(n.row).substr(n.column).search(/\S/g);return-1==i&&(i=0),n.column>o&&(o=n.column),i<a&&(a=i),i}));n.forEach((function(t,n){var i=t.cursor,s=o-i.column,u=c[n]-a;s>u?e.insert(i,l.stringRepeat(" ",s-u)):e.remove(new r(i.row,i.column,i.row,i.column-s+u)),t.start.column=t.end.column=o,t.start.row=t.end.row=i.row,t.cursor=t.end})),t.fromOrientedRange(n[0]),this.renderer.updateCursor(),this.renderer.updateBackMarkers()}else{var u=this.selection.getRange(),h=u.start.row,d=u.end.row,m=h==d;if(m){var p,g=this.session.getLength();do{p=this.session.getLine(d)}while(/[=:]/.test(p)&&++d<g);do{p=this.session.getLine(h)}while(/[=:]/.test(p)&&--h>0);h<0&&(h=0),d>=g&&(d=g-1)}var f=this.session.removeFullLines(h,d);f=this.$reAlignText(f,m),this.session.insert({row:h,column:0},f.join("\n")+"\n"),m||(u.start.column=0,u.end.column=f[f.length-1].length),this.selection.setRange(u)}},this.$reAlignText=function(e,t){var n,i,r,s=!0,o=!0;return e.map((function(e){var t=e.match(/(\s*)(.*?)(\s*)([=:].*)/);return t?null==n?(n=t[1].length,i=t[2].length,r=t[3].length,t):(n+i+r!=t[1].length+t[2].length+t[3].length&&(o=!1),n!=t[1].length&&(s=!1),n>t[1].length&&(n=t[1].length),i<t[2].length&&(i=t[2].length),r>t[3].length&&(r=t[3].length),t):[e]})).map(t?c:s?o?function(e){return e[2]?a(n+i-e[2].length)+e[2]+a(r)+e[4].replace(/^([=:])\s+/,"$1 "):e[0]}:c:function(e){return e[2]?a(n)+e[2]+a(r)+e[4].replace(/^([=:])\s+/,"$1 "):e[0]});function a(e){return l.stringRepeat(" ",e)}function c(e){return e[2]?a(n)+e[2]+a(i-e[2].length+r)+e[4].replace(/^([=:])\s+/,"$1 "):e[0]}}}).call(d.prototype),t.onSessionChange=function(e){var t=e.session;t&&!t.multiSelect&&(t.$selectionMarkers=[],t.selection.$initRangeList(),t.multiSelect=t.selection),this.multiSelect=t&&t.multiSelect;var n=e.oldSession;n&&(n.multiSelect.off("addRange",this.$onAddRange),n.multiSelect.off("removeRange",this.$onRemoveRange),n.multiSelect.off("multiSelect",this.$onMultiSelect),n.multiSelect.off("singleSelect",this.$onSingleSelect),n.multiSelect.lead.off("change",this.$checkMultiselectChange),n.multiSelect.anchor.off("change",this.$checkMultiselectChange)),t&&(t.multiSelect.on("addRange",this.$onAddRange),t.multiSelect.on("removeRange",this.$onRemoveRange),t.multiSelect.on("multiSelect",this.$onMultiSelect),t.multiSelect.on("singleSelect",this.$onSingleSelect),t.multiSelect.lead.on("change",this.$checkMultiselectChange),t.multiSelect.anchor.on("change",this.$checkMultiselectChange)),t&&this.inMultiSelectMode!=t.selection.inMultiSelectMode&&(t.selection.inMultiSelectMode?this.$onMultiSelect():this.$onSingleSelect())},t.MultiSelect=m,e("./config").defineOptions(d.prototype,"editor",{enableMultiselect:{set:function(e){m(this),e?(this.on("changeSession",this.$multiselectOnSessionChange),this.on("mousedown",o)):(this.off("changeSession",this.$multiselectOnSessionChange),this.off("mousedown",o))},value:!0},enableBlockSelect:{set:function(e){this.$blockSelectEnabled=e},value:!0}})})),ace.define("ace/mode/folding/fold_mode",["require","exports","module","ace/range"],(function(e,t,n){"use strict";var i=e("../../range").Range,r=t.FoldMode=function(){};(function(){this.foldingStartMarker=null,this.foldingStopMarker=null,this.getFoldWidget=function(e,t,n){var i=e.getLine(n);return this.foldingStartMarker.test(i)?"start":"markbeginend"==t&&this.foldingStopMarker&&this.foldingStopMarker.test(i)?"end":""},this.getFoldWidgetRange=function(e,t,n){return null},this.indentationBlock=function(e,t,n){var r=/\S/,s=e.getLine(t),o=s.search(r);if(-1!=o){for(var a=n||s.length,l=e.getLength(),c=t,u=t;++t<l;){var h=e.getLine(t).search(r);if(-1!=h){if(h<=o){var d=e.getTokenAt(t,0);if(!d||"string"!==d.type)break}u=t}}if(u>c){var m=e.getLine(u).length;return new i(c,a,u,m)}}},this.openingBracketBlock=function(e,t,n,r,s){var o={row:n,column:r+1},a=e.$findClosingBracket(t,o,s);if(a){var l=e.foldWidgets[a.row];return null==l&&(l=e.getFoldWidget(a.row)),"start"==l&&a.row>o.row&&(a.row--,a.column=e.getLine(a.row).length),i.fromPoints(o,a)}},this.closingBracketBlock=function(e,t,n,r,s){var o={row:n,column:r},a=e.$findOpeningBracket(t,o);if(a)return a.column++,o.column--,i.fromPoints(a,o)}}).call(r.prototype)})),ace.define("ace/theme/textmate",["require","exports","module","ace/lib/dom"],(function(e,t,n){"use strict";t.isDark=!1,t.cssClass="ace-tm",t.cssText='.ace-tm .ace_gutter {background: #f0f0f0;color: #333;}.ace-tm .ace_print-margin {width: 1px;background: #e8e8e8;}.ace-tm .ace_fold {background-color: #6B72E6;}.ace-tm {background-color: #FFFFFF;color: black;}.ace-tm .ace_cursor {color: black;}.ace-tm .ace_invisible {color: rgb(191, 191, 191);}.ace-tm .ace_storage,.ace-tm .ace_keyword {color: blue;}.ace-tm .ace_constant {color: rgb(197, 6, 11);}.ace-tm .ace_constant.ace_buildin {color: rgb(88, 72, 246);}.ace-tm .ace_constant.ace_language {color: rgb(88, 92, 246);}.ace-tm .ace_constant.ace_library {color: rgb(6, 150, 14);}.ace-tm .ace_invalid {background-color: rgba(255, 0, 0, 0.1);color: red;}.ace-tm .ace_support.ace_function {color: rgb(60, 76, 114);}.ace-tm .ace_support.ace_constant {color: rgb(6, 150, 14);}.ace-tm .ace_support.ace_type,.ace-tm .ace_support.ace_class {color: rgb(109, 121, 222);}.ace-tm .ace_keyword.ace_operator {color: rgb(104, 118, 135);}.ace-tm .ace_string {color: rgb(3, 106, 7);}.ace-tm .ace_comment {color: rgb(76, 136, 107);}.ace-tm .ace_comment.ace_doc {color: rgb(0, 102, 255);}.ace-tm .ace_comment.ace_doc.ace_tag {color: rgb(128, 159, 191);}.ace-tm .ace_constant.ace_numeric {color: rgb(0, 0, 205);}.ace-tm .ace_variable {color: rgb(49, 132, 149);}.ace-tm .ace_xml-pe {color: rgb(104, 104, 91);}.ace-tm .ace_entity.ace_name.ace_function {color: #0000A2;}.ace-tm .ace_heading {color: rgb(12, 7, 255);}.ace-tm .ace_list {color:rgb(185, 6, 144);}.ace-tm .ace_meta.ace_tag {color:rgb(0, 22, 142);}.ace-tm .ace_string.ace_regex {color: rgb(255, 0, 0)}.ace-tm .ace_marker-layer .ace_selection {background: rgb(181, 213, 255);}.ace-tm.ace_multiselect .ace_selection.ace_start {box-shadow: 0 0 3px 0px white;}.ace-tm .ace_marker-layer .ace_step {background: rgb(252, 255, 0);}.ace-tm .ace_marker-layer .ace_stack {background: rgb(164, 229, 101);}.ace-tm .ace_marker-layer .ace_bracket {margin: -1px 0 0 -1px;border: 1px solid rgb(192, 192, 192);}.ace-tm .ace_marker-layer .ace_active-line {background: rgba(0, 0, 0, 0.07);}.ace-tm .ace_gutter-active-line {background-color : #dcdcdc;}.ace-tm .ace_marker-layer .ace_selected-word {background: rgb(250, 250, 255);border: 1px solid rgb(200, 200, 250);}.ace-tm .ace_indent-guide {background: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAEAAAACCAYAAACZgbYnAAAAE0lEQVQImWP4////f4bLly//BwAmVgd1/w11/gAAAABJRU5ErkJggg==") right repeat-y;}',t.$id="ace/theme/textmate",e("../lib/dom").importCssString(t.cssText,t.cssClass)})),ace.define("ace/line_widgets",["require","exports","module","ace/lib/oop","ace/lib/dom","ace/range"],(function(e,t,n){"use strict";e("./lib/oop");var i=e("./lib/dom");function r(e){this.session=e,this.session.widgetManager=this,this.session.getRowLength=this.getRowLength,this.session.$getWidgetScreenLength=this.$getWidgetScreenLength,this.updateOnChange=this.updateOnChange.bind(this),this.renderWidgets=this.renderWidgets.bind(this),this.measureWidgets=this.measureWidgets.bind(this),this.session._changedWidgets=[],this.$onChangeEditor=this.$onChangeEditor.bind(this),this.session.on("change",this.updateOnChange),this.session.on("changeFold",this.updateOnFold),this.session.on("changeEditor",this.$onChangeEditor)}e("./range").Range,function(){this.getRowLength=function(e){var t;return t=this.lineWidgets&&this.lineWidgets[e]&&this.lineWidgets[e].rowCount||0,this.$useWrapMode&&this.$wrapData[e]?this.$wrapData[e].length+1+t:1+t},this.$getWidgetScreenLength=function(){var e=0;return this.lineWidgets.forEach((function(t){t&&t.rowCount&&!t.hidden&&(e+=t.rowCount)})),e},this.$onChangeEditor=function(e){this.attach(e.editor)},this.attach=function(e){e&&e.widgetManager&&e.widgetManager!=this&&e.widgetManager.detach(),this.editor!=e&&(this.detach(),this.editor=e,e&&(e.widgetManager=this,e.renderer.on("beforeRender",this.measureWidgets),e.renderer.on("afterRender",this.renderWidgets)))},this.detach=function(e){var t=this.editor;if(t){this.editor=null,t.widgetManager=null,t.renderer.off("beforeRender",this.measureWidgets),t.renderer.off("afterRender",this.renderWidgets);var n=this.session.lineWidgets;n&&n.forEach((function(e){e&&e.el&&e.el.parentNode&&(e._inDocument=!1,e.el.parentNode.removeChild(e.el))}))}},this.updateOnFold=function(e,t){var n=t.lineWidgets;if(n&&e.action){for(var i=e.data,r=i.start.row,s=i.end.row,o="add"==e.action,a=r+1;a<s;a++)n[a]&&(n[a].hidden=o);n[s]&&(o?n[r]?n[s].hidden=o:n[r]=n[s]:(n[r]==n[s]&&(n[r]=void 0),n[s].hidden=o))}},this.updateOnChange=function(e){var t=this.session.lineWidgets;if(t){var n=e.start.row,i=e.end.row-n;if(0===i);else if("remove"==e.action)t.splice(n+1,i).forEach((function(e){e&&this.removeLineWidget(e)}),this),this.$updateRows();else{var r=new Array(i);r.unshift(n,0),t.splice.apply(t,r),this.$updateRows()}}},this.$updateRows=function(){var e=this.session.lineWidgets;if(e){var t=!0;e.forEach((function(e,n){if(e)for(t=!1,e.row=n;e.$oldWidget;)e.$oldWidget.row=n,e=e.$oldWidget})),t&&(this.session.lineWidgets=null)}},this.addLineWidget=function(e){this.session.lineWidgets||(this.session.lineWidgets=new Array(this.session.getLength()));var t=this.session.lineWidgets[e.row];t&&(e.$oldWidget=t,t.el&&t.el.parentNode&&(t.el.parentNode.removeChild(t.el),t._inDocument=!1)),this.session.lineWidgets[e.row]=e,e.session=this.session;var n=this.editor.renderer;e.html&&!e.el&&(e.el=i.createElement("div"),e.el.innerHTML=e.html),e.el&&(i.addCssClass(e.el,"ace_lineWidgetContainer"),e.el.style.position="absolute",e.el.style.zIndex=5,n.container.appendChild(e.el),e._inDocument=!0),e.coverGutter||(e.el.style.zIndex=3),null==e.pixelHeight&&(e.pixelHeight=e.el.offsetHeight),null==e.rowCount&&(e.rowCount=e.pixelHeight/n.layerConfig.lineHeight);var r=this.session.getFoldAt(e.row,0);if(e.$fold=r,r){var s=this.session.lineWidgets;e.row!=r.end.row||s[r.start.row]?e.hidden=!0:s[r.start.row]=e}return this.session._emit("changeFold",{data:{start:{row:e.row}}}),this.$updateRows(),this.renderWidgets(null,n),this.onWidgetChanged(e),e},this.removeLineWidget=function(e){if(e._inDocument=!1,e.session=null,e.el&&e.el.parentNode&&e.el.parentNode.removeChild(e.el),e.editor&&e.editor.destroy)try{e.editor.destroy()}catch(e){}if(this.session.lineWidgets){var t=this.session.lineWidgets[e.row];if(t==e)this.session.lineWidgets[e.row]=e.$oldWidget,e.$oldWidget&&this.onWidgetChanged(e.$oldWidget);else for(;t;){if(t.$oldWidget==e){t.$oldWidget=e.$oldWidget;break}t=t.$oldWidget}}this.session._emit("changeFold",{data:{start:{row:e.row}}}),this.$updateRows()},this.getWidgetsAtRow=function(e){for(var t=this.session.lineWidgets,n=t&&t[e],i=[];n;)i.push(n),n=n.$oldWidget;return i},this.onWidgetChanged=function(e){this.session._changedWidgets.push(e),this.editor&&this.editor.renderer.updateFull()},this.measureWidgets=function(e,t){var n=this.session._changedWidgets,i=t.layerConfig;if(n&&n.length){for(var r=1/0,s=0;s<n.length;s++){var o=n[s];if(o&&o.el&&o.session==this.session){if(!o._inDocument){if(this.session.lineWidgets[o.row]!=o)continue;o._inDocument=!0,t.container.appendChild(o.el)}o.h=o.el.offsetHeight,o.fixedWidth||(o.w=o.el.offsetWidth,o.screenWidth=Math.ceil(o.w/i.characterWidth));var a=o.h/i.lineHeight;o.coverLine&&(a-=this.session.getRowLineCount(o.row))<0&&(a=0),o.rowCount!=a&&(o.rowCount=a,o.row<r&&(r=o.row))}}r!=1/0&&(this.session._emit("changeFold",{data:{start:{row:r}}}),this.session.lineWidgetWidth=null),this.session._changedWidgets=[]}},this.renderWidgets=function(e,t){var n=t.layerConfig,i=this.session.lineWidgets;if(i){for(var r=Math.min(this.firstRow,n.firstRow),s=Math.max(this.lastRow,n.lastRow,i.length);r>0&&!i[r];)r--;this.firstRow=n.firstRow,this.lastRow=n.lastRow,t.$cursorLayer.config=n;for(var o=r;o<=s;o++){var a=i[o];if(a&&a.el)if(a.hidden)a.el.style.top=-100-(a.pixelHeight||0)+"px";else{a._inDocument||(a._inDocument=!0,t.container.appendChild(a.el));var l=t.$cursorLayer.getPixelPosition({row:o,column:0},!0).top;a.coverLine||(l+=n.lineHeight*this.session.getRowLineCount(a.row)),a.el.style.top=l-n.offset+"px";var c=a.coverGutter?0:t.gutterWidth;a.fixedWidth||(c-=t.scrollLeft),a.el.style.left=c+"px",a.fullWidth&&a.screenWidth&&(a.el.style.minWidth=n.width+2*n.padding+"px"),a.fixedWidth?a.el.style.right=t.scrollBar.getWidth()+"px":a.el.style.right=""}}}}}.call(r.prototype),t.LineWidgets=r})),ace.define("ace/ext/error_marker",["require","exports","module","ace/line_widgets","ace/lib/dom","ace/range"],(function(e,t,n){"use strict";var i=e("../line_widgets").LineWidgets,r=e("../lib/dom"),s=e("../range").Range;t.showErrorMarker=function(e,t){var n=e.session;n.widgetManager||(n.widgetManager=new i(n),n.widgetManager.attach(e));var o=e.getCursorPosition(),a=o.row,l=n.widgetManager.getWidgetsAtRow(a).filter((function(e){return"errorMarker"==e.type}))[0];l?l.destroy():a-=t;var c,u=function(e,t,n){var i=e.getAnnotations().sort(s.comparePoints);if(i.length){var r=function(e,t,n){for(var i=0,r=e.length-1;i<=r;){var s=i+r>>1,o=n(t,e[s]);if(o>0)i=s+1;else{if(!(o<0))return s;r=s-1}}return-(i+1)}(i,{row:t,column:-1},s.comparePoints);r<0&&(r=-r-1),r>=i.length?r=n>0?0:i.length-1:0===r&&n<0&&(r=i.length-1);var o=i[r];if(o&&n){if(o.row===t){do{o=i[r+=n]}while(o&&o.row===t);if(!o)return i.slice()}var a=[];t=o.row;do{a[n<0?"unshift":"push"](o),o=i[r+=n]}while(o&&o.row==t);return a.length&&a}}}(n,a,t);if(u){var h=u[0];o.column=(h.pos&&"number"!=typeof h.column?h.pos.sc:h.column)||0,o.row=h.row,c=e.renderer.$gutterLayer.$annotations[o.row]}else{if(l)return;c={text:["Looks good!"],className:"ace_ok"}}e.session.unfold(o.row),e.selection.moveToPosition(o);var d={row:o.row,fixedWidth:!0,coverGutter:!0,el:r.createElement("div"),type:"errorMarker"},m=d.el.appendChild(r.createElement("div")),p=d.el.appendChild(r.createElement("div"));p.className="error_widget_arrow "+c.className;var g=e.renderer.$cursorLayer.getPixelPosition(o).left;p.style.left=g+e.renderer.gutterWidth-5+"px",d.el.className="error_widget_wrapper",m.className="error_widget "+c.className,m.innerHTML=c.text.join("<br>"),m.appendChild(r.createElement("div"));var f=function(e,t,n){if(0===t&&("esc"===n||"return"===n))return d.destroy(),{command:"null"}};d.destroy=function(){e.$mouseHandler.isMousePressed||(e.keyBinding.removeKeyboardHandler(f),n.widgetManager.removeLineWidget(d),e.off("changeSelection",d.destroy),e.off("changeSession",d.destroy),e.off("mouseup",d.destroy),e.off("change",d.destroy))},e.keyBinding.addKeyboardHandler(f),e.on("changeSelection",d.destroy),e.on("changeSession",d.destroy),e.on("mouseup",d.destroy),e.on("change",d.destroy),e.session.widgetManager.addLineWidget(d),d.el.onmousedown=e.focus.bind(e),e.renderer.scrollCursorIntoView(null,.5,{bottom:d.el.offsetHeight})},r.importCssString("    .error_widget_wrapper {        background: inherit;        color: inherit;        border:none    }    .error_widget {        border-top: solid 2px;        border-bottom: solid 2px;        margin: 5px 0;        padding: 10px 40px;        white-space: pre-wrap;    }    .error_widget.ace_error, .error_widget_arrow.ace_error{        border-color: #ff5a5a    }    .error_widget.ace_warning, .error_widget_arrow.ace_warning{        border-color: #F1D817    }    .error_widget.ace_info, .error_widget_arrow.ace_info{        border-color: #5a5a5a    }    .error_widget.ace_ok, .error_widget_arrow.ace_ok{        border-color: #5aaa5a    }    .error_widget_arrow {        position: absolute;        border: solid 5px;        border-top-color: transparent!important;        border-right-color: transparent!important;        border-left-color: transparent!important;        top: -5px;    }","")})),ace.define("ace/ace",["require","exports","module","ace/lib/fixoldbrowsers","ace/lib/dom","ace/lib/event","ace/range","ace/editor","ace/edit_session","ace/undomanager","ace/virtual_renderer","ace/worker/worker_client","ace/keyboard/hash_handler","ace/placeholder","ace/multi_select","ace/mode/folding/fold_mode","ace/theme/textmate","ace/ext/error_marker","ace/config"],(function(e,t,i){"use strict";e("./lib/fixoldbrowsers");var r=e("./lib/dom"),s=e("./lib/event"),o=e("./range").Range,a=e("./editor").Editor,l=e("./edit_session").EditSession,c=e("./undomanager").UndoManager,u=e("./virtual_renderer").VirtualRenderer;e("./worker/worker_client"),e("./keyboard/hash_handler"),e("./placeholder"),e("./multi_select"),e("./mode/folding/fold_mode"),e("./theme/textmate"),e("./ext/error_marker"),t.config=e("./config"),t.require=e,t.define=n.amdD,t.edit=function(e,n){if("string"==typeof e){var i=e;if(!(e=document.getElementById(i)))throw new Error("ace.edit can't find div #"+i)}if(e&&e.env&&e.env.editor instanceof a)return e.env.editor;var o="";if(e&&/input|textarea/i.test(e.tagName)){var l=e;o=l.value,e=r.createElement("pre"),l.parentNode.replaceChild(e,l)}else e&&(o=e.textContent,e.innerHTML="");var c=t.createEditSession(o),h=new a(new u(e),c,n),d={document:c,editor:h,onResize:h.resize.bind(h,null)};return l&&(d.textarea=l),s.addListener(window,"resize",d.onResize),h.on("destroy",(function(){s.removeListener(window,"resize",d.onResize),d.editor.container.env=null})),h.container.env=h.env=d,h},t.createEditSession=function(e,t){var n=new l(e,t);return n.setUndoManager(new c),n},t.Range=o,t.Editor=a,t.EditSession=l,t.UndoManager=c,t.VirtualRenderer=u,t.version=t.config.version})),ace.require(["ace/ace"],(function(t){for(var n in t&&(t.config.init(!0),t.define=ace.define),window.ace||(window.ace=t),t)t.hasOwnProperty(n)&&(window.ace[n]=t[n]);window.ace.default=window.ace,e&&(e.exports=window.ace)})),e.exports={ace}},655:(e,t,n)=>{"use strict";var i=n(379),r=n.n(i),s=n(795),o=n.n(s),a=n(569),l=n.n(a),c=n(565),u=n.n(c),h=n(216),d=n.n(h),m=n(589),p=n.n(m),g=n(827),f={};f.styleTagTransform=p(),f.setAttributes=u(),f.insert=l().bind(null,"html"),f.domAPI=o(),f.insertStyleElement=d(),r()(g.Z,f),g.Z&&g.Z.locals&&g.Z.locals},379:e=>{"use strict";var t=[];function n(e){for(var n=-1,i=0;i<t.length;i++)if(t[i].identifier===e){n=i;break}return n}function i(e,i){for(var s={},o=[],a=0;a<e.length;a++){var l=e[a],c=i.base?l[0]+i.base:l[0],u=s[c]||0,h="".concat(c," ").concat(u);s[c]=u+1;var d=n(h),m={css:l[1],media:l[2],sourceMap:l[3],supports:l[4],layer:l[5]};if(-1!==d)t[d].references++,t[d].updater(m);else{var p=r(m,i);i.byIndex=a,t.splice(a,0,{identifier:h,updater:p,references:1})}o.push(h)}return o}function r(e,t){var n=t.domAPI(t);return n.update(e),function(t){if(t){if(t.css===e.css&&t.media===e.media&&t.sourceMap===e.sourceMap&&t.supports===e.supports&&t.layer===e.layer)return;n.update(e=t)}else n.remove()}}e.exports=function(e,r){var s=i(e=e||[],r=r||{});return function(e){e=e||[];for(var o=0;o<s.length;o++){var a=n(s[o]);t[a].references--}for(var l=i(e,r),c=0;c<s.length;c++){var u=n(s[c]);0===t[u].references&&(t[u].updater(),t.splice(u,1))}s=l}}},569:e=>{"use strict";var t={};e.exports=function(e,n){var i=function(e){if(void 0===t[e]){var n=document.querySelector(e);if(window.HTMLIFrameElement&&n instanceof window.HTMLIFrameElement)try{n=n.contentDocument.head}catch(e){n=null}t[e]=n}return t[e]}(e);if(!i)throw new Error("Couldn't find a style target. This probably means that the value for the 'insert' parameter is invalid.");i.appendChild(n)}},216:e=>{"use strict";e.exports=function(e){var t=document.createElement("style");return e.setAttributes(t,e.attributes),e.insert(t,e.options),t}},565:(e,t,n)=>{"use strict";e.exports=function(e){var t=n.nc;t&&e.setAttribute("nonce",t)}},795:e=>{"use strict";e.exports=function(e){var t=e.insertStyleElement(e);return{update:function(n){!function(e,t,n){var i="";n.supports&&(i+="@supports (".concat(n.supports,") {")),n.media&&(i+="@media ".concat(n.media," {"));var r=void 0!==n.layer;r&&(i+="@layer".concat(n.layer.length>0?" ".concat(n.layer):""," {")),i+=n.css,r&&(i+="}"),n.media&&(i+="}"),n.supports&&(i+="}");var s=n.sourceMap;s&&"undefined"!=typeof btoa&&(i+="\n/*# sourceMappingURL=data:application/json;base64,".concat(btoa(unescape(encodeURIComponent(JSON.stringify(s))))," */")),t.styleTagTransform(i,e,t.options)}(t,e,n)},remove:function(){!function(e){if(null===e.parentNode)return!1;e.parentNode.removeChild(e)}(t)}}}},589:e=>{"use strict";e.exports=function(e,t){if(t.styleSheet)t.styleSheet.cssText=e;else{for(;t.firstChild;)t.removeChild(t.firstChild);t.appendChild(document.createTextNode(e))}}},986:(e,t,n)=>{"use strict";n.r(t),n.d(t,{EmbeddedFrontend:()=>qt,Spector:()=>Zt});class i{static isBuildableProgram(e){return!!e&&!!e[this.rebuildProgramFunctionName]}static rebuildProgram(e,t,n,i,r){this.isBuildableProgram(e)&&e[this.rebuildProgramFunctionName](t,n,i,r)}}var r;i.rebuildProgramFunctionName="__SPECTOR_rebuildProgram",function(e){e[e.noLog=0]="noLog",e[e.error=1]="error",e[e.warning=2]="warning",e[e.info=3]="info"}(r||(r={}));class s{static error(e,...t){this.level>0&&console.error(e,t)}static warn(e,...t){this.level>1&&console.warn(e,t)}static info(e,...t){this.level>2&&console.log(e,t)}}s.level=r.warning;class o{constructor(){this.callbacks=[],this.counter=-1}add(e,t){return this.counter++,t&&(e=e.bind(t)),this.callbacks[this.counter]=e,this.counter}remove(e){delete this.callbacks[e]}clear(){this.callbacks={}}trigger(e){for(const t in this.callbacks)this.callbacks.hasOwnProperty(t)&&this.callbacks[t](e)}}class a{constructor(){if(window.performance&&window.performance.now)this.nowFunction=this.dateBasedPerformanceNow.bind(this);else{const e=new Date;this.nowFunction=e.getTime.bind(e)}}dateBasedPerformanceNow(){return performance.timing.navigationStart+performance.now()}static get now(){return a.instance.nowFunction()}}a.instance=new a;class l{constructor(e){this.options=e}appendAnalysis(e){e.analyses=e.analyses||[];const t=this.getAnalysis(e);e.analyses.push(t)}getAnalysis(e){const t={analyserName:this.analyserName};return this.appendToAnalysis(e,t),t}}class c extends l{get analyserName(){return c.analyserName}appendToAnalysis(e,t){if(!e.commands)return;const n={};for(const t of e.commands)n[t.name]=n[t.name]||0,n[t.name]++;const i=Object.keys(n).map((e=>[e,n[e]]));i.sort(((e,t)=>{const n=t[1]-e[1];return 0===n?e[0].localeCompare(t[0]):n}));for(const e of i)t[e[0]]=e[1]}}c.analyserName="Commands";const u=["drawArrays","drawElements","drawArraysInstanced","drawArraysInstancedANGLE","drawElementsInstanced","drawElementsInstancedANGLE","drawRangeElements","multiDrawArraysWEBGL","multiDrawElementsWEBGL","multiDrawArraysInstancedWEBGL","multiDrawElementsInstancedWEBGL","multiDrawArraysInstancedBaseInstanceWEBGL","multiDrawElementsInstancedBaseVertexBaseInstanceWEBGL","drawArraysInstancedBaseInstanceWEBGL","drawElementsInstancedBaseVertexBaseInstanceWEBGL"];class h extends l{get analyserName(){return h.analyserName}appendToAnalysis(e,t){if(e.commands){t.total=e.commands.length,t.draw=0,t.clear=0;for(const n of e.commands)"clear"===n.name?t.clear++:u.indexOf(n.name)>-1&&t.draw++}}}h.analyserName="CommandsSummary";class d{static isWebGlConstant(e){return null!==p[e]&&void 0!==p[e]}static stringifyWebGlConstant(e,t){if(null==e)return"";if(0===e){return this.zeroMeaningByCommand[t]||"0"}if(1===e){return this.oneMeaningByCommand[t]||"1"}const n=p[e];return n?n.name:e+""}}d.DEPTH_BUFFER_BIT={name:"DEPTH_BUFFER_BIT",value:256,description:"Passed to clear to clear the current depth buffer."},d.STENCIL_BUFFER_BIT={name:"STENCIL_BUFFER_BIT",value:1024,description:"Passed to clear to clear the current stencil buffer."},d.COLOR_BUFFER_BIT={name:"COLOR_BUFFER_BIT",value:16384,description:"Passed to clear to clear the current color buffer."},d.POINTS={name:"POINTS",value:0,description:"Passed to drawElements or drawArrays to draw single points."},d.LINES={name:"LINES",value:1,description:"Passed to drawElements or drawArrays to draw lines. Each vertex connects to the one after it."},d.LINE_LOOP={name:"LINE_LOOP",value:2,description:"Passed to drawElements or drawArrays to draw lines. Each set of two vertices is treated as a separate line segment."},d.LINE_STRIP={name:"LINE_STRIP",value:3,description:"Passed to drawElements or drawArrays to draw a connected group of line segments from the first vertex to the last."},d.TRIANGLES={name:"TRIANGLES",value:4,description:"Passed to drawElements or drawArrays to draw triangles. Each set of three vertices creates a separate triangle."},d.TRIANGLE_STRIP={name:"TRIANGLE_STRIP",value:5,description:"Passed to drawElements or drawArrays to draw a connected group of triangles."},d.TRIANGLE_FAN={name:"TRIANGLE_FAN",value:6,description:"Passed to drawElements or drawArrays to draw a connected group of triangles. Each vertex connects to the previous and the first vertex in the fan."},d.ZERO={name:"ZERO",value:0,description:"Passed to blendFunc or blendFuncSeparate to turn off a component."},d.ONE={name:"ONE",value:1,description:"Passed to blendFunc or blendFuncSeparate to turn on a component."},d.SRC_COLOR={name:"SRC_COLOR",value:768,description:"Passed to blendFunc or blendFuncSeparate to multiply a component by the source elements color."},d.ONE_MINUS_SRC_COLOR={name:"ONE_MINUS_SRC_COLOR",value:769,description:"Passed to blendFunc or blendFuncSeparate to multiply a component by one minus the source elements color."},d.SRC_ALPHA={name:"SRC_ALPHA",value:770,description:"Passed to blendFunc or blendFuncSeparate to multiply a component by the source's alpha."},d.ONE_MINUS_SRC_ALPHA={name:"ONE_MINUS_SRC_ALPHA",value:771,description:"Passed to blendFunc or blendFuncSeparate to multiply a component by one minus the source's alpha."},d.DST_ALPHA={name:"DST_ALPHA",value:772,description:"Passed to blendFunc or blendFuncSeparate to multiply a component by the destination's alpha."},d.ONE_MINUS_DST_ALPHA={name:"ONE_MINUS_DST_ALPHA",value:773,description:"Passed to blendFunc or blendFuncSeparate to multiply a component by one minus the destination's alpha."},d.DST_COLOR={name:"DST_COLOR",value:774,description:"Passed to blendFunc or blendFuncSeparate to multiply a component by the destination's color."},d.ONE_MINUS_DST_COLOR={name:"ONE_MINUS_DST_COLOR",value:775,description:"Passed to blendFunc or blendFuncSeparate to multiply a component by one minus the destination's color."},d.SRC_ALPHA_SATURATE={name:"SRC_ALPHA_SATURATE",value:776,description:"Passed to blendFunc or blendFuncSeparate to multiply a component by the minimum of source's alpha or one minus the destination's alpha."},d.CONSTANT_COLOR={name:"CONSTANT_COLOR",value:32769,description:"Passed to blendFunc or blendFuncSeparate to specify a constant color blend function."},d.ONE_MINUS_CONSTANT_COLOR={name:"ONE_MINUS_CONSTANT_COLOR",value:32770,description:"Passed to blendFunc or blendFuncSeparate to specify one minus a constant color blend function."},d.CONSTANT_ALPHA={name:"CONSTANT_ALPHA",value:32771,description:"Passed to blendFunc or blendFuncSeparate to specify a constant alpha blend function."},d.ONE_MINUS_CONSTANT_ALPHA={name:"ONE_MINUS_CONSTANT_ALPHA",value:32772,description:"Passed to blendFunc or blendFuncSeparate to specify one minus a constant alpha blend function."},d.FUNC_ADD={name:"FUNC_ADD",value:32774,description:"Passed to blendEquation or blendEquationSeparate to set an addition blend function."},d.FUNC_SUBSTRACT={name:"FUNC_SUBSTRACT",value:32778,description:"Passed to blendEquation or blendEquationSeparate to specify a subtraction blend function (source - destination)."},d.FUNC_REVERSE_SUBTRACT={name:"FUNC_REVERSE_SUBTRACT",value:32779,description:"Passed to blendEquation or blendEquationSeparate to specify a reverse subtraction blend function (destination - source)."},d.BLEND_EQUATION={name:"BLEND_EQUATION",value:32777,description:"Passed to getParameter to get the current RGB blend function."},d.BLEND_EQUATION_RGB={name:"BLEND_EQUATION_RGB",value:32777,description:"Passed to getParameter to get the current RGB blend function. Same as BLEND_EQUATION"},d.BLEND_EQUATION_ALPHA={name:"BLEND_EQUATION_ALPHA",value:34877,description:"Passed to getParameter to get the current alpha blend function. Same as BLEND_EQUATION"},d.BLEND_DST_RGB={name:"BLEND_DST_RGB",value:32968,description:"Passed to getParameter to get the current destination RGB blend function."},d.BLEND_SRC_RGB={name:"BLEND_SRC_RGB",value:32969,description:"Passed to getParameter to get the current destination RGB blend function."},d.BLEND_DST_ALPHA={name:"BLEND_DST_ALPHA",value:32970,description:"Passed to getParameter to get the current destination alpha blend function."},d.BLEND_SRC_ALPHA={name:"BLEND_SRC_ALPHA",value:32971,description:"Passed to getParameter to get the current source alpha blend function."},d.BLEND_COLOR={name:"BLEND_COLOR",value:32773,description:"Passed to getParameter to return a the current blend color."},d.ARRAY_BUFFER_BINDING={name:"ARRAY_BUFFER_BINDING",value:34964,description:"Passed to getParameter to get the array buffer binding."},d.ELEMENT_ARRAY_BUFFER_BINDING={name:"ELEMENT_ARRAY_BUFFER_BINDING",value:34965,description:"Passed to getParameter to get the current element array buffer."},d.LINE_WIDTH={name:"LINE_WIDTH",value:2849,description:"Passed to getParameter to get the current lineWidth (set by the lineWidth method)."},d.ALIASED_POINT_SIZE_RANGE={name:"ALIASED_POINT_SIZE_RANGE",value:33901,description:"Passed to getParameter to get the current size of a point drawn with gl.POINTS"},d.ALIASED_LINE_WIDTH_RANGE={name:"ALIASED_LINE_WIDTH_RANGE",value:33902,description:"Passed to getParameter to get the range of available widths for a line. Returns a length-2 array with the lo value at 0, and hight at 1."},d.CULL_FACE_MODE={name:"CULL_FACE_MODE",value:2885,description:"Passed to getParameter to get the current value of cullFace. Should return FRONT, BACK, or FRONT_AND_BACK"},d.FRONT_FACE={name:"FRONT_FACE",value:2886,description:"Passed to getParameter to determine the current value of frontFace. Should return CW or CCW."},d.DEPTH_RANGE={name:"DEPTH_RANGE",value:2928,description:"Passed to getParameter to return a length-2 array of floats giving the current depth range."},d.DEPTH_WRITEMASK={name:"DEPTH_WRITEMASK",value:2930,description:"Passed to getParameter to determine if the depth write mask is enabled."},d.DEPTH_CLEAR_VALUE={name:"DEPTH_CLEAR_VALUE",value:2931,description:"Passed to getParameter to determine the current depth clear value."},d.DEPTH_FUNC={name:"DEPTH_FUNC",value:2932,description:"Passed to getParameter to get the current depth function. Returns NEVER, ALWAYS, LESS, EQUAL, LEQUAL, GREATER, GEQUAL, or NOTEQUAL."},d.STENCIL_CLEAR_VALUE={name:"STENCIL_CLEAR_VALUE",value:2961,description:"Passed to getParameter to get the value the stencil will be cleared to."},d.STENCIL_FUNC={name:"STENCIL_FUNC",value:2962,description:"Passed to getParameter to get the current stencil function. Returns NEVER, ALWAYS, LESS, EQUAL, LEQUAL, GREATER, GEQUAL, or NOTEQUAL."},d.STENCIL_FAIL={name:"STENCIL_FAIL",value:2964,description:"Passed to getParameter to get the current stencil fail function. Should return KEEP, REPLACE, INCR, DECR, INVERT, INCR_WRAP, or DECR_WRAP."},d.STENCIL_PASS_DEPTH_FAIL={name:"STENCIL_PASS_DEPTH_FAIL",value:2965,description:"Passed to getParameter to get the current stencil fail function should the depth buffer test fail. Should return KEEP, REPLACE, INCR, DECR, INVERT, INCR_WRAP, or DECR_WRAP."},d.STENCIL_PASS_DEPTH_PASS={name:"STENCIL_PASS_DEPTH_PASS",value:2966,description:"Passed to getParameter to get the current stencil fail function should the depth buffer test pass. Should return KEEP, REPLACE, INCR, DECR, INVERT, INCR_WRAP, or DECR_WRAP."},d.STENCIL_REF={name:"STENCIL_REF",value:2967,description:"Passed to getParameter to get the reference value used for stencil tests."},d.STENCIL_VALUE_MASK={name:"STENCIL_VALUE_MASK",value:2963,description:" "},d.STENCIL_WRITEMASK={name:"STENCIL_WRITEMASK",value:2968,description:" "},d.STENCIL_BACK_FUNC={name:"STENCIL_BACK_FUNC",value:34816,description:" "},d.STENCIL_BACK_FAIL={name:"STENCIL_BACK_FAIL",value:34817,description:" "},d.STENCIL_BACK_PASS_DEPTH_FAIL={name:"STENCIL_BACK_PASS_DEPTH_FAIL",value:34818,description:" "},d.STENCIL_BACK_PASS_DEPTH_PASS={name:"STENCIL_BACK_PASS_DEPTH_PASS",value:34819,description:" "},d.STENCIL_BACK_REF={name:"STENCIL_BACK_REF",value:36003,description:" "},d.STENCIL_BACK_VALUE_MASK={name:"STENCIL_BACK_VALUE_MASK",value:36004,description:" "},d.STENCIL_BACK_WRITEMASK={name:"STENCIL_BACK_WRITEMASK",value:36005,description:" "},d.VIEWPORT={name:"VIEWPORT",value:2978,description:"Returns an Int32Array with four elements for the current viewport dimensions."},d.SCISSOR_BOX={name:"SCISSOR_BOX",value:3088,description:"Returns an Int32Array with four elements for the current scissor box dimensions."},d.COLOR_CLEAR_VALUE={name:"COLOR_CLEAR_VALUE",value:3106,description:" "},d.COLOR_WRITEMASK={name:"COLOR_WRITEMASK",value:3107,description:" "},d.UNPACK_ALIGNMENT={name:"UNPACK_ALIGNMENT",value:3317,description:" "},d.PACK_ALIGNMENT={name:"PACK_ALIGNMENT",value:3333,description:" "},d.MAX_TEXTURE_SIZE={name:"MAX_TEXTURE_SIZE",value:3379,description:" "},d.MAX_VIEWPORT_DIMS={name:"MAX_VIEWPORT_DIMS",value:3386,description:" "},d.SUBPIXEL_BITS={name:"SUBPIXEL_BITS",value:3408,description:" "},d.RED_BITS={name:"RED_BITS",value:3410,description:" "},d.GREEN_BITS={name:"GREEN_BITS",value:3411,description:" "},d.BLUE_BITS={name:"BLUE_BITS",value:3412,description:" "},d.ALPHA_BITS={name:"ALPHA_BITS",value:3413,description:" "},d.DEPTH_BITS={name:"DEPTH_BITS",value:3414,description:" "},d.STENCIL_BITS={name:"STENCIL_BITS",value:3415,description:" "},d.POLYGON_OFFSET_UNITS={name:"POLYGON_OFFSET_UNITS",value:10752,description:" "},d.POLYGON_OFFSET_FACTOR={name:"POLYGON_OFFSET_FACTOR",value:32824,description:" "},d.TEXTURE_BINDING_2D={name:"TEXTURE_BINDING_2D",value:32873,description:" "},d.SAMPLE_BUFFERS={name:"SAMPLE_BUFFERS",value:32936,description:" "},d.SAMPLES={name:"SAMPLES",value:32937,description:" "},d.SAMPLE_COVERAGE_VALUE={name:"SAMPLE_COVERAGE_VALUE",value:32938,description:" "},d.SAMPLE_COVERAGE_INVERT={name:"SAMPLE_COVERAGE_INVERT",value:32939,description:" "},d.COMPRESSED_TEXTURE_FORMATS={name:"COMPRESSED_TEXTURE_FORMATS",value:34467,description:" "},d.VENDOR={name:"VENDOR",value:7936,description:" "},d.RENDERER={name:"RENDERER",value:7937,description:" "},d.VERSION={name:"VERSION",value:7938,description:" "},d.IMPLEMENTATION_COLOR_READ_TYPE={name:"IMPLEMENTATION_COLOR_READ_TYPE",value:35738,description:" "},d.IMPLEMENTATION_COLOR_READ_FORMAT={name:"IMPLEMENTATION_COLOR_READ_FORMAT",value:35739,description:" "},d.BROWSER_DEFAULT_WEBGL={name:"BROWSER_DEFAULT_WEBGL",value:37444,description:" "},d.STATIC_DRAW={name:"STATIC_DRAW",value:35044,description:"Passed to bufferData as a hint about whether the contents of the buffer are likely to be used often and not change often."},d.STREAM_DRAW={name:"STREAM_DRAW",value:35040,description:"Passed to bufferData as a hint about whether the contents of the buffer are likely to not be used often."},d.DYNAMIC_DRAW={name:"DYNAMIC_DRAW",value:35048,description:"Passed to bufferData as a hint about whether the contents of the buffer are likely to be used often and change often."},d.ARRAY_BUFFER={name:"ARRAY_BUFFER",value:34962,description:"Passed to bindBuffer or bufferData to specify the type of buffer being used."},d.ELEMENT_ARRAY_BUFFER={name:"ELEMENT_ARRAY_BUFFER",value:34963,description:"Passed to bindBuffer or bufferData to specify the type of buffer being used."},d.BUFFER_SIZE={name:"BUFFER_SIZE",value:34660,description:"Passed to getBufferParameter to get a buffer's size."},d.BUFFER_USAGE={name:"BUFFER_USAGE",value:34661,description:"Passed to getBufferParameter to get the hint for the buffer passed in when it was created."},d.CURRENT_VERTEX_ATTRIB={name:"CURRENT_VERTEX_ATTRIB",value:34342,description:"Passed to getVertexAttrib to read back the current vertex attribute."},d.VERTEX_ATTRIB_ARRAY_ENABLED={name:"VERTEX_ATTRIB_ARRAY_ENABLED",value:34338,description:" "},d.VERTEX_ATTRIB_ARRAY_SIZE={name:"VERTEX_ATTRIB_ARRAY_SIZE",value:34339,description:" "},d.VERTEX_ATTRIB_ARRAY_STRIDE={name:"VERTEX_ATTRIB_ARRAY_STRIDE",value:34340,description:" "},d.VERTEX_ATTRIB_ARRAY_TYPE={name:"VERTEX_ATTRIB_ARRAY_TYPE",value:34341,description:" "},d.VERTEX_ATTRIB_ARRAY_NORMALIZED={name:"VERTEX_ATTRIB_ARRAY_NORMALIZED",value:34922,description:" "},d.VERTEX_ATTRIB_ARRAY_POINTER={name:"VERTEX_ATTRIB_ARRAY_POINTER",value:34373,description:" "},d.VERTEX_ATTRIB_ARRAY_BUFFER_BINDING={name:"VERTEX_ATTRIB_ARRAY_BUFFER_BINDING",value:34975,description:" "},d.CULL_FACE={name:"CULL_FACE",value:2884,description:"Passed to enable/disable to turn on/off culling. Can also be used with getParameter to find the current culling method."},d.FRONT={name:"FRONT",value:1028,description:"Passed to cullFace to specify that only front faces should be drawn."},d.BACK={name:"BACK",value:1029,description:"Passed to cullFace to specify that only back faces should be drawn."},d.FRONT_AND_BACK={name:"FRONT_AND_BACK",value:1032,description:"Passed to cullFace to specify that front and back faces should be drawn."},d.BLEND={name:"BLEND",value:3042,description:"Passed to enable/disable to turn on/off blending. Can also be used with getParameter to find the current blending method."},d.DEPTH_TEST={name:"DEPTH_TEST",value:2929,description:"Passed to enable/disable to turn on/off the depth test. Can also be used with getParameter to query the depth test."},d.DITHER={name:"DITHER",value:3024,description:"Passed to enable/disable to turn on/off dithering. Can also be used with getParameter to find the current dithering method."},d.POLYGON_OFFSET_FILL={name:"POLYGON_OFFSET_FILL",value:32823,description:"Passed to enable/disable to turn on/off the polygon offset. Useful for rendering hidden-line images, decals, and or solids with highlighted edges. Can also be used with getParameter to query the scissor test."},d.SAMPLE_ALPHA_TO_COVERAGE={name:"SAMPLE_ALPHA_TO_COVERAGE",value:32926,description:"Passed to enable/disable to turn on/off the alpha to coverage. Used in multi-sampling alpha channels."},d.SAMPLE_COVERAGE={name:"SAMPLE_COVERAGE",value:32928,description:"Passed to enable/disable to turn on/off the sample coverage. Used in multi-sampling."},d.SCISSOR_TEST={name:"SCISSOR_TEST",value:3089,description:"Passed to enable/disable to turn on/off the scissor test. Can also be used with getParameter to query the scissor test."},d.STENCIL_TEST={name:"STENCIL_TEST",value:2960,description:"Passed to enable/disable to turn on/off the stencil test. Can also be used with getParameter to query the stencil test."},d.NO_ERROR={name:"NO_ERROR",value:0,description:"Returned from getError."},d.INVALID_ENUM={name:"INVALID_ENUM",value:1280,description:"Returned from getError."},d.INVALID_VALUE={name:"INVALID_VALUE",value:1281,description:"Returned from getError."},d.INVALID_OPERATION={name:"INVALID_OPERATION",value:1282,description:"Returned from getError."},d.OUT_OF_MEMORY={name:"OUT_OF_MEMORY",value:1285,description:"Returned from getError."},d.CONTEXT_LOST_WEBGL={name:"CONTEXT_LOST_WEBGL",value:37442,description:"Returned from getError."},d.CW={name:"CW",value:2304,description:"Passed to frontFace to specify the front face of a polygon is drawn in the clockwise direction"},d.CCW={name:"CCW",value:2305,description:"Passed to frontFace to specify the front face of a polygon is drawn in the counter clockwise direction"},d.DONT_CARE={name:"DONT_CARE",value:4352,description:"There is no preference for this behavior."},d.FASTEST={name:"FASTEST",value:4353,description:"The most efficient behavior should be used."},d.NICEST={name:"NICEST",value:4354,description:"The most correct or the highest quality option should be used."},d.GENERATE_MIPMAP_HINT={name:"GENERATE_MIPMAP_HINT",value:33170,description:"Hint for the quality of filtering when generating mipmap images with WebGLRenderingContext.generateMipmap()."},d.BYTE={name:"BYTE",value:5120,description:" "},d.UNSIGNED_BYTE={name:"UNSIGNED_BYTE",value:5121,description:" "},d.SHORT={name:"SHORT",value:5122,description:" "},d.UNSIGNED_SHORT={name:"UNSIGNED_SHORT",value:5123,description:" "},d.INT={name:"INT",value:5124,description:" "},d.UNSIGNED_INT={name:"UNSIGNED_INT",value:5125,description:" "},d.FLOAT={name:"FLOAT",value:5126,description:" "},d.DEPTH_COMPONENT={name:"DEPTH_COMPONENT",value:6402,description:" "},d.ALPHA={name:"ALPHA",value:6406,description:" "},d.RGB={name:"RGB",value:6407,description:" "},d.RGBA={name:"RGBA",value:6408,description:" "},d.LUMINANCE={name:"LUMINANCE",value:6409,description:" "},d.LUMINANCE_ALPHA={name:"LUMINANCE_ALPHA",value:6410,description:" "},d.UNSIGNED_SHORT_4_4_4_4={name:"UNSIGNED_SHORT_4_4_4_4",value:32819,description:" "},d.UNSIGNED_SHORT_5_5_5_1={name:"UNSIGNED_SHORT_5_5_5_1",value:32820,description:" "},d.UNSIGNED_SHORT_5_6_5={name:"UNSIGNED_SHORT_5_6_5",value:33635,description:" "},d.FRAGMENT_SHADER={name:"FRAGMENT_SHADER",value:35632,description:"Passed to createShader to define a fragment shader."},d.VERTEX_SHADER={name:"VERTEX_SHADER",value:35633,description:"Passed to createShader to define a vertex shader"},d.COMPILE_STATUS={name:"COMPILE_STATUS",value:35713,description:"Passed to getShaderParamter to get the status of the compilation. Returns false if the shader was not compiled. You can then query getShaderInfoLog to find the exact error"},d.DELETE_STATUS={name:"DELETE_STATUS",value:35712,description:"Passed to getShaderParamter to determine if a shader was deleted via deleteShader. Returns true if it was, false otherwise."},d.LINK_STATUS={name:"LINK_STATUS",value:35714,description:"Passed to getProgramParameter after calling linkProgram to determine if a program was linked correctly. Returns false if there were errors. Use getProgramInfoLog to find the exact error."},d.VALIDATE_STATUS={name:"VALIDATE_STATUS",value:35715,description:"Passed to getProgramParameter after calling validateProgram to determine if it is valid. Returns false if errors were found."},d.ATTACHED_SHADERS={name:"ATTACHED_SHADERS",value:35717,description:"Passed to getProgramParameter after calling attachShader to determine if the shader was attached correctly. Returns false if errors occurred."},d.ACTIVE_ATTRIBUTES={name:"ACTIVE_ATTRIBUTES",value:35721,description:"Passed to getProgramParameter to get the number of attributes active in a program."},d.ACTIVE_UNIFORMS={name:"ACTIVE_UNIFORMS",value:35718,description:"Passed to getProgramParamter to get the number of uniforms active in a program."},d.MAX_VERTEX_ATTRIBS={name:"MAX_VERTEX_ATTRIBS",value:34921,description:" "},d.MAX_VERTEX_UNIFORM_VECTORS={name:"MAX_VERTEX_UNIFORM_VECTORS",value:36347,description:" "},d.MAX_VARYING_VECTORS={name:"MAX_VARYING_VECTORS",value:36348,description:" "},d.MAX_COMBINED_TEXTURE_IMAGE_UNITS={name:"MAX_COMBINED_TEXTURE_IMAGE_UNITS",value:35661,description:" "},d.MAX_VERTEX_TEXTURE_IMAGE_UNITS={name:"MAX_VERTEX_TEXTURE_IMAGE_UNITS",value:35660,description:" "},d.MAX_TEXTURE_IMAGE_UNITS={name:"MAX_TEXTURE_IMAGE_UNITS",value:34930,description:"Implementation dependent number of maximum texture units. At least 8."},d.MAX_FRAGMENT_UNIFORM_VECTORS={name:"MAX_FRAGMENT_UNIFORM_VECTORS",value:36349,description:" "},d.SHADER_TYPE={name:"SHADER_TYPE",value:35663,description:" "},d.SHADING_LANGUAGE_VERSION={name:"SHADING_LANGUAGE_VERSION",value:35724,description:" "},d.CURRENT_PROGRAM={name:"CURRENT_PROGRAM",value:35725,description:" "},d.NEVER={name:"NEVER",value:512,description:"Passed to depthFunction or stencilFunction to specify depth or stencil tests will never pass. i.e. Nothing will be drawn."},d.ALWAYS={name:"ALWAYS",value:519,description:"Passed to depthFunction or stencilFunction to specify depth or stencil tests will always pass. i.e. Pixels will be drawn in the order they are drawn."},d.LESS={name:"LESS",value:513,description:"Passed to depthFunction or stencilFunction to specify depth or stencil tests will pass if the new depth value is less than the stored value."},d.EQUAL={name:"EQUAL",value:514,description:"Passed to depthFunction or stencilFunction to specify depth or stencil tests will pass if the new depth value is equals to the stored value."},d.LEQUAL={name:"LEQUAL",value:515,description:"Passed to depthFunction or stencilFunction to specify depth or stencil tests will pass if the new depth value is less than or equal to the stored value."},d.GREATER={name:"GREATER",value:516,description:"Passed to depthFunction or stencilFunction to specify depth or stencil tests will pass if the new depth value is greater than the stored value."},d.GEQUAL={name:"GEQUAL",value:518,description:"Passed to depthFunction or stencilFunction to specify depth or stencil tests will pass if the new depth value is greater than or equal to the stored value."},d.NOTEQUAL={name:"NOTEQUAL",value:517,description:"Passed to depthFunction or stencilFunction to specify depth or stencil tests will pass if the new depth value is not equal to the stored value."},d.KEEP={name:"KEEP",value:7680,description:" "},d.REPLACE={name:"REPLACE",value:7681,description:" "},d.INCR={name:"INCR",value:7682,description:" "},d.DECR={name:"DECR",value:7683,description:" "},d.INVERT={name:"INVERT",value:5386,description:" "},d.INCR_WRAP={name:"INCR_WRAP",value:34055,description:" "},d.DECR_WRAP={name:"DECR_WRAP",value:34056,description:" "},d.NEAREST={name:"NEAREST",value:9728,description:" "},d.LINEAR={name:"LINEAR",value:9729,description:" "},d.NEAREST_MIPMAP_NEAREST={name:"NEAREST_MIPMAP_NEAREST",value:9984,description:" "},d.LINEAR_MIPMAP_NEAREST={name:"LINEAR_MIPMAP_NEAREST",value:9985,description:" "},d.NEAREST_MIPMAP_LINEAR={name:"NEAREST_MIPMAP_LINEAR",value:9986,description:" "},d.LINEAR_MIPMAP_LINEAR={name:"LINEAR_MIPMAP_LINEAR",value:9987,description:" "},d.TEXTURE_MAG_FILTER={name:"TEXTURE_MAG_FILTER",value:10240,description:" "},d.TEXTURE_MIN_FILTER={name:"TEXTURE_MIN_FILTER",value:10241,description:" "},d.TEXTURE_WRAP_S={name:"TEXTURE_WRAP_S",value:10242,description:" "},d.TEXTURE_WRAP_T={name:"TEXTURE_WRAP_T",value:10243,description:" "},d.TEXTURE_2D={name:"TEXTURE_2D",value:3553,description:" "},d.TEXTURE={name:"TEXTURE",value:5890,description:" "},d.TEXTURE_CUBE_MAP={name:"TEXTURE_CUBE_MAP",value:34067,description:" "},d.TEXTURE_BINDING_CUBE_MAP={name:"TEXTURE_BINDING_CUBE_MAP",value:34068,description:" "},d.TEXTURE_CUBE_MAP_POSITIVE_X={name:"TEXTURE_CUBE_MAP_POSITIVE_X",value:34069,description:" "},d.TEXTURE_CUBE_MAP_NEGATIVE_X={name:"TEXTURE_CUBE_MAP_NEGATIVE_X",value:34070,description:" "},d.TEXTURE_CUBE_MAP_POSITIVE_Y={name:"TEXTURE_CUBE_MAP_POSITIVE_Y",value:34071,description:" "},d.TEXTURE_CUBE_MAP_NEGATIVE_Y={name:"TEXTURE_CUBE_MAP_NEGATIVE_Y",value:34072,description:" "},d.TEXTURE_CUBE_MAP_POSITIVE_Z={name:"TEXTURE_CUBE_MAP_POSITIVE_Z",value:34073,description:" "},d.TEXTURE_CUBE_MAP_NEGATIVE_Z={name:"TEXTURE_CUBE_MAP_NEGATIVE_Z",value:34074,description:" "},d.MAX_CUBE_MAP_TEXTURE_SIZE={name:"MAX_CUBE_MAP_TEXTURE_SIZE",value:34076,description:" "},d.TEXTURE0={name:"TEXTURE0",value:33984,description:"A texture unit."},d.TEXTURE1={name:"TEXTURE1",value:33985,description:"A texture unit."},d.TEXTURE2={name:"TEXTURE2",value:33986,description:"A texture unit."},d.TEXTURE3={name:"TEXTURE3",value:33987,description:"A texture unit."},d.TEXTURE4={name:"TEXTURE4",value:33988,description:"A texture unit."},d.TEXTURE5={name:"TEXTURE5",value:33989,description:"A texture unit."},d.TEXTURE6={name:"TEXTURE6",value:33990,description:"A texture unit."},d.TEXTURE7={name:"TEXTURE7",value:33991,description:"A texture unit."},d.TEXTURE8={name:"TEXTURE8",value:33992,description:"A texture unit."},d.TEXTURE9={name:"TEXTURE9",value:33993,description:"A texture unit."},d.TEXTURE10={name:"TEXTURE10",value:33994,description:"A texture unit."},d.TEXTURE11={name:"TEXTURE11",value:33995,description:"A texture unit."},d.TEXTURE12={name:"TEXTURE12",value:33996,description:"A texture unit."},d.TEXTURE13={name:"TEXTURE13",value:33997,description:"A texture unit."},d.TEXTURE14={name:"TEXTURE14",value:33998,description:"A texture unit."},d.TEXTURE15={name:"TEXTURE15",value:33999,description:"A texture unit."},d.TEXTURE16={name:"TEXTURE16",value:34e3,description:"A texture unit."},d.TEXTURE17={name:"TEXTURE17",value:34001,description:"A texture unit."},d.TEXTURE18={name:"TEXTURE18",value:34002,description:"A texture unit."},d.TEXTURE19={name:"TEXTURE19",value:34003,description:"A texture unit."},d.TEXTURE20={name:"TEXTURE20",value:34004,description:"A texture unit."},d.TEXTURE21={name:"TEXTURE21",value:34005,description:"A texture unit."},d.TEXTURE22={name:"TEXTURE22",value:34006,description:"A texture unit."},d.TEXTURE23={name:"TEXTURE23",value:34007,description:"A texture unit."},d.TEXTURE24={name:"TEXTURE24",value:34008,description:"A texture unit."},d.TEXTURE25={name:"TEXTURE25",value:34009,description:"A texture unit."},d.TEXTURE26={name:"TEXTURE26",value:34010,description:"A texture unit."},d.TEXTURE27={name:"TEXTURE27",value:34011,description:"A texture unit."},d.TEXTURE28={name:"TEXTURE28",value:34012,description:"A texture unit."},d.TEXTURE29={name:"TEXTURE29",value:34013,description:"A texture unit."},d.TEXTURE30={name:"TEXTURE30",value:34014,description:"A texture unit."},d.TEXTURE31={name:"TEXTURE31",value:34015,description:"A texture unit."},d.ACTIVE_TEXTURE={name:"ACTIVE_TEXTURE",value:34016,description:"The current active texture unit."},d.REPEAT={name:"REPEAT",value:10497,description:" "},d.CLAMP_TO_EDGE={name:"CLAMP_TO_EDGE",value:33071,description:" "},d.MIRRORED_REPEAT={name:"MIRRORED_REPEAT",value:33648,description:" "},d.FLOAT_VEC2={name:"FLOAT_VEC2",value:35664,description:" "},d.FLOAT_VEC3={name:"FLOAT_VEC3",value:35665,description:" "},d.FLOAT_VEC4={name:"FLOAT_VEC4",value:35666,description:" "},d.INT_VEC2={name:"INT_VEC2",value:35667,description:" "},d.INT_VEC3={name:"INT_VEC3",value:35668,description:" "},d.INT_VEC4={name:"INT_VEC4",value:35669,description:" "},d.BOOL={name:"BOOL",value:35670,description:" "},d.BOOL_VEC2={name:"BOOL_VEC2",value:35671,description:" "},d.BOOL_VEC3={name:"BOOL_VEC3",value:35672,description:" "},d.BOOL_VEC4={name:"BOOL_VEC4",value:35673,description:" "},d.FLOAT_MAT2={name:"FLOAT_MAT2",value:35674,description:" "},d.FLOAT_MAT3={name:"FLOAT_MAT3",value:35675,description:" "},d.FLOAT_MAT4={name:"FLOAT_MAT4",value:35676,description:" "},d.SAMPLER_2D={name:"SAMPLER_2D",value:35678,description:" "},d.SAMPLER_CUBE={name:"SAMPLER_CUBE",value:35680,description:" "},d.LOW_FLOAT={name:"LOW_FLOAT",value:36336,description:" "},d.MEDIUM_FLOAT={name:"MEDIUM_FLOAT",value:36337,description:" "},d.HIGH_FLOAT={name:"HIGH_FLOAT",value:36338,description:" "},d.LOW_INT={name:"LOW_INT",value:36339,description:" "},d.MEDIUM_INT={name:"MEDIUM_INT",value:36340,description:" "},d.HIGH_INT={name:"HIGH_INT",value:36341,description:" "},d.FRAMEBUFFER={name:"FRAMEBUFFER",value:36160,description:" "},d.RENDERBUFFER={name:"RENDERBUFFER",value:36161,description:" "},d.RGBA4={name:"RGBA4",value:32854,description:" "},d.RGB5_A1={name:"RGB5_A1",value:32855,description:" "},d.RGB565={name:"RGB565",value:36194,description:" "},d.DEPTH_COMPONENT16={name:"DEPTH_COMPONENT16",value:33189,description:" "},d.STENCIL_INDEX={name:"STENCIL_INDEX",value:6401,description:" "},d.STENCIL_INDEX8={name:"STENCIL_INDEX8",value:36168,description:" "},d.DEPTH_STENCIL={name:"DEPTH_STENCIL",value:34041,description:" "},d.RENDERBUFFER_WIDTH={name:"RENDERBUFFER_WIDTH",value:36162,description:" "},d.RENDERBUFFER_HEIGHT={name:"RENDERBUFFER_HEIGHT",value:36163,description:" "},d.RENDERBUFFER_INTERNAL_FORMAT={name:"RENDERBUFFER_INTERNAL_FORMAT",value:36164,description:" "},d.RENDERBUFFER_RED_SIZE={name:"RENDERBUFFER_RED_SIZE",value:36176,description:" "},d.RENDERBUFFER_GREEN_SIZE={name:"RENDERBUFFER_GREEN_SIZE",value:36177,description:" "},d.RENDERBUFFER_BLUE_SIZE={name:"RENDERBUFFER_BLUE_SIZE",value:36178,description:" "},d.RENDERBUFFER_ALPHA_SIZE={name:"RENDERBUFFER_ALPHA_SIZE",value:36179,description:" "},d.RENDERBUFFER_DEPTH_SIZE={name:"RENDERBUFFER_DEPTH_SIZE",value:36180,description:" "},d.RENDERBUFFER_STENCIL_SIZE={name:"RENDERBUFFER_STENCIL_SIZE",value:36181,description:" "},d.FRAMEBUFFER_ATTACHMENT_OBJECT_TYPE={name:"FRAMEBUFFER_ATTACHMENT_OBJECT_TYPE",value:36048,description:" "},d.FRAMEBUFFER_ATTACHMENT_OBJECT_NAME={name:"FRAMEBUFFER_ATTACHMENT_OBJECT_NAME",value:36049,description:" "},d.FRAMEBUFFER_ATTACHMENT_TEXTURE_LEVEL={name:"FRAMEBUFFER_ATTACHMENT_TEXTURE_LEVEL",value:36050,description:" "},d.FRAMEBUFFER_ATTACHMENT_TEXTURE_CUBE_MAP_FACE={name:"FRAMEBUFFER_ATTACHMENT_TEXTURE_CUBE_MAP_FACE",value:36051,description:" "},d.COLOR_ATTACHMENT0={name:"COLOR_ATTACHMENT0",value:36064,description:" "},d.DEPTH_ATTACHMENT={name:"DEPTH_ATTACHMENT",value:36096,description:" "},d.STENCIL_ATTACHMENT={name:"STENCIL_ATTACHMENT",value:36128,description:" "},d.DEPTH_STENCIL_ATTACHMENT={name:"DEPTH_STENCIL_ATTACHMENT",value:33306,description:" "},d.NONE={name:"NONE",value:0,description:" "},d.FRAMEBUFFER_COMPLETE={name:"FRAMEBUFFER_COMPLETE",value:36053,description:" "},d.FRAMEBUFFER_INCOMPLETE_ATTACHMENT={name:"FRAMEBUFFER_INCOMPLETE_ATTACHMENT",value:36054,description:" "},d.FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT={name:"FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT",value:36055,description:" "},d.FRAMEBUFFER_INCOMPLETE_DIMENSIONS={name:"FRAMEBUFFER_INCOMPLETE_DIMENSIONS",value:36057,description:" "},d.FRAMEBUFFER_UNSUPPORTED={name:"FRAMEBUFFER_UNSUPPORTED",value:36061,description:" "},d.FRAMEBUFFER_BINDING={name:"FRAMEBUFFER_BINDING",value:36006,description:" "},d.RENDERBUFFER_BINDING={name:"RENDERBUFFER_BINDING",value:36007,description:" "},d.MAX_RENDERBUFFER_SIZE={name:"MAX_RENDERBUFFER_SIZE",value:34024,description:" "},d.INVALID_FRAMEBUFFER_OPERATION={name:"INVALID_FRAMEBUFFER_OPERATION",value:1286,description:" "},d.UNPACK_FLIP_Y_WEBGL={name:"UNPACK_FLIP_Y_WEBGL",value:37440,description:" "},d.UNPACK_PREMULTIPLY_ALPHA_WEBGL={name:"UNPACK_PREMULTIPLY_ALPHA_WEBGL",value:37441,description:" "},d.UNPACK_COLORSPACE_CONVERSION_WEBGL={name:"UNPACK_COLORSPACE_CONVERSION_WEBGL",value:37443,description:" "},d.READ_BUFFER={name:"READ_BUFFER",value:3074,description:" "},d.UNPACK_ROW_LENGTH={name:"UNPACK_ROW_LENGTH",value:3314,description:" "},d.UNPACK_SKIP_ROWS={name:"UNPACK_SKIP_ROWS",value:3315,description:" "},d.UNPACK_SKIP_PIXELS={name:"UNPACK_SKIP_PIXELS",value:3316,description:" "},d.PACK_ROW_LENGTH={name:"PACK_ROW_LENGTH",value:3330,description:" "},d.PACK_SKIP_ROWS={name:"PACK_SKIP_ROWS",value:3331,description:" "},d.PACK_SKIP_PIXELS={name:"PACK_SKIP_PIXELS",value:3332,description:" "},d.TEXTURE_BINDING_3D={name:"TEXTURE_BINDING_3D",value:32874,description:" "},d.UNPACK_SKIP_IMAGES={name:"UNPACK_SKIP_IMAGES",value:32877,description:" "},d.UNPACK_IMAGE_HEIGHT={name:"UNPACK_IMAGE_HEIGHT",value:32878,description:" "},d.MAX_3D_TEXTURE_SIZE={name:"MAX_3D_TEXTURE_SIZE",value:32883,description:" "},d.MAX_ELEMENTS_VERTICES={name:"MAX_ELEMENTS_VERTICES",value:33e3,description:" "},d.MAX_ELEMENTS_INDICES={name:"MAX_ELEMENTS_INDICES",value:33001,description:" "},d.MAX_TEXTURE_LOD_BIAS={name:"MAX_TEXTURE_LOD_BIAS",value:34045,description:" "},d.MAX_FRAGMENT_UNIFORM_COMPONENTS={name:"MAX_FRAGMENT_UNIFORM_COMPONENTS",value:35657,description:" "},d.MAX_VERTEX_UNIFORM_COMPONENTS={name:"MAX_VERTEX_UNIFORM_COMPONENTS",value:35658,description:" "},d.MAX_ARRAY_TEXTURE_LAYERS={name:"MAX_ARRAY_TEXTURE_LAYERS",value:35071,description:" "},d.MIN_PROGRAM_TEXEL_OFFSET={name:"MIN_PROGRAM_TEXEL_OFFSET",value:35076,description:" "},d.MAX_PROGRAM_TEXEL_OFFSET={name:"MAX_PROGRAM_TEXEL_OFFSET",value:35077,description:" "},d.MAX_VARYING_COMPONENTS={name:"MAX_VARYING_COMPONENTS",value:35659,description:" "},d.FRAGMENT_SHADER_DERIVATIVE_HINT={name:"FRAGMENT_SHADER_DERIVATIVE_HINT",value:35723,description:" "},d.RASTERIZER_DISCARD={name:"RASTERIZER_DISCARD",value:35977,description:" "},d.VERTEX_ARRAY_BINDING={name:"VERTEX_ARRAY_BINDING",value:34229,description:" "},d.MAX_VERTEX_OUTPUT_COMPONENTS={name:"MAX_VERTEX_OUTPUT_COMPONENTS",value:37154,description:" "},d.MAX_FRAGMENT_INPUT_COMPONENTS={name:"MAX_FRAGMENT_INPUT_COMPONENTS",value:37157,description:" "},d.MAX_SERVER_WAIT_TIMEOUT={name:"MAX_SERVER_WAIT_TIMEOUT",value:37137,description:" "},d.MAX_ELEMENT_INDEX={name:"MAX_ELEMENT_INDEX",value:36203,description:" "},d.RED={name:"RED",value:6403,description:" "},d.RGB8={name:"RGB8",value:32849,description:" "},d.RGBA8={name:"RGBA8",value:32856,description:" "},d.RGB10_A2={name:"RGB10_A2",value:32857,description:" "},d.TEXTURE_3D={name:"TEXTURE_3D",value:32879,description:" "},d.TEXTURE_WRAP_R={name:"TEXTURE_WRAP_R",value:32882,description:" "},d.TEXTURE_MIN_LOD={name:"TEXTURE_MIN_LOD",value:33082,description:" "},d.TEXTURE_MAX_LOD={name:"TEXTURE_MAX_LOD",value:33083,description:" "},d.TEXTURE_BASE_LEVEL={name:"TEXTURE_BASE_LEVEL",value:33084,description:" "},d.TEXTURE_MAX_LEVEL={name:"TEXTURE_MAX_LEVEL",value:33085,description:" "},d.TEXTURE_COMPARE_MODE={name:"TEXTURE_COMPARE_MODE",value:34892,description:" "},d.TEXTURE_COMPARE_FUNC={name:"TEXTURE_COMPARE_FUNC",value:34893,description:" "},d.SRGB={name:"SRGB",value:35904,description:" "},d.SRGB8={name:"SRGB8",value:35905,description:" "},d.SRGB8_ALPHA8={name:"SRGB8_ALPHA8",value:35907,description:" "},d.COMPARE_REF_TO_TEXTURE={name:"COMPARE_REF_TO_TEXTURE",value:34894,description:" "},d.RGBA32F={name:"RGBA32F",value:34836,description:" "},d.RGB32F={name:"RGB32F",value:34837,description:" "},d.RGBA16F={name:"RGBA16F",value:34842,description:" "},d.RGB16F={name:"RGB16F",value:34843,description:" "},d.TEXTURE_2D_ARRAY={name:"TEXTURE_2D_ARRAY",value:35866,description:" "},d.TEXTURE_BINDING_2D_ARRAY={name:"TEXTURE_BINDING_2D_ARRAY",value:35869,description:" "},d.R11F_G11F_B10F={name:"R11F_G11F_B10F",value:35898,description:" "},d.RGB9_E5={name:"RGB9_E5",value:35901,description:" "},d.RGBA32UI={name:"RGBA32UI",value:36208,description:" "},d.RGB32UI={name:"RGB32UI",value:36209,description:" "},d.RGBA16UI={name:"RGBA16UI",value:36214,description:" "},d.RGB16UI={name:"RGB16UI",value:36215,description:" "},d.RGBA8UI={name:"RGBA8UI",value:36220,description:" "},d.RGB8UI={name:"RGB8UI",value:36221,description:" "},d.RGBA32I={name:"RGBA32I",value:36226,description:" "},d.RGB32I={name:"RGB32I",value:36227,description:" "},d.RGBA16I={name:"RGBA16I",value:36232,description:" "},d.RGB16I={name:"RGB16I",value:36233,description:" "},d.RGBA8I={name:"RGBA8I",value:36238,description:" "},d.RGB8I={name:"RGB8I",value:36239,description:" "},d.RED_INTEGER={name:"RED_INTEGER",value:36244,description:" "},d.RGB_INTEGER={name:"RGB_INTEGER",value:36248,description:" "},d.RGBA_INTEGER={name:"RGBA_INTEGER",value:36249,description:" "},d.R8={name:"R8",value:33321,description:" "},d.RG8={name:"RG8",value:33323,description:" "},d.R16F={name:"R16F",value:33325,description:" "},d.R32F={name:"R32F",value:33326,description:" "},d.RG16F={name:"RG16F",value:33327,description:" "},d.RG32F={name:"RG32F",value:33328,description:" "},d.R8I={name:"R8I",value:33329,description:" "},d.R8UI={name:"R8UI",value:33330,description:" "},d.R16I={name:"R16I",value:33331,description:" "},d.R16UI={name:"R16UI",value:33332,description:" "},d.R32I={name:"R32I",value:33333,description:" "},d.R32UI={name:"R32UI",value:33334,description:" "},d.RG8I={name:"RG8I",value:33335,description:" "},d.RG8UI={name:"RG8UI",value:33336,description:" "},d.RG16I={name:"RG16I",value:33337,description:" "},d.RG16UI={name:"RG16UI",value:33338,description:" "},d.RG32I={name:"RG32I",value:33339,description:" "},d.RG32UI={name:"RG32UI",value:33340,description:" "},d.R8_SNORM={name:"R8_SNORM",value:36756,description:" "},d.RG8_SNORM={name:"RG8_SNORM",value:36757,description:" "},d.RGB8_SNORM={name:"RGB8_SNORM",value:36758,description:" "},d.RGBA8_SNORM={name:"RGBA8_SNORM",value:36759,description:" "},d.RGB10_A2UI={name:"RGB10_A2UI",value:36975,description:" "},d.TEXTURE_IMMUTABLE_FORMAT={name:"TEXTURE_IMMUTABLE_FORMAT",value:37167,description:" "},d.TEXTURE_IMMUTABLE_LEVELS={name:"TEXTURE_IMMUTABLE_LEVELS",value:33503,description:" "},d.UNSIGNED_INT_2_10_10_10_REV={name:"UNSIGNED_INT_2_10_10_10_REV",value:33640,description:" "},d.UNSIGNED_INT_10F_11F_11F_REV={name:"UNSIGNED_INT_10F_11F_11F_REV",value:35899,description:" "},d.UNSIGNED_INT_5_9_9_9_REV={name:"UNSIGNED_INT_5_9_9_9_REV",value:35902,description:" "},d.FLOAT_32_UNSIGNED_INT_24_8_REV={name:"FLOAT_32_UNSIGNED_INT_24_8_REV",value:36269,description:" "},d.UNSIGNED_INT_24_8={name:"UNSIGNED_INT_24_8",value:34042,description:" "},d.HALF_FLOAT={name:"HALF_FLOAT",value:5131,description:" "},d.RG={name:"RG",value:33319,description:" "},d.RG_INTEGER={name:"RG_INTEGER",value:33320,description:" "},d.INT_2_10_10_10_REV={name:"INT_2_10_10_10_REV",value:36255,description:" "},d.CURRENT_QUERY={name:"CURRENT_QUERY",value:34917,description:" "},d.QUERY_RESULT={name:"QUERY_RESULT",value:34918,description:" "},d.QUERY_RESULT_AVAILABLE={name:"QUERY_RESULT_AVAILABLE",value:34919,description:" "},d.ANY_SAMPLES_PASSED={name:"ANY_SAMPLES_PASSED",value:35887,description:" "},d.ANY_SAMPLES_PASSED_CONSERVATIVE={name:"ANY_SAMPLES_PASSED_CONSERVATIVE",value:36202,description:" "},d.MAX_DRAW_BUFFERS={name:"MAX_DRAW_BUFFERS",value:34852,description:" "},d.DRAW_BUFFER0={name:"DRAW_BUFFER0",value:34853,description:" "},d.DRAW_BUFFER1={name:"DRAW_BUFFER1",value:34854,description:" "},d.DRAW_BUFFER2={name:"DRAW_BUFFER2",value:34855,description:" "},d.DRAW_BUFFER3={name:"DRAW_BUFFER3",value:34856,description:" "},d.DRAW_BUFFER4={name:"DRAW_BUFFER4",value:34857,description:" "},d.DRAW_BUFFER5={name:"DRAW_BUFFER5",value:34858,description:" "},d.DRAW_BUFFER6={name:"DRAW_BUFFER6",value:34859,description:" "},d.DRAW_BUFFER7={name:"DRAW_BUFFER7",value:34860,description:" "},d.DRAW_BUFFER8={name:"DRAW_BUFFER8",value:34861,description:" "},d.DRAW_BUFFER9={name:"DRAW_BUFFER9",value:34862,description:" "},d.DRAW_BUFFER10={name:"DRAW_BUFFER10",value:34863,description:" "},d.DRAW_BUFFER11={name:"DRAW_BUFFER11",value:34864,description:" "},d.DRAW_BUFFER12={name:"DRAW_BUFFER12",value:34865,description:" "},d.DRAW_BUFFER13={name:"DRAW_BUFFER13",value:34866,description:" "},d.DRAW_BUFFER14={name:"DRAW_BUFFER14",value:34867,description:" "},d.DRAW_BUFFER15={name:"DRAW_BUFFER15",value:34868,description:" "},d.MAX_COLOR_ATTACHMENTS={name:"MAX_COLOR_ATTACHMENTS",value:36063,description:" "},d.COLOR_ATTACHMENT1={name:"COLOR_ATTACHMENT1",value:36065,description:" "},d.COLOR_ATTACHMENT2={name:"COLOR_ATTACHMENT2",value:36066,description:" "},d.COLOR_ATTACHMENT3={name:"COLOR_ATTACHMENT3",value:36067,description:" "},d.COLOR_ATTACHMENT4={name:"COLOR_ATTACHMENT4",value:36068,description:" "},d.COLOR_ATTACHMENT5={name:"COLOR_ATTACHMENT5",value:36069,description:" "},d.COLOR_ATTACHMENT6={name:"COLOR_ATTACHMENT6",value:36070,description:" "},d.COLOR_ATTACHMENT7={name:"COLOR_ATTACHMENT7",value:36071,description:" "},d.COLOR_ATTACHMENT8={name:"COLOR_ATTACHMENT8",value:36072,description:" "},d.COLOR_ATTACHMENT9={name:"COLOR_ATTACHMENT9",value:36073,description:" "},d.COLOR_ATTACHMENT10={name:"COLOR_ATTACHMENT10",value:36074,description:" "},d.COLOR_ATTACHMENT11={name:"COLOR_ATTACHMENT11",value:36075,description:" "},d.COLOR_ATTACHMENT12={name:"COLOR_ATTACHMENT12",value:36076,description:" "},d.COLOR_ATTACHMENT13={name:"COLOR_ATTACHMENT13",value:36077,description:" "},d.COLOR_ATTACHMENT14={name:"COLOR_ATTACHMENT14",value:36078,description:" "},d.COLOR_ATTACHMENT15={name:"COLOR_ATTACHMENT15",value:36079,description:" "},d.SAMPLER_3D={name:"SAMPLER_3D",value:35679,description:" "},d.SAMPLER_2D_SHADOW={name:"SAMPLER_2D_SHADOW",value:35682,description:" "},d.SAMPLER_2D_ARRAY={name:"SAMPLER_2D_ARRAY",value:36289,description:" "},d.SAMPLER_2D_ARRAY_SHADOW={name:"SAMPLER_2D_ARRAY_SHADOW",value:36292,description:" "},d.SAMPLER_CUBE_SHADOW={name:"SAMPLER_CUBE_SHADOW",value:36293,description:" "},d.INT_SAMPLER_2D={name:"INT_SAMPLER_2D",value:36298,description:" "},d.INT_SAMPLER_3D={name:"INT_SAMPLER_3D",value:36299,description:" "},d.INT_SAMPLER_CUBE={name:"INT_SAMPLER_CUBE",value:36300,description:" "},d.INT_SAMPLER_2D_ARRAY={name:"INT_SAMPLER_2D_ARRAY",value:36303,description:" "},d.UNSIGNED_INT_SAMPLER_2D={name:"UNSIGNED_INT_SAMPLER_2D",value:36306,description:" "},d.UNSIGNED_INT_SAMPLER_3D={name:"UNSIGNED_INT_SAMPLER_3D",value:36307,description:" "},d.UNSIGNED_INT_SAMPLER_CUBE={name:"UNSIGNED_INT_SAMPLER_CUBE",value:36308,description:" "},d.UNSIGNED_INT_SAMPLER_2D_ARRAY={name:"UNSIGNED_INT_SAMPLER_2D_ARRAY",value:36311,description:" "},d.MAX_SAMPLES={name:"MAX_SAMPLES",value:36183,description:" "},d.SAMPLER_BINDING={name:"SAMPLER_BINDING",value:35097,description:" "},d.PIXEL_PACK_BUFFER={name:"PIXEL_PACK_BUFFER",value:35051,description:" "},d.PIXEL_UNPACK_BUFFER={name:"PIXEL_UNPACK_BUFFER",value:35052,description:" "},d.PIXEL_PACK_BUFFER_BINDING={name:"PIXEL_PACK_BUFFER_BINDING",value:35053,description:" "},d.PIXEL_UNPACK_BUFFER_BINDING={name:"PIXEL_UNPACK_BUFFER_BINDING",value:35055,description:" "},d.COPY_READ_BUFFER={name:"COPY_READ_BUFFER",value:36662,description:" "},d.COPY_WRITE_BUFFER={name:"COPY_WRITE_BUFFER",value:36663,description:" "},d.COPY_READ_BUFFER_BINDING={name:"COPY_READ_BUFFER_BINDING",value:36662,description:" "},d.COPY_WRITE_BUFFER_BINDING={name:"COPY_WRITE_BUFFER_BINDING",value:36663,description:" "},d.FLOAT_MAT2x3={name:"FLOAT_MAT2x3",value:35685,description:" "},d.FLOAT_MAT2x4={name:"FLOAT_MAT2x4",value:35686,description:" "},d.FLOAT_MAT3x2={name:"FLOAT_MAT3x2",value:35687,description:" "},d.FLOAT_MAT3x4={name:"FLOAT_MAT3x4",value:35688,description:" "},d.FLOAT_MAT4x2={name:"FLOAT_MAT4x2",value:35689,description:" "},d.FLOAT_MAT4x3={name:"FLOAT_MAT4x3",value:35690,description:" "},d.UNSIGNED_INT_VEC2={name:"UNSIGNED_INT_VEC2",value:36294,description:" "},d.UNSIGNED_INT_VEC3={name:"UNSIGNED_INT_VEC3",value:36295,description:" "},d.UNSIGNED_INT_VEC4={name:"UNSIGNED_INT_VEC4",value:36296,description:" "},d.UNSIGNED_NORMALIZED={name:"UNSIGNED_NORMALIZED",value:35863,description:" "},d.SIGNED_NORMALIZED={name:"SIGNED_NORMALIZED",value:36764,description:" "},d.VERTEX_ATTRIB_ARRAY_INTEGER={name:"VERTEX_ATTRIB_ARRAY_INTEGER",value:35069,description:" "},d.VERTEX_ATTRIB_ARRAY_DIVISOR={name:"VERTEX_ATTRIB_ARRAY_DIVISOR",value:35070,description:" "},d.TRANSFORM_FEEDBACK_BUFFER_MODE={name:"TRANSFORM_FEEDBACK_BUFFER_MODE",value:35967,description:" "},d.MAX_TRANSFORM_FEEDBACK_SEPARATE_COMPONENTS={name:"MAX_TRANSFORM_FEEDBACK_SEPARATE_COMPONENTS",value:35968,description:" "},d.TRANSFORM_FEEDBACK_VARYINGS={name:"TRANSFORM_FEEDBACK_VARYINGS",value:35971,description:" "},d.TRANSFORM_FEEDBACK_BUFFER_START={name:"TRANSFORM_FEEDBACK_BUFFER_START",value:35972,description:" "},d.TRANSFORM_FEEDBACK_BUFFER_SIZE={name:"TRANSFORM_FEEDBACK_BUFFER_SIZE",value:35973,description:" "},d.TRANSFORM_FEEDBACK_PRIMITIVES_WRITTEN={name:"TRANSFORM_FEEDBACK_PRIMITIVES_WRITTEN",value:35976,description:" "},d.MAX_TRANSFORM_FEEDBACK_INTERLEAVED_COMPONENTS={name:"MAX_TRANSFORM_FEEDBACK_INTERLEAVED_COMPONENTS",value:35978,description:" "},d.MAX_TRANSFORM_FEEDBACK_SEPARATE_ATTRIBS={name:"MAX_TRANSFORM_FEEDBACK_SEPARATE_ATTRIBS",value:35979,description:" "},d.INTERLEAVED_ATTRIBS={name:"INTERLEAVED_ATTRIBS",value:35980,description:" "},d.SEPARATE_ATTRIBS={name:"SEPARATE_ATTRIBS",value:35981,description:" "},d.TRANSFORM_FEEDBACK_BUFFER={name:"TRANSFORM_FEEDBACK_BUFFER",value:35982,description:" "},d.TRANSFORM_FEEDBACK_BUFFER_BINDING={name:"TRANSFORM_FEEDBACK_BUFFER_BINDING",value:35983,description:" "},d.TRANSFORM_FEEDBACK={name:"TRANSFORM_FEEDBACK",value:36386,description:" "},d.TRANSFORM_FEEDBACK_PAUSED={name:"TRANSFORM_FEEDBACK_PAUSED",value:36387,description:" "},d.TRANSFORM_FEEDBACK_ACTIVE={name:"TRANSFORM_FEEDBACK_ACTIVE",value:36388,description:" "},d.TRANSFORM_FEEDBACK_BINDING={name:"TRANSFORM_FEEDBACK_BINDING",value:36389,description:" "},d.FRAMEBUFFER_ATTACHMENT_COLOR_ENCODING={name:"FRAMEBUFFER_ATTACHMENT_COLOR_ENCODING",value:33296,description:" "},d.FRAMEBUFFER_ATTACHMENT_COMPONENT_TYPE={name:"FRAMEBUFFER_ATTACHMENT_COMPONENT_TYPE",value:33297,description:" "},d.FRAMEBUFFER_ATTACHMENT_RED_SIZE={name:"FRAMEBUFFER_ATTACHMENT_RED_SIZE",value:33298,description:" "},d.FRAMEBUFFER_ATTACHMENT_GREEN_SIZE={name:"FRAMEBUFFER_ATTACHMENT_GREEN_SIZE",value:33299,description:" "},d.FRAMEBUFFER_ATTACHMENT_BLUE_SIZE={name:"FRAMEBUFFER_ATTACHMENT_BLUE_SIZE",value:33300,description:" "},d.FRAMEBUFFER_ATTACHMENT_ALPHA_SIZE={name:"FRAMEBUFFER_ATTACHMENT_ALPHA_SIZE",value:33301,description:" "},d.FRAMEBUFFER_ATTACHMENT_DEPTH_SIZE={name:"FRAMEBUFFER_ATTACHMENT_DEPTH_SIZE",value:33302,description:" "},d.FRAMEBUFFER_ATTACHMENT_STENCIL_SIZE={name:"FRAMEBUFFER_ATTACHMENT_STENCIL_SIZE",value:33303,description:" "},d.FRAMEBUFFER_DEFAULT={name:"FRAMEBUFFER_DEFAULT",value:33304,description:" "},d.DEPTH24_STENCIL8={name:"DEPTH24_STENCIL8",value:35056,description:" "},d.DRAW_FRAMEBUFFER_BINDING={name:"DRAW_FRAMEBUFFER_BINDING",value:36006,description:" "},d.READ_FRAMEBUFFER={name:"READ_FRAMEBUFFER",value:36008,description:" "},d.DRAW_FRAMEBUFFER={name:"DRAW_FRAMEBUFFER",value:36009,description:" "},d.READ_FRAMEBUFFER_BINDING={name:"READ_FRAMEBUFFER_BINDING",value:36010,description:" "},d.RENDERBUFFER_SAMPLES={name:"RENDERBUFFER_SAMPLES",value:36011,description:" "},d.FRAMEBUFFER_ATTACHMENT_TEXTURE_LAYER={name:"FRAMEBUFFER_ATTACHMENT_TEXTURE_LAYER",value:36052,description:" "},d.FRAMEBUFFER_INCOMPLETE_MULTISAMPLE={name:"FRAMEBUFFER_INCOMPLETE_MULTISAMPLE",value:36182,description:" "},d.UNIFORM_BUFFER={name:"UNIFORM_BUFFER",value:35345,description:" "},d.UNIFORM_BUFFER_BINDING={name:"UNIFORM_BUFFER_BINDING",value:35368,description:" "},d.UNIFORM_BUFFER_START={name:"UNIFORM_BUFFER_START",value:35369,description:" "},d.UNIFORM_BUFFER_SIZE={name:"UNIFORM_BUFFER_SIZE",value:35370,description:" "},d.MAX_VERTEX_UNIFORM_BLOCKS={name:"MAX_VERTEX_UNIFORM_BLOCKS",value:35371,description:" "},d.MAX_FRAGMENT_UNIFORM_BLOCKS={name:"MAX_FRAGMENT_UNIFORM_BLOCKS",value:35373,description:" "},d.MAX_COMBINED_UNIFORM_BLOCKS={name:"MAX_COMBINED_UNIFORM_BLOCKS",value:35374,description:" "},d.MAX_UNIFORM_BUFFER_BINDINGS={name:"MAX_UNIFORM_BUFFER_BINDINGS",value:35375,description:" "},d.MAX_UNIFORM_BLOCK_SIZE={name:"MAX_UNIFORM_BLOCK_SIZE",value:35376,description:" "},d.MAX_COMBINED_VERTEX_UNIFORM_COMPONENTS={name:"MAX_COMBINED_VERTEX_UNIFORM_COMPONENTS",value:35377,description:" "},d.MAX_COMBINED_FRAGMENT_UNIFORM_COMPONENTS={name:"MAX_COMBINED_FRAGMENT_UNIFORM_COMPONENTS",value:35379,description:" "},d.UNIFORM_BUFFER_OFFSET_ALIGNMENT={name:"UNIFORM_BUFFER_OFFSET_ALIGNMENT",value:35380,description:" "},d.ACTIVE_UNIFORM_BLOCKS={name:"ACTIVE_UNIFORM_BLOCKS",value:35382,description:" "},d.UNIFORM_TYPE={name:"UNIFORM_TYPE",value:35383,description:" "},d.UNIFORM_SIZE={name:"UNIFORM_SIZE",value:35384,description:" "},d.UNIFORM_BLOCK_INDEX={name:"UNIFORM_BLOCK_INDEX",value:35386,description:" "},d.UNIFORM_OFFSET={name:"UNIFORM_OFFSET",value:35387,description:" "},d.UNIFORM_ARRAY_STRIDE={name:"UNIFORM_ARRAY_STRIDE",value:35388,description:" "},d.UNIFORM_MATRIX_STRIDE={name:"UNIFORM_MATRIX_STRIDE",value:35389,description:" "},d.UNIFORM_IS_ROW_MAJOR={name:"UNIFORM_IS_ROW_MAJOR",value:35390,description:" "},d.UNIFORM_BLOCK_BINDING={name:"UNIFORM_BLOCK_BINDING",value:35391,description:" "},d.UNIFORM_BLOCK_DATA_SIZE={name:"UNIFORM_BLOCK_DATA_SIZE",value:35392,description:" "},d.UNIFORM_BLOCK_ACTIVE_UNIFORMS={name:"UNIFORM_BLOCK_ACTIVE_UNIFORMS",value:35394,description:" "},d.UNIFORM_BLOCK_ACTIVE_UNIFORM_INDICES={name:"UNIFORM_BLOCK_ACTIVE_UNIFORM_INDICES",value:35395,description:" "},d.UNIFORM_BLOCK_REFERENCED_BY_VERTEX_SHADER={name:"UNIFORM_BLOCK_REFERENCED_BY_VERTEX_SHADER",value:35396,description:" "},d.UNIFORM_BLOCK_REFERENCED_BY_FRAGMENT_SHADER={name:"UNIFORM_BLOCK_REFERENCED_BY_FRAGMENT_SHADER",value:35398,description:" "},d.OBJECT_TYPE={name:"OBJECT_TYPE",value:37138,description:" "},d.SYNC_CONDITION={name:"SYNC_CONDITION",value:37139,description:" "},d.SYNC_STATUS={name:"SYNC_STATUS",value:37140,description:" "},d.SYNC_FLAGS={name:"SYNC_FLAGS",value:37141,description:" "},d.SYNC_FENCE={name:"SYNC_FENCE",value:37142,description:" "},d.SYNC_GPU_COMMANDS_COMPLETE={name:"SYNC_GPU_COMMANDS_COMPLETE",value:37143,description:" "},d.UNSIGNALED={name:"UNSIGNALED",value:37144,description:" "},d.SIGNALED={name:"SIGNALED",value:37145,description:" "},d.ALREADY_SIGNALED={name:"ALREADY_SIGNALED",value:37146,description:" "},d.TIMEOUT_EXPIRED={name:"TIMEOUT_EXPIRED",value:37147,description:" "},d.CONDITION_SATISFIED={name:"CONDITION_SATISFIED",value:37148,description:" "},d.WAIT_FAILED={name:"WAIT_FAILED",value:37149,description:" "},d.SYNC_FLUSH_COMMANDS_BIT={name:"SYNC_FLUSH_COMMANDS_BIT",value:1,description:" "},d.COLOR={name:"COLOR",value:6144,description:" "},d.DEPTH={name:"DEPTH",value:6145,description:" "},d.STENCIL={name:"STENCIL",value:6146,description:" "},d.MIN={name:"MIN",value:32775,description:" "},d.MAX={name:"MAX",value:32776,description:" "},d.DEPTH_COMPONENT24={name:"DEPTH_COMPONENT24",value:33190,description:" "},d.STREAM_READ={name:"STREAM_READ",value:35041,description:" "},d.STREAM_COPY={name:"STREAM_COPY",value:35042,description:" "},d.STATIC_READ={name:"STATIC_READ",value:35045,description:" "},d.STATIC_COPY={name:"STATIC_COPY",value:35046,description:" "},d.DYNAMIC_READ={name:"DYNAMIC_READ",value:35049,description:" "},d.DYNAMIC_COPY={name:"DYNAMIC_COPY",value:35050,description:" "},d.DEPTH_COMPONENT32F={name:"DEPTH_COMPONENT32F",value:36012,description:" "},d.DEPTH32F_STENCIL8={name:"DEPTH32F_STENCIL8",value:36013,description:" "},d.INVALID_INDEX={name:"INVALID_INDEX",value:4294967295,description:" "},d.TIMEOUT_IGNORED={name:"TIMEOUT_IGNORED",value:-1,description:" "},d.MAX_CLIENT_WAIT_TIMEOUT_WEBGL={name:"MAX_CLIENT_WAIT_TIMEOUT_WEBGL",value:37447,description:" "},d.VERTEX_ATTRIB_ARRAY_DIVISOR_ANGLE={name:"VERTEX_ATTRIB_ARRAY_DIVISOR_ANGLE",value:35070,description:"Describes the frequency divisor used for instanced rendering.",extensionName:"ANGLE_instanced_arrays"},d.UNMASKED_VENDOR_WEBGL={name:"UNMASKED_VENDOR_WEBGL",value:37445,description:"Passed to getParameter to get the vendor string of the graphics driver.",extensionName:"ANGLE_instanced_arrays"},d.UNMASKED_RENDERER_WEBGL={name:"UNMASKED_RENDERER_WEBGL",value:37446,description:"Passed to getParameter to get the renderer string of the graphics driver.",extensionName:"WEBGL_debug_renderer_info"},d.MAX_TEXTURE_MAX_ANISOTROPY_EXT={name:"MAX_TEXTURE_MAX_ANISOTROPY_EXT",value:34047,description:"Returns the maximum available anisotropy.",extensionName:"EXT_texture_filter_anisotropic"},d.TEXTURE_MAX_ANISOTROPY_EXT={name:"TEXTURE_MAX_ANISOTROPY_EXT",value:34046,description:"Passed to texParameter to set the desired maximum anisotropy for a texture.",extensionName:"EXT_texture_filter_anisotropic"},d.COMPRESSED_RGB_S3TC_DXT1_EXT={name:"COMPRESSED_RGB_S3TC_DXT1_EXT",value:33776,description:"A DXT1-compressed image in an RGB image format.",extensionName:"WEBGL_compressed_texture_s3tc"},d.COMPRESSED_RGBA_S3TC_DXT1_EXT={name:"COMPRESSED_RGBA_S3TC_DXT1_EXT",value:33777,description:"A DXT1-compressed image in an RGB image format with a simple on/off alpha value.",extensionName:"WEBGL_compressed_texture_s3tc"},d.COMPRESSED_RGBA_S3TC_DXT3_EXT={name:"COMPRESSED_RGBA_S3TC_DXT3_EXT",value:33778,description:"A DXT3-compressed image in an RGBA image format. Compared to a 32-bit RGBA texture, it offers 4:1 compression.",extensionName:"WEBGL_compressed_texture_s3tc"},d.COMPRESSED_RGBA_S3TC_DXT5_EXT={name:"COMPRESSED_RGBA_S3TC_DXT5_EXT",value:33779,description:"A DXT5-compressed image in an RGBA image format. It also provides a 4:1 compression, but differs to the DXT3 compression in how the alpha compression is done.",extensionName:"WEBGL_compressed_texture_s3tc"},d.COMPRESSED_R11_EAC={name:"COMPRESSED_R11_EAC",value:37488,description:"One-channel (red) unsigned format compression.",extensionName:"WEBGL_compressed_texture_etc"},d.COMPRESSED_SIGNED_R11_EAC={name:"COMPRESSED_SIGNED_R11_EAC",value:37489,description:"One-channel (red) signed format compression.",extensionName:"WEBGL_compressed_texture_etc"},d.COMPRESSED_RG11_EAC={name:"COMPRESSED_RG11_EAC",value:37490,description:"Two-channel (red and green) unsigned format compression.",extensionName:"WEBGL_compressed_texture_etc"},d.COMPRESSED_SIGNED_RG11_EAC={name:"COMPRESSED_SIGNED_RG11_EAC",value:37491,description:"Two-channel (red and green) signed format compression.",extensionName:"WEBGL_compressed_texture_etc"},d.COMPRESSED_RGB8_ETC2={name:"COMPRESSED_RGB8_ETC2",value:37492,description:"Compresses RBG8 data with no alpha channel.",extensionName:"WEBGL_compressed_texture_etc"},d.COMPRESSED_RGBA8_ETC2_EAC={name:"COMPRESSED_RGBA8_ETC2_EAC",value:37493,description:"Compresses RGBA8 data. The RGB part is encoded the same as RGB_ETC2, but the alpha part is encoded separately.",extensionName:"WEBGL_compressed_texture_etc"},d.COMPRESSED_SRGB8_ETC2={name:"COMPRESSED_SRGB8_ETC2",value:37494,description:"Compresses sRBG8 data with no alpha channel.",extensionName:"WEBGL_compressed_texture_etc"},d.COMPRESSED_SRGB8_ALPHA8_ETC2_EAC={name:"COMPRESSED_SRGB8_ALPHA8_ETC2_EAC",value:37495,description:"Compresses sRGBA8 data. The sRGB part is encoded the same as SRGB_ETC2, but the alpha part is encoded separately.",extensionName:"WEBGL_compressed_texture_etc"},d.COMPRESSED_RGB8_PUNCHTHROUGH_ALPHA1_ETC2={name:"COMPRESSED_RGB8_PUNCHTHROUGH_ALPHA1_ETC2",value:37496,description:"Similar to RGB8_ETC, but with ability to punch through the alpha channel, which means to make it completely opaque or transparent.",extensionName:"WEBGL_compressed_texture_etc"},d.COMPRESSED_SRGB8_PUNCHTHROUGH_ALPHA1_ETC2={name:"COMPRESSED_SRGB8_PUNCHTHROUGH_ALPHA1_ETC2",value:37497,description:"Similar to SRGB8_ETC, but with ability to punch through the alpha channel, which means to make it completely opaque or transparent.",extensionName:"WEBGL_compressed_texture_etc"},d.COMPRESSED_RGB_PVRTC_4BPPV1_IMG={name:"COMPRESSED_RGB_PVRTC_4BPPV1_IMG",value:35840,description:"RGB compression in 4-bit mode. One block for each 4×4 pixels.",extensionName:"WEBGL_compressed_texture_pvrtc"},d.COMPRESSED_RGBA_PVRTC_4BPPV1_IMG={name:"COMPRESSED_RGBA_PVRTC_4BPPV1_IMG",value:35842,description:"RGBA compression in 4-bit mode. One block for each 4×4 pixels.",extensionName:"WEBGL_compressed_texture_pvrtc"},d.COMPRESSED_RGB_PVRTC_2BPPV1_IMG={name:"COMPRESSED_RGB_PVRTC_2BPPV1_IMG",value:35841,description:"RGB compression in 2-bit mode. One block for each 8×4 pixels.",extensionName:"WEBGL_compressed_texture_pvrtc"},d.COMPRESSED_RGBA_PVRTC_2BPPV1_IMG={name:"COMPRESSED_RGBA_PVRTC_2BPPV1_IMG",value:35843,description:"RGBA compression in 2-bit mode. One block for each 8×4 pixe",extensionName:"WEBGL_compressed_texture_pvrtc"},d.COMPRESSED_RGB_ETC1_WEBGL={name:"COMPRESSED_RGB_ETC1_WEBGL",value:36196,description:"Compresses 24-bit RGB data with no alpha channel.",extensionName:"WEBGL_compressed_texture_etc1"},d.COMPRESSED_RGB_ATC_WEBGL={name:"COMPRESSED_RGB_ATC_WEBGL",value:35986,description:"Compresses RGB textures with no alpha channel.",extensionName:"WEBGL_compressed_texture_atc"},d.COMPRESSED_RGBA_ATC_EXPLICIT_ALPHA_WEBGL={name:"COMPRESSED_RGBA_ATC_EXPLICIT_ALPHA_WEBGL",value:35986,description:"Compresses RGBA textures using explicit alpha encoding (useful when alpha transitions are sharp).",extensionName:"WEBGL_compressed_texture_atc"},d.COMPRESSED_RGBA_ATC_INTERPOLATED_ALPHA_WEBGL={name:"COMPRESSED_RGBA_ATC_INTERPOLATED_ALPHA_WEBGL",value:34798,description:"Compresses RGBA textures using interpolated alpha encoding (useful when alpha transitions are gradient).",extensionName:"WEBGL_compressed_texture_atc"},d.UNSIGNED_INT_24_8_WEBGL={name:"UNSIGNED_INT_24_8_WEBGL",value:34042,description:"Unsigned integer type for 24-bit depth texture data.",extensionName:"WEBGL_depth_texture"},d.HALF_FLOAT_OES={name:"HALF_FLOAT_OES",value:36193,description:"Half floating-point type (16-bit).",extensionName:"OES_texture_half_float"},d.FRAMEBUFFER_ATTACHMENT_COMPONENT_TYPE_EXT={name:"FRAMEBUFFER_ATTACHMENT_COMPONENT_TYPE_EXT",value:33297,description:" ",extensionName:"WEBGL_color_buffer_float"},d.UNSIGNED_NORMALIZED_EXT={name:"UNSIGNED_NORMALIZED_EXT",value:35863,description:" ",extensionName:"WEBGL_color_buffer_float"},d.MIN_EXT={name:"MIN_EXT",value:32775,description:"Produces the minimum color components of the source and destination colors.",extensionName:"EXT_blend_minmax"},d.MAX_EXT={name:"MAX_EXT",value:32776,description:"Produces the maximum color components of the source and destination colors.",extensionName:"EXT_blend_minmax"},d.SRGB_EXT={name:"SRGB_EXT",value:35904,description:"Unsized sRGB format that leaves the precision up to the driver.",extensionName:"EXT_sRGB"},d.SRGB_ALPHA_EXT={name:"SRGB_ALPHA_EXT",value:35906,description:"Unsized sRGB format with unsized alpha component.",extensionName:"EXT_sRGB"},d.SRGB8_ALPHA8_EXT={name:"SRGB8_ALPHA8_EXT",value:35907,description:"Sized (8-bit) sRGB and alpha formats.",extensionName:"EXT_sRGB"},d.FRAMEBUFFER_ATTACHMENT_COLOR_ENCODING_EXT={name:"FRAMEBUFFER_ATTACHMENT_COLOR_ENCODING_EXT",value:33296,description:"Returns the framebuffer color encoding.",extensionName:"EXT_sRGB"},d.FRAGMENT_SHADER_DERIVATIVE_HINT_OES={name:"FRAGMENT_SHADER_DERIVATIVE_HINT_OES",value:35723,description:"Indicates the accuracy of the derivative calculation for the GLSL built-in functions: dFdx, dFdy, and fwidth.",extensionName:"OES_standard_derivatives"},d.COLOR_ATTACHMENT0_WEBGL={name:"COLOR_ATTACHMENT0_WEBGL",value:36064,description:"Framebuffer color attachment point",extensionName:"WEBGL_draw_buffers"},d.COLOR_ATTACHMENT1_WEBGL={name:"COLOR_ATTACHMENT1_WEBGL",value:36065,description:"Framebuffer color attachment point",extensionName:"WEBGL_draw_buffers"},d.COLOR_ATTACHMENT2_WEBGL={name:"COLOR_ATTACHMENT2_WEBGL",value:36066,description:"Framebuffer color attachment point",extensionName:"WEBGL_draw_buffers"},d.COLOR_ATTACHMENT3_WEBGL={name:"COLOR_ATTACHMENT3_WEBGL",value:36067,description:"Framebuffer color attachment point",extensionName:"WEBGL_draw_buffers"},d.COLOR_ATTACHMENT4_WEBGL={name:"COLOR_ATTACHMENT4_WEBGL",value:36068,description:"Framebuffer color attachment point",extensionName:"WEBGL_draw_buffers"},d.COLOR_ATTACHMENT5_WEBGL={name:"COLOR_ATTACHMENT5_WEBGL",value:36069,description:"Framebuffer color attachment point",extensionName:"WEBGL_draw_buffers"},d.COLOR_ATTACHMENT6_WEBGL={name:"COLOR_ATTACHMENT6_WEBGL",value:36070,description:"Framebuffer color attachment point",extensionName:"WEBGL_draw_buffers"},d.COLOR_ATTACHMENT7_WEBGL={name:"COLOR_ATTACHMENT7_WEBGL",value:36071,description:"Framebuffer color attachment point",extensionName:"WEBGL_draw_buffers"},d.COLOR_ATTACHMENT8_WEBGL={name:"COLOR_ATTACHMENT8_WEBGL",value:36072,description:"Framebuffer color attachment point",extensionName:"WEBGL_draw_buffers"},d.COLOR_ATTACHMENT9_WEBGL={name:"COLOR_ATTACHMENT9_WEBGL",value:36073,description:"Framebuffer color attachment point",extensionName:"WEBGL_draw_buffers"},d.COLOR_ATTACHMENT10_WEBGL={name:"COLOR_ATTACHMENT10_WEBGL",value:36074,description:"Framebuffer color attachment point",extensionName:"WEBGL_draw_buffers"},d.COLOR_ATTACHMENT11_WEBGL={name:"COLOR_ATTACHMENT11_WEBGL",value:36075,description:"Framebuffer color attachment point",extensionName:"WEBGL_draw_buffers"},d.COLOR_ATTACHMENT12_WEBGL={name:"COLOR_ATTACHMENT12_WEBGL",value:36076,description:"Framebuffer color attachment point",extensionName:"WEBGL_draw_buffers"},d.COLOR_ATTACHMENT13_WEBGL={name:"COLOR_ATTACHMENT13_WEBGL",value:36077,description:"Framebuffer color attachment point",extensionName:"WEBGL_draw_buffers"},d.COLOR_ATTACHMENT14_WEBGL={name:"COLOR_ATTACHMENT14_WEBGL",value:36078,description:"Framebuffer color attachment point",extensionName:"WEBGL_draw_buffers"},d.COLOR_ATTACHMENT15_WEBGL={name:"COLOR_ATTACHMENT15_WEBGL",value:36079,description:"Framebuffer color attachment point",extensionName:"WEBGL_draw_buffers"},d.DRAW_BUFFER0_WEBGL={name:"DRAW_BUFFER0_WEBGL",value:34853,description:"Draw buffer",extensionName:"WEBGL_draw_buffers"},d.DRAW_BUFFER1_WEBGL={name:"DRAW_BUFFER1_WEBGL",value:34854,description:"Draw buffer",extensionName:"WEBGL_draw_buffers"},d.DRAW_BUFFER2_WEBGL={name:"DRAW_BUFFER2_WEBGL",value:34855,description:"Draw buffer",extensionName:"WEBGL_draw_buffers"},d.DRAW_BUFFER3_WEBGL={name:"DRAW_BUFFER3_WEBGL",value:34856,description:"Draw buffer",extensionName:"WEBGL_draw_buffers"},d.DRAW_BUFFER4_WEBGL={name:"DRAW_BUFFER4_WEBGL",value:34857,description:"Draw buffer",extensionName:"WEBGL_draw_buffers"},d.DRAW_BUFFER5_WEBGL={name:"DRAW_BUFFER5_WEBGL",value:34858,description:"Draw buffer",extensionName:"WEBGL_draw_buffers"},d.DRAW_BUFFER6_WEBGL={name:"DRAW_BUFFER6_WEBGL",value:34859,description:"Draw buffer",extensionName:"WEBGL_draw_buffers"},d.DRAW_BUFFER7_WEBGL={name:"DRAW_BUFFER7_WEBGL",value:34860,description:"Draw buffer",extensionName:"WEBGL_draw_buffers"},d.DRAW_BUFFER8_WEBGL={name:"DRAW_BUFFER8_WEBGL",value:34861,description:"Draw buffer",extensionName:"WEBGL_draw_buffers"},d.DRAW_BUFFER9_WEBGL={name:"DRAW_BUFFER9_WEBGL",value:34862,description:"Draw buffer",extensionName:"WEBGL_draw_buffers"},d.DRAW_BUFFER10_WEBGL={name:"DRAW_BUFFER10_WEBGL",value:34863,description:"Draw buffer",extensionName:"WEBGL_draw_buffers"},d.DRAW_BUFFER11_WEBGL={name:"DRAW_BUFFER11_WEBGL",value:34864,description:"Draw buffer",extensionName:"WEBGL_draw_buffers"},d.DRAW_BUFFER12_WEBGL={name:"DRAW_BUFFER12_WEBGL",value:34865,description:"Draw buffer",extensionName:"WEBGL_draw_buffers"},d.DRAW_BUFFER13_WEBGL={name:"DRAW_BUFFER13_WEBGL",value:34866,description:"Draw buffer",extensionName:"WEBGL_draw_buffers"},d.DRAW_BUFFER14_WEBGL={name:"DRAW_BUFFER14_WEBGL",value:34867,description:"Draw buffer",extensionName:"WEBGL_draw_buffers"},d.DRAW_BUFFER15_WEBGL={name:"DRAW_BUFFER15_WEBGL",value:34868,description:"Draw buffer",extensionName:"WEBGL_draw_buffers"},d.MAX_COLOR_ATTACHMENTS_WEBGL={name:"MAX_COLOR_ATTACHMENTS_WEBGL",value:36063,description:"Maximum number of framebuffer color attachment points",extensionName:"WEBGL_draw_buffers"},d.MAX_DRAW_BUFFERS_WEBGL={name:"MAX_DRAW_BUFFERS_WEBGL",value:34852,description:"Maximum number of draw buffers",extensionName:"WEBGL_draw_buffers"},d.VERTEX_ARRAY_BINDING_OES={name:"VERTEX_ARRAY_BINDING_OES",value:34229,description:"The bound vertex array object (VAO).",extensionName:"VERTEX_ARRAY_BINDING_OES"},d.QUERY_COUNTER_BITS_EXT={name:"QUERY_COUNTER_BITS_EXT",value:34916,description:"The number of bits used to hold the query result for the given target.",extensionName:"EXT_disjoint_timer_query"},d.CURRENT_QUERY_EXT={name:"CURRENT_QUERY_EXT",value:34917,description:"The currently active query.",extensionName:"EXT_disjoint_timer_query"},d.QUERY_RESULT_EXT={name:"QUERY_RESULT_EXT",value:34918,description:"The query result.",extensionName:"EXT_disjoint_timer_query"},d.QUERY_RESULT_AVAILABLE_EXT={name:"QUERY_RESULT_AVAILABLE_EXT",value:34919,description:"A Boolean indicating whether or not a query result is available.",extensionName:"EXT_disjoint_timer_query"},d.TIME_ELAPSED_EXT={name:"TIME_ELAPSED_EXT",value:35007,description:"Elapsed time (in nanoseconds).",extensionName:"EXT_disjoint_timer_query"},d.TIMESTAMP_EXT={name:"TIMESTAMP_EXT",value:36392,description:"The current time.",extensionName:"EXT_disjoint_timer_query"},d.GPU_DISJOINT_EXT={name:"GPU_DISJOINT_EXT",value:36795,description:"A Boolean indicating whether or not the GPU performed any disjoint operation.",extensionName:"EXT_disjoint_timer_query"},d.zeroMeaningByCommand={getError:"NO_ERROR",blendFunc:"ZERO",blendFuncSeparate:"ZERO",readBuffer:"NONE",getFramebufferAttachmentParameter:"NONE",texParameterf:"NONE",texParameteri:"NONE",drawArrays:"POINTS",drawElements:"POINTS",drawArraysInstanced:"POINTS",drawArraysInstancedAngle:"POINTS",drawBuffers:"POINTS",drawElementsInstanced:"POINTS",drawRangeElements:"POINTS"},d.oneMeaningByCommand={blendFunc:"ONE",blendFuncSeparate:"ONE",drawArrays:"LINES",drawElements:"LINES",drawArraysInstanced:"LINES",drawArraysInstancedAngle:"LINES",drawBuffers:"LINES",drawElementsInstanced:"LINES",drawRangeElements:"LINES"};const m={},p={};!function(){for(const e in d)if(d.hasOwnProperty(e)){const t=d[e];m[t.name]=t,p[t.value]=t}}();class g extends l{get analyserName(){return g.analyserName}appendToAnalysis(e,t){if(!e.commands)return;const n={total:0,totalTriangles:0,totalTriangleStrip:0,totalTriangleFan:0,totalLines:0,totalLineStrip:0,totalLineLoop:0,totalPoints:0};for(const t of e.commands)"drawArrays"===t.name&&t.commandArguments.length>=3||"drawArraysInstanced"===t.name&&t.commandArguments.length>=3||"drawArraysInstancedANGLE"===t.name&&t.commandArguments.length>=3?this.appendToPrimitives(n,t.commandArguments[0],t.commandArguments[2]):"drawElements"===t.name&&t.commandArguments.length>=2||"drawElementsInstanced"===t.name&&t.commandArguments.length>=2||"drawElementsInstancedANGLE"===t.name&&t.commandArguments.length>=2?this.appendToPrimitives(n,t.commandArguments[0],t.commandArguments[1]):"drawRangeElements"===t.name&&t.commandArguments.length>=4&&this.appendToPrimitives(n,t.commandArguments[0],t.commandArguments[3]);t.total=n.total,t.triangles=n.totalTriangles,t.triangleStrip=n.totalTriangleStrip,t.triangleFan=n.totalTriangleFan,t.lines=n.totalLines,t.lineStrip=n.totalLineStrip,t.lineLoop=n.totalLineLoop,t.points=n.totalPoints}appendToPrimitives(e,t,n){t===d.POINTS.value?e.totalPoints+=n:t===d.LINES.value?e.totalLines+=n:t===d.LINE_STRIP.value?e.totalLineStrip+=n:t===d.LINE_LOOP.value?e.totalLineLoop+=n:t===d.TRIANGLES.value?e.totalTriangles+=n:t===d.TRIANGLE_STRIP.value?e.totalTriangleStrip+=n:t===d.TRIANGLE_FAN.value&&(e.totalTriangleFan+=n),e.total+=n}}g.analyserName="Primitives";class f{constructor(e){this.contextInformation=e,this.analysers=[],this.initAnalysers()}appendAnalyses(e){for(const t in this.analysers)this.analysers.hasOwnProperty(t)&&this.analysers[t].appendAnalysis(e)}initAnalysers(){this.analysers.push(new c(this.contextInformation),new h(this.contextInformation),new g(this.contextInformation))}}class E{static getWebGlObjectTag(e){return e[E.SPECTOROBJECTTAGKEY]}static attachWebGlObjectTag(e,t){t.displayText=E.stringifyWebGlObjectTag(t),e[E.SPECTOROBJECTTAGKEY]=t}static stringifyWebGlObjectTag(e){return e?`${e.typeName} - ID: ${e.id}`:"No tag available."}}E.SPECTOROBJECTTAGKEY="__SPECTOR_Object_TAG";class v{constructor(){this.id=0}get type(){return window[this.typeName]||null}tagWebGlObject(e){if(!this.type)return;let t;if(!e)return t;if(t=E.getWebGlObjectTag(e),t)return t;if(e instanceof this.type){const n=this.getNextId();return t={typeName:this.typeName,id:n},E.attachWebGlObjectTag(e,t),t}return t}getNextId(){return this.id++}}class _{constructor(e){this.options=e}createCapture(e,t,n){const i=class{static getStackTrace(e=0,t=0){const n=[];try{throw new Error("Errorator.")}catch(e){if(e.stack){const t=e.stack.split("\n");for(let e=0,i=t.length;e<i;e++)t[e].match(/^\s*[A-Za-z0-9\-_\$]+\(/)?n.push(t[e]):0===t[e].indexOf("    at ")?(t[e]=t[e].replace("    at ",""),n.push(t[e])):-1!==t[e].indexOf("/<@http")?(t[e]=t[e].substring(t[e].indexOf("/<@http")+3),n.push(t[e])):-1!==t[e].indexOf("@http")&&(t[e]=t[e].replace("@http"," (http"),t[e]=t[e]+")",n.push(t[e]))}else if(e.message){const t=e.message.split("\n");for(let e=0,i=t.length;e<i;e++)if(t[e].match(/^\s*[A-Za-z0-9\-_\$]+\(/)){let i=t[e];t[e+1]&&(i+=" at "+t[e+1],e++),n.push(i)}}}if(!n){let e=arguments.callee.caller;for(;e;){const t=e.toString(),i=t.substring(t.indexOf("function")+8,t.indexOf(""))||"anonymous";n.push(i),e=e.caller}}if(n){n.shift();for(let t=0;t<e&&n.length>0;t++)n.shift();for(let e=0;e<t&&n.length>0;e++)n.pop()}return n}}.getStackTrace(4,1),r=0===e.name.indexOf("uniform")?this.stringifyUniform(e.arguments):this.stringify(e.arguments,e.result),s={id:t,startTime:e.startTime,commandEndTime:e.endTime,endTime:0,name:e.name,commandArguments:e.arguments,result:e.result,stackTrace:i,status:0,marker:n,text:r};this.transformCapture(s);for(let e=0;e<s.commandArguments.length;e++){const t=s.commandArguments[e];t&&t.length&&t.length>50&&(s.commandArguments[e]="Array Length: "+t.length)}if(s.commandArguments){const e=[];for(let t=0;t<s.commandArguments.length;t++){const n=s.commandArguments[t];void 0===n?e.push(void 0):null===n?e.push(null):e.push(JSON.parse(this.stringifyJSON(n)))}s.commandArguments=e}return s.result&&(s.result=JSON.parse(this.stringifyJSON(s.result))),s}stringifyJSON(e){try{return JSON.stringify(e)}catch(e){return null}}transformCapture(e){}stringify(e,t){let n=this.spiedCommandName;return e&&e.length>0&&(n+=": "+this.stringifyArgs(e).join(", ")),null!=t&&(n+=" -> "+this.stringifyResult(t)),n}stringifyUniform(e){let t=this.spiedCommandName;if(e&&e.length>0){const n=[];n.push(this.stringifyValue(e[0]));for(let t=1;t<e.length;t++)if("number"==typeof e[t]){const i=e[t]+"";n.push(i)}else{const i=this.stringifyValue(e[t]);n.push(i)}t+=": "+n.join(", ")}return t}stringifyArgs(e){const t=[];for(let n=0;n<e.length;n++){const i=e[n],r=this.stringifyValue(i);t.push(r)}return t}stringifyResult(e){if(e)return this.stringifyValue(e)}stringifyValue(e){if(null===e)return"null";if(void 0===e)return"undefined";const t=E.getWebGlObjectTag(e);return t?t.displayText:"number"==typeof e&&d.isWebGlConstant(e)?d.stringifyWebGlConstant(e,this.spiedCommandName):"string"==typeof e?e:e instanceof HTMLImageElement?e.src:e instanceof ArrayBuffer?"[--("+e.byteLength+")--]":e.length?"[..("+e.length+")..]":e.byteLength?"[..("+e.byteLength+")..]":e}}class C extends _{get spiedCommandName(){return C.commandName}stringifyArgs(e){var t,n;const i=[];for(let r=0;r<e.length;r++){const s=e[r];if(r>0&&"number"==typeof s)i.push(null!==(n=null===(t=e[r])||void 0===t?void 0:t.toFixed(0))&&void 0!==n?n:"0");else{const e=this.stringifyValue(s);i.push(e)}}return i}}C.commandName="bufferSubData";class A{static storeOriginFunction(e,t){if(!e)return;if(!e[t])return;const n=this.getOriginFunctionName(t);e[n]||(e[n]=e[t])}static resetOriginFunction(e,t){if(!e)return;if(!e[t])return;const n=this.getOriginFunctionName(t);e[n]&&(e[t]=e[n],delete e[n])}static storePrototypeOriginFunction(e,t){if(!e)return;if(!e.prototype[t])return;const n=this.getOriginFunctionName(t);e.prototype[n]||(e.prototype[n]=e.prototype[t])}static executePrototypeOriginFunction(e,t,n,i){if(!e)return;const r=this.getOriginFunctionName(n);return t.prototype[r]?(e[r]||(e[r]=t.prototype[r]),this.executeFunction(e,r,i)):void 0}static executeOriginFunction(e,t,n){if(!e)return;const i=this.getOriginFunctionName(t);return e[i]?this.executeFunction(e,i,n):void 0}static executeFunction(e,t,n){const i=n;if(void 0===i||0===i.length)return e[t]();switch(i.length){case 1:return e[t](i[0]);case 2:return e[t](i[0],i[1]);case 3:return e[t](i[0],i[1],i[2]);case 4:return e[t](i[0],i[1],i[2],i[3]);case 5:return e[t](i[0],i[1],i[2],i[3],i[4]);case 6:return e[t](i[0],i[1],i[2],i[3],i[4],i[5]);case 7:return e[t](i[0],i[1],i[2],i[3],i[4],i[5],i[6]);case 8:return e[t](i[0],i[1],i[2],i[3],i[4],i[5],i[6],i[7]);case 9:return e[t](i[0],i[1],i[2],i[3],i[4],i[5],i[6],i[7],i[8]);case 10:return e[t](i[0],i[1],i[2],i[3],i[4],i[5],i[6],i[7],i[8],i[9]);case 11:return e[t](i[0],i[1],i[2],i[3],i[4],i[5],i[6],i[7],i[8],i[9],i[10]);case 12:return e[t](i[0],i[1],i[2],i[3],i[4],i[5],i[6],i[7],i[8],i[9],i[10],i[11]);case 13:return e[t](i[0],i[1],i[2],i[3],i[4],i[5],i[6],i[7],i[8],i[9],i[10],i[11],i[12]);case 14:return e[t](i[0],i[1],i[2],i[3],i[4],i[5],i[6],i[7],i[8],i[9],i[10],i[11],i[12],i[13]);case 15:return e[t](i[0],i[1],i[2],i[3],i[4],i[5],i[6],i[7],i[8],i[9],i[10],i[11],i[12],i[13],i[14]);case 16:return e[t](i[0],i[1],i[2],i[3],i[4],i[5],i[6],i[7],i[8],i[9],i[10],i[11],i[12],i[13],i[14],i[15]);case 17:return e[t](i[0],i[1],i[2],i[3],i[4],i[5],i[6],i[7],i[8],i[9],i[10],i[11],i[12],i[13],i[14],i[15],i[16]);case 18:return e[t](i[0],i[1],i[2],i[3],i[4],i[5],i[6],i[7],i[8],i[9],i[10],i[11],i[12],i[13],i[14],i[15],i[16],i[17]);case 19:return e[t](i[0],i[1],i[2],i[3],i[4],i[5],i[6],i[7],i[8],i[9],i[10],i[11],i[12],i[13],i[14],i[15],i[16],i[17],i[18]);case 20:return e[t](i[0],i[1],i[2],i[3],i[4],i[5],i[6],i[7],i[8],i[9],i[10],i[11],i[12],i[13],i[14],i[15],i[16],i[17],i[18],i[19]);default:return e[t].apply(e,i)}}static getOriginFunctionName(e){return this.originFunctionPrefix+e}}A.originFunctionPrefix="__SPECTOR_Origin_";class R extends _{get spiedCommandName(){return R.commandName}stringifyArgs(e){const t=[];if(e.length>0){const n=e[0],i=this.stringifyValue(n);t.push(i)}if(e.length>1){const n=""+e[1];t.push(n)}return e.length>2&&t.push(e[2]),t}}R.commandName="bindAttribLocation";class S extends _{get spiedCommandName(){return S.commandName}stringifyArgs(e){const t=[],n=this.options.context.getParameter(d.READ_FRAMEBUFFER_BINDING.value),i=this.options.tagWebGlObject(n);t.push("READ FROM: "+this.stringifyValue(i));const r=this.options.context.getParameter(d.DRAW_FRAMEBUFFER_BINDING.value),s=this.options.tagWebGlObject(r);t.push("WRITE TO: "+this.stringifyValue(s));for(let n=0;n<8;n++)t.push(e[n]);return(e[8]&d.DEPTH_BUFFER_BIT.value)===d.DEPTH_BUFFER_BIT.value&&t.push(d.DEPTH_BUFFER_BIT.name),(e[8]&d.STENCIL_BUFFER_BIT.value)===d.STENCIL_BUFFER_BIT.value&&t.push(d.STENCIL_BUFFER_BIT.name),(e[8]&d.COLOR_BUFFER_BIT.value)===d.COLOR_BUFFER_BIT.value&&t.push(d.COLOR_BUFFER_BIT.name),t.push(d.stringifyWebGlConstant(e[9],"blitFrameBuffer")),t}}S.commandName="blitFrameBuffer";class T extends _{get spiedCommandName(){return T.commandName}stringifyArgs(e){const t=[];return(e[0]&d.DEPTH_BUFFER_BIT.value)===d.DEPTH_BUFFER_BIT.value&&t.push(d.DEPTH_BUFFER_BIT.name),(e[0]&d.STENCIL_BUFFER_BIT.value)===d.STENCIL_BUFFER_BIT.value&&t.push(d.STENCIL_BUFFER_BIT.name),(e[0]&d.COLOR_BUFFER_BIT.value)===d.COLOR_BUFFER_BIT.value&&t.push(d.COLOR_BUFFER_BIT.name),t}}T.commandName="clear";const b=["lineWidth"];class w extends _{constructor(e,t){super(e),this.internalSpiedCommandName=t,this.isDeprecated=b.indexOf(this.spiedCommandName)>-1}get spiedCommandName(){return this.internalSpiedCommandName}transformCapture(e){this.isDeprecated&&(e.status=50)}}class x extends _{get spiedCommandName(){return x.commandName}stringifyArgs(e){const t=[];return t.push(e[0]),t}}x.commandName="disableVertexAttribArray";class y extends _{get spiedCommandName(){return y.commandName}stringifyArgs(e){const t=[];return t.push(d.stringifyWebGlConstant(e[0],"drawArrays")),t.push(e[1]+" indices"),t.push(e[2]),t}}y.commandName="drawArrays";class L extends _{get spiedCommandName(){return L.commandName}stringifyArgs(e){const t=[];return t.push(d.stringifyWebGlConstant(e[0],"drawArraysInstanced")),t.push(e[1]),t.push(e[2]),t.push(e[3]),t}}L.commandName="drawArraysInstanced";class I extends _{get spiedCommandName(){return I.commandName}stringifyArgs(e){const t=[];return t.push(d.stringifyWebGlConstant(e[0],"drawArraysInstancedANGLE")),t.push(e[1]),t.push(e[2]),t.push(e[3]),t}}I.commandName="drawArraysInstancedANGLE";class F extends _{get spiedCommandName(){return F.commandName}stringifyArgs(e){const t=[];return t.push(d.stringifyWebGlConstant(e[0],"drawElements")),t.push(e[1]+" indices"),t.push(d.stringifyWebGlConstant(e[2],"drawElements")),t.push(e[3]),t}}F.commandName="drawElements";class N extends _{get spiedCommandName(){return N.commandName}stringifyArgs(e){const t=[];return t.push(d.stringifyWebGlConstant(e[0],"drawElementsInstancedANGLE")),t.push(e[1]+" indices"),t.push(d.stringifyWebGlConstant(e[2],"drawElementsInstancedANGLE")),t.push(e[3]),t.push(e[4]),t}}N.commandName="drawElementsInstancedANGLE";class M extends _{get spiedCommandName(){return M.commandName}stringifyArgs(e){const t=[];return t.push(d.stringifyWebGlConstant(e[0],"drawElementsInstanced")),t.push(e[1]+" indices"),t.push(d.stringifyWebGlConstant(e[2],"drawElementsInstanced")),t.push(e[3]),t.push(e[4]),t}}M.commandName="drawElementsInstanced";class O extends _{get spiedCommandName(){return O.commandName}stringifyArgs(e){const t=[];return t.push(d.stringifyWebGlConstant(e[0],"drawRangeElements")),t.push(e[1]),t.push(e[2]),t.push(e[3]),t.push(d.stringifyWebGlConstant(e[4],"drawRangeElements")),t.push(e[5]),t}}O.commandName="drawRangeElements";class B extends _{get spiedCommandName(){return B.commandName}stringifyResult(e){if(e)return`name: ${e.name}, size: ${e.size}, type: ${e.type}`}}B.commandName="getActiveAttrib";class $ extends _{get spiedCommandName(){return $.commandName}stringifyResult(e){if(e)return`name: ${e.name}, size: ${e.size}, type: ${e.type}`}}$.commandName="getActiveUniform";class P extends _{get spiedCommandName(){return P.commandName}stringifyResult(e){var t;if(null!=e)return null!==(t=null==e?void 0:e.toFixed(0))&&void 0!==t?t:"0"}}P.commandName="getAttribLocation";class k extends _{get spiedCommandName(){return k.commandName}stringifyResult(e){return e?"true":"false"}}k.commandName="getExtension";class D extends _{get spiedCommandName(){return D.commandName}stringifyResult(e){if(!e)return"null";const t=E.getWebGlObjectTag(e);return t?t.displayText:e}}D.commandName="getParameter";class U extends _{get spiedCommandName(){return U.commandName}stringifyResult(e){if(e)return`min: ${e.rangeMin}, max: ${e.rangeMax}, precision: ${e.precision}`}}U.commandName="getShaderPrecisionFormat";class G extends _{get spiedCommandName(){return G.commandName}stringifyResult(e){if(e)return`name: ${e.name}, size: ${e.size}, type: ${e.type}`}}G.commandName="getTransformFeedbackVarying";class W extends _{get spiedCommandName(){return W.commandName}stringifyArgs(e){const t=[];return t.push(d.stringifyWebGlConstant(e[0],"multiDrawArraysInstancedBaseInstanceWEBGL")),t.push(`drawCount=${e[9]}`),t.push(e[2]),t.push(e[4]),t.push(e[6]),t.push(e[8]),t}}W.commandName="multiDrawArraysInstancedBaseInstanceWEBGL";class V extends _{get spiedCommandName(){return V.commandName}stringifyArgs(e){const t=[];return t.push(d.stringifyWebGlConstant(e[0],"drawArrays")),t.push(`drawCount=${e[7]}`),t.push(e[2]),t.push(e[4]),t.push(e[6]),t}}V.commandName="multiDrawArraysInstancedWEBGL";class H extends _{get spiedCommandName(){return H.commandName}stringifyArgs(e){const t=[];return t.push(d.stringifyWebGlConstant(e[0],"drawArrays")),t.push(`drawCount=${e[5]}`),t.push(e[2]),t.push(e[4]),t}}H.commandName="multiDrawArraysWEBGL";class X extends _{get spiedCommandName(){return X.commandName}stringifyArgs(e){const t=[];return t.push(d.stringifyWebGlConstant(e[0],"drawArrays")),t.push(d.stringifyWebGlConstant(e[3],"drawArrays")),t.push(`drawCount=${e[11]}`),t.push(e[2]),t.push(e[4]),t.push(e[6]),t.push(e[8]),t.push(e[10]),t}}X.commandName="multiDrawElementsInstancedBaseVertexBaseInstanceWEBGL";class z extends _{get spiedCommandName(){return z.commandName}stringifyArgs(e){const t=[];return t.push(d.stringifyWebGlConstant(e[0],"drawArrays")),t.push(d.stringifyWebGlConstant(e[3],"drawArrays")),t.push(`drawCount=${e[8]}`),t.push(e[2]),t.push(e[5]),t.push(e[7]),t}}z.commandName="multiDrawElementsInstancedWEBGL";class K extends _{get spiedCommandName(){return K.commandName}stringifyArgs(e){const t=[];return t.push(d.stringifyWebGlConstant(e[0],"drawArrays")),t.push(d.stringifyWebGlConstant(e[3],"drawArrays")),t.push(`drawCount=${e[6]}`),t.push(e[2]),t.push(e[5]),t}}K.commandName="multiDrawElementsWEBGL";class j extends _{get spiedCommandName(){return j.commandName}stringifyArgs(e){const t=[];return t.push(d.stringifyWebGlConstant(e[0],"drawArraysInstanced")),t.push(e[1]),t.push(e[2]),t.push(e[3]),t.push(`baseInstance = ${e[4]}`),t}}j.commandName="drawArraysInstancedBaseInstanceWEBGL";class Y extends _{get spiedCommandName(){return Y.commandName}stringifyArgs(e){const t=[];return t.push(d.stringifyWebGlConstant(e[0],"drawElementsInstanced")),t.push(e[1]+" indices"),t.push(d.stringifyWebGlConstant(e[2],"drawElementsInstanced")),t.push(e[3]),t.push(e[4]),t.push(`baseVertex = ${e[5]}`),t.push(`baseInstance = ${e[6]}`),t}}Y.commandName="drawElementsInstancedBaseVertexBaseInstanceWEBGL";class q extends _{get spiedCommandName(){return q.commandName}stringifyArgs(e){var t,n;const i=[];for(let r=0;r<4;r++)i.push(null!==(n=null===(t=e[r])||void 0===t?void 0:t.toFixed(0))&&void 0!==n?n:"0");return i}}function Z(e){return null==e?"":`${e.toFixed(0)} (0b${(e>>>0).toString(2)})`}q.commandName="scissor";class Q extends _{get spiedCommandName(){return Q.commandName}stringifyArgs(e){const t=[];return t.push(Z(e[0])),t}}Q.commandName="stencilMask";class J extends _{get spiedCommandName(){return J.commandName}stringifyArgs(e){const t=[];return t.push(d.stringifyWebGlConstant(e[0],"stencilMaskSeparate")),t.push(Z(e[1])),t}}J.commandName="stencilMaskSeparate";class ee extends _{get spiedCommandName(){return ee.commandName}stringifyArgs(e){const t=[];return t.push(d.stringifyWebGlConstant(e[0],"stencilFunc")),t.push(Z(e[1])),t.push(Z(e[2])),t}}ee.commandName="stencilFunc";class te extends _{get spiedCommandName(){return te.commandName}stringifyArgs(e){const t=[];return t.push(d.stringifyWebGlConstant(e[0],"stencilFuncSeparate")),t.push(d.stringifyWebGlConstant(e[1],"stencilFuncSeparate")),t.push(Z(e[2])),t.push(Z(e[3])),t}}te.commandName="stencilFuncSeparate";class ne extends _{get spiedCommandName(){return ne.commandName}stringifyArgs(e){const t=[];return t.push(e[0]),t.push(e[1]),t.push(d.stringifyWebGlConstant(e[2],"vertexAttribPointer")),t.push(e[3]),t.push(e[4]),t.push(e[5]),t}}ne.commandName="vertexAttribPointer";class ie extends _{get spiedCommandName(){return ie.commandName}stringifyArgs(e){const t=[];for(let n=0;n<4;n++)t.push(e[n].toFixed(0));return t}}ie.commandName="viewport";class re extends _{get spiedCommandName(){return re.commandName}stringifyArgs(e){const t=[];return t.push(e[0]),t}}re.commandName="enableVertexAttribArray";class se{constructor(e){this.spiedCommandName=e.spiedCommandName,this.spiedCommandRunningContext=e.spiedCommandRunningContext,this.spiedCommand=this.spiedCommandRunningContext[this.spiedCommandName],A.storeOriginFunction(this.spiedCommandRunningContext,this.spiedCommandName),this.callback=e.callback,this.commandOptions={context:e.context,contextVersion:e.contextVersion,extensions:e.extensions,toggleCapture:e.toggleCapture},this.initCustomCommands(),this.initCommand()}spy(){this.spiedCommandRunningContext[this.spiedCommandName]=this.overloadedCommand}unSpy(){this.spiedCommandRunningContext[this.spiedCommandName]=this.spiedCommand}createCapture(e,t,n){return this.command.createCapture(e,t,n)}initCommand(){se.customCommandsConstructors[this.spiedCommandName]?this.command=se.customCommandsConstructors[this.spiedCommandName](this.commandOptions):this.command=new w(this.commandOptions,this.spiedCommandName),this.overloadedCommand=this.getSpy()}getSpy(){const e=this;return function(){const t=a.now,n=A.executeOriginFunction(e.spiedCommandRunningContext,e.spiedCommandName,arguments),i=a.now,r={name:e.spiedCommandName,arguments,result:n,startTime:t,endTime:i};return e.callback(e,r),n}}initCustomCommands(){se.customCommandsConstructors||(se.customCommandsConstructors={[R.commandName]:e=>new R(e),[S.commandName]:e=>new S(e),[C.commandName]:e=>new C(e),[T.commandName]:e=>new T(e),[x.commandName]:e=>new x(e),[y.commandName]:e=>new y(e),[L.commandName]:e=>new L(e),[I.commandName]:e=>new I(e),[F.commandName]:e=>new F(e),[M.commandName]:e=>new M(e),[N.commandName]:e=>new N(e),[O.commandName]:e=>new O(e),[B.commandName]:e=>new B(e),[$.commandName]:e=>new $(e),[P.commandName]:e=>new P(e),[k.commandName]:e=>new k(e),[D.commandName]:e=>new D(e),[U.commandName]:e=>new U(e),[G.commandName]:e=>new G(e),[W.commandName]:e=>new W(e),[V.commandName]:e=>new V(e),[H.commandName]:e=>new H(e),[X.commandName]:e=>new X(e),[z.commandName]:e=>new z(e),[K.commandName]:e=>new K(e),[j.commandName]:e=>new j(e),[Y.commandName]:e=>new Y(e),[q.commandName]:e=>new q(e),[Q.commandName]:e=>new Q(e),[J.commandName]:e=>new J(e),[ee.commandName]:e=>new ee(e),[te.commandName]:e=>new te(e),[ne.commandName]:e=>new ne(e),[ie.commandName]:e=>new ie(e),[re.commandName]:e=>new re(e)})}}class oe{constructor(e){this.options=e,this.context=e.context,this.contextVersion=e.contextVersion,this.extensions=e.extensions,this.toggleCapture=e.toggleCapture,this.consumeCommands=this.getConsumeCommands(),this.changeCommandsByState=this.getChangeCommandsByState(),this.commandNameToStates=this.getCommandNameToStates()}get requireStartAndStopStates(){return!0}startCapture(e,t,n){return this.quickCapture=t,this.fullCapture=n,this.capturedCommandsByState={},e&&this.requireStartAndStopStates&&(this.currentState={},this.readFromContextNoSideEffects()),this.copyCurrentStateToPrevious(),this.currentState={},this.previousState}stopCapture(){return this.requireStartAndStopStates&&this.readFromContextNoSideEffects(),this.analyse(void 0),this.currentState}registerCallbacks(e){for(const t in this.changeCommandsByState)if(this.changeCommandsByState.hasOwnProperty(t))for(const n of this.changeCommandsByState[t])e[n]=e[n]||[],e[n].push(this.onChangeCommand.bind(this));for(const t of this.consumeCommands)e[t]=e[t]||[],e[t].push(this.onConsumeCommand.bind(this))}getStateData(){return this.currentState}getConsumeCommands(){return[]}getChangeCommandsByState(){return{}}copyCurrentStateToPrevious(){this.currentState&&(this.previousState=this.currentState)}onChangeCommand(e){const t=this.commandNameToStates[e.name];for(const n of t){if(!this.isValidChangeCommand(e,n))return;this.capturedCommandsByState[n]=this.capturedCommandsByState[n]||[],this.capturedCommandsByState[n].push(e)}}isValidChangeCommand(e,t){return!0}onConsumeCommand(e){this.isValidConsumeCommand(e)&&(this.readFromContextNoSideEffects(),this.analyse(e),this.storeCommandIds(),e[this.stateName]=this.currentState,this.startCapture(!1,this.quickCapture,this.fullCapture))}isValidConsumeCommand(e){return this.lastCommandName=null==e?void 0:e.name,!0}analyse(e){for(const t in this.capturedCommandsByState)if(this.capturedCommandsByState.hasOwnProperty(t)){const n=this.capturedCommandsByState[t],i=n.length-1;if(i>=0)if(e){for(let t=0;t<i;t++){const i=n[t];i.consumeCommandId=e.id,this.changeCommandCaptureStatus(i,30)}const r=this.isStateEnableNoSideEffects(t,e.commandArguments),s=n[i];s.consumeCommandId=e.id,this.areStatesEquals(this.currentState[t],this.previousState[t])?this.changeCommandCaptureStatus(s,30):r?this.changeCommandCaptureStatus(s,40):this.changeCommandCaptureStatus(s,20)}else for(let e=0;e<n.length;e++){const t=n[e];this.changeCommandCaptureStatus(t,10)}}}storeCommandIds(){const e=["unusedCommandIds","disabledCommandIds","redundantCommandIds","validCommandIds"];for(const t of e)this.currentState[t]=[];for(const e in this.capturedCommandsByState)if(this.capturedCommandsByState.hasOwnProperty(e)){const t=this.capturedCommandsByState[e];for(const e of t)switch(e.status){case 10:this.currentState.unusedCommandIds.push(e.id);break;case 20:this.currentState.disabledCommandIds.push(e.id);break;case 30:this.currentState.redundantCommandIds.push(e.id);break;case 40:this.currentState.validCommandIds.push(e.id)}}for(const t of e)this.currentState[t].length||delete this.currentState[t]}changeCommandCaptureStatus(e,t){return e.status<t&&(e.status=t,!0)}areStatesEquals(e,t){if(typeof e!=typeof t)return!1;if(e&&!t)return!1;if(t&&!e)return!1;if(null==e)return!0;if(e.length&&t.length&&"string"!=typeof e){if(e.length!==t.length)return!1;for(let n=0;n<e.length;n++)if(e[n]!==t[n])return!1;return!0}return e===t}isStateEnable(e,t){return!0}getSpectorData(e){if(e)return{__SPECTOR_Object_TAG:E.getWebGlObjectTag(e)||this.options.tagWebGlObject(e),__SPECTOR_Object_CustomData:e.__SPECTOR_Object_CustomData,__SPECTOR_Metadata:e.__SPECTOR_Metadata}}readFromContextNoSideEffects(){this.toggleCapture(!1),this.readFromContext(),this.toggleCapture(!0)}isStateEnableNoSideEffects(e,t){this.toggleCapture(!1);const n=this.isStateEnable(e,t);return this.toggleCapture(!0),n}getCommandNameToStates(){const e={};for(const t in this.changeCommandsByState)if(this.changeCommandsByState.hasOwnProperty(t))for(const n of this.changeCommandsByState[t])e[n]=e[n]||[],e[n].push(t);return e}}class ae extends oe{getWebgl1Parameters(){return[]}getWebgl2Parameters(){return[]}getChangeCommandsByState(){this.parameters=[],this.parameters.push(this.getWebgl1Parameters()),this.contextVersion>1&&this.parameters.push(this.getWebgl2Parameters());const e={};for(let t=1;t<=this.contextVersion&&!(t>this.parameters.length);t++)if(this.parameters[t-1])for(const n of this.parameters[t-1])if(n.changeCommands)for(const t of n.changeCommands)e[n.constant.name]=e[n.constant.name]||[],e[n.constant.name].push(t);return e}readFromContext(){for(let e=1;e<=this.contextVersion&&!(e>this.parameters.length);e++)for(const t of this.parameters[e-1]){const e=this.readParameterFromContext(t);if(null==e){const n=this.stringifyParameterValue(e,t);this.currentState[t.constant.name]=n;continue}const n=E.getWebGlObjectTag(e);if(n)this.currentState[t.constant.name]=n;else{const n=this.stringifyParameterValue(e,t);this.currentState[t.constant.name]=n}}}readParameterFromContext(e){return e.constant.extensionName&&!this.extensions[e.constant.extensionName]?`Extension ${e.constant.extensionName} is unavailable.`:this.context.getParameter(e.constant.value)}stringifyParameterValue(e,t){if(null===e)return"null";if(void 0===e)return"undefined";if(30===t.returnType)return Z(e);if("number"==typeof e&&d.isWebGlConstant(e)){if(20===t.returnType){const n=t.changeCommands&&t.changeCommands[0]||"";return d.stringifyWebGlConstant(e,n)}return e}if(e.length&&"string"!=typeof e){const t=[];for(let n=0;n<e.length;n++)t.push(e[n]);return t}return e}}class le extends ae{get stateName(){return le.stateName}getWebgl1Parameters(){return[{constant:d.PACK_ALIGNMENT,changeCommands:["pixelStorei"]},{constant:d.UNPACK_ALIGNMENT,changeCommands:["pixelStorei"]},{constant:d.UNPACK_COLORSPACE_CONVERSION_WEBGL,returnType:20,changeCommands:["pixelStorei"]},{constant:d.UNPACK_FLIP_Y_WEBGL,changeCommands:["pixelStorei"]},{constant:d.UNPACK_PREMULTIPLY_ALPHA_WEBGL,changeCommands:["pixelStorei"]}]}getWebgl2Parameters(){return[{constant:d.PACK_ROW_LENGTH,changeCommands:["pixelStorei"]},{constant:d.PACK_SKIP_PIXELS,changeCommands:["pixelStorei"]},{constant:d.PACK_SKIP_ROWS,changeCommands:["pixelStorei"]},{constant:d.UNPACK_IMAGE_HEIGHT,changeCommands:["pixelStorei"]},{constant:d.UNPACK_SKIP_PIXELS,changeCommands:["pixelStorei"]},{constant:d.UNPACK_SKIP_ROWS,changeCommands:["pixelStorei"]},{constant:d.UNPACK_SKIP_IMAGES,changeCommands:["pixelStorei"]}]}getConsumeCommands(){return["readPixels","texImage2D","texSubImage2D"]}isValidChangeCommand(e,t){return m[t].value===e.commandArguments[0]}}le.stateName="AlignmentState";class ce extends ae{get stateName(){return ce.stateName}getWebgl1Parameters(){return[{constant:d.BLEND,changeCommands:["enable","disable"]},{constant:d.BLEND_COLOR,changeCommands:["blendColor"]},{constant:d.BLEND_DST_ALPHA,returnType:20,changeCommands:["blendFunc","blendFuncSeparate"]},{constant:d.BLEND_DST_RGB,returnType:20,changeCommands:["blendFunc","blendFuncSeparate"]},{constant:d.BLEND_EQUATION_ALPHA,returnType:20,changeCommands:["blendEquation","blendEquationSeparate"]},{constant:d.BLEND_EQUATION_RGB,returnType:20,changeCommands:["blendEquation","blendEquationSeparate"]},{constant:d.BLEND_SRC_ALPHA,returnType:20,changeCommands:["blendFunc","blendFuncSeparate"]},{constant:d.BLEND_SRC_RGB,returnType:20,changeCommands:["blendFunc","blendFuncSeparate"]}]}isValidChangeCommand(e,t){return"enable"!==e.name&&"disable"!==e.name||e.commandArguments[0]===d.BLEND.value}getConsumeCommands(){return u}isStateEnable(e,t){return this.context.isEnabled(d.BLEND.value)}}ce.stateName="BlendState";class ue extends ae{get stateName(){return ue.stateName}getWebgl1Parameters(){return[{constant:d.COLOR_CLEAR_VALUE,changeCommands:["clearColor"]},{constant:d.DEPTH_CLEAR_VALUE,changeCommands:["clearDepth"]},{constant:d.STENCIL_CLEAR_VALUE,changeCommands:["clearStencil"]}]}getConsumeCommands(){return["clear"]}isStateEnable(e,t){switch(e){case d.COLOR_CLEAR_VALUE.name:return d.COLOR_BUFFER_BIT.value===(t[0]&d.COLOR_BUFFER_BIT.value);case d.DEPTH_CLEAR_VALUE.name:return d.DEPTH_BUFFER_BIT.value===(t[0]&d.DEPTH_BUFFER_BIT.value);case d.STENCIL_CLEAR_VALUE.name:return d.STENCIL_BUFFER_BIT.value===(t[0]&d.STENCIL_BUFFER_BIT.value)}return!1}}ue.stateName="ClearState";class he extends ae{get stateName(){return he.stateName}getWebgl1Parameters(){return[{constant:d.COLOR_WRITEMASK,changeCommands:["colorMask"]}]}getConsumeCommands(){return u}}he.stateName="ColorState";class de extends ae{get stateName(){return de.stateName}getWebgl1Parameters(){return[{constant:d.SAMPLE_COVERAGE_VALUE,changeCommands:["sampleCoverage"]},{constant:d.SAMPLE_COVERAGE_INVERT,changeCommands:["sampleCoverage"]}]}getWebgl2Parameters(){return[{constant:d.SAMPLE_COVERAGE,changeCommands:["enable","disable"]},{constant:d.SAMPLE_ALPHA_TO_COVERAGE,changeCommands:["enable","disable"]}]}isValidChangeCommand(e,t){return"enable"!==e.name&&"disable"!==e.name||(e.commandArguments[0]===d.SAMPLE_COVERAGE.value?t===d.SAMPLE_COVERAGE.name:e.commandArguments[0]===d.SAMPLE_ALPHA_TO_COVERAGE.value&&t===d.SAMPLE_ALPHA_TO_COVERAGE.name)}getConsumeCommands(){return u}isStateEnable(e,t){return 2===this.contextVersion&&this.context.isEnabled(d.SAMPLE_COVERAGE.value)}}de.stateName="CoverageState";class me extends ae{get stateName(){return me.stateName}getWebgl1Parameters(){return[{constant:d.CULL_FACE,changeCommands:["enable","disable"]},{constant:d.CULL_FACE_MODE,returnType:20,changeCommands:["cullFace"]}]}getConsumeCommands(){return u}isValidChangeCommand(e,t){return"enable"!==e.name&&"disable"!==e.name||e.commandArguments[0]===d.CULL_FACE.value}isStateEnable(e,t){return this.context.isEnabled(d.CULL_FACE.value)}}me.stateName="CullState";class pe extends ae{get stateName(){return pe.stateName}getWebgl1Parameters(){return[{constant:d.DEPTH_TEST,changeCommands:["enable","disable"]},{constant:d.DEPTH_FUNC,returnType:20,changeCommands:["depthFunc"]},{constant:d.DEPTH_RANGE,changeCommands:["depthRange"]},{constant:d.DEPTH_WRITEMASK,changeCommands:["depthMask"]}]}getConsumeCommands(){return u}isValidChangeCommand(e,t){return"enable"!==e.name&&"disable"!==e.name||e.commandArguments[0]===d.DEPTH_TEST.value}isStateEnable(e,t){return this.context.isEnabled(d.DEPTH_TEST.value)}}pe.stateName="DepthState";class ge extends ae{get stateName(){return ge.stateName}getWebgl1Parameters(){return[{constant:d.DITHER,changeCommands:["enable","disable"]},{constant:d.VIEWPORT,changeCommands:["viewPort"]},{constant:d.FRONT_FACE,returnType:20,changeCommands:["frontFace"]},{constant:d.FRAGMENT_SHADER_DERIVATIVE_HINT_OES,changeCommands:["hint"]}]}getWebgl2Parameters(){return[{constant:d.RASTERIZER_DISCARD,changeCommands:["enable","disable"]},{constant:d.FRAGMENT_SHADER_DERIVATIVE_HINT,changeCommands:["hint"]}]}isValidChangeCommand(e,t){return"enable"===e.name||"disable"===e.name?e.commandArguments[0]===d.DITHER.value?t===d.DITHER.name:e.commandArguments[0]===d.RASTERIZER_DISCARD.value&&t===d.RASTERIZER_DISCARD.name:"hint"!==e.name||(e.commandArguments[0]===d.FRAGMENT_SHADER_DERIVATIVE_HINT_OES.value?t===d.FRAGMENT_SHADER_DERIVATIVE_HINT_OES.name:e.commandArguments[0]===d.FRAGMENT_SHADER_DERIVATIVE_HINT.value&&t===d.FRAGMENT_SHADER_DERIVATIVE_HINT.name)}getConsumeCommands(){return u}isStateEnable(e,t){switch(e){case d.DITHER.name:return this.context.isEnabled(d.DITHER.value);case d.RASTERIZER_DISCARD.name:return this.context.isEnabled(d.RASTERIZER_DISCARD.value)}return!0}}ge.stateName="DrawState";class fe extends ae{get stateName(){return fe.stateName}getWebgl1Parameters(){return[{constant:d.GENERATE_MIPMAP_HINT,changeCommands:["hint"]}]}getConsumeCommands(){return["generateMipmap"]}}fe.stateName="MipmapHintState";class Ee extends ae{get stateName(){return Ee.stateName}getWebgl1Parameters(){return[{constant:d.POLYGON_OFFSET_FILL,changeCommands:["enable","disable"]},{constant:d.POLYGON_OFFSET_FACTOR,changeCommands:["polygonOffset"]},{constant:d.POLYGON_OFFSET_UNITS,changeCommands:["polygonOffset"]}]}isValidChangeCommand(e,t){return"enable"!==e.name&&"disable"!==e.name||e.commandArguments[0]===d.POLYGON_OFFSET_FILL.value}getConsumeCommands(){return u}isStateEnable(e,t){return this.context.isEnabled(d.POLYGON_OFFSET_FILL.value)}}Ee.stateName="PolygonOffsetState";class ve extends ae{get stateName(){return ve.stateName}getWebgl1Parameters(){return[{constant:d.SCISSOR_TEST,changeCommands:["enable","disable"]},{constant:d.SCISSOR_BOX,changeCommands:["scissor"]}]}isValidChangeCommand(e,t){return"enable"!==e.name&&"disable"!==e.name||e.commandArguments[0]===d.SCISSOR_TEST.value}getConsumeCommands(){return[...u,"clear"]}isStateEnable(e,t){return this.context.isEnabled(d.SCISSOR_TEST.value)}}ve.stateName="ScissorState";class _e extends ae{get stateName(){return _e.stateName}getWebgl1Parameters(){return[{constant:d.STENCIL_TEST,changeCommands:["enable","disable"]},{constant:d.STENCIL_BACK_FAIL,returnType:20,changeCommands:["stencilOp","stencilOpSeparate"]},{constant:d.STENCIL_BACK_FUNC,returnType:20,changeCommands:["stencilFunc","stencilFuncSeparate"]},{constant:d.STENCIL_BACK_PASS_DEPTH_FAIL,returnType:20,changeCommands:["stencilOp","stencilOpSeparate"]},{constant:d.STENCIL_BACK_PASS_DEPTH_PASS,returnType:20,changeCommands:["stencilOp","stencilOpSeparate"]},{constant:d.STENCIL_BACK_REF,changeCommands:["stencilFunc","stencilFuncSeparate"]},{constant:d.STENCIL_BACK_VALUE_MASK,returnType:30,changeCommands:["stencilFunc","stencilFuncSeparate"]},{constant:d.STENCIL_BACK_WRITEMASK,returnType:30,changeCommands:["stencilMask","stencilMaskSeparate"]},{constant:d.STENCIL_FAIL,returnType:20,changeCommands:["stencilOp","stencilOpSeparate"]},{constant:d.STENCIL_FUNC,returnType:20,changeCommands:["stencilFunc","stencilFuncSeparate"]},{constant:d.STENCIL_PASS_DEPTH_FAIL,returnType:20,changeCommands:["stencilOp","stencilOpSeparate"]},{constant:d.STENCIL_PASS_DEPTH_PASS,returnType:20,changeCommands:["stencilOp","stencilOpSeparate"]},{constant:d.STENCIL_REF,changeCommands:["stencilFunc","stencilFuncSeparate"]},{constant:d.STENCIL_VALUE_MASK,returnType:30,changeCommands:["stencilFunc","stencilFuncSeparate"]},{constant:d.STENCIL_WRITEMASK,returnType:30,changeCommands:["stencilMask","stencilMaskSeparate"]}]}readFromContext(){super.readFromContext();const e=this.context,t=d.FRAMEBUFFER.value,n=d.STENCIL_ATTACHMENT.value;let i=0;e.getParameter(d.FRAMEBUFFER_BINDING.value)?this.context.getFramebufferAttachmentParameter(t,n,d.FRAMEBUFFER_ATTACHMENT_OBJECT_TYPE.value)!==d.NONE.value&&(this.contextVersion>1?i=this.context.getFramebufferAttachmentParameter(t,n,d.FRAMEBUFFER_ATTACHMENT_STENCIL_SIZE.value):this.context.getFramebufferAttachmentParameter(t,n,d.FRAMEBUFFER_ATTACHMENT_OBJECT_NAME.value)===d.RENDERBUFFER.value&&(i=e.getRenderbufferParameter(e.RENDERBUFFER,e.RENDERBUFFER_STENCIL_SIZE))):i=this.readParameterFromContext({constant:d.STENCIL_BITS}),this.currentState[d.STENCIL_BITS.name]=""+i}isValidChangeCommand(e,t){return"enable"===e.name||"disable"===e.name?e.commandArguments[0]===d.STENCIL_TEST.value:"stencilOp"===e.name||"stencilOpSeparate"===e.name?_e.stencilOpStates.indexOf(e.commandArguments[0])>0:"stencilFunc"===e.name||"stencilFuncSeparate"===e.name?_e.stencilFuncStates.indexOf(e.commandArguments[0])>0:"stencilMask"!==e.name&&"stencilMaskSeparate"!==e.name||_e.stencilMaskStates.indexOf(e.commandArguments[0])>0}getConsumeCommands(){return u}isStateEnable(e,t){return this.context.isEnabled(d.STENCIL_TEST.value)}}_e.stateName="StencilState",_e.stencilOpStates=[d.STENCIL_BACK_FAIL.value,d.STENCIL_BACK_PASS_DEPTH_FAIL.value,d.STENCIL_BACK_PASS_DEPTH_PASS.value,d.STENCIL_FAIL.value,d.STENCIL_PASS_DEPTH_FAIL.value,d.STENCIL_PASS_DEPTH_PASS.value],_e.stencilFuncStates=[d.STENCIL_BACK_FUNC.value,d.STENCIL_BACK_REF.value,d.STENCIL_BACK_VALUE_MASK.value,d.STENCIL_FUNC.value,d.STENCIL_REF.value,d.STENCIL_VALUE_MASK.value],_e.stencilMaskStates=[d.STENCIL_BACK_WRITEMASK.value,d.STENCIL_WRITEMASK.value];class Ce{static isSupportedCombination(e,t,n){return e=e||d.UNSIGNED_BYTE.value,((t=t||d.RGBA.value)===d.RGB.value||t===d.RGBA.value)&&(n===d.RGB.value||n===d.RGBA.value||n===d.RGBA8.value||n===d.RGBA16F.value||n===d.RGBA32F.value||n===d.RGB16F.value||n===d.RGB32F.value||n===d.R11F_G11F_B10F.value||n===d.SRGB8.value||n===d.SRGB8_ALPHA8.value)&&this.isSupportedComponentType(e)}static readPixels(e,t,n,i,r,s){e.getError(),s===d.UNSIGNED_NORMALIZED.value&&(s=d.UNSIGNED_BYTE.value);const o=i*r*4;let a;if(s===d.UNSIGNED_BYTE.value?a=new Uint8Array(o):(s=d.FLOAT.value,a=new Float32Array(o)),e.readPixels(t,n,i,r,e.RGBA,s,a),e.getError())return;if(s===d.UNSIGNED_BYTE.value)return a;const l=new Uint8Array(i*r*4);for(let e=0;e<r;e++)for(let t=0;t<i;t++)l[e*i*4+4*t+0]=255*Math.min(Math.max(a[e*i*4+4*t+0],0),1),l[e*i*4+4*t+1]=255*Math.min(Math.max(a[e*i*4+4*t+1],0),1),l[e*i*4+4*t+2]=255*Math.min(Math.max(a[e*i*4+4*t+2],0),1),l[e*i*4+4*t+3]=255*Math.min(Math.max(a[e*i*4+4*t+3],0),1);return l}static isSupportedComponentType(e){return e===d.UNSIGNED_BYTE.value||e===d.UNSIGNED_SHORT_4_4_4_4.value||e===d.UNSIGNED_SHORT_5_5_5_1.value||e===d.UNSIGNED_SHORT_5_6_5.value||e===d.HALF_FLOAT.value||e===d.HALF_FLOAT_OES.value||e===d.FLOAT.value}}class Ae extends oe{constructor(e){super(e),this.captureFrameBuffer=e.context.createFramebuffer(),this.workingCanvas=document.createElement("canvas"),this.workingContext2D=this.workingCanvas.getContext("2d"),this.captureCanvas=document.createElement("canvas"),this.captureContext2D=this.captureCanvas.getContext("2d"),this.captureContext2D.imageSmoothingEnabled=!0,this.captureContext2D.mozImageSmoothingEnabled=!0,this.captureContext2D.oImageSmoothingEnabled=!0,this.captureContext2D.webkitImageSmoothingEnabled=!0,this.captureContext2D.msImageSmoothingEnabled=!0}get stateName(){return Ae.stateName}getConsumeCommands(){return["clear","clearBufferfv","clearBufferiv","clearBufferuiv","clearBufferfi",...u]}readFromContext(){const e=this.context;this.currentState.Attachments=[];const t=this.context.getParameter(d.FRAMEBUFFER_BINDING.value);if(!t)return this.currentState.FrameBuffer=null,void this.getCapture(e,"Canvas COLOR_ATTACHMENT",0,0,e.drawingBufferWidth,e.drawingBufferHeight,0,0,d.UNSIGNED_BYTE.value);const n=e.getParameter(e.VIEWPORT),i=n[0],r=n[1],s=n[2],o=n[3];this.currentState.FrameBuffer=this.getSpectorData(t);const a=this.context.checkFramebufferStatus(d.FRAMEBUFFER.value);if(this.currentState.FrameBufferStatus=p[a].name,a===d.FRAMEBUFFER_COMPLETE.value)if(this.extensions[d.MAX_DRAW_BUFFERS_WEBGL.extensionName]){const e=this.context.getParameter(d.MAX_DRAW_BUFFERS_WEBGL.value);for(let n=0;n<e;n++)this.readFrameBufferAttachmentFromContext(this.context,t,m["COLOR_ATTACHMENT"+n+"_WEBGL"],i,r,s,o)}else if(this.contextVersion>1){const e=this.context.getParameter(d.MAX_DRAW_BUFFERS.value);for(let n=0;n<e;n++)this.readFrameBufferAttachmentFromContext(this.context,t,m["COLOR_ATTACHMENT"+n],i,r,s,o)}else this.readFrameBufferAttachmentFromContext(this.context,t,m.COLOR_ATTACHMENT0,i,r,s,o)}readFrameBufferAttachmentFromContext(e,t,n,i,r,s,o){const a=d.FRAMEBUFFER.value,l=this.context.getFramebufferAttachmentParameter(a,n.value,d.FRAMEBUFFER_ATTACHMENT_OBJECT_TYPE.value);if(l===d.NONE.value)return;const c=this.context.getFramebufferAttachmentParameter(a,n.value,d.FRAMEBUFFER_ATTACHMENT_OBJECT_NAME.value);if(!c)return;const u=this.contextVersion>1?this.context.getFramebufferAttachmentParameter(a,n.value,d.FRAMEBUFFER_ATTACHMENT_COMPONENT_TYPE.value):d.UNSIGNED_BYTE.value;l===d.RENDERBUFFER.value?this.readFrameBufferAttachmentFromRenderBuffer(e,t,n,i,r,s,o,a,u,c):l===d.TEXTURE.value&&this.readFrameBufferAttachmentFromTexture(e,t,n,i,r,s,o,a,u,c)}readFrameBufferAttachmentFromRenderBuffer(e,t,n,i,r,s,o,a,l,c){let u=0,h=0;if(c.__SPECTOR_Object_CustomData){const e=c.__SPECTOR_Object_CustomData;if(s=e.width,o=e.height,u=e.samples,h=e.internalFormat,!u&&!Ce.isSupportedCombination(l,d.RGBA.value,h))return}else s+=i,o+=r;if(i=r=0,u){const a=e,c=e.createRenderbuffer(),u=e.getParameter(e.RENDERBUFFER_BINDING);e.bindRenderbuffer(e.RENDERBUFFER,c),e.renderbufferStorage(e.RENDERBUFFER,h,s,o),e.bindRenderbuffer(e.RENDERBUFFER,u),e.bindFramebuffer(d.FRAMEBUFFER.value,this.captureFrameBuffer),e.framebufferRenderbuffer(d.FRAMEBUFFER.value,d.COLOR_ATTACHMENT0.value,d.RENDERBUFFER.value,c);const m=a.getParameter(a.READ_FRAMEBUFFER_BINDING),p=a.getParameter(a.DRAW_FRAMEBUFFER_BINDING);a.bindFramebuffer(a.READ_FRAMEBUFFER,t),a.bindFramebuffer(a.DRAW_FRAMEBUFFER,this.captureFrameBuffer),a.blitFramebuffer(0,0,s,o,0,0,s,o,e.COLOR_BUFFER_BIT,e.NEAREST),a.bindFramebuffer(d.FRAMEBUFFER.value,this.captureFrameBuffer),a.bindFramebuffer(a.READ_FRAMEBUFFER,m),a.bindFramebuffer(a.DRAW_FRAMEBUFFER,p),this.context.checkFramebufferStatus(d.FRAMEBUFFER.value)===d.FRAMEBUFFER_COMPLETE.value&&this.getCapture(e,n.name,i,r,s,o,0,0,l),e.bindFramebuffer(d.FRAMEBUFFER.value,t),e.deleteRenderbuffer(c)}else e.bindFramebuffer(d.FRAMEBUFFER.value,this.captureFrameBuffer),e.framebufferRenderbuffer(d.FRAMEBUFFER.value,d.COLOR_ATTACHMENT0.value,d.RENDERBUFFER.value,c),this.context.checkFramebufferStatus(d.FRAMEBUFFER.value)===d.FRAMEBUFFER_COMPLETE.value&&this.getCapture(e,n.name,i,r,s,o,0,0,l),e.bindFramebuffer(d.FRAMEBUFFER.value,t)}readFrameBufferAttachmentFromTexture(e,t,n,i,r,s,o,a,l,c){let u=0;this.contextVersion>1&&(u=this.context.getFramebufferAttachmentParameter(a,n.value,d.FRAMEBUFFER_ATTACHMENT_TEXTURE_LAYER.value));const h=this.context.getFramebufferAttachmentParameter(a,n.value,d.FRAMEBUFFER_ATTACHMENT_TEXTURE_LEVEL.value),m=this.context.getFramebufferAttachmentParameter(a,n.value,d.FRAMEBUFFER_ATTACHMENT_TEXTURE_CUBE_MAP_FACE.value);m>0?p[m].name:d.TEXTURE_2D.name;let g=!1,f=l;if(c.__SPECTOR_Object_CustomData){const e=c.__SPECTOR_Object_CustomData;if(s=e.width,o=e.height,void 0!==e.type&&(f=e.type),g=e.target===d.TEXTURE_2D_ARRAY.name,!Ce.isSupportedCombination(e.type,e.format,e.internalFormat))return}else s+=i,o+=r;i=r=0,e.bindFramebuffer(d.FRAMEBUFFER.value,this.captureFrameBuffer),u>0||g?e.framebufferTextureLayer(d.FRAMEBUFFER.value,d.COLOR_ATTACHMENT0.value,c,h,u):e.framebufferTexture2D(d.FRAMEBUFFER.value,d.COLOR_ATTACHMENT0.value,m||d.TEXTURE_2D.value,c,h),this.context.checkFramebufferStatus(d.FRAMEBUFFER.value)===d.FRAMEBUFFER_COMPLETE.value&&this.getCapture(e,n.name,i,r,s,o,m,u,f),e.bindFramebuffer(d.FRAMEBUFFER.value,t)}getCapture(e,t,n,i,r,o,a,l,c){const u={attachmentName:t,src:null,textureCubeMapFace:a?p[a].name:null,textureLayer:l};if(!this.quickCapture)try{const t=Ce.readPixels(e,n,i,r,o,c);if(t){this.workingCanvas.width=r,this.workingCanvas.height=o;const e=this.workingContext2D.createImageData(Math.ceil(r),Math.ceil(o));if(e.data.set(t),this.workingContext2D.putImageData(e,0,0),this.fullCapture)this.captureCanvas.width=this.workingCanvas.width,this.captureCanvas.height=this.workingCanvas.height;else{const e=r/o;e<1?(this.captureCanvas.width=Ae.captureBaseSize*e,this.captureCanvas.height=Ae.captureBaseSize):e>1?(this.captureCanvas.width=Ae.captureBaseSize,this.captureCanvas.height=Ae.captureBaseSize/e):(this.captureCanvas.width=Ae.captureBaseSize,this.captureCanvas.height=Ae.captureBaseSize)}this.captureCanvas.width=Math.max(this.captureCanvas.width,1),this.captureCanvas.height=Math.max(this.captureCanvas.height,1),this.captureContext2D.globalCompositeOperation="copy",this.captureContext2D.scale(1,-1),this.captureContext2D.translate(0,-this.captureCanvas.height),this.captureContext2D.drawImage(this.workingCanvas,0,0,r,o,0,0,this.captureCanvas.width,this.captureCanvas.height),this.captureContext2D.setTransform(1,0,0,1,0,0),this.captureContext2D.globalCompositeOperation="source-over",u.src=this.captureCanvas.toDataURL()}}catch(e){s.warn("Spector can not capture the visual state: "+e)}this.currentState.Attachments.push(u)}analyse(e){}}Ae.stateName="VisualState",Ae.captureBaseSize=256;class Re{constructor(e){this.context=e.context,this.captureFrameBuffer=e.context.createFramebuffer(),this.workingCanvas=document.createElement("canvas"),this.workingContext2D=this.workingCanvas.getContext("2d"),this.captureCanvas=document.createElement("canvas"),this.captureContext2D=this.captureCanvas.getContext("2d"),this._setSmoothing(!0)}appendTextureState(e,t,n=null,i){if(!t)return;const r=t.__SPECTOR_Object_CustomData;if(r&&(this.fullCapture=i,r.type&&(e.textureType=this.getWebGlConstant(r.type)),r.format&&(e.format=this.getWebGlConstant(r.format)),r.internalFormat&&(e.internalFormat=this.getWebGlConstant(r.internalFormat)),e.width=r.width,e.height=r.height,r.depth&&(e.depth=r.depth),n)){const i="NEAREST"===e.samplerMagFilter||"NEAREST"===e.magFilter;e.visual=this.getTextureVisualState(n,t,r,i)}}getTextureVisualState(e,t,n,i){try{const r=this.context,s={};if(!Ce.isSupportedCombination(n.type,n.format,n.internalFormat))return s;const o=this.context.getParameter(d.FRAMEBUFFER_BINDING.value);r.bindFramebuffer(d.FRAMEBUFFER.value,this.captureFrameBuffer);try{const o=0,a=n.width,l=n.height;if(e===d.TEXTURE_3D&&n.depth){const e=r;for(let c=0;c<n.depth;c++)c>2&&c<n.depth-3||(e.framebufferTextureLayer(d.FRAMEBUFFER.value,d.COLOR_ATTACHMENT0.value,t,o,c),s["3D Layer "+c]=this.getCapture(r,0,0,a,l,n.type,i))}else if(e===d.TEXTURE_2D_ARRAY&&n.depth){const e=r;for(let c=0;c<n.depth;c++)c>2&&c<n.depth-3||(e.framebufferTextureLayer(d.FRAMEBUFFER.value,d.COLOR_ATTACHMENT0.value,t,o,c),s["Layer "+c]=this.getCapture(r,0,0,a,l,n.type,i))}else if(e===d.TEXTURE_CUBE_MAP)for(const e of Re.cubeMapFaces)r.framebufferTexture2D(d.FRAMEBUFFER.value,d.COLOR_ATTACHMENT0.value,e.value,t,o),s[e.name]=this.getCapture(r,0,0,a,l,n.type,i);else r.framebufferTexture2D(d.FRAMEBUFFER.value,d.COLOR_ATTACHMENT0.value,d.TEXTURE_2D.value,t,o),s[d.TEXTURE_2D.name]=this.getCapture(r,0,0,a,l,n.type,i)}catch(e){}return r.bindFramebuffer(d.FRAMEBUFFER.value,o),s}catch(e){}}getCapture(e,t,n,i,r,s,o){try{if(this.context.checkFramebufferStatus(d.FRAMEBUFFER.value)!==d.FRAMEBUFFER_COMPLETE.value)return;s=s||d.UNSIGNED_BYTE.value;const a=Ce.readPixels(e,t,n,i,r,s);if(!a)return;this.workingCanvas.width=i,this.workingCanvas.height=r;const l=this.workingContext2D.createImageData(i,r);if(l.data.set(a),this.workingContext2D.putImageData(l,0,0),this.fullCapture)this.captureCanvas.width=this.workingCanvas.width,this.captureCanvas.height=this.workingCanvas.height;else{const e=i/r;e<1?(this.captureCanvas.width=Ae.captureBaseSize*e,this.captureCanvas.height=Ae.captureBaseSize):e>1?(this.captureCanvas.width=Ae.captureBaseSize,this.captureCanvas.height=Ae.captureBaseSize/e):(this.captureCanvas.width=Ae.captureBaseSize,this.captureCanvas.height=Ae.captureBaseSize)}return this.captureCanvas.width=Math.max(this.captureCanvas.width,1),this.captureCanvas.height=Math.max(this.captureCanvas.height,1),this.captureContext2D.globalCompositeOperation="copy",this.captureContext2D.scale(1,-1),this.captureContext2D.translate(0,-this.captureCanvas.height),this._setSmoothing(!o),this.captureContext2D.drawImage(this.workingCanvas,0,0,i,r,0,0,this.captureCanvas.width,this.captureCanvas.height),this.captureContext2D.setTransform(1,0,0,1,0,0),this.captureContext2D.globalCompositeOperation="source-over",this.captureCanvas.toDataURL()}catch(e){}}getWebGlConstant(e){const t=p[e];return t?t.name:e+""}_setSmoothing(e){this.captureContext2D.imageSmoothingEnabled=e,this.captureContext2D.mozImageSmoothingEnabled=e,this.captureContext2D.oImageSmoothingEnabled=e,this.captureContext2D.webkitImageSmoothingEnabled=e,this.captureContext2D.msImageSmoothingEnabled=e}}Re.captureBaseSize=64,Re.cubeMapFaces=[d.TEXTURE_CUBE_MAP_POSITIVE_X,d.TEXTURE_CUBE_MAP_POSITIVE_Y,d.TEXTURE_CUBE_MAP_POSITIVE_Z,d.TEXTURE_CUBE_MAP_NEGATIVE_X,d.TEXTURE_CUBE_MAP_NEGATIVE_Y,d.TEXTURE_CUBE_MAP_NEGATIVE_Z];class Se{constructor(e){this.context=e.context}getUboValue(e,t,n,i){const r=Se.uboTypes[i];if(!r)return;const s=new r.arrayBufferView(n*r.lengthMultiplier),o=this.context,a=o.getIndexedParameter(d.UNIFORM_BUFFER_BINDING.value,e);if(a){const n=o.getIndexedParameter(d.UNIFORM_BUFFER_START.value,e),i=o.getParameter(d.UNIFORM_BUFFER_BINDING.value);try{o.bindBuffer(d.UNIFORM_BUFFER.value,a),o.getBufferSubData(d.UNIFORM_BUFFER.value,n+t,s)}catch(e){return}i&&o.bindBuffer(d.UNIFORM_BUFFER.value,i)}return Array.prototype.slice.call(s)}}Se.uboTypes={[d.BOOL.value]:{arrayBufferView:Uint8Array,lengthMultiplier:1},[d.BOOL_VEC2.value]:{arrayBufferView:Uint8Array,lengthMultiplier:2},[d.BOOL_VEC3.value]:{arrayBufferView:Uint8Array,lengthMultiplier:3},[d.BOOL_VEC4.value]:{arrayBufferView:Uint8Array,lengthMultiplier:4},[d.INT.value]:{arrayBufferView:Int32Array,lengthMultiplier:1},[d.INT_VEC2.value]:{arrayBufferView:Int32Array,lengthMultiplier:2},[d.INT_VEC3.value]:{arrayBufferView:Int32Array,lengthMultiplier:3},[d.INT_VEC4.value]:{arrayBufferView:Int32Array,lengthMultiplier:4},[d.UNSIGNED_INT.value]:{arrayBufferView:Uint32Array,lengthMultiplier:1},[d.UNSIGNED_INT_VEC2.value]:{arrayBufferView:Uint32Array,lengthMultiplier:2},[d.UNSIGNED_INT_VEC3.value]:{arrayBufferView:Uint32Array,lengthMultiplier:3},[d.UNSIGNED_INT_VEC4.value]:{arrayBufferView:Uint32Array,lengthMultiplier:4},[d.FLOAT.value]:{arrayBufferView:Float32Array,lengthMultiplier:1},[d.FLOAT_VEC2.value]:{arrayBufferView:Float32Array,lengthMultiplier:2},[d.FLOAT_VEC3.value]:{arrayBufferView:Float32Array,lengthMultiplier:3},[d.FLOAT_VEC4.value]:{arrayBufferView:Float32Array,lengthMultiplier:4},[d.FLOAT_MAT2.value]:{arrayBufferView:Float32Array,lengthMultiplier:4},[d.FLOAT_MAT2x3.value]:{arrayBufferView:Float32Array,lengthMultiplier:6},[d.FLOAT_MAT2x4.value]:{arrayBufferView:Float32Array,lengthMultiplier:8},[d.FLOAT_MAT3.value]:{arrayBufferView:Float32Array,lengthMultiplier:9},[d.FLOAT_MAT3x2.value]:{arrayBufferView:Float32Array,lengthMultiplier:6},[d.FLOAT_MAT3x4.value]:{arrayBufferView:Float32Array,lengthMultiplier:12},[d.FLOAT_MAT4.value]:{arrayBufferView:Float32Array,lengthMultiplier:16},[d.FLOAT_MAT4x2.value]:{arrayBufferView:Float32Array,lengthMultiplier:8},[d.FLOAT_MAT4x3.value]:{arrayBufferView:Float32Array,lengthMultiplier:12},[d.SAMPLER_2D.value]:{arrayBufferView:Uint8Array,lengthMultiplier:1},[d.SAMPLER_CUBE.value]:{arrayBufferView:Uint8Array,lengthMultiplier:1}};class Te extends v{get typeName(){return"WebGLBuffer"}}class be extends v{get typeName(){return"WebGLFramebuffer"}}class we extends v{get typeName(){return"WebGLProgram"}static saveInGlobalStore(e){const t=E.getWebGlObjectTag(e);t&&(this.store[t.id]=e)}static getFromGlobalStore(e){return this.store[e]}static updateInGlobalStore(e,t){if(!t)return;const n=this.getFromGlobalStore(e);if(!n)return;const i=E.getWebGlObjectTag(n);i&&(E.attachWebGlObjectTag(t,i),this.store[i.id]=t)}}we.store={};class xe extends v{get typeName(){return"WebGLQuery"}}class ye extends v{get typeName(){return"WebGLRenderbuffer"}}class Le extends v{get typeName(){return"WebGLSampler"}}class Ie extends v{get typeName(){return"WebGLShader"}}class Fe extends v{get typeName(){return"WebGLSync"}}class Ne extends v{get typeName(){return"WebGLTexture"}}class Me extends v{get typeName(){return"WebGLTransformFeedback"}}class Oe extends v{get typeName(){return"WebGLUniformLocation"}}class Be extends v{get typeName(){return"WebGLVertexArrayObject"}}class $e{static getProgramData(e,t){const n={LINK_STATUS:e.getProgramParameter(t,d.LINK_STATUS.value),VALIDATE_STATUS:e.getProgramParameter(t,d.VALIDATE_STATUS.value)},i=e.getAttachedShaders(t),r=new Array(2);let s=0;for(const t of i){const n=this.readShaderFromContext(e,t);s+=n.source.length,n.shaderType===d.FRAGMENT_SHADER.name?r[1]=n:r[0]=n}return{programStatus:n,shaders:r,length:s}}static readShaderFromContext(e,t){const n=e.getShaderSource(t),i=e.getExtension("WEBGL_debug_shaders"),r=i?i.getTranslatedShaderSource(t):null,s=e.getShaderParameter(t,d.SHADER_TYPE.value)===d.FRAGMENT_SHADER.value;let o=t&&t.__SPECTOR_Metadata&&t.__SPECTOR_Metadata.name?t.__SPECTOR_Metadata.name:this.readNameFromShaderSource(n);return o||(o=s?"Fragment":"Vertex"),{COMPILE_STATUS:e.getShaderParameter(t,d.COMPILE_STATUS.value),shaderType:s?d.FRAGMENT_SHADER.name:d.VERTEX_SHADER.name,name:o,source:n,translatedSource:r}}static readNameFromShaderSource(e){try{let t,n="";const i=/#define[\s]+SHADER_NAME[\s]+([\S]+)(\n|$)/gi;if(t=i.exec(e),null!==t&&(t.index===i.lastIndex&&i.lastIndex++,n=t[1]),""===n){const i=/#define[\s]+SHADER_NAME_B64[\s]+([\S]+)(\n|$)/gi;t=i.exec(e),null!==t&&(t.index===i.lastIndex&&i.lastIndex++,n=t[1]),n&&(n=decodeURIComponent(atob(n)))}return n}catch(e){return null}}}class Pe extends oe{constructor(e){super(e),this.drawCallTextureInputState=new Re(e),this.drawCallUboInputState=new Se(e)}get stateName(){return Pe.stateName}get requireStartAndStopStates(){return!1}getConsumeCommands(){return u}getChangeCommandsByState(){return{}}readFromContext(){var e,t;const n=this.context.getParameter(d.CURRENT_PROGRAM.value);if(!n)return;this.currentState.frameBuffer=this.readFrameBufferFromContext();const r=n.__SPECTOR_Object_CustomData?n.__SPECTOR_Object_CustomData:$e.getProgramData(this.context,n);if(this.currentState.programStatus=Object.assign({},r.programStatus),this.currentState.programStatus.program=this.getSpectorData(n),this.currentState.programStatus.RECOMPILABLE=i.isBuildableProgram(n),this.currentState.programStatus.RECOMPILABLE&&we.saveInGlobalStore(n),this.currentState.shaders=r.shaders,(null===(e=this.lastCommandName)||void 0===e?void 0:e.indexOf("Elements"))>=0){const e=this.context.getParameter(this.context.ELEMENT_ARRAY_BUFFER_BINDING);e&&(this.currentState.elementArray={},this.currentState.elementArray.arrayBuffer=this.getSpectorData(e))}const s=this.context.getProgramParameter(n,d.ACTIVE_ATTRIBUTES.value);this.currentState.attributes=[];for(let e=0;e<s;e++){const t=this.readAttributeFromContext(n,e);this.currentState.attributes.push(t)}const o=this.context.getProgramParameter(n,d.ACTIVE_UNIFORMS.value);this.currentState.uniforms=[];const a=[];for(let e=0;e<o;e++){a.push(e);const t=this.readUniformFromContext(n,e);this.currentState.uniforms.push(t)}if(this.contextVersion>1){const e=this.context.getProgramParameter(n,d.ACTIVE_UNIFORM_BLOCKS.value);this.currentState.uniformBlocks=[];for(let t=0;t<e;t++){const e=this.readUniformBlockFromContext(n,t);this.currentState.uniformBlocks.push(e)}if(this.readUniformsFromContextIntoState(n,a,this.currentState.uniforms,this.currentState.uniformBlocks),this.context.getParameter(d.TRANSFORM_FEEDBACK_ACTIVE.value)){const e=this.context.getProgramParameter(n,d.TRANSFORM_FEEDBACK_BUFFER_MODE.value);this.currentState.transformFeedbackMode=this.getWebGlConstant(e),this.currentState.transformFeedbacks=[];const t=this.context.getProgramParameter(n,d.TRANSFORM_FEEDBACK_VARYINGS.value);for(let e=0;e<t;e++){const t=this.readTransformFeedbackFromContext(n,e);this.currentState.transformFeedbacks.push(t)}}}for(let e=0;e<a.length;e++){const n=this.currentState.uniforms[e],i=null!==(t=n.value)&&void 0!==t?t:n.values;if(null!=i){const e=Pe.samplerTypes[n.typeValue];if(e)if(i.length){n.textures=[];for(let t=0;t<i.length;t++)n.textures.push(this.readTextureFromContext(i[t].value,e))}else n.texture=this.readTextureFromContext(i,e)}delete n.typeValue}}readFrameBufferFromContext(){const e=this.context.getParameter(d.FRAMEBUFFER_BINDING.value);if(!e)return null;const t={};if(t.frameBuffer=this.getSpectorData(e),this.readFrameBufferAttachmentFromContext(d.DEPTH_ATTACHMENT.value)&&(t.depthAttachment=this.readFrameBufferAttachmentFromContext(d.DEPTH_ATTACHMENT.value)),this.readFrameBufferAttachmentFromContext(d.STENCIL_ATTACHMENT.value)&&(t.stencilAttachment=this.readFrameBufferAttachmentFromContext(d.STENCIL_ATTACHMENT.value)),this.extensions[d.MAX_DRAW_BUFFERS_WEBGL.extensionName]){t.colorAttachments=[];const e=this.context.getParameter(d.MAX_DRAW_BUFFERS_WEBGL.value);for(let n=0;n<e;n++){const e=this.readFrameBufferAttachmentFromContext(m["COLOR_ATTACHMENT"+n+"_WEBGL"].value);e&&t.colorAttachments.push(e)}}else if(this.contextVersion>1){const e=this.context;t.colorAttachments=[];const n=e.getParameter(d.MAX_DRAW_BUFFERS.value);for(let e=0;e<n;e++){const n=this.readFrameBufferAttachmentFromContext(m["COLOR_ATTACHMENT"+e].value);n&&t.colorAttachments.push(n)}}else{const e=this.readFrameBufferAttachmentFromContext(m.COLOR_ATTACHMENT0.value);e&&(t.colorAttachments=[e])}return t}readFrameBufferAttachmentFromContext(e){const t=d.FRAMEBUFFER.value,n=this.context.getFramebufferAttachmentParameter(t,e,d.FRAMEBUFFER_ATTACHMENT_OBJECT_TYPE.value);if(n===d.NONE.value)return;const i={},r=this.context.getFramebufferAttachmentParameter(t,e,d.FRAMEBUFFER_ATTACHMENT_OBJECT_NAME.value);if(n===d.RENDERBUFFER.value){if(i.type="RENDERBUFFER",i.buffer=this.getSpectorData(r),r){const e=r.__SPECTOR_Object_CustomData;e&&(e.internalFormat&&(i.internalFormat=this.getWebGlConstant(e.internalFormat)),i.width=e.width,i.height=e.height,i.msaaSamples=e.samples)}}else if(n===d.TEXTURE.value){i.type="TEXTURE",i.texture=this.getSpectorData(r),i.textureLevel=this.context.getFramebufferAttachmentParameter(t,e,d.FRAMEBUFFER_ATTACHMENT_TEXTURE_LEVEL.value);const n=this.context.getFramebufferAttachmentParameter(t,e,d.FRAMEBUFFER_ATTACHMENT_TEXTURE_CUBE_MAP_FACE.value);i.textureCubeMapFace=this.getWebGlConstant(n),this.drawCallTextureInputState.appendTextureState(i,r,null,this.fullCapture)}return this.extensions.EXT_sRGB&&(i.encoding=this.getWebGlConstant(this.context.getFramebufferAttachmentParameter(t,e,d.FRAMEBUFFER_ATTACHMENT_COLOR_ENCODING_EXT.value))),this.contextVersion>1&&(i.alphaSize=this.context.getFramebufferAttachmentParameter(t,e,d.FRAMEBUFFER_ATTACHMENT_ALPHA_SIZE.value),i.blueSize=this.context.getFramebufferAttachmentParameter(t,e,d.FRAMEBUFFER_ATTACHMENT_BLUE_SIZE.value),i.encoding=this.getWebGlConstant(this.context.getFramebufferAttachmentParameter(t,e,d.FRAMEBUFFER_ATTACHMENT_COLOR_ENCODING.value)),i.componentType=this.getWebGlConstant(this.context.getFramebufferAttachmentParameter(t,e,d.FRAMEBUFFER_ATTACHMENT_COMPONENT_TYPE.value)),i.depthSize=this.context.getFramebufferAttachmentParameter(t,e,d.FRAMEBUFFER_ATTACHMENT_DEPTH_SIZE.value),i.greenSize=this.context.getFramebufferAttachmentParameter(t,e,d.FRAMEBUFFER_ATTACHMENT_GREEN_SIZE.value),i.redSize=this.context.getFramebufferAttachmentParameter(t,e,d.FRAMEBUFFER_ATTACHMENT_RED_SIZE.value),i.stencilSize=this.context.getFramebufferAttachmentParameter(t,e,d.FRAMEBUFFER_ATTACHMENT_STENCIL_SIZE.value),n===d.TEXTURE.value&&(i.textureLayer=this.context.getFramebufferAttachmentParameter(t,e,d.FRAMEBUFFER_ATTACHMENT_TEXTURE_LAYER.value))),i}readAttributeFromContext(e,t){const n=this.context.getActiveAttrib(e,t),i=this.context.getAttribLocation(e,n.name);if(-1===i)return{name:n.name,size:n.size,type:this.getWebGlConstant(n.type),location:-1};const r=this.context.getVertexAttrib(i,d.CURRENT_VERTEX_ATTRIB.value),s=this.context.getVertexAttrib(i,d.VERTEX_ATTRIB_ARRAY_BUFFER_BINDING.value),o={name:n.name,size:n.size,type:this.getWebGlConstant(n.type),location:i,offsetPointer:this.context.getVertexAttribOffset(i,d.VERTEX_ATTRIB_ARRAY_POINTER.value),bufferBinding:this.getSpectorData(s),enabled:this.context.getVertexAttrib(i,d.VERTEX_ATTRIB_ARRAY_ENABLED.value),arraySize:this.context.getVertexAttrib(i,d.VERTEX_ATTRIB_ARRAY_SIZE.value),stride:this.context.getVertexAttrib(i,d.VERTEX_ATTRIB_ARRAY_STRIDE.value),arrayType:this.getWebGlConstant(this.context.getVertexAttrib(i,d.VERTEX_ATTRIB_ARRAY_TYPE.value)),normalized:this.context.getVertexAttrib(i,d.VERTEX_ATTRIB_ARRAY_NORMALIZED.value),vertexAttrib:Array.prototype.slice.call(r)};return this.extensions[d.VERTEX_ATTRIB_ARRAY_DIVISOR_ANGLE.extensionName]?o.divisor=this.context.getVertexAttrib(i,d.VERTEX_ATTRIB_ARRAY_DIVISOR_ANGLE.value):this.contextVersion>1&&(o.integer=this.context.getVertexAttrib(i,d.VERTEX_ATTRIB_ARRAY_INTEGER.value),o.divisor=this.context.getVertexAttrib(i,d.VERTEX_ATTRIB_ARRAY_DIVISOR.value)),this.appendBufferCustomData(o,s),o}readUniformFromContext(e,t){const n=this.context.getActiveUniform(e,t),i=this.context.getUniformLocation(e,n.name);if(i){if(n.size>1&&n.name&&n.name.indexOf("[0]")===n.name.length-3){const t=[];for(let i=0;i<n.size;i++){const r=this.context.getUniformLocation(e,n.name.replace("[0]","["+i+"]"));if(r){let n=this.context.getUniform(e,r);n.length&&(n=Array.prototype.slice.call(n)),t.push({value:n})}}return{name:n.name.replace("[0]",""),size:n.size,type:this.getWebGlConstant(n.type),typeValue:n.type,location:this.getSpectorData(i),values:t}}{let t=this.context.getUniform(e,i);return t.length&&(t=Array.prototype.slice.call(t)),{name:n.name,size:n.size,type:this.getWebGlConstant(n.type),typeValue:n.type,location:this.getSpectorData(i),value:t}}}return{name:n.name,size:n.size,type:this.getWebGlConstant(n.type),typeValue:n.type}}readTextureFromContext(e,t){const n=this.context.getParameter(d.ACTIVE_TEXTURE.value);this.context.activeTexture(d.TEXTURE0.value+e);const i={magFilter:this.getWebGlConstant(this.context.getTexParameter(t.value,d.TEXTURE_MAG_FILTER.value)),minFilter:this.getWebGlConstant(this.context.getTexParameter(t.value,d.TEXTURE_MIN_FILTER.value)),wrapS:this.getWebGlConstant(this.context.getTexParameter(t.value,d.TEXTURE_WRAP_S.value)),wrapT:this.getWebGlConstant(this.context.getTexParameter(t.value,d.TEXTURE_WRAP_T.value))};if(this.extensions[d.TEXTURE_MAX_ANISOTROPY_EXT.extensionName]&&(i.anisotropy=this.context.getTexParameter(t.value,d.TEXTURE_MAX_ANISOTROPY_EXT.value)),this.contextVersion>1){i.baseLevel=this.context.getTexParameter(t.value,d.TEXTURE_BASE_LEVEL.value),i.immutable=this.context.getTexParameter(t.value,d.TEXTURE_IMMUTABLE_FORMAT.value),i.immutableLevels=this.context.getTexParameter(t.value,d.TEXTURE_IMMUTABLE_LEVELS.value),i.maxLevel=this.context.getTexParameter(t.value,d.TEXTURE_MAX_LEVEL.value);const e=this.context.getParameter(d.SAMPLER_BINDING.value);if(e){i.sampler=this.getSpectorData(e);const t=this.context;i.samplerMaxLod=t.getSamplerParameter(e,d.TEXTURE_MAX_LOD.value),i.samplerMinLod=t.getSamplerParameter(e,d.TEXTURE_MIN_LOD.value),i.samplerCompareFunc=this.getWebGlConstant(t.getSamplerParameter(e,d.TEXTURE_COMPARE_FUNC.value)),i.samplerCompareMode=this.getWebGlConstant(t.getSamplerParameter(e,d.TEXTURE_COMPARE_MODE.value)),i.samplerWrapS=this.getWebGlConstant(t.getSamplerParameter(e,d.TEXTURE_WRAP_S.value)),i.samplerWrapT=this.getWebGlConstant(t.getSamplerParameter(e,d.TEXTURE_WRAP_T.value)),i.samplerWrapR=this.getWebGlConstant(t.getSamplerParameter(e,d.TEXTURE_WRAP_R.value)),i.samplerMagFilter=this.getWebGlConstant(t.getSamplerParameter(e,d.TEXTURE_MAG_FILTER.value)),i.samplerMinFilter=this.getWebGlConstant(t.getSamplerParameter(e,d.TEXTURE_MIN_FILTER.value))}else i.maxLod=this.context.getTexParameter(t.value,d.TEXTURE_MAX_LOD.value),i.minLod=this.context.getTexParameter(t.value,d.TEXTURE_MIN_LOD.value),i.compareFunc=this.getWebGlConstant(this.context.getTexParameter(t.value,d.TEXTURE_COMPARE_FUNC.value)),i.compareMode=this.getWebGlConstant(this.context.getTexParameter(t.value,d.TEXTURE_COMPARE_MODE.value)),i.wrapR=this.getWebGlConstant(this.context.getTexParameter(t.value,d.TEXTURE_WRAP_R.value))}const r=this.getTextureStorage(t);if(r){const e=this.quickCapture?null:t;this.drawCallTextureInputState.appendTextureState(i,r,e,this.fullCapture)}return this.context.activeTexture(n),i}getTextureStorage(e){return e===d.TEXTURE_2D?this.context.getParameter(d.TEXTURE_BINDING_2D.value):e===d.TEXTURE_CUBE_MAP?this.context.getParameter(d.TEXTURE_BINDING_CUBE_MAP.value):e===d.TEXTURE_3D?this.context.getParameter(d.TEXTURE_BINDING_3D.value):e===d.TEXTURE_2D_ARRAY?this.context.getParameter(d.TEXTURE_BINDING_2D_ARRAY.value):void 0}readUniformsFromContextIntoState(e,t,n,i){const r=this.context,s=r.getActiveUniforms(e,t,d.UNIFORM_TYPE.value),o=r.getActiveUniforms(e,t,d.UNIFORM_SIZE.value),a=r.getActiveUniforms(e,t,d.UNIFORM_BLOCK_INDEX.value),l=r.getActiveUniforms(e,t,d.UNIFORM_OFFSET.value),c=r.getActiveUniforms(e,t,d.UNIFORM_ARRAY_STRIDE.value),u=r.getActiveUniforms(e,t,d.UNIFORM_MATRIX_STRIDE.value),h=r.getActiveUniforms(e,t,d.UNIFORM_IS_ROW_MAJOR.value);for(let d=0;d<t.length;d++){const t=n[d];if(t.type=this.getWebGlConstant(s[d]),t.size=o[d],t.blockIndice=a[d],t.blockIndice>-1&&(t.blockName=r.getActiveUniformBlockName(e,t.blockIndice)),t.offset=l[d],t.arrayStride=c[d],t.matrixStride=u[d],t.rowMajor=h[d],t.blockIndice>-1){const e=i[a[d]].bindingPoint;t.value=this.drawCallUboInputState.getUboValue(e,t.offset,t.size,s[d])}}}readTransformFeedbackFromContext(e,t){const n=this.context,i=n.getTransformFeedbackVarying(e,t),r=n.getIndexedParameter(d.TRANSFORM_FEEDBACK_BUFFER_BINDING.value,t),s={name:i.name,size:i.size,type:this.getWebGlConstant(i.type),buffer:this.getSpectorData(r),bufferSize:n.getIndexedParameter(d.TRANSFORM_FEEDBACK_BUFFER_SIZE.value,t),bufferStart:n.getIndexedParameter(d.TRANSFORM_FEEDBACK_BUFFER_START.value,t)};return this.appendBufferCustomData(s,r),s}readUniformBlockFromContext(e,t){const n=this.context,i=n.getActiveUniformBlockParameter(e,t,d.UNIFORM_BLOCK_BINDING.value),r=n.getIndexedParameter(d.UNIFORM_BUFFER_BINDING.value,i),s={name:n.getActiveUniformBlockName(e,t),bindingPoint:i,size:n.getActiveUniformBlockParameter(e,t,d.UNIFORM_BLOCK_DATA_SIZE.value),activeUniformCount:n.getActiveUniformBlockParameter(e,t,d.UNIFORM_BLOCK_ACTIVE_UNIFORMS.value),vertex:n.getActiveUniformBlockParameter(e,t,d.UNIFORM_BLOCK_REFERENCED_BY_VERTEX_SHADER.value),fragment:n.getActiveUniformBlockParameter(e,t,d.UNIFORM_BLOCK_REFERENCED_BY_FRAGMENT_SHADER.value),buffer:this.getSpectorData(r)};return this.appendBufferCustomData(s,r),s}appendBufferCustomData(e,t){if(t){const n=t.__SPECTOR_Object_CustomData;n&&(n.usage&&(e.bufferUsage=this.getWebGlConstant(n.usage)),e.bufferLength=n.length,n.offset&&(e.bufferOffset=n.offset),n.sourceLength&&(e.bufferSourceLength=n.sourceLength))}}getWebGlConstant(e){const t=p[e];return t?t.name:e}}Pe.stateName="DrawCall",Pe.samplerTypes={[d.SAMPLER_2D.value]:d.TEXTURE_2D,[d.SAMPLER_CUBE.value]:d.TEXTURE_CUBE_MAP,[d.SAMPLER_3D.value]:d.TEXTURE_3D,[d.SAMPLER_2D_SHADOW.value]:d.TEXTURE_2D,[d.SAMPLER_2D_ARRAY.value]:d.TEXTURE_2D_ARRAY,[d.SAMPLER_2D_ARRAY_SHADOW.value]:d.TEXTURE_2D_ARRAY,[d.SAMPLER_CUBE_SHADOW.value]:d.TEXTURE_CUBE_MAP,[d.INT_SAMPLER_2D.value]:d.TEXTURE_2D,[d.INT_SAMPLER_3D.value]:d.TEXTURE_3D,[d.INT_SAMPLER_CUBE.value]:d.TEXTURE_CUBE_MAP,[d.INT_SAMPLER_2D_ARRAY.value]:d.TEXTURE_2D_ARRAY,[d.UNSIGNED_INT_SAMPLER_2D.value]:d.TEXTURE_2D,[d.UNSIGNED_INT_SAMPLER_3D.value]:d.TEXTURE_3D,[d.UNSIGNED_INT_SAMPLER_CUBE.value]:d.TEXTURE_CUBE_MAP,[d.UNSIGNED_INT_SAMPLER_2D_ARRAY.value]:d.TEXTURE_2D_ARRAY};class ke{constructor(e){this.contextInformation=e,this.stateTrackers=[],this.onCommandCapturedCallbacks={},this.initStateTrackers()}startCapture(e,t,n){for(const i of this.stateTrackers){const r=i.startCapture(!0,t,n);i.requireStartAndStopStates&&(e.initState[i.stateName]=r)}}stopCapture(e){for(const t of this.stateTrackers){const n=t.stopCapture();t.requireStartAndStopStates&&(e.endState[t.stateName]=n)}}captureState(e){const t=this.onCommandCapturedCallbacks[e.name];if(t)for(const n of t)n(e)}initStateTrackers(){this.stateTrackers.push(new le(this.contextInformation),new ce(this.contextInformation),new ue(this.contextInformation),new he(this.contextInformation),new de(this.contextInformation),new me(this.contextInformation),new pe(this.contextInformation),new ge(this.contextInformation),new fe(this.contextInformation),new Ee(this.contextInformation),new ve(this.contextInformation),new _e(this.contextInformation),new Ae(this.contextInformation),new Pe(this.contextInformation));for(const e of this.stateTrackers)e.registerCallbacks(this.onCommandCapturedCallbacks)}}class De{constructor(e){this.options=e,this.createCommandNames=this.getCreateCommandNames(),this.updateCommandNames=this.getUpdateCommandNames(),this.deleteCommandNames=this.getDeleteCommandNames(),this.startTime=a.now,this.memoryPerSecond={},this.totalMemory=0,this.frameMemory=0,this.capturing=!1,De.initializeByteSizeFormat()}static initializeByteSizeFormat(){this.byteSizePerInternalFormat||(this.byteSizePerInternalFormat={[d.R8.value]:1,[d.R16F.value]:2,[d.R32F.value]:4,[d.R8UI.value]:1,[d.RG8.value]:2,[d.RG16F.value]:4,[d.RG32F.value]:8,[d.ALPHA.value]:1,[d.RGB.value]:3,[d.RGBA.value]:4,[d.LUMINANCE.value]:1,[d.LUMINANCE_ALPHA.value]:2,[d.DEPTH_COMPONENT.value]:1,[d.DEPTH_STENCIL.value]:2,[d.SRGB_EXT.value]:3,[d.SRGB_ALPHA_EXT.value]:4,[d.RGB8.value]:3,[d.SRGB8.value]:3,[d.RGB565.value]:2,[d.R11F_G11F_B10F.value]:4,[d.RGB9_E5.value]:2,[d.RGB16F.value]:6,[d.RGB32F.value]:12,[d.RGB8UI.value]:3,[d.RGBA8.value]:4,[d.RGB5_A1.value]:2,[d.RGBA16F.value]:8,[d.RGBA32F.value]:16,[d.RGBA8UI.value]:4,[d.COMPRESSED_R11_EAC.value]:4,[d.COMPRESSED_SIGNED_R11_EAC.value]:4,[d.COMPRESSED_RG11_EAC.value]:4,[d.COMPRESSED_SIGNED_RG11_EAC.value]:4,[d.COMPRESSED_RGB8_ETC2.value]:4,[d.COMPRESSED_RGBA8_ETC2_EAC.value]:4,[d.COMPRESSED_SRGB8_ETC2.value]:4,[d.COMPRESSED_SRGB8_ALPHA8_ETC2_EAC.value]:4,[d.COMPRESSED_RGB8_PUNCHTHROUGH_ALPHA1_ETC2.value]:4,[d.COMPRESSED_SRGB8_PUNCHTHROUGH_ALPHA1_ETC2.value]:4,[d.COMPRESSED_RGB_S3TC_DXT1_EXT.value]:.5,[d.COMPRESSED_RGBA_S3TC_DXT3_EXT.value]:1,[d.COMPRESSED_RGBA_S3TC_DXT5_EXT.value]:1,[d.COMPRESSED_RGB_PVRTC_4BPPV1_IMG.value]:.5,[d.COMPRESSED_RGBA_PVRTC_4BPPV1_IMG.value]:.5,[d.COMPRESSED_RGB_PVRTC_2BPPV1_IMG.value]:.25,[d.COMPRESSED_RGBA_PVRTC_2BPPV1_IMG.value]:.25,[d.COMPRESSED_RGB_ETC1_WEBGL.value]:.5,[d.COMPRESSED_RGB_ATC_WEBGL.value]:.5,[d.COMPRESSED_RGBA_ATC_EXPLICIT_ALPHA_WEBGL.value]:1,[d.COMPRESSED_RGBA_ATC_INTERPOLATED_ALPHA_WEBGL.value]:1})}registerCallbacks(e){for(const t of this.createCommandNames)e[t]=e[t]||[],e[t].push(this.createWithoutSideEffects.bind(this));for(const t of this.updateCommandNames)e[t]=e[t]||[],e[t].push(this.updateWithoutSideEffects.bind(this));for(const t of this.deleteCommandNames)e[t]=e[t]||[],e[t].push(this.deleteWithoutSideEffects.bind(this))}startCapture(){this.frameMemory=0,this.capturing=!0}stopCapture(){this.frameMemory=0,this.capturing=!1}appendRecordedInformation(e){e.frameMemory[this.objectName]=this.frameMemory,e.memory[this.objectName]=this.memoryPerSecond}create(e){}createWithoutSideEffects(e){this.options.toggleCapture(!1),this.create(e),this.options.toggleCapture(!0)}updateWithoutSideEffects(e){if(!e||0===e.arguments.length)return;this.options.toggleCapture(!1);const t=e.arguments[0],n=this.getBoundInstance(t);if(!n)return void this.options.toggleCapture(!0);if(!E.getWebGlObjectTag(n))return void this.options.toggleCapture(!0);const i=this.getWebGlConstant(t),r=this.update(e,i,n);this.changeMemorySize(r),this.options.toggleCapture(!0)}deleteWithoutSideEffects(e){if(!e||!e.arguments||e.arguments.length<1)return;const t=e.arguments[0];if(!t)return;this.options.toggleCapture(!1);const n=this.delete(t);this.changeMemorySize(-n),this.options.toggleCapture(!0)}changeMemorySize(e){this.totalMemory+=e,this.capturing&&(this.frameMemory+=e);const t=a.now-this.startTime,n=Math.round(t/1e3);this.memoryPerSecond[n]=this.totalMemory}getWebGlConstant(e){const t=p[e];return t?t.name:e+""}getByteSizeForInternalFormat(e){return De.byteSizePerInternalFormat[e]||4}}class Ue extends De{get objectName(){return"Buffer"}getCreateCommandNames(){return["createBuffer"]}getUpdateCommandNames(){return["bufferData"]}getDeleteCommandNames(){return["deleteBuffer"]}getBoundInstance(e){const t=this.options.context;return e===d.ARRAY_BUFFER.value?t.getParameter(d.ARRAY_BUFFER_BINDING.value):e===d.ELEMENT_ARRAY_BUFFER.value?t.getParameter(d.ELEMENT_ARRAY_BUFFER_BINDING.value):e===d.COPY_READ_BUFFER.value?t.getParameter(d.COPY_READ_BUFFER_BINDING.value):e===d.COPY_WRITE_BUFFER.value?t.getParameter(d.COPY_WRITE_BUFFER_BINDING.value):e===d.TRANSFORM_FEEDBACK_BUFFER.value?t.getParameter(d.TRANSFORM_FEEDBACK_BUFFER_BINDING.value):e===d.UNIFORM_BUFFER.value?t.getParameter(d.UNIFORM_BUFFER_BINDING.value):e===d.PIXEL_PACK_BUFFER.value?t.getParameter(d.PIXEL_PACK_BUFFER_BINDING.value):e===d.PIXEL_UNPACK_BUFFER.value?t.getParameter(d.PIXEL_UNPACK_BUFFER_BINDING.value):void 0}delete(e){const t=e.__SPECTOR_Object_CustomData;return t?t.length:0}update(e,t,n){const i=this.getCustomData(t,e);if(!i)return 0;const r=n.__SPECTOR_Object_CustomData?n.__SPECTOR_Object_CustomData.length:0;return n.__SPECTOR_Object_CustomData=i,i.length-r}getCustomData(e,t){const n=this.getLength(t);return t.arguments.length>=4?{target:e,length:n,usage:t.arguments[2],offset:t.arguments[3],sourceLength:t.arguments[1]?t.arguments[1].length:-1}:3===t.arguments.length?{target:e,length:n,usage:t.arguments[2]}:void 0}getLength(e){let t=-1,n=0;return 5===e.arguments.length&&(t=e.arguments[4],n=e.arguments[3]),t<=0&&(t="number"==typeof e.arguments[1]?e.arguments[1]:e.arguments[1]&&(e.arguments[1].byteLength||e.arguments[1].length)||0),t-n}}class Ge extends De{get objectName(){return"Renderbuffer"}getCreateCommandNames(){return["createRenderbuffer"]}getUpdateCommandNames(){return["renderbufferStorage","renderbufferStorageMultisample"]}getDeleteCommandNames(){return["deleteRenderbuffer"]}getBoundInstance(e){const t=this.options.context;if(e===d.RENDERBUFFER.value)return t.getParameter(d.RENDERBUFFER_BINDING.value)}delete(e){const t=e.__SPECTOR_Object_CustomData;return t?t.length:0}update(e,t,n){const i=this.getCustomData(e,t);if(!i)return 0;const r=n.__SPECTOR_Object_CustomData?n.__SPECTOR_Object_CustomData.length:0;return i.length=i.width*i.height*this.getByteSizeForInternalFormat(i.internalFormat),n.__SPECTOR_Object_CustomData=i,i.length-r}getCustomData(e,t){return 4===e.arguments.length?{target:t,internalFormat:e.arguments[1],width:e.arguments[2],height:e.arguments[3],length:0,samples:0}:{target:t,internalFormat:e.arguments[2],width:e.arguments[3],height:e.arguments[4],length:0,samples:e.arguments[1]}}}class We extends De{get objectName(){return"Texture2d"}getCreateCommandNames(){return["createTexture"]}getUpdateCommandNames(){return["texImage2D","compressedTexImage2D","texStorage2D"]}getDeleteCommandNames(){return["deleteTexture"]}getBoundInstance(e){const t=this.options.context;return e===d.TEXTURE_2D.value?t.getParameter(d.TEXTURE_BINDING_2D.value):e===d.TEXTURE_CUBE_MAP_POSITIVE_X.value||e===d.TEXTURE_CUBE_MAP_POSITIVE_Y.value||e===d.TEXTURE_CUBE_MAP_POSITIVE_Z.value||e===d.TEXTURE_CUBE_MAP_NEGATIVE_X.value||e===d.TEXTURE_CUBE_MAP_NEGATIVE_Y.value||e===d.TEXTURE_CUBE_MAP_NEGATIVE_Z.value?t.getParameter(d.TEXTURE_BINDING_CUBE_MAP.value):void 0}delete(e){const t=e.__SPECTOR_Object_CustomData;return t?t.target===d.TEXTURE_2D_ARRAY.name||t.target===d.TEXTURE_3D.name?0:t.length:0}update(e,t,n){const i=this.getCustomData(e,t,n);if(!i)return 0;const r=n.__SPECTOR_Object_CustomData?n.__SPECTOR_Object_CustomData.length:0;if(i.isCompressed){if(e.arguments.length>=7){const t=e.arguments[6];i.length="number"==typeof t?t:null==t?void 0:t.byteLength}}else{const e="TEXTURE_2D"===t?1:6;let n=i.internalFormat;n===d.RGBA.value&&(i.type===d.FLOAT.value&&(n=d.RGBA32F.value),i.type===d.HALF_FLOAT_OES.value&&(n=d.RGBA16F.value)),i.length=i.width*i.height*e*this.getByteSizeForInternalFormat(n)}return i.length=0|i.length,n.__SPECTOR_Object_CustomData=i,i.length-r}getCustomData(e,t,n){return"texImage2D"===e.name?this.getTexImage2DCustomData(e,t,n):"compressedTexImage2D"===e.name?this.getCompressedTexImage2DCustomData(e,t,n):"texStorage2D"===e.name?this.getTexStorage2DCustomData(e,t,n):void 0}getTexStorage2DCustomData(e,t,n){let i;return 5===e.arguments.length&&(i={target:t,internalFormat:e.arguments[2],width:e.arguments[3],height:e.arguments[4],length:0,isCompressed:!1}),i}getCompressedTexImage2DCustomData(e,t,n){if(0!==e.arguments[1])return;let i;return e.arguments.length>=7&&(i={target:t,internalFormat:e.arguments[2],width:e.arguments[3],height:e.arguments[4],length:0,isCompressed:!0}),i}getTexImage2DCustomData(e,t,n){if(0!==e.arguments[1])return;let i;return e.arguments.length>=8?i={target:t,internalFormat:e.arguments[2],width:e.arguments[3],height:e.arguments[4],format:e.arguments[6],type:e.arguments[7],length:0,isCompressed:!1}:6===e.arguments.length&&(i={target:t,internalFormat:e.arguments[2],width:e.arguments[5].width,height:e.arguments[5].height,format:e.arguments[3],type:e.arguments[4],length:0,isCompressed:!1}),i}}class Ve extends De{get objectName(){return"Texture3d"}getCreateCommandNames(){return["createTexture"]}getUpdateCommandNames(){return["texImage3D","compressedTexImage3D","texStorage3D"]}getDeleteCommandNames(){return["deleteTexture"]}getBoundInstance(e){const t=this.options.context;return e===d.TEXTURE_2D_ARRAY.value?t.getParameter(d.TEXTURE_BINDING_2D_ARRAY.value):e===d.TEXTURE_3D.value?t.getParameter(d.TEXTURE_BINDING_3D.value):void 0}delete(e){const t=e.__SPECTOR_Object_CustomData;return t?t.target!==d.TEXTURE_2D_ARRAY.name&&t.target!==d.TEXTURE_3D.name?0:t.length:0}update(e,t,n){if(e.arguments.length>=2&&0!==e.arguments[1])return 0;const i=this.getCustomData(e,t,n);if(!i)return 0;const r=n.__SPECTOR_Object_CustomData?n.__SPECTOR_Object_CustomData.length:0;if(i.isCompressed){if(e.arguments.length>=7){const t=e.arguments[6];i.length="number"==typeof t?t:null==t?void 0:t.byteLength}}else i.length=i.width*i.height*i.depth*this.getByteSizeForInternalFormat(i.internalFormat);return i.length=0|i.length,n.__SPECTOR_Object_CustomData=i,i.length-r}getCustomData(e,t,n){return"texImage3D"===e.name?this.getTexImage3DCustomData(e,t,n):"compressedTexImage3D"===e.name?this.getCompressedTexImage3DCustomData(e,t,n):"texStorage3D"===e.name?this.getTexStorage3DCustomData(e,t,n):void 0}getTexStorage3DCustomData(e,t,n){let i;return 6===e.arguments.length&&(i={target:t,internalFormat:e.arguments[2],width:e.arguments[3],height:e.arguments[4],depth:e.arguments[5],length:0,isCompressed:!1}),i}getCompressedTexImage3DCustomData(e,t,n){if(0!==e.arguments[1])return;let i;return e.arguments.length>=8&&(i={target:t,internalFormat:e.arguments[2],width:e.arguments[3],height:e.arguments[4],depth:e.arguments[5],length:0,isCompressed:!0}),i}getTexImage3DCustomData(e,t,n){if(0!==e.arguments[1])return;let i;return e.arguments.length>=9&&(i={target:t,internalFormat:e.arguments[2],width:e.arguments[3],height:e.arguments[4],depth:e.arguments[5],format:e.arguments[7],type:e.arguments[8],length:0,isCompressed:!1}),i}}class He extends De{get objectName(){return"Program"}getCreateCommandNames(){return["createProgram"]}getUpdateCommandNames(){return["linkProgram"]}getDeleteCommandNames(){return["deleteProgram"]}getBoundInstance(e){return e}delete(e){const t=e.__SPECTOR_Object_CustomData;return t?t.length:0}update(e,t,n){if(e.arguments.length>=1&&!e.arguments[0])return 0;const i=this.getCustomData(n);if(!i)return 0;const r=n.__SPECTOR_Object_CustomData?n.__SPECTOR_Object_CustomData.length:0;return n.__SPECTOR_Object_CustomData=i,i.length-r}getCustomData(e){const t=this.options.context;return $e.getProgramData(t,e)}}class Xe{constructor(e){this.contextInformation=e,this.onCommandCallbacks={},this.recorders=[],this.initRecorders()}recordCommand(e){const t=this.onCommandCallbacks[e.name];if(t)for(const n of t)n(e)}startCapture(){for(const e of this.recorders)e.startCapture()}stopCapture(){for(const e of this.recorders)e.stopCapture()}appendRecordedInformation(e){for(const t of this.recorders)t.appendRecordedInformation(e)}initRecorders(){this.recorders.push(new Ue(this.contextInformation),new Ge(this.contextInformation),new We(this.contextInformation),new Ve(this.contextInformation),new He(this.contextInformation));for(const e of this.recorders)e.registerCallbacks(this.onCommandCallbacks)}}class ze{constructor(e){this.contextInformation=e,this.webGlObjects=[],this.initWebglObjects()}tagWebGlObjects(e){for(const t of this.webGlObjects){for(let n=0;n<e.arguments.length;n++){const i=e.arguments[n];if(t.tagWebGlObject(i))break}if(t.tagWebGlObject(e.result))break}}tagWebGlObject(e){for(const t of this.webGlObjects){const n=t.tagWebGlObject(e);if(n)return n}}initWebglObjects(){this.webGlObjects.push(new Te,new be,new we,new xe,new ye,new Le,new Fe,new Ne,new Me,new Oe,new Be,new Ie)}}class Ke extends oe{constructor(e){super(e),this.extensionDefinition=[[{name:"ANGLE_instanced_arrays",description:""},{name:"EXT_blend_minmax",description:""},{name:"EXT_color_buffer_float",description:""},{name:"EXT_color_buffer_half_float",description:""},{name:"EXT_disjoint_timer_query",description:""},{name:"EXT_frag_depth",description:""},{name:"EXT_sRGB",description:""},{name:"EXT_shader_texture_lod",description:""},{name:"EXT_texture_filter_anisotropic",description:""},{name:"OES_element_index_uint",description:""},{name:"OES_standard_derivatives",description:""},{name:"OES_texture_float",description:""},{name:"OES_texture_float_linear",description:""},{name:"OES_texture_half_float",description:""},{name:"OES_texture_half_float_linear",description:""},{name:"OES_vertex_array_object",description:""},{name:"WEBGL_color_buffer_float",description:""},{name:"WEBGL_compressed_texture_astc",description:""},{name:"WEBGL_compressed_texture_atc",description:""},{name:"WEBGL_compressed_texture_etc",description:""},{name:"WEBGL_compressed_texture_etc1",description:""},{name:"WEBGL_compressed_texture_pvrtc",description:""},{name:"WEBGL_compressed_texture_s3tc",description:""},{name:"WEBGL_depth_texture",description:""},{name:"WEBGL_draw_buffers",description:""}],[{name:"EXT_color_buffer_float",description:""},{name:"EXT_disjoint_timer_query",description:""},{name:"EXT_disjoint_timer_query_webgl2",description:""},{name:"EXT_texture_filter_anisotropic",description:""},{name:"OES_texture_float_linear",description:""},{name:"WEBGL_compressed_texture_astc",description:""},{name:"WEBGL_compressed_texture_atc",description:""},{name:"WEBGL_compressed_texture_etc",description:""},{name:"WEBGL_compressed_texture_etc1",description:""},{name:"WEBGL_compressed_texture_pvrtc",description:""},{name:"WEBGL_compressed_texture_s3tc",description:""},{name:"WEBGL_multi_draw",description:""},{name:"WEBGL_multi_draw_instanced_base_vertex_base_instance",description:""},{name:"WEBGL_draw_instanced_base_vertex_base_instance",description:""}]],this.currentState=this.startCapture(!0,this.quickCapture,this.fullCapture)}get stateName(){return"Extensions"}getExtensions(){return this.extensions}readFromContext(){const e=1===this.contextVersion?this.extensionDefinition[0]:this.extensionDefinition[1];for(const t of e){const e=this.context.getExtension(t.name);e?(this.currentState[t.name]=!0,this.extensions[t.name]=e):this.currentState[t.name]=!1}}}class je extends ae{get stateName(){return"CompressedTextures"}constructor(e){super(e),this.currentState=this.startCapture(!0,this.quickCapture,this.fullCapture)}getWebgl1Parameters(){return[{constant:d.COMPRESSED_TEXTURE_FORMATS}]}stringifyParameterValue(e,t){const n=[];for(const t of e)n.push(d.stringifyWebGlConstant(t,"getParameter"));return n}}class Ye extends ae{get stateName(){return"Capabilities"}constructor(e){super(e),this.currentState=this.startCapture(!0,this.quickCapture,this.fullCapture)}getWebgl1Parameters(){return[{constant:d.RENDERER},{constant:d.VENDOR},{constant:d.VERSION},{constant:d.SHADING_LANGUAGE_VERSION},{constant:d.SAMPLES},{constant:d.SAMPLE_BUFFERS},{constant:d.RED_BITS},{constant:d.GREEN_BITS},{constant:d.BLUE_BITS},{constant:d.ALPHA_BITS},{constant:d.DEPTH_BITS},{constant:d.STENCIL_BITS},{constant:d.SUBPIXEL_BITS},{constant:d.LINE_WIDTH},{constant:d.ALIASED_LINE_WIDTH_RANGE},{constant:d.ALIASED_POINT_SIZE_RANGE},{constant:d.IMPLEMENTATION_COLOR_READ_FORMAT,returnType:20},{constant:d.IMPLEMENTATION_COLOR_READ_TYPE,returnType:20},{constant:d.MAX_COMBINED_TEXTURE_IMAGE_UNITS},{constant:d.MAX_CUBE_MAP_TEXTURE_SIZE},{constant:d.MAX_FRAGMENT_UNIFORM_VECTORS},{constant:d.MAX_RENDERBUFFER_SIZE},{constant:d.MAX_TEXTURE_IMAGE_UNITS},{constant:d.MAX_TEXTURE_SIZE},{constant:d.MAX_VARYING_VECTORS},{constant:d.MAX_VERTEX_ATTRIBS},{constant:d.MAX_VERTEX_TEXTURE_IMAGE_UNITS},{constant:d.MAX_VERTEX_UNIFORM_VECTORS},{constant:d.MAX_VIEWPORT_DIMS},{constant:d.MAX_TEXTURE_MAX_ANISOTROPY_EXT},{constant:d.MAX_COLOR_ATTACHMENTS_WEBGL},{constant:d.MAX_DRAW_BUFFERS_WEBGL}]}getWebgl2Parameters(){return[{constant:d.MAX_3D_TEXTURE_SIZE},{constant:d.MAX_ARRAY_TEXTURE_LAYERS},{constant:d.MAX_CLIENT_WAIT_TIMEOUT_WEBGL},{constant:d.MAX_COLOR_ATTACHMENTS},{constant:d.MAX_COMBINED_FRAGMENT_UNIFORM_COMPONENTS},{constant:d.MAX_COMBINED_UNIFORM_BLOCKS},{constant:d.MAX_COMBINED_VERTEX_UNIFORM_COMPONENTS},{constant:d.MAX_DRAW_BUFFERS},{constant:d.MAX_ELEMENT_INDEX},{constant:d.MAX_ELEMENTS_INDICES},{constant:d.MAX_ELEMENTS_VERTICES},{constant:d.MAX_FRAGMENT_INPUT_COMPONENTS},{constant:d.MAX_FRAGMENT_UNIFORM_BLOCKS},{constant:d.MAX_FRAGMENT_UNIFORM_COMPONENTS},{constant:d.MAX_PROGRAM_TEXEL_OFFSET},{constant:d.MAX_SAMPLES},{constant:d.MAX_SERVER_WAIT_TIMEOUT},{constant:d.MAX_TEXTURE_LOD_BIAS},{constant:d.MAX_TRANSFORM_FEEDBACK_INTERLEAVED_COMPONENTS},{constant:d.MAX_TRANSFORM_FEEDBACK_SEPARATE_ATTRIBS},{constant:d.MAX_TRANSFORM_FEEDBACK_SEPARATE_COMPONENTS},{constant:d.MAX_UNIFORM_BLOCK_SIZE},{constant:d.MAX_UNIFORM_BUFFER_BINDINGS},{constant:d.MAX_VARYING_COMPONENTS},{constant:d.MAX_VERTEX_OUTPUT_COMPONENTS},{constant:d.MAX_VERTEX_UNIFORM_BLOCKS},{constant:d.MAX_VERTEX_UNIFORM_COMPONENTS},{constant:d.MIN_PROGRAM_TEXEL_OFFSET}]}}class qe{constructor(e){this.options=e,this.commandId=0,this.context=e.context,this.version=e.version,this.onMaxCommand=new o,this.capturing=!1,this.globalCapturing=!0,this.contextInformation={context:this.context,contextVersion:this.version,toggleCapture:this.toggleGlobalCapturing.bind(this),tagWebGlObject:this.tagWebGlObject.bind(this),extensions:{}},this.commandSpies={},this.stateSpy=new ke(this.contextInformation),this.recorderSpy=new Xe(this.contextInformation),this.webGlObjectSpy=new ze(this.contextInformation),this.analyser=new f(this.contextInformation),this.initStaticCapture(),e.recordAlways&&this.spy()}spy(){this.spyContext(this.context);const{extensions:e}=this.contextInformation;for(const t in e)e.hasOwnProperty(t)&&this.spyContext(e[t])}unSpy(){for(const e in this.commandSpies)this.commandSpies.hasOwnProperty(e)&&this.commandSpies[e].unSpy()}startCapture(e=0,t=!1,n=!1){const i=a.now;this.maxCommands=e,this.options.recordAlways||this.spy(),this.capturing=!0,this.commandId=0,this.currentCapture={canvas:this.canvasCapture,context:this.contextCapture,commands:[],initState:{},endState:{},startTime:i,listenCommandsStartTime:0,listenCommandsEndTime:0,endTime:0,analyses:[],frameMemory:{},memory:{}},this.currentCapture.canvas.width=this.context.canvas.width,this.currentCapture.canvas.height=this.context.canvas.height,this.currentCapture.canvas.clientWidth=this.context.canvas.clientWidth||this.context.canvas.width,this.currentCapture.canvas.clientHeight=this.context.canvas.clientHeight||this.context.canvas.height,this.stateSpy.startCapture(this.currentCapture,t,n),this.recorderSpy.startCapture(),this.currentCapture.listenCommandsStartTime=a.now}stopCapture(){const e=a.now;return this.options.recordAlways||this.unSpy(),this.capturing=!1,this.stateSpy.stopCapture(this.currentCapture),this.recorderSpy.stopCapture(),this.currentCapture.listenCommandsEndTime=e,this.currentCapture.endTime=a.now,this.recorderSpy.appendRecordedInformation(this.currentCapture),this.analyser.appendAnalyses(this.currentCapture),this.currentCapture}isCapturing(){return this.globalCapturing&&this.capturing}setMarker(e){this.marker=e}clearMarker(){this.marker=null}log(e){this.currentCapture.commands.push({name:"LOG",text:e,commandArguments:[],commandEndTime:a.now,endTime:a.now,stackTrace:[],marker:"",status:40,startTime:a.now,result:void 0,id:this.getNextCommandCaptureId()})}getNextCommandCaptureId(){return this.commandId++}onCommand(e,t){if(this.globalCapturing&&(this.webGlObjectSpy.tagWebGlObjects(t),this.recorderSpy.recordCommand(t),this.isCapturing())){const n=e.createCapture(t,this.getNextCommandCaptureId(),this.marker);this.stateSpy.captureState(n),this.currentCapture.commands.push(n),n.endTime=a.now,this.maxCommands>0&&this.currentCapture.commands.length===this.maxCommands&&this.onMaxCommand.trigger(this)}}spyContext(e){const t=[];for(const n in e)n&&t.push(n);for(let n=0;n<t.length;n++){const i=t[n];if(!~qe.unSpyableMembers.indexOf(i))try{"number"!=typeof e[i]&&this.spyFunction(i,e)}catch(e){s.error("Cant Spy member: "+i),s.error(e)}}}initStaticCapture(){const e=new Ke(this.contextInformation),t=e.getExtensions();for(const e in t)t.hasOwnProperty(e)&&(this.contextInformation.extensions[e]=t[e]);const n=new Ye(this.contextInformation),i=new je(this.contextInformation);this.contextCapture={version:this.version,contextAttributes:this.context.getContextAttributes(),capabilities:n.getStateData(),extensions:e.getStateData(),compressedTextures:i.getStateData()},this.canvasCapture={width:this.context.canvas.width,height:this.context.canvas.height,clientWidth:this.context.canvas.clientWidth||this.context.canvas.width,clientHeight:this.context.canvas.clientHeight||this.context.canvas.height,browserAgent:navigator?navigator.userAgent:""}}spyFunction(e,t){if(0!==e.indexOf("__SPECTOR_Origin_")){if(!this.commandSpies[e]){const n=function(e,t){const n={};for(const t in e)e.hasOwnProperty(t)&&(n[t]=e[t]);for(const e in t)n.hasOwnProperty(e)||(n[e]=t[e]);return n}(this.contextInformation,{spiedCommandName:e,spiedCommandRunningContext:t,callback:this.onCommand.bind(this)});this.commandSpies[e]=new se(n)}this.commandSpies[e].spy()}}toggleGlobalCapturing(e){this.globalCapturing=e}tagWebGlObject(e){return this.webGlObjectSpy.tagWebGlObject(e)}}qe.unSpyableMembers=["canvas","drawingBufferWidth","drawingBufferHeight","drawingBufferColorSpace","unpackColorSpace","glp"];class Ze{constructor(e){this.spiedScope=e||window,this.lastFrame=0,this.speedRatio=1,this.willPlayNextFrame=!1,this.onFrameStart=new o,this.onFrameEnd=new o,this.onError=new o,this.lastSixtyFramesDuration=[],this.lastSixtyFramesCurrentIndex=0,this.lastSixtyFramesPreviousStart=0;for(let e=0;e<Ze.fpsWindowSize;e++)this.lastSixtyFramesDuration[e]=0;this.init()}playNextFrame(){this.willPlayNextFrame=!0}changeSpeedRatio(e){this.speedRatio=e}static getRequestAnimationFrameFunctionNames(){return[...Ze.requestAnimationFrameFunctions]}addRequestAnimationFrameFunctionName(e){Ze.requestAnimationFrameFunctions.push(e)}getSpiedScope(){return this.spiedScope}setSpiedScope(e){this.spiedScope=e}getFps(){let e=0;for(let t=0;t<Ze.fpsWindowSize;t++)e+=this.lastSixtyFramesDuration[t];return 0===e?0:6e4/e}init(){for(const e of Ze.requestAnimationFrameFunctions)this.spyRequestAnimationFrame(e,this.spiedScope);for(const e of Ze.setTimerFunctions)this.spySetTimer(e);this.spiedScope.VRDisplay&&this.spiedScope.addEventListener("vrdisplaypresentchange",(e=>{this.spyRequestAnimationFrame("requestAnimationFrame",e.display)}))}spyRequestAnimationFrame(e,t){const n=this;A.storeOriginFunction(t,e),t[e]=function(){const i=arguments[0],r=n.getCallback(n,i,(()=>{n.spiedScope[e](i)})),s=A.executeOriginFunction(t,e,[r]);return s}}spySetTimer(e){const t=this,n=this.spiedScope,i="setTimeout"===e;A.storeOriginFunction(n,e),n[e]=function(){const r=arguments[0],s=arguments[1],o=Array.prototype.slice.call(arguments);Ze.setTimerCommonValues.indexOf(s)>-1&&(o[0]=t.getCallback(t,r,i?()=>{n[e](r)}:null));const a=A.executeOriginFunction(n,e,o);return a}}getCallback(e,t,n=null){return function(){const i=a.now;if(e.lastFrame=++e.lastFrame%e.speedRatio,e.willPlayNextFrame||e.speedRatio&&!e.lastFrame){e.onFrameStart.trigger(e);try{t.apply(e.spiedScope,arguments)}catch(t){e.onError.trigger(t)}e.lastSixtyFramesCurrentIndex=(e.lastSixtyFramesCurrentIndex+1)%Ze.fpsWindowSize,e.lastSixtyFramesDuration[e.lastSixtyFramesCurrentIndex]=i-e.lastSixtyFramesPreviousStart,e.onFrameEnd.trigger(e),e.willPlayNextFrame=!1}else n&&n();e.lastSixtyFramesPreviousStart=i}}}Ze.requestAnimationFrameFunctions=["requestAnimationFrame","msRequestAnimationFrame","webkitRequestAnimationFrame","mozRequestAnimationFrame","oRequestAnimationFrame"],Ze.setTimerFunctions=["setTimeout","setInterval"],Ze.setTimerCommonValues=[0,15,16,33,32,40],Ze.fpsWindowSize=60;class Qe{constructor(e){this.canvas=e,this.onContextRequested=new o,this.init()}init(){const e=this,t=function(){const t=this instanceof HTMLCanvasElement?HTMLCanvasElement:OffscreenCanvas,n=e.canvas?A.executeOriginFunction(this,"getContext",arguments):A.executePrototypeOriginFunction(this,t,"getContext",arguments);if(arguments.length>0&&"2d"===arguments[0])return n;if(n){const t=Array.prototype.slice.call(arguments),i="webgl2"===t[0]||"experimental-webgl2"===t[0]?2:1;e.onContextRequested.trigger({context:n,contextVersion:i})}return n};this.canvas?(A.storeOriginFunction(this.canvas,"getContext"),this.canvas.getContext=t):(A.storePrototypeOriginFunction(HTMLCanvasElement,"getContext"),HTMLCanvasElement.prototype.getContext=t,"undefined"!=typeof OffscreenCanvas&&(A.storePrototypeOriginFunction(OffscreenCanvas,"getContext"),OffscreenCanvas.prototype.getContext=t))}}var Je=n(379),et=n.n(Je),tt=n(795),nt=n.n(tt),it=n(569),rt=n.n(it),st=n(565),ot=n.n(st),at=n(216),lt=n.n(at),ct=n(589),ut=n.n(ct),ht=n(866),dt={};dt.styleTagTransform=ut(),dt.setAttributes=ot(),dt.insert=rt().bind(null,"html"),dt.domAPI=nt(),dt.insertStyleElement=lt(),et()(ht.Z,dt),ht.Z&&ht.Z.locals&&ht.Z.locals;class mt{constructor(e,t){this.placeHolder=e,this.stateStore=t}compose(e){const t=this.stateStore.getStatesToProcess();let n=!1;for(const e in t)if(t.hasOwnProperty(e)){const i=t[e],r=this.stateStore.getLastOperation(i),s=this.stateStore.getComponentInstance(i),o=this.stateStore.getData(i);s.render(o,i,r),n=!0}if(!n)return;const i=this.stateStore.getLastOperation(e);this.composeInContainer(this.placeHolder,Number.MAX_VALUE,e,i)}composeChildren(e,t){if(!t)return;const n=this.stateStore.getChildrenIds(e);let i=0;for(let e=0;e<n.length;e++){const r=n[e],s=this.stateStore.getLastOperation(r);this.composeInContainer(t,i,r,s),50!==s&&i++}}composeInContainer(e,t,n,i){const r=this.stateStore.getComponentInstance(n).composeInContainer(e,t,i);this.composeChildren(n,r)}}class pt{constructor(){this.store={},this.idGenerator=0,this.pendingOperation={}}getLastOperation(e){return this.store[e].lastOperation}getData(e){return this.store[e].data}getComponentInstance(e){return this.store[e].componentInstance}getParentId(e){return this.store[e].parent?this.store[e].parent.id:-1}getChildrenIds(e){const t=[];for(const n of this.store[e].children)t.push(n.id);return t}hasChildren(e){return this.store[e].children.length>0}add(e,t){const n=this.getNewId();return this.pendingOperation[n]=n,this.store[n]={data:e,id:n,parent:null,children:[],componentInstance:t,lastOperation:20},n}update(e,t){this.store[e],this.pendingOperation[e]=e,this.store[e].data=t,this.store[e].lastOperation=40}addChild(e,t,n){const i=this.store[e],r=this.add(t,n);this.pendingOperation[r]=r;const s=this.store[r];return s.parent=i,i.children.push(s),r}insertChildAt(e,t,n,i){const r=this.store[e],s=this.add(n,i);this.pendingOperation[s]=s;const o=this.store[s];return o.parent=r,t>=r.children.length?r.children.push(o):t>=0?r.children.splice(t,0,o):r.children.unshift(o),s}removeChildById(e,t){const n=this.store[e];for(let i=n.children.length-1;i>=0;i--)if(n.children[i].id===t){this.removeChildAt(e,i);break}}removeChildAt(e,t){const n=this.store[e];let i;t>n.children.length-1?(i=n.children[n.children.length-1],n.children[n.children.length-1].parent=null,n.children.splice(n.children.length-1,1)):t>=0?(i=n.children[t],n.children[t].parent=null,n.children.splice(t,1)):(i=n.children[0],n.children[0].parent=null,n.children.splice(0,1)),i.parent=null,this.remove(i.id)}remove(e){const t=this.store[e];t.parent?(this.store[t.parent.id],this.removeChildById(t.parent.id,e)):(this.removeChildren(e),this.store[e].lastOperation=50,this.pendingOperation[e]=e)}removeChildren(e){const t=this.store[e];for(;t.children.length;)this.remove(t.children[0].id)}getStatesToProcess(){return this.pendingOperation}flushPendingOperations(){for(const e in this.pendingOperation)this.pendingOperation[e]&&(50===this.store[e].lastOperation?delete this.store[e]:this.store[e].lastOperation=0);this.pendingOperation={}}getNewId(){return++this.idGenerator}}class gt{constructor(e){this.component=e}render(e,t,n){0!==n&&(50!==n?this.domNode=this.component.render(e,t):this.removeNode())}composeInContainer(e,t,n){if(50===n)return this.removeNode(),null;const i=this.cachedCurrentChildrenContainer;if(0===n)return i;const r=this.domNode,s=r.getAttribute("childrencontainer")?r:r.querySelector("[childrenContainer]");if(s&&i){const e=i.children;for(;e.length>0;)s.appendChild(e[0])}if(this.cachedCurrentChildrenContainer=s,t>=e.children.length)e.appendChild(r),this.cachedCurrentDomNode&&40===n&&(this.cachedCurrentDomNode.remove?this.cachedCurrentDomNode.remove():this.cachedCurrentDomNode.parentNode&&this.cachedCurrentDomNode.parentNode.removeChild(this.cachedCurrentDomNode));else{const i=e.children[t];e.insertBefore(r,i),40===n&&e.removeChild(i)}return this.cachedCurrentDomNode=this.domNode,s}removeNode(){this.domNode&&this.domNode.parentElement&&(this.domNode.remove?this.domNode.remove():this.domNode.parentNode&&this.domNode.parentNode.removeChild(this.domNode)),this.cachedCurrentDomNode&&this.cachedCurrentDomNode.parentElement&&(this.cachedCurrentDomNode.remove?this.cachedCurrentDomNode.remove():this.cachedCurrentDomNode.parentNode&&this.cachedCurrentDomNode.parentNode.removeChild(this.cachedCurrentDomNode))}}gt.idGenerator=0;class ft{constructor(e){this.stateStore=new pt,this.compositor=new mt(e,this.stateStore),this.willRender=!1,this.rootStateId=-1}addRootState(e,t,n=!1){const i=new gt(t),r=this.stateStore.add(e,i);return this.rootStateId=r,this.setForRender(n),r}addChildState(e,t,n,i=!1){const r=this.insertChildState(e,t,Number.MAX_VALUE,n);return this.setForRender(i),r}insertChildState(e,t,n,i,r=!1){const s=new gt(i),o=this.stateStore.insertChildAt(e,n,t,s);return this.setForRender(r),o}updateState(e,t,n=!1){this.stateStore.update(e,t),this.setForRender(n)}removeState(e,t=!1){this.stateStore.remove(e),this.setForRender(t)}removeChildrenStates(e,t=!1){this.stateStore.removeChildren(e),this.setForRender(t)}getState(e){return this.stateStore.getData(e)}getGenericState(e){return this.getState(e)}getChildrenState(e){return this.stateStore.getChildrenIds(e).map((t=>this.stateStore.getData(e)))}getChildrenGenericState(e){return this.getChildrenState(e)}hasChildren(e){return this.stateStore.hasChildren(e)}updateAllChildrenState(e,t){const n=this.stateStore.getChildrenIds(e);for(const e of n){const n=this.getGenericState(e);t(n),this.updateState(e,n)}}updateAllChildrenGenericState(e,t){this.updateAllChildrenState(e,t)}setForRender(e){this.willRender||(this.willRender=!0,e?this.compose():setTimeout(this.compose.bind(this),ft.REFRESHRATEINMILLISECONDS))}compose(){this.willRender=!1,this.compositor.compose(this.rootStateId),this.stateStore.flushPendingOperations()}}ft.REFRESHRATEINMILLISECONDS=100;class Et extends class{constructor(){this.dummyTextGeneratorElement=document.createElement("div")}createFromHtml(e){const t=document.createElement("div");return t.innerHTML=e,t.firstElementChild}htmlTemplate(e,...t){const n=e.raw;let i="";return t.forEach(((e,t)=>{let r=n[t];Array.isArray(e)&&(e=e.join("")),r&&r.length>0&&"$"===r[r.length-1]?r=r.slice(0,-1):e=this.htmlEscape(e),i+=r,i+=e})),i+=n[n.length-1],i}htmlEscape(e){return null==e||0===e.length?e:(this.dummyTextGeneratorElement.innerText=e,this.dummyTextGeneratorElement.innerHTML)}}{constructor(){super(),this.events={}}addEventListener(e,t,n=null){return this.events[e]?this.events[e].add(t,n):-1}removeEventListener(e,t){this.events[e]&&this.events[e].remove(t)}renderElementFromTemplate(e,t,n){const i=this.createFromHtml(e);return this.bindCommands(i,t,n),i}bindCommands(e,t,n){e.getAttribute("commandname")&&this.bindCommand(e,t,n);const i=e.querySelectorAll("[commandName]");for(let e=0;e<i.length;e++){const r=i[e];this.bindCommand(r,t,n)}}bindCommand(e,t,n){const i=e.getAttribute("commandname");let r=e.getAttribute("commandeventbinding")||"";0===r.length&&(r="click");const s="true"===e.getAttribute("usecapture"),o="true"===e.getAttribute("stoppropagation");this.createEvent(i),this.mapEventListener(e,r,i,t,n,s,o)}mapEventListener(e,t,n,i,r,s=!1,o=!1){const a=this;o?e.addEventListener(t,(function(e){return e.stopPropagation(),e.preventDefault(),a.triggerEvent(n,this,i,r),!1}),s):e.addEventListener(t,(function(){a.triggerEvent(n,this,i,r)}),s)}createEvent(e){if(!this.events[e]){const t=new o;this.events[e]=t}return this.events[e]}triggerEvent(e,t,n,i){this.events[e].trigger({sender:t,stateId:i,state:n})}}class vt extends Et{render(e,t){const n=this.htmlTemplate`<div>
            <div childrenContainer="true" class="captureMenuComponent ${e?"active":""}">
            </div>
            <div class="captureMenuLogComponent ${e.logVisible?"active":""}">
                <span class="${e.logLevel===r.error?"error":""}">${e.logText}<span>
            </div>
        </div>`;return this.renderElementFromTemplate(n,e,t)}}class _t extends Et{constructor(){super(),this.onCanvasSelected=this.createEvent("onCanvasSelected")}render(e,t){const n=document.createElement("li"),i=document.createElement("span");return i.innerText=`Id: ${e.id} - Size: ${e.width}*${e.height}`,n.appendChild(i),this.mapEventListener(n,"click","onCanvasSelected",e,t),n}}class Ct extends Et{constructor(){super(),this.onCaptureRequested=this.createEvent("onCaptureRequested"),this.onPlayRequested=this.createEvent("onPlayRequested"),this.onPauseRequested=this.createEvent("onPauseRequested"),this.onPlayNextFrameRequested=this.createEvent("onPlayNextFrameRequested")}render(e,t){const n=this.htmlTemplate`
        <div class="captureMenuActionsComponent">
            <div commandName="onCaptureRequested">
            </div>
            $${e?'<div commandName="onPauseRequested">\n                </div>':'<div commandName="onPlayRequested">\n                </div>\n                <div commandName="onPlayNextFrameRequested">\n                </div>'}
        </div>`;return this.renderElementFromTemplate(n,e,t)}}class At extends Et{constructor(){super(),this.onCanvasSelection=this.createEvent("onCanvasSelection")}render(e,t){const n=this.htmlTemplate`
        <div class="canvasListComponent">
            <span commandName="onCanvasSelection">
                ${e.currentCanvasInformation?`${e.currentCanvasInformation.id} (${e.currentCanvasInformation.width}*${e.currentCanvasInformation.height})`:"Choose Canvas..."}
            </span>
            <ul childrenContainer="true" style="${e.showList?"display:block;visibility:visible":"display:none;visibility:hidden"}"></ul>
        </div>`;return this.renderElementFromTemplate(n,e,t)}}class Rt extends Et{render(e,t){const n=document.createElement("span");return n.className="fpsCounterComponent",n.innerText=e.toFixed(2)+" Fps",n}}class St{constructor(e={}){this.options=e,this.rootPlaceHolder=e.rootPlaceHolder||document.body,this.mvx=new ft(this.rootPlaceHolder),this.isTrackingCanvas=!1,this.onCanvasSelected=new o,this.onCaptureRequested=new o,this.onPauseRequested=new o,this.onPlayRequested=new o,this.onPlayNextFrameRequested=new o,this.captureMenuComponent=new vt,this.canvasListComponent=new At,this.canvasListItemComponent=new _t,this.actionsComponent=new Ct,this.fpsCounterComponent=new Rt,this.rootStateId=this.mvx.addRootState({visible:!0,logLevel:r.info,logText:St.SelectCanvasHelpText,logVisible:!this.options.hideLog},this.captureMenuComponent),this.canvasListStateId=this.mvx.addChildState(this.rootStateId,{currentCanvasInformation:null,showList:!1},this.canvasListComponent),this.actionsStateId=this.mvx.addChildState(this.rootStateId,!0,this.actionsComponent),this.fpsStateId=this.mvx.addChildState(this.rootStateId,0,this.fpsCounterComponent),this.actionsComponent.onCaptureRequested.add((()=>{const e=this.getSelectedCanvasInformation();e&&this.updateMenuStateLog(r.info,St.PleaseWaitHelpText,!0),setTimeout((()=>{this.onCaptureRequested.trigger(e)}),200)})),this.actionsComponent.onPauseRequested.add((()=>{this.onPauseRequested.trigger(this.getSelectedCanvasInformation()),this.mvx.updateState(this.actionsStateId,!1)})),this.actionsComponent.onPlayRequested.add((()=>{this.onPlayRequested.trigger(this.getSelectedCanvasInformation()),this.mvx.updateState(this.actionsStateId,!0)})),this.actionsComponent.onPlayNextFrameRequested.add((()=>{this.onPlayNextFrameRequested.trigger(this.getSelectedCanvasInformation())})),this.canvasListComponent.onCanvasSelection.add((e=>{this.mvx.updateState(this.canvasListStateId,{currentCanvasInformation:null,showList:!e.state.showList}),this.updateMenuStateLog(r.info,St.SelectCanvasHelpText),this.onCanvasSelected.trigger(null),this.isTrackingCanvas&&this.trackPageCanvases(),e.state.showList?this.showMenuStateLog():this.hideMenuStateLog()})),this.canvasListItemComponent.onCanvasSelected.add((e=>{this.mvx.updateState(this.canvasListStateId,{currentCanvasInformation:e.state,showList:!1}),this.onCanvasSelected.trigger(e.state),this.updateMenuStateLog(r.info,St.ActionsHelpText),this.showMenuStateLog()}))}getSelectedCanvasInformation(){return this.mvx.getGenericState(this.canvasListStateId).currentCanvasInformation}trackPageCanvases(){if(this.isTrackingCanvas=!0,document.body){const e=document.body.querySelectorAll("canvas");this.updateCanvasesList(e)}}updateCanvasesList(e){this.updateCanvasesListInformationInternal(e,(e=>({id:e.id,width:e.width,height:e.height,ref:e})))}updateCanvasesListInformation(e){this.updateCanvasesListInformationInternal(e,(e=>({id:e.id,width:e.width,height:e.height,ref:e.ref})))}display(){this.updateMenuStateVisibility(!0)}hide(){this.updateMenuStateVisibility(!1)}captureComplete(e){e?this.updateMenuStateLog(r.error,e):this.updateMenuStateLog(r.info,St.ActionsHelpText)}setFPS(e){this.mvx.updateState(this.fpsStateId,e)}updateCanvasesListInformationInternal(e,t){this.mvx.removeChildrenStates(this.canvasListStateId);const n=[];for(let i=0;i<e.length;i++){const r=t(e[i]);n.push(r),this.mvx.addChildState(this.canvasListStateId,r,this.canvasListItemComponent)}const i=n.length,s=this.mvx.getGenericState(this.canvasListStateId).showList;if(!s)if(1===i){const e=n[0];this.mvx.updateState(this.canvasListStateId,{currentCanvasInformation:e,showList:s}),this.updateMenuStateLog(r.info,St.ActionsHelpText),this.onCanvasSelected.trigger(e)}else this.updateMenuStateLog(r.info,St.SelectCanvasHelpText),this.onCanvasSelected.trigger(null)}hideMenuStateLog(){const e=this.mvx.getGenericState(this.rootStateId);this.mvx.updateState(this.rootStateId,{visible:e.visible,logLevel:e.logLevel,logText:e.logText,logVisible:!1})}showMenuStateLog(){const e=this.mvx.getGenericState(this.rootStateId);this.mvx.updateState(this.rootStateId,{visible:e.visible,logLevel:e.logLevel,logText:e.logText,logVisible:!this.options.hideLog})}updateMenuStateLog(e,t,n=!1){const i=this.mvx.getGenericState(this.rootStateId);this.mvx.updateState(this.rootStateId,{visible:i.visible,logLevel:e,logText:t,logVisible:!this.options.hideLog},n)}updateMenuStateVisibility(e){const t=this.mvx.getGenericState(this.rootStateId);this.mvx.updateState(this.rootStateId,{visible:e,logLevel:t.logLevel,logText:t.logText,logVisible:t.logVisible})}}St.SelectCanvasHelpText="Please, select a canvas in the list above.",St.ActionsHelpText="Record with the red button, you can also pause or continue playing the current scene.",St.PleaseWaitHelpText="Capturing, be patient (this can take up to 3 minutes)...";var Tt=n(625),bt={};bt.styleTagTransform=ut(),bt.setAttributes=ot(),bt.insert=rt().bind(null,"html"),bt.domAPI=nt(),bt.insertStyleElement=lt(),et()(Tt.Z,bt),Tt.Z&&Tt.Z.locals&&Tt.Z.locals;class wt extends Et{constructor(){super(),this.onCaptureLoaded=new o}render(e,t){const n=this.htmlTemplate`
        <div class="captureListComponent ${e?"active":""}">
            <div class="openCaptureFile">
                <Span>Drag files here to open a previously saved capture.</span>
            </div>
            <ul childrenContainer="true"></ul>
        </div>`,i=this.renderElementFromTemplate(n,e,t),r=i.querySelector(".openCaptureFile");return r.addEventListener("dragenter",(e=>(this.drag(e),!1)),!1),r.addEventListener("dragover",(e=>(this.drag(e),!1)),!1),r.addEventListener("drop",(e=>{this.drop(e)}),!1),i}drag(e){e.stopPropagation(),e.preventDefault()}drop(e){e.stopPropagation(),e.preventDefault(),this.loadFiles(e)}loadFiles(e){let t=null;if(e&&e.dataTransfer&&e.dataTransfer.files&&(t=e.dataTransfer.files),e&&e.target&&e.target.files&&(t=e.target.files),t&&t.length>0)for(let e=0;e<t.length;e++){const n=t[e].name.toLowerCase().split(".").pop();if(t[e].type,"json"===n){const n=t[e],i=new FileReader;i.onerror=e=>{s.error("Error while reading file: "+n.name+e)},i.onload=e=>{try{const t=JSON.parse(e.target.result);this.onCaptureLoaded.trigger(t)}catch(e){s.error("Error while reading file: "+n.name+e)}},i.readAsText(n)}}}}class xt extends Et{constructor(){super(),this.onCaptureSelected=this.createEvent("onCaptureSelected"),this.onSaveRequested=this.createEvent("onSaveRequested")}render(e,t){const n=document.createElement("li");if(e.active&&(n.className="active"),e.capture.endState.VisualState.Attachments)for(const t of e.capture.endState.VisualState.Attachments){const e=document.createElement("img");e.src=encodeURI(t.src),n.appendChild(e)}else{const t=document.createElement("span");t.innerText=e.capture.endState.VisualState.FrameBufferStatus,n.appendChild(t)}const i=document.createElement("span");i.innerText=new Date(e.capture.startTime).toTimeString().split(" ")[0],n.appendChild(i);const r=document.createElement("a");return r.href="#",r.className="captureListItemSave",this.mapEventListener(r,"click","onSaveRequested",e,t,!1,!0),i.appendChild(r),this.mapEventListener(n,"click","onCaptureSelected",e,t),n}}class yt extends Et{render(e,t){const n=this.htmlTemplate`
        <div class="visualStateListComponent">
            <ul childrenContainer="true"></ul>
        </div>`;return this.renderElementFromTemplate(n,e,t)}}class Lt{static scrollIntoView(e){const t=e.getBoundingClientRect();let n=e.parentElement;for(;n&&n.clientHeight===n.offsetHeight;)n=n.parentElement;if(!n)return;const i=n.getBoundingClientRect();t.top<i.top?e.scrollIntoView(!0):t.bottom>i.bottom&&e.scrollIntoView(!1)}}class It extends Et{constructor(){super(),this.onVisualStateSelected=this.createEvent("onVisualStateSelected")}render(e,t){const n=document.createElement("li");if(e.active&&(n.className="active",setTimeout((()=>{Lt.scrollIntoView(n)}),1)),e.VisualState.Attachments)for(const t of e.VisualState.Attachments){if(!t.src)continue;const i=document.createElement("img");if(i.src=encodeURI(t.src),n.appendChild(i),e.VisualState.Attachments.length>1){const e=document.createElement("span");e.innerText=t.attachmentName,n.appendChild(e)}if(t.textureLayer){const e=document.createElement("span");e.innerText="Layer: "+t.textureLayer,n.appendChild(e)}if(t.textureCubeMapFace){const e=document.createElement("span");e.innerText=t.textureCubeMapFace,n.appendChild(e)}}else{const t=document.createElement("span");t.innerText=e.VisualState.FrameBufferStatus,n.appendChild(t)}const i=document.createElement("span");return i.innerText=e.VisualState.FrameBuffer?"Frame buffer: "+e.VisualState.FrameBuffer.__SPECTOR_Object_TAG.id:"Canvas frame buffer",n.appendChild(i),this.mapEventListener(n,"click","onVisualStateSelected",e,t),n}}class Ft extends Et{render(e,t){const n=this.htmlTemplate`
        <div class="commandListComponent">
            <ul childrenContainer="true"></ul>
        </div>`;return this.renderElementFromTemplate(n,e,t)}}class Nt extends Et{constructor(){super(),this.onCommandSelected=this.createEvent("onCommandSelected"),this.onVertexSelected=this.createEvent("onVertexSelected"),this.onFragmentSelected=this.createEvent("onFragmentSelected")}render(e,t){const n=document.createElement("li");let i="unknown";switch(e.capture.status){case 50:i="deprecated";break;case 10:i="unused";break;case 20:i="disabled";break;case 30:i="redundant";break;case 40:i="valid"}if(e.capture.VisualState&&(n.className=" drawCall"),e.active&&(n.className=" active",setTimeout((()=>{Lt.scrollIntoView(n)}),1)),e.capture.marker){const t=document.createElement("span");t.className=i+" marker important",t.innerText=e.capture.marker+" ",t.style.fontWeight="1000",n.appendChild(t)}if("LOG"===e.capture.name){const t=document.createElement("span");t.className=i+" marker important",t.innerText=e.capture.text+" ",t.style.fontWeight="1000",n.appendChild(t)}else{const t=document.createElement("span");let r=e.capture.text;r=r.replace(e.capture.name,`<span class=" ${i} important">${e.capture.name}</span>`),t.innerHTML=r,n.appendChild(t)}if(e.capture.VisualState&&"clear"!==e.capture.name)try{const i=e.capture.DrawCall.shaders[0],r=e.capture.DrawCall.shaders[1],s=document.createElement("a");s.innerText=i.name,s.href="#",n.appendChild(s),this.mapEventListener(s,"click","onVertexSelected",e,t);const o=document.createElement("a");o.innerText=r.name,o.href="#",n.appendChild(o),this.mapEventListener(o,"click","onFragmentSelected",e,t)}catch(e){}return this.mapEventListener(n,"click","onCommandSelected",e,t),n}}class Mt extends Et{render(e,t){const n=this.htmlTemplate`
        <div class="commandDetailComponent" childrenContainer="true">
        </div>`;return this.renderElementFromTemplate(n,e,t)}}class Ot extends Et{render(e,t){const n=this.htmlTemplate`
        <div class="jsonContentComponent" childrenContainer="true">
        </div>`;return this.renderElementFromTemplate(n,e,t)}}class Bt extends Et{render(e,t){const n=this.htmlTemplate`
        <div class="jsonGroupComponent">
            <div class="jsonGroupComponentTitle">${e?e.replace(/([A-Z])/g," $1").trim():""}</div>
            <ul childrenContainer="true"></ul>
        </div>`;return this.renderElementFromTemplate(n,e,t)}}class $t extends Et{render(e,t){const n=this.htmlTemplate`
            <li><span class="jsonItemComponentKey">${e.key}: </span><span class="jsonItemComponentValue">${e.value}</span><li>`;return this.renderElementFromTemplate(n,e,t)}}class Pt extends Et{render(e,t){const n=this.htmlTemplate`
        <li class="jsonItemImageHolder"><div class="jsonItemImage"><img src="${e.value}" style="${e.pixelated?"image-rendering: pixelated;":""}" /><span>${e.key}</span></div></li>`;return this.renderElementFromTemplate(n,e,t)}}class kt extends Et{render(e,t){const n=this.htmlTemplate`
            <li><span class="jsonItemComponentKey">${e.key}: </span>
                <span class="jsonItemComponentValue">${e.value} (<a href="${e.help}" target="_blank" class="jsonSourceItemComponentOpen">Open help page</a>)
                </span>
            <li>`;return this.renderElementFromTemplate(n,e,t)}}class Dt extends Et{render(e,t){const n=document.createElement("div");if(n.className="jsonVisualStateItemComponent",e.Attachments)for(const t of e.Attachments){if(!t.src)continue;const i=document.createElement("img");if(i.src=encodeURI(t.src),n.appendChild(i),e.Attachments.length>1){const e=document.createElement("span");e.innerText=t.attachmentName,n.appendChild(e)}}else{const t=document.createElement("span");t.innerText=e.FrameBufferStatus,n.appendChild(t)}const i=document.createElement("span");return i.innerText=e.FrameBuffer?e.FrameBuffer.__SPECTOR_Object_TAG.displayText:"Canvas frame buffer",n.appendChild(i),n}}class Ut extends Et{constructor(){super(),this.onCapturesClicked=this.createEvent("onCapturesClicked"),this.onCommandsClicked=this.createEvent("onCommandsClicked"),this.onInformationClicked=this.createEvent("onInformationClicked"),this.onInitStateClicked=this.createEvent("onInitStateClicked"),this.onEndStateClicked=this.createEvent("onEndStateClicked"),this.onCloseClicked=this.createEvent("onCloseClicked"),this.onSearchTextChanged=this.createEvent("onSearchTextChanged"),this.onSearchTextCleared=this.createEvent("onSearchTextCleared")}render(e,t){const n=this.htmlTemplate`<ul class="resultViewMenuComponent">
                <li class="resultViewMenuOpen resultViewMenuSmall"><a href="#" role="button">Menu</a></li>

                <li class="searchContainer">
                    <input type="text" placeHolder="Search..." value="${e.searchText}" commandName="onSearchTextChanged" commandEventBinding="change">
                    <a class="clearSearch" stoppropagation="true" CommandName="onSearchTextCleared">X</a>
                </li>
                <li><a class="${0===e.status?"active":""} href="#" role="button" commandName="onCapturesClicked">Captures</a></li>
                <li><a class="${10===e.status?"active":""} href="#" role="button" commandName="onInformationClicked">Information</a></li>
                <li><a class="${20===e.status?"active":""} href="#" role="button" commandName="onInitStateClicked">Init State</a></li>
                <li>
                    <a class="${40===e.status?"active":""} href="#" role="button" commandName="onCommandsClicked">
                        Commands${e.commandCount>0?" ("+e.commandCount+")":""}
                    </a>
                </li>
                <li><a class="${30===e.status?"active":""} href="#" role="button" commandName="onEndStateClicked">End State</a></li>
                <li><a role="button" commandName="onCloseClicked" stoppropagation="true">Close</a></li>
            </ul>`,i=this.renderElementFromTemplate(n,e,t),r=i.querySelector(".resultViewMenuOpen"),s=i.querySelectorAll("li:not(.resultViewMenuSmall)");return r.addEventListener("click",(e=>{if("true"===r.getAttribute("open")){r.setAttribute("open","false");for(let e=0;e<s.length;e++)s[e].style.display="none",s[e].style.visibility="hidden"}else{r.setAttribute("open","true");for(let e=0;e<s.length;e++)s[e].style.display="block",s[e].style.visibility="visible"}})),i}}class Gt extends Et{render(e,t){return this.renderElementFromTemplate('<div childrenContainer="true" class="resultViewContentComponent"></div>',e,t)}}class Wt extends Et{render(e,t){const n=this.htmlTemplate`
            <div childrenContainer="true" class="resultViewComponent ${e?"active":""}">
            </div>`;return this.renderElementFromTemplate(n,e,t)}}var Vt=n(29),Ht=n.n(Vt);class Xt extends Et{constructor(){super(),this.onTranslatedVertexSourceClicked=this.createEvent("onTranslatedVertexSourceClicked"),this.onTranslatedFragmentSourceClicked=this.createEvent("onTranslatedFragmentSourceClicked"),this.onVertexSourceClicked=this.createEvent("onVertexSourceClicked"),this.onFragmentSourceClicked=this.createEvent("onFragmentSourceClicked"),this.onSourceCodeCloseClicked=this.createEvent("onSourceCodeCloseClicked"),this.onSourceCodeChanged=this.createEvent("onSourceCodeChanged"),this.onBeautifyChanged=this.createEvent("onBeautifyChanged"),this.onPreprocessChanged=this.createEvent("onPreprocessChanged")}showError(e){if(!this.editor)return;const t=[];if(e=e||""){const n=/^.*ERROR:\W([0-9]+):([0-9]+):(.*)$/gm;let i=n.exec(e);for(;null!=i;)t.push({row:+i[2]-1,column:i[1],text:i[3]||"Error",type:"error"}),i=n.exec(e)}this.editor.getSession().setAnnotations(t)}render(e,t){const n=e.fragment?e.sourceFragment:e.sourceVertex;let i,r=e.preprocessed;e.translated?(i=e.fragment?e.translatedSourceFragment:e.translatedSourceVertex,r=!1):i=null!=n?n:"";let o=i;if(r)try{o=Ht()(o,{preserveComments:!1,stopOnError:!0})}catch(e){s.error("shader preprocess failed",e)}e.beautify&&(o=this._indentIfdef(this._beautify(o)));const a=this.htmlTemplate`
        <div class="sourceCodeComponentContainer">
            <div class="sourceCodeMenuComponentContainer">
                <ul class="sourceCodeMenuComponent">
                    $${e.translatedSourceVertex?this.htmlTemplate`<li><a class="${!e.fragment&&e.translated?"active":""}" href="#" role="button" commandName="onTranslatedVertexSourceClicked">Translated Vertex</a></li>`:""}
                    $${e.translatedSourceFragment?this.htmlTemplate`<li><a class="${e.fragment&&e.translated?"active":""}" href="#" role="button" commandName="onTranslatedFragmentSourceClicked">Translated Fragment</a></li>`:""}
                    <li><a class="${e.fragment||e.translated?"":"active"}" href="#" role="button" commandName="onVertexSourceClicked">Vertex</a></li>
                    <li><a class="${e.fragment&&!e.translated?"active":""}" href="#" role="button" commandName="onFragmentSourceClicked">Fragment</a></li>
                    <li><a href="#" role="button" commandName="onSourceCodeCloseClicked">Close</a></li>
                </ul>
            </div>
            $${this.htmlTemplate`<div class="sourceCodeComponent">${o}</div>`}
            <div class="sourceCodeMenuComponentFooter">
                <p>
                    <label><input type="checkbox" commandName="onBeautifyChanged" ${e.beautify?"checked":""} /> Beautify</label>
                    <label><input type="checkbox" commandName="onPreprocessChanged" ${e.preprocessed?"checked":""} /> Preprocess</label>
                </p>
            </div>
        </div>`,l=this.renderElementFromTemplate(a.replace(/<br>/g,"\n"),e,t);this.editor=ace.edit(l.querySelector(".sourceCodeComponent")),this.editor.setTheme("ace/theme/monokai"),this.editor.getSession().setMode("ace/mode/glsl"),this.editor.setShowPrintMargin(!1);let c=-1;return this.editor.setReadOnly(!e.editable&&!e.translated),this.editor.getSession().on("change",(n=>{-1!==c&&clearTimeout(c),c=setTimeout((()=>{this._triggerCompilation(this.editor,e,l,t)}),1500)})),l}_triggerCompilation(e,t,n,i){t.fragment?t.sourceFragment=e.getValue():t.sourceVertex=e.getValue(),this.triggerEvent("onSourceCodeChanged",n,t,i)}_beautify(e,t=0){let n="";for(let e=0;e<t;e++)n+="    ";const i=e;if("#"===(e=e.trim())[0]){const r=i.indexOf("#"),s=i.indexOf("\n");let o="";-1!==s&&s<r&&(o=n+"\n");const a=e.indexOf("\n"),l=-1!==a?a:e.length,c=e.substr(0,l),u=e.substr(l+1);return o+n+c+"\n"+this._beautify(u,t)}e=this._adaptComments(e);const r=this._getBracket(e),s=r.firstIteration,o=r.lastIteration;let a;if(-1===s)a=e=(e=(e=(e=(e=(e=(e=(e=n+e).replace(/;(?![^\(]*\))\s*(\/\/.*)?/g,(e=>e.trim()+"\n"))).replace(/\s*([*+-/=><\s]*=)\s*/g,(e=>" "+e.trim()+" "))).replace(/\s*(,)\s*/g,(e=>e.trim()+" "))).replace(/\n[ \t]+/g,"\n")).replace(/\n/g,"\n"+n)).replace(/\s+$/g,"")).replace(/\n+$/g,"");else{const i=e.substr(0,s).trim(),r=e.substr(o+1,e.length).trim(),l=e.substr(s+1,o-s-1).trim();a=(""===i?n+"{":this._beautify(i,t)+" {\n")+this._beautify(l,t+1)+"\n"+n+"}\n"+this._beautify(r,t),a=a.replace(/\s*\n+\s*;/g,";")}return a=a.replace(Xt.semicolonReplacementKeyRegex,";"),a=a.replace(Xt.openCurlyReplacementKeyRegex,"{"),a=a.replace(Xt.closeCurlyReplacementKeyRegex,"}"),a}_adaptComments(e){let t=!1,n=!1;for(let i=0;i<e.length;i++){const r=e[i];"/"===r?"*"===e[i-1]?n=!1:"*"===e[i+1]?t||(n=!0,i++):"/"===e[i+1]&&(n||(t=!0,i++)):"\n"===r?t=!1:";"===r?(t||n)&&(e=e.substr(0,i)+Xt.semicolonReplacementKey+e.substr(i+1)):"{"===r?(t||n)&&(e=e.substr(0,i)+Xt.openCurlyReplacementKey+e.substr(i+1)):"}"===r&&(t||n)&&(e=e.substr(0,i)+Xt.closeCurlyReplacementKey+e.substr(i+1))}return e}_getBracket(e,t=-1){const n=e.indexOf("{",t),i=e.substr(n+1).split("");let r=1,s=n,o=0;for(const e of i)if(s++,"{"===e&&r++,"}"===e&&r--,0===r){o=s;break}return n>-1&&0===o?this._getBracket(e,n+1):{firstIteration:n,lastIteration:o}}_indentIfdef(e){let t=0;const n=e.split("\n");for(let e=0;e<n.length;e++){const i=n[e];-1!==i.indexOf("#endif")&&t--,-1!==i.indexOf("#else")&&t--;let r="";for(let e=0;e<t;e++)r+="    ";n[e]=r+i,-1===i.indexOf("#if")&&-1===i.indexOf("#else")||t++}return n.join("\n")}}Xt.semicolonReplacementKey="[[[semicolonReplacementKey]]]",Xt.semicolonReplacementKeyRegex=new RegExp("\\[\\[\\[semicolonReplacementKey\\]\\]\\]","g"),Xt.openCurlyReplacementKey="[[[openCurlyReplacementKey]]]",Xt.openCurlyReplacementKeyRegex=new RegExp("\\[\\[\\[openCurlyReplacementKey\\]\\]\\]","g"),Xt.closeCurlyReplacementKey="[[[closeCurlyReplacementKey]]]",Xt.closeCurlyReplacementKeyRegex=new RegExp("\\[\\[\\[closeCurlyReplacementKey\\]\\]\\]","g");class zt extends Et{render(e,t){const n=this.htmlTemplate`
                <div childrenContainer="true" class="${e?"informationColumnLeftComponent":"informationColumnRightComponent"}"></div>`;return this.renderElementFromTemplate(n,e,t)}}class Kt{static getMDNLink(e){const t=Kt.WebGL2Functions[e];if(t)return Kt.WebGL2RootUrl+t;const n=Kt.WebGLFunctions[e];if(n)return Kt.WebGLRootUrl+n;const i=Kt.AngleInstancedArraysExtFunctions[e];return i?Kt.AngleInstancedArraysExtRootUrl+i:Kt.WebGLRootUrl+e}}Kt.WebGL2RootUrl="https://developer.mozilla.org/en-US/docs/Web/API/WebGL2RenderingContext/",Kt.WebGLRootUrl="https://developer.mozilla.org/en-US/docs/Web/API/WebGLRenderingContext/",Kt.AngleInstancedArraysExtRootUrl="https://developer.mozilla.org/en-US/docs/Web/API/ANGLE_instanced_arrays/",Kt.WebGL2Functions={beginQuery:"beginQuery",beginTransformFeedback:"beginTransformFeedback",bindBufferBase:"bindBufferBase",bindBufferRange:"bindBufferRange",bindSampler:"bindSampler",bindTransformFeedback:"bindTransformFeedback",bindVertexArray:"bindVertexArray",blitFramebuffer:"blitFramebuffer",clearBufferfv:"clearBuffer",clearBufferiv:"clearBuffer",clearBufferuiv:"clearBuffer",clearBufferfi:"clearBuffer",clientWaitSync:"clientWaitSync",compressedTexImage3D:"compressedTexImage3D",compressedTexSubImage3D:"compressedTexSubImage3D",copyBufferSubData:"copyBufferSubData",copyTexSubImage3D:"copyTexSubImage3D",createQuery:"createQuery",createSampler:"createSampler",createTransformFeedback:"createTransformFeedback",createVertexArray:"createVertexArray",deleteQuery:"deleteQuery",deleteSampler:"deleteSampler",deleteSync:"deleteSync",deleteTransformFeedback:"deleteTransformFeedback",deleteVertexArray:"deleteVertexArray",drawArraysInstanced:"drawArraysInstanced",drawBuffers:"drawBuffers",drawElementsInstanced:"drawElementsInstanced",drawRangeElements:"drawRangeElements",endQuery:"endQuery",endTransformFeedback:"endTransformFeedback",fenceSync:"fenceSync",framebufferTextureLayer:"framebufferTextureLayer",getActiveUniformBlockName:"getActiveUniformBlockName",getActiveUniformBlockParameter:"getActiveUniformBlockParameter",getActiveUniforms:"getActiveUniforms",getBufferSubData:"getBufferSubData",getFragDataLocation:"getFragDataLocation",getIndexedParameter:"getIndexedParameter",getInternalformatParameter:"getInternalformatParameter",getQuery:"getQuery",getQueryParameter:"getQueryParameter",getSamplerParameter:"getSamplerParameter",getSyncParameter:"getSyncParameter",getTransformFeedbackVarying:"getTransformFeedbackVarying",getUniformBlockIndex:"getUniformBlockIndex",getUniformIndices:"getUniformIndices",invalidateFramebuffer:"invalidateFramebuffer",invalidateSubFramebuffer:"invalidateSubFramebuffer",isQuery:"isQuery",isSampler:"isSampler",isSync:"isSync",isTransformFeedback:"isTransformFeedback",isVertexArray:"isVertexArray",pauseTransformFeedback:"pauseTransformFeedback",readBuffer:"readBuffer",renderbufferStorageMultisample:"renderbufferStorageMultisample",resumeTransformFeedback:"resumeTransformFeedback",samplerParameteri:"samplerParameter",samplerParameterf:"samplerParameter",texImage3D:"texImage3D",texStorage2D:"texStorage2D",texStorage3D:"texStorage3D",texSubImage3D:"texSubImage3D",transformFeedbackVaryings:"transformFeedbackVaryings",uniform1ui:"uniform",uniform2ui:"uniform",uniform3ui:"uniform",uniform4ui:"uniform",uniform1fv:"uniform",uniform2fv:"uniform",uniform3fv:"uniform",uniform4fv:"uniform",uniform1iv:"uniform",uniform2iv:"uniform",uniform3iv:"uniform",uniform4iv:"uniform",uniform1uiv:"uniform",uniform2uiv:"uniform",uniform3uiv:"uniform",uniform4uiv:"uniform",uniformBlockBinding:"uniformBlockBinding",uniformMatrix2fv:"uniformMatrix",uniformMatrix3x2fv:"uniformMatrix",uniformMatrix4x2fv:"uniformMatrix",uniformMatrix2x3fv:"uniformMatrix",uniformMatrix3fv:"uniformMatrix",uniformMatrix4x3fv:"uniformMatrix",uniformMatrix2x4fv:"uniformMatrix",uniformMatrix3x4fv:"uniformMatrix",uniformMatrix4fv:"uniformMatrix",vertexAttribDivisor:"vertexAttribDivisor",vertexAttribI4i:"vertexAttribI",vertexAttribI4ui:"vertexAttribI",vertexAttribI4iv:"vertexAttribI",vertexAttribI4uiv:"vertexAttribI",vertexAttribIPointer:"vertexAttribIPointer",waitSync:"waitSync"},Kt.WebGLFunctions={uniform1f:"uniform",uniform1fv:"uniform",uniform1i:"uniform",uniform1iv:"uniform",uniform2f:"uniform",uniform2fv:"uniform",uniform2i:"uniform",uniform2iv:"uniform",uniform3f:"uniform",uniform3i:"uniform",uniform3iv:"uniform",uniform4f:"uniform",uniform4fv:"uniform",uniform4i:"uniform",uniform4iv:"uniform",uniformMatrix2fv:"uniformMatrix",uniformMatrix3fv:"uniformMatrix",uniformMatrix4fv:"uniformMatrix",vertexAttrib1f:"vertexAttrib",vertexAttrib2f:"vertexAttrib",vertexAttrib3f:"vertexAttrib",vertexAttrib4f:"vertexAttrib",vertexAttrib1fv:"vertexAttrib",vertexAttrib2fv:"vertexAttrib",vertexAttrib3fv:"vertexAttrib",vertexAttrib4fv:"vertexAttrib"},Kt.AngleInstancedArraysExtFunctions={drawArraysInstancedANGLE:"drawArraysInstancedANGLE",drawElementsInstancedANGLE:"drawElementsInstancedANGLE",vertexAttribDivisorANGLE:"vertexAttribDivisorANGLE"};class jt{constructor(e=null){this.rootPlaceHolder=e,this.onSourceCodeChanged=new o,this.rootPlaceHolder=this.rootPlaceHolder||document.body,this.mvx=new ft(this.rootPlaceHolder),this.searchText="",this.currentCommandId=-1,this.visible=!1,this.commandCount=0,this.commandListStateId=-1,this.commandDetailStateId=-1,this.currentCaptureStateId=-1,this.currentCommandStateId=-1,this.currentVisualStateId=-1,this.visualStateListStateId=-1,this.initVisualStateId=-1,this.sourceCodeComponentStateId=-1,this.captureListComponent=new wt,this.captureListItemComponent=new xt,this.visualStateListComponent=new yt,this.visualStateListItemComponent=new It,this.commandListComponent=new Ft,this.commandListItemComponent=new Nt,this.commandDetailComponent=new Mt,this.jsonContentComponent=new Ot,this.jsonGroupComponent=new Bt,this.jsonItemComponent=new $t,this.jsonImageItemComponent=new Pt,this.jsonHelpItemComponent=new kt,this.jsonVisualStateItemComponent=new Dt,this.resultViewMenuComponent=new Ut,this.resultViewContentComponent=new Gt,this.resultViewComponent=new Wt,this.sourceCodeComponent=new Xt,this.informationColumnComponent=new zt,this.rootStateId=this.mvx.addRootState(null,this.resultViewComponent),this.menuStateId=this.mvx.addChildState(this.rootStateId,null,this.resultViewMenuComponent),this.contentStateId=this.mvx.addChildState(this.rootStateId,null,this.resultViewContentComponent),this.captureListStateId=this.mvx.addChildState(this.rootStateId,!1,this.captureListComponent),this.initKeyboardEvents(),this.initMenuComponent(),this.captureListComponent.onCaptureLoaded.add((e=>{this.addCapture(e)})),this.captureListItemComponent.onCaptureSelected.add((e=>{this.selectCapture(e.stateId)})),this.captureListItemComponent.onSaveRequested.add((e=>{this.saveCapture(e.state.capture)})),this.visualStateListItemComponent.onVisualStateSelected.add((e=>{this.selectVisualState(e.stateId)})),this.commandListItemComponent.onCommandSelected.add((e=>{this.selectCommand(e.stateId)})),this.commandListItemComponent.onVertexSelected.add((e=>{this.selectCommand(e.stateId),this.openShader(!1)})),this.commandListItemComponent.onFragmentSelected.add((e=>{this.selectCommand(e.stateId),this.openShader(!0)})),this.sourceCodeComponent.onSourceCodeCloseClicked.add((()=>{this.displayCurrentCapture()})),this.sourceCodeComponent.onTranslatedVertexSourceClicked.add((e=>{const t=this.mvx.getGenericState(this.sourceCodeComponentStateId);t.fragment=!1,t.translated=!0,this.mvx.updateState(this.sourceCodeComponentStateId,t)})),this.sourceCodeComponent.onTranslatedFragmentSourceClicked.add((e=>{const t=this.mvx.getGenericState(this.sourceCodeComponentStateId);t.fragment=!0,t.translated=!0,this.mvx.updateState(this.sourceCodeComponentStateId,t)})),this.sourceCodeComponent.onVertexSourceClicked.add((e=>{const t=this.mvx.getGenericState(this.sourceCodeComponentStateId);t.fragment=!1,t.translated=!1,this.mvx.updateState(this.sourceCodeComponentStateId,t)})),this.sourceCodeComponent.onFragmentSourceClicked.add((e=>{const t=this.mvx.getGenericState(this.sourceCodeComponentStateId);t.fragment=!0,t.translated=!1,this.mvx.updateState(this.sourceCodeComponentStateId,t)})),this.sourceCodeComponent.onSourceCodeChanged.add((e=>{this.onSourceCodeChanged.trigger({programId:e.state.programId,sourceFragment:e.state.sourceFragment,sourceVertex:e.state.sourceVertex,translatedSourceFragment:e.state.translatedSourceFragment,translatedSourceVertex:e.state.translatedSourceVertex})})),this.sourceCodeComponent.onBeautifyChanged.add((e=>{const t=this.mvx.getGenericState(this.sourceCodeComponentStateId);t.beautify=e.sender.checked,this.mvx.updateState(this.sourceCodeComponentStateId,t)})),this.sourceCodeComponent.onPreprocessChanged.add((e=>{const t=this.mvx.getGenericState(this.sourceCodeComponentStateId);t.preprocessed=e.sender.checked,this.mvx.updateState(this.sourceCodeComponentStateId,t)})),this.updateViewState()}saveCapture(e){const t=JSON.stringify(e,null,4),n=new Blob([t],{type:"octet/stream"}),i="capture "+new Date(e.startTime).toTimeString().split(" ")[0]+".json";if(navigator.msSaveBlob)navigator.msSaveBlob(n,i);else{const e=document.createElement("a"),t=window.URL.createObjectURL(n);e.setAttribute("href",t),e.setAttribute("download",i),e.click()}}selectCapture(e){this.currentCommandId=-1,this.currentCaptureStateId=e,this.displayCurrentCapture()}selectCommand(e){this.currentCommandStateId=e,this.currentVisualStateId=this.displayCurrentCommand(),this.displayCurrentVisualState()}selectVisualState(e){this.currentVisualStateId=e,this.currentCommandStateId=this.displayCurrentVisualState(),this.displayCurrentCommand()}display(){this.visible=!0,this.updateViewState()}hide(){this.visible=!1,this.updateViewState()}addCapture(e){const t=this.mvx.insertChildState(this.captureListStateId,{capture:e,active:!1},0,this.captureListItemComponent);return this.selectCapture(t),t}showSourceCodeError(e){this.sourceCodeComponent.showError(e)}initKeyboardEvents(){this.rootPlaceHolder.addEventListener("keydown",(e=>{40===this.mvx.getGenericState(this.menuStateId).status&&(38===e.keyCode?(e.preventDefault(),e.stopPropagation(),this.selectPreviousCommand()):40===e.keyCode?(e.preventDefault(),e.stopPropagation(),this.selectNextCommand()):33===e.keyCode?(e.preventDefault(),e.stopPropagation(),this.selectPreviousVisualState()):34===e.keyCode&&(e.preventDefault(),e.stopPropagation(),this.selectNextVisualState()))}))}openShader(e){this.mvx.removeChildrenStates(this.contentStateId);const t=this.mvx.getGenericState(this.currentCommandStateId);this.sourceCodeComponentStateId=this.mvx.addChildState(this.contentStateId,{programId:t.capture.DrawCall.programStatus.program.__SPECTOR_Object_TAG.id,nameVertex:t.capture.DrawCall.shaders[0].name,nameFragment:t.capture.DrawCall.shaders[1].name,sourceVertex:t.capture.DrawCall.shaders[0].source,sourceFragment:t.capture.DrawCall.shaders[1].source,translatedSourceVertex:t.capture.DrawCall.shaders[0].translatedSource,translatedSourceFragment:t.capture.DrawCall.shaders[1].translatedSource,fragment:e,translated:!1,editable:t.capture.DrawCall.programStatus.RECOMPILABLE,beautify:!0},this.sourceCodeComponent),this.commandDetailStateId=this.mvx.addChildState(this.contentStateId,null,this.commandDetailComponent),this.displayCurrentCommandDetail(t)}selectPreviousCommand(){const e=this.mvx.getGenericState(this.currentCommandStateId);e.previousCommandStateId<0||this.selectCommand(e.previousCommandStateId)}selectNextCommand(){const e=this.mvx.getGenericState(this.currentCommandStateId);e.nextCommandStateId<0||this.selectCommand(e.nextCommandStateId)}selectPreviousVisualState(){const e=this.mvx.getGenericState(this.currentVisualStateId);e.previousVisualStateId<0||this.selectVisualState(e.previousVisualStateId)}selectNextVisualState(){const e=this.mvx.getGenericState(this.currentVisualStateId);e.nextVisualStateId<0||this.selectVisualState(e.nextVisualStateId)}initMenuComponent(){this.mvx.updateState(this.menuStateId,{status:0,searchText:this.searchText,commandCount:0}),this.resultViewMenuComponent.onCloseClicked.add((e=>{this.hide()})),this.resultViewMenuComponent.onCapturesClicked.add((e=>{this.displayCaptures()})),this.resultViewMenuComponent.onCommandsClicked.add((e=>{this.displayCurrentCapture()})),this.resultViewMenuComponent.onInformationClicked.add((e=>{this.displayInformation()})),this.resultViewMenuComponent.onInitStateClicked.add((e=>{this.displayInitState()})),this.resultViewMenuComponent.onEndStateClicked.add((e=>{this.displayEndState()})),this.resultViewMenuComponent.onSearchTextChanged.add((e=>{this.search(e.sender.value)})),this.resultViewMenuComponent.onSearchTextCleared.add((e=>{this.mvx.updateState(this.menuStateId,{status:e.state.status,searchText:"",commandCount:e.state.commandCount}),this.search("")}))}onCaptureRelatedAction(e){const t=this.mvx.getGenericState(this.currentCaptureStateId);return this.commandCount=t.capture.commands.length,this.mvx.removeChildrenStates(this.contentStateId),this.mvx.updateState(this.menuStateId,{status:e,searchText:this.searchText,commandCount:this.commandCount}),this.mvx.getGenericState(this.captureListStateId)&&this.mvx.updateState(this.captureListStateId,!1),t.capture}displayCaptures(){this.mvx.updateState(this.menuStateId,{status:0,searchText:this.searchText,commandCount:this.commandCount}),this.mvx.updateState(this.captureListStateId,!0)}displayInformation(){const e=this.onCaptureRelatedAction(10),t=this.mvx.addChildState(this.contentStateId,!0,this.informationColumnComponent),n=this.mvx.addChildState(this.contentStateId,!1,this.informationColumnComponent),i=this.mvx.addChildState(t,null,this.jsonContentComponent);this.displayJSONGroup(i,"Canvas",e.canvas),this.displayJSONGroup(i,"Context",e.context);const r=this.mvx.addChildState(n,null,this.jsonContentComponent);for(const t of e.analyses)"Primitives"===t.analyserName?this.displayJSONGroup(r,"Vertices count",t):this.displayJSONGroup(r,t.analyserName,t);this.displayJSONGroup(r,"Frame Memory Changes",e.frameMemory),this.displayJSONGroup(r,"Total Memory (seconds since application start: bytes)",e.memory)}displayJSON(e,t){t.VisualState&&this.mvx.addChildState(e,t.VisualState,this.jsonVisualStateItemComponent);for(const n in t){if("VisualState"===n||"analyserName"===n||"source"===n||"translatedSource"===n)continue;const i=t[n];if("visual"===n)for(const n in i)i.hasOwnProperty(n)&&i[n]&&this.mvx.addChildState(e,{key:n,value:i[n],pixelated:"NEAREST"===t.samplerMagFilter||"NEAREST"===t.magFilter},this.jsonImageItemComponent);else{const t=this.getJSONAsString(e,n,i);if(null==t)continue;if(this.toFilter(n)&&this.toFilter(i))continue;this.mvx.addChildState(e,{key:n,value:t},this.jsonItemComponent)}i&&i.__SPECTOR_Metadata&&this.displayJSONGroup(e,"Metadata",i.__SPECTOR_Metadata)}}getJSONAsString(e,t,n){if(null===n)return"null";if(void 0===n)return"undefined";if("number"==typeof n)return Math.floor(n)===n?n.toFixed(0):n.toFixed(4);if("string"==typeof n)return n;if("boolean"==typeof n)return n?"true":"false";if(0===n.length)return"Empty Array";if(n.length){const i=[];for(let r=0;r<n.length;r++){const s=this.getJSONAsString(e,`${t}(${r.toFixed(0)})`,n[r]);null!==s&&i.push(s)}return 0===i.length?null:i.join(", ")}return n.help?(this.mvx.addChildState(e,{key:t,value:n.name,help:n.help},this.jsonHelpItemComponent),null):n.__SPECTOR_Object_TAG?n.__SPECTOR_Object_TAG.displayText:n.displayText?n.displayText:("object"==typeof n&&this.displayJSONGroup(e,t,n),null)}displayJSONGroup(e,t,n){if(!n)return;const i=this.mvx.addChildState(e,t,this.jsonGroupComponent);this.displayJSON(i,n),this.mvx.hasChildren(i)||this.mvx.removeState(i)}displayInitState(){const e=this.onCaptureRelatedAction(20),t=this.mvx.addChildState(this.contentStateId,null,this.jsonContentComponent);this.displayJSON(t,e.initState)}displayEndState(){const e=this.onCaptureRelatedAction(30),t=this.mvx.addChildState(this.contentStateId,null,this.jsonContentComponent);this.displayJSON(t,e.endState)}displayCurrentCapture(){const e=this.onCaptureRelatedAction(40);this.mvx.updateAllChildrenGenericState(this.captureListStateId,(e=>(e.active=!1,e))),this.mvx.updateState(this.currentCaptureStateId,{capture:e,active:!0}),this.createVisualStates(e),this.commandListStateId=this.mvx.addChildState(this.contentStateId,null,this.commandListComponent),this.commandDetailStateId=this.mvx.addChildState(this.contentStateId,null,this.commandDetailComponent),this.createCommands(e)}displayCurrentCommand(){if(40!==this.mvx.getGenericState(this.menuStateId).status)return-1;const e=this.mvx.getGenericState(this.currentCommandStateId),t=e.capture;return this.currentCommandId=t.id,this.mvx.updateAllChildrenGenericState(this.commandListStateId,(e=>(e.active=!1,e))),this.mvx.updateState(this.currentCommandStateId,{capture:t,visualStateId:e.visualStateId,previousCommandStateId:e.previousCommandStateId,nextCommandStateId:e.nextCommandStateId,active:!0}),this.displayCurrentCommandDetail(e)}displayCurrentCommandDetail(e){const t=e.capture;this.mvx.removeChildrenStates(this.commandDetailStateId);const n=this.mvx.getGenericState(e.visualStateId);this.mvx.addChildState(this.commandDetailStateId,n.VisualState,this.jsonVisualStateItemComponent);let i="Unknown";switch(t.status){case 50:i="Deprecated";break;case 10:i="Unused";break;case 20:i="Disabled";break;case 30:i="Redundant";break;case 40:i="Valid"}const r=Kt.getMDNLink(t.name);t.result?this.displayJSONGroup(this.commandDetailStateId,"Global",{name:{help:r,name:t.name},duration:t.commandEndTime-t.startTime,result:t.result,status:i}):"LOG"!==t.name&&this.displayJSONGroup(this.commandDetailStateId,"Global",{name:{help:r,name:t.name},duration:t.commandEndTime-t.startTime,status:i});for(const e in t)"VisualState"!==e&&"result"!==e&&"object"==typeof t[e]&&this.displayJSONGroup(this.commandDetailStateId,e,t[e]);return e.visualStateId}displayCurrentVisualState(){if(40!==this.mvx.getGenericState(this.menuStateId).status)return null;const e=this.mvx.getGenericState(this.currentVisualStateId);return e.commandStateId===Number.MIN_VALUE?this.displayInitState():e.commandStateId===Number.MAX_VALUE&&this.displayEndState(),this.mvx.updateAllChildrenGenericState(this.visualStateListStateId,(e=>(e.active=!1,e))),e.active=!0,this.mvx.updateState(this.currentVisualStateId,e),e.commandStateId}createVisualStates(e){this.visualStateListStateId=this.mvx.addChildState(this.contentStateId,null,this.visualStateListComponent),this.mvx.removeChildrenStates(this.visualStateListStateId),this.initVisualStateId=this.mvx.addChildState(this.visualStateListStateId,{VisualState:e.initState.VisualState,time:e.startTime,commandStateId:Number.MIN_VALUE,active:!1},this.visualStateListItemComponent)}createCommands(e){this.mvx.removeChildrenStates(this.commandListStateId);let t=this.initVisualStateId,n=!1,i=null,r=-1,s=null,o=-1;for(let a=0;a<e.commands.length;a++){const l=e.commands[a];if(this.toFilter(l.marker)&&this.toFilter(l.name)&&l.id!==this.currentCommandId&&("LOG"!==l.name||this.toFilter(l.text)))continue;const c={capture:l,previousCommandStateId:r,nextCommandStateId:-1,visualStateId:void 0,active:!1},u=this.mvx.addChildState(this.commandListStateId,c,this.commandListItemComponent);if(i&&(i=this.mvx.getGenericState(r),i.nextCommandStateId=u,this.mvx.updateState(r,i)),r=u,i=c,l.VisualState){const e={VisualState:l.VisualState,time:l.endTime,commandStateId:u,active:!1,previousVisualStateId:o,nextVisualStateId:-1};t=this.mvx.addChildState(this.visualStateListStateId,e,this.visualStateListItemComponent),s&&(s=this.mvx.getGenericState(o),s.nextVisualStateId=t,this.mvx.updateState(o,s)),s=e,o=t,n=!0}else if(!n){const e=this.mvx.getGenericState(this.initVisualStateId);e.commandStateId=u,e.previousVisualStateId=-1,e.nextVisualStateId=-1,this.mvx.updateState(this.initVisualStateId,e),s=e,o=t,n=!0}c.visualStateId=t,this.mvx.updateState(u,c),(-1===this.currentCommandId&&0===a||this.currentCommandId===l.id)&&(this.currentCommandStateId=u,this.displayCurrentCommand(),this.currentVisualStateId=t,this.displayCurrentVisualState())}}updateViewState(){this.mvx.updateState(this.rootStateId,this.visible)}toFilter(e){return e=(e+="").toLowerCase(),!!(this.searchText&&this.searchText.length>2&&-1===e.indexOf(this.searchText.toLowerCase()))}search(e){switch(this.searchText=e,this.mvx.getGenericState(this.menuStateId).status){case 0:case 40:this.displayCurrentCapture();break;case 30:this.displayEndState();break;case 10:this.displayInformation();break;case 20:this.displayInitState()}this.searchText=""}}class Yt{constructor(e){this.timeSpy=e,this.init()}spyXRSession(e){this.currentXRSession&&this.unspyXRSession();for(const e of Ze.getRequestAnimationFrameFunctionNames())A.resetOriginFunction(this.timeSpy.getSpiedScope(),e);this.timeSpy.spyRequestAnimationFrame("requestAnimationFrame",e),this.currentXRSession=e}unspyXRSession(){if(this.currentXRSession){A.resetOriginFunction(this.currentXRSession,"requestAnimationFrame"),this.currentXRSession=void 0;for(const e of Ze.getRequestAnimationFrameFunctionNames())this.timeSpy.spyRequestAnimationFrame(e,this.timeSpy.getSpiedScope())}}init(){if(!navigator.xr)return;class e extends XRWebGLLayer{constructor(e,t,n){super(e,t,n),this.glContext=t}getContext(){return this.glContext}}class t extends XRWebGLBinding{constructor(e,t){super(e,t),this.glContext=t}createProjectionLayer(e){const t=super.createProjectionLayer(e);return t.glContext=this.glContext,t}}window.XRWebGLLayer=e,window.XRWebGLBinding=t;const n=navigator.xr.requestSession;Object.defineProperty(navigator.xr,"requestSessionInternal",{writable:!0}),navigator.xr.requestSessionInternal=n,Object.defineProperty(navigator.xr,"requestSession",{writable:!0}),navigator.xr.requestSession=(e,t)=>((e,t)=>navigator.xr.requestSessionInternal(e,t).then((e=>{const t=e;return t._updateRenderState=e.updateRenderState,t.updateRenderState=e=>{return n=this,i=void 0,s=function*(){if(e.baseLayer){const n=e.baseLayer;t.glContext=n.getContext()}if(e.layers)for(const n of e.layers){const e=n;e.glContext&&(t.glContext=e.glContext)}return t._updateRenderState(e)},new((r=void 0)||(r=Promise))((function(e,t){function o(e){try{l(s.next(e))}catch(e){t(e)}}function a(e){try{l(s.throw(e))}catch(e){t(e)}}function l(t){var n;t.done?e(t.value):(n=t.value,n instanceof r?n:new r((function(e){e(n)}))).then(o,a)}l((s=s.apply(n,i||[])).next())}));var n,i,r,s},this.spyXRSession(t),e.addEventListener("end",(()=>{this.unspyXRSession()})),Promise.resolve(e)})))(e,t)}}const qt={CaptureMenu:St,ResultView:jt};class Zt{constructor(e={}){this.noFrameTimeout=-1,this.options=Object.assign({enableXRCapture:!1},e),this.captureNextFrames=0,this.captureNextCommands=0,this.quickCapture=!1,this.fullCapture=!1,this.retry=0,this.contexts=[],this.timeSpy=new Ze,this.onCaptureStarted=new o,this.onCapture=new o,this.onError=new o,this.timeSpy.onFrameStart.add(this.onFrameStart,this),this.timeSpy.onFrameEnd.add(this.onFrameEnd,this),this.timeSpy.onError.add(this.onErrorInternal,this),this.options.enableXRCapture&&(this.xrSpy=new Yt(this.timeSpy))}static getFirstAvailable3dContext(e){return this.tryGetContextFromHelperField(e)||this.tryGetContextFromCanvas(e,"webgl")||this.tryGetContextFromCanvas(e,"experimental-webgl")||this.tryGetContextFromCanvas(e,"webgl2")||this.tryGetContextFromCanvas(e,"experimental-webgl2")}static tryGetContextFromHelperField(e){const t=e instanceof HTMLCanvasElement?e.getAttribute("__spector_context_type"):e.__spector_context_type;if(t)return this.tryGetContextFromCanvas(e,t)}static tryGetContextFromCanvas(e,t){let n;try{n=e.getContext(t)}catch(e){}return n}displayUI(e=!1){this.captureMenu||(this.getCaptureUI(),this.captureMenu.onPauseRequested.add(this.pause,this),this.captureMenu.onPlayRequested.add(this.play,this),this.captureMenu.onPlayNextFrameRequested.add(this.playNextFrame,this),this.captureMenu.onCaptureRequested.add((e=>{e&&this.captureCanvas(e.ref)}),this),setInterval((()=>{this.captureMenu.setFPS(this.getFps())}),1e3),e||this.captureMenu.trackPageCanvases(),this.captureMenu.display()),this.resultView||(this.getResultUI(),this.onCapture.add((e=>{this.resultView.display(),this.resultView.addCapture(e)})))}getResultUI(){return this.resultView||(this.resultView=new jt,this.resultView.onSourceCodeChanged.add((e=>{this.rebuildProgramFromProgramId(e.programId,e.sourceVertex,e.sourceFragment,(t=>{this.referenceNewProgram(e.programId,t),this.resultView.showSourceCodeError(null)}),(e=>{this.resultView.showSourceCodeError(e)}))}))),this.resultView}getCaptureUI(){return this.captureMenu||(this.captureMenu=new St),this.captureMenu}rebuildProgramFromProgramId(e,t,n,i,r){const s=we.getFromGlobalStore(e);this.rebuildProgram(s,t,n,i,r)}rebuildProgram(e,t,n,r,s){i.rebuildProgram(e,t,n,r,s)}referenceNewProgram(e,t){we.updateInGlobalStore(e,t)}pause(){this.timeSpy.changeSpeedRatio(0)}play(){this.timeSpy.changeSpeedRatio(1)}playNextFrame(){this.timeSpy.playNextFrame()}drawOnlyEveryXFrame(e){this.timeSpy.changeSpeedRatio(e)}getFps(){return this.timeSpy.getFps()}spyCanvases(){this.canvasSpy?this.onErrorInternal("Already spying canvas."):(this.canvasSpy=new Qe,this.canvasSpy.onContextRequested.add(this.spyContext,this))}spyCanvas(e){this.canvasSpy?this.onErrorInternal("Already spying canvas."):(this.canvasSpy=new Qe(e),this.canvasSpy.onContextRequested.add(this.spyContext,this))}getAvailableContexts(){return this.getAvailableContexts()}captureCanvas(e,t=0,n=!1,i=!1){const r=this.getAvailableContextSpyByCanvas(e);if(r)this.captureContextSpy(r,t,n,i);else{const r=Zt.getFirstAvailable3dContext(e);r?this.captureContext(r,t,n,i):s.error("No webgl context available on the chosen canvas.")}}captureContext(e,t=0,n=!1,i=!1){let r=this.getAvailableContextSpyByCanvas(e.canvas);r||(r=e.getIndexedParameter?new qe({context:e,version:2,recordAlways:!1}):new qe({context:e,version:1,recordAlways:!1}),r.onMaxCommand.add(this.stopCapture,this),this.contexts.push({canvas:r.context.canvas,contextSpy:r})),r&&this.captureContextSpy(r,t,n,i)}captureXRContext(e=0,t=!1,n=!1){this.captureContext(this.getXRContext(),e,t,n)}captureContextSpy(e,t=0,n=!1,i=!1){this.quickCapture=n,this.fullCapture=i,this.capturingContext?this.onErrorInternal("Already capturing a context."):(this.retry=0,this.capturingContext=e,this.capturingContext.setMarker(this.marker),(t=Math.min(t,1e4))>0?this.captureCommands(t):this.captureFrames(1),this.noFrameTimeout=setTimeout((()=>{t>0?this.stopCapture():this.capturingContext&&this.retry>1?this.onErrorInternal("No frames with gl commands detected. Try moving the camera."):this.onErrorInternal("No frames detected. Try moving the camera or implementing requestAnimationFrame.")}),1e4))}captureNextFrame(e,t=!1,n=!1){e instanceof HTMLCanvasElement||self.OffscreenCanvas&&e instanceof OffscreenCanvas?this.captureCanvas(e,0,t,n):this.captureContext(e,0,t,n)}startCapture(e,t,n=!1,i=!1){e instanceof HTMLCanvasElement||self.OffscreenCanvas&&e instanceof OffscreenCanvas?this.captureCanvas(e,t,n,i):this.captureContext(e,t,n,i)}stopCapture(){if(this.capturingContext){const e=this.capturingContext.stopCapture();if(e.commands.length>0)return this.noFrameTimeout>-1&&clearTimeout(this.noFrameTimeout),this.triggerCapture(e),this.capturingContext=void 0,this.captureNextFrames=0,this.captureNextCommands=0,e;0===this.captureNextCommands&&(this.retry++,this.captureFrames(1))}}setMarker(e){this.marker=e,this.capturingContext&&this.capturingContext.setMarker(e)}clearMarker(){this.marker=null,this.capturingContext&&this.capturingContext.clearMarker()}addRequestAnimationFrameFunctionName(e){this.timeSpy.addRequestAnimationFrameFunctionName(e)}setSpiedScope(e){this.timeSpy.setSpiedScope(e)}log(e){this.capturingContext&&this.capturingContext.log(e)}captureFrames(e){this.captureNextFrames=e,this.captureNextCommands=0,this.playNextFrame()}captureCommands(e){this.captureNextFrames=0,this.captureNextCommands=e,this.play(),this.capturingContext?(this.onCaptureStarted.trigger(void 0),this.capturingContext.startCapture(e,this.quickCapture,this.fullCapture)):(this.onErrorInternal("No context to capture from."),this.captureNextCommands=0)}spyContext(e){let t=this.getAvailableContextSpyByCanvas(e.context.canvas);t||(t=new qe({context:e.context,version:e.contextVersion,recordAlways:!0}),t.onMaxCommand.add(this.stopCapture,this),this.contexts.push({canvas:t.context.canvas,contextSpy:t})),t.spy()}getAvailableContextSpyByCanvas(e){for(const t of this.contexts)if(t.canvas===e)return t.contextSpy}getXRContext(){return this.options.enableXRCapture||s.error("Cannot retrieve WebXR context if capturing WebXR is disabled."),this.xrSpy.currentXRSession||s.error("No currently active WebXR session."),this.xrSpy.currentXRSession.glContext}onFrameStart(){this.captureNextCommands>0||(this.captureNextFrames>0?(this.capturingContext&&(this.onCaptureStarted.trigger(void 0),this.capturingContext.startCapture(0,this.quickCapture,this.fullCapture)),this.captureNextFrames--):this.capturingContext=void 0)}onFrameEnd(){this.captureNextCommands>0||0===this.captureNextFrames&&this.stopCapture()}triggerCapture(e){this.captureMenu&&this.captureMenu.captureComplete(null),this.onCapture.trigger(e)}onErrorInternal(e){if(s.error(e),this.noFrameTimeout>-1&&clearTimeout(this.noFrameTimeout),!this.capturingContext)throw e;this.capturingContext=void 0,this.captureNextFrames=0,this.captureNextCommands=0,this.retry=0,this.captureMenu&&this.captureMenu.captureComplete(e),this.onError.trigger(e)}}},18:(e,t,n)=>{e=n.nmd(e),ace.define("ace/ext/searchbox",["require","exports","module","ace/lib/dom","ace/lib/lang","ace/lib/event","ace/keyboard/hash_handler","ace/lib/keys"],(function(e,t,n){"use strict";var i=e("../lib/dom"),r=e("../lib/lang"),s=e("../lib/event"),o='.ace_search {background-color: #ddd;color: #666;border: 1px solid #cbcbcb;border-top: 0 none;overflow: hidden;margin: 0;padding: 4px 6px 0 4px;position: absolute;top: 0;z-index: 99;white-space: normal;}.ace_search.left {border-left: 0 none;border-radius: 0px 0px 5px 0px;left: 0;}.ace_search.right {border-radius: 0px 0px 0px 5px;border-right: 0 none;right: 0;}.ace_search_form, .ace_replace_form {margin: 0 20px 4px 0;overflow: hidden;line-height: 1.9;}.ace_replace_form {margin-right: 0;}.ace_search_form.ace_nomatch {outline: 1px solid red;}.ace_search_field {border-radius: 3px 0 0 3px;background-color: white;color: black;border: 1px solid #cbcbcb;border-right: 0 none;outline: 0;padding: 0;font-size: inherit;margin: 0;line-height: inherit;padding: 0 6px;min-width: 17em;vertical-align: top;min-height: 1.8em;box-sizing: content-box;}.ace_searchbtn {border: 1px solid #cbcbcb;line-height: inherit;display: inline-block;padding: 0 6px;background: #fff;border-right: 0 none;border-left: 1px solid #dcdcdc;cursor: pointer;margin: 0;position: relative;color: #666;}.ace_searchbtn:last-child {border-radius: 0 3px 3px 0;border-right: 1px solid #cbcbcb;}.ace_searchbtn:disabled {background: none;cursor: default;}.ace_searchbtn:hover {background-color: #eef1f6;}.ace_searchbtn.prev, .ace_searchbtn.next {padding: 0px 0.7em}.ace_searchbtn.prev:after, .ace_searchbtn.next:after {content: "";border: solid 2px #888;width: 0.5em;height: 0.5em;border-width:  2px 0 0 2px;display:inline-block;transform: rotate(-45deg);}.ace_searchbtn.next:after {border-width: 0 2px 2px 0 ;}.ace_searchbtn_close {background: url(data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAA4AAAAcCAYAAABRVo5BAAAAZ0lEQVR42u2SUQrAMAhDvazn8OjZBilCkYVVxiis8H4CT0VrAJb4WHT3C5xU2a2IQZXJjiQIRMdkEoJ5Q2yMqpfDIo+XY4k6h+YXOyKqTIj5REaxloNAd0xiKmAtsTHqW8sR2W5f7gCu5nWFUpVjZwAAAABJRU5ErkJggg==) no-repeat 50% 0;border-radius: 50%;border: 0 none;color: #656565;cursor: pointer;font: 16px/16px Arial;padding: 0;height: 14px;width: 14px;top: 9px;right: 7px;position: absolute;}.ace_searchbtn_close:hover {background-color: #656565;background-position: 50% 100%;color: white;}.ace_button {margin-left: 2px;cursor: pointer;-webkit-user-select: none;-moz-user-select: none;-o-user-select: none;-ms-user-select: none;user-select: none;overflow: hidden;opacity: 0.7;border: 1px solid rgba(100,100,100,0.23);padding: 1px;box-sizing:    border-box!important;color: black;}.ace_button:hover {background-color: #eee;opacity:1;}.ace_button:active {background-color: #ddd;}.ace_button.checked {border-color: #3399ff;opacity:1;}.ace_search_options{margin-bottom: 3px;text-align: right;-webkit-user-select: none;-moz-user-select: none;-o-user-select: none;-ms-user-select: none;user-select: none;clear: both;}.ace_search_counter {float: left;font-family: arial;padding: 0 8px;}',a=e("../keyboard/hash_handler").HashHandler,l=e("../lib/keys");i.importCssString(o,"ace_searchbox");var c=function(e,t,n){var r=i.createElement("div");i.buildDom(["div",{class:"ace_search right"},["span",{action:"hide",class:"ace_searchbtn_close"}],["div",{class:"ace_search_form"},["input",{class:"ace_search_field",placeholder:"Search for",spellcheck:"false"}],["span",{action:"findPrev",class:"ace_searchbtn prev"},"​"],["span",{action:"findNext",class:"ace_searchbtn next"},"​"],["span",{action:"findAll",class:"ace_searchbtn",title:"Alt-Enter"},"All"]],["div",{class:"ace_replace_form"},["input",{class:"ace_search_field",placeholder:"Replace with",spellcheck:"false"}],["span",{action:"replaceAndFindNext",class:"ace_searchbtn"},"Replace"],["span",{action:"replaceAll",class:"ace_searchbtn"},"All"]],["div",{class:"ace_search_options"},["span",{action:"toggleReplace",class:"ace_button",title:"Toggle Replace mode",style:"float:left;margin-top:-2px;padding:0 5px;"},"+"],["span",{class:"ace_search_counter"}],["span",{action:"toggleRegexpMode",class:"ace_button",title:"RegExp Search"},".*"],["span",{action:"toggleCaseSensitive",class:"ace_button",title:"CaseSensitive Search"},"Aa"],["span",{action:"toggleWholeWords",class:"ace_button",title:"Whole Word Search"},"\\b"],["span",{action:"searchInSelection",class:"ace_button",title:"Search In Selection"},"S"]]],r),this.element=r.firstChild,this.setSession=this.setSession.bind(this),this.$init(),this.setEditor(e),i.importCssString(o,"ace_searchbox",e.container)};(function(){this.setEditor=function(e){e.searchBox=this,e.renderer.scroller.appendChild(this.element),this.editor=e},this.setSession=function(e){this.searchRange=null,this.$syncOptions(!0)},this.$initElements=function(e){this.searchBox=e.querySelector(".ace_search_form"),this.replaceBox=e.querySelector(".ace_replace_form"),this.searchOption=e.querySelector("[action=searchInSelection]"),this.replaceOption=e.querySelector("[action=toggleReplace]"),this.regExpOption=e.querySelector("[action=toggleRegexpMode]"),this.caseSensitiveOption=e.querySelector("[action=toggleCaseSensitive]"),this.wholeWordOption=e.querySelector("[action=toggleWholeWords]"),this.searchInput=this.searchBox.querySelector(".ace_search_field"),this.replaceInput=this.replaceBox.querySelector(".ace_search_field"),this.searchCounter=e.querySelector(".ace_search_counter")},this.$init=function(){var e=this.element;this.$initElements(e);var t=this;s.addListener(e,"mousedown",(function(e){setTimeout((function(){t.activeInput.focus()}),0),s.stopPropagation(e)})),s.addListener(e,"click",(function(e){var n=(e.target||e.srcElement).getAttribute("action");n&&t[n]?t[n]():t.$searchBarKb.commands[n]&&t.$searchBarKb.commands[n].exec(t),s.stopPropagation(e)})),s.addCommandKeyListener(e,(function(e,n,i){var r=l.keyCodeToString(i),o=t.$searchBarKb.findKeyCommand(n,r);o&&o.exec&&(o.exec(t),s.stopEvent(e))})),this.$onChange=r.delayedCall((function(){t.find(!1,!1)})),s.addListener(this.searchInput,"input",(function(){t.$onChange.schedule(20)})),s.addListener(this.searchInput,"focus",(function(){t.activeInput=t.searchInput,t.searchInput.value&&t.highlight()})),s.addListener(this.replaceInput,"focus",(function(){t.activeInput=t.replaceInput,t.searchInput.value&&t.highlight()}))},this.$closeSearchBarKb=new a([{bindKey:"Esc",name:"closeSearchBar",exec:function(e){e.searchBox.hide()}}]),this.$searchBarKb=new a,this.$searchBarKb.bindKeys({"Ctrl-f|Command-f":function(e){var t=e.isReplace=!e.isReplace;e.replaceBox.style.display=t?"":"none",e.replaceOption.checked=!1,e.$syncOptions(),e.searchInput.focus()},"Ctrl-H|Command-Option-F":function(e){e.editor.getReadOnly()||(e.replaceOption.checked=!0,e.$syncOptions(),e.replaceInput.focus())},"Ctrl-G|Command-G":function(e){e.findNext()},"Ctrl-Shift-G|Command-Shift-G":function(e){e.findPrev()},esc:function(e){setTimeout((function(){e.hide()}))},Return:function(e){e.activeInput==e.replaceInput&&e.replace(),e.findNext()},"Shift-Return":function(e){e.activeInput==e.replaceInput&&e.replace(),e.findPrev()},"Alt-Return":function(e){e.activeInput==e.replaceInput&&e.replaceAll(),e.findAll()},Tab:function(e){(e.activeInput==e.replaceInput?e.searchInput:e.replaceInput).focus()}}),this.$searchBarKb.addCommands([{name:"toggleRegexpMode",bindKey:{win:"Alt-R|Alt-/",mac:"Ctrl-Alt-R|Ctrl-Alt-/"},exec:function(e){e.regExpOption.checked=!e.regExpOption.checked,e.$syncOptions()}},{name:"toggleCaseSensitive",bindKey:{win:"Alt-C|Alt-I",mac:"Ctrl-Alt-R|Ctrl-Alt-I"},exec:function(e){e.caseSensitiveOption.checked=!e.caseSensitiveOption.checked,e.$syncOptions()}},{name:"toggleWholeWords",bindKey:{win:"Alt-B|Alt-W",mac:"Ctrl-Alt-B|Ctrl-Alt-W"},exec:function(e){e.wholeWordOption.checked=!e.wholeWordOption.checked,e.$syncOptions()}},{name:"toggleReplace",exec:function(e){e.replaceOption.checked=!e.replaceOption.checked,e.$syncOptions()}},{name:"searchInSelection",exec:function(e){e.searchOption.checked=!e.searchRange,e.setSearchRange(e.searchOption.checked&&e.editor.getSelectionRange()),e.$syncOptions()}}]),this.setSearchRange=function(e){this.searchRange=e,e?this.searchRangeMarker=this.editor.session.addMarker(e,"ace_active-line"):this.searchRangeMarker&&(this.editor.session.removeMarker(this.searchRangeMarker),this.searchRangeMarker=null)},this.$syncOptions=function(e){i.setCssClass(this.replaceOption,"checked",this.searchRange),i.setCssClass(this.searchOption,"checked",this.searchOption.checked),this.replaceOption.textContent=this.replaceOption.checked?"-":"+",i.setCssClass(this.regExpOption,"checked",this.regExpOption.checked),i.setCssClass(this.wholeWordOption,"checked",this.wholeWordOption.checked),i.setCssClass(this.caseSensitiveOption,"checked",this.caseSensitiveOption.checked);var t=this.editor.getReadOnly();this.replaceOption.style.display=t?"none":"",this.replaceBox.style.display=this.replaceOption.checked&&!t?"":"none",this.find(!1,!1,e)},this.highlight=function(e){this.editor.session.highlight(e||this.editor.$search.$options.re),this.editor.renderer.updateBackMarkers()},this.find=function(e,t,n){var r=!this.editor.find(this.searchInput.value,{skipCurrent:e,backwards:t,wrap:!0,regExp:this.regExpOption.checked,caseSensitive:this.caseSensitiveOption.checked,wholeWord:this.wholeWordOption.checked,preventScroll:n,range:this.searchRange})&&this.searchInput.value;i.setCssClass(this.searchBox,"ace_nomatch",r),this.editor._emit("findSearchBox",{match:!r}),this.highlight(),this.updateCounter()},this.updateCounter=function(){var e=this.editor,t=e.$search.$options.re,n=0,i=0;if(t){var r=this.searchRange?e.session.getTextRange(this.searchRange):e.getValue(),s=e.session.doc.positionToIndex(e.selection.anchor);this.searchRange&&(s-=e.session.doc.positionToIndex(this.searchRange.start));for(var o,a=t.lastIndex=0;(o=t.exec(r))&&(n++,(a=o.index)<=s&&i++,!(n>999))&&(o[0]||(t.lastIndex=a+=1,!(a>=r.length))););}this.searchCounter.textContent=i+" of "+(n>999?"999+":n)},this.findNext=function(){this.find(!0,!1)},this.findPrev=function(){this.find(!0,!0)},this.findAll=function(){var e=!this.editor.findAll(this.searchInput.value,{regExp:this.regExpOption.checked,caseSensitive:this.caseSensitiveOption.checked,wholeWord:this.wholeWordOption.checked})&&this.searchInput.value;i.setCssClass(this.searchBox,"ace_nomatch",e),this.editor._emit("findSearchBox",{match:!e}),this.highlight(),this.hide()},this.replace=function(){this.editor.getReadOnly()||this.editor.replace(this.replaceInput.value)},this.replaceAndFindNext=function(){this.editor.getReadOnly()||(this.editor.replace(this.replaceInput.value),this.findNext())},this.replaceAll=function(){this.editor.getReadOnly()||this.editor.replaceAll(this.replaceInput.value)},this.hide=function(){this.active=!1,this.setSearchRange(null),this.editor.off("changeSession",this.setSession),this.element.style.display="none",this.editor.keyBinding.removeKeyboardHandler(this.$closeSearchBarKb),this.editor.focus()},this.show=function(e,t){this.active=!0,this.editor.on("changeSession",this.setSession),this.element.style.display="",this.replaceOption.checked=t,e&&(this.searchInput.value=e),this.searchInput.focus(),this.searchInput.select(),this.editor.keyBinding.addKeyboardHandler(this.$closeSearchBarKb),this.$syncOptions(!0)},this.isFocused=function(){var e=document.activeElement;return e==this.searchInput||e==this.replaceInput}}).call(c.prototype),t.SearchBox=c,t.Search=function(e,t){(e.searchBox||new c(e)).show(e.session.getTextRange(),t)}})),ace.require(["ace/ext/searchbox"],(function(t){e&&(e.exports=t)}))},176:(e,t,n)=>{e=n.nmd(e),ace.define("ace/mode/doc_comment_highlight_rules",["require","exports","module","ace/lib/oop","ace/mode/text_highlight_rules"],(function(e,t,n){"use strict";var i=e("../lib/oop"),r=e("./text_highlight_rules").TextHighlightRules,s=function(){this.$rules={start:[{token:"comment.doc.tag",regex:"@[\\w\\d_]+"},s.getTagRule(),{defaultToken:"comment.doc",caseInsensitive:!0}]}};i.inherits(s,r),s.getTagRule=function(e){return{token:"comment.doc.tag.storage.type",regex:"\\b(?:TODO|FIXME|XXX|HACK)\\b"}},s.getStartRule=function(e){return{token:"comment.doc",regex:"\\/\\*(?=\\*)",next:e}},s.getEndRule=function(e){return{token:"comment.doc",regex:"\\*\\/",next:e}},t.DocCommentHighlightRules=s})),ace.define("ace/mode/c_cpp_highlight_rules",["require","exports","module","ace/lib/oop","ace/mode/doc_comment_highlight_rules","ace/mode/text_highlight_rules"],(function(e,t,n){"use strict";var i=e("../lib/oop"),r=e("./doc_comment_highlight_rules").DocCommentHighlightRules,s=e("./text_highlight_rules").TextHighlightRules,o=t.cFunctions="\\b(?:hypot(?:f|l)?|s(?:scanf|ystem|nprintf|ca(?:nf|lb(?:n(?:f|l)?|ln(?:f|l)?))|i(?:n(?:h(?:f|l)?|f|l)?|gn(?:al|bit))|tr(?:s(?:tr|pn)|nc(?:py|at|mp)|c(?:spn|hr|oll|py|at|mp)|to(?:imax|d|u(?:l(?:l)?|max)|k|f|l(?:d|l)?)|error|pbrk|ftime|len|rchr|xfrm)|printf|et(?:jmp|vbuf|locale|buf)|qrt(?:f|l)?|w(?:scanf|printf)|rand)|n(?:e(?:arbyint(?:f|l)?|xt(?:toward(?:f|l)?|after(?:f|l)?))|an(?:f|l)?)|c(?:s(?:in(?:h(?:f|l)?|f|l)?|qrt(?:f|l)?)|cos(?:h(?:f)?|f|l)?|imag(?:f|l)?|t(?:ime|an(?:h(?:f|l)?|f|l)?)|o(?:s(?:h(?:f|l)?|f|l)?|nj(?:f|l)?|pysign(?:f|l)?)|p(?:ow(?:f|l)?|roj(?:f|l)?)|e(?:il(?:f|l)?|xp(?:f|l)?)|l(?:o(?:ck|g(?:f|l)?)|earerr)|a(?:sin(?:h(?:f|l)?|f|l)?|cos(?:h(?:f|l)?|f|l)?|tan(?:h(?:f|l)?|f|l)?|lloc|rg(?:f|l)?|bs(?:f|l)?)|real(?:f|l)?|brt(?:f|l)?)|t(?:ime|o(?:upper|lower)|an(?:h(?:f|l)?|f|l)?|runc(?:f|l)?|gamma(?:f|l)?|mp(?:nam|file))|i(?:s(?:space|n(?:ormal|an)|cntrl|inf|digit|u(?:nordered|pper)|p(?:unct|rint)|finite|w(?:space|c(?:ntrl|type)|digit|upper|p(?:unct|rint)|lower|al(?:num|pha)|graph|xdigit|blank)|l(?:ower|ess(?:equal|greater)?)|al(?:num|pha)|gr(?:eater(?:equal)?|aph)|xdigit|blank)|logb(?:f|l)?|max(?:div|abs))|di(?:v|fftime)|_Exit|unget(?:c|wc)|p(?:ow(?:f|l)?|ut(?:s|c(?:har)?|wc(?:har)?)|error|rintf)|e(?:rf(?:c(?:f|l)?|f|l)?|x(?:it|p(?:2(?:f|l)?|f|l|m1(?:f|l)?)?))|v(?:s(?:scanf|nprintf|canf|printf|w(?:scanf|printf))|printf|f(?:scanf|printf|w(?:scanf|printf))|w(?:scanf|printf)|a_(?:start|copy|end|arg))|qsort|f(?:s(?:canf|e(?:tpos|ek))|close|tell|open|dim(?:f|l)?|p(?:classify|ut(?:s|c|w(?:s|c))|rintf)|e(?:holdexcept|set(?:e(?:nv|xceptflag)|round)|clearexcept|testexcept|of|updateenv|r(?:aiseexcept|ror)|get(?:e(?:nv|xceptflag)|round))|flush|w(?:scanf|ide|printf|rite)|loor(?:f|l)?|abs(?:f|l)?|get(?:s|c|pos|w(?:s|c))|re(?:open|e|ad|xp(?:f|l)?)|m(?:in(?:f|l)?|od(?:f|l)?|a(?:f|l|x(?:f|l)?)?))|l(?:d(?:iv|exp(?:f|l)?)|o(?:ngjmp|cal(?:time|econv)|g(?:1(?:p(?:f|l)?|0(?:f|l)?)|2(?:f|l)?|f|l|b(?:f|l)?)?)|abs|l(?:div|abs|r(?:int(?:f|l)?|ound(?:f|l)?))|r(?:int(?:f|l)?|ound(?:f|l)?)|gamma(?:f|l)?)|w(?:scanf|c(?:s(?:s(?:tr|pn)|nc(?:py|at|mp)|c(?:spn|hr|oll|py|at|mp)|to(?:imax|d|u(?:l(?:l)?|max)|k|f|l(?:d|l)?|mbs)|pbrk|ftime|len|r(?:chr|tombs)|xfrm)|to(?:b|mb)|rtomb)|printf|mem(?:set|c(?:hr|py|mp)|move))|a(?:s(?:sert|ctime|in(?:h(?:f|l)?|f|l)?)|cos(?:h(?:f|l)?|f|l)?|t(?:o(?:i|f|l(?:l)?)|exit|an(?:h(?:f|l)?|2(?:f|l)?|f|l)?)|b(?:s|ort))|g(?:et(?:s|c(?:har)?|env|wc(?:har)?)|mtime)|r(?:int(?:f|l)?|ound(?:f|l)?|e(?:name|alloc|wind|m(?:ove|quo(?:f|l)?|ainder(?:f|l)?))|a(?:nd|ise))|b(?:search|towc)|m(?:odf(?:f|l)?|em(?:set|c(?:hr|py|mp)|move)|ktime|alloc|b(?:s(?:init|towcs|rtowcs)|towc|len|r(?:towc|len))))\\b",a=function(){var e=this.$keywords=this.createKeywordMapper({"keyword.control":"break|case|continue|default|do|else|for|goto|if|_Pragma|return|switch|while|catch|operator|try|throw|using","storage.type":"asm|__asm__|auto|bool|_Bool|char|_Complex|double|enum|float|_Imaginary|int|long|short|signed|struct|typedef|union|unsigned|void|class|wchar_t|template|char16_t|char32_t","storage.modifier":"const|extern|register|restrict|static|volatile|inline|private|protected|public|friend|explicit|virtual|export|mutable|typename|constexpr|new|delete|alignas|alignof|decltype|noexcept|thread_local","keyword.operator":"and|and_eq|bitand|bitor|compl|not|not_eq|or|or_eq|typeid|xor|xor_eq|const_cast|dynamic_cast|reinterpret_cast|static_cast|sizeof|namespace","variable.language":"this","constant.language":"NULL|true|false|TRUE|FALSE|nullptr"},"identifier"),t=/\\(?:['"?\\abfnrtv]|[0-7]{1,3}|x[a-fA-F\d]{2}|u[a-fA-F\d]{4}U[a-fA-F\d]{8}|.)/.source,n="%"+/(\d+\$)?/.source+/[#0\- +']*/.source+/[,;:_]?/.source+/((-?\d+)|\*(-?\d+\$)?)?/.source+/(\.((-?\d+)|\*(-?\d+\$)?)?)?/.source+/(hh|h|ll|l|j|t|z|q|L|vh|vl|v|hv|hl)?/.source+/(\[[^"\]]+\]|[diouxXDOUeEfFgGaACcSspn%])/.source;this.$rules={start:[{token:"comment",regex:"//$",next:"start"},{token:"comment",regex:"//",next:"singleLineComment"},r.getStartRule("doc-start"),{token:"comment",regex:"\\/\\*",next:"comment"},{token:"string",regex:"'(?:"+t+"|.)?'"},{token:"string.start",regex:'"',stateName:"qqstring",next:[{token:"string",regex:/\\\s*$/,next:"qqstring"},{token:"constant.language.escape",regex:t},{token:"constant.language.escape",regex:n},{token:"string.end",regex:'"|$',next:"start"},{defaultToken:"string"}]},{token:"string.start",regex:'R"\\(',stateName:"rawString",next:[{token:"string.end",regex:'\\)"',next:"start"},{defaultToken:"string"}]},{token:"constant.numeric",regex:"0[xX][0-9a-fA-F]+(L|l|UL|ul|u|U|F|f|ll|LL|ull|ULL)?\\b"},{token:"constant.numeric",regex:"[+-]?\\d+(?:(?:\\.\\d*)?(?:[eE][+-]?\\d+)?)?(L|l|UL|ul|u|U|F|f|ll|LL|ull|ULL)?\\b"},{token:"keyword",regex:"#\\s*(?:include|import|pragma|line|define|undef|version)\\b",next:"directive"},{token:"keyword",regex:"#\\s*(?:endif|if|ifdef|else|elif|ifndef)\\b"},{token:"support.function.C99.c",regex:o},{token:e,regex:"[a-zA-Z_$][a-zA-Z0-9_$]*"},{token:"keyword.operator",regex:/--|\+\+|<<=|>>=|>>>=|<>|&&|\|\||\?:|[*%\/+\-&\^|~!<>=]=?/},{token:"punctuation.operator",regex:"\\?|\\:|\\,|\\;|\\."},{token:"paren.lparen",regex:"[[({]"},{token:"paren.rparen",regex:"[\\])}]"},{token:"text",regex:"\\s+"}],comment:[{token:"comment",regex:"\\*\\/",next:"start"},{defaultToken:"comment"}],singleLineComment:[{token:"comment",regex:/\\$/,next:"singleLineComment"},{token:"comment",regex:/$/,next:"start"},{defaultToken:"comment"}],directive:[{token:"constant.other.multiline",regex:/\\/},{token:"constant.other.multiline",regex:/.*\\/},{token:"constant.other",regex:"\\s*<.+?>",next:"start"},{token:"constant.other",regex:'\\s*["](?:(?:\\\\.)|(?:[^"\\\\]))*?["]',next:"start"},{token:"constant.other",regex:"\\s*['](?:(?:\\\\.)|(?:[^'\\\\]))*?[']",next:"start"},{token:"constant.other",regex:/[^\\\/]+/,next:"start"}]},this.embedRules(r,"doc-",[r.getEndRule("start")]),this.normalizeRules()};i.inherits(a,s),t.c_cppHighlightRules=a})),ace.define("ace/mode/matching_brace_outdent",["require","exports","module","ace/range"],(function(e,t,n){"use strict";var i=e("../range").Range,r=function(){};(function(){this.checkOutdent=function(e,t){return!!/^\s+$/.test(e)&&/^\s*\}/.test(t)},this.autoOutdent=function(e,t){var n=e.getLine(t).match(/^(\s*\})/);if(!n)return 0;var r=n[1].length,s=e.findMatchingBracket({row:t,column:r});if(!s||s.row==t)return 0;var o=this.$getIndent(e.getLine(s.row));e.replace(new i(t,0,t,r-1),o)},this.$getIndent=function(e){return e.match(/^\s*/)[0]}}).call(r.prototype),t.MatchingBraceOutdent=r})),ace.define("ace/mode/folding/cstyle",["require","exports","module","ace/lib/oop","ace/range","ace/mode/folding/fold_mode"],(function(e,t,n){"use strict";var i=e("../../lib/oop"),r=e("../../range").Range,s=e("./fold_mode").FoldMode,o=t.FoldMode=function(e){e&&(this.foldingStartMarker=new RegExp(this.foldingStartMarker.source.replace(/\|[^|]*?$/,"|"+e.start)),this.foldingStopMarker=new RegExp(this.foldingStopMarker.source.replace(/\|[^|]*?$/,"|"+e.end)))};i.inherits(o,s),function(){this.foldingStartMarker=/([\{\[\(])[^\}\]\)]*$|^\s*(\/\*)/,this.foldingStopMarker=/^[^\[\{\(]*([\}\]\)])|^[\s\*]*(\*\/)/,this.singleLineBlockCommentRe=/^\s*(\/\*).*\*\/\s*$/,this.tripleStarBlockCommentRe=/^\s*(\/\*\*\*).*\*\/\s*$/,this.startRegionRe=/^\s*(\/\*|\/\/)#?region\b/,this._getFoldWidgetBase=this.getFoldWidget,this.getFoldWidget=function(e,t,n){var i=e.getLine(n);if(this.singleLineBlockCommentRe.test(i)&&!this.startRegionRe.test(i)&&!this.tripleStarBlockCommentRe.test(i))return"";var r=this._getFoldWidgetBase(e,t,n);return!r&&this.startRegionRe.test(i)?"start":r},this.getFoldWidgetRange=function(e,t,n,i){var r,s=e.getLine(n);if(this.startRegionRe.test(s))return this.getCommentRegionBlock(e,s,n);if(r=s.match(this.foldingStartMarker)){var o=r.index;if(r[1])return this.openingBracketBlock(e,r[1],n,o);var a=e.getCommentFoldRange(n,o+r[0].length,1);return a&&!a.isMultiLine()&&(i?a=this.getSectionRange(e,n):"all"!=t&&(a=null)),a}return"markbegin"!==t&&(r=s.match(this.foldingStopMarker))?(o=r.index+r[0].length,r[1]?this.closingBracketBlock(e,r[1],n,o):e.getCommentFoldRange(n,o,-1)):void 0},this.getSectionRange=function(e,t){for(var n=e.getLine(t),i=n.search(/\S/),s=t,o=n.length,a=t+=1,l=e.getLength();++t<l;){var c=(n=e.getLine(t)).search(/\S/);if(-1!==c){if(i>c)break;var u=this.getFoldWidgetRange(e,"all",t);if(u){if(u.start.row<=s)break;if(u.isMultiLine())t=u.end.row;else if(i==c)break}a=t}}return new r(s,o,a,e.getLine(a).length)},this.getCommentRegionBlock=function(e,t,n){for(var i=t.search(/\s*$/),s=e.getLength(),o=n,a=/^\s*(?:\/\*|\/\/|--)#?(end)?region\b/,l=1;++n<s;){t=e.getLine(n);var c=a.exec(t);if(c&&(c[1]?l--:l++,!l))break}if(n>o)return new r(o,i,n,t.length)}}.call(o.prototype)})),ace.define("ace/mode/c_cpp",["require","exports","module","ace/lib/oop","ace/mode/text","ace/mode/c_cpp_highlight_rules","ace/mode/matching_brace_outdent","ace/range","ace/mode/behaviour/cstyle","ace/mode/folding/cstyle"],(function(e,t,n){"use strict";var i=e("../lib/oop"),r=e("./text").Mode,s=e("./c_cpp_highlight_rules").c_cppHighlightRules,o=e("./matching_brace_outdent").MatchingBraceOutdent,a=(e("../range").Range,e("./behaviour/cstyle").CstyleBehaviour),l=e("./folding/cstyle").FoldMode,c=function(){this.HighlightRules=s,this.$outdent=new o,this.$behaviour=new a,this.foldingRules=new l};i.inherits(c,r),function(){this.lineCommentStart="//",this.blockComment={start:"/*",end:"*/"},this.getNextLineIndent=function(e,t,n){var i=this.$getIndent(t),r=this.getTokenizer().getLineTokens(t,e),s=r.tokens,o=r.state;if(s.length&&"comment"==s[s.length-1].type)return i;if("start"==e)(a=t.match(/^.*[\{\(\[]\s*$/))&&(i+=n);else if("doc-start"==e){if("start"==o)return"";var a;(a=t.match(/^\s*(\/?)\*/))&&(a[1]&&(i+=" "),i+="* ")}return i},this.checkOutdent=function(e,t,n){return this.$outdent.checkOutdent(t,n)},this.autoOutdent=function(e,t,n){this.$outdent.autoOutdent(t,n)},this.$id="ace/mode/c_cpp"}.call(c.prototype),t.Mode=c})),ace.define("ace/mode/glsl_highlight_rules",["require","exports","module","ace/lib/oop","ace/mode/c_cpp_highlight_rules"],(function(e,t,n){"use strict";var i=e("../lib/oop"),r=e("./c_cpp_highlight_rules").c_cppHighlightRules,s=function(){var e=this.createKeywordMapper({"variable.language":"this",keyword:"layout|attribute|const|uniform|varying|break|continue|do|for|while|if|else|in|out|inout|float|int|void|bool|true|false|lowp|mediump|highp|precision|invariant|discard|return|mat2|mat3|mat4|vec2|vec3|vec4|ivec2|ivec3|ivec4|bvec2|bvec3|bvec4|sampler2D|samplerCube|struct","constant.language":"radians|degrees|sin|cos|tan|asin|acos|atan|pow|exp|log|exp2|log2|sqrt|inversesqrt|abs|sign|floor|ceil|fract|mod|min|max|clamp|mix|step|smoothstep|length|distance|dot|cross|normalize|faceforward|reflect|refract|matrixCompMult|lessThan|lessThanEqual|greaterThan|greaterThanEqual|equal|notEqual|any|all|not|dFdx|dFdy|fwidth|texture2D|texture2DProj|texture2DLod|texture2DProjLod|textureCube|textureCubeLod|gl_MaxVertexAttribs|gl_MaxVertexUniformVectors|gl_MaxVaryingVectors|gl_MaxVertexTextureImageUnits|gl_MaxCombinedTextureImageUnits|gl_MaxTextureImageUnits|gl_MaxFragmentUniformVectors|gl_MaxDrawBuffers|gl_DepthRangeParameters|gl_DepthRange|gl_Position|gl_PointSize|gl_FragCoord|gl_FrontFacing|gl_PointCoord|gl_FragColor|gl_FragData"},"identifier");this.$rules=(new r).$rules,this.$rules.start.forEach((function(t){"function"==typeof t.token&&(t.token=e)}))};i.inherits(s,r),t.glslHighlightRules=s})),ace.define("ace/mode/glsl",["require","exports","module","ace/lib/oop","ace/mode/c_cpp","ace/mode/glsl_highlight_rules","ace/mode/matching_brace_outdent","ace/range","ace/mode/behaviour/cstyle","ace/mode/folding/cstyle"],(function(e,t,n){"use strict";var i=e("../lib/oop"),r=e("./c_cpp").Mode,s=e("./glsl_highlight_rules").glslHighlightRules,o=e("./matching_brace_outdent").MatchingBraceOutdent,a=(e("../range").Range,e("./behaviour/cstyle").CstyleBehaviour),l=e("./folding/cstyle").FoldMode,c=function(){this.HighlightRules=s,this.$outdent=new o,this.$behaviour=new a,this.foldingRules=new l};i.inherits(c,r),function(){this.$id="ace/mode/glsl"}.call(c.prototype),t.Mode=c})),ace.require(["ace/mode/glsl"],(function(t){e&&(e.exports=t)}))},793:(e,t,n)=>{e=n.nmd(e),ace.define("ace/theme/monokai",["require","exports","module","ace/lib/dom"],(function(e,t,n){t.isDark=!0,t.cssClass="ace-monokai",t.cssText=".ace-monokai .ace_gutter {background: #2F3129;color: #8F908A}.ace-monokai .ace_print-margin {width: 1px;background: #555651}.ace-monokai {background-color: #272822;color: #F8F8F2}.ace-monokai .ace_cursor {color: #F8F8F0}.ace-monokai .ace_marker-layer .ace_selection {background: #49483E}.ace-monokai.ace_multiselect .ace_selection.ace_start {box-shadow: 0 0 3px 0px #272822;}.ace-monokai .ace_marker-layer .ace_step {background: rgb(102, 82, 0)}.ace-monokai .ace_marker-layer .ace_bracket {margin: -1px 0 0 -1px;border: 1px solid #49483E}.ace-monokai .ace_marker-layer .ace_active-line {background: #202020}.ace-monokai .ace_gutter-active-line {background-color: #272727}.ace-monokai .ace_marker-layer .ace_selected-word {border: 1px solid #49483E}.ace-monokai .ace_invisible {color: #52524d}.ace-monokai .ace_entity.ace_name.ace_tag,.ace-monokai .ace_keyword,.ace-monokai .ace_meta.ace_tag,.ace-monokai .ace_storage {color: #F92672}.ace-monokai .ace_punctuation,.ace-monokai .ace_punctuation.ace_tag {color: #fff}.ace-monokai .ace_constant.ace_character,.ace-monokai .ace_constant.ace_language,.ace-monokai .ace_constant.ace_numeric,.ace-monokai .ace_constant.ace_other {color: #AE81FF}.ace-monokai .ace_invalid {color: #F8F8F0;background-color: #F92672}.ace-monokai .ace_invalid.ace_deprecated {color: #F8F8F0;background-color: #AE81FF}.ace-monokai .ace_support.ace_constant,.ace-monokai .ace_support.ace_function {color: #66D9EF}.ace-monokai .ace_fold {background-color: #A6E22E;border-color: #F8F8F2}.ace-monokai .ace_storage.ace_type,.ace-monokai .ace_support.ace_class,.ace-monokai .ace_support.ace_type {font-style: italic;color: #66D9EF}.ace-monokai .ace_entity.ace_name.ace_function,.ace-monokai .ace_entity.ace_other,.ace-monokai .ace_entity.ace_other.ace_attribute-name,.ace-monokai .ace_variable {color: #A6E22E}.ace-monokai .ace_variable.ace_parameter {font-style: italic;color: #FD971F}.ace-monokai .ace_string {color: #E6DB74}.ace-monokai .ace_comment {color: #75715E}.ace-monokai .ace_indent-guide {background: url(data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAEAAAACCAYAAACZgbYnAAAAEklEQVQImWPQ0FD0ZXBzd/wPAAjVAoxeSgNeAAAAAElFTkSuQmCC) right repeat-y}",e("../lib/dom").importCssString(t.cssText,t.cssClass)})),ace.require(["ace/theme/monokai"],(function(t){e&&(e.exports=t)}))}},t={};function n(i){var r=t[i];if(void 0!==r)return r.exports;var s=t[i]={id:i,loaded:!1,exports:{}};return e[i].call(s.exports,s,s.exports,n),s.loaded=!0,s.exports}return n.amdD=function(){throw new Error("define cannot be used indirect")},n.n=e=>{var t=e&&e.__esModule?()=>e.default:()=>e;return n.d(t,{a:t}),t},n.d=(e,t)=>{for(var i in t)n.o(t,i)&&!n.o(e,i)&&Object.defineProperty(e,i,{enumerable:!0,get:t[i]})},n.o=(e,t)=>Object.prototype.hasOwnProperty.call(e,t),n.r=e=>{"undefined"!=typeof Symbol&&Symbol.toStringTag&&Object.defineProperty(e,Symbol.toStringTag,{value:"Module"}),Object.defineProperty(e,"__esModule",{value:!0})},n.nmd=e=>(e.paths=[],e.children||(e.children=[]),e),n.nc=void 0,n(819),n(176),n(793),n(655),n(18),n(986)})()));

/***/ }),

/***/ "./node_modules/tweakpane/dist/tweakpane.js":
/*!**************************************************!*\
  !*** ./node_modules/tweakpane/dist/tweakpane.js ***!
  \**************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   BladeApi: () => (/* binding */ BladeApi),
/* harmony export */   ButtonApi: () => (/* binding */ ButtonApi),
/* harmony export */   FolderApi: () => (/* binding */ FolderApi),
/* harmony export */   ListBladeApi: () => (/* binding */ ListBladeApi),
/* harmony export */   ListInputBindingApi: () => (/* binding */ ListInputBindingApi),
/* harmony export */   Pane: () => (/* binding */ Pane),
/* harmony export */   Semver: () => (/* binding */ Semver),
/* harmony export */   SeparatorBladeApi: () => (/* binding */ SeparatorBladeApi),
/* harmony export */   SliderBladeApi: () => (/* binding */ SliderBladeApi),
/* harmony export */   SliderInputBindingApi: () => (/* binding */ SliderInputBindingApi),
/* harmony export */   TabApi: () => (/* binding */ TabApi),
/* harmony export */   TabPageApi: () => (/* binding */ TabPageApi),
/* harmony export */   TextBladeApi: () => (/* binding */ TextBladeApi),
/* harmony export */   TpChangeEvent: () => (/* binding */ TpChangeEvent),
/* harmony export */   VERSION: () => (/* binding */ VERSION)
/* harmony export */ });
/*! Tweakpane 4.0.5 (c) 2016 cocopon, licensed under the MIT license. */
function forceCast(v) {
    return v;
}
function isEmpty(value) {
    return value === null || value === undefined;
}
function isObject$1(value) {
    return value !== null && typeof value === 'object';
}
function isRecord(value) {
    return value !== null && typeof value === 'object';
}
function deepEqualsArray(a1, a2) {
    if (a1.length !== a2.length) {
        return false;
    }
    for (let i = 0; i < a1.length; i++) {
        if (a1[i] !== a2[i]) {
            return false;
        }
    }
    return true;
}
function deepMerge(r1, r2) {
    const keys = Array.from(new Set([...Object.keys(r1), ...Object.keys(r2)]));
    return keys.reduce((result, key) => {
        const v1 = r1[key];
        const v2 = r2[key];
        return isRecord(v1) && isRecord(v2)
            ? Object.assign(Object.assign({}, result), { [key]: deepMerge(v1, v2) }) : Object.assign(Object.assign({}, result), { [key]: key in r2 ? v2 : v1 });
    }, {});
}

function isBinding(value) {
    if (!isObject$1(value)) {
        return false;
    }
    return 'target' in value;
}

const CREATE_MESSAGE_MAP = {
    alreadydisposed: () => 'View has been already disposed',
    invalidparams: (context) => `Invalid parameters for '${context.name}'`,
    nomatchingcontroller: (context) => `No matching controller for '${context.key}'`,
    nomatchingview: (context) => `No matching view for '${JSON.stringify(context.params)}'`,
    notbindable: () => `Value is not bindable`,
    notcompatible: (context) => `Not compatible with  plugin '${context.id}'`,
    propertynotfound: (context) => `Property '${context.name}' not found`,
    shouldneverhappen: () => 'This error should never happen',
};
class TpError {
    static alreadyDisposed() {
        return new TpError({ type: 'alreadydisposed' });
    }
    static notBindable() {
        return new TpError({
            type: 'notbindable',
        });
    }
    static notCompatible(bundleId, id) {
        return new TpError({
            type: 'notcompatible',
            context: {
                id: `${bundleId}.${id}`,
            },
        });
    }
    static propertyNotFound(name) {
        return new TpError({
            type: 'propertynotfound',
            context: {
                name: name,
            },
        });
    }
    static shouldNeverHappen() {
        return new TpError({ type: 'shouldneverhappen' });
    }
    constructor(config) {
        var _a;
        this.message =
            (_a = CREATE_MESSAGE_MAP[config.type](forceCast(config.context))) !== null && _a !== void 0 ? _a : 'Unexpected error';
        this.name = this.constructor.name;
        this.stack = new Error(this.message).stack;
        this.type = config.type;
    }
    toString() {
        return this.message;
    }
}

class BindingTarget {
    constructor(obj, key) {
        this.obj_ = obj;
        this.key = key;
    }
    static isBindable(obj) {
        if (obj === null) {
            return false;
        }
        if (typeof obj !== 'object' && typeof obj !== 'function') {
            return false;
        }
        return true;
    }
    read() {
        return this.obj_[this.key];
    }
    write(value) {
        this.obj_[this.key] = value;
    }
    writeProperty(name, value) {
        const valueObj = this.read();
        if (!BindingTarget.isBindable(valueObj)) {
            throw TpError.notBindable();
        }
        if (!(name in valueObj)) {
            throw TpError.propertyNotFound(name);
        }
        valueObj[name] = value;
    }
}

class Emitter {
    constructor() {
        this.observers_ = {};
    }
    on(eventName, handler, opt_options) {
        var _a;
        let observers = this.observers_[eventName];
        if (!observers) {
            observers = this.observers_[eventName] = [];
        }
        observers.push({
            handler: handler,
            key: (_a = opt_options === null || opt_options === void 0 ? void 0 : opt_options.key) !== null && _a !== void 0 ? _a : handler,
        });
        return this;
    }
    off(eventName, key) {
        const observers = this.observers_[eventName];
        if (observers) {
            this.observers_[eventName] = observers.filter((observer) => {
                return observer.key !== key;
            });
        }
        return this;
    }
    emit(eventName, event) {
        const observers = this.observers_[eventName];
        if (!observers) {
            return;
        }
        observers.forEach((observer) => {
            observer.handler(event);
        });
    }
}

class ComplexValue {
    constructor(initialValue, config) {
        var _a;
        this.constraint_ = config === null || config === void 0 ? void 0 : config.constraint;
        this.equals_ = (_a = config === null || config === void 0 ? void 0 : config.equals) !== null && _a !== void 0 ? _a : ((v1, v2) => v1 === v2);
        this.emitter = new Emitter();
        this.rawValue_ = initialValue;
    }
    get constraint() {
        return this.constraint_;
    }
    get rawValue() {
        return this.rawValue_;
    }
    set rawValue(rawValue) {
        this.setRawValue(rawValue, {
            forceEmit: false,
            last: true,
        });
    }
    setRawValue(rawValue, options) {
        const opts = options !== null && options !== void 0 ? options : {
            forceEmit: false,
            last: true,
        };
        const constrainedValue = this.constraint_
            ? this.constraint_.constrain(rawValue)
            : rawValue;
        const prevValue = this.rawValue_;
        const changed = !this.equals_(prevValue, constrainedValue);
        if (!changed && !opts.forceEmit) {
            return;
        }
        this.emitter.emit('beforechange', {
            sender: this,
        });
        this.rawValue_ = constrainedValue;
        this.emitter.emit('change', {
            options: opts,
            previousRawValue: prevValue,
            rawValue: constrainedValue,
            sender: this,
        });
    }
}

class PrimitiveValue {
    constructor(initialValue) {
        this.emitter = new Emitter();
        this.value_ = initialValue;
    }
    get rawValue() {
        return this.value_;
    }
    set rawValue(value) {
        this.setRawValue(value, {
            forceEmit: false,
            last: true,
        });
    }
    setRawValue(value, options) {
        const opts = options !== null && options !== void 0 ? options : {
            forceEmit: false,
            last: true,
        };
        const prevValue = this.value_;
        if (prevValue === value && !opts.forceEmit) {
            return;
        }
        this.emitter.emit('beforechange', {
            sender: this,
        });
        this.value_ = value;
        this.emitter.emit('change', {
            options: opts,
            previousRawValue: prevValue,
            rawValue: this.value_,
            sender: this,
        });
    }
}

class ReadonlyPrimitiveValue {
    constructor(value) {
        this.emitter = new Emitter();
        this.onValueBeforeChange_ = this.onValueBeforeChange_.bind(this);
        this.onValueChange_ = this.onValueChange_.bind(this);
        this.value_ = value;
        this.value_.emitter.on('beforechange', this.onValueBeforeChange_);
        this.value_.emitter.on('change', this.onValueChange_);
    }
    get rawValue() {
        return this.value_.rawValue;
    }
    onValueBeforeChange_(ev) {
        this.emitter.emit('beforechange', Object.assign(Object.assign({}, ev), { sender: this }));
    }
    onValueChange_(ev) {
        this.emitter.emit('change', Object.assign(Object.assign({}, ev), { sender: this }));
    }
}

function createValue(initialValue, config) {
    const constraint = config === null || config === void 0 ? void 0 : config.constraint;
    const equals = config === null || config === void 0 ? void 0 : config.equals;
    if (!constraint && !equals) {
        return new PrimitiveValue(initialValue);
    }
    return new ComplexValue(initialValue, config);
}
function createReadonlyValue(value) {
    return [
        new ReadonlyPrimitiveValue(value),
        (rawValue, options) => {
            value.setRawValue(rawValue, options);
        },
    ];
}

class ValueMap {
    constructor(valueMap) {
        this.emitter = new Emitter();
        this.valMap_ = valueMap;
        for (const key in this.valMap_) {
            const v = this.valMap_[key];
            v.emitter.on('change', () => {
                this.emitter.emit('change', {
                    key: key,
                    sender: this,
                });
            });
        }
    }
    static createCore(initialValue) {
        const keys = Object.keys(initialValue);
        return keys.reduce((o, key) => {
            return Object.assign(o, {
                [key]: createValue(initialValue[key]),
            });
        }, {});
    }
    static fromObject(initialValue) {
        const core = this.createCore(initialValue);
        return new ValueMap(core);
    }
    get(key) {
        return this.valMap_[key].rawValue;
    }
    set(key, value) {
        this.valMap_[key].rawValue = value;
    }
    value(key) {
        return this.valMap_[key];
    }
}

class DefiniteRangeConstraint {
    constructor(config) {
        this.values = ValueMap.fromObject({
            max: config.max,
            min: config.min,
        });
    }
    constrain(value) {
        const max = this.values.get('max');
        const min = this.values.get('min');
        return Math.min(Math.max(value, min), max);
    }
}

class RangeConstraint {
    constructor(config) {
        this.values = ValueMap.fromObject({
            max: config.max,
            min: config.min,
        });
    }
    constrain(value) {
        const max = this.values.get('max');
        const min = this.values.get('min');
        let result = value;
        if (!isEmpty(min)) {
            result = Math.max(result, min);
        }
        if (!isEmpty(max)) {
            result = Math.min(result, max);
        }
        return result;
    }
}

class StepConstraint {
    constructor(step, origin = 0) {
        this.step = step;
        this.origin = origin;
    }
    constrain(value) {
        const o = this.origin % this.step;
        const r = Math.round((value - o) / this.step);
        return o + r * this.step;
    }
}

class NumberLiteralNode {
    constructor(text) {
        this.text = text;
    }
    evaluate() {
        return Number(this.text);
    }
    toString() {
        return this.text;
    }
}
const BINARY_OPERATION_MAP = {
    '**': (v1, v2) => Math.pow(v1, v2),
    '*': (v1, v2) => v1 * v2,
    '/': (v1, v2) => v1 / v2,
    '%': (v1, v2) => v1 % v2,
    '+': (v1, v2) => v1 + v2,
    '-': (v1, v2) => v1 - v2,
    '<<': (v1, v2) => v1 << v2,
    '>>': (v1, v2) => v1 >> v2,
    '>>>': (v1, v2) => v1 >>> v2,
    '&': (v1, v2) => v1 & v2,
    '^': (v1, v2) => v1 ^ v2,
    '|': (v1, v2) => v1 | v2,
};
class BinaryOperationNode {
    constructor(operator, left, right) {
        this.left = left;
        this.operator = operator;
        this.right = right;
    }
    evaluate() {
        const op = BINARY_OPERATION_MAP[this.operator];
        if (!op) {
            throw new Error(`unexpected binary operator: '${this.operator}`);
        }
        return op(this.left.evaluate(), this.right.evaluate());
    }
    toString() {
        return [
            'b(',
            this.left.toString(),
            this.operator,
            this.right.toString(),
            ')',
        ].join(' ');
    }
}
const UNARY_OPERATION_MAP = {
    '+': (v) => v,
    '-': (v) => -v,
    '~': (v) => ~v,
};
class UnaryOperationNode {
    constructor(operator, expr) {
        this.operator = operator;
        this.expression = expr;
    }
    evaluate() {
        const op = UNARY_OPERATION_MAP[this.operator];
        if (!op) {
            throw new Error(`unexpected unary operator: '${this.operator}`);
        }
        return op(this.expression.evaluate());
    }
    toString() {
        return ['u(', this.operator, this.expression.toString(), ')'].join(' ');
    }
}

function combineReader(parsers) {
    return (text, cursor) => {
        for (let i = 0; i < parsers.length; i++) {
            const result = parsers[i](text, cursor);
            if (result !== '') {
                return result;
            }
        }
        return '';
    };
}
function readWhitespace(text, cursor) {
    var _a;
    const m = text.substr(cursor).match(/^\s+/);
    return (_a = (m && m[0])) !== null && _a !== void 0 ? _a : '';
}
function readNonZeroDigit(text, cursor) {
    const ch = text.substr(cursor, 1);
    return ch.match(/^[1-9]$/) ? ch : '';
}
function readDecimalDigits(text, cursor) {
    var _a;
    const m = text.substr(cursor).match(/^[0-9]+/);
    return (_a = (m && m[0])) !== null && _a !== void 0 ? _a : '';
}
function readSignedInteger(text, cursor) {
    const ds = readDecimalDigits(text, cursor);
    if (ds !== '') {
        return ds;
    }
    const sign = text.substr(cursor, 1);
    cursor += 1;
    if (sign !== '-' && sign !== '+') {
        return '';
    }
    const sds = readDecimalDigits(text, cursor);
    if (sds === '') {
        return '';
    }
    return sign + sds;
}
function readExponentPart(text, cursor) {
    const e = text.substr(cursor, 1);
    cursor += 1;
    if (e.toLowerCase() !== 'e') {
        return '';
    }
    const si = readSignedInteger(text, cursor);
    if (si === '') {
        return '';
    }
    return e + si;
}
function readDecimalIntegerLiteral(text, cursor) {
    const ch = text.substr(cursor, 1);
    if (ch === '0') {
        return ch;
    }
    const nzd = readNonZeroDigit(text, cursor);
    cursor += nzd.length;
    if (nzd === '') {
        return '';
    }
    return nzd + readDecimalDigits(text, cursor);
}
function readDecimalLiteral1(text, cursor) {
    const dil = readDecimalIntegerLiteral(text, cursor);
    cursor += dil.length;
    if (dil === '') {
        return '';
    }
    const dot = text.substr(cursor, 1);
    cursor += dot.length;
    if (dot !== '.') {
        return '';
    }
    const dds = readDecimalDigits(text, cursor);
    cursor += dds.length;
    return dil + dot + dds + readExponentPart(text, cursor);
}
function readDecimalLiteral2(text, cursor) {
    const dot = text.substr(cursor, 1);
    cursor += dot.length;
    if (dot !== '.') {
        return '';
    }
    const dds = readDecimalDigits(text, cursor);
    cursor += dds.length;
    if (dds === '') {
        return '';
    }
    return dot + dds + readExponentPart(text, cursor);
}
function readDecimalLiteral3(text, cursor) {
    const dil = readDecimalIntegerLiteral(text, cursor);
    cursor += dil.length;
    if (dil === '') {
        return '';
    }
    return dil + readExponentPart(text, cursor);
}
const readDecimalLiteral = combineReader([
    readDecimalLiteral1,
    readDecimalLiteral2,
    readDecimalLiteral3,
]);
function parseBinaryDigits(text, cursor) {
    var _a;
    const m = text.substr(cursor).match(/^[01]+/);
    return (_a = (m && m[0])) !== null && _a !== void 0 ? _a : '';
}
function readBinaryIntegerLiteral(text, cursor) {
    const prefix = text.substr(cursor, 2);
    cursor += prefix.length;
    if (prefix.toLowerCase() !== '0b') {
        return '';
    }
    const bds = parseBinaryDigits(text, cursor);
    if (bds === '') {
        return '';
    }
    return prefix + bds;
}
function readOctalDigits(text, cursor) {
    var _a;
    const m = text.substr(cursor).match(/^[0-7]+/);
    return (_a = (m && m[0])) !== null && _a !== void 0 ? _a : '';
}
function readOctalIntegerLiteral(text, cursor) {
    const prefix = text.substr(cursor, 2);
    cursor += prefix.length;
    if (prefix.toLowerCase() !== '0o') {
        return '';
    }
    const ods = readOctalDigits(text, cursor);
    if (ods === '') {
        return '';
    }
    return prefix + ods;
}
function readHexDigits(text, cursor) {
    var _a;
    const m = text.substr(cursor).match(/^[0-9a-f]+/i);
    return (_a = (m && m[0])) !== null && _a !== void 0 ? _a : '';
}
function readHexIntegerLiteral(text, cursor) {
    const prefix = text.substr(cursor, 2);
    cursor += prefix.length;
    if (prefix.toLowerCase() !== '0x') {
        return '';
    }
    const hds = readHexDigits(text, cursor);
    if (hds === '') {
        return '';
    }
    return prefix + hds;
}
const readNonDecimalIntegerLiteral = combineReader([
    readBinaryIntegerLiteral,
    readOctalIntegerLiteral,
    readHexIntegerLiteral,
]);
const readNumericLiteral = combineReader([
    readNonDecimalIntegerLiteral,
    readDecimalLiteral,
]);

function parseLiteral(text, cursor) {
    const num = readNumericLiteral(text, cursor);
    cursor += num.length;
    if (num === '') {
        return null;
    }
    return {
        evaluable: new NumberLiteralNode(num),
        cursor: cursor,
    };
}
function parseParenthesizedExpression(text, cursor) {
    const op = text.substr(cursor, 1);
    cursor += op.length;
    if (op !== '(') {
        return null;
    }
    const expr = parseExpression(text, cursor);
    if (!expr) {
        return null;
    }
    cursor = expr.cursor;
    cursor += readWhitespace(text, cursor).length;
    const cl = text.substr(cursor, 1);
    cursor += cl.length;
    if (cl !== ')') {
        return null;
    }
    return {
        evaluable: expr.evaluable,
        cursor: cursor,
    };
}
function parsePrimaryExpression(text, cursor) {
    var _a;
    return ((_a = parseLiteral(text, cursor)) !== null && _a !== void 0 ? _a : parseParenthesizedExpression(text, cursor));
}
function parseUnaryExpression(text, cursor) {
    const expr = parsePrimaryExpression(text, cursor);
    if (expr) {
        return expr;
    }
    const op = text.substr(cursor, 1);
    cursor += op.length;
    if (op !== '+' && op !== '-' && op !== '~') {
        return null;
    }
    const num = parseUnaryExpression(text, cursor);
    if (!num) {
        return null;
    }
    cursor = num.cursor;
    return {
        cursor: cursor,
        evaluable: new UnaryOperationNode(op, num.evaluable),
    };
}
function readBinaryOperator(ops, text, cursor) {
    cursor += readWhitespace(text, cursor).length;
    const op = ops.filter((op) => text.startsWith(op, cursor))[0];
    if (!op) {
        return null;
    }
    cursor += op.length;
    cursor += readWhitespace(text, cursor).length;
    return {
        cursor: cursor,
        operator: op,
    };
}
function createBinaryOperationExpressionParser(exprParser, ops) {
    return (text, cursor) => {
        const firstExpr = exprParser(text, cursor);
        if (!firstExpr) {
            return null;
        }
        cursor = firstExpr.cursor;
        let expr = firstExpr.evaluable;
        for (;;) {
            const op = readBinaryOperator(ops, text, cursor);
            if (!op) {
                break;
            }
            cursor = op.cursor;
            const nextExpr = exprParser(text, cursor);
            if (!nextExpr) {
                return null;
            }
            cursor = nextExpr.cursor;
            expr = new BinaryOperationNode(op.operator, expr, nextExpr.evaluable);
        }
        return expr
            ? {
                cursor: cursor,
                evaluable: expr,
            }
            : null;
    };
}
const parseBinaryOperationExpression = [
    ['**'],
    ['*', '/', '%'],
    ['+', '-'],
    ['<<', '>>>', '>>'],
    ['&'],
    ['^'],
    ['|'],
].reduce((parser, ops) => {
    return createBinaryOperationExpressionParser(parser, ops);
}, parseUnaryExpression);
function parseExpression(text, cursor) {
    cursor += readWhitespace(text, cursor).length;
    return parseBinaryOperationExpression(text, cursor);
}
function parseEcmaNumberExpression(text) {
    const expr = parseExpression(text, 0);
    if (!expr) {
        return null;
    }
    const cursor = expr.cursor + readWhitespace(text, expr.cursor).length;
    if (cursor !== text.length) {
        return null;
    }
    return expr.evaluable;
}

function parseNumber(text) {
    var _a;
    const r = parseEcmaNumberExpression(text);
    return (_a = r === null || r === void 0 ? void 0 : r.evaluate()) !== null && _a !== void 0 ? _a : null;
}
function numberFromUnknown(value) {
    if (typeof value === 'number') {
        return value;
    }
    if (typeof value === 'string') {
        const pv = parseNumber(value);
        if (!isEmpty(pv)) {
            return pv;
        }
    }
    return 0;
}
function numberToString(value) {
    return String(value);
}
function createNumberFormatter(digits) {
    return (value) => {
        return value.toFixed(Math.max(Math.min(digits, 20), 0));
    };
}

function mapRange(value, start1, end1, start2, end2) {
    const p = (value - start1) / (end1 - start1);
    return start2 + p * (end2 - start2);
}
function getDecimalDigits(value) {
    const text = String(value.toFixed(10));
    const frac = text.split('.')[1];
    return frac.replace(/0+$/, '').length;
}
function constrainRange(value, min, max) {
    return Math.min(Math.max(value, min), max);
}
function loopRange(value, max) {
    return ((value % max) + max) % max;
}
function getSuitableDecimalDigits(params, rawValue) {
    return !isEmpty(params.step)
        ? getDecimalDigits(params.step)
        : Math.max(getDecimalDigits(rawValue), 2);
}
function getSuitableKeyScale(params) {
    var _a;
    return (_a = params.step) !== null && _a !== void 0 ? _a : 1;
}
function getSuitablePointerScale(params, rawValue) {
    var _a;
    const base = Math.abs((_a = params.step) !== null && _a !== void 0 ? _a : rawValue);
    return base === 0 ? 0.1 : Math.pow(10, Math.floor(Math.log10(base)) - 1);
}
function createStepConstraint(params, initialValue) {
    if (!isEmpty(params.step)) {
        return new StepConstraint(params.step, initialValue);
    }
    return null;
}
function createRangeConstraint(params) {
    if (!isEmpty(params.max) && !isEmpty(params.min)) {
        return new DefiniteRangeConstraint({
            max: params.max,
            min: params.min,
        });
    }
    if (!isEmpty(params.max) || !isEmpty(params.min)) {
        return new RangeConstraint({
            max: params.max,
            min: params.min,
        });
    }
    return null;
}
function createNumberTextPropsObject(params, initialValue) {
    var _a, _b, _c;
    return {
        formatter: (_a = params.format) !== null && _a !== void 0 ? _a : createNumberFormatter(getSuitableDecimalDigits(params, initialValue)),
        keyScale: (_b = params.keyScale) !== null && _b !== void 0 ? _b : getSuitableKeyScale(params),
        pointerScale: (_c = params.pointerScale) !== null && _c !== void 0 ? _c : getSuitablePointerScale(params, initialValue),
    };
}
function createNumberTextInputParamsParser(p) {
    return {
        format: p.optional.function,
        keyScale: p.optional.number,
        max: p.optional.number,
        min: p.optional.number,
        pointerScale: p.optional.number,
        step: p.optional.number,
    };
}

function createPointAxis(config) {
    return {
        constraint: config.constraint,
        textProps: ValueMap.fromObject(createNumberTextPropsObject(config.params, config.initialValue)),
    };
}

class BladeApi {
    constructor(controller) {
        this.controller = controller;
    }
    get element() {
        return this.controller.view.element;
    }
    get disabled() {
        return this.controller.viewProps.get('disabled');
    }
    set disabled(disabled) {
        this.controller.viewProps.set('disabled', disabled);
    }
    get hidden() {
        return this.controller.viewProps.get('hidden');
    }
    set hidden(hidden) {
        this.controller.viewProps.set('hidden', hidden);
    }
    dispose() {
        this.controller.viewProps.set('disposed', true);
    }
    importState(state) {
        return this.controller.importState(state);
    }
    exportState() {
        return this.controller.exportState();
    }
}

class TpEvent {
    constructor(target) {
        this.target = target;
    }
}
class TpChangeEvent extends TpEvent {
    constructor(target, value, last) {
        super(target);
        this.value = value;
        this.last = last !== null && last !== void 0 ? last : true;
    }
}
class TpFoldEvent extends TpEvent {
    constructor(target, expanded) {
        super(target);
        this.expanded = expanded;
    }
}
class TpTabSelectEvent extends TpEvent {
    constructor(target, index) {
        super(target);
        this.index = index;
    }
}
class TpMouseEvent extends TpEvent {
    constructor(target, nativeEvent) {
        super(target);
        this.native = nativeEvent;
    }
}

class BindingApi extends BladeApi {
    constructor(controller) {
        super(controller);
        this.onValueChange_ = this.onValueChange_.bind(this);
        this.emitter_ = new Emitter();
        this.controller.value.emitter.on('change', this.onValueChange_);
    }
    get label() {
        return this.controller.labelController.props.get('label');
    }
    set label(label) {
        this.controller.labelController.props.set('label', label);
    }
    get key() {
        return this.controller.value.binding.target.key;
    }
    get tag() {
        return this.controller.tag;
    }
    set tag(tag) {
        this.controller.tag = tag;
    }
    on(eventName, handler) {
        const bh = handler.bind(this);
        this.emitter_.on(eventName, (ev) => {
            bh(ev);
        }, {
            key: handler,
        });
        return this;
    }
    off(eventName, handler) {
        this.emitter_.off(eventName, handler);
        return this;
    }
    refresh() {
        this.controller.value.fetch();
    }
    onValueChange_(ev) {
        const value = this.controller.value;
        this.emitter_.emit('change', new TpChangeEvent(this, forceCast(value.binding.target.read()), ev.options.last));
    }
}

class InputBindingValue {
    constructor(value, binding) {
        this.onValueBeforeChange_ = this.onValueBeforeChange_.bind(this);
        this.onValueChange_ = this.onValueChange_.bind(this);
        this.binding = binding;
        this.value_ = value;
        this.value_.emitter.on('beforechange', this.onValueBeforeChange_);
        this.value_.emitter.on('change', this.onValueChange_);
        this.emitter = new Emitter();
    }
    get rawValue() {
        return this.value_.rawValue;
    }
    set rawValue(rawValue) {
        this.value_.rawValue = rawValue;
    }
    setRawValue(rawValue, options) {
        this.value_.setRawValue(rawValue, options);
    }
    fetch() {
        this.value_.rawValue = this.binding.read();
    }
    push() {
        this.binding.write(this.value_.rawValue);
    }
    onValueBeforeChange_(ev) {
        this.emitter.emit('beforechange', Object.assign(Object.assign({}, ev), { sender: this }));
    }
    onValueChange_(ev) {
        this.push();
        this.emitter.emit('change', Object.assign(Object.assign({}, ev), { sender: this }));
    }
}
function isInputBindingValue(v) {
    if (!('binding' in v)) {
        return false;
    }
    const b = v['binding'];
    return isBinding(b) && 'read' in b && 'write' in b;
}

function parseObject(value, keyToParserMap) {
    const keys = Object.keys(keyToParserMap);
    const result = keys.reduce((tmp, key) => {
        if (tmp === undefined) {
            return undefined;
        }
        const parser = keyToParserMap[key];
        const result = parser(value[key]);
        return result.succeeded
            ? Object.assign(Object.assign({}, tmp), { [key]: result.value }) : undefined;
    }, {});
    return forceCast(result);
}
function parseArray(value, parseItem) {
    return value.reduce((tmp, item) => {
        if (tmp === undefined) {
            return undefined;
        }
        const result = parseItem(item);
        if (!result.succeeded || result.value === undefined) {
            return undefined;
        }
        return [...tmp, result.value];
    }, []);
}
function isObject(value) {
    if (value === null) {
        return false;
    }
    return typeof value === 'object';
}
function createMicroParserBuilder(parse) {
    return (optional) => (v) => {
        if (!optional && v === undefined) {
            return {
                succeeded: false,
                value: undefined,
            };
        }
        if (optional && v === undefined) {
            return {
                succeeded: true,
                value: undefined,
            };
        }
        const result = parse(v);
        return result !== undefined
            ? {
                succeeded: true,
                value: result,
            }
            : {
                succeeded: false,
                value: undefined,
            };
    };
}
function createMicroParserBuilders(optional) {
    return {
        custom: (parse) => createMicroParserBuilder(parse)(optional),
        boolean: createMicroParserBuilder((v) => typeof v === 'boolean' ? v : undefined)(optional),
        number: createMicroParserBuilder((v) => typeof v === 'number' ? v : undefined)(optional),
        string: createMicroParserBuilder((v) => typeof v === 'string' ? v : undefined)(optional),
        function: createMicroParserBuilder((v) =>
        typeof v === 'function' ? v : undefined)(optional),
        constant: (value) => createMicroParserBuilder((v) => (v === value ? value : undefined))(optional),
        raw: createMicroParserBuilder((v) => v)(optional),
        object: (keyToParserMap) => createMicroParserBuilder((v) => {
            if (!isObject(v)) {
                return undefined;
            }
            return parseObject(v, keyToParserMap);
        })(optional),
        array: (itemParser) => createMicroParserBuilder((v) => {
            if (!Array.isArray(v)) {
                return undefined;
            }
            return parseArray(v, itemParser);
        })(optional),
    };
}
const MicroParsers = {
    optional: createMicroParserBuilders(true),
    required: createMicroParserBuilders(false),
};
function parseRecord(value, keyToParserMap) {
    const map = keyToParserMap(MicroParsers);
    const result = MicroParsers.required.object(map)(value);
    return result.succeeded ? result.value : undefined;
}

function importBladeState(state, superImport, parser, callback) {
    if (superImport && !superImport(state)) {
        return false;
    }
    const result = parseRecord(state, parser);
    return result ? callback(result) : false;
}
function exportBladeState(superExport, thisState) {
    var _a;
    return deepMerge((_a = superExport === null || superExport === void 0 ? void 0 : superExport()) !== null && _a !== void 0 ? _a : {}, thisState);
}

function isValueBladeController(bc) {
    return 'value' in bc;
}

function isBindingValue(v) {
    if (!isObject$1(v) || !('binding' in v)) {
        return false;
    }
    const b = v.binding;
    return isBinding(b);
}

const SVG_NS = 'http://www.w3.org/2000/svg';
function forceReflow(element) {
    element.offsetHeight;
}
function disableTransitionTemporarily(element, callback) {
    const t = element.style.transition;
    element.style.transition = 'none';
    callback();
    element.style.transition = t;
}
function supportsTouch(doc) {
    return doc.ontouchstart !== undefined;
}
function getGlobalObject() {
    return globalThis;
}
function getWindowDocument() {
    const globalObj = forceCast(getGlobalObject());
    return globalObj.document;
}
function getCanvasContext(canvasElement) {
    const win = canvasElement.ownerDocument.defaultView;
    if (!win) {
        return null;
    }
    const isBrowser = 'document' in win;
    return isBrowser
        ? canvasElement.getContext('2d', {
            willReadFrequently: true,
        })
        : null;
}
const ICON_ID_TO_INNER_HTML_MAP = {
    check: '<path d="M2 8l4 4l8 -8"/>',
    dropdown: '<path d="M5 7h6l-3 3 z"/>',
    p2dpad: '<path d="M8 4v8"/><path d="M4 8h8"/><circle cx="12" cy="12" r="1.2"/>',
};
function createSvgIconElement(document, iconId) {
    const elem = document.createElementNS(SVG_NS, 'svg');
    elem.innerHTML = ICON_ID_TO_INNER_HTML_MAP[iconId];
    return elem;
}
function insertElementAt(parentElement, element, index) {
    parentElement.insertBefore(element, parentElement.children[index]);
}
function removeElement(element) {
    if (element.parentElement) {
        element.parentElement.removeChild(element);
    }
}
function removeChildElements(element) {
    while (element.children.length > 0) {
        element.removeChild(element.children[0]);
    }
}
function removeChildNodes(element) {
    while (element.childNodes.length > 0) {
        element.removeChild(element.childNodes[0]);
    }
}
function findNextTarget(ev) {
    if (ev.relatedTarget) {
        return forceCast(ev.relatedTarget);
    }
    if ('explicitOriginalTarget' in ev) {
        return ev.explicitOriginalTarget;
    }
    return null;
}

function bindValue(value, applyValue) {
    value.emitter.on('change', (ev) => {
        applyValue(ev.rawValue);
    });
    applyValue(value.rawValue);
}
function bindValueMap(valueMap, key, applyValue) {
    bindValue(valueMap.value(key), applyValue);
}

const PREFIX = 'tp';
function ClassName(viewName) {
    const fn = (opt_elementName, opt_modifier) => {
        return [
            PREFIX,
            '-',
            viewName,
            'v',
            opt_elementName ? `_${opt_elementName}` : '',
            opt_modifier ? `-${opt_modifier}` : '',
        ].join('');
    };
    return fn;
}

const cn$r = ClassName('lbl');
function createLabelNode(doc, label) {
    const frag = doc.createDocumentFragment();
    const lineNodes = label.split('\n').map((line) => {
        return doc.createTextNode(line);
    });
    lineNodes.forEach((lineNode, index) => {
        if (index > 0) {
            frag.appendChild(doc.createElement('br'));
        }
        frag.appendChild(lineNode);
    });
    return frag;
}
class LabelView {
    constructor(doc, config) {
        this.element = doc.createElement('div');
        this.element.classList.add(cn$r());
        config.viewProps.bindClassModifiers(this.element);
        const labelElem = doc.createElement('div');
        labelElem.classList.add(cn$r('l'));
        bindValueMap(config.props, 'label', (value) => {
            if (isEmpty(value)) {
                this.element.classList.add(cn$r(undefined, 'nol'));
            }
            else {
                this.element.classList.remove(cn$r(undefined, 'nol'));
                removeChildNodes(labelElem);
                labelElem.appendChild(createLabelNode(doc, value));
            }
        });
        this.element.appendChild(labelElem);
        this.labelElement = labelElem;
        const valueElem = doc.createElement('div');
        valueElem.classList.add(cn$r('v'));
        this.element.appendChild(valueElem);
        this.valueElement = valueElem;
    }
}

class LabelController {
    constructor(doc, config) {
        this.props = config.props;
        this.valueController = config.valueController;
        this.viewProps = config.valueController.viewProps;
        this.view = new LabelView(doc, {
            props: config.props,
            viewProps: this.viewProps,
        });
        this.view.valueElement.appendChild(this.valueController.view.element);
    }
    importProps(state) {
        return importBladeState(state, null, (p) => ({
            label: p.optional.string,
        }), (result) => {
            this.props.set('label', result.label);
            return true;
        });
    }
    exportProps() {
        return exportBladeState(null, {
            label: this.props.get('label'),
        });
    }
}

function getAllBladePositions() {
    return ['veryfirst', 'first', 'last', 'verylast'];
}

const cn$q = ClassName('');
const POS_TO_CLASS_NAME_MAP = {
    veryfirst: 'vfst',
    first: 'fst',
    last: 'lst',
    verylast: 'vlst',
};
class BladeController {
    constructor(config) {
        this.parent_ = null;
        this.blade = config.blade;
        this.view = config.view;
        this.viewProps = config.viewProps;
        const elem = this.view.element;
        this.blade.value('positions').emitter.on('change', () => {
            getAllBladePositions().forEach((pos) => {
                elem.classList.remove(cn$q(undefined, POS_TO_CLASS_NAME_MAP[pos]));
            });
            this.blade.get('positions').forEach((pos) => {
                elem.classList.add(cn$q(undefined, POS_TO_CLASS_NAME_MAP[pos]));
            });
        });
        this.viewProps.handleDispose(() => {
            removeElement(elem);
        });
    }
    get parent() {
        return this.parent_;
    }
    set parent(parent) {
        this.parent_ = parent;
        this.viewProps.set('parent', this.parent_ ? this.parent_.viewProps : null);
    }
    importState(state) {
        return importBladeState(state, null, (p) => ({
            disabled: p.required.boolean,
            hidden: p.required.boolean,
        }), (result) => {
            this.viewProps.importState(result);
            return true;
        });
    }
    exportState() {
        return exportBladeState(null, Object.assign({}, this.viewProps.exportState()));
    }
}

class LabeledValueBladeController extends BladeController {
    constructor(doc, config) {
        if (config.value !== config.valueController.value) {
            throw TpError.shouldNeverHappen();
        }
        const viewProps = config.valueController.viewProps;
        const lc = new LabelController(doc, {
            blade: config.blade,
            props: config.props,
            valueController: config.valueController,
        });
        super(Object.assign(Object.assign({}, config), { view: new LabelView(doc, {
                props: config.props,
                viewProps: viewProps,
            }), viewProps: viewProps }));
        this.labelController = lc;
        this.value = config.value;
        this.valueController = config.valueController;
        this.view.valueElement.appendChild(this.valueController.view.element);
    }
    importState(state) {
        return importBladeState(state, (s) => {
            var _a, _b, _c;
            return super.importState(s) &&
                this.labelController.importProps(s) &&
                ((_c = (_b = (_a = this.valueController).importProps) === null || _b === void 0 ? void 0 : _b.call(_a, state)) !== null && _c !== void 0 ? _c : true);
        }, (p) => ({
            value: p.optional.raw,
        }), (result) => {
            if (result.value) {
                this.value.rawValue = result.value;
            }
            return true;
        });
    }
    exportState() {
        var _a, _b, _c;
        return exportBladeState(() => super.exportState(), Object.assign(Object.assign({ value: this.value.rawValue }, this.labelController.exportProps()), ((_c = (_b = (_a = this.valueController).exportProps) === null || _b === void 0 ? void 0 : _b.call(_a)) !== null && _c !== void 0 ? _c : {})));
    }
}

function excludeValue(state) {
    const result = Object.assign({}, state);
    delete result.value;
    return result;
}
class BindingController extends LabeledValueBladeController {
    constructor(doc, config) {
        super(doc, config);
        this.tag = config.tag;
    }
    importState(state) {
        return importBladeState(state,
        (_s) => super.importState(excludeValue(state)), (p) => ({
            tag: p.optional.string,
        }), (result) => {
            this.tag = result.tag;
            return true;
        });
    }
    exportState() {
        return exportBladeState(() => excludeValue(super.exportState()), {
            binding: {
                key: this.value.binding.target.key,
                value: this.value.binding.target.read(),
            },
            tag: this.tag,
        });
    }
}
function isBindingController(bc) {
    return isValueBladeController(bc) && isBindingValue(bc.value);
}

class InputBindingController extends BindingController {
    importState(state) {
        return importBladeState(state, (s) => super.importState(s), (p) => ({
            binding: p.required.object({
                value: p.required.raw,
            }),
        }), (result) => {
            this.value.binding.inject(result.binding.value);
            this.value.fetch();
            return true;
        });
    }
}
function isInputBindingController(bc) {
    return isValueBladeController(bc) && isInputBindingValue(bc.value);
}

function fillBuffer(buffer, bufferSize) {
    while (buffer.length < bufferSize) {
        buffer.push(undefined);
    }
}
function initializeBuffer(bufferSize) {
    const buffer = [];
    fillBuffer(buffer, bufferSize);
    return buffer;
}
function createTrimmedBuffer(buffer) {
    const index = buffer.indexOf(undefined);
    return forceCast(index < 0 ? buffer : buffer.slice(0, index));
}
function createPushedBuffer(buffer, newValue) {
    const newBuffer = [...createTrimmedBuffer(buffer), newValue];
    if (newBuffer.length > buffer.length) {
        newBuffer.splice(0, newBuffer.length - buffer.length);
    }
    else {
        fillBuffer(newBuffer, buffer.length);
    }
    return newBuffer;
}

class MonitorBindingValue {
    constructor(config) {
        this.emitter = new Emitter();
        this.onTick_ = this.onTick_.bind(this);
        this.onValueBeforeChange_ = this.onValueBeforeChange_.bind(this);
        this.onValueChange_ = this.onValueChange_.bind(this);
        this.binding = config.binding;
        this.value_ = createValue(initializeBuffer(config.bufferSize));
        this.value_.emitter.on('beforechange', this.onValueBeforeChange_);
        this.value_.emitter.on('change', this.onValueChange_);
        this.ticker = config.ticker;
        this.ticker.emitter.on('tick', this.onTick_);
        this.fetch();
    }
    get rawValue() {
        return this.value_.rawValue;
    }
    set rawValue(rawValue) {
        this.value_.rawValue = rawValue;
    }
    setRawValue(rawValue, options) {
        this.value_.setRawValue(rawValue, options);
    }
    fetch() {
        this.value_.rawValue = createPushedBuffer(this.value_.rawValue, this.binding.read());
    }
    onTick_() {
        this.fetch();
    }
    onValueBeforeChange_(ev) {
        this.emitter.emit('beforechange', Object.assign(Object.assign({}, ev), { sender: this }));
    }
    onValueChange_(ev) {
        this.emitter.emit('change', Object.assign(Object.assign({}, ev), { sender: this }));
    }
}
function isMonitorBindingValue(v) {
    if (!('binding' in v)) {
        return false;
    }
    const b = v['binding'];
    return isBinding(b) && 'read' in b && !('write' in b);
}

class MonitorBindingController extends BindingController {
    exportState() {
        return exportBladeState(() => super.exportState(), {
            binding: {
                readonly: true,
            },
        });
    }
}
function isMonitorBindingController(bc) {
    return (isValueBladeController(bc) &&
        isMonitorBindingValue(bc.value));
}

class ButtonApi extends BladeApi {
    get label() {
        return this.controller.labelController.props.get('label');
    }
    set label(label) {
        this.controller.labelController.props.set('label', label);
    }
    get title() {
        var _a;
        return (_a = this.controller.buttonController.props.get('title')) !== null && _a !== void 0 ? _a : '';
    }
    set title(title) {
        this.controller.buttonController.props.set('title', title);
    }
    on(eventName, handler) {
        const bh = handler.bind(this);
        const emitter = this.controller.buttonController.emitter;
        emitter.on(eventName, (ev) => {
            bh(new TpMouseEvent(this, ev.nativeEvent));
        });
        return this;
    }
    off(eventName, handler) {
        const emitter = this.controller.buttonController.emitter;
        emitter.off(eventName, handler);
        return this;
    }
}

function applyClass(elem, className, active) {
    if (active) {
        elem.classList.add(className);
    }
    else {
        elem.classList.remove(className);
    }
}
function valueToClassName(elem, className) {
    return (value) => {
        applyClass(elem, className, value);
    };
}
function bindValueToTextContent(value, elem) {
    bindValue(value, (text) => {
        elem.textContent = text !== null && text !== void 0 ? text : '';
    });
}

const cn$p = ClassName('btn');
class ButtonView {
    constructor(doc, config) {
        this.element = doc.createElement('div');
        this.element.classList.add(cn$p());
        config.viewProps.bindClassModifiers(this.element);
        const buttonElem = doc.createElement('button');
        buttonElem.classList.add(cn$p('b'));
        config.viewProps.bindDisabled(buttonElem);
        this.element.appendChild(buttonElem);
        this.buttonElement = buttonElem;
        const titleElem = doc.createElement('div');
        titleElem.classList.add(cn$p('t'));
        bindValueToTextContent(config.props.value('title'), titleElem);
        this.buttonElement.appendChild(titleElem);
    }
}

class ButtonController {
    constructor(doc, config) {
        this.emitter = new Emitter();
        this.onClick_ = this.onClick_.bind(this);
        this.props = config.props;
        this.viewProps = config.viewProps;
        this.view = new ButtonView(doc, {
            props: this.props,
            viewProps: this.viewProps,
        });
        this.view.buttonElement.addEventListener('click', this.onClick_);
    }
    importProps(state) {
        return importBladeState(state, null, (p) => ({
            title: p.optional.string,
        }), (result) => {
            this.props.set('title', result.title);
            return true;
        });
    }
    exportProps() {
        return exportBladeState(null, {
            title: this.props.get('title'),
        });
    }
    onClick_(ev) {
        this.emitter.emit('click', {
            nativeEvent: ev,
            sender: this,
        });
    }
}

class ButtonBladeController extends BladeController {
    constructor(doc, config) {
        const bc = new ButtonController(doc, {
            props: config.buttonProps,
            viewProps: config.viewProps,
        });
        const lc = new LabelController(doc, {
            blade: config.blade,
            props: config.labelProps,
            valueController: bc,
        });
        super({
            blade: config.blade,
            view: lc.view,
            viewProps: config.viewProps,
        });
        this.buttonController = bc;
        this.labelController = lc;
    }
    importState(state) {
        return importBladeState(state, (s) => super.importState(s) &&
            this.buttonController.importProps(s) &&
            this.labelController.importProps(s), () => ({}), () => true);
    }
    exportState() {
        return exportBladeState(() => super.exportState(), Object.assign(Object.assign({}, this.buttonController.exportProps()), this.labelController.exportProps()));
    }
}

class Semver {
    constructor(text) {
        const [core, prerelease] = text.split('-');
        const coreComps = core.split('.');
        this.major = parseInt(coreComps[0], 10);
        this.minor = parseInt(coreComps[1], 10);
        this.patch = parseInt(coreComps[2], 10);
        this.prerelease = prerelease !== null && prerelease !== void 0 ? prerelease : null;
    }
    toString() {
        const core = [this.major, this.minor, this.patch].join('.');
        return this.prerelease !== null ? [core, this.prerelease].join('-') : core;
    }
}

const VERSION$1 = new Semver('2.0.5');

function createPlugin(plugin) {
    return Object.assign({ core: VERSION$1 }, plugin);
}

const ButtonBladePlugin = createPlugin({
    id: 'button',
    type: 'blade',
    accept(params) {
        const result = parseRecord(params, (p) => ({
            title: p.required.string,
            view: p.required.constant('button'),
            label: p.optional.string,
        }));
        return result ? { params: result } : null;
    },
    controller(args) {
        return new ButtonBladeController(args.document, {
            blade: args.blade,
            buttonProps: ValueMap.fromObject({
                title: args.params.title,
            }),
            labelProps: ValueMap.fromObject({
                label: args.params.label,
            }),
            viewProps: args.viewProps,
        });
    },
    api(args) {
        if (args.controller instanceof ButtonBladeController) {
            return new ButtonApi(args.controller);
        }
        return null;
    },
});

function addButtonAsBlade(api, params) {
    return api.addBlade(Object.assign(Object.assign({}, params), { view: 'button' }));
}
function addFolderAsBlade(api, params) {
    return api.addBlade(Object.assign(Object.assign({}, params), { view: 'folder' }));
}
function addTabAsBlade(api, params) {
    return api.addBlade(Object.assign(Object.assign({}, params), { view: 'tab' }));
}

function isRefreshable(value) {
    if (!isObject$1(value)) {
        return false;
    }
    return 'refresh' in value && typeof value.refresh === 'function';
}

function createBindingTarget(obj, key) {
    if (!BindingTarget.isBindable(obj)) {
        throw TpError.notBindable();
    }
    return new BindingTarget(obj, key);
}
class RackApi {
    constructor(controller, pool) {
        this.onRackValueChange_ = this.onRackValueChange_.bind(this);
        this.controller_ = controller;
        this.emitter_ = new Emitter();
        this.pool_ = pool;
        const rack = this.controller_.rack;
        rack.emitter.on('valuechange', this.onRackValueChange_);
    }
    get children() {
        return this.controller_.rack.children.map((bc) => this.pool_.createApi(bc));
    }
    addBinding(object, key, opt_params) {
        const params = opt_params !== null && opt_params !== void 0 ? opt_params : {};
        const doc = this.controller_.element.ownerDocument;
        const bc = this.pool_.createBinding(doc, createBindingTarget(object, key), params);
        const api = this.pool_.createBindingApi(bc);
        return this.add(api, params.index);
    }
    addFolder(params) {
        return addFolderAsBlade(this, params);
    }
    addButton(params) {
        return addButtonAsBlade(this, params);
    }
    addTab(params) {
        return addTabAsBlade(this, params);
    }
    add(api, opt_index) {
        const bc = api.controller;
        this.controller_.rack.add(bc, opt_index);
        return api;
    }
    remove(api) {
        this.controller_.rack.remove(api.controller);
    }
    addBlade(params) {
        const doc = this.controller_.element.ownerDocument;
        const bc = this.pool_.createBlade(doc, params);
        const api = this.pool_.createApi(bc);
        return this.add(api, params.index);
    }
    on(eventName, handler) {
        const bh = handler.bind(this);
        this.emitter_.on(eventName, (ev) => {
            bh(ev);
        }, {
            key: handler,
        });
        return this;
    }
    off(eventName, handler) {
        this.emitter_.off(eventName, handler);
        return this;
    }
    refresh() {
        this.children.forEach((c) => {
            if (isRefreshable(c)) {
                c.refresh();
            }
        });
    }
    onRackValueChange_(ev) {
        const bc = ev.bladeController;
        const api = this.pool_.createApi(bc);
        const binding = isBindingValue(bc.value) ? bc.value.binding : null;
        this.emitter_.emit('change', new TpChangeEvent(api, binding ? binding.target.read() : bc.value.rawValue, ev.options.last));
    }
}

class ContainerBladeApi extends BladeApi {
    constructor(controller, pool) {
        super(controller);
        this.rackApi_ = new RackApi(controller.rackController, pool);
    }
    refresh() {
        this.rackApi_.refresh();
    }
}

class ContainerBladeController extends BladeController {
    constructor(config) {
        super({
            blade: config.blade,
            view: config.view,
            viewProps: config.rackController.viewProps,
        });
        this.rackController = config.rackController;
    }
    importState(state) {
        return importBladeState(state, (s) => super.importState(s), (p) => ({
            children: p.required.array(p.required.raw),
        }), (result) => {
            return this.rackController.rack.children.every((c, index) => {
                return c.importState(result.children[index]);
            });
        });
    }
    exportState() {
        return exportBladeState(() => super.exportState(), {
            children: this.rackController.rack.children.map((c) => c.exportState()),
        });
    }
}
function isContainerBladeController(bc) {
    return 'rackController' in bc;
}

class NestedOrderedSet {
    constructor(extract) {
        this.emitter = new Emitter();
        this.items_ = [];
        this.cache_ = new Set();
        this.onSubListAdd_ = this.onSubListAdd_.bind(this);
        this.onSubListRemove_ = this.onSubListRemove_.bind(this);
        this.extract_ = extract;
    }
    get items() {
        return this.items_;
    }
    allItems() {
        return Array.from(this.cache_);
    }
    find(callback) {
        for (const item of this.allItems()) {
            if (callback(item)) {
                return item;
            }
        }
        return null;
    }
    includes(item) {
        return this.cache_.has(item);
    }
    add(item, opt_index) {
        if (this.includes(item)) {
            throw TpError.shouldNeverHappen();
        }
        const index = opt_index !== undefined ? opt_index : this.items_.length;
        this.items_.splice(index, 0, item);
        this.cache_.add(item);
        const subList = this.extract_(item);
        if (subList) {
            subList.emitter.on('add', this.onSubListAdd_);
            subList.emitter.on('remove', this.onSubListRemove_);
            subList.allItems().forEach((i) => {
                this.cache_.add(i);
            });
        }
        this.emitter.emit('add', {
            index: index,
            item: item,
            root: this,
            target: this,
        });
    }
    remove(item) {
        const index = this.items_.indexOf(item);
        if (index < 0) {
            return;
        }
        this.items_.splice(index, 1);
        this.cache_.delete(item);
        const subList = this.extract_(item);
        if (subList) {
            subList.allItems().forEach((i) => {
                this.cache_.delete(i);
            });
            subList.emitter.off('add', this.onSubListAdd_);
            subList.emitter.off('remove', this.onSubListRemove_);
        }
        this.emitter.emit('remove', {
            index: index,
            item: item,
            root: this,
            target: this,
        });
    }
    onSubListAdd_(ev) {
        this.cache_.add(ev.item);
        this.emitter.emit('add', {
            index: ev.index,
            item: ev.item,
            root: this,
            target: ev.target,
        });
    }
    onSubListRemove_(ev) {
        this.cache_.delete(ev.item);
        this.emitter.emit('remove', {
            index: ev.index,
            item: ev.item,
            root: this,
            target: ev.target,
        });
    }
}

function findValueBladeController(bcs, v) {
    for (let i = 0; i < bcs.length; i++) {
        const bc = bcs[i];
        if (isValueBladeController(bc) && bc.value === v) {
            return bc;
        }
    }
    return null;
}
function findSubBladeControllerSet(bc) {
    return isContainerBladeController(bc)
        ? bc.rackController.rack['bcSet_']
        : null;
}
class Rack {
    constructor(config) {
        var _a, _b;
        this.emitter = new Emitter();
        this.onBladePositionsChange_ = this.onBladePositionsChange_.bind(this);
        this.onSetAdd_ = this.onSetAdd_.bind(this);
        this.onSetRemove_ = this.onSetRemove_.bind(this);
        this.onChildDispose_ = this.onChildDispose_.bind(this);
        this.onChildPositionsChange_ = this.onChildPositionsChange_.bind(this);
        this.onChildValueChange_ = this.onChildValueChange_.bind(this);
        this.onChildViewPropsChange_ = this.onChildViewPropsChange_.bind(this);
        this.onRackLayout_ = this.onRackLayout_.bind(this);
        this.onRackValueChange_ = this.onRackValueChange_.bind(this);
        this.blade_ = (_a = config.blade) !== null && _a !== void 0 ? _a : null;
        (_b = this.blade_) === null || _b === void 0 ? void 0 : _b.value('positions').emitter.on('change', this.onBladePositionsChange_);
        this.viewProps = config.viewProps;
        this.bcSet_ = new NestedOrderedSet(findSubBladeControllerSet);
        this.bcSet_.emitter.on('add', this.onSetAdd_);
        this.bcSet_.emitter.on('remove', this.onSetRemove_);
    }
    get children() {
        return this.bcSet_.items;
    }
    add(bc, opt_index) {
        var _a;
        (_a = bc.parent) === null || _a === void 0 ? void 0 : _a.remove(bc);
        bc.parent = this;
        this.bcSet_.add(bc, opt_index);
    }
    remove(bc) {
        bc.parent = null;
        this.bcSet_.remove(bc);
    }
    find(finder) {
        return this.bcSet_.allItems().filter(finder);
    }
    onSetAdd_(ev) {
        this.updatePositions_();
        const root = ev.target === ev.root;
        this.emitter.emit('add', {
            bladeController: ev.item,
            index: ev.index,
            root: root,
            sender: this,
        });
        if (!root) {
            return;
        }
        const bc = ev.item;
        bc.viewProps.emitter.on('change', this.onChildViewPropsChange_);
        bc.blade
            .value('positions')
            .emitter.on('change', this.onChildPositionsChange_);
        bc.viewProps.handleDispose(this.onChildDispose_);
        if (isValueBladeController(bc)) {
            bc.value.emitter.on('change', this.onChildValueChange_);
        }
        else if (isContainerBladeController(bc)) {
            const rack = bc.rackController.rack;
            if (rack) {
                const emitter = rack.emitter;
                emitter.on('layout', this.onRackLayout_);
                emitter.on('valuechange', this.onRackValueChange_);
            }
        }
    }
    onSetRemove_(ev) {
        this.updatePositions_();
        const root = ev.target === ev.root;
        this.emitter.emit('remove', {
            bladeController: ev.item,
            root: root,
            sender: this,
        });
        if (!root) {
            return;
        }
        const bc = ev.item;
        if (isValueBladeController(bc)) {
            bc.value.emitter.off('change', this.onChildValueChange_);
        }
        else if (isContainerBladeController(bc)) {
            const rack = bc.rackController.rack;
            if (rack) {
                const emitter = rack.emitter;
                emitter.off('layout', this.onRackLayout_);
                emitter.off('valuechange', this.onRackValueChange_);
            }
        }
    }
    updatePositions_() {
        const visibleItems = this.bcSet_.items.filter((bc) => !bc.viewProps.get('hidden'));
        const firstVisibleItem = visibleItems[0];
        const lastVisibleItem = visibleItems[visibleItems.length - 1];
        this.bcSet_.items.forEach((bc) => {
            const ps = [];
            if (bc === firstVisibleItem) {
                ps.push('first');
                if (!this.blade_ ||
                    this.blade_.get('positions').includes('veryfirst')) {
                    ps.push('veryfirst');
                }
            }
            if (bc === lastVisibleItem) {
                ps.push('last');
                if (!this.blade_ || this.blade_.get('positions').includes('verylast')) {
                    ps.push('verylast');
                }
            }
            bc.blade.set('positions', ps);
        });
    }
    onChildPositionsChange_() {
        this.updatePositions_();
        this.emitter.emit('layout', {
            sender: this,
        });
    }
    onChildViewPropsChange_(_ev) {
        this.updatePositions_();
        this.emitter.emit('layout', {
            sender: this,
        });
    }
    onChildDispose_() {
        const disposedUcs = this.bcSet_.items.filter((bc) => {
            return bc.viewProps.get('disposed');
        });
        disposedUcs.forEach((bc) => {
            this.bcSet_.remove(bc);
        });
    }
    onChildValueChange_(ev) {
        const bc = findValueBladeController(this.find(isValueBladeController), ev.sender);
        if (!bc) {
            throw TpError.alreadyDisposed();
        }
        this.emitter.emit('valuechange', {
            bladeController: bc,
            options: ev.options,
            sender: this,
        });
    }
    onRackLayout_(_) {
        this.updatePositions_();
        this.emitter.emit('layout', {
            sender: this,
        });
    }
    onRackValueChange_(ev) {
        this.emitter.emit('valuechange', {
            bladeController: ev.bladeController,
            options: ev.options,
            sender: this,
        });
    }
    onBladePositionsChange_() {
        this.updatePositions_();
    }
}

class RackController {
    constructor(config) {
        this.onRackAdd_ = this.onRackAdd_.bind(this);
        this.onRackRemove_ = this.onRackRemove_.bind(this);
        this.element = config.element;
        this.viewProps = config.viewProps;
        const rack = new Rack({
            blade: config.root ? undefined : config.blade,
            viewProps: config.viewProps,
        });
        rack.emitter.on('add', this.onRackAdd_);
        rack.emitter.on('remove', this.onRackRemove_);
        this.rack = rack;
        this.viewProps.handleDispose(() => {
            for (let i = this.rack.children.length - 1; i >= 0; i--) {
                const bc = this.rack.children[i];
                bc.viewProps.set('disposed', true);
            }
        });
    }
    onRackAdd_(ev) {
        if (!ev.root) {
            return;
        }
        insertElementAt(this.element, ev.bladeController.view.element, ev.index);
    }
    onRackRemove_(ev) {
        if (!ev.root) {
            return;
        }
        removeElement(ev.bladeController.view.element);
    }
}

function createBlade() {
    return new ValueMap({
        positions: createValue([], {
            equals: deepEqualsArray,
        }),
    });
}

class Foldable extends ValueMap {
    constructor(valueMap) {
        super(valueMap);
    }
    static create(expanded) {
        const coreObj = {
            completed: true,
            expanded: expanded,
            expandedHeight: null,
            shouldFixHeight: false,
            temporaryExpanded: null,
        };
        const core = ValueMap.createCore(coreObj);
        return new Foldable(core);
    }
    get styleExpanded() {
        var _a;
        return (_a = this.get('temporaryExpanded')) !== null && _a !== void 0 ? _a : this.get('expanded');
    }
    get styleHeight() {
        if (!this.styleExpanded) {
            return '0';
        }
        const exHeight = this.get('expandedHeight');
        if (this.get('shouldFixHeight') && !isEmpty(exHeight)) {
            return `${exHeight}px`;
        }
        return 'auto';
    }
    bindExpandedClass(elem, expandedClassName) {
        const onExpand = () => {
            const expanded = this.styleExpanded;
            if (expanded) {
                elem.classList.add(expandedClassName);
            }
            else {
                elem.classList.remove(expandedClassName);
            }
        };
        bindValueMap(this, 'expanded', onExpand);
        bindValueMap(this, 'temporaryExpanded', onExpand);
    }
    cleanUpTransition() {
        this.set('shouldFixHeight', false);
        this.set('expandedHeight', null);
        this.set('completed', true);
    }
}
function computeExpandedFolderHeight(folder, containerElement) {
    let height = 0;
    disableTransitionTemporarily(containerElement, () => {
        folder.set('expandedHeight', null);
        folder.set('temporaryExpanded', true);
        forceReflow(containerElement);
        height = containerElement.clientHeight;
        folder.set('temporaryExpanded', null);
        forceReflow(containerElement);
    });
    return height;
}
function applyHeight(foldable, elem) {
    elem.style.height = foldable.styleHeight;
}
function bindFoldable(foldable, elem) {
    foldable.value('expanded').emitter.on('beforechange', () => {
        foldable.set('completed', false);
        if (isEmpty(foldable.get('expandedHeight'))) {
            const h = computeExpandedFolderHeight(foldable, elem);
            if (h > 0) {
                foldable.set('expandedHeight', h);
            }
        }
        foldable.set('shouldFixHeight', true);
        forceReflow(elem);
    });
    foldable.emitter.on('change', () => {
        applyHeight(foldable, elem);
    });
    applyHeight(foldable, elem);
    elem.addEventListener('transitionend', (ev) => {
        if (ev.propertyName !== 'height') {
            return;
        }
        foldable.cleanUpTransition();
    });
}

class FolderApi extends ContainerBladeApi {
    constructor(controller, pool) {
        super(controller, pool);
        this.emitter_ = new Emitter();
        this.controller.foldable
            .value('expanded')
            .emitter.on('change', (ev) => {
            this.emitter_.emit('fold', new TpFoldEvent(this, ev.sender.rawValue));
        });
        this.rackApi_.on('change', (ev) => {
            this.emitter_.emit('change', ev);
        });
    }
    get expanded() {
        return this.controller.foldable.get('expanded');
    }
    set expanded(expanded) {
        this.controller.foldable.set('expanded', expanded);
    }
    get title() {
        return this.controller.props.get('title');
    }
    set title(title) {
        this.controller.props.set('title', title);
    }
    get children() {
        return this.rackApi_.children;
    }
    addBinding(object, key, opt_params) {
        return this.rackApi_.addBinding(object, key, opt_params);
    }
    addFolder(params) {
        return this.rackApi_.addFolder(params);
    }
    addButton(params) {
        return this.rackApi_.addButton(params);
    }
    addTab(params) {
        return this.rackApi_.addTab(params);
    }
    add(api, opt_index) {
        return this.rackApi_.add(api, opt_index);
    }
    remove(api) {
        this.rackApi_.remove(api);
    }
    addBlade(params) {
        return this.rackApi_.addBlade(params);
    }
    on(eventName, handler) {
        const bh = handler.bind(this);
        this.emitter_.on(eventName, (ev) => {
            bh(ev);
        }, {
            key: handler,
        });
        return this;
    }
    off(eventName, handler) {
        this.emitter_.off(eventName, handler);
        return this;
    }
}

const bladeContainerClassName = ClassName('cnt');

class FolderView {
    constructor(doc, config) {
        var _a;
        this.className_ = ClassName((_a = config.viewName) !== null && _a !== void 0 ? _a : 'fld');
        this.element = doc.createElement('div');
        this.element.classList.add(this.className_(), bladeContainerClassName());
        config.viewProps.bindClassModifiers(this.element);
        this.foldable_ = config.foldable;
        this.foldable_.bindExpandedClass(this.element, this.className_(undefined, 'expanded'));
        bindValueMap(this.foldable_, 'completed', valueToClassName(this.element, this.className_(undefined, 'cpl')));
        const buttonElem = doc.createElement('button');
        buttonElem.classList.add(this.className_('b'));
        bindValueMap(config.props, 'title', (title) => {
            if (isEmpty(title)) {
                this.element.classList.add(this.className_(undefined, 'not'));
            }
            else {
                this.element.classList.remove(this.className_(undefined, 'not'));
            }
        });
        config.viewProps.bindDisabled(buttonElem);
        this.element.appendChild(buttonElem);
        this.buttonElement = buttonElem;
        const indentElem = doc.createElement('div');
        indentElem.classList.add(this.className_('i'));
        this.element.appendChild(indentElem);
        const titleElem = doc.createElement('div');
        titleElem.classList.add(this.className_('t'));
        bindValueToTextContent(config.props.value('title'), titleElem);
        this.buttonElement.appendChild(titleElem);
        this.titleElement = titleElem;
        const markElem = doc.createElement('div');
        markElem.classList.add(this.className_('m'));
        this.buttonElement.appendChild(markElem);
        const containerElem = doc.createElement('div');
        containerElem.classList.add(this.className_('c'));
        this.element.appendChild(containerElem);
        this.containerElement = containerElem;
    }
}

class FolderController extends ContainerBladeController {
    constructor(doc, config) {
        var _a;
        const foldable = Foldable.create((_a = config.expanded) !== null && _a !== void 0 ? _a : true);
        const view = new FolderView(doc, {
            foldable: foldable,
            props: config.props,
            viewName: config.root ? 'rot' : undefined,
            viewProps: config.viewProps,
        });
        super(Object.assign(Object.assign({}, config), { rackController: new RackController({
                blade: config.blade,
                element: view.containerElement,
                root: config.root,
                viewProps: config.viewProps,
            }), view: view }));
        this.onTitleClick_ = this.onTitleClick_.bind(this);
        this.props = config.props;
        this.foldable = foldable;
        bindFoldable(this.foldable, this.view.containerElement);
        this.rackController.rack.emitter.on('add', () => {
            this.foldable.cleanUpTransition();
        });
        this.rackController.rack.emitter.on('remove', () => {
            this.foldable.cleanUpTransition();
        });
        this.view.buttonElement.addEventListener('click', this.onTitleClick_);
    }
    get document() {
        return this.view.element.ownerDocument;
    }
    importState(state) {
        return importBladeState(state, (s) => super.importState(s), (p) => ({
            expanded: p.required.boolean,
            title: p.optional.string,
        }), (result) => {
            this.foldable.set('expanded', result.expanded);
            this.props.set('title', result.title);
            return true;
        });
    }
    exportState() {
        return exportBladeState(() => super.exportState(), {
            expanded: this.foldable.get('expanded'),
            title: this.props.get('title'),
        });
    }
    onTitleClick_() {
        this.foldable.set('expanded', !this.foldable.get('expanded'));
    }
}

const FolderBladePlugin = createPlugin({
    id: 'folder',
    type: 'blade',
    accept(params) {
        const result = parseRecord(params, (p) => ({
            title: p.required.string,
            view: p.required.constant('folder'),
            expanded: p.optional.boolean,
        }));
        return result ? { params: result } : null;
    },
    controller(args) {
        return new FolderController(args.document, {
            blade: args.blade,
            expanded: args.params.expanded,
            props: ValueMap.fromObject({
                title: args.params.title,
            }),
            viewProps: args.viewProps,
        });
    },
    api(args) {
        if (!(args.controller instanceof FolderController)) {
            return null;
        }
        return new FolderApi(args.controller, args.pool);
    },
});

const cn$o = ClassName('');
function valueToModifier(elem, modifier) {
    return valueToClassName(elem, cn$o(undefined, modifier));
}
class ViewProps extends ValueMap {
    constructor(valueMap) {
        var _a;
        super(valueMap);
        this.onDisabledChange_ = this.onDisabledChange_.bind(this);
        this.onParentChange_ = this.onParentChange_.bind(this);
        this.onParentGlobalDisabledChange_ =
            this.onParentGlobalDisabledChange_.bind(this);
        [this.globalDisabled_, this.setGlobalDisabled_] = createReadonlyValue(createValue(this.getGlobalDisabled_()));
        this.value('disabled').emitter.on('change', this.onDisabledChange_);
        this.value('parent').emitter.on('change', this.onParentChange_);
        (_a = this.get('parent')) === null || _a === void 0 ? void 0 : _a.globalDisabled.emitter.on('change', this.onParentGlobalDisabledChange_);
    }
    static create(opt_initialValue) {
        var _a, _b, _c;
        const initialValue = opt_initialValue !== null && opt_initialValue !== void 0 ? opt_initialValue : {};
        return new ViewProps(ValueMap.createCore({
            disabled: (_a = initialValue.disabled) !== null && _a !== void 0 ? _a : false,
            disposed: false,
            hidden: (_b = initialValue.hidden) !== null && _b !== void 0 ? _b : false,
            parent: (_c = initialValue.parent) !== null && _c !== void 0 ? _c : null,
        }));
    }
    get globalDisabled() {
        return this.globalDisabled_;
    }
    bindClassModifiers(elem) {
        bindValue(this.globalDisabled_, valueToModifier(elem, 'disabled'));
        bindValueMap(this, 'hidden', valueToModifier(elem, 'hidden'));
    }
    bindDisabled(target) {
        bindValue(this.globalDisabled_, (disabled) => {
            target.disabled = disabled;
        });
    }
    bindTabIndex(elem) {
        bindValue(this.globalDisabled_, (disabled) => {
            elem.tabIndex = disabled ? -1 : 0;
        });
    }
    handleDispose(callback) {
        this.value('disposed').emitter.on('change', (disposed) => {
            if (disposed) {
                callback();
            }
        });
    }
    importState(state) {
        this.set('disabled', state.disabled);
        this.set('hidden', state.hidden);
    }
    exportState() {
        return {
            disabled: this.get('disabled'),
            hidden: this.get('hidden'),
        };
    }
    getGlobalDisabled_() {
        const parent = this.get('parent');
        const parentDisabled = parent ? parent.globalDisabled.rawValue : false;
        return parentDisabled || this.get('disabled');
    }
    updateGlobalDisabled_() {
        this.setGlobalDisabled_(this.getGlobalDisabled_());
    }
    onDisabledChange_() {
        this.updateGlobalDisabled_();
    }
    onParentGlobalDisabledChange_() {
        this.updateGlobalDisabled_();
    }
    onParentChange_(ev) {
        var _a;
        const prevParent = ev.previousRawValue;
        prevParent === null || prevParent === void 0 ? void 0 : prevParent.globalDisabled.emitter.off('change', this.onParentGlobalDisabledChange_);
        (_a = this.get('parent')) === null || _a === void 0 ? void 0 : _a.globalDisabled.emitter.on('change', this.onParentGlobalDisabledChange_);
        this.updateGlobalDisabled_();
    }
}

const cn$n = ClassName('tbp');
class TabPageView {
    constructor(doc, config) {
        this.element = doc.createElement('div');
        this.element.classList.add(cn$n());
        config.viewProps.bindClassModifiers(this.element);
        const containerElem = doc.createElement('div');
        containerElem.classList.add(cn$n('c'));
        this.element.appendChild(containerElem);
        this.containerElement = containerElem;
    }
}

const cn$m = ClassName('tbi');
class TabItemView {
    constructor(doc, config) {
        this.element = doc.createElement('div');
        this.element.classList.add(cn$m());
        config.viewProps.bindClassModifiers(this.element);
        bindValueMap(config.props, 'selected', (selected) => {
            if (selected) {
                this.element.classList.add(cn$m(undefined, 'sel'));
            }
            else {
                this.element.classList.remove(cn$m(undefined, 'sel'));
            }
        });
        const buttonElem = doc.createElement('button');
        buttonElem.classList.add(cn$m('b'));
        config.viewProps.bindDisabled(buttonElem);
        this.element.appendChild(buttonElem);
        this.buttonElement = buttonElem;
        const titleElem = doc.createElement('div');
        titleElem.classList.add(cn$m('t'));
        bindValueToTextContent(config.props.value('title'), titleElem);
        this.buttonElement.appendChild(titleElem);
        this.titleElement = titleElem;
    }
}

class TabItemController {
    constructor(doc, config) {
        this.emitter = new Emitter();
        this.onClick_ = this.onClick_.bind(this);
        this.props = config.props;
        this.viewProps = config.viewProps;
        this.view = new TabItemView(doc, {
            props: config.props,
            viewProps: config.viewProps,
        });
        this.view.buttonElement.addEventListener('click', this.onClick_);
    }
    onClick_() {
        this.emitter.emit('click', {
            sender: this,
        });
    }
}

class TabPageController extends ContainerBladeController {
    constructor(doc, config) {
        const view = new TabPageView(doc, {
            viewProps: config.viewProps,
        });
        super(Object.assign(Object.assign({}, config), { rackController: new RackController({
                blade: config.blade,
                element: view.containerElement,
                viewProps: config.viewProps,
            }), view: view }));
        this.onItemClick_ = this.onItemClick_.bind(this);
        this.ic_ = new TabItemController(doc, {
            props: config.itemProps,
            viewProps: ViewProps.create(),
        });
        this.ic_.emitter.on('click', this.onItemClick_);
        this.props = config.props;
        bindValueMap(this.props, 'selected', (selected) => {
            this.itemController.props.set('selected', selected);
            this.viewProps.set('hidden', !selected);
        });
    }
    get itemController() {
        return this.ic_;
    }
    importState(state) {
        return importBladeState(state, (s) => super.importState(s), (p) => ({
            selected: p.required.boolean,
            title: p.required.string,
        }), (result) => {
            this.ic_.props.set('selected', result.selected);
            this.ic_.props.set('title', result.title);
            return true;
        });
    }
    exportState() {
        return exportBladeState(() => super.exportState(), {
            selected: this.ic_.props.get('selected'),
            title: this.ic_.props.get('title'),
        });
    }
    onItemClick_() {
        this.props.set('selected', true);
    }
}

class TabApi extends ContainerBladeApi {
    constructor(controller, pool) {
        super(controller, pool);
        this.emitter_ = new Emitter();
        this.onSelect_ = this.onSelect_.bind(this);
        this.pool_ = pool;
        this.rackApi_.on('change', (ev) => {
            this.emitter_.emit('change', ev);
        });
        this.controller.tab.selectedIndex.emitter.on('change', this.onSelect_);
    }
    get pages() {
        return this.rackApi_.children;
    }
    addPage(params) {
        const doc = this.controller.view.element.ownerDocument;
        const pc = new TabPageController(doc, {
            blade: createBlade(),
            itemProps: ValueMap.fromObject({
                selected: false,
                title: params.title,
            }),
            props: ValueMap.fromObject({
                selected: false,
            }),
            viewProps: ViewProps.create(),
        });
        const papi = this.pool_.createApi(pc);
        return this.rackApi_.add(papi, params.index);
    }
    removePage(index) {
        this.rackApi_.remove(this.rackApi_.children[index]);
    }
    on(eventName, handler) {
        const bh = handler.bind(this);
        this.emitter_.on(eventName, (ev) => {
            bh(ev);
        }, {
            key: handler,
        });
        return this;
    }
    off(eventName, handler) {
        this.emitter_.off(eventName, handler);
        return this;
    }
    onSelect_(ev) {
        this.emitter_.emit('select', new TpTabSelectEvent(this, ev.rawValue));
    }
}

class TabPageApi extends ContainerBladeApi {
    get title() {
        var _a;
        return (_a = this.controller.itemController.props.get('title')) !== null && _a !== void 0 ? _a : '';
    }
    set title(title) {
        this.controller.itemController.props.set('title', title);
    }
    get selected() {
        return this.controller.props.get('selected');
    }
    set selected(selected) {
        this.controller.props.set('selected', selected);
    }
    get children() {
        return this.rackApi_.children;
    }
    addButton(params) {
        return this.rackApi_.addButton(params);
    }
    addFolder(params) {
        return this.rackApi_.addFolder(params);
    }
    addTab(params) {
        return this.rackApi_.addTab(params);
    }
    add(api, opt_index) {
        this.rackApi_.add(api, opt_index);
    }
    remove(api) {
        this.rackApi_.remove(api);
    }
    addBinding(object, key, opt_params) {
        return this.rackApi_.addBinding(object, key, opt_params);
    }
    addBlade(params) {
        return this.rackApi_.addBlade(params);
    }
}

const INDEX_NOT_SELECTED = -1;
class Tab {
    constructor() {
        this.onItemSelectedChange_ = this.onItemSelectedChange_.bind(this);
        this.empty = createValue(true);
        this.selectedIndex = createValue(INDEX_NOT_SELECTED);
        this.items_ = [];
    }
    add(item, opt_index) {
        const index = opt_index !== null && opt_index !== void 0 ? opt_index : this.items_.length;
        this.items_.splice(index, 0, item);
        item.emitter.on('change', this.onItemSelectedChange_);
        this.keepSelection_();
    }
    remove(item) {
        const index = this.items_.indexOf(item);
        if (index < 0) {
            return;
        }
        this.items_.splice(index, 1);
        item.emitter.off('change', this.onItemSelectedChange_);
        this.keepSelection_();
    }
    keepSelection_() {
        if (this.items_.length === 0) {
            this.selectedIndex.rawValue = INDEX_NOT_SELECTED;
            this.empty.rawValue = true;
            return;
        }
        const firstSelIndex = this.items_.findIndex((s) => s.rawValue);
        if (firstSelIndex < 0) {
            this.items_.forEach((s, i) => {
                s.rawValue = i === 0;
            });
            this.selectedIndex.rawValue = 0;
        }
        else {
            this.items_.forEach((s, i) => {
                s.rawValue = i === firstSelIndex;
            });
            this.selectedIndex.rawValue = firstSelIndex;
        }
        this.empty.rawValue = false;
    }
    onItemSelectedChange_(ev) {
        if (ev.rawValue) {
            const index = this.items_.findIndex((s) => s === ev.sender);
            this.items_.forEach((s, i) => {
                s.rawValue = i === index;
            });
            this.selectedIndex.rawValue = index;
        }
        else {
            this.keepSelection_();
        }
    }
}

const cn$l = ClassName('tab');
class TabView {
    constructor(doc, config) {
        this.element = doc.createElement('div');
        this.element.classList.add(cn$l(), bladeContainerClassName());
        config.viewProps.bindClassModifiers(this.element);
        bindValue(config.empty, valueToClassName(this.element, cn$l(undefined, 'nop')));
        const titleElem = doc.createElement('div');
        titleElem.classList.add(cn$l('t'));
        this.element.appendChild(titleElem);
        this.itemsElement = titleElem;
        const indentElem = doc.createElement('div');
        indentElem.classList.add(cn$l('i'));
        this.element.appendChild(indentElem);
        const contentsElem = doc.createElement('div');
        contentsElem.classList.add(cn$l('c'));
        this.element.appendChild(contentsElem);
        this.contentsElement = contentsElem;
    }
}

class TabController extends ContainerBladeController {
    constructor(doc, config) {
        const tab = new Tab();
        const view = new TabView(doc, {
            empty: tab.empty,
            viewProps: config.viewProps,
        });
        super({
            blade: config.blade,
            rackController: new RackController({
                blade: config.blade,
                element: view.contentsElement,
                viewProps: config.viewProps,
            }),
            view: view,
        });
        this.onRackAdd_ = this.onRackAdd_.bind(this);
        this.onRackRemove_ = this.onRackRemove_.bind(this);
        const rack = this.rackController.rack;
        rack.emitter.on('add', this.onRackAdd_);
        rack.emitter.on('remove', this.onRackRemove_);
        this.tab = tab;
    }
    add(pc, opt_index) {
        this.rackController.rack.add(pc, opt_index);
    }
    remove(index) {
        this.rackController.rack.remove(this.rackController.rack.children[index]);
    }
    onRackAdd_(ev) {
        if (!ev.root) {
            return;
        }
        const pc = ev.bladeController;
        insertElementAt(this.view.itemsElement, pc.itemController.view.element, ev.index);
        pc.itemController.viewProps.set('parent', this.viewProps);
        this.tab.add(pc.props.value('selected'));
    }
    onRackRemove_(ev) {
        if (!ev.root) {
            return;
        }
        const pc = ev.bladeController;
        removeElement(pc.itemController.view.element);
        pc.itemController.viewProps.set('parent', null);
        this.tab.remove(pc.props.value('selected'));
    }
}

const TabBladePlugin = createPlugin({
    id: 'tab',
    type: 'blade',
    accept(params) {
        const result = parseRecord(params, (p) => ({
            pages: p.required.array(p.required.object({ title: p.required.string })),
            view: p.required.constant('tab'),
        }));
        if (!result || result.pages.length === 0) {
            return null;
        }
        return { params: result };
    },
    controller(args) {
        const c = new TabController(args.document, {
            blade: args.blade,
            viewProps: args.viewProps,
        });
        args.params.pages.forEach((p) => {
            const pc = new TabPageController(args.document, {
                blade: createBlade(),
                itemProps: ValueMap.fromObject({
                    selected: false,
                    title: p.title,
                }),
                props: ValueMap.fromObject({
                    selected: false,
                }),
                viewProps: ViewProps.create(),
            });
            c.add(pc);
        });
        return c;
    },
    api(args) {
        if (args.controller instanceof TabController) {
            return new TabApi(args.controller, args.pool);
        }
        if (args.controller instanceof TabPageController) {
            return new TabPageApi(args.controller, args.pool);
        }
        return null;
    },
});

function createBladeController(plugin, args) {
    const ac = plugin.accept(args.params);
    if (!ac) {
        return null;
    }
    const params = parseRecord(args.params, (p) => ({
        disabled: p.optional.boolean,
        hidden: p.optional.boolean,
    }));
    return plugin.controller({
        blade: createBlade(),
        document: args.document,
        params: forceCast(Object.assign(Object.assign({}, ac.params), { disabled: params === null || params === void 0 ? void 0 : params.disabled, hidden: params === null || params === void 0 ? void 0 : params.hidden })),
        viewProps: ViewProps.create({
            disabled: params === null || params === void 0 ? void 0 : params.disabled,
            hidden: params === null || params === void 0 ? void 0 : params.hidden,
        }),
    });
}

class ListInputBindingApi extends BindingApi {
    get options() {
        return this.controller.valueController.props.get('options');
    }
    set options(options) {
        this.controller.valueController.props.set('options', options);
    }
}

class ManualTicker {
    constructor() {
        this.disabled = false;
        this.emitter = new Emitter();
    }
    dispose() { }
    tick() {
        if (this.disabled) {
            return;
        }
        this.emitter.emit('tick', {
            sender: this,
        });
    }
}

class IntervalTicker {
    constructor(doc, interval) {
        this.disabled_ = false;
        this.timerId_ = null;
        this.onTick_ = this.onTick_.bind(this);
        this.doc_ = doc;
        this.emitter = new Emitter();
        this.interval_ = interval;
        this.setTimer_();
    }
    get disabled() {
        return this.disabled_;
    }
    set disabled(inactive) {
        this.disabled_ = inactive;
        if (this.disabled_) {
            this.clearTimer_();
        }
        else {
            this.setTimer_();
        }
    }
    dispose() {
        this.clearTimer_();
    }
    clearTimer_() {
        if (this.timerId_ === null) {
            return;
        }
        const win = this.doc_.defaultView;
        if (win) {
            win.clearInterval(this.timerId_);
        }
        this.timerId_ = null;
    }
    setTimer_() {
        this.clearTimer_();
        if (this.interval_ <= 0) {
            return;
        }
        const win = this.doc_.defaultView;
        if (win) {
            this.timerId_ = win.setInterval(this.onTick_, this.interval_);
        }
    }
    onTick_() {
        if (this.disabled_) {
            return;
        }
        this.emitter.emit('tick', {
            sender: this,
        });
    }
}

class CompositeConstraint {
    constructor(constraints) {
        this.constraints = constraints;
    }
    constrain(value) {
        return this.constraints.reduce((result, c) => {
            return c.constrain(result);
        }, value);
    }
}
function findConstraint(c, constraintClass) {
    if (c instanceof constraintClass) {
        return c;
    }
    if (c instanceof CompositeConstraint) {
        const result = c.constraints.reduce((tmpResult, sc) => {
            if (tmpResult) {
                return tmpResult;
            }
            return sc instanceof constraintClass ? sc : null;
        }, null);
        if (result) {
            return result;
        }
    }
    return null;
}

class ListConstraint {
    constructor(options) {
        this.values = ValueMap.fromObject({
            options: options,
        });
    }
    constrain(value) {
        const opts = this.values.get('options');
        if (opts.length === 0) {
            return value;
        }
        const matched = opts.filter((item) => {
            return item.value === value;
        }).length > 0;
        return matched ? value : opts[0].value;
    }
}

function parseListOptions(value) {
    var _a;
    const p = MicroParsers;
    if (Array.isArray(value)) {
        return (_a = parseRecord({ items: value }, (p) => ({
            items: p.required.array(p.required.object({
                text: p.required.string,
                value: p.required.raw,
            })),
        }))) === null || _a === void 0 ? void 0 : _a.items;
    }
    if (typeof value === 'object') {
        return p.required.raw(value)
            .value;
    }
    return undefined;
}
function normalizeListOptions(options) {
    if (Array.isArray(options)) {
        return options;
    }
    const items = [];
    Object.keys(options).forEach((text) => {
        items.push({ text: text, value: options[text] });
    });
    return items;
}
function createListConstraint(options) {
    return !isEmpty(options)
        ? new ListConstraint(normalizeListOptions(forceCast(options)))
        : null;
}

const cn$k = ClassName('lst');
class ListView {
    constructor(doc, config) {
        this.onValueChange_ = this.onValueChange_.bind(this);
        this.props_ = config.props;
        this.element = doc.createElement('div');
        this.element.classList.add(cn$k());
        config.viewProps.bindClassModifiers(this.element);
        const selectElem = doc.createElement('select');
        selectElem.classList.add(cn$k('s'));
        config.viewProps.bindDisabled(selectElem);
        this.element.appendChild(selectElem);
        this.selectElement = selectElem;
        const markElem = doc.createElement('div');
        markElem.classList.add(cn$k('m'));
        markElem.appendChild(createSvgIconElement(doc, 'dropdown'));
        this.element.appendChild(markElem);
        config.value.emitter.on('change', this.onValueChange_);
        this.value_ = config.value;
        bindValueMap(this.props_, 'options', (opts) => {
            removeChildElements(this.selectElement);
            opts.forEach((item) => {
                const optionElem = doc.createElement('option');
                optionElem.textContent = item.text;
                this.selectElement.appendChild(optionElem);
            });
            this.update_();
        });
    }
    update_() {
        const values = this.props_.get('options').map((o) => o.value);
        this.selectElement.selectedIndex = values.indexOf(this.value_.rawValue);
    }
    onValueChange_() {
        this.update_();
    }
}

class ListController {
    constructor(doc, config) {
        this.onSelectChange_ = this.onSelectChange_.bind(this);
        this.props = config.props;
        this.value = config.value;
        this.viewProps = config.viewProps;
        this.view = new ListView(doc, {
            props: this.props,
            value: this.value,
            viewProps: this.viewProps,
        });
        this.view.selectElement.addEventListener('change', this.onSelectChange_);
    }
    onSelectChange_(e) {
        const selectElem = forceCast(e.currentTarget);
        this.value.rawValue =
            this.props.get('options')[selectElem.selectedIndex].value;
    }
    importProps(state) {
        return importBladeState(state, null, (p) => ({
            options: p.required.custom(parseListOptions),
        }), (result) => {
            this.props.set('options', normalizeListOptions(result.options));
            return true;
        });
    }
    exportProps() {
        return exportBladeState(null, {
            options: this.props.get('options'),
        });
    }
}

const cn$j = ClassName('pop');
class PopupView {
    constructor(doc, config) {
        this.element = doc.createElement('div');
        this.element.classList.add(cn$j());
        config.viewProps.bindClassModifiers(this.element);
        bindValue(config.shows, valueToClassName(this.element, cn$j(undefined, 'v')));
    }
}

class PopupController {
    constructor(doc, config) {
        this.shows = createValue(false);
        this.viewProps = config.viewProps;
        this.view = new PopupView(doc, {
            shows: this.shows,
            viewProps: this.viewProps,
        });
    }
}

const cn$i = ClassName('txt');
class TextView {
    constructor(doc, config) {
        this.onChange_ = this.onChange_.bind(this);
        this.element = doc.createElement('div');
        this.element.classList.add(cn$i());
        config.viewProps.bindClassModifiers(this.element);
        this.props_ = config.props;
        this.props_.emitter.on('change', this.onChange_);
        const inputElem = doc.createElement('input');
        inputElem.classList.add(cn$i('i'));
        inputElem.type = 'text';
        config.viewProps.bindDisabled(inputElem);
        this.element.appendChild(inputElem);
        this.inputElement = inputElem;
        config.value.emitter.on('change', this.onChange_);
        this.value_ = config.value;
        this.refresh();
    }
    refresh() {
        const formatter = this.props_.get('formatter');
        this.inputElement.value = formatter(this.value_.rawValue);
    }
    onChange_() {
        this.refresh();
    }
}

class TextController {
    constructor(doc, config) {
        this.onInputChange_ = this.onInputChange_.bind(this);
        this.parser_ = config.parser;
        this.props = config.props;
        this.value = config.value;
        this.viewProps = config.viewProps;
        this.view = new TextView(doc, {
            props: config.props,
            value: this.value,
            viewProps: this.viewProps,
        });
        this.view.inputElement.addEventListener('change', this.onInputChange_);
    }
    onInputChange_(e) {
        const inputElem = forceCast(e.currentTarget);
        const value = inputElem.value;
        const parsedValue = this.parser_(value);
        if (!isEmpty(parsedValue)) {
            this.value.rawValue = parsedValue;
        }
        this.view.refresh();
    }
}

function boolToString(value) {
    return String(value);
}
function boolFromUnknown(value) {
    if (value === 'false') {
        return false;
    }
    return !!value;
}
function BooleanFormatter(value) {
    return boolToString(value);
}

function composeParsers(parsers) {
    return (text) => {
        return parsers.reduce((result, parser) => {
            if (result !== null) {
                return result;
            }
            return parser(text);
        }, null);
    };
}

const innerFormatter = createNumberFormatter(0);
function formatPercentage(value) {
    return innerFormatter(value) + '%';
}

function stringFromUnknown(value) {
    return String(value);
}
function formatString(value) {
    return value;
}

function connectValues({ primary, secondary, forward, backward, }) {
    let changing = false;
    function preventFeedback(callback) {
        if (changing) {
            return;
        }
        changing = true;
        callback();
        changing = false;
    }
    primary.emitter.on('change', (ev) => {
        preventFeedback(() => {
            secondary.setRawValue(forward(primary.rawValue, secondary.rawValue), ev.options);
        });
    });
    secondary.emitter.on('change', (ev) => {
        preventFeedback(() => {
            primary.setRawValue(backward(primary.rawValue, secondary.rawValue), ev.options);
        });
        preventFeedback(() => {
            secondary.setRawValue(forward(primary.rawValue, secondary.rawValue), ev.options);
        });
    });
    preventFeedback(() => {
        secondary.setRawValue(forward(primary.rawValue, secondary.rawValue), {
            forceEmit: false,
            last: true,
        });
    });
}

function getStepForKey(keyScale, keys) {
    const step = keyScale * (keys.altKey ? 0.1 : 1) * (keys.shiftKey ? 10 : 1);
    if (keys.upKey) {
        return +step;
    }
    else if (keys.downKey) {
        return -step;
    }
    return 0;
}
function getVerticalStepKeys(ev) {
    return {
        altKey: ev.altKey,
        downKey: ev.key === 'ArrowDown',
        shiftKey: ev.shiftKey,
        upKey: ev.key === 'ArrowUp',
    };
}
function getHorizontalStepKeys(ev) {
    return {
        altKey: ev.altKey,
        downKey: ev.key === 'ArrowLeft',
        shiftKey: ev.shiftKey,
        upKey: ev.key === 'ArrowRight',
    };
}
function isVerticalArrowKey(key) {
    return key === 'ArrowUp' || key === 'ArrowDown';
}
function isArrowKey(key) {
    return isVerticalArrowKey(key) || key === 'ArrowLeft' || key === 'ArrowRight';
}

function computeOffset$1(ev, elem) {
    var _a, _b;
    const win = elem.ownerDocument.defaultView;
    const rect = elem.getBoundingClientRect();
    return {
        x: ev.pageX - (((_a = (win && win.scrollX)) !== null && _a !== void 0 ? _a : 0) + rect.left),
        y: ev.pageY - (((_b = (win && win.scrollY)) !== null && _b !== void 0 ? _b : 0) + rect.top),
    };
}
class PointerHandler {
    constructor(element) {
        this.lastTouch_ = null;
        this.onDocumentMouseMove_ = this.onDocumentMouseMove_.bind(this);
        this.onDocumentMouseUp_ = this.onDocumentMouseUp_.bind(this);
        this.onMouseDown_ = this.onMouseDown_.bind(this);
        this.onTouchEnd_ = this.onTouchEnd_.bind(this);
        this.onTouchMove_ = this.onTouchMove_.bind(this);
        this.onTouchStart_ = this.onTouchStart_.bind(this);
        this.elem_ = element;
        this.emitter = new Emitter();
        element.addEventListener('touchstart', this.onTouchStart_, {
            passive: false,
        });
        element.addEventListener('touchmove', this.onTouchMove_, {
            passive: true,
        });
        element.addEventListener('touchend', this.onTouchEnd_);
        element.addEventListener('mousedown', this.onMouseDown_);
    }
    computePosition_(offset) {
        const rect = this.elem_.getBoundingClientRect();
        return {
            bounds: {
                width: rect.width,
                height: rect.height,
            },
            point: offset
                ? {
                    x: offset.x,
                    y: offset.y,
                }
                : null,
        };
    }
    onMouseDown_(ev) {
        var _a;
        ev.preventDefault();
        (_a = ev.currentTarget) === null || _a === void 0 ? void 0 : _a.focus();
        const doc = this.elem_.ownerDocument;
        doc.addEventListener('mousemove', this.onDocumentMouseMove_);
        doc.addEventListener('mouseup', this.onDocumentMouseUp_);
        this.emitter.emit('down', {
            altKey: ev.altKey,
            data: this.computePosition_(computeOffset$1(ev, this.elem_)),
            sender: this,
            shiftKey: ev.shiftKey,
        });
    }
    onDocumentMouseMove_(ev) {
        this.emitter.emit('move', {
            altKey: ev.altKey,
            data: this.computePosition_(computeOffset$1(ev, this.elem_)),
            sender: this,
            shiftKey: ev.shiftKey,
        });
    }
    onDocumentMouseUp_(ev) {
        const doc = this.elem_.ownerDocument;
        doc.removeEventListener('mousemove', this.onDocumentMouseMove_);
        doc.removeEventListener('mouseup', this.onDocumentMouseUp_);
        this.emitter.emit('up', {
            altKey: ev.altKey,
            data: this.computePosition_(computeOffset$1(ev, this.elem_)),
            sender: this,
            shiftKey: ev.shiftKey,
        });
    }
    onTouchStart_(ev) {
        ev.preventDefault();
        const touch = ev.targetTouches.item(0);
        const rect = this.elem_.getBoundingClientRect();
        this.emitter.emit('down', {
            altKey: ev.altKey,
            data: this.computePosition_(touch
                ? {
                    x: touch.clientX - rect.left,
                    y: touch.clientY - rect.top,
                }
                : undefined),
            sender: this,
            shiftKey: ev.shiftKey,
        });
        this.lastTouch_ = touch;
    }
    onTouchMove_(ev) {
        const touch = ev.targetTouches.item(0);
        const rect = this.elem_.getBoundingClientRect();
        this.emitter.emit('move', {
            altKey: ev.altKey,
            data: this.computePosition_(touch
                ? {
                    x: touch.clientX - rect.left,
                    y: touch.clientY - rect.top,
                }
                : undefined),
            sender: this,
            shiftKey: ev.shiftKey,
        });
        this.lastTouch_ = touch;
    }
    onTouchEnd_(ev) {
        var _a;
        const touch = (_a = ev.targetTouches.item(0)) !== null && _a !== void 0 ? _a : this.lastTouch_;
        const rect = this.elem_.getBoundingClientRect();
        this.emitter.emit('up', {
            altKey: ev.altKey,
            data: this.computePosition_(touch
                ? {
                    x: touch.clientX - rect.left,
                    y: touch.clientY - rect.top,
                }
                : undefined),
            sender: this,
            shiftKey: ev.shiftKey,
        });
    }
}

const cn$h = ClassName('txt');
class NumberTextView {
    constructor(doc, config) {
        this.onChange_ = this.onChange_.bind(this);
        this.props_ = config.props;
        this.props_.emitter.on('change', this.onChange_);
        this.element = doc.createElement('div');
        this.element.classList.add(cn$h(), cn$h(undefined, 'num'));
        if (config.arrayPosition) {
            this.element.classList.add(cn$h(undefined, config.arrayPosition));
        }
        config.viewProps.bindClassModifiers(this.element);
        const inputElem = doc.createElement('input');
        inputElem.classList.add(cn$h('i'));
        inputElem.type = 'text';
        config.viewProps.bindDisabled(inputElem);
        this.element.appendChild(inputElem);
        this.inputElement = inputElem;
        this.onDraggingChange_ = this.onDraggingChange_.bind(this);
        this.dragging_ = config.dragging;
        this.dragging_.emitter.on('change', this.onDraggingChange_);
        this.element.classList.add(cn$h());
        this.inputElement.classList.add(cn$h('i'));
        const knobElem = doc.createElement('div');
        knobElem.classList.add(cn$h('k'));
        this.element.appendChild(knobElem);
        this.knobElement = knobElem;
        const guideElem = doc.createElementNS(SVG_NS, 'svg');
        guideElem.classList.add(cn$h('g'));
        this.knobElement.appendChild(guideElem);
        const bodyElem = doc.createElementNS(SVG_NS, 'path');
        bodyElem.classList.add(cn$h('gb'));
        guideElem.appendChild(bodyElem);
        this.guideBodyElem_ = bodyElem;
        const headElem = doc.createElementNS(SVG_NS, 'path');
        headElem.classList.add(cn$h('gh'));
        guideElem.appendChild(headElem);
        this.guideHeadElem_ = headElem;
        const tooltipElem = doc.createElement('div');
        tooltipElem.classList.add(ClassName('tt')());
        this.knobElement.appendChild(tooltipElem);
        this.tooltipElem_ = tooltipElem;
        config.value.emitter.on('change', this.onChange_);
        this.value = config.value;
        this.refresh();
    }
    onDraggingChange_(ev) {
        if (ev.rawValue === null) {
            this.element.classList.remove(cn$h(undefined, 'drg'));
            return;
        }
        this.element.classList.add(cn$h(undefined, 'drg'));
        const x = ev.rawValue / this.props_.get('pointerScale');
        const aox = x + (x > 0 ? -1 : x < 0 ? +1 : 0);
        const adx = constrainRange(-aox, -4, +4);
        this.guideHeadElem_.setAttributeNS(null, 'd', [`M ${aox + adx},0 L${aox},4 L${aox + adx},8`, `M ${x},-1 L${x},9`].join(' '));
        this.guideBodyElem_.setAttributeNS(null, 'd', `M 0,4 L${x},4`);
        const formatter = this.props_.get('formatter');
        this.tooltipElem_.textContent = formatter(this.value.rawValue);
        this.tooltipElem_.style.left = `${x}px`;
    }
    refresh() {
        const formatter = this.props_.get('formatter');
        this.inputElement.value = formatter(this.value.rawValue);
    }
    onChange_() {
        this.refresh();
    }
}

class NumberTextController {
    constructor(doc, config) {
        var _a;
        this.originRawValue_ = 0;
        this.onInputChange_ = this.onInputChange_.bind(this);
        this.onInputKeyDown_ = this.onInputKeyDown_.bind(this);
        this.onInputKeyUp_ = this.onInputKeyUp_.bind(this);
        this.onPointerDown_ = this.onPointerDown_.bind(this);
        this.onPointerMove_ = this.onPointerMove_.bind(this);
        this.onPointerUp_ = this.onPointerUp_.bind(this);
        this.parser_ = config.parser;
        this.props = config.props;
        this.sliderProps_ = (_a = config.sliderProps) !== null && _a !== void 0 ? _a : null;
        this.value = config.value;
        this.viewProps = config.viewProps;
        this.dragging_ = createValue(null);
        this.view = new NumberTextView(doc, {
            arrayPosition: config.arrayPosition,
            dragging: this.dragging_,
            props: this.props,
            value: this.value,
            viewProps: this.viewProps,
        });
        this.view.inputElement.addEventListener('change', this.onInputChange_);
        this.view.inputElement.addEventListener('keydown', this.onInputKeyDown_);
        this.view.inputElement.addEventListener('keyup', this.onInputKeyUp_);
        const ph = new PointerHandler(this.view.knobElement);
        ph.emitter.on('down', this.onPointerDown_);
        ph.emitter.on('move', this.onPointerMove_);
        ph.emitter.on('up', this.onPointerUp_);
    }
    constrainValue_(value) {
        var _a, _b;
        const min = (_a = this.sliderProps_) === null || _a === void 0 ? void 0 : _a.get('min');
        const max = (_b = this.sliderProps_) === null || _b === void 0 ? void 0 : _b.get('max');
        let v = value;
        if (min !== undefined) {
            v = Math.max(v, min);
        }
        if (max !== undefined) {
            v = Math.min(v, max);
        }
        return v;
    }
    onInputChange_(e) {
        const inputElem = forceCast(e.currentTarget);
        const value = inputElem.value;
        const parsedValue = this.parser_(value);
        if (!isEmpty(parsedValue)) {
            this.value.rawValue = this.constrainValue_(parsedValue);
        }
        this.view.refresh();
    }
    onInputKeyDown_(ev) {
        const step = getStepForKey(this.props.get('keyScale'), getVerticalStepKeys(ev));
        if (step === 0) {
            return;
        }
        this.value.setRawValue(this.constrainValue_(this.value.rawValue + step), {
            forceEmit: false,
            last: false,
        });
    }
    onInputKeyUp_(ev) {
        const step = getStepForKey(this.props.get('keyScale'), getVerticalStepKeys(ev));
        if (step === 0) {
            return;
        }
        this.value.setRawValue(this.value.rawValue, {
            forceEmit: true,
            last: true,
        });
    }
    onPointerDown_() {
        this.originRawValue_ = this.value.rawValue;
        this.dragging_.rawValue = 0;
    }
    computeDraggingValue_(data) {
        if (!data.point) {
            return null;
        }
        const dx = data.point.x - data.bounds.width / 2;
        return this.constrainValue_(this.originRawValue_ + dx * this.props.get('pointerScale'));
    }
    onPointerMove_(ev) {
        const v = this.computeDraggingValue_(ev.data);
        if (v === null) {
            return;
        }
        this.value.setRawValue(v, {
            forceEmit: false,
            last: false,
        });
        this.dragging_.rawValue = this.value.rawValue - this.originRawValue_;
    }
    onPointerUp_(ev) {
        const v = this.computeDraggingValue_(ev.data);
        if (v === null) {
            return;
        }
        this.value.setRawValue(v, {
            forceEmit: true,
            last: true,
        });
        this.dragging_.rawValue = null;
    }
}

const cn$g = ClassName('sld');
class SliderView {
    constructor(doc, config) {
        this.onChange_ = this.onChange_.bind(this);
        this.props_ = config.props;
        this.props_.emitter.on('change', this.onChange_);
        this.element = doc.createElement('div');
        this.element.classList.add(cn$g());
        config.viewProps.bindClassModifiers(this.element);
        const trackElem = doc.createElement('div');
        trackElem.classList.add(cn$g('t'));
        config.viewProps.bindTabIndex(trackElem);
        this.element.appendChild(trackElem);
        this.trackElement = trackElem;
        const knobElem = doc.createElement('div');
        knobElem.classList.add(cn$g('k'));
        this.trackElement.appendChild(knobElem);
        this.knobElement = knobElem;
        config.value.emitter.on('change', this.onChange_);
        this.value = config.value;
        this.update_();
    }
    update_() {
        const p = constrainRange(mapRange(this.value.rawValue, this.props_.get('min'), this.props_.get('max'), 0, 100), 0, 100);
        this.knobElement.style.width = `${p}%`;
    }
    onChange_() {
        this.update_();
    }
}

class SliderController {
    constructor(doc, config) {
        this.onKeyDown_ = this.onKeyDown_.bind(this);
        this.onKeyUp_ = this.onKeyUp_.bind(this);
        this.onPointerDownOrMove_ = this.onPointerDownOrMove_.bind(this);
        this.onPointerUp_ = this.onPointerUp_.bind(this);
        this.value = config.value;
        this.viewProps = config.viewProps;
        this.props = config.props;
        this.view = new SliderView(doc, {
            props: this.props,
            value: this.value,
            viewProps: this.viewProps,
        });
        this.ptHandler_ = new PointerHandler(this.view.trackElement);
        this.ptHandler_.emitter.on('down', this.onPointerDownOrMove_);
        this.ptHandler_.emitter.on('move', this.onPointerDownOrMove_);
        this.ptHandler_.emitter.on('up', this.onPointerUp_);
        this.view.trackElement.addEventListener('keydown', this.onKeyDown_);
        this.view.trackElement.addEventListener('keyup', this.onKeyUp_);
    }
    handlePointerEvent_(d, opts) {
        if (!d.point) {
            return;
        }
        this.value.setRawValue(mapRange(constrainRange(d.point.x, 0, d.bounds.width), 0, d.bounds.width, this.props.get('min'), this.props.get('max')), opts);
    }
    onPointerDownOrMove_(ev) {
        this.handlePointerEvent_(ev.data, {
            forceEmit: false,
            last: false,
        });
    }
    onPointerUp_(ev) {
        this.handlePointerEvent_(ev.data, {
            forceEmit: true,
            last: true,
        });
    }
    onKeyDown_(ev) {
        const step = getStepForKey(this.props.get('keyScale'), getHorizontalStepKeys(ev));
        if (step === 0) {
            return;
        }
        this.value.setRawValue(this.value.rawValue + step, {
            forceEmit: false,
            last: false,
        });
    }
    onKeyUp_(ev) {
        const step = getStepForKey(this.props.get('keyScale'), getHorizontalStepKeys(ev));
        if (step === 0) {
            return;
        }
        this.value.setRawValue(this.value.rawValue, {
            forceEmit: true,
            last: true,
        });
    }
}

const cn$f = ClassName('sldtxt');
class SliderTextView {
    constructor(doc, config) {
        this.element = doc.createElement('div');
        this.element.classList.add(cn$f());
        const sliderElem = doc.createElement('div');
        sliderElem.classList.add(cn$f('s'));
        this.sliderView_ = config.sliderView;
        sliderElem.appendChild(this.sliderView_.element);
        this.element.appendChild(sliderElem);
        const textElem = doc.createElement('div');
        textElem.classList.add(cn$f('t'));
        this.textView_ = config.textView;
        textElem.appendChild(this.textView_.element);
        this.element.appendChild(textElem);
    }
}

class SliderTextController {
    constructor(doc, config) {
        this.value = config.value;
        this.viewProps = config.viewProps;
        this.sliderC_ = new SliderController(doc, {
            props: config.sliderProps,
            value: config.value,
            viewProps: this.viewProps,
        });
        this.textC_ = new NumberTextController(doc, {
            parser: config.parser,
            props: config.textProps,
            sliderProps: config.sliderProps,
            value: config.value,
            viewProps: config.viewProps,
        });
        this.view = new SliderTextView(doc, {
            sliderView: this.sliderC_.view,
            textView: this.textC_.view,
        });
    }
    get sliderController() {
        return this.sliderC_;
    }
    get textController() {
        return this.textC_;
    }
    importProps(state) {
        return importBladeState(state, null, (p) => ({
            max: p.required.number,
            min: p.required.number,
        }), (result) => {
            const sliderProps = this.sliderC_.props;
            sliderProps.set('max', result.max);
            sliderProps.set('min', result.min);
            return true;
        });
    }
    exportProps() {
        const sliderProps = this.sliderC_.props;
        return exportBladeState(null, {
            max: sliderProps.get('max'),
            min: sliderProps.get('min'),
        });
    }
}
function createSliderTextProps(config) {
    return {
        sliderProps: new ValueMap({
            keyScale: config.keyScale,
            max: config.max,
            min: config.min,
        }),
        textProps: new ValueMap({
            formatter: createValue(config.formatter),
            keyScale: config.keyScale,
            pointerScale: createValue(config.pointerScale),
        }),
    };
}

const CSS_VAR_MAP = {
    containerUnitSize: 'cnt-usz',
};
function getCssVar(key) {
    return `--${CSS_VAR_MAP[key]}`;
}

function createPointDimensionParser(p) {
    return createNumberTextInputParamsParser(p);
}
function parsePointDimensionParams(value) {
    if (!isRecord(value)) {
        return undefined;
    }
    return parseRecord(value, createPointDimensionParser);
}
function createDimensionConstraint(params, initialValue) {
    if (!params) {
        return undefined;
    }
    const constraints = [];
    const cs = createStepConstraint(params, initialValue);
    if (cs) {
        constraints.push(cs);
    }
    const rs = createRangeConstraint(params);
    if (rs) {
        constraints.push(rs);
    }
    return new CompositeConstraint(constraints);
}

function isCompatible(ver) {
    if (!ver) {
        return false;
    }
    return ver.major === VERSION$1.major;
}

function parsePickerLayout(value) {
    if (value === 'inline' || value === 'popup') {
        return value;
    }
    return undefined;
}

function writePrimitive(target, value) {
    target.write(value);
}

const cn$e = ClassName('ckb');
class CheckboxView {
    constructor(doc, config) {
        this.onValueChange_ = this.onValueChange_.bind(this);
        this.element = doc.createElement('div');
        this.element.classList.add(cn$e());
        config.viewProps.bindClassModifiers(this.element);
        const labelElem = doc.createElement('label');
        labelElem.classList.add(cn$e('l'));
        this.element.appendChild(labelElem);
        this.labelElement = labelElem;
        const inputElem = doc.createElement('input');
        inputElem.classList.add(cn$e('i'));
        inputElem.type = 'checkbox';
        this.labelElement.appendChild(inputElem);
        this.inputElement = inputElem;
        config.viewProps.bindDisabled(this.inputElement);
        const wrapperElem = doc.createElement('div');
        wrapperElem.classList.add(cn$e('w'));
        this.labelElement.appendChild(wrapperElem);
        const markElem = createSvgIconElement(doc, 'check');
        wrapperElem.appendChild(markElem);
        config.value.emitter.on('change', this.onValueChange_);
        this.value = config.value;
        this.update_();
    }
    update_() {
        this.inputElement.checked = this.value.rawValue;
    }
    onValueChange_() {
        this.update_();
    }
}

class CheckboxController {
    constructor(doc, config) {
        this.onInputChange_ = this.onInputChange_.bind(this);
        this.onLabelMouseDown_ = this.onLabelMouseDown_.bind(this);
        this.value = config.value;
        this.viewProps = config.viewProps;
        this.view = new CheckboxView(doc, {
            value: this.value,
            viewProps: this.viewProps,
        });
        this.view.inputElement.addEventListener('change', this.onInputChange_);
        this.view.labelElement.addEventListener('mousedown', this.onLabelMouseDown_);
    }
    onInputChange_(ev) {
        const inputElem = forceCast(ev.currentTarget);
        this.value.rawValue = inputElem.checked;
        ev.preventDefault();
        ev.stopPropagation();
    }
    onLabelMouseDown_(ev) {
        ev.preventDefault();
    }
}

function createConstraint$6(params) {
    const constraints = [];
    const lc = createListConstraint(params.options);
    if (lc) {
        constraints.push(lc);
    }
    return new CompositeConstraint(constraints);
}
const BooleanInputPlugin = createPlugin({
    id: 'input-bool',
    type: 'input',
    accept: (value, params) => {
        if (typeof value !== 'boolean') {
            return null;
        }
        const result = parseRecord(params, (p) => ({
            options: p.optional.custom(parseListOptions),
            readonly: p.optional.constant(false),
        }));
        return result
            ? {
                initialValue: value,
                params: result,
            }
            : null;
    },
    binding: {
        reader: (_args) => boolFromUnknown,
        constraint: (args) => createConstraint$6(args.params),
        writer: (_args) => writePrimitive,
    },
    controller: (args) => {
        const doc = args.document;
        const value = args.value;
        const c = args.constraint;
        const lc = c && findConstraint(c, ListConstraint);
        if (lc) {
            return new ListController(doc, {
                props: new ValueMap({
                    options: lc.values.value('options'),
                }),
                value: value,
                viewProps: args.viewProps,
            });
        }
        return new CheckboxController(doc, {
            value: value,
            viewProps: args.viewProps,
        });
    },
    api(args) {
        if (typeof args.controller.value.rawValue !== 'boolean') {
            return null;
        }
        if (args.controller.valueController instanceof ListController) {
            return new ListInputBindingApi(args.controller);
        }
        return null;
    },
});

const cn$d = ClassName('col');
class ColorView {
    constructor(doc, config) {
        this.element = doc.createElement('div');
        this.element.classList.add(cn$d());
        config.foldable.bindExpandedClass(this.element, cn$d(undefined, 'expanded'));
        bindValueMap(config.foldable, 'completed', valueToClassName(this.element, cn$d(undefined, 'cpl')));
        const headElem = doc.createElement('div');
        headElem.classList.add(cn$d('h'));
        this.element.appendChild(headElem);
        const swatchElem = doc.createElement('div');
        swatchElem.classList.add(cn$d('s'));
        headElem.appendChild(swatchElem);
        this.swatchElement = swatchElem;
        const textElem = doc.createElement('div');
        textElem.classList.add(cn$d('t'));
        headElem.appendChild(textElem);
        this.textElement = textElem;
        if (config.pickerLayout === 'inline') {
            const pickerElem = doc.createElement('div');
            pickerElem.classList.add(cn$d('p'));
            this.element.appendChild(pickerElem);
            this.pickerElement = pickerElem;
        }
        else {
            this.pickerElement = null;
        }
    }
}

function rgbToHslInt(r, g, b) {
    const rp = constrainRange(r / 255, 0, 1);
    const gp = constrainRange(g / 255, 0, 1);
    const bp = constrainRange(b / 255, 0, 1);
    const cmax = Math.max(rp, gp, bp);
    const cmin = Math.min(rp, gp, bp);
    const c = cmax - cmin;
    let h = 0;
    let s = 0;
    const l = (cmin + cmax) / 2;
    if (c !== 0) {
        s = c / (1 - Math.abs(cmax + cmin - 1));
        if (rp === cmax) {
            h = (gp - bp) / c;
        }
        else if (gp === cmax) {
            h = 2 + (bp - rp) / c;
        }
        else {
            h = 4 + (rp - gp) / c;
        }
        h = h / 6 + (h < 0 ? 1 : 0);
    }
    return [h * 360, s * 100, l * 100];
}
function hslToRgbInt(h, s, l) {
    const hp = ((h % 360) + 360) % 360;
    const sp = constrainRange(s / 100, 0, 1);
    const lp = constrainRange(l / 100, 0, 1);
    const c = (1 - Math.abs(2 * lp - 1)) * sp;
    const x = c * (1 - Math.abs(((hp / 60) % 2) - 1));
    const m = lp - c / 2;
    let rp, gp, bp;
    if (hp >= 0 && hp < 60) {
        [rp, gp, bp] = [c, x, 0];
    }
    else if (hp >= 60 && hp < 120) {
        [rp, gp, bp] = [x, c, 0];
    }
    else if (hp >= 120 && hp < 180) {
        [rp, gp, bp] = [0, c, x];
    }
    else if (hp >= 180 && hp < 240) {
        [rp, gp, bp] = [0, x, c];
    }
    else if (hp >= 240 && hp < 300) {
        [rp, gp, bp] = [x, 0, c];
    }
    else {
        [rp, gp, bp] = [c, 0, x];
    }
    return [(rp + m) * 255, (gp + m) * 255, (bp + m) * 255];
}
function rgbToHsvInt(r, g, b) {
    const rp = constrainRange(r / 255, 0, 1);
    const gp = constrainRange(g / 255, 0, 1);
    const bp = constrainRange(b / 255, 0, 1);
    const cmax = Math.max(rp, gp, bp);
    const cmin = Math.min(rp, gp, bp);
    const d = cmax - cmin;
    let h;
    if (d === 0) {
        h = 0;
    }
    else if (cmax === rp) {
        h = 60 * (((((gp - bp) / d) % 6) + 6) % 6);
    }
    else if (cmax === gp) {
        h = 60 * ((bp - rp) / d + 2);
    }
    else {
        h = 60 * ((rp - gp) / d + 4);
    }
    const s = cmax === 0 ? 0 : d / cmax;
    const v = cmax;
    return [h, s * 100, v * 100];
}
function hsvToRgbInt(h, s, v) {
    const hp = loopRange(h, 360);
    const sp = constrainRange(s / 100, 0, 1);
    const vp = constrainRange(v / 100, 0, 1);
    const c = vp * sp;
    const x = c * (1 - Math.abs(((hp / 60) % 2) - 1));
    const m = vp - c;
    let rp, gp, bp;
    if (hp >= 0 && hp < 60) {
        [rp, gp, bp] = [c, x, 0];
    }
    else if (hp >= 60 && hp < 120) {
        [rp, gp, bp] = [x, c, 0];
    }
    else if (hp >= 120 && hp < 180) {
        [rp, gp, bp] = [0, c, x];
    }
    else if (hp >= 180 && hp < 240) {
        [rp, gp, bp] = [0, x, c];
    }
    else if (hp >= 240 && hp < 300) {
        [rp, gp, bp] = [x, 0, c];
    }
    else {
        [rp, gp, bp] = [c, 0, x];
    }
    return [(rp + m) * 255, (gp + m) * 255, (bp + m) * 255];
}
function hslToHsvInt(h, s, l) {
    const sd = l + (s * (100 - Math.abs(2 * l - 100))) / (2 * 100);
    return [
        h,
        sd !== 0 ? (s * (100 - Math.abs(2 * l - 100))) / sd : 0,
        l + (s * (100 - Math.abs(2 * l - 100))) / (2 * 100),
    ];
}
function hsvToHslInt(h, s, v) {
    const sd = 100 - Math.abs((v * (200 - s)) / 100 - 100);
    return [h, sd !== 0 ? (s * v) / sd : 0, (v * (200 - s)) / (2 * 100)];
}
function removeAlphaComponent(comps) {
    return [comps[0], comps[1], comps[2]];
}
function appendAlphaComponent(comps, alpha) {
    return [comps[0], comps[1], comps[2], alpha];
}
const MODE_CONVERTER_MAP = {
    hsl: {
        hsl: (h, s, l) => [h, s, l],
        hsv: hslToHsvInt,
        rgb: hslToRgbInt,
    },
    hsv: {
        hsl: hsvToHslInt,
        hsv: (h, s, v) => [h, s, v],
        rgb: hsvToRgbInt,
    },
    rgb: {
        hsl: rgbToHslInt,
        hsv: rgbToHsvInt,
        rgb: (r, g, b) => [r, g, b],
    },
};
function getColorMaxComponents(mode, type) {
    return [
        type === 'float' ? 1 : mode === 'rgb' ? 255 : 360,
        type === 'float' ? 1 : mode === 'rgb' ? 255 : 100,
        type === 'float' ? 1 : mode === 'rgb' ? 255 : 100,
    ];
}
function loopHueRange(hue, max) {
    return hue === max ? max : loopRange(hue, max);
}
function constrainColorComponents(components, mode, type) {
    var _a;
    const ms = getColorMaxComponents(mode, type);
    return [
        mode === 'rgb'
            ? constrainRange(components[0], 0, ms[0])
            : loopHueRange(components[0], ms[0]),
        constrainRange(components[1], 0, ms[1]),
        constrainRange(components[2], 0, ms[2]),
        constrainRange((_a = components[3]) !== null && _a !== void 0 ? _a : 1, 0, 1),
    ];
}
function convertColorType(comps, mode, from, to) {
    const fms = getColorMaxComponents(mode, from);
    const tms = getColorMaxComponents(mode, to);
    return comps.map((c, index) => (c / fms[index]) * tms[index]);
}
function convertColor(components, from, to) {
    const intComps = convertColorType(components, from.mode, from.type, 'int');
    const result = MODE_CONVERTER_MAP[from.mode][to.mode](...intComps);
    return convertColorType(result, to.mode, 'int', to.type);
}

class IntColor {
    static black() {
        return new IntColor([0, 0, 0], 'rgb');
    }
    constructor(comps, mode) {
        this.type = 'int';
        this.mode = mode;
        this.comps_ = constrainColorComponents(comps, mode, this.type);
    }
    getComponents(opt_mode) {
        return appendAlphaComponent(convertColor(removeAlphaComponent(this.comps_), { mode: this.mode, type: this.type }, { mode: opt_mode !== null && opt_mode !== void 0 ? opt_mode : this.mode, type: this.type }), this.comps_[3]);
    }
    toRgbaObject() {
        const rgbComps = this.getComponents('rgb');
        return {
            r: rgbComps[0],
            g: rgbComps[1],
            b: rgbComps[2],
            a: rgbComps[3],
        };
    }
}

const cn$c = ClassName('colp');
class ColorPickerView {
    constructor(doc, config) {
        this.alphaViews_ = null;
        this.element = doc.createElement('div');
        this.element.classList.add(cn$c());
        config.viewProps.bindClassModifiers(this.element);
        const hsvElem = doc.createElement('div');
        hsvElem.classList.add(cn$c('hsv'));
        const svElem = doc.createElement('div');
        svElem.classList.add(cn$c('sv'));
        this.svPaletteView_ = config.svPaletteView;
        svElem.appendChild(this.svPaletteView_.element);
        hsvElem.appendChild(svElem);
        const hElem = doc.createElement('div');
        hElem.classList.add(cn$c('h'));
        this.hPaletteView_ = config.hPaletteView;
        hElem.appendChild(this.hPaletteView_.element);
        hsvElem.appendChild(hElem);
        this.element.appendChild(hsvElem);
        const rgbElem = doc.createElement('div');
        rgbElem.classList.add(cn$c('rgb'));
        this.textsView_ = config.textsView;
        rgbElem.appendChild(this.textsView_.element);
        this.element.appendChild(rgbElem);
        if (config.alphaViews) {
            this.alphaViews_ = {
                palette: config.alphaViews.palette,
                text: config.alphaViews.text,
            };
            const aElem = doc.createElement('div');
            aElem.classList.add(cn$c('a'));
            const apElem = doc.createElement('div');
            apElem.classList.add(cn$c('ap'));
            apElem.appendChild(this.alphaViews_.palette.element);
            aElem.appendChild(apElem);
            const atElem = doc.createElement('div');
            atElem.classList.add(cn$c('at'));
            atElem.appendChild(this.alphaViews_.text.element);
            aElem.appendChild(atElem);
            this.element.appendChild(aElem);
        }
    }
    get allFocusableElements() {
        const elems = [
            this.svPaletteView_.element,
            this.hPaletteView_.element,
            this.textsView_.modeSelectElement,
            ...this.textsView_.inputViews.map((v) => v.inputElement),
        ];
        if (this.alphaViews_) {
            elems.push(this.alphaViews_.palette.element, this.alphaViews_.text.inputElement);
        }
        return elems;
    }
}

function parseColorType(value) {
    return value === 'int' ? 'int' : value === 'float' ? 'float' : undefined;
}
function parseColorInputParams(params) {
    return parseRecord(params, (p) => ({
        color: p.optional.object({
            alpha: p.optional.boolean,
            type: p.optional.custom(parseColorType),
        }),
        expanded: p.optional.boolean,
        picker: p.optional.custom(parsePickerLayout),
        readonly: p.optional.constant(false),
    }));
}
function getKeyScaleForColor(forAlpha) {
    return forAlpha ? 0.1 : 1;
}
function extractColorType(params) {
    var _a;
    return (_a = params.color) === null || _a === void 0 ? void 0 : _a.type;
}

class FloatColor {
    constructor(comps, mode) {
        this.type = 'float';
        this.mode = mode;
        this.comps_ = constrainColorComponents(comps, mode, this.type);
    }
    getComponents(opt_mode) {
        return appendAlphaComponent(convertColor(removeAlphaComponent(this.comps_), { mode: this.mode, type: this.type }, { mode: opt_mode !== null && opt_mode !== void 0 ? opt_mode : this.mode, type: this.type }), this.comps_[3]);
    }
    toRgbaObject() {
        const rgbComps = this.getComponents('rgb');
        return {
            r: rgbComps[0],
            g: rgbComps[1],
            b: rgbComps[2],
            a: rgbComps[3],
        };
    }
}

const TYPE_TO_CONSTRUCTOR_MAP = {
    int: (comps, mode) => new IntColor(comps, mode),
    float: (comps, mode) => new FloatColor(comps, mode),
};
function createColor(comps, mode, type) {
    return TYPE_TO_CONSTRUCTOR_MAP[type](comps, mode);
}
function isFloatColor(c) {
    return c.type === 'float';
}
function isIntColor(c) {
    return c.type === 'int';
}
function convertFloatToInt(cf) {
    const comps = cf.getComponents();
    const ms = getColorMaxComponents(cf.mode, 'int');
    return new IntColor([
        Math.round(mapRange(comps[0], 0, 1, 0, ms[0])),
        Math.round(mapRange(comps[1], 0, 1, 0, ms[1])),
        Math.round(mapRange(comps[2], 0, 1, 0, ms[2])),
        comps[3],
    ], cf.mode);
}
function convertIntToFloat(ci) {
    const comps = ci.getComponents();
    const ms = getColorMaxComponents(ci.mode, 'int');
    return new FloatColor([
        mapRange(comps[0], 0, ms[0], 0, 1),
        mapRange(comps[1], 0, ms[1], 0, 1),
        mapRange(comps[2], 0, ms[2], 0, 1),
        comps[3],
    ], ci.mode);
}
function mapColorType(c, type) {
    if (c.type === type) {
        return c;
    }
    if (isIntColor(c) && type === 'float') {
        return convertIntToFloat(c);
    }
    if (isFloatColor(c) && type === 'int') {
        return convertFloatToInt(c);
    }
    throw TpError.shouldNeverHappen();
}

function equalsStringColorFormat(f1, f2) {
    return (f1.alpha === f2.alpha &&
        f1.mode === f2.mode &&
        f1.notation === f2.notation &&
        f1.type === f2.type);
}
function parseCssNumberOrPercentage(text, max) {
    const m = text.match(/^(.+)%$/);
    if (!m) {
        return Math.min(parseFloat(text), max);
    }
    return Math.min(parseFloat(m[1]) * 0.01 * max, max);
}
const ANGLE_TO_DEG_MAP = {
    deg: (angle) => angle,
    grad: (angle) => (angle * 360) / 400,
    rad: (angle) => (angle * 360) / (2 * Math.PI),
    turn: (angle) => angle * 360,
};
function parseCssNumberOrAngle(text) {
    const m = text.match(/^([0-9.]+?)(deg|grad|rad|turn)$/);
    if (!m) {
        return parseFloat(text);
    }
    const angle = parseFloat(m[1]);
    const unit = m[2];
    return ANGLE_TO_DEG_MAP[unit](angle);
}
function parseFunctionalRgbColorComponents(text) {
    const m = text.match(/^rgb\(\s*([0-9A-Fa-f.]+%?)\s*,\s*([0-9A-Fa-f.]+%?)\s*,\s*([0-9A-Fa-f.]+%?)\s*\)$/);
    if (!m) {
        return null;
    }
    const comps = [
        parseCssNumberOrPercentage(m[1], 255),
        parseCssNumberOrPercentage(m[2], 255),
        parseCssNumberOrPercentage(m[3], 255),
    ];
    if (isNaN(comps[0]) || isNaN(comps[1]) || isNaN(comps[2])) {
        return null;
    }
    return comps;
}
function parseFunctionalRgbColor(text) {
    const comps = parseFunctionalRgbColorComponents(text);
    return comps ? new IntColor(comps, 'rgb') : null;
}
function parseFunctionalRgbaColorComponents(text) {
    const m = text.match(/^rgba\(\s*([0-9A-Fa-f.]+%?)\s*,\s*([0-9A-Fa-f.]+%?)\s*,\s*([0-9A-Fa-f.]+%?)\s*,\s*([0-9A-Fa-f.]+%?)\s*\)$/);
    if (!m) {
        return null;
    }
    const comps = [
        parseCssNumberOrPercentage(m[1], 255),
        parseCssNumberOrPercentage(m[2], 255),
        parseCssNumberOrPercentage(m[3], 255),
        parseCssNumberOrPercentage(m[4], 1),
    ];
    if (isNaN(comps[0]) ||
        isNaN(comps[1]) ||
        isNaN(comps[2]) ||
        isNaN(comps[3])) {
        return null;
    }
    return comps;
}
function parseFunctionalRgbaColor(text) {
    const comps = parseFunctionalRgbaColorComponents(text);
    return comps ? new IntColor(comps, 'rgb') : null;
}
function parseFunctionalHslColorComponents(text) {
    const m = text.match(/^hsl\(\s*([0-9A-Fa-f.]+(?:deg|grad|rad|turn)?)\s*,\s*([0-9A-Fa-f.]+%?)\s*,\s*([0-9A-Fa-f.]+%?)\s*\)$/);
    if (!m) {
        return null;
    }
    const comps = [
        parseCssNumberOrAngle(m[1]),
        parseCssNumberOrPercentage(m[2], 100),
        parseCssNumberOrPercentage(m[3], 100),
    ];
    if (isNaN(comps[0]) || isNaN(comps[1]) || isNaN(comps[2])) {
        return null;
    }
    return comps;
}
function parseFunctionalHslColor(text) {
    const comps = parseFunctionalHslColorComponents(text);
    return comps ? new IntColor(comps, 'hsl') : null;
}
function parseHslaColorComponents(text) {
    const m = text.match(/^hsla\(\s*([0-9A-Fa-f.]+(?:deg|grad|rad|turn)?)\s*,\s*([0-9A-Fa-f.]+%?)\s*,\s*([0-9A-Fa-f.]+%?)\s*,\s*([0-9A-Fa-f.]+%?)\s*\)$/);
    if (!m) {
        return null;
    }
    const comps = [
        parseCssNumberOrAngle(m[1]),
        parseCssNumberOrPercentage(m[2], 100),
        parseCssNumberOrPercentage(m[3], 100),
        parseCssNumberOrPercentage(m[4], 1),
    ];
    if (isNaN(comps[0]) ||
        isNaN(comps[1]) ||
        isNaN(comps[2]) ||
        isNaN(comps[3])) {
        return null;
    }
    return comps;
}
function parseFunctionalHslaColor(text) {
    const comps = parseHslaColorComponents(text);
    return comps ? new IntColor(comps, 'hsl') : null;
}
function parseHexRgbColorComponents(text) {
    const mRgb = text.match(/^#([0-9A-Fa-f])([0-9A-Fa-f])([0-9A-Fa-f])$/);
    if (mRgb) {
        return [
            parseInt(mRgb[1] + mRgb[1], 16),
            parseInt(mRgb[2] + mRgb[2], 16),
            parseInt(mRgb[3] + mRgb[3], 16),
        ];
    }
    const mRrggbb = text.match(/^(?:#|0x)([0-9A-Fa-f]{2})([0-9A-Fa-f]{2})([0-9A-Fa-f]{2})$/);
    if (mRrggbb) {
        return [
            parseInt(mRrggbb[1], 16),
            parseInt(mRrggbb[2], 16),
            parseInt(mRrggbb[3], 16),
        ];
    }
    return null;
}
function parseHexRgbColor(text) {
    const comps = parseHexRgbColorComponents(text);
    return comps ? new IntColor(comps, 'rgb') : null;
}
function parseHexRgbaColorComponents(text) {
    const mRgb = text.match(/^#([0-9A-Fa-f])([0-9A-Fa-f])([0-9A-Fa-f])([0-9A-Fa-f])$/);
    if (mRgb) {
        return [
            parseInt(mRgb[1] + mRgb[1], 16),
            parseInt(mRgb[2] + mRgb[2], 16),
            parseInt(mRgb[3] + mRgb[3], 16),
            mapRange(parseInt(mRgb[4] + mRgb[4], 16), 0, 255, 0, 1),
        ];
    }
    const mRrggbb = text.match(/^(?:#|0x)?([0-9A-Fa-f]{2})([0-9A-Fa-f]{2})([0-9A-Fa-f]{2})([0-9A-Fa-f]{2})$/);
    if (mRrggbb) {
        return [
            parseInt(mRrggbb[1], 16),
            parseInt(mRrggbb[2], 16),
            parseInt(mRrggbb[3], 16),
            mapRange(parseInt(mRrggbb[4], 16), 0, 255, 0, 1),
        ];
    }
    return null;
}
function parseHexRgbaColor(text) {
    const comps = parseHexRgbaColorComponents(text);
    return comps ? new IntColor(comps, 'rgb') : null;
}
function parseObjectRgbColorComponents(text) {
    const m = text.match(/^\{\s*r\s*:\s*([0-9A-Fa-f.]+%?)\s*,\s*g\s*:\s*([0-9A-Fa-f.]+%?)\s*,\s*b\s*:\s*([0-9A-Fa-f.]+%?)\s*\}$/);
    if (!m) {
        return null;
    }
    const comps = [
        parseFloat(m[1]),
        parseFloat(m[2]),
        parseFloat(m[3]),
    ];
    if (isNaN(comps[0]) || isNaN(comps[1]) || isNaN(comps[2])) {
        return null;
    }
    return comps;
}
function createObjectRgbColorParser(type) {
    return (text) => {
        const comps = parseObjectRgbColorComponents(text);
        return comps ? createColor(comps, 'rgb', type) : null;
    };
}
function parseObjectRgbaColorComponents(text) {
    const m = text.match(/^\{\s*r\s*:\s*([0-9A-Fa-f.]+%?)\s*,\s*g\s*:\s*([0-9A-Fa-f.]+%?)\s*,\s*b\s*:\s*([0-9A-Fa-f.]+%?)\s*,\s*a\s*:\s*([0-9A-Fa-f.]+%?)\s*\}$/);
    if (!m) {
        return null;
    }
    const comps = [
        parseFloat(m[1]),
        parseFloat(m[2]),
        parseFloat(m[3]),
        parseFloat(m[4]),
    ];
    if (isNaN(comps[0]) ||
        isNaN(comps[1]) ||
        isNaN(comps[2]) ||
        isNaN(comps[3])) {
        return null;
    }
    return comps;
}
function createObjectRgbaColorParser(type) {
    return (text) => {
        const comps = parseObjectRgbaColorComponents(text);
        return comps ? createColor(comps, 'rgb', type) : null;
    };
}
const PARSER_AND_RESULT = [
    {
        parser: parseHexRgbColorComponents,
        result: {
            alpha: false,
            mode: 'rgb',
            notation: 'hex',
        },
    },
    {
        parser: parseHexRgbaColorComponents,
        result: {
            alpha: true,
            mode: 'rgb',
            notation: 'hex',
        },
    },
    {
        parser: parseFunctionalRgbColorComponents,
        result: {
            alpha: false,
            mode: 'rgb',
            notation: 'func',
        },
    },
    {
        parser: parseFunctionalRgbaColorComponents,
        result: {
            alpha: true,
            mode: 'rgb',
            notation: 'func',
        },
    },
    {
        parser: parseFunctionalHslColorComponents,
        result: {
            alpha: false,
            mode: 'hsl',
            notation: 'func',
        },
    },
    {
        parser: parseHslaColorComponents,
        result: {
            alpha: true,
            mode: 'hsl',
            notation: 'func',
        },
    },
    {
        parser: parseObjectRgbColorComponents,
        result: {
            alpha: false,
            mode: 'rgb',
            notation: 'object',
        },
    },
    {
        parser: parseObjectRgbaColorComponents,
        result: {
            alpha: true,
            mode: 'rgb',
            notation: 'object',
        },
    },
];
function detectStringColor(text) {
    return PARSER_AND_RESULT.reduce((prev, { parser, result: detection }) => {
        if (prev) {
            return prev;
        }
        return parser(text) ? detection : null;
    }, null);
}
function detectStringColorFormat(text, type = 'int') {
    const r = detectStringColor(text);
    if (!r) {
        return null;
    }
    if (r.notation === 'hex' && type !== 'float') {
        return Object.assign(Object.assign({}, r), { type: 'int' });
    }
    if (r.notation === 'func') {
        return Object.assign(Object.assign({}, r), { type: type });
    }
    return null;
}
function createColorStringParser(type) {
    const parsers = [
        parseHexRgbColor,
        parseHexRgbaColor,
        parseFunctionalRgbColor,
        parseFunctionalRgbaColor,
        parseFunctionalHslColor,
        parseFunctionalHslaColor,
    ];
    if (type === 'int') {
        parsers.push(createObjectRgbColorParser('int'), createObjectRgbaColorParser('int'));
    }
    if (type === 'float') {
        parsers.push(createObjectRgbColorParser('float'), createObjectRgbaColorParser('float'));
    }
    const parser = composeParsers(parsers);
    return (text) => {
        const result = parser(text);
        return result ? mapColorType(result, type) : null;
    };
}
function readIntColorString(value) {
    const parser = createColorStringParser('int');
    if (typeof value !== 'string') {
        return IntColor.black();
    }
    const result = parser(value);
    return result !== null && result !== void 0 ? result : IntColor.black();
}
function zerofill(comp) {
    const hex = constrainRange(Math.floor(comp), 0, 255).toString(16);
    return hex.length === 1 ? `0${hex}` : hex;
}
function colorToHexRgbString(value, prefix = '#') {
    const hexes = removeAlphaComponent(value.getComponents('rgb'))
        .map(zerofill)
        .join('');
    return `${prefix}${hexes}`;
}
function colorToHexRgbaString(value, prefix = '#') {
    const rgbaComps = value.getComponents('rgb');
    const hexes = [rgbaComps[0], rgbaComps[1], rgbaComps[2], rgbaComps[3] * 255]
        .map(zerofill)
        .join('');
    return `${prefix}${hexes}`;
}
function colorToFunctionalRgbString(value) {
    const formatter = createNumberFormatter(0);
    const ci = mapColorType(value, 'int');
    const comps = removeAlphaComponent(ci.getComponents('rgb')).map((comp) => formatter(comp));
    return `rgb(${comps.join(', ')})`;
}
function colorToFunctionalRgbaString(value) {
    const aFormatter = createNumberFormatter(2);
    const rgbFormatter = createNumberFormatter(0);
    const ci = mapColorType(value, 'int');
    const comps = ci.getComponents('rgb').map((comp, index) => {
        const formatter = index === 3 ? aFormatter : rgbFormatter;
        return formatter(comp);
    });
    return `rgba(${comps.join(', ')})`;
}
function colorToFunctionalHslString(value) {
    const formatters = [
        createNumberFormatter(0),
        formatPercentage,
        formatPercentage,
    ];
    const ci = mapColorType(value, 'int');
    const comps = removeAlphaComponent(ci.getComponents('hsl')).map((comp, index) => formatters[index](comp));
    return `hsl(${comps.join(', ')})`;
}
function colorToFunctionalHslaString(value) {
    const formatters = [
        createNumberFormatter(0),
        formatPercentage,
        formatPercentage,
        createNumberFormatter(2),
    ];
    const ci = mapColorType(value, 'int');
    const comps = ci
        .getComponents('hsl')
        .map((comp, index) => formatters[index](comp));
    return `hsla(${comps.join(', ')})`;
}
function colorToObjectRgbString(value, type) {
    const formatter = createNumberFormatter(type === 'float' ? 2 : 0);
    const names = ['r', 'g', 'b'];
    const cc = mapColorType(value, type);
    const comps = removeAlphaComponent(cc.getComponents('rgb')).map((comp, index) => `${names[index]}: ${formatter(comp)}`);
    return `{${comps.join(', ')}}`;
}
function createObjectRgbColorFormatter(type) {
    return (value) => colorToObjectRgbString(value, type);
}
function colorToObjectRgbaString(value, type) {
    const aFormatter = createNumberFormatter(2);
    const rgbFormatter = createNumberFormatter(type === 'float' ? 2 : 0);
    const names = ['r', 'g', 'b', 'a'];
    const cc = mapColorType(value, type);
    const comps = cc.getComponents('rgb').map((comp, index) => {
        const formatter = index === 3 ? aFormatter : rgbFormatter;
        return `${names[index]}: ${formatter(comp)}`;
    });
    return `{${comps.join(', ')}}`;
}
function createObjectRgbaColorFormatter(type) {
    return (value) => colorToObjectRgbaString(value, type);
}
const FORMAT_AND_STRINGIFIERS = [
    {
        format: {
            alpha: false,
            mode: 'rgb',
            notation: 'hex',
            type: 'int',
        },
        stringifier: colorToHexRgbString,
    },
    {
        format: {
            alpha: true,
            mode: 'rgb',
            notation: 'hex',
            type: 'int',
        },
        stringifier: colorToHexRgbaString,
    },
    {
        format: {
            alpha: false,
            mode: 'rgb',
            notation: 'func',
            type: 'int',
        },
        stringifier: colorToFunctionalRgbString,
    },
    {
        format: {
            alpha: true,
            mode: 'rgb',
            notation: 'func',
            type: 'int',
        },
        stringifier: colorToFunctionalRgbaString,
    },
    {
        format: {
            alpha: false,
            mode: 'hsl',
            notation: 'func',
            type: 'int',
        },
        stringifier: colorToFunctionalHslString,
    },
    {
        format: {
            alpha: true,
            mode: 'hsl',
            notation: 'func',
            type: 'int',
        },
        stringifier: colorToFunctionalHslaString,
    },
    ...['int', 'float'].reduce((prev, type) => {
        return [
            ...prev,
            {
                format: {
                    alpha: false,
                    mode: 'rgb',
                    notation: 'object',
                    type: type,
                },
                stringifier: createObjectRgbColorFormatter(type),
            },
            {
                format: {
                    alpha: true,
                    mode: 'rgb',
                    notation: 'object',
                    type: type,
                },
                stringifier: createObjectRgbaColorFormatter(type),
            },
        ];
    }, []),
];
function findColorStringifier(format) {
    return FORMAT_AND_STRINGIFIERS.reduce((prev, fas) => {
        if (prev) {
            return prev;
        }
        return equalsStringColorFormat(fas.format, format)
            ? fas.stringifier
            : null;
    }, null);
}

const cn$b = ClassName('apl');
class APaletteView {
    constructor(doc, config) {
        this.onValueChange_ = this.onValueChange_.bind(this);
        this.value = config.value;
        this.value.emitter.on('change', this.onValueChange_);
        this.element = doc.createElement('div');
        this.element.classList.add(cn$b());
        config.viewProps.bindClassModifiers(this.element);
        config.viewProps.bindTabIndex(this.element);
        const barElem = doc.createElement('div');
        barElem.classList.add(cn$b('b'));
        this.element.appendChild(barElem);
        const colorElem = doc.createElement('div');
        colorElem.classList.add(cn$b('c'));
        barElem.appendChild(colorElem);
        this.colorElem_ = colorElem;
        const markerElem = doc.createElement('div');
        markerElem.classList.add(cn$b('m'));
        this.element.appendChild(markerElem);
        this.markerElem_ = markerElem;
        const previewElem = doc.createElement('div');
        previewElem.classList.add(cn$b('p'));
        this.markerElem_.appendChild(previewElem);
        this.previewElem_ = previewElem;
        this.update_();
    }
    update_() {
        const c = this.value.rawValue;
        const rgbaComps = c.getComponents('rgb');
        const leftColor = new IntColor([rgbaComps[0], rgbaComps[1], rgbaComps[2], 0], 'rgb');
        const rightColor = new IntColor([rgbaComps[0], rgbaComps[1], rgbaComps[2], 255], 'rgb');
        const gradientComps = [
            'to right',
            colorToFunctionalRgbaString(leftColor),
            colorToFunctionalRgbaString(rightColor),
        ];
        this.colorElem_.style.background = `linear-gradient(${gradientComps.join(',')})`;
        this.previewElem_.style.backgroundColor = colorToFunctionalRgbaString(c);
        const left = mapRange(rgbaComps[3], 0, 1, 0, 100);
        this.markerElem_.style.left = `${left}%`;
    }
    onValueChange_() {
        this.update_();
    }
}

class APaletteController {
    constructor(doc, config) {
        this.onKeyDown_ = this.onKeyDown_.bind(this);
        this.onKeyUp_ = this.onKeyUp_.bind(this);
        this.onPointerDown_ = this.onPointerDown_.bind(this);
        this.onPointerMove_ = this.onPointerMove_.bind(this);
        this.onPointerUp_ = this.onPointerUp_.bind(this);
        this.value = config.value;
        this.viewProps = config.viewProps;
        this.view = new APaletteView(doc, {
            value: this.value,
            viewProps: this.viewProps,
        });
        this.ptHandler_ = new PointerHandler(this.view.element);
        this.ptHandler_.emitter.on('down', this.onPointerDown_);
        this.ptHandler_.emitter.on('move', this.onPointerMove_);
        this.ptHandler_.emitter.on('up', this.onPointerUp_);
        this.view.element.addEventListener('keydown', this.onKeyDown_);
        this.view.element.addEventListener('keyup', this.onKeyUp_);
    }
    handlePointerEvent_(d, opts) {
        if (!d.point) {
            return;
        }
        const alpha = d.point.x / d.bounds.width;
        const c = this.value.rawValue;
        const [h, s, v] = c.getComponents('hsv');
        this.value.setRawValue(new IntColor([h, s, v, alpha], 'hsv'), opts);
    }
    onPointerDown_(ev) {
        this.handlePointerEvent_(ev.data, {
            forceEmit: false,
            last: false,
        });
    }
    onPointerMove_(ev) {
        this.handlePointerEvent_(ev.data, {
            forceEmit: false,
            last: false,
        });
    }
    onPointerUp_(ev) {
        this.handlePointerEvent_(ev.data, {
            forceEmit: true,
            last: true,
        });
    }
    onKeyDown_(ev) {
        const step = getStepForKey(getKeyScaleForColor(true), getHorizontalStepKeys(ev));
        if (step === 0) {
            return;
        }
        const c = this.value.rawValue;
        const [h, s, v, a] = c.getComponents('hsv');
        this.value.setRawValue(new IntColor([h, s, v, a + step], 'hsv'), {
            forceEmit: false,
            last: false,
        });
    }
    onKeyUp_(ev) {
        const step = getStepForKey(getKeyScaleForColor(true), getHorizontalStepKeys(ev));
        if (step === 0) {
            return;
        }
        this.value.setRawValue(this.value.rawValue, {
            forceEmit: true,
            last: true,
        });
    }
}

const cn$a = ClassName('coltxt');
function createModeSelectElement(doc) {
    const selectElem = doc.createElement('select');
    const items = [
        { text: 'RGB', value: 'rgb' },
        { text: 'HSL', value: 'hsl' },
        { text: 'HSV', value: 'hsv' },
        { text: 'HEX', value: 'hex' },
    ];
    selectElem.appendChild(items.reduce((frag, item) => {
        const optElem = doc.createElement('option');
        optElem.textContent = item.text;
        optElem.value = item.value;
        frag.appendChild(optElem);
        return frag;
    }, doc.createDocumentFragment()));
    return selectElem;
}
class ColorTextsView {
    constructor(doc, config) {
        this.element = doc.createElement('div');
        this.element.classList.add(cn$a());
        config.viewProps.bindClassModifiers(this.element);
        const modeElem = doc.createElement('div');
        modeElem.classList.add(cn$a('m'));
        this.modeElem_ = createModeSelectElement(doc);
        this.modeElem_.classList.add(cn$a('ms'));
        modeElem.appendChild(this.modeSelectElement);
        config.viewProps.bindDisabled(this.modeElem_);
        const modeMarkerElem = doc.createElement('div');
        modeMarkerElem.classList.add(cn$a('mm'));
        modeMarkerElem.appendChild(createSvgIconElement(doc, 'dropdown'));
        modeElem.appendChild(modeMarkerElem);
        this.element.appendChild(modeElem);
        const inputsElem = doc.createElement('div');
        inputsElem.classList.add(cn$a('w'));
        this.element.appendChild(inputsElem);
        this.inputsElem_ = inputsElem;
        this.inputViews_ = config.inputViews;
        this.applyInputViews_();
        bindValue(config.mode, (mode) => {
            this.modeElem_.value = mode;
        });
    }
    get modeSelectElement() {
        return this.modeElem_;
    }
    get inputViews() {
        return this.inputViews_;
    }
    set inputViews(inputViews) {
        this.inputViews_ = inputViews;
        this.applyInputViews_();
    }
    applyInputViews_() {
        removeChildElements(this.inputsElem_);
        const doc = this.element.ownerDocument;
        this.inputViews_.forEach((v) => {
            const compElem = doc.createElement('div');
            compElem.classList.add(cn$a('c'));
            compElem.appendChild(v.element);
            this.inputsElem_.appendChild(compElem);
        });
    }
}

function createFormatter$2(type) {
    return createNumberFormatter(type === 'float' ? 2 : 0);
}
function createConstraint$5(mode, type, index) {
    const max = getColorMaxComponents(mode, type)[index];
    return new DefiniteRangeConstraint({
        min: 0,
        max: max,
    });
}
function createComponentController(doc, config, index) {
    return new NumberTextController(doc, {
        arrayPosition: index === 0 ? 'fst' : index === 3 - 1 ? 'lst' : 'mid',
        parser: config.parser,
        props: ValueMap.fromObject({
            formatter: createFormatter$2(config.colorType),
            keyScale: getKeyScaleForColor(false),
            pointerScale: config.colorType === 'float' ? 0.01 : 1,
        }),
        value: createValue(0, {
            constraint: createConstraint$5(config.colorMode, config.colorType, index),
        }),
        viewProps: config.viewProps,
    });
}
function createComponentControllers(doc, config) {
    const cc = {
        colorMode: config.colorMode,
        colorType: config.colorType,
        parser: parseNumber,
        viewProps: config.viewProps,
    };
    return [0, 1, 2].map((i) => {
        const c = createComponentController(doc, cc, i);
        connectValues({
            primary: config.value,
            secondary: c.value,
            forward(p) {
                const mc = mapColorType(p, config.colorType);
                return mc.getComponents(config.colorMode)[i];
            },
            backward(p, s) {
                const pickedMode = config.colorMode;
                const mc = mapColorType(p, config.colorType);
                const comps = mc.getComponents(pickedMode);
                comps[i] = s;
                const c = createColor(appendAlphaComponent(removeAlphaComponent(comps), comps[3]), pickedMode, config.colorType);
                return mapColorType(c, 'int');
            },
        });
        return c;
    });
}
function createHexController(doc, config) {
    const c = new TextController(doc, {
        parser: createColorStringParser('int'),
        props: ValueMap.fromObject({
            formatter: colorToHexRgbString,
        }),
        value: createValue(IntColor.black()),
        viewProps: config.viewProps,
    });
    connectValues({
        primary: config.value,
        secondary: c.value,
        forward: (p) => new IntColor(removeAlphaComponent(p.getComponents()), p.mode),
        backward: (p, s) => new IntColor(appendAlphaComponent(removeAlphaComponent(s.getComponents(p.mode)), p.getComponents()[3]), p.mode),
    });
    return [c];
}
function isColorMode(mode) {
    return mode !== 'hex';
}
class ColorTextsController {
    constructor(doc, config) {
        this.onModeSelectChange_ = this.onModeSelectChange_.bind(this);
        this.colorType_ = config.colorType;
        this.value = config.value;
        this.viewProps = config.viewProps;
        this.colorMode = createValue(this.value.rawValue.mode);
        this.ccs_ = this.createComponentControllers_(doc);
        this.view = new ColorTextsView(doc, {
            mode: this.colorMode,
            inputViews: [this.ccs_[0].view, this.ccs_[1].view, this.ccs_[2].view],
            viewProps: this.viewProps,
        });
        this.view.modeSelectElement.addEventListener('change', this.onModeSelectChange_);
    }
    createComponentControllers_(doc) {
        const mode = this.colorMode.rawValue;
        if (isColorMode(mode)) {
            return createComponentControllers(doc, {
                colorMode: mode,
                colorType: this.colorType_,
                value: this.value,
                viewProps: this.viewProps,
            });
        }
        return createHexController(doc, {
            value: this.value,
            viewProps: this.viewProps,
        });
    }
    onModeSelectChange_(ev) {
        const selectElem = ev.currentTarget;
        this.colorMode.rawValue = selectElem.value;
        this.ccs_ = this.createComponentControllers_(this.view.element.ownerDocument);
        this.view.inputViews = this.ccs_.map((cc) => cc.view);
    }
}

const cn$9 = ClassName('hpl');
class HPaletteView {
    constructor(doc, config) {
        this.onValueChange_ = this.onValueChange_.bind(this);
        this.value = config.value;
        this.value.emitter.on('change', this.onValueChange_);
        this.element = doc.createElement('div');
        this.element.classList.add(cn$9());
        config.viewProps.bindClassModifiers(this.element);
        config.viewProps.bindTabIndex(this.element);
        const colorElem = doc.createElement('div');
        colorElem.classList.add(cn$9('c'));
        this.element.appendChild(colorElem);
        const markerElem = doc.createElement('div');
        markerElem.classList.add(cn$9('m'));
        this.element.appendChild(markerElem);
        this.markerElem_ = markerElem;
        this.update_();
    }
    update_() {
        const c = this.value.rawValue;
        const [h] = c.getComponents('hsv');
        this.markerElem_.style.backgroundColor = colorToFunctionalRgbString(new IntColor([h, 100, 100], 'hsv'));
        const left = mapRange(h, 0, 360, 0, 100);
        this.markerElem_.style.left = `${left}%`;
    }
    onValueChange_() {
        this.update_();
    }
}

class HPaletteController {
    constructor(doc, config) {
        this.onKeyDown_ = this.onKeyDown_.bind(this);
        this.onKeyUp_ = this.onKeyUp_.bind(this);
        this.onPointerDown_ = this.onPointerDown_.bind(this);
        this.onPointerMove_ = this.onPointerMove_.bind(this);
        this.onPointerUp_ = this.onPointerUp_.bind(this);
        this.value = config.value;
        this.viewProps = config.viewProps;
        this.view = new HPaletteView(doc, {
            value: this.value,
            viewProps: this.viewProps,
        });
        this.ptHandler_ = new PointerHandler(this.view.element);
        this.ptHandler_.emitter.on('down', this.onPointerDown_);
        this.ptHandler_.emitter.on('move', this.onPointerMove_);
        this.ptHandler_.emitter.on('up', this.onPointerUp_);
        this.view.element.addEventListener('keydown', this.onKeyDown_);
        this.view.element.addEventListener('keyup', this.onKeyUp_);
    }
    handlePointerEvent_(d, opts) {
        if (!d.point) {
            return;
        }
        const hue = mapRange(constrainRange(d.point.x, 0, d.bounds.width), 0, d.bounds.width, 0, 360);
        const c = this.value.rawValue;
        const [, s, v, a] = c.getComponents('hsv');
        this.value.setRawValue(new IntColor([hue, s, v, a], 'hsv'), opts);
    }
    onPointerDown_(ev) {
        this.handlePointerEvent_(ev.data, {
            forceEmit: false,
            last: false,
        });
    }
    onPointerMove_(ev) {
        this.handlePointerEvent_(ev.data, {
            forceEmit: false,
            last: false,
        });
    }
    onPointerUp_(ev) {
        this.handlePointerEvent_(ev.data, {
            forceEmit: true,
            last: true,
        });
    }
    onKeyDown_(ev) {
        const step = getStepForKey(getKeyScaleForColor(false), getHorizontalStepKeys(ev));
        if (step === 0) {
            return;
        }
        const c = this.value.rawValue;
        const [h, s, v, a] = c.getComponents('hsv');
        this.value.setRawValue(new IntColor([h + step, s, v, a], 'hsv'), {
            forceEmit: false,
            last: false,
        });
    }
    onKeyUp_(ev) {
        const step = getStepForKey(getKeyScaleForColor(false), getHorizontalStepKeys(ev));
        if (step === 0) {
            return;
        }
        this.value.setRawValue(this.value.rawValue, {
            forceEmit: true,
            last: true,
        });
    }
}

const cn$8 = ClassName('svp');
const CANVAS_RESOL = 64;
class SvPaletteView {
    constructor(doc, config) {
        this.onValueChange_ = this.onValueChange_.bind(this);
        this.value = config.value;
        this.value.emitter.on('change', this.onValueChange_);
        this.element = doc.createElement('div');
        this.element.classList.add(cn$8());
        config.viewProps.bindClassModifiers(this.element);
        config.viewProps.bindTabIndex(this.element);
        const canvasElem = doc.createElement('canvas');
        canvasElem.height = CANVAS_RESOL;
        canvasElem.width = CANVAS_RESOL;
        canvasElem.classList.add(cn$8('c'));
        this.element.appendChild(canvasElem);
        this.canvasElement = canvasElem;
        const markerElem = doc.createElement('div');
        markerElem.classList.add(cn$8('m'));
        this.element.appendChild(markerElem);
        this.markerElem_ = markerElem;
        this.update_();
    }
    update_() {
        const ctx = getCanvasContext(this.canvasElement);
        if (!ctx) {
            return;
        }
        const c = this.value.rawValue;
        const hsvComps = c.getComponents('hsv');
        const width = this.canvasElement.width;
        const height = this.canvasElement.height;
        const imgData = ctx.getImageData(0, 0, width, height);
        const data = imgData.data;
        for (let iy = 0; iy < height; iy++) {
            for (let ix = 0; ix < width; ix++) {
                const s = mapRange(ix, 0, width, 0, 100);
                const v = mapRange(iy, 0, height, 100, 0);
                const rgbComps = hsvToRgbInt(hsvComps[0], s, v);
                const i = (iy * width + ix) * 4;
                data[i] = rgbComps[0];
                data[i + 1] = rgbComps[1];
                data[i + 2] = rgbComps[2];
                data[i + 3] = 255;
            }
        }
        ctx.putImageData(imgData, 0, 0);
        const left = mapRange(hsvComps[1], 0, 100, 0, 100);
        this.markerElem_.style.left = `${left}%`;
        const top = mapRange(hsvComps[2], 0, 100, 100, 0);
        this.markerElem_.style.top = `${top}%`;
    }
    onValueChange_() {
        this.update_();
    }
}

class SvPaletteController {
    constructor(doc, config) {
        this.onKeyDown_ = this.onKeyDown_.bind(this);
        this.onKeyUp_ = this.onKeyUp_.bind(this);
        this.onPointerDown_ = this.onPointerDown_.bind(this);
        this.onPointerMove_ = this.onPointerMove_.bind(this);
        this.onPointerUp_ = this.onPointerUp_.bind(this);
        this.value = config.value;
        this.viewProps = config.viewProps;
        this.view = new SvPaletteView(doc, {
            value: this.value,
            viewProps: this.viewProps,
        });
        this.ptHandler_ = new PointerHandler(this.view.element);
        this.ptHandler_.emitter.on('down', this.onPointerDown_);
        this.ptHandler_.emitter.on('move', this.onPointerMove_);
        this.ptHandler_.emitter.on('up', this.onPointerUp_);
        this.view.element.addEventListener('keydown', this.onKeyDown_);
        this.view.element.addEventListener('keyup', this.onKeyUp_);
    }
    handlePointerEvent_(d, opts) {
        if (!d.point) {
            return;
        }
        const saturation = mapRange(d.point.x, 0, d.bounds.width, 0, 100);
        const value = mapRange(d.point.y, 0, d.bounds.height, 100, 0);
        const [h, , , a] = this.value.rawValue.getComponents('hsv');
        this.value.setRawValue(new IntColor([h, saturation, value, a], 'hsv'), opts);
    }
    onPointerDown_(ev) {
        this.handlePointerEvent_(ev.data, {
            forceEmit: false,
            last: false,
        });
    }
    onPointerMove_(ev) {
        this.handlePointerEvent_(ev.data, {
            forceEmit: false,
            last: false,
        });
    }
    onPointerUp_(ev) {
        this.handlePointerEvent_(ev.data, {
            forceEmit: true,
            last: true,
        });
    }
    onKeyDown_(ev) {
        if (isArrowKey(ev.key)) {
            ev.preventDefault();
        }
        const [h, s, v, a] = this.value.rawValue.getComponents('hsv');
        const keyScale = getKeyScaleForColor(false);
        const ds = getStepForKey(keyScale, getHorizontalStepKeys(ev));
        const dv = getStepForKey(keyScale, getVerticalStepKeys(ev));
        if (ds === 0 && dv === 0) {
            return;
        }
        this.value.setRawValue(new IntColor([h, s + ds, v + dv, a], 'hsv'), {
            forceEmit: false,
            last: false,
        });
    }
    onKeyUp_(ev) {
        const keyScale = getKeyScaleForColor(false);
        const ds = getStepForKey(keyScale, getHorizontalStepKeys(ev));
        const dv = getStepForKey(keyScale, getVerticalStepKeys(ev));
        if (ds === 0 && dv === 0) {
            return;
        }
        this.value.setRawValue(this.value.rawValue, {
            forceEmit: true,
            last: true,
        });
    }
}

class ColorPickerController {
    constructor(doc, config) {
        this.value = config.value;
        this.viewProps = config.viewProps;
        this.hPaletteC_ = new HPaletteController(doc, {
            value: this.value,
            viewProps: this.viewProps,
        });
        this.svPaletteC_ = new SvPaletteController(doc, {
            value: this.value,
            viewProps: this.viewProps,
        });
        this.alphaIcs_ = config.supportsAlpha
            ? {
                palette: new APaletteController(doc, {
                    value: this.value,
                    viewProps: this.viewProps,
                }),
                text: new NumberTextController(doc, {
                    parser: parseNumber,
                    props: ValueMap.fromObject({
                        pointerScale: 0.01,
                        keyScale: 0.1,
                        formatter: createNumberFormatter(2),
                    }),
                    value: createValue(0, {
                        constraint: new DefiniteRangeConstraint({ min: 0, max: 1 }),
                    }),
                    viewProps: this.viewProps,
                }),
            }
            : null;
        if (this.alphaIcs_) {
            connectValues({
                primary: this.value,
                secondary: this.alphaIcs_.text.value,
                forward: (p) => p.getComponents()[3],
                backward: (p, s) => {
                    const comps = p.getComponents();
                    comps[3] = s;
                    return new IntColor(comps, p.mode);
                },
            });
        }
        this.textsC_ = new ColorTextsController(doc, {
            colorType: config.colorType,
            value: this.value,
            viewProps: this.viewProps,
        });
        this.view = new ColorPickerView(doc, {
            alphaViews: this.alphaIcs_
                ? {
                    palette: this.alphaIcs_.palette.view,
                    text: this.alphaIcs_.text.view,
                }
                : null,
            hPaletteView: this.hPaletteC_.view,
            supportsAlpha: config.supportsAlpha,
            svPaletteView: this.svPaletteC_.view,
            textsView: this.textsC_.view,
            viewProps: this.viewProps,
        });
    }
    get textsController() {
        return this.textsC_;
    }
}

const cn$7 = ClassName('colsw');
class ColorSwatchView {
    constructor(doc, config) {
        this.onValueChange_ = this.onValueChange_.bind(this);
        config.value.emitter.on('change', this.onValueChange_);
        this.value = config.value;
        this.element = doc.createElement('div');
        this.element.classList.add(cn$7());
        config.viewProps.bindClassModifiers(this.element);
        const swatchElem = doc.createElement('div');
        swatchElem.classList.add(cn$7('sw'));
        this.element.appendChild(swatchElem);
        this.swatchElem_ = swatchElem;
        const buttonElem = doc.createElement('button');
        buttonElem.classList.add(cn$7('b'));
        config.viewProps.bindDisabled(buttonElem);
        this.element.appendChild(buttonElem);
        this.buttonElement = buttonElem;
        this.update_();
    }
    update_() {
        const value = this.value.rawValue;
        this.swatchElem_.style.backgroundColor = colorToHexRgbaString(value);
    }
    onValueChange_() {
        this.update_();
    }
}

class ColorSwatchController {
    constructor(doc, config) {
        this.value = config.value;
        this.viewProps = config.viewProps;
        this.view = new ColorSwatchView(doc, {
            value: this.value,
            viewProps: this.viewProps,
        });
    }
}

class ColorController {
    constructor(doc, config) {
        this.onButtonBlur_ = this.onButtonBlur_.bind(this);
        this.onButtonClick_ = this.onButtonClick_.bind(this);
        this.onPopupChildBlur_ = this.onPopupChildBlur_.bind(this);
        this.onPopupChildKeydown_ = this.onPopupChildKeydown_.bind(this);
        this.value = config.value;
        this.viewProps = config.viewProps;
        this.foldable_ = Foldable.create(config.expanded);
        this.swatchC_ = new ColorSwatchController(doc, {
            value: this.value,
            viewProps: this.viewProps,
        });
        const buttonElem = this.swatchC_.view.buttonElement;
        buttonElem.addEventListener('blur', this.onButtonBlur_);
        buttonElem.addEventListener('click', this.onButtonClick_);
        this.textC_ = new TextController(doc, {
            parser: config.parser,
            props: ValueMap.fromObject({
                formatter: config.formatter,
            }),
            value: this.value,
            viewProps: this.viewProps,
        });
        this.view = new ColorView(doc, {
            foldable: this.foldable_,
            pickerLayout: config.pickerLayout,
        });
        this.view.swatchElement.appendChild(this.swatchC_.view.element);
        this.view.textElement.appendChild(this.textC_.view.element);
        this.popC_ =
            config.pickerLayout === 'popup'
                ? new PopupController(doc, {
                    viewProps: this.viewProps,
                })
                : null;
        const pickerC = new ColorPickerController(doc, {
            colorType: config.colorType,
            supportsAlpha: config.supportsAlpha,
            value: this.value,
            viewProps: this.viewProps,
        });
        pickerC.view.allFocusableElements.forEach((elem) => {
            elem.addEventListener('blur', this.onPopupChildBlur_);
            elem.addEventListener('keydown', this.onPopupChildKeydown_);
        });
        this.pickerC_ = pickerC;
        if (this.popC_) {
            this.view.element.appendChild(this.popC_.view.element);
            this.popC_.view.element.appendChild(pickerC.view.element);
            connectValues({
                primary: this.foldable_.value('expanded'),
                secondary: this.popC_.shows,
                forward: (p) => p,
                backward: (_, s) => s,
            });
        }
        else if (this.view.pickerElement) {
            this.view.pickerElement.appendChild(this.pickerC_.view.element);
            bindFoldable(this.foldable_, this.view.pickerElement);
        }
    }
    get textController() {
        return this.textC_;
    }
    onButtonBlur_(e) {
        if (!this.popC_) {
            return;
        }
        const elem = this.view.element;
        const nextTarget = forceCast(e.relatedTarget);
        if (!nextTarget || !elem.contains(nextTarget)) {
            this.popC_.shows.rawValue = false;
        }
    }
    onButtonClick_() {
        this.foldable_.set('expanded', !this.foldable_.get('expanded'));
        if (this.foldable_.get('expanded')) {
            this.pickerC_.view.allFocusableElements[0].focus();
        }
    }
    onPopupChildBlur_(ev) {
        if (!this.popC_) {
            return;
        }
        const elem = this.popC_.view.element;
        const nextTarget = findNextTarget(ev);
        if (nextTarget && elem.contains(nextTarget)) {
            return;
        }
        if (nextTarget &&
            nextTarget === this.swatchC_.view.buttonElement &&
            !supportsTouch(elem.ownerDocument)) {
            return;
        }
        this.popC_.shows.rawValue = false;
    }
    onPopupChildKeydown_(ev) {
        if (this.popC_) {
            if (ev.key === 'Escape') {
                this.popC_.shows.rawValue = false;
            }
        }
        else if (this.view.pickerElement) {
            if (ev.key === 'Escape') {
                this.swatchC_.view.buttonElement.focus();
            }
        }
    }
}

function colorToRgbNumber(value) {
    return removeAlphaComponent(value.getComponents('rgb')).reduce((result, comp) => {
        return (result << 8) | (Math.floor(comp) & 0xff);
    }, 0);
}
function colorToRgbaNumber(value) {
    return (value.getComponents('rgb').reduce((result, comp, index) => {
        const hex = Math.floor(index === 3 ? comp * 255 : comp) & 0xff;
        return (result << 8) | hex;
    }, 0) >>> 0);
}
function numberToRgbColor(num) {
    return new IntColor([(num >> 16) & 0xff, (num >> 8) & 0xff, num & 0xff], 'rgb');
}
function numberToRgbaColor(num) {
    return new IntColor([
        (num >> 24) & 0xff,
        (num >> 16) & 0xff,
        (num >> 8) & 0xff,
        mapRange(num & 0xff, 0, 255, 0, 1),
    ], 'rgb');
}
function colorFromRgbNumber(value) {
    if (typeof value !== 'number') {
        return IntColor.black();
    }
    return numberToRgbColor(value);
}
function colorFromRgbaNumber(value) {
    if (typeof value !== 'number') {
        return IntColor.black();
    }
    return numberToRgbaColor(value);
}

function isRgbColorComponent(obj, key) {
    if (typeof obj !== 'object' || isEmpty(obj)) {
        return false;
    }
    return key in obj && typeof obj[key] === 'number';
}
function isRgbColorObject(obj) {
    return (isRgbColorComponent(obj, 'r') &&
        isRgbColorComponent(obj, 'g') &&
        isRgbColorComponent(obj, 'b'));
}
function isRgbaColorObject(obj) {
    return isRgbColorObject(obj) && isRgbColorComponent(obj, 'a');
}
function isColorObject(obj) {
    return isRgbColorObject(obj);
}
function equalsColor(v1, v2) {
    if (v1.mode !== v2.mode) {
        return false;
    }
    if (v1.type !== v2.type) {
        return false;
    }
    const comps1 = v1.getComponents();
    const comps2 = v2.getComponents();
    for (let i = 0; i < comps1.length; i++) {
        if (comps1[i] !== comps2[i]) {
            return false;
        }
    }
    return true;
}
function createColorComponentsFromRgbObject(obj) {
    return 'a' in obj ? [obj.r, obj.g, obj.b, obj.a] : [obj.r, obj.g, obj.b];
}

function createColorStringWriter(format) {
    const stringify = findColorStringifier(format);
    return stringify
        ? (target, value) => {
            writePrimitive(target, stringify(value));
        }
        : null;
}
function createColorNumberWriter(supportsAlpha) {
    const colorToNumber = supportsAlpha ? colorToRgbaNumber : colorToRgbNumber;
    return (target, value) => {
        writePrimitive(target, colorToNumber(value));
    };
}
function writeRgbaColorObject(target, value, type) {
    const cc = mapColorType(value, type);
    const obj = cc.toRgbaObject();
    target.writeProperty('r', obj.r);
    target.writeProperty('g', obj.g);
    target.writeProperty('b', obj.b);
    target.writeProperty('a', obj.a);
}
function writeRgbColorObject(target, value, type) {
    const cc = mapColorType(value, type);
    const obj = cc.toRgbaObject();
    target.writeProperty('r', obj.r);
    target.writeProperty('g', obj.g);
    target.writeProperty('b', obj.b);
}
function createColorObjectWriter(supportsAlpha, type) {
    return (target, inValue) => {
        if (supportsAlpha) {
            writeRgbaColorObject(target, inValue, type);
        }
        else {
            writeRgbColorObject(target, inValue, type);
        }
    };
}

function shouldSupportAlpha$1(inputParams) {
    var _a;
    if ((_a = inputParams === null || inputParams === void 0 ? void 0 : inputParams.color) === null || _a === void 0 ? void 0 : _a.alpha) {
        return true;
    }
    return false;
}
function createFormatter$1(supportsAlpha) {
    return supportsAlpha
        ? (v) => colorToHexRgbaString(v, '0x')
        : (v) => colorToHexRgbString(v, '0x');
}
function isForColor(params) {
    if ('color' in params) {
        return true;
    }
    if (params.view === 'color') {
        return true;
    }
    return false;
}
const NumberColorInputPlugin = createPlugin({
    id: 'input-color-number',
    type: 'input',
    accept: (value, params) => {
        if (typeof value !== 'number') {
            return null;
        }
        if (!isForColor(params)) {
            return null;
        }
        const result = parseColorInputParams(params);
        return result
            ? {
                initialValue: value,
                params: Object.assign(Object.assign({}, result), { supportsAlpha: shouldSupportAlpha$1(params) }),
            }
            : null;
    },
    binding: {
        reader: (args) => {
            return args.params.supportsAlpha
                ? colorFromRgbaNumber
                : colorFromRgbNumber;
        },
        equals: equalsColor,
        writer: (args) => {
            return createColorNumberWriter(args.params.supportsAlpha);
        },
    },
    controller: (args) => {
        var _a, _b;
        return new ColorController(args.document, {
            colorType: 'int',
            expanded: (_a = args.params.expanded) !== null && _a !== void 0 ? _a : false,
            formatter: createFormatter$1(args.params.supportsAlpha),
            parser: createColorStringParser('int'),
            pickerLayout: (_b = args.params.picker) !== null && _b !== void 0 ? _b : 'popup',
            supportsAlpha: args.params.supportsAlpha,
            value: args.value,
            viewProps: args.viewProps,
        });
    },
});

function colorFromObject(value, type) {
    if (!isColorObject(value)) {
        return mapColorType(IntColor.black(), type);
    }
    if (type === 'int') {
        const comps = createColorComponentsFromRgbObject(value);
        return new IntColor(comps, 'rgb');
    }
    if (type === 'float') {
        const comps = createColorComponentsFromRgbObject(value);
        return new FloatColor(comps, 'rgb');
    }
    return mapColorType(IntColor.black(), 'int');
}

function shouldSupportAlpha(initialValue) {
    return isRgbaColorObject(initialValue);
}
function createColorObjectBindingReader(type) {
    return (value) => {
        const c = colorFromObject(value, type);
        return mapColorType(c, 'int');
    };
}
function createColorObjectFormatter(supportsAlpha, type) {
    return (value) => {
        if (supportsAlpha) {
            return colorToObjectRgbaString(value, type);
        }
        return colorToObjectRgbString(value, type);
    };
}
const ObjectColorInputPlugin = createPlugin({
    id: 'input-color-object',
    type: 'input',
    accept: (value, params) => {
        var _a;
        if (!isColorObject(value)) {
            return null;
        }
        const result = parseColorInputParams(params);
        return result
            ? {
                initialValue: value,
                params: Object.assign(Object.assign({}, result), { colorType: (_a = extractColorType(params)) !== null && _a !== void 0 ? _a : 'int' }),
            }
            : null;
    },
    binding: {
        reader: (args) => createColorObjectBindingReader(args.params.colorType),
        equals: equalsColor,
        writer: (args) => createColorObjectWriter(shouldSupportAlpha(args.initialValue), args.params.colorType),
    },
    controller: (args) => {
        var _a, _b;
        const supportsAlpha = isRgbaColorObject(args.initialValue);
        return new ColorController(args.document, {
            colorType: args.params.colorType,
            expanded: (_a = args.params.expanded) !== null && _a !== void 0 ? _a : false,
            formatter: createColorObjectFormatter(supportsAlpha, args.params.colorType),
            parser: createColorStringParser('int'),
            pickerLayout: (_b = args.params.picker) !== null && _b !== void 0 ? _b : 'popup',
            supportsAlpha: supportsAlpha,
            value: args.value,
            viewProps: args.viewProps,
        });
    },
});

const StringColorInputPlugin = createPlugin({
    id: 'input-color-string',
    type: 'input',
    accept: (value, params) => {
        if (typeof value !== 'string') {
            return null;
        }
        if (params.view === 'text') {
            return null;
        }
        const format = detectStringColorFormat(value, extractColorType(params));
        if (!format) {
            return null;
        }
        const stringifier = findColorStringifier(format);
        if (!stringifier) {
            return null;
        }
        const result = parseColorInputParams(params);
        return result
            ? {
                initialValue: value,
                params: Object.assign(Object.assign({}, result), { format: format, stringifier: stringifier }),
            }
            : null;
    },
    binding: {
        reader: () => readIntColorString,
        equals: equalsColor,
        writer: (args) => {
            const writer = createColorStringWriter(args.params.format);
            if (!writer) {
                throw TpError.notBindable();
            }
            return writer;
        },
    },
    controller: (args) => {
        var _a, _b;
        return new ColorController(args.document, {
            colorType: args.params.format.type,
            expanded: (_a = args.params.expanded) !== null && _a !== void 0 ? _a : false,
            formatter: args.params.stringifier,
            parser: createColorStringParser('int'),
            pickerLayout: (_b = args.params.picker) !== null && _b !== void 0 ? _b : 'popup',
            supportsAlpha: args.params.format.alpha,
            value: args.value,
            viewProps: args.viewProps,
        });
    },
});

class PointNdConstraint {
    constructor(config) {
        this.components = config.components;
        this.asm_ = config.assembly;
    }
    constrain(value) {
        const comps = this.asm_
            .toComponents(value)
            .map((comp, index) => { var _a, _b; return (_b = (_a = this.components[index]) === null || _a === void 0 ? void 0 : _a.constrain(comp)) !== null && _b !== void 0 ? _b : comp; });
        return this.asm_.fromComponents(comps);
    }
}

const cn$6 = ClassName('pndtxt');
class PointNdTextView {
    constructor(doc, config) {
        this.textViews = config.textViews;
        this.element = doc.createElement('div');
        this.element.classList.add(cn$6());
        this.textViews.forEach((v) => {
            const axisElem = doc.createElement('div');
            axisElem.classList.add(cn$6('a'));
            axisElem.appendChild(v.element);
            this.element.appendChild(axisElem);
        });
    }
}

function createAxisController(doc, config, index) {
    return new NumberTextController(doc, {
        arrayPosition: index === 0 ? 'fst' : index === config.axes.length - 1 ? 'lst' : 'mid',
        parser: config.parser,
        props: config.axes[index].textProps,
        value: createValue(0, {
            constraint: config.axes[index].constraint,
        }),
        viewProps: config.viewProps,
    });
}
class PointNdTextController {
    constructor(doc, config) {
        this.value = config.value;
        this.viewProps = config.viewProps;
        this.acs_ = config.axes.map((_, index) => createAxisController(doc, config, index));
        this.acs_.forEach((c, index) => {
            connectValues({
                primary: this.value,
                secondary: c.value,
                forward: (p) => config.assembly.toComponents(p)[index],
                backward: (p, s) => {
                    const comps = config.assembly.toComponents(p);
                    comps[index] = s;
                    return config.assembly.fromComponents(comps);
                },
            });
        });
        this.view = new PointNdTextView(doc, {
            textViews: this.acs_.map((ac) => ac.view),
        });
    }
    get textControllers() {
        return this.acs_;
    }
}

class SliderInputBindingApi extends BindingApi {
    get max() {
        return this.controller.valueController.sliderController.props.get('max');
    }
    set max(max) {
        this.controller.valueController.sliderController.props.set('max', max);
    }
    get min() {
        return this.controller.valueController.sliderController.props.get('min');
    }
    set min(max) {
        this.controller.valueController.sliderController.props.set('min', max);
    }
}

function createConstraint$4(params, initialValue) {
    const constraints = [];
    const sc = createStepConstraint(params, initialValue);
    if (sc) {
        constraints.push(sc);
    }
    const rc = createRangeConstraint(params);
    if (rc) {
        constraints.push(rc);
    }
    const lc = createListConstraint(params.options);
    if (lc) {
        constraints.push(lc);
    }
    return new CompositeConstraint(constraints);
}
const NumberInputPlugin = createPlugin({
    id: 'input-number',
    type: 'input',
    accept: (value, params) => {
        if (typeof value !== 'number') {
            return null;
        }
        const result = parseRecord(params, (p) => (Object.assign(Object.assign({}, createNumberTextInputParamsParser(p)), { options: p.optional.custom(parseListOptions), readonly: p.optional.constant(false) })));
        return result
            ? {
                initialValue: value,
                params: result,
            }
            : null;
    },
    binding: {
        reader: (_args) => numberFromUnknown,
        constraint: (args) => createConstraint$4(args.params, args.initialValue),
        writer: (_args) => writePrimitive,
    },
    controller: (args) => {
        const value = args.value;
        const c = args.constraint;
        const lc = c && findConstraint(c, ListConstraint);
        if (lc) {
            return new ListController(args.document, {
                props: new ValueMap({
                    options: lc.values.value('options'),
                }),
                value: value,
                viewProps: args.viewProps,
            });
        }
        const textPropsObj = createNumberTextPropsObject(args.params, value.rawValue);
        const drc = c && findConstraint(c, DefiniteRangeConstraint);
        if (drc) {
            return new SliderTextController(args.document, Object.assign(Object.assign({}, createSliderTextProps(Object.assign(Object.assign({}, textPropsObj), { keyScale: createValue(textPropsObj.keyScale), max: drc.values.value('max'), min: drc.values.value('min') }))), { parser: parseNumber, value: value, viewProps: args.viewProps }));
        }
        return new NumberTextController(args.document, {
            parser: parseNumber,
            props: ValueMap.fromObject(textPropsObj),
            value: value,
            viewProps: args.viewProps,
        });
    },
    api(args) {
        if (typeof args.controller.value.rawValue !== 'number') {
            return null;
        }
        if (args.controller.valueController instanceof SliderTextController) {
            return new SliderInputBindingApi(args.controller);
        }
        if (args.controller.valueController instanceof ListController) {
            return new ListInputBindingApi(args.controller);
        }
        return null;
    },
});

class Point2d {
    constructor(x = 0, y = 0) {
        this.x = x;
        this.y = y;
    }
    getComponents() {
        return [this.x, this.y];
    }
    static isObject(obj) {
        if (isEmpty(obj)) {
            return false;
        }
        const x = obj.x;
        const y = obj.y;
        if (typeof x !== 'number' || typeof y !== 'number') {
            return false;
        }
        return true;
    }
    static equals(v1, v2) {
        return v1.x === v2.x && v1.y === v2.y;
    }
    toObject() {
        return {
            x: this.x,
            y: this.y,
        };
    }
}
const Point2dAssembly = {
    toComponents: (p) => p.getComponents(),
    fromComponents: (comps) => new Point2d(...comps),
};

const cn$5 = ClassName('p2d');
class Point2dView {
    constructor(doc, config) {
        this.element = doc.createElement('div');
        this.element.classList.add(cn$5());
        config.viewProps.bindClassModifiers(this.element);
        bindValue(config.expanded, valueToClassName(this.element, cn$5(undefined, 'expanded')));
        const headElem = doc.createElement('div');
        headElem.classList.add(cn$5('h'));
        this.element.appendChild(headElem);
        const buttonElem = doc.createElement('button');
        buttonElem.classList.add(cn$5('b'));
        buttonElem.appendChild(createSvgIconElement(doc, 'p2dpad'));
        config.viewProps.bindDisabled(buttonElem);
        headElem.appendChild(buttonElem);
        this.buttonElement = buttonElem;
        const textElem = doc.createElement('div');
        textElem.classList.add(cn$5('t'));
        headElem.appendChild(textElem);
        this.textElement = textElem;
        if (config.pickerLayout === 'inline') {
            const pickerElem = doc.createElement('div');
            pickerElem.classList.add(cn$5('p'));
            this.element.appendChild(pickerElem);
            this.pickerElement = pickerElem;
        }
        else {
            this.pickerElement = null;
        }
    }
}

const cn$4 = ClassName('p2dp');
class Point2dPickerView {
    constructor(doc, config) {
        this.onFoldableChange_ = this.onFoldableChange_.bind(this);
        this.onPropsChange_ = this.onPropsChange_.bind(this);
        this.onValueChange_ = this.onValueChange_.bind(this);
        this.props_ = config.props;
        this.props_.emitter.on('change', this.onPropsChange_);
        this.element = doc.createElement('div');
        this.element.classList.add(cn$4());
        if (config.layout === 'popup') {
            this.element.classList.add(cn$4(undefined, 'p'));
        }
        config.viewProps.bindClassModifiers(this.element);
        const padElem = doc.createElement('div');
        padElem.classList.add(cn$4('p'));
        config.viewProps.bindTabIndex(padElem);
        this.element.appendChild(padElem);
        this.padElement = padElem;
        const svgElem = doc.createElementNS(SVG_NS, 'svg');
        svgElem.classList.add(cn$4('g'));
        this.padElement.appendChild(svgElem);
        this.svgElem_ = svgElem;
        const xAxisElem = doc.createElementNS(SVG_NS, 'line');
        xAxisElem.classList.add(cn$4('ax'));
        xAxisElem.setAttributeNS(null, 'x1', '0');
        xAxisElem.setAttributeNS(null, 'y1', '50%');
        xAxisElem.setAttributeNS(null, 'x2', '100%');
        xAxisElem.setAttributeNS(null, 'y2', '50%');
        this.svgElem_.appendChild(xAxisElem);
        const yAxisElem = doc.createElementNS(SVG_NS, 'line');
        yAxisElem.classList.add(cn$4('ax'));
        yAxisElem.setAttributeNS(null, 'x1', '50%');
        yAxisElem.setAttributeNS(null, 'y1', '0');
        yAxisElem.setAttributeNS(null, 'x2', '50%');
        yAxisElem.setAttributeNS(null, 'y2', '100%');
        this.svgElem_.appendChild(yAxisElem);
        const lineElem = doc.createElementNS(SVG_NS, 'line');
        lineElem.classList.add(cn$4('l'));
        lineElem.setAttributeNS(null, 'x1', '50%');
        lineElem.setAttributeNS(null, 'y1', '50%');
        this.svgElem_.appendChild(lineElem);
        this.lineElem_ = lineElem;
        const markerElem = doc.createElement('div');
        markerElem.classList.add(cn$4('m'));
        this.padElement.appendChild(markerElem);
        this.markerElem_ = markerElem;
        config.value.emitter.on('change', this.onValueChange_);
        this.value = config.value;
        this.update_();
    }
    get allFocusableElements() {
        return [this.padElement];
    }
    update_() {
        const [x, y] = this.value.rawValue.getComponents();
        const max = this.props_.get('max');
        const px = mapRange(x, -max, +max, 0, 100);
        const py = mapRange(y, -max, +max, 0, 100);
        const ipy = this.props_.get('invertsY') ? 100 - py : py;
        this.lineElem_.setAttributeNS(null, 'x2', `${px}%`);
        this.lineElem_.setAttributeNS(null, 'y2', `${ipy}%`);
        this.markerElem_.style.left = `${px}%`;
        this.markerElem_.style.top = `${ipy}%`;
    }
    onValueChange_() {
        this.update_();
    }
    onPropsChange_() {
        this.update_();
    }
    onFoldableChange_() {
        this.update_();
    }
}

function computeOffset(ev, keyScales, invertsY) {
    return [
        getStepForKey(keyScales[0], getHorizontalStepKeys(ev)),
        getStepForKey(keyScales[1], getVerticalStepKeys(ev)) * (invertsY ? 1 : -1),
    ];
}
class Point2dPickerController {
    constructor(doc, config) {
        this.onPadKeyDown_ = this.onPadKeyDown_.bind(this);
        this.onPadKeyUp_ = this.onPadKeyUp_.bind(this);
        this.onPointerDown_ = this.onPointerDown_.bind(this);
        this.onPointerMove_ = this.onPointerMove_.bind(this);
        this.onPointerUp_ = this.onPointerUp_.bind(this);
        this.props = config.props;
        this.value = config.value;
        this.viewProps = config.viewProps;
        this.view = new Point2dPickerView(doc, {
            layout: config.layout,
            props: this.props,
            value: this.value,
            viewProps: this.viewProps,
        });
        this.ptHandler_ = new PointerHandler(this.view.padElement);
        this.ptHandler_.emitter.on('down', this.onPointerDown_);
        this.ptHandler_.emitter.on('move', this.onPointerMove_);
        this.ptHandler_.emitter.on('up', this.onPointerUp_);
        this.view.padElement.addEventListener('keydown', this.onPadKeyDown_);
        this.view.padElement.addEventListener('keyup', this.onPadKeyUp_);
    }
    handlePointerEvent_(d, opts) {
        if (!d.point) {
            return;
        }
        const max = this.props.get('max');
        const px = mapRange(d.point.x, 0, d.bounds.width, -max, +max);
        const py = mapRange(this.props.get('invertsY') ? d.bounds.height - d.point.y : d.point.y, 0, d.bounds.height, -max, +max);
        this.value.setRawValue(new Point2d(px, py), opts);
    }
    onPointerDown_(ev) {
        this.handlePointerEvent_(ev.data, {
            forceEmit: false,
            last: false,
        });
    }
    onPointerMove_(ev) {
        this.handlePointerEvent_(ev.data, {
            forceEmit: false,
            last: false,
        });
    }
    onPointerUp_(ev) {
        this.handlePointerEvent_(ev.data, {
            forceEmit: true,
            last: true,
        });
    }
    onPadKeyDown_(ev) {
        if (isArrowKey(ev.key)) {
            ev.preventDefault();
        }
        const [dx, dy] = computeOffset(ev, [this.props.get('xKeyScale'), this.props.get('yKeyScale')], this.props.get('invertsY'));
        if (dx === 0 && dy === 0) {
            return;
        }
        this.value.setRawValue(new Point2d(this.value.rawValue.x + dx, this.value.rawValue.y + dy), {
            forceEmit: false,
            last: false,
        });
    }
    onPadKeyUp_(ev) {
        const [dx, dy] = computeOffset(ev, [this.props.get('xKeyScale'), this.props.get('yKeyScale')], this.props.get('invertsY'));
        if (dx === 0 && dy === 0) {
            return;
        }
        this.value.setRawValue(this.value.rawValue, {
            forceEmit: true,
            last: true,
        });
    }
}

class Point2dController {
    constructor(doc, config) {
        var _a, _b;
        this.onPopupChildBlur_ = this.onPopupChildBlur_.bind(this);
        this.onPopupChildKeydown_ = this.onPopupChildKeydown_.bind(this);
        this.onPadButtonBlur_ = this.onPadButtonBlur_.bind(this);
        this.onPadButtonClick_ = this.onPadButtonClick_.bind(this);
        this.value = config.value;
        this.viewProps = config.viewProps;
        this.foldable_ = Foldable.create(config.expanded);
        this.popC_ =
            config.pickerLayout === 'popup'
                ? new PopupController(doc, {
                    viewProps: this.viewProps,
                })
                : null;
        const padC = new Point2dPickerController(doc, {
            layout: config.pickerLayout,
            props: new ValueMap({
                invertsY: createValue(config.invertsY),
                max: createValue(config.max),
                xKeyScale: config.axes[0].textProps.value('keyScale'),
                yKeyScale: config.axes[1].textProps.value('keyScale'),
            }),
            value: this.value,
            viewProps: this.viewProps,
        });
        padC.view.allFocusableElements.forEach((elem) => {
            elem.addEventListener('blur', this.onPopupChildBlur_);
            elem.addEventListener('keydown', this.onPopupChildKeydown_);
        });
        this.pickerC_ = padC;
        this.textC_ = new PointNdTextController(doc, {
            assembly: Point2dAssembly,
            axes: config.axes,
            parser: config.parser,
            value: this.value,
            viewProps: this.viewProps,
        });
        this.view = new Point2dView(doc, {
            expanded: this.foldable_.value('expanded'),
            pickerLayout: config.pickerLayout,
            viewProps: this.viewProps,
        });
        this.view.textElement.appendChild(this.textC_.view.element);
        (_a = this.view.buttonElement) === null || _a === void 0 ? void 0 : _a.addEventListener('blur', this.onPadButtonBlur_);
        (_b = this.view.buttonElement) === null || _b === void 0 ? void 0 : _b.addEventListener('click', this.onPadButtonClick_);
        if (this.popC_) {
            this.view.element.appendChild(this.popC_.view.element);
            this.popC_.view.element.appendChild(this.pickerC_.view.element);
            connectValues({
                primary: this.foldable_.value('expanded'),
                secondary: this.popC_.shows,
                forward: (p) => p,
                backward: (_, s) => s,
            });
        }
        else if (this.view.pickerElement) {
            this.view.pickerElement.appendChild(this.pickerC_.view.element);
            bindFoldable(this.foldable_, this.view.pickerElement);
        }
    }
    get textController() {
        return this.textC_;
    }
    onPadButtonBlur_(e) {
        if (!this.popC_) {
            return;
        }
        const elem = this.view.element;
        const nextTarget = forceCast(e.relatedTarget);
        if (!nextTarget || !elem.contains(nextTarget)) {
            this.popC_.shows.rawValue = false;
        }
    }
    onPadButtonClick_() {
        this.foldable_.set('expanded', !this.foldable_.get('expanded'));
        if (this.foldable_.get('expanded')) {
            this.pickerC_.view.allFocusableElements[0].focus();
        }
    }
    onPopupChildBlur_(ev) {
        if (!this.popC_) {
            return;
        }
        const elem = this.popC_.view.element;
        const nextTarget = findNextTarget(ev);
        if (nextTarget && elem.contains(nextTarget)) {
            return;
        }
        if (nextTarget &&
            nextTarget === this.view.buttonElement &&
            !supportsTouch(elem.ownerDocument)) {
            return;
        }
        this.popC_.shows.rawValue = false;
    }
    onPopupChildKeydown_(ev) {
        if (this.popC_) {
            if (ev.key === 'Escape') {
                this.popC_.shows.rawValue = false;
            }
        }
        else if (this.view.pickerElement) {
            if (ev.key === 'Escape') {
                this.view.buttonElement.focus();
            }
        }
    }
}

function point2dFromUnknown(value) {
    return Point2d.isObject(value)
        ? new Point2d(value.x, value.y)
        : new Point2d();
}
function writePoint2d(target, value) {
    target.writeProperty('x', value.x);
    target.writeProperty('y', value.y);
}

function createConstraint$3(params, initialValue) {
    return new PointNdConstraint({
        assembly: Point2dAssembly,
        components: [
            createDimensionConstraint(Object.assign(Object.assign({}, params), params.x), initialValue.x),
            createDimensionConstraint(Object.assign(Object.assign({}, params), params.y), initialValue.y),
        ],
    });
}
function getSuitableMaxDimensionValue(params, rawValue) {
    var _a, _b;
    if (!isEmpty(params.min) || !isEmpty(params.max)) {
        return Math.max(Math.abs((_a = params.min) !== null && _a !== void 0 ? _a : 0), Math.abs((_b = params.max) !== null && _b !== void 0 ? _b : 0));
    }
    const step = getSuitableKeyScale(params);
    return Math.max(Math.abs(step) * 10, Math.abs(rawValue) * 10);
}
function getSuitableMax(params, initialValue) {
    var _a, _b;
    const xr = getSuitableMaxDimensionValue(deepMerge(params, ((_a = params.x) !== null && _a !== void 0 ? _a : {})), initialValue.x);
    const yr = getSuitableMaxDimensionValue(deepMerge(params, ((_b = params.y) !== null && _b !== void 0 ? _b : {})), initialValue.y);
    return Math.max(xr, yr);
}
function shouldInvertY(params) {
    if (!('y' in params)) {
        return false;
    }
    const yParams = params.y;
    if (!yParams) {
        return false;
    }
    return 'inverted' in yParams ? !!yParams.inverted : false;
}
const Point2dInputPlugin = createPlugin({
    id: 'input-point2d',
    type: 'input',
    accept: (value, params) => {
        if (!Point2d.isObject(value)) {
            return null;
        }
        const result = parseRecord(params, (p) => (Object.assign(Object.assign({}, createPointDimensionParser(p)), { expanded: p.optional.boolean, picker: p.optional.custom(parsePickerLayout), readonly: p.optional.constant(false), x: p.optional.custom(parsePointDimensionParams), y: p.optional.object(Object.assign(Object.assign({}, createPointDimensionParser(p)), { inverted: p.optional.boolean })) })));
        return result
            ? {
                initialValue: value,
                params: result,
            }
            : null;
    },
    binding: {
        reader: () => point2dFromUnknown,
        constraint: (args) => createConstraint$3(args.params, args.initialValue),
        equals: Point2d.equals,
        writer: () => writePoint2d,
    },
    controller: (args) => {
        var _a, _b;
        const doc = args.document;
        const value = args.value;
        const c = args.constraint;
        const dParams = [args.params.x, args.params.y];
        return new Point2dController(doc, {
            axes: value.rawValue.getComponents().map((comp, i) => {
                var _a;
                return createPointAxis({
                    constraint: c.components[i],
                    initialValue: comp,
                    params: deepMerge(args.params, ((_a = dParams[i]) !== null && _a !== void 0 ? _a : {})),
                });
            }),
            expanded: (_a = args.params.expanded) !== null && _a !== void 0 ? _a : false,
            invertsY: shouldInvertY(args.params),
            max: getSuitableMax(args.params, value.rawValue),
            parser: parseNumber,
            pickerLayout: (_b = args.params.picker) !== null && _b !== void 0 ? _b : 'popup',
            value: value,
            viewProps: args.viewProps,
        });
    },
});

class Point3d {
    constructor(x = 0, y = 0, z = 0) {
        this.x = x;
        this.y = y;
        this.z = z;
    }
    getComponents() {
        return [this.x, this.y, this.z];
    }
    static isObject(obj) {
        if (isEmpty(obj)) {
            return false;
        }
        const x = obj.x;
        const y = obj.y;
        const z = obj.z;
        if (typeof x !== 'number' ||
            typeof y !== 'number' ||
            typeof z !== 'number') {
            return false;
        }
        return true;
    }
    static equals(v1, v2) {
        return v1.x === v2.x && v1.y === v2.y && v1.z === v2.z;
    }
    toObject() {
        return {
            x: this.x,
            y: this.y,
            z: this.z,
        };
    }
}
const Point3dAssembly = {
    toComponents: (p) => p.getComponents(),
    fromComponents: (comps) => new Point3d(...comps),
};

function point3dFromUnknown(value) {
    return Point3d.isObject(value)
        ? new Point3d(value.x, value.y, value.z)
        : new Point3d();
}
function writePoint3d(target, value) {
    target.writeProperty('x', value.x);
    target.writeProperty('y', value.y);
    target.writeProperty('z', value.z);
}

function createConstraint$2(params, initialValue) {
    return new PointNdConstraint({
        assembly: Point3dAssembly,
        components: [
            createDimensionConstraint(Object.assign(Object.assign({}, params), params.x), initialValue.x),
            createDimensionConstraint(Object.assign(Object.assign({}, params), params.y), initialValue.y),
            createDimensionConstraint(Object.assign(Object.assign({}, params), params.z), initialValue.z),
        ],
    });
}
const Point3dInputPlugin = createPlugin({
    id: 'input-point3d',
    type: 'input',
    accept: (value, params) => {
        if (!Point3d.isObject(value)) {
            return null;
        }
        const result = parseRecord(params, (p) => (Object.assign(Object.assign({}, createPointDimensionParser(p)), { readonly: p.optional.constant(false), x: p.optional.custom(parsePointDimensionParams), y: p.optional.custom(parsePointDimensionParams), z: p.optional.custom(parsePointDimensionParams) })));
        return result
            ? {
                initialValue: value,
                params: result,
            }
            : null;
    },
    binding: {
        reader: (_args) => point3dFromUnknown,
        constraint: (args) => createConstraint$2(args.params, args.initialValue),
        equals: Point3d.equals,
        writer: (_args) => writePoint3d,
    },
    controller: (args) => {
        const value = args.value;
        const c = args.constraint;
        const dParams = [args.params.x, args.params.y, args.params.z];
        return new PointNdTextController(args.document, {
            assembly: Point3dAssembly,
            axes: value.rawValue.getComponents().map((comp, i) => {
                var _a;
                return createPointAxis({
                    constraint: c.components[i],
                    initialValue: comp,
                    params: deepMerge(args.params, ((_a = dParams[i]) !== null && _a !== void 0 ? _a : {})),
                });
            }),
            parser: parseNumber,
            value: value,
            viewProps: args.viewProps,
        });
    },
});

class Point4d {
    constructor(x = 0, y = 0, z = 0, w = 0) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.w = w;
    }
    getComponents() {
        return [this.x, this.y, this.z, this.w];
    }
    static isObject(obj) {
        if (isEmpty(obj)) {
            return false;
        }
        const x = obj.x;
        const y = obj.y;
        const z = obj.z;
        const w = obj.w;
        if (typeof x !== 'number' ||
            typeof y !== 'number' ||
            typeof z !== 'number' ||
            typeof w !== 'number') {
            return false;
        }
        return true;
    }
    static equals(v1, v2) {
        return v1.x === v2.x && v1.y === v2.y && v1.z === v2.z && v1.w === v2.w;
    }
    toObject() {
        return {
            x: this.x,
            y: this.y,
            z: this.z,
            w: this.w,
        };
    }
}
const Point4dAssembly = {
    toComponents: (p) => p.getComponents(),
    fromComponents: (comps) => new Point4d(...comps),
};

function point4dFromUnknown(value) {
    return Point4d.isObject(value)
        ? new Point4d(value.x, value.y, value.z, value.w)
        : new Point4d();
}
function writePoint4d(target, value) {
    target.writeProperty('x', value.x);
    target.writeProperty('y', value.y);
    target.writeProperty('z', value.z);
    target.writeProperty('w', value.w);
}

function createConstraint$1(params, initialValue) {
    return new PointNdConstraint({
        assembly: Point4dAssembly,
        components: [
            createDimensionConstraint(Object.assign(Object.assign({}, params), params.x), initialValue.x),
            createDimensionConstraint(Object.assign(Object.assign({}, params), params.y), initialValue.y),
            createDimensionConstraint(Object.assign(Object.assign({}, params), params.z), initialValue.z),
            createDimensionConstraint(Object.assign(Object.assign({}, params), params.w), initialValue.w),
        ],
    });
}
const Point4dInputPlugin = createPlugin({
    id: 'input-point4d',
    type: 'input',
    accept: (value, params) => {
        if (!Point4d.isObject(value)) {
            return null;
        }
        const result = parseRecord(params, (p) => (Object.assign(Object.assign({}, createPointDimensionParser(p)), { readonly: p.optional.constant(false), w: p.optional.custom(parsePointDimensionParams), x: p.optional.custom(parsePointDimensionParams), y: p.optional.custom(parsePointDimensionParams), z: p.optional.custom(parsePointDimensionParams) })));
        return result
            ? {
                initialValue: value,
                params: result,
            }
            : null;
    },
    binding: {
        reader: (_args) => point4dFromUnknown,
        constraint: (args) => createConstraint$1(args.params, args.initialValue),
        equals: Point4d.equals,
        writer: (_args) => writePoint4d,
    },
    controller: (args) => {
        const value = args.value;
        const c = args.constraint;
        const dParams = [
            args.params.x,
            args.params.y,
            args.params.z,
            args.params.w,
        ];
        return new PointNdTextController(args.document, {
            assembly: Point4dAssembly,
            axes: value.rawValue.getComponents().map((comp, i) => {
                var _a;
                return createPointAxis({
                    constraint: c.components[i],
                    initialValue: comp,
                    params: deepMerge(args.params, ((_a = dParams[i]) !== null && _a !== void 0 ? _a : {})),
                });
            }),
            parser: parseNumber,
            value: value,
            viewProps: args.viewProps,
        });
    },
});

function createConstraint(params) {
    const constraints = [];
    const lc = createListConstraint(params.options);
    if (lc) {
        constraints.push(lc);
    }
    return new CompositeConstraint(constraints);
}
const StringInputPlugin = createPlugin({
    id: 'input-string',
    type: 'input',
    accept: (value, params) => {
        if (typeof value !== 'string') {
            return null;
        }
        const result = parseRecord(params, (p) => ({
            readonly: p.optional.constant(false),
            options: p.optional.custom(parseListOptions),
        }));
        return result
            ? {
                initialValue: value,
                params: result,
            }
            : null;
    },
    binding: {
        reader: (_args) => stringFromUnknown,
        constraint: (args) => createConstraint(args.params),
        writer: (_args) => writePrimitive,
    },
    controller: (args) => {
        const doc = args.document;
        const value = args.value;
        const c = args.constraint;
        const lc = c && findConstraint(c, ListConstraint);
        if (lc) {
            return new ListController(doc, {
                props: new ValueMap({
                    options: lc.values.value('options'),
                }),
                value: value,
                viewProps: args.viewProps,
            });
        }
        return new TextController(doc, {
            parser: (v) => v,
            props: ValueMap.fromObject({
                formatter: formatString,
            }),
            value: value,
            viewProps: args.viewProps,
        });
    },
    api(args) {
        if (typeof args.controller.value.rawValue !== 'string') {
            return null;
        }
        if (args.controller.valueController instanceof ListController) {
            return new ListInputBindingApi(args.controller);
        }
        return null;
    },
});

const Constants = {
    monitor: {
        defaultInterval: 200,
        defaultRows: 3,
    },
};

const cn$3 = ClassName('mll');
class MultiLogView {
    constructor(doc, config) {
        this.onValueUpdate_ = this.onValueUpdate_.bind(this);
        this.formatter_ = config.formatter;
        this.element = doc.createElement('div');
        this.element.classList.add(cn$3());
        config.viewProps.bindClassModifiers(this.element);
        const textareaElem = doc.createElement('textarea');
        textareaElem.classList.add(cn$3('i'));
        textareaElem.style.height = `calc(var(${getCssVar('containerUnitSize')}) * ${config.rows})`;
        textareaElem.readOnly = true;
        config.viewProps.bindDisabled(textareaElem);
        this.element.appendChild(textareaElem);
        this.textareaElem_ = textareaElem;
        config.value.emitter.on('change', this.onValueUpdate_);
        this.value = config.value;
        this.update_();
    }
    update_() {
        const elem = this.textareaElem_;
        const shouldScroll = elem.scrollTop === elem.scrollHeight - elem.clientHeight;
        const lines = [];
        this.value.rawValue.forEach((value) => {
            if (value !== undefined) {
                lines.push(this.formatter_(value));
            }
        });
        elem.textContent = lines.join('\n');
        if (shouldScroll) {
            elem.scrollTop = elem.scrollHeight;
        }
    }
    onValueUpdate_() {
        this.update_();
    }
}

class MultiLogController {
    constructor(doc, config) {
        this.value = config.value;
        this.viewProps = config.viewProps;
        this.view = new MultiLogView(doc, {
            formatter: config.formatter,
            rows: config.rows,
            value: this.value,
            viewProps: this.viewProps,
        });
    }
}

const cn$2 = ClassName('sgl');
class SingleLogView {
    constructor(doc, config) {
        this.onValueUpdate_ = this.onValueUpdate_.bind(this);
        this.formatter_ = config.formatter;
        this.element = doc.createElement('div');
        this.element.classList.add(cn$2());
        config.viewProps.bindClassModifiers(this.element);
        const inputElem = doc.createElement('input');
        inputElem.classList.add(cn$2('i'));
        inputElem.readOnly = true;
        inputElem.type = 'text';
        config.viewProps.bindDisabled(inputElem);
        this.element.appendChild(inputElem);
        this.inputElement = inputElem;
        config.value.emitter.on('change', this.onValueUpdate_);
        this.value = config.value;
        this.update_();
    }
    update_() {
        const values = this.value.rawValue;
        const lastValue = values[values.length - 1];
        this.inputElement.value =
            lastValue !== undefined ? this.formatter_(lastValue) : '';
    }
    onValueUpdate_() {
        this.update_();
    }
}

class SingleLogController {
    constructor(doc, config) {
        this.value = config.value;
        this.viewProps = config.viewProps;
        this.view = new SingleLogView(doc, {
            formatter: config.formatter,
            value: this.value,
            viewProps: this.viewProps,
        });
    }
}

const BooleanMonitorPlugin = createPlugin({
    id: 'monitor-bool',
    type: 'monitor',
    accept: (value, params) => {
        if (typeof value !== 'boolean') {
            return null;
        }
        const result = parseRecord(params, (p) => ({
            readonly: p.required.constant(true),
            rows: p.optional.number,
        }));
        return result
            ? {
                initialValue: value,
                params: result,
            }
            : null;
    },
    binding: {
        reader: (_args) => boolFromUnknown,
    },
    controller: (args) => {
        var _a;
        if (args.value.rawValue.length === 1) {
            return new SingleLogController(args.document, {
                formatter: BooleanFormatter,
                value: args.value,
                viewProps: args.viewProps,
            });
        }
        return new MultiLogController(args.document, {
            formatter: BooleanFormatter,
            rows: (_a = args.params.rows) !== null && _a !== void 0 ? _a : Constants.monitor.defaultRows,
            value: args.value,
            viewProps: args.viewProps,
        });
    },
});

class GraphLogMonitorBindingApi extends BindingApi {
    get max() {
        return this.controller.valueController.props.get('max');
    }
    set max(max) {
        this.controller.valueController.props.set('max', max);
    }
    get min() {
        return this.controller.valueController.props.get('min');
    }
    set min(min) {
        this.controller.valueController.props.set('min', min);
    }
}

const cn$1 = ClassName('grl');
class GraphLogView {
    constructor(doc, config) {
        this.onCursorChange_ = this.onCursorChange_.bind(this);
        this.onValueUpdate_ = this.onValueUpdate_.bind(this);
        this.element = doc.createElement('div');
        this.element.classList.add(cn$1());
        config.viewProps.bindClassModifiers(this.element);
        this.formatter_ = config.formatter;
        this.props_ = config.props;
        this.cursor_ = config.cursor;
        this.cursor_.emitter.on('change', this.onCursorChange_);
        const svgElem = doc.createElementNS(SVG_NS, 'svg');
        svgElem.classList.add(cn$1('g'));
        svgElem.style.height = `calc(var(${getCssVar('containerUnitSize')}) * ${config.rows})`;
        this.element.appendChild(svgElem);
        this.svgElem_ = svgElem;
        const lineElem = doc.createElementNS(SVG_NS, 'polyline');
        this.svgElem_.appendChild(lineElem);
        this.lineElem_ = lineElem;
        const tooltipElem = doc.createElement('div');
        tooltipElem.classList.add(cn$1('t'), ClassName('tt')());
        this.element.appendChild(tooltipElem);
        this.tooltipElem_ = tooltipElem;
        config.value.emitter.on('change', this.onValueUpdate_);
        this.value = config.value;
        this.update_();
    }
    get graphElement() {
        return this.svgElem_;
    }
    update_() {
        const { clientWidth: w, clientHeight: h } = this.element;
        const maxIndex = this.value.rawValue.length - 1;
        const min = this.props_.get('min');
        const max = this.props_.get('max');
        const points = [];
        this.value.rawValue.forEach((v, index) => {
            if (v === undefined) {
                return;
            }
            const x = mapRange(index, 0, maxIndex, 0, w);
            const y = mapRange(v, min, max, h, 0);
            points.push([x, y].join(','));
        });
        this.lineElem_.setAttributeNS(null, 'points', points.join(' '));
        const tooltipElem = this.tooltipElem_;
        const value = this.value.rawValue[this.cursor_.rawValue];
        if (value === undefined) {
            tooltipElem.classList.remove(cn$1('t', 'a'));
            return;
        }
        const tx = mapRange(this.cursor_.rawValue, 0, maxIndex, 0, w);
        const ty = mapRange(value, min, max, h, 0);
        tooltipElem.style.left = `${tx}px`;
        tooltipElem.style.top = `${ty}px`;
        tooltipElem.textContent = `${this.formatter_(value)}`;
        if (!tooltipElem.classList.contains(cn$1('t', 'a'))) {
            tooltipElem.classList.add(cn$1('t', 'a'), cn$1('t', 'in'));
            forceReflow(tooltipElem);
            tooltipElem.classList.remove(cn$1('t', 'in'));
        }
    }
    onValueUpdate_() {
        this.update_();
    }
    onCursorChange_() {
        this.update_();
    }
}

class GraphLogController {
    constructor(doc, config) {
        this.onGraphMouseMove_ = this.onGraphMouseMove_.bind(this);
        this.onGraphMouseLeave_ = this.onGraphMouseLeave_.bind(this);
        this.onGraphPointerDown_ = this.onGraphPointerDown_.bind(this);
        this.onGraphPointerMove_ = this.onGraphPointerMove_.bind(this);
        this.onGraphPointerUp_ = this.onGraphPointerUp_.bind(this);
        this.props = config.props;
        this.value = config.value;
        this.viewProps = config.viewProps;
        this.cursor_ = createValue(-1);
        this.view = new GraphLogView(doc, {
            cursor: this.cursor_,
            formatter: config.formatter,
            rows: config.rows,
            props: this.props,
            value: this.value,
            viewProps: this.viewProps,
        });
        if (!supportsTouch(doc)) {
            this.view.element.addEventListener('mousemove', this.onGraphMouseMove_);
            this.view.element.addEventListener('mouseleave', this.onGraphMouseLeave_);
        }
        else {
            const ph = new PointerHandler(this.view.element);
            ph.emitter.on('down', this.onGraphPointerDown_);
            ph.emitter.on('move', this.onGraphPointerMove_);
            ph.emitter.on('up', this.onGraphPointerUp_);
        }
    }
    importProps(state) {
        return importBladeState(state, null, (p) => ({
            max: p.required.number,
            min: p.required.number,
        }), (result) => {
            this.props.set('max', result.max);
            this.props.set('min', result.min);
            return true;
        });
    }
    exportProps() {
        return exportBladeState(null, {
            max: this.props.get('max'),
            min: this.props.get('min'),
        });
    }
    onGraphMouseLeave_() {
        this.cursor_.rawValue = -1;
    }
    onGraphMouseMove_(ev) {
        const { clientWidth: w } = this.view.element;
        this.cursor_.rawValue = Math.floor(mapRange(ev.offsetX, 0, w, 0, this.value.rawValue.length));
    }
    onGraphPointerDown_(ev) {
        this.onGraphPointerMove_(ev);
    }
    onGraphPointerMove_(ev) {
        if (!ev.data.point) {
            this.cursor_.rawValue = -1;
            return;
        }
        this.cursor_.rawValue = Math.floor(mapRange(ev.data.point.x, 0, ev.data.bounds.width, 0, this.value.rawValue.length));
    }
    onGraphPointerUp_() {
        this.cursor_.rawValue = -1;
    }
}

function createFormatter(params) {
    return !isEmpty(params.format) ? params.format : createNumberFormatter(2);
}
function createTextMonitor(args) {
    var _a;
    if (args.value.rawValue.length === 1) {
        return new SingleLogController(args.document, {
            formatter: createFormatter(args.params),
            value: args.value,
            viewProps: args.viewProps,
        });
    }
    return new MultiLogController(args.document, {
        formatter: createFormatter(args.params),
        rows: (_a = args.params.rows) !== null && _a !== void 0 ? _a : Constants.monitor.defaultRows,
        value: args.value,
        viewProps: args.viewProps,
    });
}
function createGraphMonitor(args) {
    var _a, _b, _c;
    return new GraphLogController(args.document, {
        formatter: createFormatter(args.params),
        rows: (_a = args.params.rows) !== null && _a !== void 0 ? _a : Constants.monitor.defaultRows,
        props: ValueMap.fromObject({
            max: (_b = args.params.max) !== null && _b !== void 0 ? _b : 100,
            min: (_c = args.params.min) !== null && _c !== void 0 ? _c : 0,
        }),
        value: args.value,
        viewProps: args.viewProps,
    });
}
function shouldShowGraph(params) {
    return params.view === 'graph';
}
const NumberMonitorPlugin = createPlugin({
    id: 'monitor-number',
    type: 'monitor',
    accept: (value, params) => {
        if (typeof value !== 'number') {
            return null;
        }
        const result = parseRecord(params, (p) => ({
            format: p.optional.function,
            max: p.optional.number,
            min: p.optional.number,
            readonly: p.required.constant(true),
            rows: p.optional.number,
            view: p.optional.string,
        }));
        return result
            ? {
                initialValue: value,
                params: result,
            }
            : null;
    },
    binding: {
        defaultBufferSize: (params) => (shouldShowGraph(params) ? 64 : 1),
        reader: (_args) => numberFromUnknown,
    },
    controller: (args) => {
        if (shouldShowGraph(args.params)) {
            return createGraphMonitor(args);
        }
        return createTextMonitor(args);
    },
    api: (args) => {
        if (args.controller.valueController instanceof GraphLogController) {
            return new GraphLogMonitorBindingApi(args.controller);
        }
        return null;
    },
});

const StringMonitorPlugin = createPlugin({
    id: 'monitor-string',
    type: 'monitor',
    accept: (value, params) => {
        if (typeof value !== 'string') {
            return null;
        }
        const result = parseRecord(params, (p) => ({
            multiline: p.optional.boolean,
            readonly: p.required.constant(true),
            rows: p.optional.number,
        }));
        return result
            ? {
                initialValue: value,
                params: result,
            }
            : null;
    },
    binding: {
        reader: (_args) => stringFromUnknown,
    },
    controller: (args) => {
        var _a;
        const value = args.value;
        const multiline = value.rawValue.length > 1 || args.params.multiline;
        if (multiline) {
            return new MultiLogController(args.document, {
                formatter: formatString,
                rows: (_a = args.params.rows) !== null && _a !== void 0 ? _a : Constants.monitor.defaultRows,
                value: value,
                viewProps: args.viewProps,
            });
        }
        return new SingleLogController(args.document, {
            formatter: formatString,
            value: value,
            viewProps: args.viewProps,
        });
    },
});

class BladeApiCache {
    constructor() {
        this.map_ = new Map();
    }
    get(bc) {
        var _a;
        return (_a = this.map_.get(bc)) !== null && _a !== void 0 ? _a : null;
    }
    has(bc) {
        return this.map_.has(bc);
    }
    add(bc, api) {
        this.map_.set(bc, api);
        bc.viewProps.handleDispose(() => {
            this.map_.delete(bc);
        });
        return api;
    }
}

class ReadWriteBinding {
    constructor(config) {
        this.target = config.target;
        this.reader_ = config.reader;
        this.writer_ = config.writer;
    }
    read() {
        return this.reader_(this.target.read());
    }
    write(value) {
        this.writer_(this.target, value);
    }
    inject(value) {
        this.write(this.reader_(value));
    }
}

function createInputBindingController(plugin, args) {
    var _a;
    const result = plugin.accept(args.target.read(), args.params);
    if (isEmpty(result)) {
        return null;
    }
    const valueArgs = {
        target: args.target,
        initialValue: result.initialValue,
        params: result.params,
    };
    const params = parseRecord(args.params, (p) => ({
        disabled: p.optional.boolean,
        hidden: p.optional.boolean,
        label: p.optional.string,
        tag: p.optional.string,
    }));
    const reader = plugin.binding.reader(valueArgs);
    const constraint = plugin.binding.constraint
        ? plugin.binding.constraint(valueArgs)
        : undefined;
    const binding = new ReadWriteBinding({
        reader: reader,
        target: args.target,
        writer: plugin.binding.writer(valueArgs),
    });
    const value = new InputBindingValue(createValue(reader(result.initialValue), {
        constraint: constraint,
        equals: plugin.binding.equals,
    }), binding);
    const controller = plugin.controller({
        constraint: constraint,
        document: args.document,
        initialValue: result.initialValue,
        params: result.params,
        value: value,
        viewProps: ViewProps.create({
            disabled: params === null || params === void 0 ? void 0 : params.disabled,
            hidden: params === null || params === void 0 ? void 0 : params.hidden,
        }),
    });
    return new InputBindingController(args.document, {
        blade: createBlade(),
        props: ValueMap.fromObject({
            label: 'label' in args.params ? (_a = params === null || params === void 0 ? void 0 : params.label) !== null && _a !== void 0 ? _a : null : args.target.key,
        }),
        tag: params === null || params === void 0 ? void 0 : params.tag,
        value: value,
        valueController: controller,
    });
}

class ReadonlyBinding {
    constructor(config) {
        this.target = config.target;
        this.reader_ = config.reader;
    }
    read() {
        return this.reader_(this.target.read());
    }
}

function createTicker(document, interval) {
    return interval === 0
        ? new ManualTicker()
        : new IntervalTicker(document, interval !== null && interval !== void 0 ? interval : Constants.monitor.defaultInterval);
}
function createMonitorBindingController(plugin, args) {
    var _a, _b, _c;
    const result = plugin.accept(args.target.read(), args.params);
    if (isEmpty(result)) {
        return null;
    }
    const bindingArgs = {
        target: args.target,
        initialValue: result.initialValue,
        params: result.params,
    };
    const params = parseRecord(args.params, (p) => ({
        bufferSize: p.optional.number,
        disabled: p.optional.boolean,
        hidden: p.optional.boolean,
        interval: p.optional.number,
        label: p.optional.string,
    }));
    const reader = plugin.binding.reader(bindingArgs);
    const bufferSize = (_b = (_a = params === null || params === void 0 ? void 0 : params.bufferSize) !== null && _a !== void 0 ? _a : (plugin.binding.defaultBufferSize &&
        plugin.binding.defaultBufferSize(result.params))) !== null && _b !== void 0 ? _b : 1;
    const value = new MonitorBindingValue({
        binding: new ReadonlyBinding({
            reader: reader,
            target: args.target,
        }),
        bufferSize: bufferSize,
        ticker: createTicker(args.document, params === null || params === void 0 ? void 0 : params.interval),
    });
    const controller = plugin.controller({
        document: args.document,
        params: result.params,
        value: value,
        viewProps: ViewProps.create({
            disabled: params === null || params === void 0 ? void 0 : params.disabled,
            hidden: params === null || params === void 0 ? void 0 : params.hidden,
        }),
    });
    controller.viewProps.bindDisabled(value.ticker);
    controller.viewProps.handleDispose(() => {
        value.ticker.dispose();
    });
    return new MonitorBindingController(args.document, {
        blade: createBlade(),
        props: ValueMap.fromObject({
            label: 'label' in args.params ? (_c = params === null || params === void 0 ? void 0 : params.label) !== null && _c !== void 0 ? _c : null : args.target.key,
        }),
        value: value,
        valueController: controller,
    });
}

class PluginPool {
    constructor(apiCache) {
        this.pluginsMap_ = {
            blades: [],
            inputs: [],
            monitors: [],
        };
        this.apiCache_ = apiCache;
    }
    getAll() {
        return [
            ...this.pluginsMap_.blades,
            ...this.pluginsMap_.inputs,
            ...this.pluginsMap_.monitors,
        ];
    }
    register(bundleId, r) {
        if (!isCompatible(r.core)) {
            throw TpError.notCompatible(bundleId, r.id);
        }
        if (r.type === 'blade') {
            this.pluginsMap_.blades.unshift(r);
        }
        else if (r.type === 'input') {
            this.pluginsMap_.inputs.unshift(r);
        }
        else if (r.type === 'monitor') {
            this.pluginsMap_.monitors.unshift(r);
        }
    }
    createInput_(document, target, params) {
        return this.pluginsMap_.inputs.reduce((result, plugin) => result !== null && result !== void 0 ? result : createInputBindingController(plugin, {
            document: document,
            target: target,
            params: params,
        }), null);
    }
    createMonitor_(document, target, params) {
        return this.pluginsMap_.monitors.reduce((result, plugin) => result !== null && result !== void 0 ? result : createMonitorBindingController(plugin, {
            document: document,
            params: params,
            target: target,
        }), null);
    }
    createBinding(doc, target, params) {
        const initialValue = target.read();
        if (isEmpty(initialValue)) {
            throw new TpError({
                context: {
                    key: target.key,
                },
                type: 'nomatchingcontroller',
            });
        }
        const ic = this.createInput_(doc, target, params);
        if (ic) {
            return ic;
        }
        const mc = this.createMonitor_(doc, target, params);
        if (mc) {
            return mc;
        }
        throw new TpError({
            context: {
                key: target.key,
            },
            type: 'nomatchingcontroller',
        });
    }
    createBlade(document, params) {
        const bc = this.pluginsMap_.blades.reduce((result, plugin) => result !== null && result !== void 0 ? result : createBladeController(plugin, {
            document: document,
            params: params,
        }), null);
        if (!bc) {
            throw new TpError({
                type: 'nomatchingview',
                context: {
                    params: params,
                },
            });
        }
        return bc;
    }
    createInputBindingApi_(bc) {
        const api = this.pluginsMap_.inputs.reduce((result, plugin) => {
            var _a, _b;
            if (result) {
                return result;
            }
            return ((_b = (_a = plugin.api) === null || _a === void 0 ? void 0 : _a.call(plugin, {
                controller: bc,
            })) !== null && _b !== void 0 ? _b : null);
        }, null);
        return this.apiCache_.add(bc, api !== null && api !== void 0 ? api : new BindingApi(bc));
    }
    createMonitorBindingApi_(bc) {
        const api = this.pluginsMap_.monitors.reduce((result, plugin) => {
            var _a, _b;
            if (result) {
                return result;
            }
            return ((_b = (_a = plugin.api) === null || _a === void 0 ? void 0 : _a.call(plugin, {
                controller: bc,
            })) !== null && _b !== void 0 ? _b : null);
        }, null);
        return this.apiCache_.add(bc, api !== null && api !== void 0 ? api : new BindingApi(bc));
    }
    createBindingApi(bc) {
        if (this.apiCache_.has(bc)) {
            return this.apiCache_.get(bc);
        }
        if (isInputBindingController(bc)) {
            return this.createInputBindingApi_(bc);
        }
        if (isMonitorBindingController(bc)) {
            return this.createMonitorBindingApi_(bc);
        }
        throw TpError.shouldNeverHappen();
    }
    createApi(bc) {
        if (this.apiCache_.has(bc)) {
            return this.apiCache_.get(bc);
        }
        if (isBindingController(bc)) {
            return this.createBindingApi(bc);
        }
        const api = this.pluginsMap_.blades.reduce((result, plugin) => result !== null && result !== void 0 ? result : plugin.api({
            controller: bc,
            pool: this,
        }), null);
        if (!api) {
            throw TpError.shouldNeverHappen();
        }
        return this.apiCache_.add(bc, api);
    }
}

const sharedCache = new BladeApiCache();
function createDefaultPluginPool() {
    const pool = new PluginPool(sharedCache);
    [
        Point2dInputPlugin,
        Point3dInputPlugin,
        Point4dInputPlugin,
        StringInputPlugin,
        NumberInputPlugin,
        StringColorInputPlugin,
        ObjectColorInputPlugin,
        NumberColorInputPlugin,
        BooleanInputPlugin,
        BooleanMonitorPlugin,
        StringMonitorPlugin,
        NumberMonitorPlugin,
        ButtonBladePlugin,
        FolderBladePlugin,
        TabBladePlugin,
    ].forEach((p) => {
        pool.register('core', p);
    });
    return pool;
}

class ListBladeApi extends BladeApi {
    /**
     * @hidden
     */
    constructor(controller) {
        super(controller);
        this.emitter_ = new Emitter();
        this.controller.value.emitter.on('change', (ev) => {
            this.emitter_.emit('change', new TpChangeEvent(this, ev.rawValue));
        });
    }
    get label() {
        return this.controller.labelController.props.get('label');
    }
    set label(label) {
        this.controller.labelController.props.set('label', label);
    }
    get options() {
        return this.controller.valueController.props.get('options');
    }
    set options(options) {
        this.controller.valueController.props.set('options', options);
    }
    get value() {
        return this.controller.value.rawValue;
    }
    set value(value) {
        this.controller.value.rawValue = value;
    }
    on(eventName, handler) {
        const bh = handler.bind(this);
        this.emitter_.on(eventName, (ev) => {
            bh(ev);
        }, {
            key: handler,
        });
        return this;
    }
    off(eventName, handler) {
        this.emitter_.off(eventName, handler);
        return this;
    }
}

class SeparatorBladeApi extends BladeApi {
}

class SliderBladeApi extends BladeApi {
    /**
     * @hidden
     */
    constructor(controller) {
        super(controller);
        this.emitter_ = new Emitter();
        this.controller.value.emitter.on('change', (ev) => {
            this.emitter_.emit('change', new TpChangeEvent(this, ev.rawValue));
        });
    }
    get label() {
        return this.controller.labelController.props.get('label');
    }
    set label(label) {
        this.controller.labelController.props.set('label', label);
    }
    get max() {
        return this.controller.valueController.sliderController.props.get('max');
    }
    set max(max) {
        this.controller.valueController.sliderController.props.set('max', max);
    }
    get min() {
        return this.controller.valueController.sliderController.props.get('min');
    }
    set min(min) {
        this.controller.valueController.sliderController.props.set('min', min);
    }
    get value() {
        return this.controller.value.rawValue;
    }
    set value(value) {
        this.controller.value.rawValue = value;
    }
    on(eventName, handler) {
        const bh = handler.bind(this);
        this.emitter_.on(eventName, (ev) => {
            bh(ev);
        }, {
            key: handler,
        });
        return this;
    }
    off(eventName, handler) {
        this.emitter_.off(eventName, handler);
        return this;
    }
}

class TextBladeApi extends BladeApi {
    /**
     * @hidden
     */
    constructor(controller) {
        super(controller);
        this.emitter_ = new Emitter();
        this.controller.value.emitter.on('change', (ev) => {
            this.emitter_.emit('change', new TpChangeEvent(this, ev.rawValue));
        });
    }
    get label() {
        return this.controller.labelController.props.get('label');
    }
    set label(label) {
        this.controller.labelController.props.set('label', label);
    }
    get formatter() {
        return this.controller.valueController.props.get('formatter');
    }
    set formatter(formatter) {
        this.controller.valueController.props.set('formatter', formatter);
    }
    get value() {
        return this.controller.value.rawValue;
    }
    set value(value) {
        this.controller.value.rawValue = value;
    }
    on(eventName, handler) {
        const bh = handler.bind(this);
        this.emitter_.on(eventName, (ev) => {
            bh(ev);
        }, {
            key: handler,
        });
        return this;
    }
    off(eventName, handler) {
        this.emitter_.off(eventName, handler);
        return this;
    }
}

const ListBladePlugin = (function () {
    return {
        id: 'list',
        type: 'blade',
        core: VERSION$1,
        accept(params) {
            const result = parseRecord(params, (p) => ({
                options: p.required.custom(parseListOptions),
                value: p.required.raw,
                view: p.required.constant('list'),
                label: p.optional.string,
            }));
            return result ? { params: result } : null;
        },
        controller(args) {
            const lc = new ListConstraint(normalizeListOptions(args.params.options));
            const value = createValue(args.params.value, {
                constraint: lc,
            });
            const ic = new ListController(args.document, {
                props: new ValueMap({
                    options: lc.values.value('options'),
                }),
                value: value,
                viewProps: args.viewProps,
            });
            return new LabeledValueBladeController(args.document, {
                blade: args.blade,
                props: ValueMap.fromObject({
                    label: args.params.label,
                }),
                value: value,
                valueController: ic,
            });
        },
        api(args) {
            if (!(args.controller instanceof LabeledValueBladeController)) {
                return null;
            }
            if (!(args.controller.valueController instanceof ListController)) {
                return null;
            }
            return new ListBladeApi(args.controller);
        },
    };
})();

class RootApi extends FolderApi {
    /**
     * @hidden
     */
    constructor(controller, pool) {
        super(controller, pool);
    }
    get element() {
        return this.controller.view.element;
    }
}

/**
 * @hidden
 */
class RootController extends FolderController {
    constructor(doc, config) {
        super(doc, {
            expanded: config.expanded,
            blade: config.blade,
            props: config.props,
            root: true,
            viewProps: config.viewProps,
        });
    }
}

const cn = ClassName('spr');
/**
 * @hidden
 */
class SeparatorView {
    constructor(doc, config) {
        this.element = doc.createElement('div');
        this.element.classList.add(cn());
        config.viewProps.bindClassModifiers(this.element);
        const hrElem = doc.createElement('hr');
        hrElem.classList.add(cn('r'));
        this.element.appendChild(hrElem);
    }
}

/**
 * @hidden
 */
class SeparatorController extends BladeController {
    /**
     * @hidden
     */
    constructor(doc, config) {
        super(Object.assign(Object.assign({}, config), { view: new SeparatorView(doc, {
                viewProps: config.viewProps,
            }) }));
    }
}

const SeparatorBladePlugin = {
    id: 'separator',
    type: 'blade',
    core: VERSION$1,
    accept(params) {
        const result = parseRecord(params, (p) => ({
            view: p.required.constant('separator'),
        }));
        return result ? { params: result } : null;
    },
    controller(args) {
        return new SeparatorController(args.document, {
            blade: args.blade,
            viewProps: args.viewProps,
        });
    },
    api(args) {
        if (!(args.controller instanceof SeparatorController)) {
            return null;
        }
        return new SeparatorBladeApi(args.controller);
    },
};

const SliderBladePlugin = {
    id: 'slider',
    type: 'blade',
    core: VERSION$1,
    accept(params) {
        const result = parseRecord(params, (p) => ({
            max: p.required.number,
            min: p.required.number,
            view: p.required.constant('slider'),
            format: p.optional.function,
            label: p.optional.string,
            value: p.optional.number,
        }));
        return result ? { params: result } : null;
    },
    controller(args) {
        var _a, _b;
        const initialValue = (_a = args.params.value) !== null && _a !== void 0 ? _a : 0;
        const drc = new DefiniteRangeConstraint({
            max: args.params.max,
            min: args.params.min,
        });
        const v = createValue(initialValue, {
            constraint: drc,
        });
        const vc = new SliderTextController(args.document, Object.assign(Object.assign({}, createSliderTextProps({
            formatter: (_b = args.params.format) !== null && _b !== void 0 ? _b : numberToString,
            keyScale: createValue(1),
            max: drc.values.value('max'),
            min: drc.values.value('min'),
            pointerScale: getSuitablePointerScale(args.params, initialValue),
        })), { parser: parseNumber, value: v, viewProps: args.viewProps }));
        return new LabeledValueBladeController(args.document, {
            blade: args.blade,
            props: ValueMap.fromObject({
                label: args.params.label,
            }),
            value: v,
            valueController: vc,
        });
    },
    api(args) {
        if (!(args.controller instanceof LabeledValueBladeController)) {
            return null;
        }
        if (!(args.controller.valueController instanceof SliderTextController)) {
            return null;
        }
        return new SliderBladeApi(args.controller);
    },
};

const TextBladePlugin = (function () {
    return {
        id: 'text',
        type: 'blade',
        core: VERSION$1,
        accept(params) {
            const result = parseRecord(params, (p) => ({
                parse: p.required.function,
                value: p.required.raw,
                view: p.required.constant('text'),
                format: p.optional.function,
                label: p.optional.string,
            }));
            return result ? { params: result } : null;
        },
        controller(args) {
            var _a;
            const v = createValue(args.params.value);
            const ic = new TextController(args.document, {
                parser: args.params.parse,
                props: ValueMap.fromObject({
                    formatter: (_a = args.params.format) !== null && _a !== void 0 ? _a : ((v) => String(v)),
                }),
                value: v,
                viewProps: args.viewProps,
            });
            return new LabeledValueBladeController(args.document, {
                blade: args.blade,
                props: ValueMap.fromObject({
                    label: args.params.label,
                }),
                value: v,
                valueController: ic,
            });
        },
        api(args) {
            if (!(args.controller instanceof LabeledValueBladeController)) {
                return null;
            }
            if (!(args.controller.valueController instanceof TextController)) {
                return null;
            }
            return new TextBladeApi(args.controller);
        },
    };
})();

function createDefaultWrapperElement(doc) {
    const elem = doc.createElement('div');
    elem.classList.add(ClassName('dfw')());
    if (doc.body) {
        doc.body.appendChild(elem);
    }
    return elem;
}
function embedStyle(doc, id, css) {
    if (doc.querySelector(`style[data-tp-style=${id}]`)) {
        return;
    }
    const styleElem = doc.createElement('style');
    styleElem.dataset.tpStyle = id;
    styleElem.textContent = css;
    doc.head.appendChild(styleElem);
}
/**
 * The root pane of Tweakpane.
 */
class Pane extends RootApi {
    constructor(opt_config) {
        var _a, _b;
        const config = opt_config !== null && opt_config !== void 0 ? opt_config : {};
        const doc = (_a = config.document) !== null && _a !== void 0 ? _a : getWindowDocument();
        const pool = createDefaultPluginPool();
        const rootController = new RootController(doc, {
            expanded: config.expanded,
            blade: createBlade(),
            props: ValueMap.fromObject({
                title: config.title,
            }),
            viewProps: ViewProps.create(),
        });
        super(rootController, pool);
        this.pool_ = pool;
        this.containerElem_ = (_b = config.container) !== null && _b !== void 0 ? _b : createDefaultWrapperElement(doc);
        this.containerElem_.appendChild(this.element);
        this.doc_ = doc;
        this.usesDefaultWrapper_ = !config.container;
        this.setUpDefaultPlugins_();
    }
    get document() {
        if (!this.doc_) {
            throw TpError.alreadyDisposed();
        }
        return this.doc_;
    }
    dispose() {
        const containerElem = this.containerElem_;
        if (!containerElem) {
            throw TpError.alreadyDisposed();
        }
        if (this.usesDefaultWrapper_) {
            const parentElem = containerElem.parentElement;
            if (parentElem) {
                parentElem.removeChild(containerElem);
            }
        }
        this.containerElem_ = null;
        this.doc_ = null;
        super.dispose();
    }
    registerPlugin(bundle) {
        if (bundle.css) {
            embedStyle(this.document, `plugin-${bundle.id}`, bundle.css);
        }
        const plugins = 'plugin' in bundle
            ? [bundle.plugin]
            : 'plugins' in bundle
                ? bundle.plugins
                : [];
        plugins.forEach((p) => {
            this.pool_.register(bundle.id, p);
        });
    }
    setUpDefaultPlugins_() {
        this.registerPlugin({
            id: 'default',
            // NOTE: This string literal will be replaced with the default CSS by Rollup at the compilation time
            css: '.tp-tbiv_b,.tp-coltxtv_ms,.tp-colswv_b,.tp-ckbv_i,.tp-sglv_i,.tp-mllv_i,.tp-grlv_g,.tp-txtv_i,.tp-p2dpv_p,.tp-colswv_sw,.tp-rotv_b,.tp-fldv_b,.tp-p2dv_b,.tp-btnv_b,.tp-lstv_s{-webkit-appearance:none;-moz-appearance:none;appearance:none;background-color:rgba(0,0,0,0);border-width:0;font-family:inherit;font-size:inherit;font-weight:inherit;margin:0;outline:none;padding:0}.tp-p2dv_b,.tp-btnv_b,.tp-lstv_s{background-color:var(--btn-bg);border-radius:var(--bld-br);color:var(--btn-fg);cursor:pointer;display:block;font-weight:bold;height:var(--cnt-usz);line-height:var(--cnt-usz);overflow:hidden;text-overflow:ellipsis;white-space:nowrap}.tp-p2dv_b:hover,.tp-btnv_b:hover,.tp-lstv_s:hover{background-color:var(--btn-bg-h)}.tp-p2dv_b:focus,.tp-btnv_b:focus,.tp-lstv_s:focus{background-color:var(--btn-bg-f)}.tp-p2dv_b:active,.tp-btnv_b:active,.tp-lstv_s:active{background-color:var(--btn-bg-a)}.tp-p2dv_b:disabled,.tp-btnv_b:disabled,.tp-lstv_s:disabled{opacity:.5}.tp-rotv_c>.tp-cntv.tp-v-lst,.tp-tbpv_c>.tp-cntv.tp-v-lst,.tp-fldv_c>.tp-cntv.tp-v-lst{margin-bottom:calc(-1*var(--cnt-vp))}.tp-rotv_c>.tp-fldv.tp-v-lst .tp-fldv_c,.tp-tbpv_c>.tp-fldv.tp-v-lst .tp-fldv_c,.tp-fldv_c>.tp-fldv.tp-v-lst .tp-fldv_c{border-bottom-left-radius:0}.tp-rotv_c>.tp-fldv.tp-v-lst .tp-fldv_b,.tp-tbpv_c>.tp-fldv.tp-v-lst .tp-fldv_b,.tp-fldv_c>.tp-fldv.tp-v-lst .tp-fldv_b{border-bottom-left-radius:0}.tp-rotv_c>*:not(.tp-v-fst),.tp-tbpv_c>*:not(.tp-v-fst),.tp-fldv_c>*:not(.tp-v-fst){margin-top:var(--cnt-usp)}.tp-rotv_c>.tp-sprv:not(.tp-v-fst),.tp-tbpv_c>.tp-sprv:not(.tp-v-fst),.tp-fldv_c>.tp-sprv:not(.tp-v-fst),.tp-rotv_c>.tp-cntv:not(.tp-v-fst),.tp-tbpv_c>.tp-cntv:not(.tp-v-fst),.tp-fldv_c>.tp-cntv:not(.tp-v-fst){margin-top:var(--cnt-vp)}.tp-rotv_c>.tp-sprv+*:not(.tp-v-hidden),.tp-tbpv_c>.tp-sprv+*:not(.tp-v-hidden),.tp-fldv_c>.tp-sprv+*:not(.tp-v-hidden),.tp-rotv_c>.tp-cntv+*:not(.tp-v-hidden),.tp-tbpv_c>.tp-cntv+*:not(.tp-v-hidden),.tp-fldv_c>.tp-cntv+*:not(.tp-v-hidden){margin-top:var(--cnt-vp)}.tp-rotv_c>.tp-sprv:not(.tp-v-hidden)+.tp-sprv,.tp-tbpv_c>.tp-sprv:not(.tp-v-hidden)+.tp-sprv,.tp-fldv_c>.tp-sprv:not(.tp-v-hidden)+.tp-sprv,.tp-rotv_c>.tp-cntv:not(.tp-v-hidden)+.tp-cntv,.tp-tbpv_c>.tp-cntv:not(.tp-v-hidden)+.tp-cntv,.tp-fldv_c>.tp-cntv:not(.tp-v-hidden)+.tp-cntv{margin-top:0}.tp-tbpv_c>.tp-cntv,.tp-fldv_c>.tp-cntv{margin-left:4px}.tp-tbpv_c>.tp-fldv>.tp-fldv_b,.tp-fldv_c>.tp-fldv>.tp-fldv_b{border-top-left-radius:var(--bld-br);border-bottom-left-radius:var(--bld-br)}.tp-tbpv_c>.tp-fldv.tp-fldv-expanded>.tp-fldv_b,.tp-fldv_c>.tp-fldv.tp-fldv-expanded>.tp-fldv_b{border-bottom-left-radius:0}.tp-tbpv_c .tp-fldv>.tp-fldv_c,.tp-fldv_c .tp-fldv>.tp-fldv_c{border-bottom-left-radius:var(--bld-br)}.tp-tbpv_c>.tp-cntv+.tp-fldv>.tp-fldv_b,.tp-fldv_c>.tp-cntv+.tp-fldv>.tp-fldv_b{border-top-left-radius:0}.tp-tbpv_c>.tp-cntv+.tp-tabv>.tp-tabv_t,.tp-fldv_c>.tp-cntv+.tp-tabv>.tp-tabv_t{border-top-left-radius:0}.tp-tbpv_c>.tp-tabv>.tp-tabv_t,.tp-fldv_c>.tp-tabv>.tp-tabv_t{border-top-left-radius:var(--bld-br)}.tp-tbpv_c .tp-tabv>.tp-tabv_c,.tp-fldv_c .tp-tabv>.tp-tabv_c{border-bottom-left-radius:var(--bld-br)}.tp-rotv_b,.tp-fldv_b{background-color:var(--cnt-bg);color:var(--cnt-fg);cursor:pointer;display:block;height:calc(var(--cnt-usz) + 4px);line-height:calc(var(--cnt-usz) + 4px);overflow:hidden;padding-left:var(--cnt-hp);padding-right:calc(4px + var(--cnt-usz) + var(--cnt-hp));position:relative;text-align:left;text-overflow:ellipsis;white-space:nowrap;width:100%;transition:border-radius .2s ease-in-out .2s}.tp-rotv_b:hover,.tp-fldv_b:hover{background-color:var(--cnt-bg-h)}.tp-rotv_b:focus,.tp-fldv_b:focus{background-color:var(--cnt-bg-f)}.tp-rotv_b:active,.tp-fldv_b:active{background-color:var(--cnt-bg-a)}.tp-rotv_b:disabled,.tp-fldv_b:disabled{opacity:.5}.tp-rotv_m,.tp-fldv_m{background:linear-gradient(to left, var(--cnt-fg), var(--cnt-fg) 2px, transparent 2px, transparent 4px, var(--cnt-fg) 4px);border-radius:2px;bottom:0;content:"";display:block;height:6px;right:calc(var(--cnt-hp) + (var(--cnt-usz) + 4px - 6px)/2 - 2px);margin:auto;opacity:.5;position:absolute;top:0;transform:rotate(90deg);transition:transform .2s ease-in-out;width:6px}.tp-rotv.tp-rotv-expanded .tp-rotv_m,.tp-fldv.tp-fldv-expanded>.tp-fldv_b>.tp-fldv_m{transform:none}.tp-rotv_c,.tp-fldv_c{box-sizing:border-box;height:0;opacity:0;overflow:hidden;padding-bottom:0;padding-top:0;position:relative;transition:height .2s ease-in-out,opacity .2s linear,padding .2s ease-in-out}.tp-rotv.tp-rotv-cpl:not(.tp-rotv-expanded) .tp-rotv_c,.tp-fldv.tp-fldv-cpl:not(.tp-fldv-expanded)>.tp-fldv_c{display:none}.tp-rotv.tp-rotv-expanded .tp-rotv_c,.tp-fldv.tp-fldv-expanded>.tp-fldv_c{opacity:1;padding-bottom:var(--cnt-vp);padding-top:var(--cnt-vp);transform:none;overflow:visible;transition:height .2s ease-in-out,opacity .2s linear .2s,padding .2s ease-in-out}.tp-txtv_i,.tp-p2dpv_p,.tp-colswv_sw{background-color:var(--in-bg);border-radius:var(--bld-br);box-sizing:border-box;color:var(--in-fg);font-family:inherit;height:var(--cnt-usz);line-height:var(--cnt-usz);min-width:0;width:100%}.tp-txtv_i:hover,.tp-p2dpv_p:hover,.tp-colswv_sw:hover{background-color:var(--in-bg-h)}.tp-txtv_i:focus,.tp-p2dpv_p:focus,.tp-colswv_sw:focus{background-color:var(--in-bg-f)}.tp-txtv_i:active,.tp-p2dpv_p:active,.tp-colswv_sw:active{background-color:var(--in-bg-a)}.tp-txtv_i:disabled,.tp-p2dpv_p:disabled,.tp-colswv_sw:disabled{opacity:.5}.tp-lstv,.tp-coltxtv_m{position:relative}.tp-lstv_s{padding:0 20px 0 4px;width:100%}.tp-lstv_m,.tp-coltxtv_mm{bottom:0;margin:auto;pointer-events:none;position:absolute;right:2px;top:0}.tp-lstv_m svg,.tp-coltxtv_mm svg{bottom:0;height:16px;margin:auto;position:absolute;right:0;top:0;width:16px}.tp-lstv_m svg path,.tp-coltxtv_mm svg path{fill:currentColor}.tp-sglv_i,.tp-mllv_i,.tp-grlv_g{background-color:var(--mo-bg);border-radius:var(--bld-br);box-sizing:border-box;color:var(--mo-fg);height:var(--cnt-usz);scrollbar-color:currentColor rgba(0,0,0,0);scrollbar-width:thin;width:100%}.tp-sglv_i::-webkit-scrollbar,.tp-mllv_i::-webkit-scrollbar,.tp-grlv_g::-webkit-scrollbar{height:8px;width:8px}.tp-sglv_i::-webkit-scrollbar-corner,.tp-mllv_i::-webkit-scrollbar-corner,.tp-grlv_g::-webkit-scrollbar-corner{background-color:rgba(0,0,0,0)}.tp-sglv_i::-webkit-scrollbar-thumb,.tp-mllv_i::-webkit-scrollbar-thumb,.tp-grlv_g::-webkit-scrollbar-thumb{background-clip:padding-box;background-color:currentColor;border:rgba(0,0,0,0) solid 2px;border-radius:4px}.tp-pndtxtv,.tp-coltxtv_w{display:flex}.tp-pndtxtv_a,.tp-coltxtv_c{width:100%}.tp-pndtxtv_a+.tp-pndtxtv_a,.tp-coltxtv_c+.tp-pndtxtv_a,.tp-pndtxtv_a+.tp-coltxtv_c,.tp-coltxtv_c+.tp-coltxtv_c{margin-left:2px}.tp-rotv{--bs-bg: var(--tp-base-background-color, hsl(230, 7%, 17%));--bs-br: var(--tp-base-border-radius, 6px);--bs-ff: var(--tp-base-font-family, Roboto Mono, Source Code Pro, Menlo, Courier, monospace);--bs-sh: var(--tp-base-shadow-color, rgba(0, 0, 0, 0.2));--bld-br: var(--tp-blade-border-radius, 2px);--bld-hp: var(--tp-blade-horizontal-padding, 4px);--bld-vw: var(--tp-blade-value-width, 160px);--btn-bg: var(--tp-button-background-color, hsl(230, 7%, 70%));--btn-bg-a: var(--tp-button-background-color-active, #d6d7db);--btn-bg-f: var(--tp-button-background-color-focus, #c8cad0);--btn-bg-h: var(--tp-button-background-color-hover, #bbbcc4);--btn-fg: var(--tp-button-foreground-color, hsl(230, 7%, 17%));--cnt-bg: var(--tp-container-background-color, rgba(187, 188, 196, 0.1));--cnt-bg-a: var(--tp-container-background-color-active, rgba(187, 188, 196, 0.25));--cnt-bg-f: var(--tp-container-background-color-focus, rgba(187, 188, 196, 0.2));--cnt-bg-h: var(--tp-container-background-color-hover, rgba(187, 188, 196, 0.15));--cnt-fg: var(--tp-container-foreground-color, hsl(230, 7%, 75%));--cnt-hp: var(--tp-container-horizontal-padding, 4px);--cnt-vp: var(--tp-container-vertical-padding, 4px);--cnt-usp: var(--tp-container-unit-spacing, 4px);--cnt-usz: var(--tp-container-unit-size, 20px);--in-bg: var(--tp-input-background-color, rgba(187, 188, 196, 0.1));--in-bg-a: var(--tp-input-background-color-active, rgba(187, 188, 196, 0.25));--in-bg-f: var(--tp-input-background-color-focus, rgba(187, 188, 196, 0.2));--in-bg-h: var(--tp-input-background-color-hover, rgba(187, 188, 196, 0.15));--in-fg: var(--tp-input-foreground-color, hsl(230, 7%, 75%));--lbl-fg: var(--tp-label-foreground-color, rgba(187, 188, 196, 0.7));--mo-bg: var(--tp-monitor-background-color, rgba(0, 0, 0, 0.2));--mo-fg: var(--tp-monitor-foreground-color, rgba(187, 188, 196, 0.7));--grv-fg: var(--tp-groove-foreground-color, rgba(187, 188, 196, 0.1))}.tp-btnv_b{width:100%}.tp-btnv_t{text-align:center}.tp-ckbv_l{display:block;position:relative}.tp-ckbv_i{left:0;opacity:0;position:absolute;top:0}.tp-ckbv_w{background-color:var(--in-bg);border-radius:var(--bld-br);cursor:pointer;display:block;height:var(--cnt-usz);position:relative;width:var(--cnt-usz)}.tp-ckbv_w svg{display:block;height:16px;inset:0;margin:auto;opacity:0;position:absolute;width:16px}.tp-ckbv_w svg path{fill:none;stroke:var(--in-fg);stroke-width:2}.tp-ckbv_i:hover+.tp-ckbv_w{background-color:var(--in-bg-h)}.tp-ckbv_i:focus+.tp-ckbv_w{background-color:var(--in-bg-f)}.tp-ckbv_i:active+.tp-ckbv_w{background-color:var(--in-bg-a)}.tp-ckbv_i:checked+.tp-ckbv_w svg{opacity:1}.tp-ckbv.tp-v-disabled .tp-ckbv_w{opacity:.5}.tp-colv{position:relative}.tp-colv_h{display:flex}.tp-colv_s{flex-grow:0;flex-shrink:0;width:var(--cnt-usz)}.tp-colv_t{flex:1;margin-left:4px}.tp-colv_p{height:0;margin-top:0;opacity:0;overflow:hidden;transition:height .2s ease-in-out,opacity .2s linear,margin .2s ease-in-out}.tp-colv.tp-colv-expanded.tp-colv-cpl .tp-colv_p{overflow:visible}.tp-colv.tp-colv-expanded .tp-colv_p{margin-top:var(--cnt-usp);opacity:1}.tp-colv .tp-popv{left:calc(-1*var(--cnt-hp));right:calc(-1*var(--cnt-hp));top:var(--cnt-usz)}.tp-colpv_h,.tp-colpv_ap{margin-left:6px;margin-right:6px}.tp-colpv_h{margin-top:var(--cnt-usp)}.tp-colpv_rgb{display:flex;margin-top:var(--cnt-usp);width:100%}.tp-colpv_a{display:flex;margin-top:var(--cnt-vp);padding-top:calc(var(--cnt-vp) + 2px);position:relative}.tp-colpv_a::before{background-color:var(--grv-fg);content:"";height:2px;left:calc(-1*var(--cnt-hp));position:absolute;right:calc(-1*var(--cnt-hp));top:0}.tp-colpv.tp-v-disabled .tp-colpv_a::before{opacity:.5}.tp-colpv_ap{align-items:center;display:flex;flex:3}.tp-colpv_at{flex:1;margin-left:4px}.tp-svpv{border-radius:var(--bld-br);outline:none;overflow:hidden;position:relative}.tp-svpv.tp-v-disabled{opacity:.5}.tp-svpv_c{cursor:crosshair;display:block;height:calc(var(--cnt-usz)*4);width:100%}.tp-svpv_m{border-radius:100%;border:rgba(255,255,255,.75) solid 2px;box-sizing:border-box;filter:drop-shadow(0 0 1px rgba(0, 0, 0, 0.3));height:12px;margin-left:-6px;margin-top:-6px;pointer-events:none;position:absolute;width:12px}.tp-svpv:focus .tp-svpv_m{border-color:#fff}.tp-hplv{cursor:pointer;height:var(--cnt-usz);outline:none;position:relative}.tp-hplv.tp-v-disabled{opacity:.5}.tp-hplv_c{background-image:url(data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAEAAAAABCAYAAABubagXAAAAQ0lEQVQoU2P8z8Dwn0GCgQEDi2OK/RBgYHjBgIpfovFh8j8YBIgzFGQxuqEgPhaDOT5gOhPkdCxOZeBg+IDFZZiGAgCaSSMYtcRHLgAAAABJRU5ErkJggg==);background-position:left top;background-repeat:no-repeat;background-size:100% 100%;border-radius:2px;display:block;height:4px;left:0;margin-top:-2px;position:absolute;top:50%;width:100%}.tp-hplv_m{border-radius:var(--bld-br);border:rgba(255,255,255,.75) solid 2px;box-shadow:0 0 2px rgba(0,0,0,.1);box-sizing:border-box;height:12px;left:50%;margin-left:-6px;margin-top:-6px;position:absolute;top:50%;width:12px}.tp-hplv:focus .tp-hplv_m{border-color:#fff}.tp-aplv{cursor:pointer;height:var(--cnt-usz);outline:none;position:relative;width:100%}.tp-aplv.tp-v-disabled{opacity:.5}.tp-aplv_b{background-color:#fff;background-image:linear-gradient(to top right, #ddd 25%, transparent 25%, transparent 75%, #ddd 75%),linear-gradient(to top right, #ddd 25%, transparent 25%, transparent 75%, #ddd 75%);background-size:4px 4px;background-position:0 0,2px 2px;border-radius:2px;display:block;height:4px;left:0;margin-top:-2px;overflow:hidden;position:absolute;top:50%;width:100%}.tp-aplv_c{inset:0;position:absolute}.tp-aplv_m{background-color:#fff;background-image:linear-gradient(to top right, #ddd 25%, transparent 25%, transparent 75%, #ddd 75%),linear-gradient(to top right, #ddd 25%, transparent 25%, transparent 75%, #ddd 75%);background-size:12px 12px;background-position:0 0,6px 6px;border-radius:var(--bld-br);box-shadow:0 0 2px rgba(0,0,0,.1);height:12px;left:50%;margin-left:-6px;margin-top:-6px;overflow:hidden;position:absolute;top:50%;width:12px}.tp-aplv_p{border-radius:var(--bld-br);border:rgba(255,255,255,.75) solid 2px;box-sizing:border-box;inset:0;position:absolute}.tp-aplv:focus .tp-aplv_p{border-color:#fff}.tp-colswv{background-color:#fff;background-image:linear-gradient(to top right, #ddd 25%, transparent 25%, transparent 75%, #ddd 75%),linear-gradient(to top right, #ddd 25%, transparent 25%, transparent 75%, #ddd 75%);background-size:10px 10px;background-position:0 0,5px 5px;border-radius:var(--bld-br);overflow:hidden}.tp-colswv.tp-v-disabled{opacity:.5}.tp-colswv_sw{border-radius:0}.tp-colswv_b{cursor:pointer;display:block;height:var(--cnt-usz);left:0;position:absolute;top:0;width:var(--cnt-usz)}.tp-colswv_b:focus::after{border:rgba(255,255,255,.75) solid 2px;border-radius:var(--bld-br);content:"";display:block;inset:0;position:absolute}.tp-coltxtv{display:flex;width:100%}.tp-coltxtv_m{margin-right:4px}.tp-coltxtv_ms{border-radius:var(--bld-br);color:var(--lbl-fg);cursor:pointer;height:var(--cnt-usz);line-height:var(--cnt-usz);padding:0 18px 0 4px}.tp-coltxtv_ms:hover{background-color:var(--in-bg-h)}.tp-coltxtv_ms:focus{background-color:var(--in-bg-f)}.tp-coltxtv_ms:active{background-color:var(--in-bg-a)}.tp-coltxtv_mm{color:var(--lbl-fg)}.tp-coltxtv.tp-v-disabled .tp-coltxtv_mm{opacity:.5}.tp-coltxtv_w{flex:1}.tp-dfwv{position:absolute;top:8px;right:8px;width:256px}.tp-fldv{position:relative}.tp-fldv_t{padding-left:4px}.tp-fldv_b:disabled .tp-fldv_m{display:none}.tp-fldv_c{padding-left:4px}.tp-fldv_i{bottom:0;color:var(--cnt-bg);left:0;overflow:hidden;position:absolute;top:calc(var(--cnt-usz) + 4px);width:max(var(--bs-br),4px)}.tp-fldv_i::before{background-color:currentColor;bottom:0;content:"";left:0;position:absolute;top:0;width:4px}.tp-fldv_b:hover+.tp-fldv_i{color:var(--cnt-bg-h)}.tp-fldv_b:focus+.tp-fldv_i{color:var(--cnt-bg-f)}.tp-fldv_b:active+.tp-fldv_i{color:var(--cnt-bg-a)}.tp-fldv.tp-v-disabled>.tp-fldv_i{opacity:.5}.tp-grlv{position:relative}.tp-grlv_g{display:block;height:calc(var(--cnt-usz)*3)}.tp-grlv_g polyline{fill:none;stroke:var(--mo-fg);stroke-linejoin:round}.tp-grlv_t{margin-top:-4px;transition:left .05s,top .05s;visibility:hidden}.tp-grlv_t.tp-grlv_t-a{visibility:visible}.tp-grlv_t.tp-grlv_t-in{transition:none}.tp-grlv.tp-v-disabled .tp-grlv_g{opacity:.5}.tp-grlv .tp-ttv{background-color:var(--mo-fg)}.tp-grlv .tp-ttv::before{border-top-color:var(--mo-fg)}.tp-lblv{align-items:center;display:flex;line-height:1.3;padding-left:var(--cnt-hp);padding-right:var(--cnt-hp)}.tp-lblv.tp-lblv-nol{display:block}.tp-lblv_l{color:var(--lbl-fg);flex:1;-webkit-hyphens:auto;hyphens:auto;overflow:hidden;padding-left:4px;padding-right:16px}.tp-lblv.tp-v-disabled .tp-lblv_l{opacity:.5}.tp-lblv.tp-lblv-nol .tp-lblv_l{display:none}.tp-lblv_v{align-self:flex-start;flex-grow:0;flex-shrink:0;width:var(--bld-vw)}.tp-lblv.tp-lblv-nol .tp-lblv_v{width:100%}.tp-lstv_s{padding:0 20px 0 var(--bld-hp);width:100%}.tp-lstv_m{color:var(--btn-fg)}.tp-sglv_i{padding-left:var(--bld-hp);padding-right:var(--bld-hp)}.tp-sglv.tp-v-disabled .tp-sglv_i{opacity:.5}.tp-mllv_i{display:block;height:calc(var(--cnt-usz)*3);line-height:var(--cnt-usz);padding-left:var(--bld-hp);padding-right:var(--bld-hp);resize:none;white-space:pre}.tp-mllv.tp-v-disabled .tp-mllv_i{opacity:.5}.tp-p2dv{position:relative}.tp-p2dv_h{display:flex}.tp-p2dv_b{height:var(--cnt-usz);margin-right:4px;position:relative;width:var(--cnt-usz)}.tp-p2dv_b svg{display:block;height:16px;left:50%;margin-left:-8px;margin-top:-8px;position:absolute;top:50%;width:16px}.tp-p2dv_b svg path{stroke:currentColor;stroke-width:2}.tp-p2dv_b svg circle{fill:currentColor}.tp-p2dv_t{flex:1}.tp-p2dv_p{height:0;margin-top:0;opacity:0;overflow:hidden;transition:height .2s ease-in-out,opacity .2s linear,margin .2s ease-in-out}.tp-p2dv.tp-p2dv-expanded .tp-p2dv_p{margin-top:var(--cnt-usp);opacity:1}.tp-p2dv .tp-popv{left:calc(-1*var(--cnt-hp));right:calc(-1*var(--cnt-hp));top:var(--cnt-usz)}.tp-p2dpv{padding-left:calc(var(--cnt-usz) + 4px)}.tp-p2dpv_p{cursor:crosshair;height:0;overflow:hidden;padding-bottom:100%;position:relative}.tp-p2dpv.tp-v-disabled .tp-p2dpv_p{opacity:.5}.tp-p2dpv_g{display:block;height:100%;left:0;pointer-events:none;position:absolute;top:0;width:100%}.tp-p2dpv_ax{opacity:.1;stroke:var(--in-fg);stroke-dasharray:1}.tp-p2dpv_l{opacity:.5;stroke:var(--in-fg);stroke-dasharray:1}.tp-p2dpv_m{border:var(--in-fg) solid 1px;border-radius:50%;box-sizing:border-box;height:4px;margin-left:-2px;margin-top:-2px;position:absolute;width:4px}.tp-p2dpv_p:focus .tp-p2dpv_m{background-color:var(--in-fg);border-width:0}.tp-popv{background-color:var(--bs-bg);border-radius:var(--bs-br);box-shadow:0 2px 4px var(--bs-sh);display:none;max-width:var(--bld-vw);padding:var(--cnt-vp) var(--cnt-hp);position:absolute;visibility:hidden;z-index:1000}.tp-popv.tp-popv-v{display:block;visibility:visible}.tp-sldv.tp-v-disabled{opacity:.5}.tp-sldv_t{box-sizing:border-box;cursor:pointer;height:var(--cnt-usz);margin:0 6px;outline:none;position:relative}.tp-sldv_t::before{background-color:var(--in-bg);border-radius:1px;content:"";display:block;height:2px;inset:0;margin:auto;position:absolute}.tp-sldv_k{height:100%;left:0;position:absolute;top:0}.tp-sldv_k::before{background-color:var(--in-fg);border-radius:1px;content:"";display:block;height:2px;inset:0;margin-bottom:auto;margin-top:auto;position:absolute}.tp-sldv_k::after{background-color:var(--btn-bg);border-radius:var(--bld-br);bottom:0;content:"";display:block;height:12px;margin-bottom:auto;margin-top:auto;position:absolute;right:-6px;top:0;width:12px}.tp-sldv_t:hover .tp-sldv_k::after{background-color:var(--btn-bg-h)}.tp-sldv_t:focus .tp-sldv_k::after{background-color:var(--btn-bg-f)}.tp-sldv_t:active .tp-sldv_k::after{background-color:var(--btn-bg-a)}.tp-sldtxtv{display:flex}.tp-sldtxtv_s{flex:2}.tp-sldtxtv_t{flex:1;margin-left:4px}.tp-tabv{position:relative}.tp-tabv_t{align-items:flex-end;color:var(--cnt-bg);display:flex;overflow:hidden;position:relative}.tp-tabv_t:hover{color:var(--cnt-bg-h)}.tp-tabv_t:has(*:focus){color:var(--cnt-bg-f)}.tp-tabv_t:has(*:active){color:var(--cnt-bg-a)}.tp-tabv_t::before{background-color:currentColor;bottom:0;content:"";height:2px;left:0;pointer-events:none;position:absolute;right:0}.tp-tabv.tp-v-disabled .tp-tabv_t::before{opacity:.5}.tp-tabv.tp-tabv-nop .tp-tabv_t{height:calc(var(--cnt-usz) + 4px);position:relative}.tp-tabv.tp-tabv-nop .tp-tabv_t::before{background-color:var(--cnt-bg);bottom:0;content:"";height:2px;left:0;position:absolute;right:0}.tp-tabv_i{bottom:0;color:var(--cnt-bg);left:0;overflow:hidden;position:absolute;top:calc(var(--cnt-usz) + 4px);width:max(var(--bs-br),4px)}.tp-tabv_i::before{background-color:currentColor;bottom:0;content:"";left:0;position:absolute;top:0;width:4px}.tp-tabv_t:hover+.tp-tabv_i{color:var(--cnt-bg-h)}.tp-tabv_t:has(*:focus)+.tp-tabv_i{color:var(--cnt-bg-f)}.tp-tabv_t:has(*:active)+.tp-tabv_i{color:var(--cnt-bg-a)}.tp-tabv.tp-v-disabled>.tp-tabv_i{opacity:.5}.tp-tbiv{flex:1;min-width:0;position:relative}.tp-tbiv+.tp-tbiv{margin-left:2px}.tp-tbiv+.tp-tbiv.tp-v-disabled::before{opacity:.5}.tp-tbiv_b{display:block;padding-left:calc(var(--cnt-hp) + 4px);padding-right:calc(var(--cnt-hp) + 4px);position:relative;width:100%}.tp-tbiv_b:disabled{opacity:.5}.tp-tbiv_b::before{background-color:var(--cnt-bg);content:"";inset:0 0 2px;pointer-events:none;position:absolute}.tp-tbiv_b:hover::before{background-color:var(--cnt-bg-h)}.tp-tbiv_b:focus::before{background-color:var(--cnt-bg-f)}.tp-tbiv_b:active::before{background-color:var(--cnt-bg-a)}.tp-tbiv_t{color:var(--cnt-fg);height:calc(var(--cnt-usz) + 4px);line-height:calc(var(--cnt-usz) + 4px);opacity:.5;overflow:hidden;position:relative;text-overflow:ellipsis}.tp-tbiv.tp-tbiv-sel .tp-tbiv_t{opacity:1}.tp-tbpv_c{padding-bottom:var(--cnt-vp);padding-left:4px;padding-top:var(--cnt-vp)}.tp-txtv{position:relative}.tp-txtv_i{padding-left:var(--bld-hp);padding-right:var(--bld-hp)}.tp-txtv.tp-txtv-fst .tp-txtv_i{border-bottom-right-radius:0;border-top-right-radius:0}.tp-txtv.tp-txtv-mid .tp-txtv_i{border-radius:0}.tp-txtv.tp-txtv-lst .tp-txtv_i{border-bottom-left-radius:0;border-top-left-radius:0}.tp-txtv.tp-txtv-num .tp-txtv_i{text-align:right}.tp-txtv.tp-txtv-drg .tp-txtv_i{opacity:.3}.tp-txtv_k{cursor:pointer;height:100%;left:calc(var(--bld-hp) - 5px);position:absolute;top:0;width:12px}.tp-txtv_k::before{background-color:var(--in-fg);border-radius:1px;bottom:0;content:"";height:calc(var(--cnt-usz) - 4px);left:50%;margin-bottom:auto;margin-left:-1px;margin-top:auto;opacity:.1;position:absolute;top:0;transition:border-radius .1s,height .1s,transform .1s,width .1s;width:2px}.tp-txtv_k:hover::before,.tp-txtv.tp-txtv-drg .tp-txtv_k::before{opacity:1}.tp-txtv.tp-txtv-drg .tp-txtv_k::before{border-radius:50%;height:4px;transform:translateX(-1px);width:4px}.tp-txtv_g{bottom:0;display:block;height:8px;left:50%;margin:auto;overflow:visible;pointer-events:none;position:absolute;top:0;visibility:hidden;width:100%}.tp-txtv.tp-txtv-drg .tp-txtv_g{visibility:visible}.tp-txtv_gb{fill:none;stroke:var(--in-fg);stroke-dasharray:1}.tp-txtv_gh{fill:none;stroke:var(--in-fg)}.tp-txtv .tp-ttv{margin-left:6px;visibility:hidden}.tp-txtv.tp-txtv-drg .tp-ttv{visibility:visible}.tp-ttv{background-color:var(--in-fg);border-radius:var(--bld-br);color:var(--bs-bg);padding:2px 4px;pointer-events:none;position:absolute;transform:translate(-50%, -100%)}.tp-ttv::before{border-color:var(--in-fg) rgba(0,0,0,0) rgba(0,0,0,0) rgba(0,0,0,0);border-style:solid;border-width:2px;box-sizing:border-box;content:"";font-size:.9em;height:4px;left:50%;margin-left:-2px;position:absolute;top:100%;width:4px}.tp-rotv{background-color:var(--bs-bg);border-radius:var(--bs-br);box-shadow:0 2px 4px var(--bs-sh);font-family:var(--bs-ff);font-size:11px;font-weight:500;line-height:1;text-align:left}.tp-rotv_b{border-bottom-left-radius:var(--bs-br);border-bottom-right-radius:var(--bs-br);border-top-left-radius:var(--bs-br);border-top-right-radius:var(--bs-br);padding-left:calc(4px + var(--cnt-usz) + var(--cnt-hp));text-align:center}.tp-rotv.tp-rotv-expanded .tp-rotv_b{border-bottom-left-radius:0;border-bottom-right-radius:0;transition-delay:0s;transition-duration:0s}.tp-rotv.tp-rotv-not>.tp-rotv_b{display:none}.tp-rotv_b:disabled .tp-rotv_m{display:none}.tp-rotv_c>.tp-fldv.tp-v-lst>.tp-fldv_c{border-bottom-left-radius:var(--bs-br);border-bottom-right-radius:var(--bs-br)}.tp-rotv_c>.tp-fldv.tp-v-lst>.tp-fldv_i{border-bottom-left-radius:var(--bs-br)}.tp-rotv_c>.tp-fldv.tp-v-lst:not(.tp-fldv-expanded)>.tp-fldv_b{border-bottom-left-radius:var(--bs-br);border-bottom-right-radius:var(--bs-br)}.tp-rotv_c>.tp-fldv.tp-v-lst.tp-fldv-expanded>.tp-fldv_b{transition-delay:0s;transition-duration:0s}.tp-rotv_c .tp-fldv.tp-v-vlst:not(.tp-fldv-expanded)>.tp-fldv_b{border-bottom-right-radius:var(--bs-br)}.tp-rotv.tp-rotv-not .tp-rotv_c>.tp-fldv.tp-v-fst{margin-top:calc(-1*var(--cnt-vp))}.tp-rotv.tp-rotv-not .tp-rotv_c>.tp-fldv.tp-v-fst>.tp-fldv_b{border-top-left-radius:var(--bs-br);border-top-right-radius:var(--bs-br)}.tp-rotv_c>.tp-tabv.tp-v-lst>.tp-tabv_c{border-bottom-left-radius:var(--bs-br);border-bottom-right-radius:var(--bs-br)}.tp-rotv_c>.tp-tabv.tp-v-lst>.tp-tabv_i{border-bottom-left-radius:var(--bs-br)}.tp-rotv.tp-rotv-not .tp-rotv_c>.tp-tabv.tp-v-fst{margin-top:calc(-1*var(--cnt-vp))}.tp-rotv.tp-rotv-not .tp-rotv_c>.tp-tabv.tp-v-fst>.tp-tabv_t{border-top-left-radius:var(--bs-br);border-top-right-radius:var(--bs-br)}.tp-rotv.tp-v-disabled,.tp-rotv .tp-v-disabled{pointer-events:none}.tp-rotv.tp-v-hidden,.tp-rotv .tp-v-hidden{display:none}.tp-sprv_r{background-color:var(--grv-fg);border-width:0;display:block;height:2px;margin:0;width:100%}.tp-sprv.tp-v-disabled .tp-sprv_r{opacity:.5}',
            plugins: [
                ListBladePlugin,
                SeparatorBladePlugin,
                SliderBladePlugin,
                TabBladePlugin,
                TextBladePlugin,
            ],
        });
    }
}

const VERSION = new Semver('4.0.5');




/***/ }),

/***/ "./src/framework/platform/web/status.ts":
/*!**********************************************!*\
  !*** ./src/framework/platform/web/status.ts ***!
  \**********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   StatusPanel: () => (/* binding */ StatusPanel)
/* harmony export */ });
/* harmony import */ var framework_tiny_math_Vector2__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! framework/tiny/math/Vector2 */ "./src/framework/tiny/math/Vector2.ts");
/* harmony import */ var framework_tiny_utils_Frequency__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! framework/tiny/utils/Frequency */ "./src/framework/tiny/utils/Frequency.ts");
/* harmony import */ var tweakpane__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! tweakpane */ "./node_modules/tweakpane/dist/tweakpane.js");



class StatusPanel {
  constructor() {
    this.params = {};
    this.frequency = new framework_tiny_utils_Frequency__WEBPACK_IMPORTED_MODULE_1__.Frequency(2);
    this.folders = {};
    this.numberMonitors = {};
    this.bgColorStyle = {
      hidden: "rgb(40 41 46 / 0%)",
      expanded: "hsl(230deg 19.28% 11.35%)"
    };
    this.pane = new tweakpane__WEBPACK_IMPORTED_MODULE_2__.Pane({ expanded: false, title: "Status" });
    this.pane.element.parentElement.style.left = "86px";
    this.pane.element.firstChild.style.fontWeight = "bold";
    this.makeDragable(this.pane);
  }
  addNumberMonitor(label, value, options) {
    this.numberMonitors[label] = value;
    this.params[label] = value();
    const opt = { interval: 250, readonly: true, label, format: (v) => v.toFixed(0) };
    if (options) Object.assign(opt, options);
    let target = this.pane;
    const group = options == null ? void 0 : options.group;
    if (group) {
      if (!this.folders[group]) {
        this.folders[group] = this.pane.addFolder({ title: group, expanded: false });
      }
      target = this.folders[group];
    }
    target.addBinding(this.params, label, opt);
  }
  setTitle(title) {
    this.pane.title = title;
  }
  dispose() {
    this.pane.dispose();
  }
  update(dt) {
    Object.entries(this.numberMonitors).forEach((pair) => {
      const label = pair[0];
      const value = pair[1];
      this.params[label] = value();
    });
    if (this.pane.expanded) {
      this.pane.element.parentElement.style.width = "280px";
      this.pane.element.style.backgroundColor = this.bgColorStyle.expanded;
      this.pane.element.firstChild.style.textShadow = "";
      this.pane.element.lastChild.style.backgroundColor = this.bgColorStyle.expanded;
    } else {
      this.pane.element.firstChild.style.textShadow = `0 0 #232323`;
      this.pane.element.style.backgroundColor = this.bgColorStyle.hidden;
      this.pane.element.parentElement.style.width = "160px";
    }
  }
  makeDragable(pane) {
    const draggableElement = pane.element.getElementsByTagName("button")[0];
    setTimeout(() => {
      const divs = draggableElement.getElementsByTagName("div");
      for (let i = 0; i < divs.length; i++) {
        const element = divs[i];
        element.style.pointerEvents = "none";
      }
    }, 10);
    let isDragging = false;
    let currentX = 0;
    let currentY = 0;
    let initialX = 0;
    let initialY = 0;
    let xOffset = 0;
    let yOffset = 0;
    const startPos = new framework_tiny_math_Vector2__WEBPACK_IMPORTED_MODULE_0__.Vector2();
    let startState = pane.expanded;
    function dragStart(e) {
      initialX = e.clientX - xOffset;
      initialY = e.clientY - yOffset;
      startPos.assign(e.clientX, e.clientY);
      if (e.target === draggableElement) {
        isDragging = true;
      }
      startState = pane.expanded;
    }
    function dragEnd(event) {
      initialX = currentX;
      initialY = currentY;
      isDragging = false;
      const pos = new framework_tiny_math_Vector2__WEBPACK_IMPORTED_MODULE_0__.Vector2(event.clientX, event.clientY);
      const moved = pos.distanceTo(startPos);
      if (moved >= 4) {
        pane.expanded = !startState;
      }
    }
    function setTranslate(xPos, yPos, el) {
      el.style.transform = `translate3d(${xPos}px, ${yPos}px, 0)`;
    }
    function drag(e) {
      if (isDragging) {
        e.preventDefault();
        currentX = e.clientX - initialX;
        currentY = e.clientY - initialY;
        xOffset = currentX;
        yOffset = currentY;
        setTranslate(currentX, currentY, pane.element.parentElement);
      }
    }
    draggableElement.addEventListener("mousedown", dragStart);
    draggableElement.addEventListener("touchstart", dragStart);
    draggableElement.addEventListener("mouseup", dragEnd);
    draggableElement.addEventListener("touchend", dragEnd);
    draggableElement.addEventListener("touchcancel", dragEnd);
    draggableElement.addEventListener("mousemove", drag);
    draggableElement.addEventListener("touchmove", drag);
  }
}


/***/ }),

/***/ "./src/framework/tiny/core/EventEmitter.ts":
/*!*************************************************!*\
  !*** ./src/framework/tiny/core/EventEmitter.ts ***!
  \*************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   EventEmitter: () => (/* binding */ EventEmitter)
/* harmony export */ });
/* harmony import */ var _HashObject__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./HashObject */ "./src/framework/tiny/core/HashObject.ts");

class EventEmitter extends _HashObject__WEBPACK_IMPORTED_MODULE_0__.HashObject {
  constructor() {
    super();
    this.$all = /* @__PURE__ */ new Map();
  }
  /**
   * 添加事件监听器
   *
   * @param {EventType} type 事件类型
   * @param {EventHandler} handler 事件回调
   * @param {boolean} [options] 派发一次事件后移除该事件
   * @returns 返回绑定的回调函数，可用于取消绑定
   * @memberof EventEmitter
   */
  on(type, handler, options) {
    const handlers = this.$all.get(type);
    const h = { handler, options };
    const added = handlers && handlers.push(h);
    if (!added) {
      this.$all.set(type, [h]);
    }
    return h.handler;
  }
  /**
   * 添加事件监听器, 事件派发后自动解绑
   *
   * @param {EventType} type 事件类型
   * @param {EventHandler} handler 事件回调
   * @param {boolean} [options] 派发一次事件后移除该事件
   * @returns 返回绑定的回调函数，可用于取消绑定
   * @returns EventEmitter
   */
  once(type, handler, options) {
    const opt = options || {};
    opt.once = true;
    return this.on(type, handler, opt);
  }
  /**
   * 转发事件
   * @param target 目标代理对象
   * @param type 时间类型
   * @param options 配置参数
   * @returns 返回代理回调，可用于取消转发
   */
  pipe(target, type, options) {
    if (target == this) return void 0;
    const callback = function() {
      target.emit.apply(target, [type, ...arguments]);
    };
    this.on(type, callback, options);
    return callback;
  }
  /**
   * 移除事件监听器
   *
   * @param {EventType} type 事件类型
   * @param {EventHandler} handler 要移除的回调
   * @memberof EventEmitter
   */
  off(type, handler) {
    const handlers = this.$all.get(type);
    if (handlers) {
      const h = handlers.find((h2) => h2.handler === handler);
      if (h) {
        handlers.splice(handlers.indexOf(h), 1);
      }
    }
  }
  /**
   * 移除特定类型是所有事件监听器
   *
   * @param {EventType} type 事件类型，传入`*`则清理所有类型的事件回调
   * @memberof EventEmitter
   */
  offAll(type) {
    if (type === "*") {
      this.$all.clear();
    } else {
      this.$all.delete(type);
    }
  }
  /**
   * 派发事件
   *
   * @param {EventType} type 事件类型
   * @param {...any[]} args 派发参数表
   * @memberof EventEmitter
   */
  emit(type, ...args) {
    const handlers = [];
    let blocking = false;
    for (const h of (this.$all.get(type) || []).slice()) {
      const currentBlocking = h.options && h.options.block;
      const currentOnce = h.options && h.options.once;
      if (!blocking) h.handler(...args);
      if (!currentOnce || blocking) handlers.push(h);
      blocking = blocking || currentBlocking;
    }
    this.$all.set(type, handlers);
  }
  /** 等待事件派发 */
  wait(event) {
    return new Promise((resolve, reject) => {
      this.on(event, (...args) => {
        resolve(args);
      }, { once: true });
    });
  }
  /** 销毁时解绑所有事件 */
  dispose() {
    this.$all.clear();
  }
}


/***/ }),

/***/ "./src/framework/tiny/core/HashObject.ts":
/*!***********************************************!*\
  !*** ./src/framework/tiny/core/HashObject.ts ***!
  \***********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   GenerateObjectHashCode: () => (/* binding */ GenerateObjectHashCode),
/* harmony export */   HashObject: () => (/* binding */ HashObject)
/* harmony export */ });
let $hashCount = 0;
function GenerateObjectHashCode() {
  return ++$hashCount;
}
class HashObject {
  constructor() {
    this.$hashCode = GenerateObjectHashCode();
  }
  get hashCode() {
    return this.$hashCode;
  }
}


/***/ }),

/***/ "./src/framework/tiny/core/TinyObject.ts":
/*!***********************************************!*\
  !*** ./src/framework/tiny/core/TinyObject.ts ***!
  \***********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   TinyObject: () => (/* binding */ TinyObject)
/* harmony export */ });
/* harmony import */ var _EventEmitter__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./EventEmitter */ "./src/framework/tiny/core/EventEmitter.ts");
/* harmony import */ var _HashObject__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./HashObject */ "./src/framework/tiny/core/HashObject.ts");


class TinyObject extends _HashObject__WEBPACK_IMPORTED_MODULE_1__.HashObject {
  constructor() {
    super(...arguments);
    /** 事件派发器 */
    this.event = new _EventEmitter__WEBPACK_IMPORTED_MODULE_0__.EventEmitter();
  }
  /** 执行清理/销毁操作，执行该操作之后不应再继续使用该对象 */
  dispose() {
    this.event.dispose();
  }
}


/***/ }),

/***/ "./src/framework/tiny/math/MathUtils.ts":
/*!**********************************************!*\
  !*** ./src/framework/tiny/math/MathUtils.ts ***!
  \**********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Axis: () => (/* binding */ Axis),
/* harmony export */   COMPARE_EPSILON: () => (/* binding */ COMPARE_EPSILON),
/* harmony export */   DEG2RAD: () => (/* binding */ DEG2RAD),
/* harmony export */   RAD2DEG: () => (/* binding */ RAD2DEG),
/* harmony export */   UNIT_EPSILON: () => (/* binding */ UNIT_EPSILON),
/* harmony export */   ceilPowerOfTwo: () => (/* binding */ ceilPowerOfTwo),
/* harmony export */   clamp: () => (/* binding */ clamp),
/* harmony export */   damp: () => (/* binding */ damp),
/* harmony export */   degToRad: () => (/* binding */ degToRad),
/* harmony export */   equalsApprox: () => (/* binding */ equalsApprox),
/* harmony export */   euclideanModulo: () => (/* binding */ euclideanModulo),
/* harmony export */   floorPowerOfTwo: () => (/* binding */ floorPowerOfTwo),
/* harmony export */   generateUUID: () => (/* binding */ generateUUID),
/* harmony export */   inverseLerp: () => (/* binding */ inverseLerp),
/* harmony export */   isPowerOfTwo: () => (/* binding */ isPowerOfTwo),
/* harmony export */   lerp: () => (/* binding */ lerp),
/* harmony export */   mapLinear: () => (/* binding */ mapLinear),
/* harmony export */   pingpong: () => (/* binding */ pingpong),
/* harmony export */   radToDeg: () => (/* binding */ radToDeg),
/* harmony export */   randFloat: () => (/* binding */ randFloat),
/* harmony export */   randFloatSpread: () => (/* binding */ randFloatSpread),
/* harmony export */   randInt: () => (/* binding */ randInt),
/* harmony export */   seededRandom: () => (/* binding */ seededRandom),
/* harmony export */   setQuaternionFromProperEuler: () => (/* binding */ setQuaternionFromProperEuler),
/* harmony export */   sign: () => (/* binding */ sign),
/* harmony export */   smootherstep: () => (/* binding */ smootherstep),
/* harmony export */   smoothstep: () => (/* binding */ smoothstep),
/* harmony export */   swap: () => (/* binding */ swap)
/* harmony export */ });
function sign(m_v) {
  return m_v < 0 ? -1 : 1;
}
function swap(m_a, m_b) {
  const temp = m_a.clone();
  m_a.assign(m_b);
  m_b.assign(temp);
}
function equalsApprox(a, b, tolerance = COMPARE_EPSILON) {
  if (a == b) return true;
  if (typeof a === "number" && typeof b === "number") {
    return Math.abs(a - b) < tolerance;
  }
  if (typeof a === "object" && typeof b === "object") {
    return a.equalsApprox(b);
  }
  return false;
}
var Axis = /* @__PURE__ */ ((Axis2) => {
  Axis2[Axis2["AXIS_X"] = 0] = "AXIS_X";
  Axis2[Axis2["AXIS_Y"] = 1] = "AXIS_Y";
  Axis2[Axis2["AXIS_Z"] = 2] = "AXIS_Z";
  Axis2[Axis2["AXIS_W"] = 3] = "AXIS_W";
  return Axis2;
})(Axis || {});
const DEG2RAD = Math.PI / 180;
const RAD2DEG = 180 / Math.PI;
const COMPARE_EPSILON = 1e-5;
const UNIT_EPSILON = 1e-3;
function clamp(value, min, max) {
  return Math.max(min, Math.min(max, value));
}
function euclideanModulo(n, m) {
  return (n % m + m) % m;
}
function mapLinear(x, a1, a2, b1, b2) {
  return b1 + (x - a1) * (b2 - b1) / (a2 - a1);
}
function lerp(x, y, t) {
  return (1 - t) * x + t * y;
}
function inverseLerp(x, y, value) {
  if (x !== y) {
    return (value - x) / (y - x);
  }
  return 0;
}
function damp(x, y, lambda, dt) {
  return lerp(x, y, 1 - Math.exp(-lambda * dt));
}
function pingpong(x, length = 1) {
  return length - Math.abs(euclideanModulo(x, length * 2) - length);
}
function smoothstep(x, min, max) {
  if (x <= min) return 0;
  if (x >= max) return 1;
  x = (x - min) / (max - min);
  return x * x * (3 - 2 * x);
}
function smootherstep(x, min, max) {
  if (x <= min) return 0;
  if (x >= max) return 1;
  x = (x - min) / (max - min);
  return x * x * x * (x * (x * 6 - 15) + 10);
}
function randInt(low, high) {
  return low + Math.floor(Math.random() * (high - low + 1));
}
function randFloat(low, high) {
  return low + Math.random() * (high - low);
}
function randFloatSpread(range) {
  return range * (0.5 - Math.random());
}
function seededRandom(s) {
  if (s !== void 0) _seed = s % 2147483647;
  _seed = _seed * 16807 % 2147483647;
  return (_seed - 1) / 2147483646;
}
let _seed = 1234567;
function degToRad(degrees) {
  return degrees * DEG2RAD;
}
function radToDeg(radians) {
  return radians * RAD2DEG;
}
function isPowerOfTwo(value) {
  return (value & value - 1) === 0 && value !== 0;
}
function ceilPowerOfTwo(value) {
  return Math.pow(2, Math.ceil(Math.log(value) / Math.LN2));
}
function floorPowerOfTwo(value) {
  return Math.pow(2, Math.floor(Math.log(value) / Math.LN2));
}
function setQuaternionFromProperEuler(q, a, b, c, order) {
  const cos = Math.cos;
  const sin = Math.sin;
  const c2 = cos(b / 2);
  const s2 = sin(b / 2);
  const c13 = cos((a + c) / 2);
  const s13 = sin((a + c) / 2);
  const $c13 = cos((a - c) / 2);
  const $s13 = sin((a - c) / 2);
  const $c31 = cos((c - a) / 2);
  const $s31 = sin((c - a) / 2);
  switch (order) {
    case "XYX":
      q.set(c2 * s13, s2 * $c13, s2 * $s13, c2 * c13);
      break;
    case "YZY":
      q.set(s2 * $s13, c2 * s13, s2 * $c13, c2 * c13);
      break;
    case "ZXZ":
      q.set(s2 * $c13, s2 * $s13, c2 * s13, c2 * c13);
      break;
    case "XZX":
      q.set(c2 * s13, s2 * $s31, s2 * $c31, c2 * c13);
      break;
    case "YXY":
      q.set(s2 * $c31, c2 * s13, s2 * $s31, c2 * c13);
      break;
    case "ZYZ":
      q.set(s2 * $s31, s2 * $c31, c2 * s13, c2 * c13);
      break;
    default:
      console.warn(`MathUtils: .setQuaternionFromProperEuler() encountered an unknown order: ${order}`);
      break;
  }
  return q;
}
function generateUUID() {
  if (!_lut.length) {
    for (let i = 0; i < 256; i++) {
      _lut[i] = (i < 16 ? "0" : "") + i.toString(16);
    }
  }
  const d0 = Math.random() * 4294967295 | 0;
  const d1 = Math.random() * 4294967295 | 0;
  const d2 = Math.random() * 4294967295 | 0;
  const d3 = Math.random() * 4294967295 | 0;
  const uuid = `${_lut[d0 & 255] + _lut[d0 >> 8 & 255] + _lut[d0 >> 16 & 255] + _lut[d0 >> 24 & 255]}-${_lut[d1 & 255]}${_lut[d1 >> 8 & 255]}-${_lut[d1 >> 16 & 15 | 64]}${_lut[d1 >> 24 & 255]}-${_lut[d2 & 63 | 128]}${_lut[d2 >> 8 & 255]}-${_lut[d2 >> 16 & 255]}${_lut[d2 >> 24 & 255]}${_lut[d3 & 255]}${_lut[d3 >> 8 & 255]}${_lut[d3 >> 16 & 255]}${_lut[d3 >> 24 & 255]}`;
  return uuid.toUpperCase();
}
const _lut = [];



/***/ }),

/***/ "./src/framework/tiny/math/Vector2.ts":
/*!********************************************!*\
  !*** ./src/framework/tiny/math/Vector2.ts ***!
  \********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Vector2: () => (/* binding */ Vector2)
/* harmony export */ });
/* harmony import */ var _MathUtils__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./MathUtils */ "./src/framework/tiny/math/MathUtils.ts");


const _Vector2 = class _Vector2 {
  constructor(x = 0, y) {
    this.x = 0;
    this.y = 0;
    this.copy = this.assign;
    /** @deprecated 使用 addAssign */
    this.add_assign = this.addAssign;
    /** @deprecated 使用 subtractAssign */
    this.subtract_assign = this.subtractAssign;
    /** @deprecated 使用 multiplyAssign */
    this.multiply_assign = this.multiplyAssign;
    /** @deprecated 使用 divideAssign */
    this.divide_assign = this.divideAssign;
    const len = arguments.length;
    if (len > 1) {
      this.set(x, y);
    } else if (len == 1 && typeof x === "object" && x !== null) {
      this.set(x.x, x.y);
    }
  }
  *[Symbol.iterator]() {
    yield this.x;
    yield this.y;
  }
  toString() {
    return `(${this.x},${this.y})`;
  }
  assign(src, y) {
    if (typeof src === "number") {
      return this.set(src, y);
    }
    return this.set(src.x, src.y);
  }
  get duplicated() {
    return new _Vector2(this);
  }
  clone() {
    return new _Vector2(this);
  }
  cloneTo(target) {
    target.x = this.x;
    target.y = this.y;
    return target;
  }
  set(x, y) {
    this.x = x;
    this.y = y;
    return this;
  }
  equals(v) {
    throw this.x === v.x && this.y === v.y;
  }
  equalsApprox(anothor) {
    return _MathUtils__WEBPACK_IMPORTED_MODULE_0__.equalsApprox(this.x, anothor.x) && _MathUtils__WEBPACK_IMPORTED_MODULE_0__.equalsApprox(this.y, anothor.y);
  }
  //#endregion
  //#region R/W
  /**
   * Sets this vector's x and y value from the provided array or array-like.
   * @param array the source array or array-like.
   * @param offset (optional) offset into the array. Default is 0.
   */
  fromArray(array, offset = 0) {
    this.x = array[offset];
    this.y = array[offset + 1];
    return this;
  }
  toArray(array = [], offset = 0) {
    array[offset] = this.x;
    array[offset + 1] = this.y;
    return array;
  }
  setComponent(axis, value) {
    switch (axis) {
      case _MathUtils__WEBPACK_IMPORTED_MODULE_0__.Axis.AXIS_X:
        this.x = value;
        break;
      case _MathUtils__WEBPACK_IMPORTED_MODULE_0__.Axis.AXIS_Y:
        this.y = value;
        break;
      default:
        throw new Error(`out of range: ${axis}`);
    }
    return this;
  }
  getComponent(axis) {
    switch (axis) {
      case _MathUtils__WEBPACK_IMPORTED_MODULE_0__.Axis.AXIS_X:
        return this.x;
      case _MathUtils__WEBPACK_IMPORTED_MODULE_0__.Axis.AXIS_Y:
        return this.y;
      default:
        throw new Error(`out of range: ${axis}`);
    }
  }
  //#endregion
  //#region properties
  /** 宽 */
  get width() {
    return this.x;
  }
  set width(v) {
    this.x = v;
  }
  /** 高 */
  get height() {
    return this.y;
  }
  set height(v) {
    this.y = v;
  }
  /** 面积 */
  get area() {
    return this.x * this.y;
  }
  /** 角度 */
  get angle() {
    return Math.atan2(this.y, this.x);
  }
  /** 长度 */
  get length() {
    return Math.sqrt(this.x * this.x + this.y * this.y);
  }
  /** Normalizes this vector and multiplies it by `length`. */
  setLength(length) {
    this.normalize();
    this.x *= length;
    this.y *= length;
    return this;
  }
  /** 长度的平方 */
  get lengthSquared() {
    return this.x * this.x + this.y * this.y;
  }
  /**
   * Computes the Manhattan length of this vector.
   *
   * see https://en.wikipedia.org/wiki/Taxicab_geometry
   */
  get manhattanLength() {
    return Math.abs(this.x) + Math.abs(this.y);
  }
  /** @see manhattanLength */
  get lengthManhattan() {
    return this.manhattanLength;
  }
  //#endregion
  //#region operator
  negate() {
    this.x = -this.x;
    this.y = -this.y;
    return this;
  }
  negated() {
    return this.clone().negate();
  }
  addAssign(v, y) {
    if (typeof v === "number") {
      this.x += v;
      this.y += y === void 0 ? v : y;
    } else if (typeof v === "object" && v !== void 0) {
      this.x += v.x;
      this.y += v.y;
    } else {
      throw new Error("Invalid parameter");
    }
    return this;
  }
  add(v, y) {
    return this.duplicated.addAssign(v, y);
  }
  subtractAssign(v, y) {
    if (typeof v === "number") {
      this.x -= v;
      this.y -= y === void 0 ? v : y;
    } else if (typeof v === "object" && v !== void 0) {
      this.x -= v.x;
      this.y -= v.y;
    } else {
      throw new Error("Invalid parameter");
    }
    return this;
  }
  subtract(v, y) {
    return this.duplicated.subtractAssign(v, y);
  }
  multiplyAssign(v, y) {
    if (typeof v === "number") {
      this.x *= v;
      this.y *= typeof y === "number" ? y : v;
    } else if (typeof v === "object" && v !== void 0) {
      this.x *= v.x;
      this.y *= v.y;
    } else {
      throw new Error("Invalid parameter");
    }
    return this;
  }
  multiply(v, y) {
    return this.duplicated.multiplyAssign(v, y);
  }
  divideAssign(v, y) {
    if (typeof v === "number") {
      this.x /= v;
      this.y /= typeof y === "number" ? y : v;
    } else if (typeof v === "object" && v !== void 0) {
      this.x /= v.x;
      this.y /= v.y;
    } else {
      throw new Error("Invalid parameter");
    }
    return this;
  }
  divide(v, y) {
    return this.duplicated.divideAssign(v, y);
  }
  min(v) {
    return new _Vector2(Math.min(this.x, v.x), Math.min(this.y, v.y));
  }
  max(v) {
    return new _Vector2(Math.max(this.x, v.x), Math.max(this.y, v.y));
  }
  clamp(min, max) {
    if (typeof min === "number") {
      const x2 = Math.max(min, Math.min(max, this.x));
      const y2 = Math.max(min, Math.min(max, this.y));
      return new _Vector2(x2, y2);
    }
    const x = Math.max(min.x, Math.min(max.x, this.x));
    const y = Math.max(min.y, Math.min(max.y, this.y));
    return new _Vector2(x, y);
  }
  cross(v) {
    return this.x * v.y - this.y * v.x;
  }
  dot(v) {
    return this.x * v.x + this.y * v.y;
  }
  sign() {
    return new _Vector2(_MathUtils__WEBPACK_IMPORTED_MODULE_0__.sign(this.x), _MathUtils__WEBPACK_IMPORTED_MODULE_0__.sign(this.y));
  }
  floor() {
    return new _Vector2(Math.floor(this.x), Math.floor(this.y));
  }
  ceil() {
    return new _Vector2(Math.ceil(this.x), Math.ceil(this.y));
  }
  round() {
    return new _Vector2(Math.round(this.x), Math.round(this.y));
  }
  abs() {
    return new _Vector2(Math.abs(this.x), Math.abs(this.y));
  }
  normalize() {
    let l = this.x * this.x + this.y * this.y;
    if (l != 0) {
      l = Math.sqrt(l);
      this.x /= l;
      this.y /= l;
    }
    return this;
  }
  normalized() {
    return this.duplicated.normalize();
  }
  get isNormalized() {
    return _MathUtils__WEBPACK_IMPORTED_MODULE_0__.equalsApprox(this.lengthSquared, 1, _MathUtils__WEBPACK_IMPORTED_MODULE_0__.UNIT_EPSILON);
  }
  lerpAssign(v, alpha) {
    this.x += (v.x - this.x) * alpha;
    this.y += (v.y - this.y) * alpha;
    return this;
  }
  lerp(v, alpha) {
    return this.duplicated.lerpAssign(v, alpha);
  }
  rotate(angle) {
    const sine = Math.sin(angle);
    const cosi = Math.cos(angle);
    return this.set(this.x * cosi - this.y * sine, this.x * sine + this.y * cosi);
  }
  rotated(angle) {
    return this.duplicated.rotate(angle);
  }
  static random() {
    return new _Vector2(Math.random(), Math.random());
  }
  rotateAround(center, angle) {
    const c = Math.cos(angle), s = Math.sin(angle);
    const x = this.x - center.x;
    const y = this.y - center.y;
    return this.set(x * c - y * s + center.x, x * s + y * c + center.y);
  }
  project(to) {
    const d = this.dot(to) / (to.x * to.x + to.y * to.y);
    return new _Vector2(to).multiplyAssign(d);
  }
  reflect(normal) {
    const n = new _Vector2(normal).normalize();
    return n.multiplyAssign(this.dot(n)).multiplyAssign(2).subtractAssign(this);
  }
  bounce(normal) {
    return this.reflect(normal).negate();
  }
  slide(normal) {
    const n = new _Vector2(normal).normalize();
    return this.subtract(n.multiplyAssign(this.dot(n)));
  }
  moveToward(to, delta) {
    const end = new _Vector2(to);
    const vd = end.subtract(this);
    const len = vd.length;
    if (len <= delta || len < _MathUtils__WEBPACK_IMPORTED_MODULE_0__.COMPARE_EPSILON) {
      return end;
    }
    return this.add(vd.divide(len * delta));
  }
  //#endregion
  distanceTo(v) {
    return Math.sqrt(this.distanceToSquared(v));
  }
  distanceToSquared(v) {
    const dx = this.x - v.x, dy = this.y - v.y;
    return dx * dx + dy * dy;
  }
  manhattanDistanceTo(v) {
    return Math.abs(this.x - v.x) + Math.abs(this.y - v.y);
  }
};
_Vector2.ONE = new _Vector2(1, 1);
_Vector2.ZERO = new _Vector2(0, 0);
_Vector2.UP = new _Vector2(0, 1);
_Vector2.DOWN = new _Vector2(0, -1);
_Vector2.LEFT = new _Vector2(-1, 0);
_Vector2.RIGHT = new _Vector2(1, 0);
let Vector2 = _Vector2;


/***/ }),

/***/ "./src/framework/tiny/utils/Frequency.ts":
/*!***********************************************!*\
  !*** ./src/framework/tiny/utils/Frequency.ts ***!
  \***********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Frequency: () => (/* binding */ Frequency)
/* harmony export */ });
/* harmony import */ var _core_TinyObject__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../core/TinyObject */ "./src/framework/tiny/core/TinyObject.ts");

class Frequency extends _core_TinyObject__WEBPACK_IMPORTED_MODULE_0__.TinyObject {
  /**
   * @param frequency 频率，如 30 表示 30Hz
   */
  constructor(frequency = 30) {
    super();
    this._tickDuration = 0;
    this._lastTickDuration = 0;
    this.frequency = frequency;
  }
  /** 频率（每秒多少次） */
  get frequency() {
    return this._frequency;
  }
  set frequency(v) {
    this._frequency = v;
    this._tickMaxDuration = 1 / v || 0;
  }
  /** 时间间隔（多少秒一次） */
  set interval(v) {
    this._frequency = 1 / (v || 60);
    this._tickMaxDuration = v || 0;
  }
  /** 设置下一次的时间 */
  set next(v) {
    this._tickDuration = this._tickMaxDuration - v;
  }
  /** 获取下一次tick的时间间隔 */
  get next() {
    return this._tickMaxDuration - this._tickDuration;
  }
  /** 获取上一次 tick 通过至今的时间 */
  get delta() {
    return this._lastTickDuration;
  }
  /**
   * 时间迭代，返回 `true` 时表示需要自行更新
   * @param delta 与上一次迭代的时间长度
   */
  tick(delta) {
    this._tickDuration += delta;
    if (this._tickDuration >= this._tickMaxDuration) {
      this._lastTickDuration = this._tickDuration;
      this._tickDuration = 0;
      return true;
    }
    return false;
  }
}


/***/ })

/******/ 	});
/************************************************************************/
/******/ 	// The module cache
/******/ 	var __webpack_module_cache__ = {};
/******/ 	
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/ 		// Check if module is in cache
/******/ 		var cachedModule = __webpack_module_cache__[moduleId];
/******/ 		if (cachedModule !== undefined) {
/******/ 			return cachedModule.exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = __webpack_module_cache__[moduleId] = {
/******/ 			// no module.id needed
/******/ 			// no module.loaded needed
/******/ 			exports: {}
/******/ 		};
/******/ 	
/******/ 		// Execute the module function
/******/ 		__webpack_modules__[moduleId](module, module.exports, __webpack_require__);
/******/ 	
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/ 	
/************************************************************************/
/******/ 	/* webpack/runtime/define property getters */
/******/ 	(() => {
/******/ 		// define getter functions for harmony exports
/******/ 		__webpack_require__.d = (exports, definition) => {
/******/ 			for(var key in definition) {
/******/ 				if(__webpack_require__.o(definition, key) && !__webpack_require__.o(exports, key)) {
/******/ 					Object.defineProperty(exports, key, { enumerable: true, get: definition[key] });
/******/ 				}
/******/ 			}
/******/ 		};
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/hasOwnProperty shorthand */
/******/ 	(() => {
/******/ 		__webpack_require__.o = (obj, prop) => (Object.prototype.hasOwnProperty.call(obj, prop))
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/make namespace object */
/******/ 	(() => {
/******/ 		// define __esModule on exports
/******/ 		__webpack_require__.r = (exports) => {
/******/ 			if(typeof Symbol !== 'undefined' && Symbol.toStringTag) {
/******/ 				Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });
/******/ 			}
/******/ 			Object.defineProperty(exports, '__esModule', { value: true });
/******/ 		};
/******/ 	})();
/******/ 	
/************************************************************************/
var __webpack_exports__ = {};
// This entry needs to be wrapped in an IIFE because it needs to be in strict mode.
(() => {
"use strict";
/*!*********************************************!*\
  !*** ./src/adaptor/laya/StatUI.laya.web.ts ***!
  \*********************************************/
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var filesize__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! filesize */ "./node_modules/filesize/dist/filesize.esm.js");
/* harmony import */ var framework_platform_web_status__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! framework/platform/web/status */ "./src/framework/platform/web/status.ts");
var __async = (__this, __arguments, generator) => {
  return new Promise((resolve, reject) => {
    var fulfilled = (value) => {
      try {
        step(generator.next(value));
      } catch (e) {
        reject(e);
      }
    };
    var rejected = (value) => {
      try {
        step(generator.throw(value));
      } catch (e) {
        reject(e);
      }
    };
    var step = (x) => x.done ? resolve(x.value) : Promise.resolve(x.value).then(fulfilled, rejected);
    step((generator = generator.apply(__this, __arguments)).next());
  });
};


const SPECTOR = __webpack_require__(/*! spectorjs */ "./node_modules/spectorjs/dist/spector.bundle.js");
class TinyStatUI {
  constructor() {
    this.params = {
      totalJSHeapSize: 0,
      usedJSHeapSize: 0
    };
    this._view = [];
    this.getStatistic = (type) => Laya.LayaGL.renderEngine.getStatisticsInfo(type);
    this.ExtralStats = {
      // cpuMemory: { title: "CPUMemory", value: "cpuMemory", color: "white", units: "M", mode: "summit" },
      meshRenderNode: { title: "MeshRender", value: "meshRenderNode", color: "white", units: "int", mode: "summit" },
      totalJSHeapSize: { title: "Heap Size", value: "totalJSHeapSize", color: "white", units: "M", mode: "summit" },
      usedJSHeapSize: { title: "Heap Used", value: "usedJSHeapSize", color: "white", units: "M", mode: "summit" }
      // jsHeapSizeLimit: { title: "Heap Limit", valu