(function () {
    let config = JSON.parse(`{"resolution":{"designWidth":828,"designHeight":1656,"scaleMode":"fixedauto","backgroundColor":"#3d404a","alignV":"top","alignH":"left","screenMode":"none"},"2D":{"useRetinalCanvas":true,"defaultFont":"ArialMT","defaultFontSize":36,"FPS":60,"isAntialias":true,"isAlpha":false,"enableUniformBufferObject":true,"matUseUBO":true,"webGL2D_MeshAllocMaxMem":true},"3D":{"defaultPhysicsMemory":32,"maxLightCount":16,"enableDynamicBatch":true,"pixelRatio":1,"enableMultiLight":true,"lightClusterCount":{"x":12,"y":12,"z":12},"maxMorphTargetCount":32},"UI":{"alwaysIncludeDefaultSkin":false,"horizontalScrollBar":"","verticalScrollBar":"","popupMenu":"","tooltipsWidget":"","defaultTooltipsShowDelay":100,"defaultComboBoxVisibleItemCount":20},"addons":{"laya.ui":"both"},"physics3dModule":"laya.bullet.wasm","physics2dModule":"laya.box2D.wasm","splash":{"enabled":false,"backgroundColor":"#ffffff","fit":"center","duration":0.6,"enabledInPreview":true},"stat":true,"light2D":{"lightDirection":{"x":-1,"y":0,"z":1},"ambientColor":{"r":0.2,"g":0.2,"b":0.2,"a":0},"ambientLayerMask":-1,"multiSamples":4},"physics2D":{"allowSleeping":true,"gravity":{"x":0,"y":9.8},"velocityIterations":8,"positionIterations":3,"pixelRatio":50,"debugDraw":false,"drawShape":true,"drawJoint":true,"drawAABB":false,"drawCenterOfMass":false,"layers":["Default"],"defaultConfig":{"allowSleeping":false,"gravity":{"x":0,"y":9.8},"velocityIterations":8,"positionIterations":3,"pixelRatio":50,"debugDraw":true,"drawShape":true,"drawJoint":true,"drawAABB":false,"drawCenterOfMass":false}},"physics3D":{"fixedTimeStep":0.016666666666666666,"maxSubSteps":1,"enableCCD":false,"ccdThreshold":0.0001,"ccdSphereRadius":0.0001,"layers":["Default"]},"spineVersion":"3.8","vConsole":false,"alertGlobalError":false,"startupScene":"main.ls","useSafeFileExtensions":true,"pkgs":[{"path":"","autoLoad":true}]}`);
    Object.assign(Laya.PlayerConfig, config);
    Object.assign(Laya.Config, config["2D"]);
    Object.assign(Laya.Config3D, config["3D"]);
    if (Laya.UIConfig2)
        Object.assign(Laya.UIConfig2, config["UI"]);

    let v3 = Laya.Config3D.lightClusterCount;
    Laya.Config3D.lightClusterCount = new Laya.Vector3(v3.x, v3.y, v3.z);

    if (typeof (window) === "undefined")
        window = {};

    if (config.useSafeFileExtensions)
        Laya.URL.initMiniGameExtensionOverrides();

    let pkgs = [];
    for (let pkg of config.pkgs) {
        let path = pkg.path.length > 0 ? (pkg.path + "/") : pkg.path;
        if (pkg.hash)
            Laya.URL.version[path + "fileconfig.json"] = pkg.hash;
        if (pkg.remoteUrl) {
            let remoteUrl = pkg.remoteUrl.endsWith("/") ? pkg.remoteUrl : (pkg.remoteUrl + "/");
            if (path.length > 0)
                Laya.URL.basePaths[path] = remoteUrl;
            else
                Laya.URL.basePath = remoteUrl;
        }

        if (pkg.autoLoad)
            pkgs.push(pkg);
    }

    Laya.init(config.resolution).then(() => {
        if (config.vConsole && (Laya.Browser.onMobile || Laya.Browser.onIPad) && !Laya.LayaEnv.isConch) {
            let script = document.createElement("script");
            script.src = "js/vConsole.min.js";
            script.onload = () => {
                window.vConsole = new VConsole();
            };
            document.body.appendChild(script);
        }

        if (config.alertGlobalError)
            Laya.alertGlobalError(true);
        if (config.stat)
            Laya.Stat.show();

        return Promise.all(pkgs.map(pkg => Laya.loader.loadPackage(pkg.path, pkg.remoteUrl)));
    }).then(() => {
        return Laya.Laya._invokeReadyCallbacks();
    }).then(() => {
        if (window.$_main_)
            return window.$_main_();
        else if (config.startupScene) {
            return Laya.Scene.open(config.startupScene, true, null, null, Laya.Handler.create(null, (progress) => {
                if (window.onSplashProgress)
                    window.onSplashProgress(progress);
            }, null, false));
        }
    }).then(() => {
        if (window.hideSplashScreen)
            window.hideSplashScreen();
    });
})();
